/* Battle.net Version Check Source Code  YobGuls (yobguls@yobguls.2ndmail.com) 2001
 * This is the equivalent of the CheckVersion() function that appears
 * in the IX86VER?.DLL files that are used as part of the Battle.net
 * connection procedure
 * Thanks a lot to Onlyer (onlyer@263.net) for explaining the basic
 * parts of this function to me, it made it a lot easier
 * Also, Skywing provided the additional checksum keys for certain DLLs */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

/* These are special keys that vary depending upon which DLL it is that you're using
 * They're used to initialize the first variable (A) as part of the checksum algorithm */
/* Thanks to Skywing for the additional checksum keys */

DWORD dwMpqChecksumKeys[] =
{ 0xE7F4CB62lu, 0xF6A14FFClu, 0xAA5504AFlu, 0x871FCDC2lu, 0x11BF6A18lu, 0xC57292E6lu,
  0x7927D27Elu, 0x2FEC8733lu };

/* CheckRevision function
 * This function takes in three file names and a versioning string.  The file names refer
 * to the main EXE and DLL files that are used by the game.  Usually this includes the game's
 * main EXE file (like Starcraft.exe) and the Battle.net client DLL (Battle.snp for Starcraft
 * or Bnclient.dll for Diablo 2).  In the actual DLLs, the first argument is ignored and
 * GetModuleFileName(NULL) is used instead.  The versioning string is a list of random
 * variables and operations that tell how the checksum is performed.
 * The function will write two 32-bit DWORDs as output.  The first is the version information
 * taken from the actual resource in the main EXE file.  The second is the result of the
 * checksum function. */
/* NOTE:  I added the MPQ file name argument, it's not in the real function of course.  Set
 * that to the file that Battle.net specifies in the connection, like "IX86VER0.MPQ".  You
 * don't actually have to download this file, the algorithm is all in here. */

__declspec(dllexport)
BOOL __stdcall CheckRevision(LPCTSTR lpszFileName1, LPCTSTR lpszFileName2,
                   LPCTSTR lpszFileName3, LPCTSTR lpszValueString,
                   DWORD * lpdwVersion, DWORD * lpdwChecksum,
                   LPSTR lpExeInfoString, LPCTSTR lpszMpqFileName)
{
   HANDLE hFile, hFileMapping;
   char * s, lpszFileName[256], cOperations[16];
   int nHashFile, nVariable1[16], nVariable2[16], nVariable3[16], nVariable,
       i, k, nHashOperations;
   DWORD dwTotalSize, dwSize, j, dwBytesRead, dwVariables[4], dwMpqKey,
         * lpdwBuffer;
   LPSTR lpszFileNames[3];
   FILETIME ft;
   SYSTEMTIME st;
   LPBYTE lpbBuffer;
   VS_FIXEDFILEINFO * ffi;

   s = strchr((char *) lpszMpqFileName, '.');
   if (s == NULL)
      return FALSE;
   nHashFile = (int) (*(s - 1) - '0');
   if (nHashFile > 7 || nHashFile < 0)
      return FALSE;
   dwMpqKey = dwMpqChecksumKeys[nHashFile];
   lpszFileNames[0] = (LPSTR) lpszFileName1;
   lpszFileNames[1] = (LPSTR) lpszFileName2;
   lpszFileNames[2] = (LPSTR) lpszFileName3;
   s = (char *) lpszValueString;
   while (*s != '\0')
   {
      if (isalpha(*s))
         nVariable = (int) (toupper(*s) - 'A');
      else
      {
         nHashOperations = (int) (*s - '0');
         s = strchr(s, ' ');
         if (s == NULL)
            return FALSE;
         s++;
         break;
      }
      if (*(++s) == '=')
         s++;
      dwVariables[nVariable] = atol(s);
      s = strchr(s, ' ');
      if (s == NULL)
         return FALSE;
      s++;
   }
   for (i = 0; i < nHashOperations; i++)
   {
      if (!isalpha(*s))
         return FALSE;
      nVariable1[i] = (int) (toupper(*s) - 'A');
      if (*(++s) == '=')
         s++;
      if (toupper(*s) == 'S')
         nVariable2[i] = 3;
      else
         nVariable2[i] = (int) (toupper(*s) - 'A');
      cOperations[i] = *(++s);
      s++;
      if (toupper(*s) == 'S')
         nVariable3[i] = 3;
      else
         nVariable3[i] = (int) (toupper(*s) - 'A');
      s = strchr(s, ' ');
      if (s == NULL)
         break;
      s++;
   }
   dwVariables[0] ^= dwMpqKey;
   for (i = 0; i < 3; i++)
   {
      if (lpszFileNames[i][0] == '\0')
         continue;
      hFile = CreateFile(lpszFileNames[i],
                         GENERIC_READ,
                         FILE_SHARE_READ,
                         NULL,
                         OPEN_EXISTING,
                         FILE_ATTRIBUTE_NORMAL,
                         NULL);
      if (hFile == (HANDLE) INVALID_HANDLE_VALUE)
         return FALSE;
      hFileMapping = CreateFileMapping(hFile, NULL, PAGE_READONLY, 0, 0, NULL);
      if (hFileMapping == NULL)
      {
         CloseHandle(hFile);
         return FALSE;
      }
      lpdwBuffer = (LPDWORD) MapViewOfFile(hFileMapping, FILE_MAP_READ, 0, 0, 0);
      if (lpdwBuffer == NULL)
      {
         CloseHandle(hFileMapping);
         CloseHandle(hFile);
         return FALSE;
      }
      if (i == 0)
      {
         GetFileTime(hFile, NULL, NULL, &ft);
         FileTimeToSystemTime(&ft, &st);
         dwTotalSize = GetFileSize(hFile, NULL);
      }
      dwSize = (GetFileSize(hFile, NULL) / 1024lu) * 1024lu;
      for (j = 0; j < (dwSize / 4lu); j++)
      {
         dwVariables[3] = lpdwBuffer[j];
         for (k = 0; k < nHashOperations; k++)
         {
            switch (cOperations[k])
            {
               case '+':
                  dwVariables[nVariable1[k]] = dwVariables[nVariable2[k]] +
                                               dwVariables[nVariable3[k]];
                  break;
               case '-':
                  dwVariables[nVariable1[k]] = dwVariables[nVariable2[k]] -
                                               dwVariables[nVariable3[k]];
                  break;
               case '^':
                  dwVariables[nVariable1[k]] = dwVariables[nVariable2[k]] ^
                                               dwVariables[nVariable3[k]];
                  break;
               default:
                  return FALSE;
            }
         }
      }
      UnmapViewOfFile(lpdwBuffer);
      CloseHandle(hFileMapping);
      CloseHandle(hFile);
   }
   strcpy(lpszFileName, lpszFileName1);
   dwSize = GetFileVersionInfoSize(lpszFileName, &dwBytesRead);
   lpbBuffer = (LPBYTE) VirtualAlloc(NULL, dwSize, MEM_COMMIT,
                                     PAGE_READWRITE);
   if (lpbBuffer == NULL)
      return FALSE;
   if (GetFileVersionInfo(lpszFileName, NULL, dwSize, lpbBuffer) == FALSE)
      return FALSE;
   if (VerQueryValue(lpbBuffer, "\\", (LPVOID *) &ffi, (PUINT) &dwSize) == FALSE)
      return FALSE;
   *lpdwVersion = ((HIWORD(ffi->dwProductVersionMS) & 0xFF) << 24) |
                  ((LOWORD(ffi->dwProductVersionMS) & 0xFF) << 16) |
                  ((HIWORD(ffi->dwProductVersionLS) & 0xFF) << 8) |
                  (LOWORD(ffi->dwProductVersionLS) & 0xFF);
   VirtualFree(lpbBuffer, 0lu, MEM_RELEASE);
   s = (char *) &lpszFileName[strlen(lpszFileName)-1];
   while (*s != '\\' && s > (char *) lpszFileName)
      s--;
   s++;
   sprintf(lpExeInfoString,
           "%s %02u/%02u/%02u %02u:%02u:%02u %lu",
           s,
           st.wMonth,
           st.wDay,
           st.wYear % 100,
           st.wHour,
           st.wMinute,
           st.wSecond,
           dwTotalSize);
   *lpdwChecksum = dwVariables[2];
   return TRUE;
}

__declspec(dllexport)
void __stdcall datahash(unsigned long*param)
{
	unsigned long buf[0x50];
	unsigned long dw, a, b, c, d, e, *p;
	int i;
	memcpy(buf, param+5, 0x40);
	for(i=0x10; i<0x50; i++) 
	{
		dw = buf[i-0x10]^buf[i-0x8]^buf[i-0xe]^buf[i-0x3];
		buf[i] = (1>>(0x20-(unsigned char)dw)) | (1<<(unsigned char)dw);		
	}
	a = param[0];	// edi
	b = param[1];	// eax
	c = param[2];	// esi
	d = param[3];	// edx
	e = param[4];	// [+18], ebx
	p = buf;		// [+14]
	i = 0x14;		// [+10]
	do 
	{
		dw = ((a<<5) | (a>>0x1b)) + ((~b & d) | (c & b)) + e + *p++ + 0x5A827999; // ecx
		e = d;
		d = c;
		c = (b>>2)  | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	i = 0x14;		// [+14]
	do 
	{
		dw = (d ^ c ^ b) + e + ((a<<5) | (a>>0x1b)) + *p++ + 0x6ED9EBA1; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	i = 0x14;
	do 
	{
		dw = ((c & b) | (d & c) | (d & b)) + e + ((a<<5) | (a>>0x1b)) + *p++ - 0x70E44324; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);

	i = 0x14;
	do 
	{
		dw = ((a<<5) | (a>>0x1b)) + e + (d ^ c ^ b) + *p++ - 0x359D3E2A; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	param[0] += a;
	param[1] += b;
	param[2] += c;
	param[3] += d;
	param[4] += e;

}

__declspec(dllexport)
void __stdcall calchashbuf(unsigned long *hash, void *inbuf, int len)
{
	char *buf = (char*)inbuf;
	int pos;
	int sublen;
	unsigned long hashbuf[0x10 + 5];
	hashbuf[0] = 0x67452301;
	hashbuf[1] = 0xEFCDAB89;
	hashbuf[2] = 0x98BADCFE;
	hashbuf[3] = 0x10325476;
	hashbuf[4] = 0xC3D2E1F0;
	for(pos=0; pos<len; pos+=0x40) {
		sublen = len - pos;
		if(sublen > 0x40)
			sublen = 0x40;
		memcpy(hashbuf+5, buf+pos, sublen);
		if(sublen<0x40)
			ZeroMemory((char*)(hashbuf+5)+sublen, 0x40-sublen);
		datahash(hashbuf);
	}
	memcpy(hash, hashbuf, 5*4);
}

__declspec(dllexport)
void __stdcall CreatePasswordHash(char *OutBuf, DWORD encryptvalue, char *password, char *username)
{
	DWORD passwordhash[7];
	passwordhash[0] = GetTickCount();
	passwordhash[1] = encryptvalue;
	calchashbuf(passwordhash+2, password, strlen(password));
	calchashbuf(passwordhash+2, passwordhash, 7*4);
	memcpy(OutBuf, passwordhash, 7*4);
	memcpy(OutBuf + (7*4), username, strlen(username));
}
