Attribute VB_Name = "BinaryUtil"
' CheckRevision.dll calling example and
' numeric to string conversion routines
'
' By SubSpace, 2001-06-13
' Thanks to YobGuls for the original ChechRevision.dll
' source
'
' Revision 1:
' The storm.dll and battle.snp parameters were switched,
' thus the function returned incorrect results. Fixed

Declare Function CheckRevision Lib "CheckRevision.dll" Alias "_CheckRevision@32" (ByVal FileExe As String, ByVal FileStormDll As String, ByVal FileBnetDll As String, ByVal HashText As String, ByRef Version As Long, ByRef Checksum As Long, ByVal ExeInfo As String, ByVal MpqName As String) As Long
Declare Sub CopyMemory Lib "Kernel32" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal numbytes As Long)

Const StarcraftPath = "D:\SPEL\Starcraft\"

Sub Example()
    Dim Version As Long
    Dim Checksum As Long
    Dim ExeInfo As String
    Dim Result As Long
    
    ExeInfo = Space(256)
    R = CheckRevision(StarcraftPath & "Starcraft.exe", StarcraftPath & "storm.dll", StarcraftPath & "battle.snp", "A=2197462687 B=3371463791 C=3659979230 4 A=A^S B=B-C C=C^A A=A+B", Version, Checksum, ExeInfo, "IX86ver4.mpq")
    NullTruncString ExeInfo
    
    Dim PacketData As String
    
    PacketData = "68XIRATS" & Chr(&HC3) & _
                    MKI(0) & MKL(Version) & MKL(Checksum) & ExeInfo & Chr(0)
                    
    MsgBox HexDump(PacketData)
End Sub


' Converts a Long value to a 4 byte string
' representing the number
Function MKL(Value As Long) As String
    Dim Result As String * 4
    
    CopyMemory ByVal Result, Value, 4
    MKL = Result
End Function

' Converts an Integer value to a 2 byte string
' representing the number
Function MKI(Value As Integer) As String
    Dim Result As String * 2
    
    CopyMemory ByVal Result, Value, 2
    MKI = Result
End Function

' Converts a string to a Long
Function CVL(x As String) As Long
    If Len(x) < 4 Then
        MsgBox "CVL(): String too short"
        Stop
    End If
    CopyMemory CVL, ByVal x, 4
End Function


' Converts a string to an Integer
Function CVI(x As String) As Integer
    If Len(x) < 2 Then
        MsgBox "CVI(): String too short"
        Stop
    End If
    
    CopyMemory CVI, ByVal x, 2
End Function

' Converts a string to a Hex representation of the
' string: "AB" -> "41 42"
Function HexDump(Text As String)
    Dim I As Integer
    Dim S As String
    
    For I = 1 To Len(Text)
        S = Hex(Asc(Mid(Text, I, 1)))
        If Len(S) < 2 Then S = String(2 - Len(S), "0") & S
        
        HexDump = HexDump & S & " "
    Next
End Function

' Truncated a BASIC String at the first NULL
' character
Sub NullTruncString(ByRef Text As String)
    Dim I As Integer
    
    I = InStr(Text, Chr(0))
    If I = 0 Then Exit Sub
    
    Text = Left(Text, I - 1)
End Sub

