/*****************************************************************************/
/* Storm.h                           Copyright Justin Olbrantz(Quantam) 2000 */
/*                                                                           */
/* Storm Interface Library v1.0 for Windows                                  */
/*                                                                           */
/* Author : Justin Olbrantz(Quantam)                                         */
/* E-mail : omega@dragonfire.net                                             */
/* WWW    : www.campaigncreations.com/starcraft/mpq2k/inside_mopaq/          */
/*---------------------------------------------------------------------------*/
/*                Function prototypes for use with Storm.dll                 */
/*---------------------------------------------------------------------------*/
/*          !This file requires the Storm.lib and Storm.exp files!           */
/*****************************************************************************/

#ifndef STORM_H
#define STORM_H

//We need the Windows data types for the Storm prototypes
#include <windows.h>

//Just in case anyone is still using C out there
#ifdef __cplusplus
extern "C" {
#endif
	//Storm prototypes
	BOOL WINAPI SFileOpenArchive(LPCSTR lpFileName, DWORD dwMPQID, DWORD dwUnknown, HANDLE *lphMPQ);
	BOOL WINAPI SFileCloseArchive(HANDLE hMPQ);
	BOOL WINAPI SFileOpenFileEx(HANDLE hMPQ, LPCSTR lpFileName, DWORD dwSearchScope, HANDLE *lphFile);
	BOOL WINAPI SFileCloseFile(HANDLE hFile);
	BOOL WINAPI SFileReadFile(HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped);
	DWORD WINAPI SFileGetFileSize(HANDLE hFile, LPDWORD lpdwFileSizeHigh);
	DWORD WINAPI SFileSetFilePointer(HANDLE hFile, long nDistanceToMove, DWORD dwUnused, DWORD dwMoveMethod);
	LCID WINAPI SFileSetLocale(LCID lcNewLocale);
#ifdef __cplusplus
}
#endif

#endif //#ifndef STORM_H