#ifndef CONSOLEOUTPUT_H
#define CONSOLEOUTPUT_H

#include <windows.h>
#include <stdio.h>

class ConsoleOutput {
public:
	ConsoleOutput(CRITICAL_SECTION *_Synchronize, bool createscreenbuffer = false, const char *_log = 0);
	~ConsoleOutput();
	DWORD WriteEx(char color, const char *format, ...);
	void SetTitle(const char *title);
	char *GetTitle(char *buffer, DWORD size = 1024);
	void Activate(void);
	HWND GetWindow(void);
	void SetLog(const char *_log);
	enum {
		WHITE = 0,
		GRAY = 1,
		BLUE = 2,
		GREEN = 3,
		RED = 4,
		YELLOW = 5,
		PURPLE = 6,
		BLUEGREEN = 7,
		MIDBLUE = 8,
		DARKBLUE = 9,
		DARKGREEN = 10,
		DARKYELLOW = 11,
		DARKRED = 12,
		DARKPURPLE = 13
	};
private:
	DWORD Write(const char *format, va_list argptr);
	void WriteLog(const char *format, va_list argptr);
	void SetColor(char color);
	HANDLE output;
	CRITICAL_SECTION *Synchronize;
	bool createdscreenbuffer;
	char *log;
};

#endif
