#include "ConsoleOutput.h"

ConsoleOutput::ConsoleOutput(CRITICAL_SECTION *_Synchronize, bool createscreenbuffer, const char *_log) {
#ifndef GENERAL_RELEASE
	if(createscreenbuffer == false) {
		AllocConsole();
		output = GetStdHandle(STD_OUTPUT_HANDLE);
	} else {
		output = CreateConsoleScreenBuffer(GENERIC_READ | GENERIC_WRITE, 0, 0, CONSOLE_TEXTMODE_BUFFER, 0);
	}
	createdscreenbuffer = createscreenbuffer;
	Synchronize = _Synchronize;
	CONSOLE_SCREEN_BUFFER_INFO csbi;
	COORD coo;
	GetConsoleScreenBufferInfo(output, &csbi);
	coo = csbi.dwSize;
	coo.Y = 500;
	SetConsoleScreenBufferSize(output, coo);
	if(_log) {
		log = new char[strlen(_log) + 1];
		strcpy(log, _log);
	} else {
		log = 0;
	}
#endif
}

ConsoleOutput::~ConsoleOutput() {
#ifndef GENERAL_RELEASE
	EnterCriticalSection(Synchronize);
	if(log)
		delete [] log;
	if(createdscreenbuffer == false)
		FreeConsole();
	else
		CloseHandle(output);
	LeaveCriticalSection(Synchronize);
#endif
}

#ifndef GENERAL_RELEASE
DWORD ConsoleOutput::Write(const char *format, va_list argptr) {
	char tmpbuf[8192] = "";
	DWORD nwritten = 0;
	vsprintf(tmpbuf, format, argptr);
	while(strchr(tmpbuf, '\x95')) // beep
		*strchr(tmpbuf, '\x95') = '.';
	while(strchr(tmpbuf, '\x07')) // beep
		*strchr(tmpbuf, '\x07') = '.';
	while(strchr(tmpbuf, '\x10')) // backspace
		*strchr(tmpbuf, '\10') = '.';
	CharToOem(tmpbuf, tmpbuf);
	WriteConsole(output, tmpbuf, strlen(tmpbuf), &nwritten, 0);
	return nwritten;
}

void ConsoleOutput::SetColor(char color) {
	switch (color) {
	case WHITE:
		SetConsoleTextAttribute(output, FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE | FOREGROUND_INTENSITY);
		break;
		
	case GRAY:
		SetConsoleTextAttribute(output, FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);
		break;
		
	case YELLOW:
		SetConsoleTextAttribute(output, FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_INTENSITY);
		break;
		
	case RED:
		SetConsoleTextAttribute(output, FOREGROUND_RED | FOREGROUND_INTENSITY);
		break;
		
	case GREEN:
		SetConsoleTextAttribute(output, FOREGROUND_GREEN | FOREGROUND_INTENSITY);
		break;
		
	case BLUE:
		SetConsoleTextAttribute(output, FOREGROUND_GREEN | FOREGROUND_BLUE | FOREGROUND_INTENSITY);
		break;
		
	case MIDBLUE:
		SetConsoleTextAttribute(output, FOREGROUND_BLUE | FOREGROUND_INTENSITY);
		break;
		
	case BLUEGREEN:
		SetConsoleTextAttribute(output, FOREGROUND_GREEN | FOREGROUND_BLUE);
		break;
		
	case PURPLE:
		SetConsoleTextAttribute(output, FOREGROUND_RED | FOREGROUND_BLUE | FOREGROUND_INTENSITY);
		break;
		
	case DARKBLUE:
		SetConsoleTextAttribute(output, FOREGROUND_BLUE);
		break;
		
	case DARKPURPLE:
		SetConsoleTextAttribute(output, FOREGROUND_RED | FOREGROUND_BLUE);
		break;
		
	case DARKYELLOW:
		SetConsoleTextAttribute(output, FOREGROUND_RED | FOREGROUND_GREEN);
		break;
		
	case DARKGREEN:
		SetConsoleTextAttribute(output, FOREGROUND_GREEN);
		break;
		
	case DARKRED:
		SetConsoleTextAttribute(output, FOREGROUND_RED);
		break;
		
	default:
		SetConsoleTextAttribute(output, FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE | FOREGROUND_INTENSITY);
		break;
	}
}

void ConsoleOutput::WriteLog(const char *format, va_list argptr) {
	FILE *writelog = 0;
	if(stricmp(log, "none")) {
		writelog = fopen(log, "at");
		vfprintf(writelog, format, argptr);
		fclose(writelog);
	}
}
#endif

DWORD ConsoleOutput::WriteEx(char color, const char *format, ...) {
	DWORD result = 0;
#ifndef GENERAL_RELEASE
	EnterCriticalSection(Synchronize);
	SetColor(color);
	va_list argptr;
	va_start(argptr, format);
	result = Write(format, argptr);
	if(log)
		WriteLog(format, argptr);
	va_end(argptr);
	LeaveCriticalSection(Synchronize);
#endif
	return result;
}

#ifndef GENERAL_RELEASE
void ConsoleOutput::SetTitle(const char *title) {
	EnterCriticalSection(Synchronize);
	SetConsoleTitle(title);
	LeaveCriticalSection(Synchronize);
}

char *ConsoleOutput::GetTitle(char *buffer, DWORD size) {
	EnterCriticalSection(Synchronize);
	GetConsoleTitle(buffer, size);
	LeaveCriticalSection(Synchronize);
	return buffer;
}

void ConsoleOutput::Activate(void) {
	EnterCriticalSection(Synchronize);
	SetConsoleActiveScreenBuffer(output);
	LeaveCriticalSection(Synchronize);
}

HWND ConsoleOutput::GetWindow(void) {
	EnterCriticalSection(Synchronize);
	HWND result = 0;
	char buffer[1024] = "";
	GetConsoleTitle(buffer, sizeof(buffer) - 1);
	SetConsoleTitle("finder");
	while(result == 0)
		result = FindWindow(0, "finder");
	SetConsoleTitle(buffer);
	LeaveCriticalSection(Synchronize);
	return result;
}

void ConsoleOutput::SetLog(const char *_log) {
	if(log)
		delete [] log;
	log = new char[strlen(_log) + 1];
	strcpy(log, _log);
}
#endif
