#ifndef CONNECTION_H
#define CONNECTION_H

#include "PacketBuffer.h"
#include "dmstring.h"
#include "ConsoleOutput.h"
#include <process.h>
#include <io.h>
#include "Storm.h"
#include "CDKeyDecode.h"

#define CONNECTED    1
#define DISCONNECTED 0

char storm[128] = "", battle[128] = "", diablo[128] = "";

typedef unsigned long (__stdcall CheckRevisionProc)(char *diablo, char *battle, char *storm, char *hashcmd, unsigned long *pa, unsigned long *pb, char *pbuf);
CheckRevisionProc *CheckRevision;

DWORD __stdcall MyGetModuleFileName(HMODULE hModule, LPTSTR lpFilename, DWORD nSize);
DWORD __stdcall MyGetModuleFileName(HMODULE hModule, LPTSTR lpFilename, DWORD nSize)
{
	if(hModule == GetModuleHandle(0)) 
	{
		if(nSize > strlen(diablo)) 
		{
			printf("Fooled verification DLL\n");
			strcpy(lpFilename, diablo);
			return strlen(diablo);
		} 
		else
			return 0;
	} 
	else
		return GetModuleFileName(hModule, lpFilename, nSize);
}

class BinaryBot
{
public:
	BinaryBot();
	~BinaryBot();

	WSADATA wsadata;
	SOCKET s;
	HANDLE recvevent;
	CRITICAL_SECTION critsec;
	ConsoleOutput *Output;
	char tmppacketid;
	DWORD encryptvalue;
	int pingvalue;
	int state;
	
	char pbuf[128], errorbuf[128], mpqfile[128], cdkey[128];
	DWORD a, b, passbuf, makebuf;

	char homechannel[128], password[256], username[20], statstring[256], unname[20];

	char hashcmd[64];

	struct BnetPacket
	{
		char packetid;
		unsigned short packetlen;
		char *packetdata;
	};

	PacketBuffer packetbuf, sendbuf;

	BOOL CheckRevision(LPCTSTR lpszFileName1, LPCTSTR lpszFileName2, LPCTSTR lpszFileName3, LPCTSTR lpszValueString, DWORD * lpdwVersion, DWORD * lpdwChecksum, LPSTR lpExeInfoString, LPCTSTR lpszMpqFileName);
	void SendCDKeyCheck(LPCTSTR lpszCDKey, DWORD dwServerHashKey, LPCTSTR lpszUserName);
	void datahash(unsigned long*param);
	void calchashbuf(unsigned long *hash, void *inbuf, int len);
	void getvalues(const char *databuf, DWORD *ping, WORD *flags, char *name, char *txt);
	
	bool Connect(char *szServer);
	void Disconnect();
	bool Startup();
	bool GetData(BnetPacket &Data);
	void MsgLoop();
};

BinaryBot::BinaryBot()
{
	InitializeCriticalSection(&critsec);
	Output = new ConsoleOutput(&critsec, false, 0);
}

BinaryBot::~BinaryBot() { DeleteCriticalSection(&critsec); }

bool BinaryBot::Connect(char *szServer)
{
	Output->WriteEx(ConsoleOutput::WHITE, "Attempting to connect to %s\n", szServer);
  s = INVALID_SOCKET;
  state = DISCONNECTED;
  if (WSAStartup(0x101,&wsadata)) 
    return false;
  if (wsadata.wVersion != 0x101) 
  {
    WSACleanup();
    return false;
  }
  struct sockaddr_in name;
  struct hostent *hp;
  memset(&name, '\0', sizeof(name));
  name.sin_family = AF_INET;
  name.sin_port = htons(6112);
  char *p = szServer;
  while (*p && (isdigit(*p) || (*p == '.')))
    p++;
  if (*p) 
  {
    hp = gethostbyname(szServer);
    if (hp == 0)
      return false;
    memcpy(&name.sin_addr, hp->h_addr, hp->h_length);
  }
  else
    name.sin_addr.s_addr = inet_addr(szServer);
  s = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
  if (s == INVALID_SOCKET)
    return false;
  if (connect(s, (struct sockaddr *)&name, sizeof(name)))
    return false;
  recvevent = CreateEvent(0, 0, 0, 0);
  WSAResetEvent(recvevent);
  WSAEventSelect(s, recvevent, 0);
  WSAEventSelect(s, recvevent, FD_READ | FD_CLOSE);
  state = CONNECTED;
  return true;
}

void BinaryBot::Disconnect()
{
	if (s == INVALID_SOCKET)
		return;
	closesocket(s);
	s = INVALID_SOCKET;
	state = DISCONNECTED;
}

bool BinaryBot::Startup()
{
	send(s, "\x1", 1, 0); 
	packetbuf.insert((int)0);
	packetbuf.insert((int)0); 
	packetbuf.insert((int)0);
	packetbuf.insert((int)0);
	packetbuf.insert("vLBBot");
	packetbuf.insert("vLBBot");
	packetbuf.sendpacket(s, 0x05);

	packetbuf.insert("68XIRHSS", 8);
	packetbuf.insert((int)0xa5);
	packetbuf.insert((int)0);
	packetbuf.sendpacket(s, 0x06);
	BnetPacket Data;
	for(int i = 0; i < 4; i++)
	{
		if(!GetData(Data)) { Output->WriteEx(ConsoleOutput::RED, "Disconnected\n"); return false; }
		Sleep(300);
		switch(Data.packetid)
		{
		case 0x05:
			//nothing, account number shit doesn't matter
			break;
		case 0x28:
			//random pw encrypt value
			encryptvalue = *(unsigned long*)Data.packetdata;
			Output->WriteEx(ConsoleOutput::BLUE, "Recieved random hash encrypt value: 0x%08x\n", encryptvalue);
			break;
		case 0x25:
			//ping packet
			pingvalue = *(unsigned long*)Data.packetdata;
			packetbuf.insert((int)pingvalue);
			packetbuf.sendpacket(s, 0x25);
			break;
		case 0x06:
			//mpq name and hash command
			memset(mpqfile, 0, sizeof(mpqfile));
			memset(hashcmd, 0, sizeof(hashcmd));
			memcpy(mpqfile, Data.packetdata + 7, 12);
			memcpy(hashcmd, Data.packetdata + 19, Data.packetlen - 20);
			Output->WriteEx(ConsoleOutput::BLUE, "Recieved hash information.\n");
			break;
		}
	}
	if(!CheckRevision("starcraft.exe", "storm.dll", "battle.snp", hashcmd, &a, &b, pbuf, mpqfile))
		return false;
	Output->WriteEx(ConsoleOutput::WHITE, "Checking game version...\n");
	packetbuf.insert("68XIRHSS", 8);
	packetbuf.insert((int)0xa5);
	packetbuf.insert(a);
	packetbuf.insert(b);
	packetbuf.insert(pbuf);
	packetbuf.sendpacket(s, 0x07);
	if(!GetData(Data)) { Output->WriteEx(ConsoleOutput::RED, "Disconnected\n"); return false; }
	if(memchr(Data.packetdata, 0x02, strlen(Data.packetdata)))
	{
		Output->WriteEx(ConsoleOutput::RED, "Battle net rejected your hash!\n");
		return false;
	}
	else
		Output->WriteEx(ConsoleOutput::GREEN, "Battle net accepted your game version.\n");

	packetbuf.sendpacket(s, 0x2d);
	//Output->WriteEx(ConsoleOutput::WHITE, "Verifying CDKey...\n");
	//packetbuf.insert((int)0x1a);
	//packetbuf.insert((int)0);
	//packetbuf.insert("tos_USA");
	//packetbuf.sendpacket(s, 0x33);
	//packetbuf.insert((int)0x1b);
	//packetbuf.insert((int)0);
	//packetbuf.insert("bnetserver.ini");
	//packetbuf.sendpacket(s, 0x33);
	//SendCDKeyCheck(cdkey, encryptvalue, username);
	if(!GetData(Data)) { Output->WriteEx(ConsoleOutput::RED, "Disconnected\n"); return false; }
	packetbuf.insert("tenb");
	packetbuf.sendpacket(s, 0x14);
	DWORD passwordhash[7];
	passwordhash[0] = GetTickCount();
	passwordhash[1] = encryptvalue;
	calchashbuf(passwordhash+2, password, strlen(password));
	calchashbuf(passwordhash+2, passwordhash, 7*4);
	packetbuf.insert(passwordhash, 7*4);
	packetbuf.insert(username);
	packetbuf.sendpacket(s, 0x29);
	if(!GetData(Data)) { Output->WriteEx(ConsoleOutput::RED, "Disconnected\n"); return false; }
	if(memchr(Data.packetdata, 0x01, strlen(Data.packetdata)))
	{
		Output->WriteEx(ConsoleOutput::RED, "Login failed!\n");
		return false;
	}
	Output->WriteEx(ConsoleOutput::GREEN, "Logon accepted!\n");
	packetbuf.insert(username);
	packetbuf.insert(statstring);
	packetbuf.sendpacket(s, 0x0a);
	packetbuf.insert("RHSS");
	packetbuf.sendpacket(s, 0x0b);
	packetbuf.insert((int)2);
	packetbuf.insert(homechannel);
	packetbuf.sendpacket(s, 0x0c);
	if(!GetData(Data)) { Output->WriteEx(ConsoleOutput::RED, "Disconnected\n"); return false; } //channel list
	if(!GetData(Data)) { Output->WriteEx(ConsoleOutput::RED, "Disconnected\n"); return false; } //server list
	if(!GetData(Data)) { Output->WriteEx(ConsoleOutput::RED, "Disconnected\n"); return false; }
	packetbuf.insert(Data.packetdata);
	packetbuf.extract(unname);
	packetbuf.clear();
	Output->WriteEx(ConsoleOutput::YELLOW, "Base name: %s\nLogged on as %s\n", username, unname);
	return true;
}

void BinaryBot::MsgLoop()
{
	BnetPacket Data;
	DWORD ping;
	WORD flags;
	char name[128], txt[512];
	while(GetData(Data))
	{
		if(Data.packetid == 0x0F)
		{
			switch(Data.packetdata[0])
			{
			case 0x01:
				getvalues(Data.packetdata, &ping, &flags, name, txt);
				Output->WriteEx(ConsoleOutput::WHITE, "In channel: %s:%d:%d: %s\n", name, ping, flags, txt);
				break;
			}
		}
	}
}

void BinaryBot::getvalues(const char *databuf, DWORD *ping, WORD *flags, char *name, char *txt)
{
	PacketBuffer Data;
	*ping = *(unsigned long *)databuf + 8;
	*flags = *(unsigned short *)databuf + 4;
	Data.insert(databuf);
	Data += 24;
	Data.extract(name);
	Data += strlen(name);
	Data.extract(txt);
}

bool BinaryBot::GetData(BnetPacket &Data)
{
	char databuf[6000] = "";
	char header[4] = "";
	int recvlen = 0, buflen = 0;
	DWORD wait = WaitForSingleObject(recvevent, 10000);
	if(wait == WAIT_TIMEOUT)
		return false;
	recv(s, (char *)header, 4, 0);
	Data.packetid = header[1];
	Data.packetlen = *(unsigned short *)&header[2];
	Data.packetdata = new char[Data.packetlen];
	ZeroMemory(Data.packetdata, Data.packetlen);
	wait = WaitForSingleObject(recvevent, 10000);
	if(wait == WAIT_TIMEOUT)
		return false;
	while(buflen < (int)(Data.packetlen - 4))
	{
		recvlen = recv(s, (char *)databuf + buflen, 1, 0);
		sprintf(Data.packetdata, "%s%c", Data.packetdata, databuf[buflen]);
		buflen += recvlen;
	}
	return true;
}

void BinaryBot::datahash(unsigned long*param)
{
	unsigned long buf[0x50];
	unsigned long dw, a, b, c, d, e, *p;
	int i;
	memcpy(buf, param+5, 0x40);
	for(i=0x10; i<0x50; i++) 
	{
		dw = buf[i-0x10]^buf[i-0x8]^buf[i-0xe]^buf[i-0x3];
		buf[i] = (1>>(0x20-(unsigned char)dw)) | (1<<(unsigned char)dw);		
	}
	a = param[0];	// edi
	b = param[1];	// eax
	c = param[2];	// esi
	d = param[3];	// edx
	e = param[4];	// [+18], ebx
	p = buf;		// [+14]
	i = 0x14;		// [+10]
	do 
	{
		dw = ((a<<5) | (a>>0x1b)) + ((~b & d) | (c & b)) + e + *p++ + 0x5A827999; // ecx
		e = d;
		d = c;
		c = (b>>2)  | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	i = 0x14;		// [+14]
	do 
	{
		dw = (d ^ c ^ b) + e + ((a<<5) | (a>>0x1b)) + *p++ + 0x6ED9EBA1; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	i = 0x14;
	do 
	{
		dw = ((c & b) | (d & c) | (d & b)) + e + ((a<<5) | (a>>0x1b)) + *p++ - 0x70E44324; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);

	i = 0x14;
	do 
	{
		dw = ((a<<5) | (a>>0x1b)) + e + (d ^ c ^ b) + *p++ - 0x359D3E2A; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	param[0] += a;
	param[1] += b;
	param[2] += c;
	param[3] += d;
	param[4] += e;

}

void BinaryBot::calchashbuf(unsigned long *hash, void *inbuf, int len)
{
	char *buf = (char*)inbuf;
	int pos;
	int sublen;
	unsigned long hashbuf[0x10 + 5];
	hashbuf[0] = 0x67452301;
	hashbuf[1] = 0xEFCDAB89;
	hashbuf[2] = 0x98BADCFE;
	hashbuf[3] = 0x10325476;
	hashbuf[4] = 0xC3D2E1F0;
	for(pos=0; pos<len; pos+=0x40) {
		sublen = len - pos;
		if(sublen > 0x40)
			sublen = 0x40;
		memcpy(hashbuf+5, buf+pos, sublen);
		if(sublen<0x40)
			ZeroMemory((char*)(hashbuf+5)+sublen, 0x40-sublen);
		datahash(hashbuf);
	}
	memcpy(hash, hashbuf, 5*4);
}

BOOL BinaryBot::CheckRevision(LPCTSTR lpszFileName1, LPCTSTR lpszFileName2, LPCTSTR lpszFileName3, LPCTSTR lpszValueString, DWORD * lpdwVersion, DWORD * lpdwChecksum, LPSTR lpExeInfoString, LPCTSTR lpszMpqFileName)
{
   DWORD dwMpqChecksumKeys[] = {0xE7F4CB62lu, 0xF6A14FFClu, 0xAA5504AFlu, 0x871FCDC2lu, 0x11BF6A18lu, 0xC57292E6lu, 0x7927D27Elu, 0x2FEC8733lu};
   HANDLE hFile, hFileMapping;
   char * s, lpszFileName[256], cOperations[16];
   int nHashFile, nVariable1[16], nVariable2[16], nVariable3[16], nVariable,
       i, k, nHashOperations;
   DWORD dwTotalSize, dwSize, j, dwBytesRead, dwVariables[4], dwMpqKey,
         * lpdwBuffer;
   LPSTR lpszFileNames[3];
   FILETIME ft;
   SYSTEMTIME st;
   LPBYTE lpbBuffer;
   VS_FIXEDFILEINFO * ffi;

   s = strchr((char *) lpszMpqFileName, '.');
   if (s == NULL)
      return FALSE;
   nHashFile = (int) (*(s - 1) - '0');
   if (nHashFile > 7 || nHashFile < 0)
      return FALSE;
   dwMpqKey = dwMpqChecksumKeys[nHashFile];
   lpszFileNames[0] = (LPSTR) lpszFileName1;
   lpszFileNames[1] = (LPSTR) lpszFileName2;
   lpszFileNames[2] = (LPSTR) lpszFileName3;
   s = (char *) lpszValueString;
   while (*s != '\0')
   {
      if (isalpha(*s))
         nVariable = (int) (toupper(*s) - 'A');
      else
      {
         nHashOperations = (int) (*s - '0');
         s = strchr(s, ' ');
         if (s == NULL)
            return FALSE;
         s++;
         break;
      }
      if (*(++s) == '=')
         s++;
      dwVariables[nVariable] = atol(s);
      s = strchr(s, ' ');
      if (s == NULL)
         return FALSE;
      s++;
   }
   for (i = 0; i < nHashOperations; i++)
   {
      if (!isalpha(*s))
         return FALSE;
      nVariable1[i] = (int) (toupper(*s) - 'A');
      if (*(++s) == '=')
         s++;
      if (toupper(*s) == 'S')
         nVariable2[i] = 3;
      else
         nVariable2[i] = (int) (toupper(*s) - 'A');
      cOperations[i] = *(++s);
      s++;
      if (toupper(*s) == 'S')
         nVariable3[i] = 3;
      else
         nVariable3[i] = (int) (toupper(*s) - 'A');
      s = strchr(s, ' ');
      if (s == NULL)
         break;
      s++;
   }
   dwVariables[0] ^= dwMpqKey;
   for (i = 0; i < 3; i++)
   {
      if (lpszFileNames[i][0] == '\0')
         continue;
      hFile = CreateFile(lpszFileNames[i],
                         GENERIC_READ,
                         FILE_SHARE_READ,
                         NULL,
                         OPEN_EXISTING,
                         FILE_ATTRIBUTE_NORMAL,
                         NULL);
      if (hFile == (HANDLE) INVALID_HANDLE_VALUE)
         return FALSE;
      hFileMapping = CreateFileMapping(hFile, NULL, PAGE_READONLY, 0, 0, NULL);
      if (hFileMapping == NULL)
      {
         CloseHandle(hFile);
         return FALSE;
      }
      lpdwBuffer = (LPDWORD) MapViewOfFile(hFileMapping, FILE_MAP_READ, 0, 0, 0);
      if (lpdwBuffer == NULL)
      {
         CloseHandle(hFileMapping);
         CloseHandle(hFile);
         return FALSE;
      }
      if (i == 0)
      {
         GetFileTime(hFile, NULL, NULL, &ft);
         FileTimeToSystemTime(&ft, &st);
         dwTotalSize = GetFileSize(hFile, NULL);
      }
      dwSize = (GetFileSize(hFile, NULL) / 1024lu) * 1024lu;
      for (j = 0; j < (dwSize / 4lu); j++)
      {
         dwVariables[3] = lpdwBuffer[j];
         for (k = 0; k < nHashOperations; k++)
         {
            switch (cOperations[k])
            {
               case '+':
                  dwVariables[nVariable1[k]] = dwVariables[nVariable2[k]] +
                                               dwVariables[nVariable3[k]];
                  break;
               case '-':
                  dwVariables[nVariable1[k]] = dwVariables[nVariable2[k]] -
                                               dwVariables[nVariable3[k]];
                  break;
               case '^':
                  dwVariables[nVariable1[k]] = dwVariables[nVariable2[k]] ^
                                               dwVariables[nVariable3[k]];
                  break;
               default:
                  return FALSE;
            }
         }
      }
      UnmapViewOfFile(lpdwBuffer);
      CloseHandle(hFileMapping);
      CloseHandle(hFile);
   }
   strcpy(lpszFileName, lpszFileName1);
   dwSize = GetFileVersionInfoSize(lpszFileName, &dwBytesRead);
   lpbBuffer = (LPBYTE) VirtualAlloc(NULL, dwSize, MEM_COMMIT,
                                     PAGE_READWRITE);
   if (lpbBuffer == NULL)
      return FALSE;
   if (GetFileVersionInfo(lpszFileName, NULL, dwSize, lpbBuffer) == FALSE)
      return FALSE;
   if (VerQueryValue(lpbBuffer, "\\", (LPVOID *) &ffi, (PUINT) &dwSize) == FALSE)
      return FALSE;
   *lpdwVersion = ((HIWORD(ffi->dwProductVersionMS) & 0xFF) << 24) |
                  ((LOWORD(ffi->dwProductVersionMS) & 0xFF) << 16) |
                  ((HIWORD(ffi->dwProductVersionLS) & 0xFF) << 8) |
                  (LOWORD(ffi->dwProductVersionLS) & 0xFF);
   VirtualFree(lpbBuffer, 0lu, MEM_RELEASE);
   s = (char *) &lpszFileName[strlen(lpszFileName)-1];
   while (*s != '\\' && s > (char *) lpszFileName)
      s--;
   s++;
   sprintf(lpExeInfoString,
           "%s %02u/%02u/%02u %02u:%02u:%02u %lu",
           lpszFileName,
           st.wMonth,
           st.wDay,
           st.wYear % 100,
           st.wHour,
           st.wMinute,
           st.wSecond,
           dwTotalSize);
   *lpdwChecksum = dwVariables[2];
   return TRUE;
}

void BinaryBot::SendCDKeyCheck(LPCTSTR lpszCDKey, DWORD dwServerHashKey, LPCTSTR lpszUserName)
{
	DWORD * lpdwBuffer;
	BYTE bBuffer[1024];
	DWORD dwHashBuffer[256], dwProductId, dwValue1, dwValue2, dwHashKey;
	WORD wLength;

	bBuffer[0] = 0xFF;
	bBuffer[1] = 0x36;
	lpdwBuffer = (DWORD *) &bBuffer[4];
	if (DecodeCDKey(lpszCDKey, &dwProductId, &dwValue1, &dwValue2) == FALSE)
		return;
	dwHashKey = GetTickCount();
	dwHashBuffer[0] = dwServerHashKey;
	dwHashBuffer[1] = dwHashKey;
	dwHashBuffer[2] = dwProductId;
	dwHashBuffer[3] = dwValue1;
	dwHashBuffer[4] = dwValue2;
	HashData(dwHashBuffer, 20, &lpdwBuffer[6]);
	lpdwBuffer[0] = 0;
	lpdwBuffer[1] = strlen(lpszCDKey);
	lpdwBuffer[2] = dwProductId;
	lpdwBuffer[3] = dwValue1;
	lpdwBuffer[4] = dwServerHashKey;
	lpdwBuffer[5] = dwHashKey;
	strcpy((char *) &lpdwBuffer[11], lpszUserName);
	wLength = 48 + strlen(lpszUserName) + 1;
	*(WORD *) &bBuffer[2] = wLength;
	send(s, (const char *)bBuffer, wLength, 0);
	return;
}

#endif