/* Battle.net CD-Key Algorithm Source Code  YobGuls (yobguls@yobguls.2ndmail.com) 2001
 * This source will decode a CD-Key from either Starcraft or Diablo 2
 * into the three values that need to be sent to Battle.net to verify it */
/* The first value identifies the product that the CD-key is used for, and the next
 * two are part of a string of digits which is kind of like a seed that can be used
 * to generate the key. */

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>

#include "CDKeyDecode.h"

#define ROL(nr, shift)	((nr << shift) | (nr >> (32 - shift)))

/* Code values used in Diablo 2 CD-Key decoding */

BYTE codevalues[256] = {
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x02, 0x03, 0x04, 0x05, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0xFF, 0x0D, 0x0E, 0xFF, 0x0F, 0x10, 0xFF,
0x11, 0xFF, 0x12, 0xFF, 0x13, 0xFF, 0x14, 0x15, 0x16, 0xFF, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0xFF, 0x0D, 0x0E, 0xFF, 0x0F, 0x10, 0xFF,
0x11, 0xFF, 0x12, 0xFF, 0x13, 0xFF, 0x14, 0x15, 0x16, 0xFF, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };

BOOL DecodeCDKey(LPCTSTR lpszCDKey, DWORD * lpdwProductId, DWORD * lpdwValue1,
                 DWORD * lpdwValue2)
{
   char key[1024], value[1024];
   int i, length, keylength;
   BOOL bValid;

   length = strlen(lpszCDKey);
   keylength = 0;
   for (i = 0; i < length; i++)
   {
      if (isalnum(lpszCDKey[i]))
      {
         key[keylength] = lpszCDKey[i];
         keylength++;
      }
   }
   if (keylength == 13)
      bValid = DecodeStarcraftKey(key);
   else if (keylength == 16)
      bValid = DecodeD2Key(key);
   else
      return FALSE;
   strncpy(value, key, 2);
   value[2] = '\0';
   sscanf(value, "%X", lpdwProductId);
   if (keylength == 16)
   {
      strncpy(value, &key[2], 6);
      value[6] = '\0';
      sscanf(value, "%X", lpdwValue1);
      strcpy(value, &key[8]);
      value[8] = '\0';
      sscanf(value, "%X", lpdwValue2);
   }
   else if (keylength == 13)
   {
      strncpy(value, &key[2], 7);
      value[7] = '\0';
      sscanf(value, "%ld", lpdwValue1);
      strncpy(value, &key[9], 3);
      value[3] = '\0';
      sscanf(value, "%ld", lpdwValue2);
   }      
   return bValid;
}

BOOL DecodeStarcraftKey(LPSTR key)
{
   DWORD r, n, n2, v, v2, keyvalue;
   BYTE c1, c2, c;
   BOOL bValid;
   int i;

   v = 3;
   for (i = 0; i < 12; i++)
   {
      c = key[i];
      n = Get_Num_Value(c);
      n2 = v * 2;
      n ^= n2;
      v += n;
   }
   v %= 10;
   if (Get_Hex_Value(v) == key[12])
      bValid = TRUE;
   else
      bValid = FALSE;
   v = 194;
   for (i = 11; v >= 7, i >= 0; i--)
   {
      c = key[i];
      n = v / 12;
      n2 = v % 12;
      v -= 17;
      c2 = key[n2];
      key[i] = c2;
      key[n2] = c;
   }
   v2 = 0x13AC9741;
   for (i = 11; i >= 0; i--)
   {
      c = toupper(key[i]);
      key[i] = c;
      if (c <= '7')
      {
         v = v2;
         c2 = v & 0xFF;
         c2 &= 7;
         c2 ^= c;
         v >>= 3;
         key[i] = c2;
         v2 = v;
      }
      else if (c < 'A')
      {
         c2 = (BYTE) i;
         c2 &= 1;
         c2 ^= c;
         key[i] = c2;
      }
   }
   return bValid;
}

BOOL DecodeD2Key(LPSTR key)
{
   DWORD r, n, n2, v, v2, keyvalue;
   BYTE c1, c2, c;
   BOOL bValid;
   int i;   

   r = 1;
   keyvalue = 0;
   for (i = 0; i < 16; i += 2)
   {
      c1 = codevalues[key[i]];
      n = c1 * 3;
      c2 = codevalues[key[i+1]];
      n = c2 + n * 8;
      if (n >= 0x100)
      {
         n -= 0x100;
         keyvalue |= r;
      }
      n2 = n;
      n2 >>= 4;
      key[i] = Get_Hex_Value(n2);
      key[i+1] = Get_Hex_Value(n);
      r <<= 1;
   }
   v = 3;
   for (i = 0; i < 16; i++)
   {
      c = key[i];
      n = Get_Num_Value(c);
      n2 = v * 2;
      n ^= n2;
      v += n;
   }
   v &= 0xFF;
   if (v == keyvalue)
      bValid = TRUE;
   else
      bValid = FALSE;
   for (i = 15; i >= 0; i--)
   {
      c = key[i];
      if (i > 8)
         n = i - 9;
      else
         n = 0xF - (8 - i);
      n &= 0xF;
      c2 = key[n];
      key[i] = c2;
      key[n] = c;
   }
   v2 = 0x13AC9741;
   for (i = 15; i >= 0; i--)
   {
      c = toupper(key[i]);
      key[i] = c;
      if (c <= '7')
      {
         v = v2;
         c2 = v & 0xFF;
         c2 &= 7;
         c2 ^= c;
         v >>= 3;
         key[i] = c2;
         v2 = v;
      }
      else if (c < 'A')
      {
         c2 = (BYTE) i;
         c2 &= 1;
         c2 ^= c;
         key[i] = c2;
      }
   }
   return bValid;
}

char Get_Hex_Value(DWORD v)
{
   v &= 0xF;
   if (v < 10)
      return (v + 0x30);
   else
      return (v + 0x37);
}

int Get_Num_Value(char c)
{
   c = toupper(c);
   if (isdigit(c))
      return (c - 0x30);
   else
      return (c - 0x37);
}

void HashData(LPVOID lpSource, int nLength, LPVOID lpResult)
{
   BYTE bBuffer[1024];
   int i;
   DWORD a, b, c, d, e, g, * lpdwBuffer;

   ZeroMemory(bBuffer, 1024);
   CopyMemory(bBuffer, lpSource, nLength);
   lpdwBuffer = (LPDWORD) bBuffer;

   for (i=0; i<64; i++)
      lpdwBuffer[i+16] = ROL(1, (lpdwBuffer[i] ^ lpdwBuffer[i+8] ^
                             lpdwBuffer[i+2] ^ lpdwBuffer[i+13]) % 32);
   a = 0x67452301lu;
   b = 0xefcdab89lu;
   c = 0x98badcfelu;
   d = 0x10325476lu;
   e = 0xc3d2e1f0lu;
   for (i = 0; i < (20 * 1); i++)
   {
      g = lpdwBuffer[i] + ROL(a,5) + e + ((b & c) | (~b & d)) + 0x5a827999lu;
      e = d;
      d = c;
      c = ROL(b,30);
      b = a;
      a = g;
   }
   for (; i < (20 * 2); i++)
   {
      g = (d ^ c ^ b) + e + ROL(g,5) + lpdwBuffer[i] + 0x6ed9eba1lu;
      e = d;
      d = c;
      c = ROL(b,30);
      b = a;
      a = g;
   }
   for (; i < (20 * 3); i++)
   {
      g = lpdwBuffer[i] + ROL(g,5) + e + ((c & b) | (d & c) | (d & b)) -
          0x70e44324lu;
      e = d;
      d = c;
      c = ROL(b,30);
      b = a;
      a = g;
   }
   for (; i < (20 * 4); i++)
   {
      g = (d ^ c ^ b) + e + ROL(g,5) + lpdwBuffer[i] - 0x359d3e2alu;
      e = d;
      d = c;
      c = ROL(b,30);
      b = a;
      a = g;
   }

   lpdwBuffer = (LPDWORD) lpResult;
   lpdwBuffer[0] = 0x67452301lu + g;
   lpdwBuffer[1] = 0xefcdab89lu + b;
   lpdwBuffer[2] = 0x98badcfelu + c;
   lpdwBuffer[3] = 0x10325476lu + d;
   lpdwBuffer[4] = 0xc3d2e1f0lu + e;
   return TRUE;
}