Attribute VB_Name = "modSystemFolders"
Option Explicit

'-------------------------------------------------
'  Folder Browsing API Declarations
'-------------------------------------------------
Private Type BrowseInfo
    hWndOwner As Long
    pidlRoot As Long
    sDisplayName As String
    sTitle As String
    ulFlags As Long
    lpfn As Long
    lParam As Long
    iImage As Long
End Type

Private Declare Function SHBrowseForFolder Lib "shell32.dll" (bBrowse As BrowseInfo) As Long
Private Declare Function SHGetPathFromIDList Lib "shell32.dll" (ByVal lItem As Long, ByVal sDir As String) As Long

'-------------------------------------------------
'  Folder Browsing
'-------------------------------------------------
'  Let the user browse for a folder.  Returns the
'  selected folder or vbNullString on cancel.
'-------------------------------------------------
Public Function BrowseForFolder() As String
    Dim browse_info As BrowseInfo
    Dim Item As Long
    Dim dir_name As String

    BrowseForFolder = vbNullString
   
    browse_info.hWndOwner = frmEditConfig.hWnd
    browse_info.pidlRoot = 0
    browse_info.sDisplayName = String$(260, vbNullChar)
    browse_info.sTitle = "Select Hash Directory"
    browse_info.ulFlags = 1 ' Return directory name.
    browse_info.lpfn = 0
    browse_info.lParam = 0
    browse_info.iImage = 0
    
    Item = SHBrowseForFolder(browse_info)
    If Item Then
        dir_name = String$(260, vbNullChar)
        If SHGetPathFromIDList(Item, dir_name) Then
            BrowseForFolder = Left(dir_name, InStr(dir_name, Chr$(0)) - 1)
        Else
            BrowseForFolder = vbNullString
        End If
    End If
End Function
