Attribute VB_Name = "modModeration"
Option Explicit

Public IsModerator As Boolean   ' Bot Moderator Status
Public Designated As String     ' User Last Designated

Public LastBannedUser As String
Public LastIgnoredUser As String
Public SweepChannel As Boolean
Public SweepBan As Boolean
Public SweepIgnore As Boolean

Public Enum enMode
    seLow& = 0
    seNormal& = 1
    seHigh& = 2
End Enum

Public Function StructureName(ByVal uUsername As String, ByVal uProductID As String) As String
    ' If ProductID is WAR3, W3XP then check if Username is on StarCraft or WarCraft3
    ' If ProductID is D2DV, D2XP then split Username
    
    Select Case Config.ProductID
        Case "WAR3", "W3XP"
            Select Case uProductID
                Case "WAR3", "W3XP"
                    ' Remove @Realm
                    
                    If InStr(uUsername, "@Lordaeron") > 0 Or _
                        InStr(uUsername, "@Azeroth") > 0 Or _
                        InStr(uUsername, "@Northrend") > 0 Or _
                        InStr(uUsername, "@Kalimdor") > 0 Then
                        StructureName = Left(uUsername, InStrRev(uUsername, "@") - 1)
                    Else
                        StructureName = uUsername
                    End If
                
                Case Else
                    
                    If InStr(uUsername, "@USWest") > 0 Or _
                        InStr(uUsername, "@USEast") > 0 Or _
                        InStr(uUsername, "@Europe") > 0 Or _
                        InStr(uUsername, "@Asia") > 0 Then
                        StructureName = uUsername
                    Else
                        StructureName = uUsername ' & "@" & GetServerName
                    End If
            End Select
        Case "D2DV", "D2XP"
            If InStr(uUsername, "*") > 0 Then
                StructureName = "*" & Split(uUsername, "*")(1)
            Else
                StructureName = "*" & uUsername
            End If
        Case Else
            If InStr(uUsername, "@USWest") > 0 Or _
                InStr(uUsername, "@USEast") > 0 Or _
                InStr(uUsername, "@Europe") > 0 Or _
                InStr(uUsername, "@Asia") > 0 Then
                StructureName = Left(uUsername, InStrRev(uUsername, "@") - 1)
            Else
                StructureName = uUsername
            End If
    End Select
End Function

Public Sub QueueBan(ByVal UserName As String, Optional Message As String, Optional Prefix As String = "ban")
    Dim FUsername As String
    If InStr(UserName, "*") > 0 Then
        FUsername = "*" & Split(UserName, "*")(1)
    Else
        FUsername = UserName
    End If
    
    Dim uIndex As Integer
    uIndex = FindUser(UserName)
    
    If uIndex > 0 Then
        If (Users(uIndex).Flags And USERFLAG_MOD) = USERFLAG_MOD Then
            Exit Sub
        End If
    End If
    
    If Settings.ByPassSafelist = False Then
        Dim iIndex As Integer
        iIndex = FindDatabaseUser(UserName)
        
        If iIndex > 0 Then
            If Ranks(RankIndex(Database(iIndex).Rank)).Friend = True Then
                AddChat vbYellow, "Removed " & Prefix & " action for " & UserName & " due to safelist."
                Exit Sub
            End If
        End If
        
        iIndex = FindDatabaseUser(FUsername)
        
        If iIndex > 0 Then
            If Ranks(RankIndex(Database(iIndex).Rank)).Friend = True Then
                AddChat vbYellow, "Removed " & Prefix & " action for " & UserName & " due to safelist."
                Exit Sub
            End If
        End If
    End If
    
    If Settings.QRemBanned = True And LCase$(Prefix) = "ban" Then
        Dim I As Integer
        For I = 1 To UBound(Banned)
            If LCase$(Banned(I).UserName) = LCase$(FUsername) Then
                Exit Sub
            End If
        Next I
    End If
    
    ' Check if user is already being banned in the queue...
    For I = 1 To UBound(Queue)
        If LCase$(Left$(Queue(I), 4)) = LCase$("/" & Prefix) Then
            Dim Splt() As String
            If InStr(Queue(I), " ") > 0 Then
                Splt() = Split(Queue(I), " ")
                If LCase$(Splt(1)) = LCase$(UserName) Then
                    Exit Sub
                End If
            End If
        End If
    Next I

    AddQueue "/" & Prefix & " " & UserName & " " & Message
End Sub

Public Sub ProcessModeration(ByVal EventID As Byte, ByVal UserName As String, ByVal Ping As Long, ByVal Flags As Long, ByVal Statstring As String, Optional ByVal Message As String)
    ' TODO : Stats Banning, _
             Clan Protection
    
    Dim FUsername As String
    If InStr(UserName, "*") > 0 Then
        FUsername = Split(UserName, "*")(1)
    Else
        FUsername = UserName
    End If
    
    If FUsername = MyUsername Then Exit Sub
    
    ' Don't allow moderators to be banned
    If (Flags And &H2) = &H2 Then Exit Sub
    
    ' Don't allow moderation options if _
      bot is not moderator
    If Not ((MyFlags And &H2) = &H2) Then Exit Sub

    ' Check if blacklisted or safelisted
    Dim I As Integer, R As Integer
    For I = 1 To UBound(Database())
        If InStr(Database(I).UserName, "*") > 0 Then
            If Matches(FUsername, Database(I).UserName) = True Then
                R = RankIndex(Database(I).Rank)
                If (R > 0) Then
                    If Ranks(R).Friend = True Then
                        If Settings.ByPassSafelist = False Then Exit Sub
                    End If
                    If Ranks(R).Ignored = True Then
                        If Ranks(R).Banned = False Then
                            QueueBan UserName, , "ignore"
                            Exit Sub
                        End If
                    End If
                    If Ranks(R).Banned = True Then
                        If Ranks(R).Ignored = True Then
                            QueueBan UserName, , "ignore"
                        End If
                        QueueBan UserName, Ranks(RankIndex(Database(I).Rank)).BanMessage
                        Exit Sub
                    End If
                End If
            End If
        Else
            If LCase$(Database(I).UserName) = LCase$(FUsername) Then
                R = RankIndex(Database(I).Rank)
                If (R > 0) Then
                    If Ranks(R).Friend = True Then
                        If Settings.ByPassSafelist = False Then Exit Sub
                    End If
                    If Ranks(R).Ignored = True Then
                        If Ranks(R).Banned = False Then
                            QueueBan UserName, , "ignore"
                            Exit Sub
                        End If
                    End If
                    If Ranks(R).Banned = True Then
                        If Ranks(R).Ignored = True Then
                            QueueBan UserName, , "ignore"
                        End If
                        QueueBan UserName, Ranks(RankIndex(Database(I).Rank)).BanMessage
                        Exit Sub
                    End If
                End If
            End If
        End If
    Next I
    
LockDown:
'--------------------------------
' LockDown
'--------------------------------
    If Settings.LockDown = True Then
        QueueBan UserName, "LockDown"
        Exit Sub
    End If

    Dim Client As String * 4
    Client = StrReverse$(Left$(Statstring, 4))
    
'--------------------------------
' Clan Banning
'--------------------------------
    If UBound(Split(Statstring, " ")) = 4 Then
        Dim Clan As String
        Clan = StrReverse(Split(Split(Statstring, " ")(3), Chr$(&H0))(0))
    End If
    
    If Client = "WAR3" Or Client = "W3XP" Then
        If Len(Clan) > 0 Then
            Dim c As Integer
            For c = 1 To UBound(ClanBans())
                If LCase$(ClanBans(c).Clan) = LCase$(Clan) Then
                    QueueBan UserName, "Clanban"
                    Exit Sub
                End If
            Next c
        End If
    End If

    If (Settings.OutsiderClanBan = True) Then
        ' Check if you are shaman or cheiftain
        If (MyClanRank > 2) Then
            ' Check if your tag is the name of the clan channel
            If (LCase$(MyChannel) Like "clan " & LCase$(MyClanTag)) Then
                ' Check if their tag is different to yours
                If (Clan <> MyClanTag) Then
                    QueueBan UserName, "Outsider ClanBan"
                End If
            End If
        End If
    End If

'--------------------------------
' Ping Banning
'--------------------------------
    If Settings.PingBanning Then
        If (Settings.Ping0) And (Ping = 0) Then: _
            QueueBan UserName, "PingBan: 0ms": Exit Sub
        If (Settings.Ping1) And (Ping = -1) Then: _
            QueueBan UserName, "PingBan: -1ms": Exit Sub
        If (Settings.Ping500) And (Ping > 500) Then: _
            QueueBan UserName, "PingBan: >500ms": Exit Sub
        If (Settings.Ping300) And (Ping > 300) Then: _
            QueueBan UserName, "PingBan: >300ms": Exit Sub
        If (Flags And &H10) = &H10 Then
            If Settings.PingUDP = True Then: _
                QueueBan UserName, "PingBan: PLUG": Exit Sub
        End If
    End If

'--------------------------------
' Client Banning
'--------------------------------
    If Settings.ClientBanning = True Then
        Select Case Client
            Case "D2DV"
                If Settings.ClientD2DV = True Then: _
                    QueueBan UserName, "ClientBan: D2DV": Exit Sub
            Case "D2XP"
                If Settings.ClientD2XP = True Then: _
                    QueueBan UserName, "ClientBan: D2XP": Exit Sub
            Case "W2BN"
                If Settings.ClientW2BN = True Then: _
                    QueueBan UserName, "ClientBan: W2BN": Exit Sub
            Case "STAR"
                If Settings.ClientSTAR = True Then: _
                    QueueBan UserName, "ClientBan: STAR": Exit Sub
            Case "SEXP"
                If Settings.ClientSEXP = True Then: _
                    QueueBan UserName, "ClientBan: SEXP": Exit Sub
            Case "WAR3"
                If Settings.ClientWAR3 = True Then: _
                    QueueBan UserName, "ClientBan: WAR3": Exit Sub
            Case "W3XP"
                If Settings.ClientW3XP = True Then: _
                    QueueBan UserName, "ClientBan: W3XP": Exit Sub
        End Select
            
        If (Flags And &H20) = &H20 Then
            If Settings.BanSquelched = True Then: _
                QueueBan UserName, "ClientBan: Squelched": Exit Sub
        End If
    End If
    
'--------------------------------
' Stats Banning
'--------------------------------
    If Settings.StatsBanning = True Then
        Select Case Client
            Case "D2DV"
                If Len(Statstring) = 4 Then
                    If Settings.StatsD2DV Then: _
                        QueueBan UserName, "StatsBan: Open Char": Exit Sub
                End If
            Case "D2XP"
                If Len(Statstring) = 4 Then
                    If Settings.StatsD2XP Then: _
                        QueueBan UserName, "StatsBan: Open Char": Exit Sub
                End If
            Case "STAR"
                If Val(Split(Statstring, " ")(3)) = 0 Then
                    If Settings.StatsSTAR Then: _
                        QueueBan UserName, "StatsBan: 0 Wins": Exit Sub
                End If
            Case "SEXP"
                If Val(Split(Statstring, " ")(3)) = 0 Then
                    If Settings.StatsSEXP Then: _
                        QueueBan UserName, "StatsBan: 0 Wins": Exit Sub
                End If
            Case "W2BN"
                If Val(Split(Statstring, " ")(3)) = 0 Then
                    If Settings.StatsW2BN Then: _
                        QueueBan UserName, "StatsBan: 0 Wins": Exit Sub
                End If
            Case "WAR3"
                If InStr(Statstring, " ") > 0 Then
                    If Val(Left$(Split(Statstring, " ")(1), 1)) Then
                        If Settings.StatsWAR3 Then: _
                            QueueBan UserName, "StatsBan: Peon": Exit Sub
                    End If
                End If
            Case "W3XP"
                If InStr(Statstring, " ") > 0 Then
                    If Val(Left$(Split(Statstring, " ")(1), 1)) Then
                        If Settings.StatsW3XP Then: _
                            QueueBan UserName, "StatsBan: Peon": Exit Sub
                    End If
                End If
        End Select
    End If
    

'--------------------------------
' Massload Banning
'--------------------------------
    If Settings.MassloadBanning = True Then
        If Settings.MassloadNumbers = True Then
            If (InStr(UserName, "#") > 0) Or (Matches(UserName, "*#") = True) Or _
                (Matches(UserName, "*##") = True) Or (Matches(UserName, "*###") = True) Or (Matches(UserName, "*####") = True) Or _
                (CStr(Val(UserName)) = UserName) Then: _
                QueueBan UserName, "MassloadBan: Numbered": Exit Sub
        End If
        If EventID = &H2 Then
            If Settings.MassloadJoins = True Then
                Static UserTimes(5) As Long
                Static UserJoins(5) As String
                
                Dim n As Integer
                For n = 1 To 5
                    UserJoins(n) = UserJoins(n - 1)
                    UserTimes(n) = UserTimes(n - 1)
                Next n
                
                UserJoins(0) = UserName
                UserTimes(0) = GetTickCount()
                
                If (UserTimes(0) - UserTimes(5)) < 700 Then
                    For n = 0 To 5
                        QueueBan UserName, "MassloadBan: 5+ Joins"
                    Next n
                    Exit Sub
                End If
            End If
        End If
    End If
    
    If EventID = &H4 Or EventID = &H5 Then
'--------------------------------
' Phrase Banning
'--------------------------------
        If Settings.PhraseBanning = True Then
            'Custom Phrasebans ...
            Dim ph As Integer
            If UBound(Phrases()) > 0 Then
                For ph = 1 To UBound(Phrases)
                    If Matches(Message, Phrases(ph).Phrase) = True Then
                        QueueBan UserName, "PhraseBan": Exit Sub
                    End If
                Next ph
            End If
        End If

'--------------------------------
' Spam Banning
'--------------------------------
        If Settings.SpamFloodBanning = True Then
            
            Static LastTalk(2) As Long
            Static LastTalker(2) As String
            
            Dim T As Integer
            For T = 1 To 2
                LastTalk(T) = LastTalk(T - 1)
                LastTalker(T) = LastTalker(T - 1)
            Next T
            
            LastTalk(0) = GetTickCount()
            LastTalker(0) = UserName
            
            If LastTalk(0) - LastTalk(2) < 500 Then: _
                QueueBan UserName, "Floodban: Spam": Exit Sub
        End If
    End If
End Sub
