Attribute VB_Name = "modCommands"
Option Explicit

Public Function ProcessCommand(ByVal UserName As String, ByVal Message As String) As Boolean
    Dim ui As Integer, RankName As String
    ui = FindDatabaseUser(UserName)

    If (ui = 0) And Len(UserName) > 0 Then Exit Function
    RankName = GetRank(Database(ui).UserName)

    If (Len(RankName) = 0) And Len(UserName) > 0 Then Exit Function

    Dim CmdSplt() As String, CmdLoop As Integer
    If InStr(Message, ", ") > 0 Then
        CmdSplt() = Split(Message, ", ")
    Else
        ReDim CmdSplt(0)
        CmdSplt(0) = Message
    End If
    
    For CmdLoop = 0 To UBound(CmdSplt())
        Dim Splt() As String
        Splt() = Split(CmdSplt(CmdLoop), " ", 2)
        Dim I As Integer
        ProcessCommand = True

        If UBound(Splt()) = 0 Then
            Select Case LCase$(Splt(0))
                
                '-------------------------------------------------
                ' Sends bot to tray.
                '-------------------------------------------------
                Case "tray"
                    If CanDoCommand(RankName, "tray") = True Or Len(UserName) = 0 Then
                        frmTray.SendToTray
                        AddQueue "/w " & UserName & " Bot minimized to tray."
                    End If
                
                '-------------------------------------------------
                ' Hide News
                '-------------------------------------------------
                Case "hidenews", "hn"
                    If CanDoCommand(RankName, "hidenews") = True Or Len(UserName) = 0 Then
                        Settings.News = False
                        AddQueue "/w " & UserName & " Battle.Net news is now hidden."
                    End If
                
                Case "cpub"
                    If CanDoCommand(RankName, "cpub") = True Or Len(UserName) = 0 Then
                        If Config.ProductID = "WAR3" Or Config.ProductID = "W3XP" Then
                            AddQueue "/clan public"
                            AddQueue "Set clan channel to public."
                        Else
                            AddQueue "You must be on WarCraft III to change the clan channel to public."
                        End If
                    End If
                
                Case "cpriv"
                    If CanDoCommand(RankName, "cpriv") = True Or Len(UserName) = 0 Then
                        If Config.ProductID = "WAR3" Or Config.ProductID = "W3XP" Then
                            AddQueue "/clan private"
                            AddQueue "Set clan channel to private."
                        Else
                            AddQueue "You must be on WarCraft III to change the clan channel to private."
                        End If
                    End If
                
                '-------------------------------------------------
                ' Show News
                '-------------------------------------------------
                Case "shownews", "sn"
                    If CanDoCommand(RankName, "shownews") = True Or Len(UserName) = 0 Then
                        Settings.News = True
                        AddQueue "/w " & UserName & " Battle.Net news is now shown."
                    End If
                    
                '-------------------------------------------------
                ' Hide Join Leave
                '-------------------------------------------------
                Case "hidejoins", "hj"
                    If CanDoCommand(RankName, "hidejoins") = True Or Len(UserName) = 0 Then
                        Settings.JoinLeave = False
                        AddQueue "/w " & UserName & " Join, leave & here user events are now hidden."
                    End If
                    
                '-------------------------------------------------
                ' Show Join Leave
                '-------------------------------------------------
                Case "showjoins", "sj"
                    If CanDoCommand(RankName, "showjoins") = True Or Len(UserName) = 0 Then
                        Settings.JoinLeave = True
                        AddQueue "/w " & UserName & " Join, leave & here user events are now shown."
                    End If
                    
                '-------------------------------------------------
                ' Lock Window
                '-------------------------------------------------
                Case "lockwindow", "lw"
                    If CanDoCommand(RankName, "lockwindow") = True Or Len(UserName) = 0 Then
                        Settings.LockWindow = True
                        AddQueue "/w " & UserName & " Chat window is now locked."
                    End If
                
                '-------------------------------------------------
                ' Unlock Window
                '-------------------------------------------------
                Case "unlockwindow", "ulw"
                    If CanDoCommand(RankName, "unlockwindow") = True Or Len(UserName) = 0 Then
                        Settings.LockWindow = False
                        AddQueue "/w " & UserName & " Chat window is now unlocked."
                    End If
                
                Case "availableranks"
                    If CanDoCommand(RankName, "availableranks") = True Or Len(UserName) = 0 Then
                        Dim AR As Integer, strAR As String
                        For AR = 1 To UBound(Ranks())
                            strAR = strAR & Ranks(AR).Rank & ", "
                        Next AR
                        
                        If Len(strAR) > 0 Then
                            AddQueue "/w " & UserName & " Available Ranks: " & Left$(strAR, Len(strAR) - 2) & "."
                        Else
                            AddQueue "/w " & UserName & " There are no available ranks!"
                        End If
                    End If
                
                Case "rankinfo"
                    If CanDoCommand(RankName, "rankinfo") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " You must specify a rank to get info for."
                    End If
                    
                Case "rankcommands"
                    If CanDoCommand(RankName, "rankcommands") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " You must specify a rank to get commands for."
                    End If
                    
                Case "uptime"
                    If CanDoCommand(RankName, "uptime") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " System: " & TickToTime(GetTickCount()) & ", Bot: " & TickToTime(GetTickCount() - OpenTick) & ", Online: " & TickToTime(GetTickCount() - MyOnlineTime) & "."
                    End If
                    
                '-------------------------------------------------
                ' Hides the bot. No Tray Icon
                '-------------------------------------------------
                Case "hide"
                    If CanDoCommand(RankName, "hide") = True Or Len(UserName) = 0 Then
                        On Error GoTo CantHide:
                        frmMain.SetFocus
                        Unload frmTray
                        frmMain.Hide
                        AddQueue "/w " & UserName & " Bot is now hidden."
                        GoTo NextCmd:
CantHide:
                        Err = 0
                        AddQueue "/w " & UserName & " Bot is unable to be hidden right now, another form may be open."
                    End If
                
                '-------------------------------------------------
                ' Shows the bot.
                '-------------------------------------------------
                Case "unhide", "show"
                    If CanDoCommand(RankName, "unhide") = True Or Len(UserName) = 0 Then
                        On Error GoTo CantUnHide:
                        Unload frmTray
                        frmMain.Show
                        AddQueue "/w " & UserName & " Bot is no longer hidden."
                        GoTo NextCmd:
CantUnHide:
                        Err = 0
                        AddQueue "/w " & UserName & " Bot is unable to be shown right now, another form may be open."
                    End If
                    
                Case "unbanlast", "ubl"
                    If CanDoCommand(RankName, "unbanlast") = True Or Len(UserName) = 0 Then
                        If Len(LastBannedUser) > 0 Then
                            AddQueue "/unban " & LastBannedUser
                        Else
                            AddQueue "This bot has not seen any users banned yet."
                        End If
                    End If
                    
                Case "unipbanlast", "uipl"
                    If CanDoCommand(RankName, "unipbanlast") = True Or Len(UserName) = 0 Then
                        If Len(LastIgnoredUser) > 0 Then
                            AddQueue "/unignore " & LastIgnoredUser
                            AddQueue "/unban " & LastIgnoredUser
                            AddQueue "Unipbanned " & LastIgnoredUser & "."
                        Else
                            AddQueue "This bot has not ipbanned any users yet."
                        End If
                    End If
                    
                Case "unignorelast", "uil"
                    If CanDoCommand(RankName, "unignorelast") = True Or Len(UserName) = 0 Then
                        If Len(LastIgnoredUser) > 0 Then
                            AddQueue "/unignore " & LastIgnoredUser
                            AddQueue "Unignored " & LastIgnoredUser & "."
                        Else
                            AddQueue "This bot has not ignored any users yet."
                        End If
                    End If
                    
                '-------------------------------------------------
                ' ERROR: Problem with find.
                '-------------------------------------------------
                Case "whois", "find", "finduser", "search"
                    If CanDoCommand(RankName, "finduser") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " Who do you want to search for?"
                    End If
                    
                '-------------------------------------------------
                ' Send Bots Ping
                '-------------------------------------------------
                Case "ping"
                    If CanDoCommand(RankName, "ping") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " This bots ping at login was " & MyPing & "ms."
                    End If
                    
                '-------------------------------------------------
                ' ERROR: Problem with say.
                '-------------------------------------------------
                Case "say", "repeat", "copy", "send"
                    If CanDoCommand(RankName, "say") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " What do you want the bot to repeat?"
                    End If
                    
                '-------------------------------------------------
                ' Clears the queue.
                '-------------------------------------------------
                Case "cq", "scq"
                    If CanDoCommand(RankName, "cq") = True Or Len(UserName) = 0 Then
                        ClearQueue
                    End If
                    
                '-------------------------------------------------
                ' Display the users flags.
                '-------------------------------------------------
                Case "whoami", "me"
                    If CanDoCommand(RankName, "whoami") = True Or Len(UserName) = 0 Then
                        If Len(UserName) > 0 Then
                            AddQueue "/w " & UserName & " User [ " & Database(ui).UserName & " ] was added on " & Database(ui).AddedTime & " by " & Database(ui).AddedBy & " with a rank of " & RankName & "."
                        End If
                    End If
                    
                '-------------------------------------------------
                ' ERROR: Designate a user
                '-------------------------------------------------
                Case "designate", "des"
                    If CanDoCommand(RankName, "designate") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " Who do you want to designate as your heir?"
                    End If
                    
                '-------------------------------------------------
                ' ERROR: Giveops
                '-------------------------------------------------
                Case "giveops", "op"
                    If CanDoCommand(RankName, "giveops") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " Who do you want to give ops to?"
                    End If
                    
                '-------------------------------------------------
                ' Rejoin the current channel.
                '-------------------------------------------------
                Case "rejoin", "resign", "rj"
                    If CanDoCommand(RankName, "resign") = True Or Len(UserName) = 0 Then
                        frmMain.mnuRejoinChannel_Click
                    End If
                    
                '-------------------------------------------------
                ' Shows the designated user.
                '-------------------------------------------------
                Case "designated"
                    If CanDoCommand(RankName, "designated") = True Or Len(UserName) = 0 Then
                        If Len(Designated) > 0 Then
                            AddQueue Designated & " is currently designated."
                        Else
                            AddQueue "/w " & UserName & " No user is currently designated."
                        End If
                    End If

                '-------------------------------------------------
                ' ERROR: Problem with Phrase
                '-------------------------------------------------
                Case "addphrase"
                    If CanDoCommand(RankName, "addphrase") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " Invalid structure for adding a phrase, syntax is .addphrase <ban.msg>; <phrase>"
                    End If
                    
                '-------------------------------------------------
                ' Displays the current bot version.
                '-------------------------------------------------
                Case "ver", "version", "about", "bot"
                    If CanDoCommand(RankName, "version") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " " & "ShieldBot v" & GetVersion(True) & " by DDA-TriCk-E."
                    End If
                    
                Case Else
                    ProcessCommand = False
            End Select
        ElseIf UBound(Splt()) = 1 Then
            Select Case LCase$(Splt(0))
            
                '-------------------------------------------------
                ' Help
                '-------------------------------------------------
                Case "help"
                    If CanDoCommand(RankName, "help") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " Help command has been temporarily disabled."
'
'                        Dim sDescr As String, sFlags As String, sKey As String
'                        ReadCommand Splt(1), sDescr, sFlags, sKey
'
'                        If InStr(sDescr, vbCrLf) > 0 Then
'                            Dim DescrS() As String
'                            DescrS() = Split(sDescr, vbCrLf)
'
'                            If Len(UserName) = 0 Then
'                                AddChat vbCyan, sKey & " " & IIf(Len(sFlags) > 0, "(Flags: " & sFlags & "): ", "")
'                            End If
'
'                            For i = 0 To UBound(DescrS())
'                                If Len(DescrS(i)) > 0 Then
'                                    AddQueue "/w " & UserName & " " & IIf(Len(sFlags) > 0, "(Flags: " & sFlags & "): ", "") & DescrS(i)
'                                End If
'                            Next i
'                        Else
'                            AddQueue "/w " & UserName & " " & sDescr
'                        End If
                    End If
                    
                Case "rankinfo"
                    If CanDoCommand(RankName, "rankinfo") = True Or Len(UserName) = 0 Then
                        Dim RI As Integer
                        RI = RankIndex(Splt(1))
                        
                        If RI = 0 Then
                            AddQueue "/w " & UserName & " That rank does not exist, please type .availableranks for a list of ranks."
                            GoTo NextCmd:
                        Else
                            AddQueue "/w " & UserName & " Rank: " & Ranks(RI).Rank & " or " & Ranks(RI).Alias & ", Description: " & Ranks(RI).Description & ". Friend: " & IIf(Ranks(RI).Friend, "Y", "N") & ", Banned: " & IIf(Ranks(RI).Banned, "Y", "N") & ", Ignored: " & IIf(Ranks(RI).Ignored, "Y", "N") & "."
                        End If
                    End If
                    
                Case "invite"
                    If CanDoCommand(RankName, "invite") = True Or Len(UserName) = 0 Then
                        If Config.ProductID = "WAR3" Or Config.ProductID = "W3XP" Then
                            AddQueue "/w " & UserName & " Sent invite to " & Splt(1) & " to join clan " & MyClanname & "."
                            Connection.Send0x77 Splt(1)
                        End If
                    End If
                
                Case "removemember"
                    If CanDoCommand(RankName, "removemember") = True Or Len(UserName) = 0 Then
                        If Config.ProductID = "WAR3" Or Config.ProductID = "W3XP" Then
                            AddQueue "/w " & UserName & " Sent request to remove member: " & Splt(1) & "."
                            Connection.Send0x78 Splt(1)
                        End If
                    End If
                
                Case "setchannel"
                    If CanDoCommand(RankName, "setchannel") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " Successfully changed home channel."
                        Config.Channel = Splt(1)
                    End If
                    
                Case "setusername"
                    If CanDoCommand(RankName, "setusername") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " Successfully changed username."
                        Config.UserName = Splt(1)
                    End If
                    
                Case "setpassword"
                    If CanDoCommand(RankName, "setpassword") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " Successfully changed password."
                        Config.Password = Splt(1)
                    End If
                
                Case "setproduct"
                    If CanDoCommand(RankName, "setproduct") = True Or Len(UserName) = 0 Then
                        Select Case UCase$(Splt(1))
                            Case "D2XP", "D2DV", "W2BN", "WAR3", "W3XP", "SEXP", "STAR"
                                AddQueue "/w " & UserName & " Successfully changed product."
                                Config.ProductID = UCase$(Splt(1))
                            Case Else
                                AddQueue "/w " & UserName & " Invalid product ID."
                        End Select
                    End If
                
                Case "setcdkey"
                    If CanDoCommand(RankName, "setcdkey") = True Or Len(UserName) = 0 Then
                        Select Case Len(Splt(1))
                            Case 13, 16, 26
                                AddQueue "/w " & UserName & " Successfully changed cdkey."
                                Config.CDKey = UCase$(Splt(1))
                            Case Else
                                AddQueue "/w " & UserName & " Invalid cdkey length."
                        End Select
                    End If
                
                Case "setcdkeyex"
                    If CanDoCommand(RankName, "setcdkeyex") = True Or Len(UserName) = 0 Then
                        Select Case Len(Splt(1))
                            Case 13, 16, 26
                                AddQueue "/w " & UserName & " Successfully changed expansion cdkey."
                                Config.ExpansionCdkey = UCase$(Splt(1))
                            Case Else
                                AddQueue "/w " & UserName & " Invalid expansion cdkey length."
                        End Select
                    End If
                
                
                
                Case "setserver"
                    If CanDoCommand(RankName, "setserver") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " Successfully changed server."
                        Config.Server = Splt(1)
                    End If
                
                Case "settrigger"
                    If CanDoCommand(RankName, "settrigger") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " Successfully changed trigger to: " & Left$(Splt(1), 1) & ""
                        Config.Trigger = Left$(Splt(1), 1)
                    End If
                
                Case "setpeon"
                    If CanDoCommand(RankName, "setpeon") = True Or Len(UserName) = 0 Then
                        If Config.ProductID = "WAR3" Or Config.ProductID = "W3XP" Then
                            AddQueue "/w " & UserName & " Sent request to change clan members rank."
                            Connection.Send0x7A Splt(1), &H1
                        End If
                    End If
                
                Case "setgrunt"
                    If CanDoCommand(RankName, "setgrunt") = True Or Len(UserName) = 0 Then
                        If Config.ProductID = "WAR3" Or Config.ProductID = "W3XP" Then
                            AddQueue "/w " & UserName & " Sent request to change clan members rank."
                            Connection.Send0x7A Splt(1), &H2
                        End If
                    End If
                
                Case "setshaman"
                    If CanDoCommand(RankName, "setshaman") = True Or Len(UserName) = 0 Then
                        If Config.ProductID = "WAR3" Or Config.ProductID = "W3XP" Then
                            AddQueue "/w " & UserName & " Sent request to change clan members rank."
                            Connection.Send0x7A Splt(1), &H3
                        End If
                    End If
                
                Case "ddp"
                    If CanDoCommand(RankName, "ddp") = True Or Len(UserName) = 0 Then
                        Dim Shamans As New Collection, D As Integer, shCount As Integer
                        For D = 1 To UBound(ClanMembers())
                            If ClanMembers(D).Rank = &H3 Then
                                Shamans.Add ClanMembers(D).UserName
                                Connection.Send0x7A ClanMembers(D).UserName, &H2
                            End If
                        Next D
                        
                        Do Until shCount = 0
                            For D = 1 To UBound(ClanMembers())
                                If ClanMembers(D).Rank = &H3 Then
                                    shCount = shCount = 1
                                    GoTo skiploop:
                                End If
                            Next D
                            shCount = 0
skiploop:
                        Loop
                        
                        Connection.Send0x0E "/designate " & Splt(1)
                        With Packet
                            .SendPacket &H10
                            .InsertDWORD &H2
                            .InsertCSTR MyChannel
                            .SendPacket &HC
                        End With
                        
                        Sleep 2000
                        
                        For D = 1 To Shamans.Count
                            If Len(Shamans.Item(D)) > 0 Then
                                Connection.Send0x7A Shamans(D), &H3
                            End If
                        Next D
                    End If
                
                Case "unban", "u"
                    If CanDoCommand(RankName, "unban") = True Or Len(UserName) = 0 Then
                        If InStr(Splt(1), "*") > 0 Then
                            Dim ubFound As Boolean, ul As Integer
                            For ul = 0 To UBound(Banned())
                                If Matches(Banned(ul).UserName, Splt(1)) = True Then
                                    AddQueue "/unban " & StructureName(Banned(ul).UserName, "STAR")
                                    ubFound = True
                                End If
                            Next ul
                            If ubFound = False Then
                                AddQueue "/unban " & Splt(1)
                            End If
                        Else
                            AddQueue "/unban " & Splt(1)
                        End If
                    End If
                
                Case "rankcommands"
                    If CanDoCommand(RankName, "rankcommands") = True Or Len(UserName) = 0 Then
                        Dim RC As Integer
                        RC = RankIndex(Splt(1))
                        
                        If RC = 0 Then
                            AddQueue "/w " & UserName & " That rank does not exist, please type .availableranks for a list of ranks."
                            GoTo NextCmd:
                        Else
                            AddQueue "/w " & UserName & " Rank: " & Ranks(RC).Rank & ", Commands: " & Replace$(Ranks(RC).Commands, ",", ", ") & "."
                        End If
                    End If
                    
                Case "giveops", "op"
                    If CanDoCommand(RankName, "giveops") = True Or Len(UserName) = 0 Then
                        AddQueue "/designate " & Splt(1)
                        AddQueue "/resign"
                    End If
                
                Case "designate", "des"
                    If CanDoCommand(RankName, "designate") = True Or Len(UserName) = 0 Then
                        AddQueue "/designate " & Splt(1)
                    End If
                    
                Case "join", "j", "channel"
                    If CanDoCommand(RankName, "join") = True Or Len(UserName) = 0 Then
                        AddQueue "/join " & Splt(1)
                    End If
                
                Case "ping"
                    If CanDoCommand(RankName, "ping") = True Or Len(UserName) = 0 Then
                        Command_Ping UserName, Splt(1)
                    End If
                
                '-------------------------------------------------
                ' Ban a user or users in the channel.
                '-------------------------------------------------
                Case "ban", "b"
                    If CanDoCommand(RankName, "ban") = True Or Len(UserName) = 0 Then
                        Command_Ban UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Quickly bans a single user in the channel.
                '-------------------------------------------------
                Case "qban", "qb"
                    If CanDoCommand(RankName, "qban") = True Or Len(UserName) = 0 Then
                        Connection.Send0x0E "/ban " & Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Quickly kicks a single user in the channel.
                '-------------------------------------------------
                Case "qkick", "qk"
                    If CanDoCommand(RankName, "qkick") = True Or Len(UserName) = 0 Then
                        Connection.Send0x0E "/kick " & Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Quickly ignores a single user in the channel.
                '-------------------------------------------------
                Case "qign", "qi"
                    If CanDoCommand(RankName, "qign") = True Or Len(UserName) = 0 Then
                        Connection.Send0x0E "/ignore " & Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Quickly unignores a single user in the channel.
                '-------------------------------------------------
                Case "qunign", "qui"
                    If CanDoCommand(RankName, "qunign") = True Or Len(UserName) = 0 Then
                        Connection.Send0x0E "/unignore " & Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Quickly unignores a single user in the channel.
                '-------------------------------------------------
                Case "qunban", "qu"
                    If CanDoCommand(RankName, "qunban") = True Or Len(UserName) = 0 Then
                        Connection.Send0x0E "/unban " & Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Kick a user or users in the channel.
                '-------------------------------------------------
                Case "kick", "k"
                    If CanDoCommand(RankName, "kick") = True Or Len(UserName) = 0 Then
                        Command_Kick UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Unignore a user in the channel.
                '-------------------------------------------------
                Case "unignore", "ui"
                    If CanDoCommand(RankName, "unignore") = True Or Len(UserName) = 0 Then
                        AddQueue "/unignore " & Splt(1)
                    End If
                
                '-------------------------------------------------
                ' Ignore a user or users in the channel.
                '-------------------------------------------------
                Case "ignore", "i"
                    If CanDoCommand(RankName, "ignore") = True Or Len(UserName) = 0 Then
                        Command_Ignore UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' IPBan a user or users in the channel.
                '-------------------------------------------------
                Case "ipban", "ipb"
                    If CanDoCommand(RankName, "ipban") = True Or Len(UserName) = 0 Then
                        Command_IpBan UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' IPBan a user or users in the channel.
                '-------------------------------------------------
                Case "unipban", "uipb"
                    If CanDoCommand(RankName, "unipban") = True Or Len(UserName) = 0 Then
                        If InStr(Splt(1), "*") > 0 Then
                            Dim uibFound As Boolean, uil As Integer
                            For uil = 0 To UBound(Banned())
                                If Matches(Banned(uil).UserName, Splt(1)) = True Then
                                    AddQueue "/unban " & StructureName(Banned(uil).UserName, "STAR")
                                    AddQueue "/unignore " & StructureName(Banned(uil).UserName, "STAR")
                                    uibFound = True
                                End If
                            Next uil
                            If uibFound = False Then
                                AddQueue "/unban " & Splt(1)
                                AddQueue "/unignore " & Splt(1)
                            End If
                        Else
                            AddQueue "/unban " & Splt(1)
                            AddQueue "/unignore " & Splt(1)
                        End If
                    End If
                    
                '-------------------------------------------------
                ' Sweep A Channel
                '-------------------------------------------------
                Case "sweep"
                    If CanDoCommand(RankName, "sweep") = True Or Len(UserName) = 0 Then
                        AddQueue "/who " & Splt(1)
                        SweepBan = True
                        SweepIgnore = False
                    End If
                    
                '-------------------------------------------------
                ' IP Sweep A Channel
                '-------------------------------------------------
                Case "ipsweep"
                    If CanDoCommand(RankName, "ipsweep") = True Or Len(UserName) = 0 Then
                        AddQueue "/who " & Splt(1)
                        SweepBan = True
                        SweepIgnore = True
                    End If
                    
                '-------------------------------------------------
                ' Add a clan to the clanban list.
                '-------------------------------------------------
                Case "addclan"
                    If CanDoCommand(RankName, "addclan") = True Or Len(UserName) = 0 Then
                        Command_AddClan UserName, Splt(1)
                    End If
'
'                '-------------------------------------------------
'                ' Add mail for a certain user.
'                '-------------------------------------------------
'                Case "addmail", "mail"
'                    If CanDoCommand(RankName, "addmail") = True Or Len(UserName) = 0 Then
'                        If InStr(Splt(1), " ") > 0 Then
'                            Dim MailSplt() As String
'                            MailSplt() = Split(Splt(1), " ", 2)
'                            AddMail MailSplt(0), MailSplt(1), UserName
'                            AddQueue "/w " & UserName & " Successfully added mail for " & MailSplt(0) & "."
'                        Else
'                            AddQueue "/w " & UserName & " Add mail command must be formatted as .addmail <recipient> <message>"
'                        End If
'                    End If
'
'                '-------------------------------------------------
'                ' Clear mail for a certain user.
'                '-------------------------------------------------
'                Case "clearmail"
'                    If CanDoCommand(RankName, "clearmail") = True Or Len(UserName) = 0 Then
'                        If HasMail(Splt(1)) = True Then
'                            'ClearMail  Splt(1)
'                            AddQueue "/w " & UserName & " Cleared all mail for that user."
'                        Else
'                            AddQueue "/w " & UserName & " That user does not have any mail."
'                        End If
'                    End If
'
                '-------------------------------------------------
                ' Add a phrase to the database.
                '-------------------------------------------------
                Case "addphrase"
                    If CanDoCommand(RankName, "addphrase") = True Or Len(UserName) = 0 Then
                        Command_AddPhrase UserName, Splt(1)
                    End If
                
                '-------------------------------------------------
                ' Delete phrase from phrase bans list.
                '-------------------------------------------------
                Case "delphrase"
                    If CanDoCommand(RankName, "delphrase") = True Or Len(UserName) = 0 Then
                        Command_DelPhrase UserName, Splt(1)
                    End If
                
                '-------------------------------------------------
                ' Delete phrase from phrase bans list.
                '-------------------------------------------------
                Case "findphrase"
                    If CanDoCommand(RankName, "findphrase") = True Or Len(UserName) = 0 Then
                        Command_FindPhrase UserName, Splt(1)
                    End If
                
                '-------------------------------------------------
                ' Delete phrase from phrase bans list.
                '-------------------------------------------------
                Case "findclan"
                    If CanDoCommand(RankName, "findclan") = True Or Len(UserName) = 0 Then
                        Command_FindClan UserName, Splt(1)
                    End If
                
                '-------------------------------------------------
                ' Delete clan from clan bans list.
                '-------------------------------------------------
                Case "delclan"
                    If CanDoCommand(RankName, "delclan") = True Or Len(UserName) = 0 Then
                        Command_DelClan UserName, Splt(1)
                    End If
                
                '-------------------------------------------------
                ' Add a user to the database.
                '-------------------------------------------------
                Case "add", "adduser"
                    If CanDoCommand(RankName, "adduser") = True Or Len(UserName) = 0 Then
                        Command_AddUser UserName, Splt(1)
                    End If
                
                Case "lockdown", "ld"
                    If CanDoCommand(RankName, "lockdown") = True Or Len(UserName) = 0 Then
                        Command_Mode_LockDown UserName, Splt(1)
                    End If
                
                '-------------------------------------------------
                ' Ban Rotation
                '-------------------------------------------------
                Case "banrotation", "br"
                    If CanDoCommand(RankName, "banrotation") = True Or Len(UserName) = 0 Then
                        Command_Mode_BanRotation UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Safelist Checking
                '-------------------------------------------------
                Case "whisperback", "wb"
                    If CanDoCommand(RankName, "whisperback") = True Or Len(UserName) = 0 Then
                        Command_Mode_WhisperBack UserName, Splt(1)
                    End If
                
                '-------------------------------------------------
                ' Safelist Checking
                '-------------------------------------------------
                Case "safelist", "sl"
                    If CanDoCommand(RankName, "safelist") = True Or Len(UserName) = 0 Then
                        Command_Mode_SafelistChecking UserName, Splt(1)
                    End If
                
                '-------------------------------------------------
                ' Clan Banning
                '-------------------------------------------------
                Case "clanbanning", "cl"
                    If CanDoCommand(RankName, "clanbanning") = True Or Len(UserName) = 0 Then
                        Command_Mode_ClanBanning UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Massload Banning
                '-------------------------------------------------
                Case "massloadbanning", "mlb"
                    If CanDoCommand(RankName, "massloadbanning") = True Or Len(UserName) = 0 Then
                        Command_Mode_MassloadBanning UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Spam Banning
                '-------------------------------------------------
                Case "spambanning", "spb"
                    If CanDoCommand(RankName, "spambanning") = True Or Len(UserName) = 0 Then
                        Command_Mode_SpamFloodBanning UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Phrase Banning
                '-------------------------------------------------
                Case "phrasebanning", "phb"
                    If CanDoCommand(RankName, "phrasebanning") = True Or Len(UserName) = 0 Then
                        Command_Mode_PhraseBanning UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Ping Banning
                '-------------------------------------------------
                Case "pingbanning", "pb"
                    If CanDoCommand(RankName, "pingbanning") = True Or Len(UserName) = 0 Then
                        Command_Mode_PingBanning UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Stats Banning
                '-------------------------------------------------
                Case "statsbanning", "sb"
                    If CanDoCommand(RankName, "statsbanning") = True Or Len(UserName) = 0 Then
                        Command_Mode_StatsBanning UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Idle Kicking
                '-------------------------------------------------
                Case "idlekicking", "ik"
                    If CanDoCommand(RankName, "idlekicking") = True Or Len(UserName) = 0 Then
                        Command_Mode_IdleKicking UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Flood Banning
                '-------------------------------------------------
                Case "floodbanning", "fb"
                    If CanDoCommand(RankName, "floodbanning") = True Or Len(UserName) = 0 Then
                        Command_Mode_FloodBanning UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Outsider Clan Banning
                '-------------------------------------------------
                Case "outsiderbanning", "osb"
                    If CanDoCommand(RankName, "outsiderbanning") = True Or Len(UserName) = 0 Then
                        Command_Mode_OutsiderClanBan UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Client Banning
                '-------------------------------------------------
                Case "clientbanning", "cb"
                    If CanDoCommand(RankName, "clientbanning") = True Or Len(UserName) = 0 Then
                        Command_Mode_ClientBanning UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Remove a user from the database.
                '-------------------------------------------------
                Case "del", "deluser"
                    If CanDoCommand(RankName, "deluser") = True Or Len(UserName) = 0 Then
                        Command_DelUser UserName, Splt(1)
                    End If
                    
                '-------------------------------------------------
                ' Find a specific user in the database.
                '-------------------------------------------------
                Case "whois"
                    If CanDoCommand(RankName, "whois") = True Or Len(UserName) = 0 Then
                        Dim whFind As Integer
                        whFind = FindDatabaseUser(Splt(1))
                        
                        If whFind > 0 Then
                            AddQueue "/w " & UserName & " User [ " & Database(whFind).UserName & " ] was added on " & Database(whFind).AddedTime & " by " & Database(whFind).AddedBy & " with a rank of " & Database(whFind).Rank & "."
                        Else
                            AddQueue "/w " & UserName & " That user was not found."
                        End If
                    End If
                
                '-------------------------------------------------
                ' Find a user or users in the database.
                '-------------------------------------------------
                Case "find", "finduser", "search"
                    If CanDoCommand(RankName, "finduser") = True Or Len(UserName) = 0 Then
                        Command_FindUser UserName, Splt(1)
                    End If
                
                '-------------------------------------------------
                ' Say a message.
                '-------------------------------------------------
                Case "say", "repeat", "send", "copy"
                    If CanDoCommand(RankName, "say") = True Or Len(UserName) = 0 Then
                        If Left$(Splt(1), 1) = "/" Then
                            AddQueue "Cannot send text starting with /."
                        Else
                            AddQueue Splt(1)
                        End If
                    End If
                    
                '-------------------------------------------------
                ' ERROR: Rejoin the current channel.
                '-------------------------------------------------
                Case "rejoin", "resign", "rj"
                    If CanDoCommand(RankName, "resign") = True Or Len(UserName) = 0 Then
                        AddQueue "/w " & UserName & " The rejoin command does not require a channel name, use join instead."
                    End If
                Case Else
                    ProcessCommand = False
            End Select
        End If
NextCmd:
    Next CmdLoop
End Function

Public Sub ReadCommand(ByVal sCommand As String, ByRef Description As String, ByRef Flags As String, ByRef sKey As String)
    On Error GoTo NoCommandList:
    Open App.Path & "\ShieldBot.Help.Command.xml" For Input As #1
        Dim bItem As Boolean, bCommand As Boolean
        Dim strLine As String
        
        Do Until EOF(1)
            Line Input #1, strLine
            
            Dim strTemp As String
            If strLine = "<item>" Then
                bItem = True
            ElseIf strLine = "</item>" Then
                bItem = False
                bCommand = False
            Else
                If (InStr(strLine, "<key>") > 0) And (bItem = True) Then
                    If InStr(LCase$(strLine), LCase$(sCommand)) > 0 Then
                        strTemp = Split(strLine, "<key>")(1)
                        strTemp = Split(strTemp, "</key>")(0)
                        
                        If InStr(strTemp, ",") > 0 Then
                            Dim I As Integer, strLoop() As String
                            strLoop = Split(strTemp, ",")
                            For I = 0 To UBound(strLoop)
                                If LCase(strLoop(I)) = LCase$(sCommand) Then
                                    bCommand = True
                                    sKey = strTemp
                                    Exit For
                                End If
                            Next I
                        Else
                            If LCase$(strTemp) = LCase$(sCommand) Then
                                bCommand = True
                                sKey = strTemp
                            End If
                        End If
                    End If
                    If InStr(LCase$(strLine), "<key>description</key>") > 0 Then
                        If bCommand = True And bItem = True Then
                            strTemp = Split(strLine, "<value>")(1)
                            strTemp = Split(strTemp, "</value>")(0)
                        
                            Description = Description & strTemp & vbCrLf
                        End If
                    ElseIf InStr(LCase$(strLine), "<key>flag</key>") > 0 Then
                        If bCommand = True And bItem = True Then
                            strTemp = Split(strLine, "<value>")(1)
                            strTemp = Split(strTemp, "</value>")(0)
                        
                            Flags = strTemp
                        End If
                    End If
                End If
            End If
        Loop
    Close #1
    If Len(Description) = 0 Then
        Description = "Command not found!"
    End If
    Exit Sub
NoCommandList:
    Close #1
    Description = "ShieldBot.Help.Command.xml is missing!"
End Sub

Private Sub Command_Ping(ByVal UserName As String, ByVal Message As String)
    Dim I As Integer
    Message = LCase$(Message)
    If InStr(Message, "*") > 1 Then
        For I = 1 To UBound(Users())
            If Matches(Users(I).ProperUsername, Message) = True Then
                AddQueue "/w " & UserName & " " & Users(I).ProperUsername & "'s ping at login was " & Users(I).Ping & "ms."
            End If
        Next I
    Else
        For I = 1 To UBound(Users())
            If LCase$(Users(I).ProperUsername) = Message Then
                AddQueue "/w " & UserName & " " & Users(I).ProperUsername & "'s ping at login was " & Users(I).Ping & "ms."
            End If
        Next I
    End If
End Sub

Private Sub Command_Ban(ByVal UserName As String, ByVal Message As String)
    Dim I As Integer, db As Integer, sMsg() As String
    
    If InStr(Message, " ") > 0 Then
        sMsg() = Split(Message, " ", 2)
    Else
        ReDim sMsg(0)
        sMsg(0) = Message
    End If
    
    If InStr(sMsg(0), "*") > 0 Then
        For I = 1 To UBound(Users())
            Dim banFound As Boolean
            If Matches(Users(I).ProperUsername, sMsg(0)) = True Then
                banFound = True
                db = FindDatabaseUser(Users(I).ProperUsername)
                If db > 0 Then
                    If Ranks(RankIndex(Database(db).Rank)).Friend = False Then
                        If UBound(sMsg) = 1 Then
                            QueueBan Users(I).ProperUsername, sMsg(1)
                        Else
                            QueueBan Users(I).ProperUsername
                        End If
                    End If
                Else
                    If UBound(sMsg) = 1 Then
                        QueueBan Users(I).ProperUsername, sMsg(1)
                    Else
                        QueueBan Users(I).ProperUsername
                    End If
                End If
            End If
        Next I
        If banFound = False Then
            If UBound(sMsg) = 1 Then
                QueueBan sMsg(0), sMsg(1)
            Else
                QueueBan sMsg(0)
            End If
        End If
    Else
        For I = 1 To UBound(Users())
            If LCase$(Users(I).ProperUsername) = LCase$(sMsg(0)) Then
                db = FindDatabaseUser(Users(I).ProperUsername)
                If db > 0 Then
                    If Ranks(RankIndex(Database(db).Rank)).Friend = False Then
                        If UBound(sMsg) = 1 Then
                            QueueBan sMsg(0), sMsg(1)
                        Else
                            QueueBan sMsg(0)
                        End If
                    End If
                Else
                    If UBound(sMsg) = 1 Then
                        QueueBan sMsg(0), sMsg(1)
                    Else
                        QueueBan sMsg(0)
                    End If
                End If
            End If
        Next I
        If db = 0 Then
            If UBound(sMsg) = 1 Then
                QueueBan sMsg(0), sMsg(1)
            Else
                QueueBan sMsg(0)
            End If
        End If
            
    End If
End Sub
Private Sub Command_IpBan(ByVal UserName As String, ByVal Message As String)
    Dim I As Integer, db As Integer, sMsg() As String
    
    If InStr(Message, " ") > 0 Then
        sMsg() = Split(Message, " ", 2)
    Else
        ReDim sMsg(0)
        sMsg(0) = Message
    End If
    
    If InStr(sMsg(0), "*") > 0 Then
        For I = 1 To UBound(Users())
            Dim banFound As Boolean
            If Matches(Users(I).ProperUsername, sMsg(0)) = True Then
                banFound = True
                db = FindDatabaseUser(Users(I).ProperUsername)
                If db > 0 Then
                    If Ranks(RankIndex(Database(db).Rank)).Friend = False Then
                        If UBound(sMsg) = 1 Then
                            QueueBan Users(I).ProperUsername, sMsg(1), "ban"
                            QueueBan Users(I).ProperUsername, , "ignore"
                        Else
                            QueueBan Users(I).ProperUsername, , "ban"
                            QueueBan Users(I).ProperUsername, , "ignore"
                        End If
                    End If
                Else
                    If UBound(sMsg) = 1 Then
                        QueueBan Users(I).ProperUsername, sMsg(1), "ban"
                        QueueBan Users(I).ProperUsername, , "ignore"
                    Else
                        QueueBan Users(I).ProperUsername, , "ban"
                        QueueBan Users(I).ProperUsername, , "ignore"
                    End If
                End If
            End If
        Next I
        If banFound = False Then
            If UBound(sMsg) = 1 Then
                QueueBan sMsg(0), sMsg(1), "ban"
                QueueBan sMsg(0), , "ignore"
            Else
                QueueBan sMsg(0), , "ban"
                QueueBan sMsg(0), , "ignore"
            End If
        End If
    Else
        For I = 1 To UBound(Users())
            If LCase$(Users(I).ProperUsername) = LCase$(sMsg(0)) Then
                db = FindDatabaseUser(Users(I).ProperUsername)
                If db > 0 Then
                    If Ranks(RankIndex(Database(db).Rank)).Friend = False Then
                        If UBound(sMsg) = 1 Then
                            QueueBan sMsg(0), sMsg(1), "ban"
                            QueueBan sMsg(0), , "ignore"
                        Else
                            QueueBan sMsg(0), , "ban"
                            QueueBan sMsg(0), , "ignore"
                        End If
                    End If
                Else
                    If UBound(sMsg) = 1 Then
                        QueueBan sMsg(0), sMsg(1), "ban"
                        QueueBan sMsg(0), , "ignore"
                    Else
                        QueueBan sMsg(0), , "ban"
                        QueueBan sMsg(0), , "ignore"
                    End If
                End If
            End If
        Next I
        If db = 0 Then
            If UBound(sMsg) = 1 Then
                QueueBan sMsg(0), sMsg(1), "ban"
                QueueBan sMsg(0), , "ignore"
            Else
                QueueBan sMsg(0), , "ban"
                QueueBan sMsg(0), , "ignore"
            End If
        End If
    End If
End Sub
Private Sub Command_Kick(ByVal UserName As String, ByVal Message As String)
    Dim I As Integer, db As Integer, sMsg() As String
    
    If InStr(Message, " ") > 0 Then
        sMsg() = Split(Message, " ", 2)
    Else
        ReDim sMsg(0)
        sMsg(0) = Message
    End If
    
    If InStr(sMsg(0), "*") > 0 Then
        For I = 1 To UBound(Users())
            Dim banFound As Boolean
            If Matches(Users(I).ProperUsername, sMsg(0)) = True Then
                banFound = True
                db = FindDatabaseUser(Users(I).ProperUsername)
                If db > 0 Then
                    If Ranks(RankIndex(Database(db).Rank)).Friend = False Then
                        If UBound(sMsg) = 1 Then
                            QueueBan Users(I).ProperUsername, sMsg(1), "kick"
                        Else
                            QueueBan Users(I).ProperUsername, , "kick"
                        End If
                    End If
                Else
                    If UBound(sMsg) = 1 Then
                        QueueBan Users(I).ProperUsername, sMsg(1), "kick"
                    Else
                        QueueBan Users(I).ProperUsername, , "kick"
                    End If
                End If
            End If
        Next I
        If banFound = False Then
            If UBound(sMsg) = 1 Then
                QueueBan sMsg(0), sMsg(1), "kick"
            Else
                QueueBan sMsg(0), , "kick"
            End If
        End If
    Else
        For I = 1 To UBound(Users())
            If LCase$(Users(I).ProperUsername) = LCase$(sMsg(0)) Then
                db = FindDatabaseUser(Users(I).ProperUsername)
                If db > 0 Then
                    If Ranks(RankIndex(Database(db).Rank)).Friend = False Then
                        If UBound(sMsg) = 1 Then
                            QueueBan sMsg(0), sMsg(1), "kick"
                        Else
                            QueueBan sMsg(0), , "kick"
                        End If
                    End If
                Else
                    If UBound(sMsg) = 1 Then
                        QueueBan sMsg(0), sMsg(1), "kick"
                    Else
                        QueueBan sMsg(0), , "kick"
                    End If
                End If
            End If
        Next I
        If db = 0 Then
            If UBound(sMsg) = 1 Then
                QueueBan sMsg(0), sMsg(1), "kick"
            Else
                QueueBan sMsg(0), , "kick"
            End If
        End If
    End If
End Sub
Private Sub Command_Ignore(ByVal UserName As String, ByVal Message As String)
    Dim I As Integer, db As Integer, sCount As Integer
    
    If InStr(Message, " ") > 0 Then
        AddQueue "/w " & UserName & " The ignore command does not need a message."
        Exit Sub
    End If
    
    If InStr(Message, "*") > 0 Then
        For I = 1 To UBound(Users())
            Dim igFound As Boolean
            If Matches(Users(I).ProperUsername, Message) = True Then
                igFound = True
                db = FindDatabaseUser(Users(I).ProperUsername)
                If db > 0 Then
                    If Ranks(RankIndex(Database(db).Rank)).Friend = False Then
                        QueueBan Users(I).ProperUsername, , "ignore"
                        sCount = sCount + 1
                    End If
                Else
                    QueueBan Users(I).ProperUsername, , "ignore"
                    sCount = sCount + 1
                End If
            End If
        Next I
        If igFound = False Then
            QueueBan Message, , "ignore"
        End If
        
        If sCount > 0 Then
            AddQueue "Ignored a total of " & sCount & " users."
        End If
    Else
        For I = 1 To UBound(Users())
            If LCase$(Users(I).ProperUsername) = LCase$(Message) Then
                db = FindDatabaseUser(Users(I).ProperUsername)
                If db > 0 Then
                    If Ranks(RankIndex(Database(db).Rank)).Friend = False Then
                        QueueBan Users(I).ProperUsername, , "ignore"
                    End If
                Else
                    QueueBan Users(I).ProperUsername, , "ignore"
                End If
            End If
        Next I
        If db = 0 Then
            QueueBan Message, , "ignore"
        End If
    End If
End Sub
Private Sub Command_FindUser(ByVal UserName As String, ByVal Message As String)
    Dim TmpStr As String, TmpCnt As Integer, TmpFound As Boolean
    Dim I As Integer
    For I = 1 To UBound(Database())
        If Matches(Database(I).UserName, Message) Then
            TmpStr = TmpStr & Database(I).UserName & " (" & Database(I).Rank & "), "
            TmpCnt = TmpCnt + 1
            TmpFound = True
            GoTo NextI:
        End If
        
        If LCase$(Database(I).UserName) = LCase$(Message) Then
            TmpStr = TmpStr & Database(I).UserName & " (" & Database(I).Rank & "), "
            TmpCnt = TmpCnt + 1
            TmpFound = True
        End If
NextI:
        If TmpCnt >= 4 Then
            AddQueue "/w " & UserName & " User(s) found: " & TmpStr
            TmpStr = vbNullString
            TmpCnt = 0
        End If
    Next I
    If TmpCnt > 0 Then
        AddQueue "/w " & UserName & " User(s) found: " & TmpStr
        TmpStr = vbNullString
        TmpCnt = 0
    End If
    If TmpFound = False Then
        AddQueue "/w " & UserName & " No users found matching request."
    End If
End Sub
Private Sub Command_AddClan(ByVal UserName As String, ByVal Message As String)
    If Len(Message) > 1 Or Len(Message) < 5 Then
        If IsAlphaNumeric(Message) = True Then
            Dim typClan As tClanBan
            typClan.AddedBy = UserName
            typClan.AddedTime = Date & ", " & Time
            typClan.Clan = Message
            AddClanBan typClan
            AddQueue "/w " & UserName & " Successfully added clan ban."
        Else
            AddQueue "/w " & UserName & " Clan ban is not alphanumeric, must contain a-z, A-Z or 0-9."
        End If
    Else
        AddQueue "/w " & UserName & " Clan ban length is invalid, must be between 2, 3 or 4 characters in length."
    End If
End Sub

Private Sub Command_AddPhrase(ByVal UserName As String, ByVal Message As String)
    If InStr(Message, "*") > 0 Then
        Dim phFound As Boolean, phPhrase As tPhrase, I As Integer
        For I = 0 To UBound(Phrases())
            If StrComp(Phrases(I).Phrase, Message, vbTextCompare) = 0 Then
                phFound = True
                AddQueue "/w " & UserName & " Phrase already exists in the database."
                Exit Sub
            End If
        Next I
        
        If phFound = False Then
            With phPhrase
                .AddedBy = UserName
                .Phrase = Message
            End With
            AddPhrase phPhrase
            AddQueue "/w " & UserName & " Successfully added phrase to the database."
        End If
    Else
        AddQueue "/w " & UserName & " Phrase must contain the asterisk wildcard (*)."
    End If
End Sub

Private Sub Command_AddUser(ByVal UserName As String, ByVal Message As String)
    Dim dbUser As String, dbRank As String, RI As Integer, URI As Integer
    Dim newUser As tDatabase
    
    If InStr(Message, " ") > 0 Then
        dbUser = Split(Message, " ")(0)
        dbRank = Split(Message, " ")(1)
        RI = RankIndex(dbRank)
        URI = RankIndex(Database(FindDatabaseUser(UserName)).Rank)
        
        If Len(dbUser) < 2 Then
            AddQueue "/w " & UserName & " Username length is invalid."
            Exit Sub
        End If
        
        If RI = 0 Then
            AddQueue "/w " & UserName & " Invalid rank stated, please type .availableranks for a list of ranks."
            Exit Sub
        End If
        If URI = 0 And Len(UserName) > 0 Then Exit Sub
        
        If Len(UserName) = 0 Then
            With newUser
                .AddedBy = UserName
                .Rank = Ranks(RI).Rank
                .UserName = dbUser
            End With
            If AddDatabaseUser(newUser) = True Then
                AddQueue "/w " & UserName & " Added " & dbUser & " to the database with a rank of " & Ranks(RI).Rank & "."
            Else
                AddQueue "/w " & UserName & " " & dbUser & " already exists in the database."
            End If
        Else
            ' Search if the Users Rank can add the Rank indicated.
            If InStr(Ranks(URI).CanAddRanks, ",") > 0 Then
                Dim Splt() As String, I As Integer, Added As Boolean
                Splt = Split(Ranks(URI).CanAddRanks, ",")
                For I = 0 To UBound(Splt())
                    If Len(Splt(I)) > 0 Then
                        If LCase$(Trim$(Splt(I))) = LCase$(Ranks(RI).Rank) Or _
                            LCase$(Trim$(Splt(I))) = LCase$(Ranks(RI).Alias) Then
                            ' Add user
                            With newUser
                                .AddedBy = UserName
                                .Rank = Ranks(RI).Rank
                                .UserName = dbUser
                            End With
                            If AddDatabaseUser(newUser) = True Then
                                AddQueue "/w " & UserName & " Added " & dbUser & " to the database with a rank of " & Ranks(RI).Rank & "."
                            Else
                                AddQueue "/w " & UserName & " " & dbUser & " already exists in the database."
                            End If
                            Added = True
                            Exit For
                        End If
                    End If
                Next I
                
                If Not Added Then
                    AddQueue "/w " & UserName & " You do not have the ability to add users with the rank of " & Ranks(RI).Rank & "."
                    Exit Sub
                End If
            Else
                If LCase$(Trim$(Ranks(URI).CanAddRanks)) = LCase$(Ranks(RI).Rank) Or _
                    LCase$(Trim$(Ranks(URI).CanAddRanks)) = LCase$(Ranks(RI).Alias) Then
                    ' Add user
                    With newUser
                        .AddedBy = UserName
                        .Rank = Ranks(RI).Rank
                        .UserName = dbUser
                    End With
                    If AddDatabaseUser(newUser) = True Then
                        AddQueue "/w " & UserName & " Added " & dbUser & " to the database with a rank of " & Ranks(RI).Rank & "."
                    Else
                        AddQueue "/w " & UserName & " " & dbUser & " already exists in the database."
                    End If
                Else
                    AddQueue "/w " & UserName & " You do not have the ability to add users with the rank of " & Ranks(RI).Rank & "."
                    Exit Sub
                End If
            End If
        End If
    Else
        AddQueue "/w " & UserName & " Invalid format specified, do .adduser [username] [rank]"
    End If
End Sub

Private Sub Command_DelClan(ByVal UserName As String, ByVal Message As String)
    If InStr(Message, " ") > 0 Then
        AddQueue "/w " & UserName & " Invalid format specified, cannot contain spaces."
        Exit Sub
    End If
    
    If Len(Message) > 4 Or Len(Message) < 2 Then
        AddQueue "/w " & UserName & " Invalid length specified, must be between 2 and 4 characters."
        Exit Sub
    End If
    
    If RemoveClanBan(Message) = True Then
        AddQueue "/w " & UserName & " Successfully removed clanban."
    Else
        AddQueue "/w " & UserName & " Failed to remove clanban, it doesn't exist."
    End If
End Sub

Private Sub Command_FindClan(ByVal UserName As String, ByVal Message As String)
    If InStr(Message, " ") > 0 Then
        AddQueue "/w " & UserName & " Invalid format specified, cannot contain spaces."
        Exit Sub
    End If
    
    If Len(Message) > 4 Or Len(Message) < 2 Then
        AddQueue "/w " & UserName & " Invalid length specified, must be between 2 and 4 characters."
        Exit Sub
    End If
    
    Dim Index As Integer
    Index = FindClanBan(Message)
    If Index > 0 Then
        AddQueue "/w " & UserName & " Clanban " & Message & " found."
    Else
        AddQueue "/w " & UserName & " Clanban not found."
    End If
End Sub

Private Sub Command_FindPhrase(ByVal UserName As String, ByVal Message As String)
    Dim Index As Integer
    Index = FindPhrase(Message)
    If Index > 0 Then
        AddQueue "/w " & UserName & " Phrase " & Message & " found."
    Else
        AddQueue "/w " & UserName & " Phrase not found."
    End If
End Sub

Private Sub Command_DelPhrase(ByVal UserName As String, ByVal Message As String)
    If RemovePhrase(Message) = True Then
        AddQueue "/w " & UserName & " Successfully removed phrase."
    Else
        AddQueue "/w " & UserName & " Failed to remove phrase, it doesn't exist."
    End If
End Sub

Private Sub Command_DelUser(ByVal UserName As String, ByVal Message As String)
    Dim dbUser As String, RI As Integer, URI As Integer
    dbUser = Message
    RI = RankIndex(Database(FindDatabaseUser(Message)).Rank)
    URI = RankIndex(Database(FindDatabaseUser(UserName)).Rank)

    If Len(dbUser) < 2 Then
        AddQueue "/w " & UserName & " Username length is invalid."
        Exit Sub
    End If

    If RI = 0 Then
        AddQueue "/w " & UserName & " User is not in the database."
        Exit Sub
    End If
    
    If URI = 0 And Len(UserName) > 0 Then Exit Sub
    
    If Len(UserName) = 0 Then
        If RemoveDatabaseUser(dbUser) = True Then
            AddQueue "/w " & UserName & " Removed " & dbUser & " from the database."
        Else
            AddQueue "/w " & UserName & " Failed to remove " & dbUser & "!"
        End If
    Else
        If InStr(Ranks(URI).CanDelRanks, ",") > 0 Then
            Dim Splt() As String, I As Integer, Removed As Boolean
            Splt = Split(Ranks(URI).CanDelRanks, ",")
            
            For I = 0 To UBound(Splt())
                If Len(Splt(I)) > 0 Then
                    If LCase$(Trim$(Splt(I))) = LCase$(Ranks(RI).Rank) Or _
                        LCase$(Trim$(Splt(I))) = LCase$(Ranks(RI).Alias) Then
                        ' Remove User
                        If RemoveDatabaseUser(dbUser) = True Then
                            AddQueue "/w " & UserName & " Removed " & dbUser & " from the database."
                        Else
                            AddQueue "/w " & UserName & " Failed to remove " & dbUser & "!"
                        End If
                        Removed = True
                        Exit For
                    End If
                End If
            Next I
            
            If Not Removed Then
                AddQueue "/w " & UserName & " You do not have the ability to remove users with a rank of " & Ranks(RI).Rank & "."
                Exit Sub
            End If
        Else
            If LCase$(Trim$(Ranks(URI).CanDelRanks)) = LCase$(Ranks(RI).Rank) Or _
                LCase$(Trim$(Ranks(URI).CanDelRanks)) = LCase$(Ranks(RI).Alias) Then
                ' Remove User
                If RemoveDatabaseUser(dbUser) = True Then
                    AddQueue "/w " & UserName & " Removed " & dbUser & " from the database."
                Else
                    AddQueue "/w " & UserName & " Failed to remove " & dbUser & "!"
                End If
            Else
                AddQueue "/w " & UserName & " You do not have the ability to remove users with a rank of " & Ranks(RI).Rank & "."
                Exit Sub
            End If
        End If
    End If
End Sub

Private Sub Command_Mode_PhraseBanning(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.PhraseBanning = True
            AddQueue "/w " & UserName & " Phrase banning is now on."
        Case "off"
            Settings.PhraseBanning = False
            AddQueue "/w " & UserName & " Phrase banning is now off."
        Case "list"
            Dim phrList As String
            Dim phL As Integer
            For phL = 0 To UBound(Phrases())
                If Len(Phrases(phL)) > 0 Then phrList = phrList & Phrases(phL).Phrase & ", "
            Next phL
            
            If Len(phrList) > 0 Then
                If Right(phrList, 2) = ", " Then
                    phrList = Left$(phrList, Len(phrList) - 2) & "."
                End If
                AddQueue "/w " & UserName & " Phrases: " & phrList
            Else
                AddQueue "/w " & UserName & " No phrases have been added. Type .addphraseban <case> <phrase> to add a phrase."
            End If
        Case "status", "?"
            AddQueue "/w " & UserName & " Phrase banning is now " & IIf(Settings.PhraseBanning, "on", "off") & ". There are currently " & UBound(Phrases()) & " phrases, type .phrasebanning list for a list or .phrasebanning phrase <phrase> for information."
        Case "phrase"
            'Handled Below
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help phrasebanning for more information."
    End Select
    If Matches(Message, "phrase *") = True Then
        Dim phrStr As String
        phrStr = Mid(Message, 8)
        Dim phI As Integer
        For phI = 0 To UBound(Phrases())
            If Matches(Phrases(phI).Phrase, phrStr) = True Then
                AddQueue "/w " & UserName & " " & Phrases(phI).Phrase & ": Phrase added by " & Phrases(phI).AddedBy & " at " & Phrases(phI).AddedTime
            End If
        Next phI
    End If
End Sub

Private Sub Command_Mode_SpamFloodBanning(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.SpamFloodBanning = True
            AddQueue "/w " & UserName & " Spam Flood banning is now on."
        Case "off"
            Settings.SpamFloodBanning = False
            AddQueue "/w " & UserName & " Spam Flood banning is now off."
        Case "status", "?"
            AddQueue "/w " & UserName & " Spam Flood banning is now " & IIf(Settings.SpamFloodBanning, "on", "off") & "."
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, use on/off/status."
    End Select
End Sub

Private Sub Command_Mode_OutsiderClanBan(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.OutsiderClanBan = True
            AddQueue "/w " & UserName & " Outsider Clan banning is now on."
        Case "off"
            Settings.OutsiderClanBan = False
            AddQueue "/w " & UserName & " Outsider Clan banning is now off."
        Case "status", "?"
            AddQueue "/w " & UserName & " Outsider Clan banning is now " & IIf(Settings.OutsiderClanBan, "on", "off") & "."
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, use on/off/status."
    End Select
End Sub

Private Sub Command_Mode_IdleKicking(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.IdleKicking = True
            AddQueue "/w " & UserName & " Idle kicking is now on."
        Case "off"
            Settings.IdleKicking = False
            AddQueue "/w " & UserName & " Idle kicking is now off."
        Case "time 15"
            Settings.IdleTimeMode = seLow
            AddQueue "/w " & UserName & " Idle kicking time is now set to 15 minutes."
        Case "time 30"
            Settings.IdleTimeMode = seNormal
            AddQueue "/w " & UserName & " Idle kicking time is now set to 30 minutes."
        Case "time 60"
            Settings.IdleTimeMode = seHigh
            AddQueue "/w " & UserName & " Idle kicking time is now set to 60 minutes."
        Case "status", "?"
            Dim ikMinutes As String
            If Settings.IdleTimeMode = seLow Then
                ikMinutes = "15"
            ElseIf Settings.IdleTimeMode = seNormal Then
                ikMinutes = "30"
            Else
                ikMinutes = "60"
            End If
            AddQueue "/w " & UserName & " Idle kicking is now " & IIf(Settings.IdleKicking, "on", "off") & ", and the time is set to " & ikMinutes & " minutes."
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help idlekicking for more information."
    End Select
End Sub

Private Sub Command_Mode_LockDown(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.LockDown = True
            AddQueue "/w " & UserName & " Channel lockdown is now on."
        Case "off"
            Settings.LockDown = False
            AddQueue "/w " & UserName & " Channel lockdown is now off."
        Case "status", "?"
            AddQueue "/w " & UserName & " Channel lockdown is currently " & IIf(Settings.LockDown, "on", "off") & "."
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help lockdown for more information."
    End Select
End Sub
    
Private Sub Command_Mode_ClientBanning(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.ClientBanning = True
            AddQueue "/w " & UserName & " Client banning is now on."
        Case "off"
            Settings.ClientBanning = False
            AddQueue "/w " & UserName & " Client banning is now off."
        Case "status", "?"
            AddQueue "/w " & UserName & " Client banning is currently " & IIf(Settings.ClientBanning, "on", "off")
            Dim stMsg As String
            stMsg = IIf(Settings.ClientD2DV, "D2DV, ", "") & _
                IIf(Settings.ClientD2XP, "D2XP, ", "") & IIf(Settings.ClientSEXP, "SEXP, ", "") & _
                IIf(Settings.ClientSTAR, "STAR, ", "") & IIf(Settings.ClientW2BN, "W2BN, ", "") & _
                IIf(Settings.ClientW3XP, "W3XP, ", "") & IIf(Settings.ClientWAR3, "WAR3, ", "") & _
                IIf(Settings.BanSquelched, "Squelched Users, ", "")
            If Len(stMsg) > 0 Then
                If Right$(stMsg, 2) = ", " Then stMsg = Left$(stMsg, Len(stMsg) - 2) & "."
                AddQueue "/w " & UserName & " Currently banning: " & stMsg
            Else
                AddQueue "/w " & UserName & " Not banning any clients."
            End If
        Case "star on"
            Settings.ClientSTAR = True
            AddQueue "/w " & UserName & " StarCraft banning is now on."
        Case "star off"
            Settings.ClientSTAR = False
            AddQueue "/w " & UserName & " StarCraft banning is now off."
        Case "star ?", "star status"
            AddQueue "/w " & UserName & " StarCraft banning is currently " & IIf(Settings.ClientSTAR, "on", "off")
        Case "sexp on"
            Settings.ClientSEXP = True
            AddQueue "/w " & UserName & " StarCraft: BroodWar banning is now on."
        Case "sexp off"
            Settings.ClientSEXP = False
            AddQueue "/w " & UserName & " StarCraft: BroodWar banning is now off."
        Case "sexp ?", "sexp status"
            AddQueue "/w " & UserName & " StarCraft: BroodWar banning is currently " & IIf(Settings.ClientSEXP, "on", "off")
        Case "d2dv on"
            Settings.ClientD2DV = True
            AddQueue "/w " & UserName & " Diablo II banning is now on."
        Case "d2dv off"
            Settings.ClientD2DV = False
            AddQueue "/w " & UserName & " Diablo II banning is now off."
        Case "d2dv ?", "d2dv status"
            AddQueue "/w " & UserName & " Diablo II banning is currently " & IIf(Settings.ClientD2DV, "on", "off")
        Case "d2xp on"
            Settings.ClientD2XP = True
            AddQueue "/w " & UserName & " Diablo II: LoD banning is now on."
        Case "d2xp off"
            Settings.ClientD2XP = False
            AddQueue "/w " & UserName & " Diablo II: LoD banning is now off."
        Case "d2xp ?", "d2xp status"
            AddQueue "/w " & UserName & " Diablo II: LoD banning is currently " & IIf(Settings.ClientD2XP, "on", "off")
        Case "war3 on"
            Settings.ClientWAR3 = True
            AddQueue "/w " & UserName & " WarCraft III banning is now on."
        Case "war3 off"
            Settings.ClientWAR3 = False
            AddQueue "/w " & UserName & " WarCraft III banning is now off."
        Case "war3 ?", "war3 status"
            AddQueue "/w " & UserName & " WarCraft III banning is currently " & IIf(Settings.ClientWAR3, "on", "off")
        Case "w3xp on"
            Settings.ClientW3XP = True
            AddQueue "/w " & UserName & " WarCraft III: TFT banning is now on."
        Case "w3xp off"
            Settings.ClientW3XP = False
            AddQueue "/w " & UserName & " WarCraft III: TFT banning is now off."
        Case "w3xp ?", "w3xp status"
            AddQueue "/w " & UserName & " WarCraft III: TFT banning is currently " & IIf(Settings.ClientW3XP, "on", "off")
        Case "w2bn on"
            Settings.ClientW2BN = True
            AddQueue "/w " & UserName & " WarCraft II banning is now on."
        Case "w2bn off"
            Settings.ClientW2BN = False
            AddQueue "/w " & UserName & " WarCraft II banning is now off."
        Case "w2bn ?", "w2bn status"
            AddQueue "/w " & UserName & " WarCraft II banning is currently " & IIf(Settings.ClientW2BN, "on", "off")
        Case "squelch on"
            Settings.BanSquelched = True
            AddQueue "/w " & UserName & " Squelched banning is now on."
        Case "squelch off"
            Settings.BanSquelched = False
            AddQueue "/w " & UserName & " Squelched banning is now off."
        Case "squelch ?", "squelch status"
            AddQueue "/w " & UserName & " Squelched banning is currently " & IIf(Settings.BanSquelched, "on", "off")
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help clientbanning for more information."
    End Select
End Sub
    
Private Sub Command_Mode_FloodBanning(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.FloodBanning = True
            AddQueue "/w " & UserName & " Flood banning is now on."
        Case "off"
            Settings.FloodBanning = False
            AddQueue "/w " & UserName & " Flood banning is now off."
        Case "mode high"
            Settings.FloodSensitivity = seHigh
            AddQueue "/w " & UserName & " Flood sensitivity is now high."
        Case "mode normal"
            Settings.FloodSensitivity = seNormal
            AddQueue "/w " & UserName & " Flood sensitivity is now normal."
        Case "mode low"
            Settings.FloodSensitivity = seLow
            AddQueue "/w " & UserName & " flood sensitivity is now low."
        Case "status", "?"
            Dim floodSens As String
            If Settings.FloodSensitivity = seHigh Then
                floodSens = "high"
            ElseIf Settings.FloodSensitivity = seNormal Then
                floodSens = "normal"
            Else
                floodSens = "low"
            End If
            AddQueue "/w " & UserName & " Flood banning is currently " & IIf(Settings.FloodBanning, "on", "off") & " and sensitivity is set to " & floodSens & "."
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help floodbanning for more information."
    End Select
End Sub

Private Sub Command_Mode_StatsBanning(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.StatsBanning = True
            AddQueue "/w " & UserName & " Stats banning is now on."
        Case "off"
            Settings.StatsBanning = False
            AddQueue "/w " & UserName & " Stats banning is now off."
        Case "status", "?"
            AddQueue "/w " & UserName & " Stats banning is currently " & IIf(Settings.StatsBanning, "on", "off") & "."
            AddQueue "/w " & UserName & " Modes: " & IIf(Settings.StatsSTAR, "STAR (0 wins), ", "") & IIf(Settings.StatsSEXP, "SEXP (0 wins), ", "") & _
                IIf(Settings.StatsW2BN, "W2BN (0 wins), ", "") & IIf(Settings.StatsWAR3, "WAR3 (Peon Icon), ", "") & _
                IIf(Settings.StatsW3XP, "W3XP (Peon Icon), ", "") & IIf(Settings.StatsD2DV, "D2DV (Open Character), ", "") & _
                IIf(Settings.StatsD2XP, "D2XP (Open Character), ", "")
        Case "star on"
            Settings.StatsSTAR = True
            AddQueue "/w " & UserName & " Stats banning for StarCraft users with 0 wins is now on."
        Case "star off"
            Settings.StatsSTAR = False
            AddQueue "/w " & UserName & " Stats banning for StarCraft users with 0 wins is now off."
        Case "sexp on"
            Settings.StatsSEXP = True
            AddQueue "/w " & UserName & " Stats banning for StarCraft: BroodWar users with 0 wins is now on."
        Case "sexp off"
            Settings.StatsSEXP = False
            AddQueue "/w " & UserName & " Stats banning for StarCraft: BroodWar users with 0 wins is now off."
        Case "w2bn on"
            Settings.StatsW2BN = True
            AddQueue "/w " & UserName & " Stats banning for WarCraft II users with 0 wins is now on."
        Case "w2bn off"
            Settings.StatsW2BN = False
            AddQueue "/w " & UserName & " Stats banning for WarCraft II users with 0 wins is now off."
        Case "d2dv on"
            Settings.StatsD2DV = True
            AddQueue "/w " & UserName & " Stats banning for Diablo II users with an open character is now on."
        Case "d2dv off"
            Settings.StatsD2DV = False
            AddQueue "/w " & UserName & " Stats banning for Diablo II users with an open character is now off."
        Case "d2xp on"
            Settings.StatsD2XP = True
            AddQueue "/w " & UserName & " Stats banning for Diablo II: LoD users with an open character is now on."
        Case "d2xp off"
            Settings.StatsD2XP = False
            AddQueue "/w " & UserName & " Stats banning for Diablo II: LoD users with an open character is now off."
        Case "war3 on"
            Settings.StatsWAR3 = True
            AddQueue "/w " & UserName & " Stats banning for WarCraft III users with a peon icon is now on."
        Case "war3 off"
            Settings.StatsWAR3 = False
            AddQueue "/w " & UserName & " Stats banning for WarCraft III users with a peon icon is now off."
        Case "w3xp on"
            Settings.StatsW3XP = True
            AddQueue "/w " & UserName & " Stats banning for WarCraft III: TFT users with a peon icon is now on."
        Case "w3xp off"
            Settings.StatsW3XP = False
            AddQueue "/w " & UserName & " Stats banning for WarCraft III: TFT users with a peon icon is now off."
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help statsbanning for more information."
    End Select
End Sub

Private Sub Command_Mode_PingBanning(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.PingBanning = True
            AddQueue "/w " & UserName & " Ping banning is now on."
        Case "off"
            Settings.PingBanning = False
            AddQueue "/w " & UserName & " Ping banning is now off."
        Case "status", "?"
            AddQueue "/w " & UserName & " Ping banning is now " & IIf(Settings.PingBanning, "on", "off") & "."
            Dim pbStr As String
            pbStr = IIf(Settings.Ping0, "0ms, ", "") & IIf(Settings.Ping1, "-1ms, ", "") & IIf(Settings.Ping300, ">300ms, ", "") & IIf(Settings.Ping500, ">500ms, ", "")
            If Right(pbStr, 2) = ", " Then pbStr = Left$(pbStr, Len(pbStr) - 2) & "."
            AddQueue "/w " & UserName & " Modes: " & pbStr
        Case "0 on"
            Settings.Ping0 = True
            AddQueue "/w " & UserName & " Ping banning (0ms latency) is now on."
        Case "0 off"
            Settings.Ping0 = False
            AddQueue "/w " & UserName & " Ping banning (0ms latency) is now off."
        Case "-1 on", "1 on"
            Settings.Ping1 = True
            AddQueue "/w " & UserName & " Ping banning (-1ms latency) is now on."
        Case "-1 off", "1 off"
            Settings.Ping1 = False
            AddQueue "/w " & UserName & " Ping banning (-1ms latency) is now off."
        Case "300 on"
            Settings.Ping300 = True
            AddQueue "/w " & UserName & " Ping banning (>300ms latency) is now on."
        Case "300 off"
            Settings.Ping300 = False
            AddQueue "/w " & UserName & " Ping banning (>300ms latency) is now off."
        Case "500 on"
            Settings.Ping500 = True
            AddQueue "/w " & UserName & " Ping banning (>500ms latency) is now on."
        Case "500 off"
            Settings.Ping500 = False
            AddQueue "/w " & UserName & " Ping banning (>500ms latency) is now off."
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help pingbanning for more information."
    End Select
End Sub

Private Sub Command_Mode_BanRotation(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.BanRotation = True
            AddQueue "/w " & UserName & " Ban Rotation is now on."
        Case "off"
            Settings.BanRotation = False
            AddQueue "/w " & UserName & " Ban Rotation is now off."
        Case "status", "?"
            Settings.BanRotation = True
            AddQueue "/w " & UserName & " Ban Rotation is currently " & IIf(Settings.BanRotation, "on", "off") & " and ban capacity is set to " & Settings.BanRotationCapacity & "."
        Case "number", "capacity"
            If Val(Message) > 0 Then
                Settings.BanRotationCapacity = Message
                AddQueue "/w " & UserName & " Ban Rotation Capacity is now " & Settings.BanRotationCapacity & "."
            Else
                AddQueue "/w " & UserName & " Capacity must be a number (default is 40)."
            End If
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help banrotation for more information."
    End Select
End Sub

Private Sub Command_Mode_SafelistChecking(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "bypass", "skip"
            Settings.ByPassSafelist = True
            AddQueue "/w " & UserName & " Safelist will be ignored when banning/kicking users."
        Case "use", "check"
            Settings.ByPassSafelist = False
            AddQueue "/w " & UserName & " Safelist will be checked before banning/kicking users."
        Case "status", "?"
            AddQueue "/w " & UserName & " Safelist will be " & IIf(Settings.ByPassSafelist, "ignored when", "checked before") & " banning/kicking users."
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help safelist for more information."
    End Select
End Sub

Private Sub Command_Mode_WhisperBack(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.WhisperBack = True
            AddQueue "/w " & UserName & " Command responses will be whispered back."
        Case "off"
            Settings.WhisperBack = False
            AddQueue "/w " & UserName & " Command responses will be sent publicly."
        Case "status", "?"
            If Settings.WhisperBack = True Then
                AddQueue "/w " & UserName & " Command responses will be whispered back."
            Else
                AddQueue "/w " & UserName & " Command responses will be sent publicly."
            End If
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help whisperback for more information."
    End Select
End Sub

Private Sub Command_Mode_MassloadBanning(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.MassloadBanning = True
            AddQueue "/w " & UserName & " Massload banning is now on."
        Case "off"
            Settings.MassloadBanning = False
            AddQueue "/w " & UserName & " Massload banning is now off."
        Case "numbers on"
            Settings.MassloadNumbers = True
            AddQueue "/w " & UserName & " Number massload banning is now on."
        Case "numbers off"
            Settings.MassloadNumbers = False
            AddQueue "/w " & UserName & " Number massload banning is now off."
        Case "joins on"
            Settings.MassloadJoins = True
            AddQueue "/w " & UserName & " Join massload banning is now on."
        Case "joins off"
            Settings.MassloadJoins = False
            AddQueue "/w " & UserName & " Join massload banning is now off."
        Case "status", "?"
            AddQueue "/w " & UserName & " Massload banning is now " & IIf(Settings.MassloadBanning, "on", "off") & "."
            AddQueue "/w " & UserName & " Modes: Numbers (" & IIf(Settings.MassloadNumbers, "on", "off") & "), Joins (" & IIf(Settings.MassloadJoins, "on", "off") & ")."
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help massloadbanning for more information."
    End Select
End Sub

Private Sub Command_Mode_ClanBanning(ByVal UserName As String, ByVal Message As String)
    Select Case LCase$(Message)
        Case "on"
            Settings.ClanBanning = True
            AddQueue "/w " & UserName & " Clan banning is now on."
        Case "off"
            Settings.ClanBanning = False
            AddQueue "/w " & UserName & " Clan banning is now off."
        Case "status", "?"
            AddQueue "/w " & UserName & " Clan banning is currently " & IIf(Settings.ClanBanning, "on", "off") & "."
        Case Else
            AddQueue "/w " & UserName & " That is not a valid option, please type .help clanbanning for more information."
    End Select
End Sub
