Attribute VB_Name = "modChatEvent"
Option Explicit

Public Const USERFLAG_BLIZZ As Long = &H1
Public Const USERFLAG_MOD As Long = &H2
Public Const USERFLAG_PLUG As Long = &H10
Public Const USERFLAG_SQUELCH As Long = &H20


Public Sub GetIcons(ByVal Ping As Long, ByVal Flags As Long, ByVal Statstring As String, ByRef PingIcon As Integer, ByRef ClientIcon As Integer)
    Dim ProductID As String
    ProductID = StrReverse(Left$(Statstring, 4))
    
    If ((Flags And USERFLAG_MOD) = USERFLAG_MOD) Then
        ProductID = "Moderator"
    ElseIf ((Flags And USERFLAG_BLIZZ) = USERFLAG_BLIZZ) Then
        ProductID = "Blizzard"
    End If
    
    Dim I As Integer
    For I = 1 To frmMain.ClientIcons.ListImages.Count
        If (frmMain.ClientIcons.ListImages(I).Key = ProductID) Then
            ClientIcon = I: Exit For
        End If
    Next I
    If (ClientIcon = 0) Then ClientIcon = 23
    
    If ((Flags And USERFLAG_SQUELCH) = USERFLAG_SQUELCH) Then
        ClientIcon = 3
    End If
    
    Select Case Ping
        Case -1: PingIcon = 21
        Case 0: PingIcon = 0
        Case 1 To 200: PingIcon = 16
        Case 200 To 300: PingIcon = 17
        Case 300 To 400: PingIcon = 18
        Case 400 To 500: PingIcon = 19
        Case 500 To 600: PingIcon = 20
        Case Else: PingIcon = 21
    End Select
End Sub

Public Function CheckDisplayed(ByVal dbRank As String)
    If (Settings.DisplayNonSafe = True) Then
        CheckDisplayed = Not (Ranks(RankIndex(dbRank)).Friend)
    Else
        CheckDisplayed = True
    End If
End Function

Public Sub EventUserLeave(ByVal UserName As String)
    Dim I As Integer, lngUptime As Long, strUsername As String
    For I = 1 To UBound(Users())
        If StrComp(Users(I).ProperUsername, UserName, vbTextCompare) = 0 Then
            If (Users(I).Flags And USERFLAG_MOD) = USERFLAG_MOD Then
                ClearIndividualBanlist Users(I).UserName
            End If
            strUsername = Users(I).ProperUsername
            lngUptime = Users(I).SeenTime
            Exit For
        End If
    Next I
    
    If StrComp(UserName, Designated, vbTextCompare) = 0 Then Designated = vbNullString

    RemoveUser strUsername
    frmMain.lvUsers.ListItems.Remove "u" & UserName
    
    If (lngUptime > 0) Then
        If (Settings.FloodBanning = True) Then
            Dim intTime As Integer
            If (Settings.FloodSensitivity = seLow) Then
                intTime = 300
            ElseIf (Settings.FloodSensitivity = seHigh) Then
                intTime = 1000
            Else
                intTime = 600
            End If
            
            If (GetTickCount - lngUptime) < intTime Then
                Call QueueBan(UserName, "FloodBan: " & _
                GetTickCount() - lngUptime & "ms"): Exit Sub
            End If
        End If
        
        If (Settings.FilterFlood = True) Then
            If (GetTickCount - lngUptime) < 1000 Then Exit Sub
        End If
        
        If (Settings.JoinLeave = True) Then
            Dim dbRank As String
            dbRank = Database(FindDatabaseUser(UserName)).Rank
            If (Len(dbRank) > 0) Then
                AddChat vbMagenta, "[" & dbRank & "] ", &H80FF&, UserName & " has left the channel."
            Else
                AddChat &H80FF&, UserName & " has left the channel."
            End If
        End If
    End If
End Sub

Public Sub EventUserJoin(ByVal UserName As String, ByVal Ping As Long, ByVal Flags As Long, ByVal Statstring As String)
    Dim newUser As tUsers, ClientIcon As Integer, PingIcon As Integer, dbRank As String
    dbRank = Database(FindDatabaseUser(UserName)).Rank
    GetIcons Ping, Flags, Statstring, PingIcon, ClientIcon
    
    If StrComp(UserName, Designated, vbTextCompare) = 0 Then Designated = vbNullString

    Call ProcessModeration(&H2, UserName, Ping, Flags, Statstring)
'
'    If HasMail(UserName) = True Then
'        AddQueue "/w " & UserName & " There is new mail for you type !inbox to read."
'    End If
'
    Dim RI As Integer
    RI = RankIndex(Database(FindDatabaseUser(UserName)).Rank)
    If RI > 0 Then
        If Len(Ranks(RI).GreetMessage) > 0 Then
            AddQueue "/w " & UserName & " " & Ranks(RI).GreetMessage
        End If
    End If
    
  ' Add to user database
    With newUser
        .Flags = Flags
        .Ping = Ping
        .Statstring = Statstring
        .SeenTime = GetTickCount()
        .SpokenTime = .SeenTime
        .ProperUsername = UserName
        If (InStr(UserName, "*") > 0) Then
        .UserName = Split(UserName, "*")(1)
        Else
        .UserName = UserName
        End If
    End With
    AddUser newUser

    Dim intFind As Integer
    For intFind = frmMain.lvUsers.ListItems.Count To 1 Step -1
        If frmMain.lvUsers.ListItems(intFind).Text = newUser.UserName Then
            frmMain.lvUsers.ListItems.Remove intFind
        End If
    Next intFind
    
    If (Settings.JoinLeave = True) Then
        If (Len(dbRank) > 0) Then
            AddChat vbMagenta, "[" & dbRank & "] ", vbGreen, UserName & " has joined with ping of " & Ping & " and flags of " & Flags & "."
        Else
            AddChat vbGreen, UserName & " has joined with ping of " & Ping & " and flags of " & Flags & "."
        End If
    End If
    
  ' Display
    If (ClientIcon = 1 Or ClientIcon = 2) Then
        With frmMain.lvUsers.ListItems.Add(1, "u" & newUser.ProperUsername, newUser.UserName, , ClientIcon)
            If Len(dbRank) > 0 Then
                .ForeColor = Ranks(RankIndex(dbRank)).Color
            Else
                .ForeColor = &HA0A0A0
            End If
            .ToolTipText = newUser.ProperUsername
            .ListSubItems.Add(, , , PingIcon).ToolTipText = Ping
        End With
    Else
        With frmMain.lvUsers.ListItems.Add(, "u" & newUser.ProperUsername, newUser.UserName, , ClientIcon)
            .ToolTipText = newUser.ProperUsername
            If Len(dbRank) > 0 Then
                .ForeColor = Ranks(RankIndex(dbRank)).Color
            Else
                .ForeColor = &HA0A0A0
            End If
            .ListSubItems.Add(, , , PingIcon).ToolTipText = Ping
        End With
    End If
End Sub

Public Sub EventUserShow(ByVal UserName As String, ByVal Ping As Long, ByVal Flags As Long, ByVal Statstring As String)
    Dim newUser As tUsers, MySelf As Boolean, ClientIcon As Integer, PingIcon As Integer, dbRank As String
    dbRank = Database(FindDatabaseUser(UserName)).Rank
    GetIcons Ping, Flags, Statstring, PingIcon, ClientIcon
    
    If StrComp(UserName, Designated, vbTextCompare) = 0 Then Designated = vbNullString
    
  ' If Bot Then Update Information
    If StrComp(UserName, MyProperUsername, vbTextCompare) = 0 Then
        MyFlags = Flags
        MyPing = Ping
        MyStatstring = Statstring
        MySelf = True
    End If

  ' After info updated check moderation
    If Not MySelf Then
        Call ProcessModeration(&H1, UserName, Ping, Flags, Statstring)
    End If
'
'    If HasMail(UserName) = True Then
'        AddQueue "/w " & UserName & " There is new mail for you type !inbox to read."
'    End If
'
'
  ' Add to user database
    With newUser
        .Flags = Flags
        .Ping = Ping
        .Statstring = Statstring
        .SeenTime = GetTickCount()
        .SpokenTime = .SeenTime
        .ProperUsername = UserName
        If (InStr(UserName, "*") > 0) Then
        .UserName = Split(UserName, "*")(1)
        Else
        .UserName = UserName
        End If
    End With
    AddUser newUser

    Dim n As Integer
    For n = frmMain.lvUsers.ListItems.Count To 1 Step -1
        If frmMain.lvUsers.ListItems(n).Key = "u" & UserName Then
            frmMain.lvUsers.ListItems.Remove n
        End If
    Next n

  ' Display
    If (ClientIcon = 1 Or ClientIcon = 2) Then
        With frmMain.lvUsers.ListItems.Add(1, "u" & UserName, newUser.UserName, , ClientIcon)
            If Len(dbRank) > 0 Then
                .ForeColor = Ranks(RankIndex(dbRank)).Color
            Else
                .ForeColor = &HA0A0A0
            End If
            .ToolTipText = UserName
            .ListSubItems.Add(, , , PingIcon).ToolTipText = Ping
        End With
    Else
        With frmMain.lvUsers.ListItems.Add(, "u" & UserName, newUser.UserName, , ClientIcon)
            .ToolTipText = UserName
            If Len(dbRank) > 0 Then
                .ForeColor = Ranks(RankIndex(dbRank)).Color
            Else
                .ForeColor = &HA0A0A0
            End If
            .ListSubItems.Add(, , , PingIcon).ToolTipText = Ping
        End With
    End If
    
    If (Settings.JoinLeave = True) Then
        If (Len(dbRank) > 0) Then
            AddChat vbMagenta, "[" & dbRank & "] ", vbGreen, UserName & " is here with ping of " & Ping & " and flags of " & Flags & "."
        Else
            AddChat vbGreen, UserName & " is here with ping of " & Ping & " and flags of " & Flags & "."
        End If
    End If
End Sub

Public Sub EventUserFlags(ByVal UserName As String, ByVal Ping As Long, ByVal Flags As Long, ByVal Statstring As String)
    Dim MySelf As Boolean, ClientIcon As Integer, PingIcon As Integer, dbRank As String, intFind As Integer
    Dim FixUsername As String
    
    If StrComp(UserName, Designated, vbTextCompare) = 0 Then Designated = vbNullString

  ' If Bot Then Update Information
    If StrComp(UserName, MyProperUsername, vbTextCompare) = 0 Then
        MyFlags = Flags
        MyPing = Ping
        MyStatstring = Statstring
        MySelf = True
    End If
    If (InStr(UserName, "*") > 0) Then
        FixUsername = Split(UserName, "*")(1)
    Else
        FixUsername = UserName
    End If
    If Not MySelf Then ProcessModeration &H9, UserName, Ping, Flags, Statstring
    
    intFind = frmMain.lvUsers.FindItem(FixUsername).Index
    dbRank = Database(FindDatabaseUser(UserName)).Rank
    GetIcons Ping, Flags, Statstring, PingIcon, ClientIcon
    
    If intFind > 0 Then
        If (Flags And &H2) = &H2 Then
            frmMain.lvUsers.ListItems.Remove "u" & UserName
            With frmMain.lvUsers.ListItems.Add(1, "u" & UserName, FixUsername, , ClientIcon)
                .ToolTipText = UserName
                .ForeColor = Ranks(RankIndex(dbRank)).Color
                If .ForeColor = vbBlack Then .ForeColor = &HA0A0A0
                .ListSubItems.Add(, , , PingIcon).ToolTipText = Ping
            End With
        Else
            With frmMain.lvUsers.ListItems.Item(intFind)
                .SmallIcon = ClientIcon
                .ForeColor = Ranks(RankIndex(dbRank)).Color
                If .ForeColor = vbBlack Then .ForeColor = &HA0A0A0
                .ToolTipText = UserName
                .ListSubItems.Item(1).ReportIcon = PingIcon
            End With
        End If
    Else
        If (ClientIcon = 1 Or ClientIcon = 2) Then
            With frmMain.lvUsers.ListItems.Add(1, "u" & UserName, FixUsername, , ClientIcon)
                .ToolTipText = UserName
                .ListSubItems.Add(, , , PingIcon).ToolTipText = Ping
            End With
        Else
            With frmMain.lvUsers.ListItems.Add(, "u" & UserName, FixUsername, , ClientIcon)
                .ToolTipText = UserName
                .ListSubItems.Add(, , , PingIcon).ToolTipText = Ping
            End With
        End If
    End If
    
    Dim B As Integer
    For B = 1 To UBound(Users())
        If Users(B).ProperUsername = UserName Then
            If Users(B).Flags <> Flags Then
                If (Users(B).Flags And &H2) = &H2 Then
                    AddChat vbGreen, UserName & "'s flags changed from " & Users(B).Flags & " to " & Flags & "."
                    If Not ((Flags And &H2) = &H2) Then
                        ClearIndividualBanlist FixUsername
                    End If
                End If
            End If
            Users(B).Flags = Flags
            Users(B).Statstring = Statstring
        End If
    Next B
End Sub

Public Sub EventUserTalk(ByVal UserName As String, ByVal Message As String, ByVal Ping As Long, ByVal Flags As Long)
    Dim Display As Boolean, dbRank As String
    dbRank = Database(FindDatabaseUser(UserName)).Rank
    Display = CheckDisplayed(dbRank)
        
  ' Find users uptime
    Dim lngUptime As Long, Statstring As String, lngLastSpoken As Long
    Dim I As Integer
    For I = 1 To UBound(Users())
        If StrComp(Users(I).ProperUsername, UserName, vbTextCompare) = 0 Then
            lngLastSpoken = Users(I).SpokenTime
            Users(I).SpokenTime = GetTickCount()
            Statstring = Users(I).Statstring
            lngUptime = Users(I).SeenTime
            Exit For
        End If
    Next I

  ' Check if too quick
    If (lngUptime > 0) Then
        If (Settings.FloodBanning = True) Then
            Dim intTime As Integer
            If (Settings.FloodSensitivity = seLow) Then
                intTime = 300
            ElseIf (Settings.FloodSensitivity = seHigh) Then
                intTime = 1000
            Else
                intTime = 600
            End If
            
            If (GetTickCount - lngUptime) < intTime Then
                Call QueueBan(UserName, "FloodBan: " & _
                GetTickCount() - lngUptime & "ms"): Exit Sub
            End If
        End If
        
        If (Settings.FilterFlood = True) Then
            If (GetTickCount - lngUptime) < 700 Then Exit Sub
        End If
        If (Settings.FilterSpam = True) Then
            If (GetTickCount - lngLastSpoken) < 400 Then Exit Sub
        End If
    End If
    
    
  ' Display Message
    If Display = True Then
        If Len(dbRank) > 0 Then
            AddChat vbMagenta, "[" & dbRank & "] (" & Ping & ", " & Flags & ") ", vbCyan, UserName & " says: ", vbWhite, Message
        Else
            AddChat vbMagenta, "(" & Ping & ", " & Flags & ") ", vbCyan, UserName & " says: ", vbWhite, Message
        End If
    End If
    
    ProcessModeration &H5, UserName, Ping, Flags, Statstring, Message

  ' Check Trigger Command
    If (Len(Config.Trigger) = 0) Then Config.Trigger = "."
    
    If LCase$(Message) = "!inbox" Then
        If HasMail(UserName) = True Then
            Dim Messages() As String, IDs() As String
            GetMail UserName, Messages(), IDs()
            
            Dim iM As Integer
            For iM = 0 To UBound(Messages())
                AddQueue "/w " & UserName & " " & IDs(I) & " > " & Messages(I)
            Next iM
        End If
    End If
    
    If LCase$(Message) = "?trigger" Then
        If Len(dbRank) > 0 Then
            If Ranks(RankIndex(dbRank)).Friend = True Then
                AddQueue "/w " & UserName & " Trigger is " & Config.Trigger & " (Alt + " & Asc(Config.Trigger) & ")."
            End If
        End If
        Exit Sub
    End If
    
  ' Check Commands
    If (Len(Message) > Len(Config.Trigger)) Then
        If StrComp(Left$(Message, Len(Config.Trigger)), Config.Trigger, vbTextCompare) = 0 Then
            ProcessCommand UserName, Mid$(Message, Len(Config.Trigger) + 1)
        End If
    End If
End Sub

Public Sub EventWhisper(ByVal UserName As String, ByVal Message As String, ByVal Ping As Long, ByVal Flags As Long)
    Dim Display As Boolean, dbRank As String
    dbRank = Database(FindDatabaseUser(UserName)).Rank
    Display = CheckDisplayed(dbRank)
    
  ' Display Message
    If (Display = True) Then
        If (Len(dbRank) > 0) Then
            AddChat vbMagenta, "[" & dbRank & "] (" & Ping & ", " & Flags & ") ", vbWhite, "<From: " & UserName & "> ", &HC0C0C0, Message
        Else
            AddChat vbMagenta, "(" & Ping & ", " & Flags & ") ", vbWhite, "<From: " & UserName & "> ", &HC0C0C0, Message
        End If
    End If
    
    ProcessModeration &H4, UserName, Ping, Flags, Users(FindUser(UserName)).Statstring, Message
    
    If LCase$(Message) = "!inbox" Then
        If HasMail(UserName) = True Then
            Dim Messages() As String, IDs() As String
            GetMail UserName, Messages(), IDs()
            
            Dim iM As Integer
            For iM = 0 To UBound(Messages())
                AddQueue "/w " & UserName & " " & IDs(iM) & " > " & Messages(iM)
            Next iM
        End If
    End If
    
  ' Check Trigger Command
    If (Len(Config.Trigger) = 0) Then Config.Trigger = "."
    If LCase$(Message) = "?trigger" Then
        If Len(dbRank) > 0 Then
            If Ranks(RankIndex(dbRank)).Friend = True Then
                AddQueue "/w " & UserName & " Trigger is " & Config.Trigger & " (Alt + " & Asc(Config.Trigger) & ")."
            End If
        End If
        Exit Sub
    End If
    
  ' Check Commands
    If (Len(Message) > Len(Config.Trigger)) Then
        If StrComp(Left$(Message, Len(Config.Trigger)), Config.Trigger, vbTextCompare) = 0 Then
            ProcessCommand UserName, Mid$(Message, Len(Config.Trigger) + 1)
        End If
    End If
End Sub

Public Sub EventWhisperSent(ByVal UserName As String, ByVal Message As String, ByVal Ping As Long, ByVal Flags As Long)
    Dim Display As Boolean, dbRank As String
    dbRank = Database(FindDatabaseUser(UserName)).Rank
    Display = CheckDisplayed(dbRank)
    
    If Display = True Then
        If Len(dbRank) > 0 Then
            AddChat vbMagenta, "[" & dbRank & "] (" & Ping & ", " & Flags & ") ", vbWhite, "<To: " & UserName & "> ", &HC0C0C0, Message
        Else
            AddChat vbMagenta, "(" & Ping & ", " & Flags & ") ", vbWhite, "<To: " & UserName & "> ", &HC0C0C0, Message
        End If
    End If
End Sub

Public Sub EventUserEmote(ByVal UserName As String, ByVal Message As String, ByVal Ping As Long, ByVal Flags As Long)
    Dim Display As Boolean, dbRank As String
    dbRank = Database(FindDatabaseUser(UserName)).Rank
    Display = CheckDisplayed(dbRank)
    
  ' Find users uptime
    Dim lngUptime As Long, Statstring As String, lngLastSpoken As Long
    Dim I As Integer
    For I = 1 To UBound(Users())
        If StrComp(Users(I).ProperUsername, UserName, vbTextCompare) = 0 Then
            lngLastSpoken = Users(I).SpokenTime
            Users(I).SpokenTime = GetTickCount()
            Statstring = Users(I).Statstring
            lngUptime = Users(I).SeenTime
            Exit For
        End If
    Next I

  ' Check if too quick
    If (lngUptime > 0) Then
        If (Settings.FloodBanning = True) Then
            Dim intTime As Integer
            If (Settings.FloodSensitivity = seLow) Then
                intTime = 300
            ElseIf (Settings.FloodSensitivity = seHigh) Then
                intTime = 1000
            Else
                intTime = 600
            End If
            
            If (GetTickCount - lngUptime) < intTime Then
                Call QueueBan(UserName, "FloodBan: " & _
                GetTickCount() - lngUptime & "ms"): Exit Sub
            End If
        End If
        
        If (Settings.FilterFlood = True) Then
            If (GetTickCount - lngUptime) < 1000 Then Exit Sub
        End If
        If (Settings.FilterSpam = True) Then
            If (GetTickCount - lngLastSpoken) < 500 Then Exit Sub
        End If
    End If
    
  ' Display Message
    If (Display = True) Then
        If (Len(dbRank) > 0) Then
            AddChat vbMagenta, "[" & dbRank & "] (" & Ping & ", " & Flags & ") ", vbCyan, "<" & UserName & " " & Message & ">"
        Else
            AddChat vbMagenta, "(" & Ping & ", " & Flags & ") ", vbCyan, "<" & UserName & " " & Message & ">"
        End If
    End If
End Sub

Public Sub EventChannel(ByVal Channel As String)
    frmMain.lvUsers.ListItems.Clear
    MyFlags = 0
    MyChannel = Channel
    AddChat vbCyan, "Joined Channel: " & Channel
    ClearUsers
    ClearBannedUsers
    Designated = vbNullString
End Sub

Public Sub EventInformation(ByVal Message As String)
    If SweepChannel = True Then
        If InStr(Message, ", ") > 0 Then
            Dim sweepStr() As String
            sweepStr = Split(Message, ", ")
            If UBound(sweepStr()) = 1 Then
                Dim sweepTry1 As String, sweepTry2 As String
                If InStr(sweepStr(0), " ") = 0 Then
                    If (UCase$(sweepStr(0)) = sweepStr(0)) And (Left$(sweepStr(0), 1) = "[" And Right$(sweepStr(0), 1) = "]") Then
                        sweepTry1 = Mid$(sweepStr(0), 2, Len(sweepStr(0)) - 2)
                    Else
                        sweepTry1 = sweepStr(0)
                    End If
                    If SweepIgnore = True Then QueueBan sweepTry1, , "ignore"
                    If SweepBan = True Then QueueBan sweepTry1, "Channel Sweep"
                ElseIf InStr(sweepStr(0), " (*") > 0 Then
                    sweepTry1 = Split(sweepStr(0), " (")(1)
                    sweepTry1 = Left$(sweepTry1, Len(sweepTry1) - 1)
                    If SweepIgnore = True Then QueueBan sweepTry1, , "ignore"
                    If SweepBan = True Then QueueBan sweepTry1, "Channel Sweep"
                End If
                If InStr(sweepStr(1), " ") = 0 Then
                    If (UCase$(sweepStr(1)) = sweepStr(1)) And (Left$(sweepStr(1), 1) = "[" And Right$(sweepStr(1), 1) = "]") Then
                        sweepTry2 = Mid$(sweepStr(1), 2, Len(sweepStr(1)) - 2)
                    Else
                        sweepTry2 = sweepStr(1)
                    End If
                    If SweepIgnore = True Then QueueBan sweepTry2, , "ignore"
                    If SweepBan = True Then QueueBan sweepTry2, "Channel Sweep"
                ElseIf InStr(sweepStr(1), " (*") > 0 Then
                    sweepTry2 = Split(sweepStr(1), " (")(1)
                    sweepTry2 = Left$(sweepTry2, Len(sweepTry2) - 1)
                    If SweepIgnore = True Then QueueBan sweepTry2, , "ignore"
                    If SweepBan = True Then QueueBan sweepTry2, "Channel Sweep"
                End If
            End If
        Else
            SweepChannel = False
            SweepBan = False
            SweepIgnore = False
            If InStr(Message, " ") > 0 Then
                If InStr(Message, " (*") = 0 Then
                Else
                    Dim sweepD2 As String
                    sweepD2 = Split(Message, " (")(1)
                    sweepD2 = Left$(sweepD2, Len(sweepD2) - 1)
                    If SweepIgnore = True Then QueueBan sweepD2, , "ignore"
                    If SweepBan = True Then QueueBan sweepD2, "Channel Sweep"
                End If
            Else
                If SweepIgnore = True Then QueueBan Message, , "ignore"
                If SweepBan = True Then QueueBan Message, "Channel Sweep"
            End If
        End If
    End If
    If InStr(Message, " is unavailable (") Then
        AddQueue Split(Message, " is unavailable (")(0) & " please disable do not disturb mode, I am unable to communicate with you."
        AddChat &HC0C0C0, Message
    ElseIf InStr(Message, "Users in channel ") > 0 Then
        SweepChannel = True
        AddChat &HC0C0C0, Message
    ElseIf InStr(Message, " banned by ") > 0 Then
        SweepChannel = False
        SweepBan = False
        SweepIgnore = False
        AddChat vbCyan, Message
        Dim ban As tBanned
        ban.UserName = Split(Message, " ")(0)
        ban.BannedBy = Split(Message, " banned by ")(1)
        LastBannedUser = ban.UserName
        If InStr(ban.BannedBy, " (") > 0 Then
            ban.Reason = Mid$(ban.BannedBy, InStr(ban.BannedBy, " (") + 2)
            ban.Reason = Left$(ban.Reason, InStrRev(ban.Reason, ").") - 1)
            ban.BannedBy = Left$(ban.BannedBy, InStr(ban.BannedBy, " (") - 1)
        Else
            ban.BannedBy = Left$(ban.BannedBy, Len(ban.BannedBy) - 1)
        End If
        ban.BannedTime = Date & ", " & Time
        
        QueueBannedUser ban
        If frmViewBanned.Visible = True Then
            If frmViewBanned.Check1.Value = 1 Then
                frmViewBanned.cmdReload_Click
            End If
        End If
        
        Dim intFind As Integer
        intFind = FindDatabaseUser(ban.UserName)
        If intFind > 0 Then
            If Ranks(RankIndex(Database(intFind).Rank)).Friend = True Then
                AddQueue "/unban " & ban.UserName
            End If
        End If
    ElseIf InStr(Message, " unbanned by ") > 0 Then
        SweepChannel = False
        SweepBan = False
        SweepIgnore = False
        AddChat vbCyan, Message
        Dim uban As tBanned
        uban.UserName = Split(Message, " ")(0)
        uban.BannedBy = Split(Message, " unbanned by ")(1)
        uban.BannedBy = Left$(uban.BannedBy, Len(uban.BannedBy) - 1)
        
        RemoveBannedUser uban.UserName
        If frmViewBanned.Visible = True Then
            If frmViewBanned.Check1.Value = 1 Then
                frmViewBanned.cmdReload_Click
            End If
        End If
    ElseIf InStr(Message, "kicked") > 0 Then
        AddChat vbCyan, Message
    ElseIf InStr(Message, "designated") > 0 Then
        AddQueue Message
        Designated = Split(Message, " ")(0)
        AddChat vbCyan, Message
    ElseIf InStr(Message, " has been squelched.") > 0 Or InStr(Message, " has been unsquelched.") > 0 Then
        SweepChannel = False
        SweepBan = False
        SweepIgnore = False
        AddChat vbYellow, Message
        If (InStr(Message, " has been squelched.") > 0) Then
            Dim strFindSQ As String
            strFindSQ = Split(Message, " has been squelched.")(0)
            LastIgnoredUser = strFindSQ
            Dim intFindSQ As Integer
            intFindSQ = FindDatabaseUser(strFindSQ)
            If intFindSQ > 0 Then
                If Ranks(RankIndex(Database(intFindSQ).Rank)).Friend = True Then
                    AddQueue "/unsquelch " & strFindSQ
                End If
            End If
        End If
    Else
        AddChat &HC0C0C0, Message
    End If
End Sub
