VERSION 5.00
Begin VB.Form frmEditQueueProfiles 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "ShieldBot - Edit Queue Profiles"
   ClientHeight    =   4455
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   6375
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "frmQueue.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4455
   ScaleWidth      =   6375
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdClose 
      Caption         =   "Save && Close"
      Height          =   375
      Left            =   4800
      TabIndex        =   11
      Top             =   3960
      Width           =   1455
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Save"
      Height          =   375
      Left            =   3720
      TabIndex        =   21
      Top             =   3960
      Width           =   975
   End
   Begin VB.CheckBox Check2 
      Caption         =   "Do not double send"
      Height          =   255
      Left            =   240
      TabIndex        =   24
      Top             =   3480
      Width           =   1695
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Do not double ban (remove already banned users from queue)"
      Height          =   255
      Left            =   240
      TabIndex        =   23
      Top             =   3120
      Width           =   4815
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Use Queue"
      Height          =   375
      Left            =   2400
      TabIndex        =   22
      Top             =   3960
      Width           =   1215
   End
   Begin VB.ComboBox cboProfiles 
      Height          =   315
      Left            =   2400
      Style           =   2  'Dropdown List
      TabIndex        =   19
      Top             =   120
      Width           =   3015
   End
   Begin VB.CommandButton Command1 
      Caption         =   "+"
      Height          =   255
      Left            =   5520
      TabIndex        =   18
      Top             =   120
      Width           =   375
   End
   Begin VB.CommandButton Command2 
      Caption         =   "-"
      Height          =   255
      Left            =   5880
      TabIndex        =   17
      Top             =   120
      Width           =   375
   End
   Begin VB.TextBox txtSendsDelay 
      ForeColor       =   &H00FF0000&
      Height          =   285
      Left            =   3360
      TabIndex        =   16
      Top             =   2625
      Width           =   975
   End
   Begin VB.TextBox txtSends 
      ForeColor       =   &H00FF0000&
      Height          =   285
      Left            =   720
      TabIndex        =   15
      Top             =   2625
      Width           =   375
   End
   Begin VB.TextBox txtChar3 
      ForeColor       =   &H00C00000&
      Height          =   285
      Left            =   5040
      TabIndex        =   10
      Top             =   2040
      Width           =   1095
   End
   Begin VB.TextBox txtChar1 
      ForeColor       =   &H00C00000&
      Height          =   285
      Left            =   5040
      TabIndex        =   8
      Top             =   1320
      Width           =   1095
   End
   Begin VB.TextBox txtChar2 
      ForeColor       =   &H00C00000&
      Height          =   285
      Left            =   5040
      TabIndex        =   7
      Top             =   1680
      Width           =   1095
   End
   Begin VB.TextBox txtBase3 
      ForeColor       =   &H00FF0000&
      Height          =   285
      Left            =   3720
      TabIndex        =   5
      Top             =   2040
      Width           =   1095
   End
   Begin VB.TextBox txtBase1 
      ForeColor       =   &H00FF0000&
      Height          =   285
      Left            =   3720
      TabIndex        =   3
      Top             =   1320
      Width           =   1095
   End
   Begin VB.TextBox txtBase2 
      ForeColor       =   &H00FF0000&
      Height          =   285
      Left            =   3720
      TabIndex        =   1
      Top             =   1680
      Width           =   1095
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Queue Profile:"
      Height          =   195
      Left            =   120
      TabIndex        =   20
      Top             =   165
      Width           =   1035
   End
   Begin VB.Line Line6 
      X1              =   120
      X2              =   6240
      Y1              =   480
      Y2              =   480
   End
   Begin VB.Line Line5 
      X1              =   120
      X2              =   6240
      Y1              =   3840
      Y2              =   3840
   End
   Begin VB.Label Label8 
      Caption         =   "Every           constant sends wait an extra"
      Height          =   255
      Left            =   240
      TabIndex        =   14
      Top             =   2640
      Width           =   3135
   End
   Begin VB.Line Line4 
      BorderColor     =   &H00808080&
      X1              =   4920
      X2              =   4920
      Y1              =   960
      Y2              =   2400
   End
   Begin VB.Line Line3 
      BorderColor     =   &H00808080&
      X1              =   240
      X2              =   6120
      Y1              =   1200
      Y2              =   1200
   End
   Begin VB.Line Line1 
      BorderColor     =   &H00808080&
      X1              =   3600
      X2              =   3600
      Y1              =   960
      Y2              =   2400
   End
   Begin VB.Label Label9 
      AutoSize        =   -1  'True
      Caption         =   "Base delay:"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   195
      Left            =   3720
      TabIndex        =   12
      Top             =   960
      Width           =   960
   End
   Begin VB.Line Line2 
      BorderColor     =   &H00808080&
      X1              =   240
      X2              =   6120
      Y1              =   2400
      Y2              =   2400
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Char delay:"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   195
      Left            =   5040
      TabIndex        =   9
      Top             =   960
      Width           =   945
   End
   Begin VB.Label Label7 
      BackStyle       =   0  'Transparent
      Caption         =   "Length of last message warrants a different base delay and per character delay..."
      Height          =   255
      Left            =   240
      TabIndex        =   6
      Top             =   600
      Width           =   6015
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   ">200"
      ForeColor       =   &H00000000&
      Height          =   195
      Left            =   240
      TabIndex        =   4
      Top             =   2040
      Width           =   390
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "<101"
      ForeColor       =   &H00000000&
      Height          =   195
      Left            =   240
      TabIndex        =   2
      Top             =   1320
      Width           =   390
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   ">100"
      ForeColor       =   &H00000000&
      Height          =   195
      Left            =   240
      TabIndex        =   0
      Top             =   1680
      Width           =   390
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Length:"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   195
      Left            =   240
      TabIndex        =   13
      Top             =   960
      Width           =   630
   End
End
Attribute VB_Name = "frmEditQueueProfiles"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cboProfiles_Click()
    txtBase1.Text = Registry.ReadDWORD(REG_QUEUE & cboProfiles.Text, "BaseDelay1", 1600)
    txtBase2.Text = Registry.ReadDWORD(REG_QUEUE & cboProfiles.Text, "BaseDelay2", 1800)
    txtBase3.Text = Registry.ReadDWORD(REG_QUEUE & cboProfiles.Text, "BaseDelay3", 3200)
    txtChar1.Text = Registry.ReadDWORD(REG_QUEUE & cboProfiles.Text, "CharDelay1", 40)
    txtChar2.Text = Registry.ReadDWORD(REG_QUEUE & cboProfiles.Text, "CharDelay2", 40)
    txtChar3.Text = Registry.ReadDWORD(REG_QUEUE & cboProfiles.Text, "CharDelay3", 40)
    txtSends.Text = Registry.ReadDWORD(REG_QUEUE & cboProfiles.Text, "ConstantCount", 16)
    txtSendsDelay.Text = Registry.ReadDWORD(REG_QUEUE & cboProfiles.Text, "ConstantDelay", 4000)
    Check2.Value = Registry.ReadDWORD(REG_QUEUE & cboProfiles.Text, "RemoveDuplicates", 1)
    Check1.Value = Registry.ReadDWORD(REG_QUEUE & cboProfiles.Text, "RemoveBanned", 0)
End Sub

Private Sub cmdClose_Click()
    Command3_Click
    Unload Me
End Sub

Private Sub Command1_Click()
    Dim sInput As String, Found As Boolean
    sInput = InputBox("Enter name for new queue profile", "New Queue Profile")
    
    If Len(sInput) > 0 Then
        Dim I As Integer
        For I = 0 To cboProfiles.ListCount - 1
            If LCase$(cboProfiles.List(I)) = LCase$(sInput) Then
                Found = True
                Exit For
            End If
        Next I
        
        If Found = True Then
            MsgBox "Unable to add queue profile, it already exists.", vbExclamation + vbOKOnly, "Already Exists!"
            Exit Sub
        End If
        
        Registry.CreateKey REG_QUEUE & sInput
        Form_Load
    Else
        MsgBox "Unable to create a null queue profile.", vbExclamation + vbOKOnly, "Unable to Create!"
    End If
End Sub

Private Sub Command2_Click()
    If Len(cboProfiles.Text) > 0 Then
        Dim Result As VbMsgBoxResult
        Result = MsgBox("Are you sure you want to delete this queue profile?", vbQuestion + vbYesNo, "Delete?")
        
        If Result = vbYes Then
            If Registry.KeyExists(REG_QUEUE & cboProfiles.Text) = True Then
                If Registry.HaveSubkey(REG_QUEUE & cboProfiles.Text) = True Then
                    Dim Keys() As String, I As Integer
                    Registry.EnumKeys REG_QUEUE & cboProfiles.Text, Keys()
                    
                    On Error GoTo DeleteMainKey:
                    For I = 0 To UBound(Keys())
                        Dim Keys2() As String, j As Integer
                        ReDim Keys2(0)
                        If Registry.HaveSubkey(REG_QUEUE & cboProfiles.Text & "\" & Keys(I)) = True Then
                            Registry.EnumKeys REG_QUEUE & cboProfiles.Text & "\" & Keys(I), Keys2
                            
                            On Error GoTo DeleteSubKey:
                            For j = 0 To UBound(Keys2())
                                Registry.DeleteKey Mid$(REG_QUEUE, 6) & cboProfiles.Text & "\" & Keys(I) & "\" & Keys2(j)
                            Next j
                        End If
DeleteSubKey:
                        Registry.DeleteKey Mid$(REG_QUEUE, 6) & cboProfiles.Text & "\" & Keys(I)
                    Next I
DeleteMainKey:
                    Registry.DeleteKey Mid$(REG_QUEUE, 6) & cboProfiles.Text
                End If
            Else
                MsgBox "Unable to delete this profile, it seems it was already deleted.", vbExclamation + vbOKOnly, "Unable to Delete!"
            End If
            Form_Load
        End If
    Else
        MsgBox "Unable to delete null profile. A profile needs to be loaded in order for this bot to function press Ctrl+O to create/load a profile.", vbExclamation + vbOKOnly, "Unable to Delete!"
    End If
End Sub

Private Sub Command3_Click()
    Registry.WriteDWORD REG_QUEUE & cboProfiles.Text, "BaseDelay1", Val(txtBase1.Text)
    Registry.WriteDWORD REG_QUEUE & cboProfiles.Text, "BaseDelay2", Val(txtBase2.Text)
    Registry.WriteDWORD REG_QUEUE & cboProfiles.Text, "BaseDelay3", Val(txtBase3.Text)
    Registry.WriteDWORD REG_QUEUE & cboProfiles.Text, "CharDelay1", Val(txtChar1.Text)
    Registry.WriteDWORD REG_QUEUE & cboProfiles.Text, "CharDelay2", Val(txtChar2.Text)
    Registry.WriteDWORD REG_QUEUE & cboProfiles.Text, "CharDelay3", Val(txtChar3.Text)
    Registry.WriteDWORD REG_QUEUE & cboProfiles.Text, "ConstantCount", Val(txtSends.Text)
    Registry.WriteDWORD REG_QUEUE & cboProfiles.Text, "ConstantDelay", Val(txtSendsDelay.Text)
    Registry.WriteDWORD REG_QUEUE & cboProfiles.Text, "RemoveDuplicates", Abs(Check2.Value)
    Registry.WriteDWORD REG_QUEUE & cboProfiles.Text, "RemoveBanned", Abs(Check1.Value)
End Sub

Private Sub Command4_Click()
    On Error Resume Next
    Config.QProfile = cboProfiles.Text
    If Err Then
        Config.QProfile = "Default"
    End If
End Sub

Private Sub Form_Load()
    On Error Resume Next
    txtBase1.Text = Settings.BaseDelay1
    txtBase2.Text = Settings.BaseDelay2
    txtBase3.Text = Settings.BaseDelay3
    txtChar1.Text = Settings.CharDelay1
    txtChar2.Text = Settings.CharDelay2
    txtChar3.Text = Settings.CharDelay3
    Check1.Value = IIf(Settings.QRemBanned, 1, 0)
    Check2.Value = IIf(Settings.QRemDupe, 1, 0)
    txtSends.Text = Settings.ConstantCount
    txtSendsDelay.Text = Settings.ConstantDelay
    
    With cboProfiles
        .Clear
        Dim Keys() As String, I As Integer
        If Registry.HaveSubkey(REG_QUEUE) = True Then
            Registry.EnumKeys REG_QUEUE, Keys
            For I = 0 To UBound(Keys())
                .AddItem Keys(I)
            Next I
            If .ListCount > 0 Then .ListIndex = 0
        End If
        .Text = Config.QProfile
    End With
End Sub
