VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsConnection"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'---------------------------------------
' Connection Class
' o Deals with packet sequences/constructing and deconstructing
'---------------------------------------

Dim UseNLS As Boolean, ClientToken As Long, ServerToken As Long, _
    mpqNumber As Long, mpqFileTime As String, mpqArchive As String, _
    ChecksumFormula As String, ServerSignature As Long, NLS As Long, OldNLS As Long, _
    Sent0x25 As Boolean
    
Public YourProfile As Boolean, ProfileUser As String

'Private Type typFlooding
'    Usernames(5) As String
'    Counters(5) As Long
'End Type

'------------------------------------------------------------
' Free New Login System Variables
'------------------------------------------------------------
Public Sub FreeNLS()
    If (NLS <> 0) Then
        Call nls_free(NLS)
        NLS = 0
    End If
    
    If (OldNLS <> 0) Then
        Call nls_free(OldNLS)
        OldNLS = 0
    End If
End Sub

'------------------------------------------------------------
' Send Null/KeepAlive (SID_NULL)
'------------------------------------------------------------
Public Sub Send0x00()
    Packet.SendPacket &H0
End Sub

'------------------------------------------------------------
' Received Null/KeepAlive (SID_NULL)
'------------------------------------------------------------
Public Sub Recv0x00()
    Packet.SendPacket &H0
End Sub

'------------------------------------------------------------
' Send Away Authorization Information (SID_AUTH_INFO)
'------------------------------------------------------------
Public Sub Send0x50()
    With Packet
        .InsertDWORD 0
        .InsertBSTR "68XI" & StrReverse(Config.ProductID)
        .InsertDWORD Config.Verbyte
        .InsertDWORD 0
        .InsertDWORD 0
        .InsertDWORD 0
        .InsertDWORD 0
        .InsertDWORD 0
        .InsertCSTR GetInfo(LOCALE_SABBREVCTRYNAME)
        .InsertCSTR GetInfo(LOCALE_SNATIVECTRYNAME)
        .SendPacket &H50
    End With
    AddChat &HC0C0C0, "Sent Authorization Information"
End Sub

'------------------------------------------------------------
' Send Away Ping (SID_PING)
'------------------------------------------------------------
Public Sub Send0x25()
    If Config.Ping <> 2 Then
        With Packet
            .InsertDWORD 0
            .SendPacket &H25
        End With
    End If
End Sub

'------------------------------------------------------------
' Send Away Ping (SID_READUSERDATA)
'------------------------------------------------------------
Public Sub Send0x26(Optional ByVal Yours As Boolean = True, Optional ByVal UserName As String)
    YourProfile = Yours
    ProfileUser = UserName
    With Packet
        .InsertDWORD 1
        If Yours = True Then
            AddChat &HC0C0C0, "Send Read Account Data"
            .InsertDWORD 9
            .InsertDWORD GetTickCount()
            .InsertCSTR Config.UserName
            .InsertCSTR "system\username"
            .InsertCSTR "system\account created"
            .InsertCSTR "system\last logon"
            .InsertCSTR "system\last logoff"
            .InsertCSTR "system\time logged"
        Else
            .InsertDWORD 4
            .InsertDWORD GetTickCount()
            .InsertCSTR UserName
        End If
        .InsertCSTR "profile\sex"
        .InsertCSTR "profile\age"
        .InsertCSTR "profile\location"
        .InsertCSTR "profile\description"
        .SendPacket &H26
    End With
End Sub

'------------------------------------------------------------
' Recv Your Data (SID_READUSERDATA)
'------------------------------------------------------------
Public Sub Recv0x26()
    Dim UserName As String, Created As String, Logon As String, Logoff As String, TimeLogged As String, _
    Sex As String, Age As String, Location As String, Description As String
    
    Dim FT As FILETIME, ST As SystemTime
    
    With Packet
        .Skip 12
        If YourProfile = True Then
            UserName = .GetCSTR
            Created = .GetCSTR
            Logon = .GetCSTR
            Logoff = .GetCSTR
            TimeLogged = .GetCSTR
            AddChat &HC0C0C0, "Received Read Account Data"

            If Len(Created) < 3 Then
                If Settings.AccountData = True Then AddChat vbWhite, "Account Created: " & "N/A"
            Else
                FT = StringToFiletime(Created)
                Call FileTimeToSystemTime(FT, ST)
                If Settings.AccountData = True Then AddChat vbWhite, "Account Created: " & ProcessSystemTime(ST)
            End If
            
            If Len(TimeLogged) < 3 Then
                If Settings.AccountData = True Then AddChat vbWhite, "Time Logged: N/A"
            Else
                If Settings.AccountData = True Then AddChat vbWhite, "Time Logged: " & ProcessTimeLogged(Val(TimeLogged))
            End If
            
            If Len(Logon) < 3 Then
                If Settings.AccountData = True Then AddChat vbWhite, "Last Logon: " & "Never logged on"
            Else
                FT = StringToFiletime(Logon)
                Call FileTimeToSystemTime(FT, ST)
                If Settings.AccountData = True Then AddChat vbWhite, "Last Logon: " & ProcessSystemTime(ST)
            End If
            
            If Len(Logoff) < 3 Then
                If Settings.AccountData = True Then AddChat vbWhite, "Last Logoff: " & "Never logged on"
            Else
                FT = StringToFiletime(Logoff)
                Call FileTimeToSystemTime(FT, ST)
                If Settings.AccountData = True Then AddChat vbWhite, "Last Logoff: " & ProcessSystemTime(ST)
            End If
        End If
        
        Sex = .GetCSTR
        Age = .GetCSTR
        Location = .GetCSTR
        Description = .GetCSTR
        
        If Not YourProfile Then
            If frmEditUserProfile.Opened = True And ProfileUser = Config.UserName Then
                frmEditUserProfile.txtSex.Text = Sex
                frmEditUserProfile.txtLocation.Text = Location
                frmEditUserProfile.txtDescription.Text = Description
                frmEditUserProfile.pWait.Visible = False
            Else
                AddChat vbCyan, "Profile for: " & ProfileUser
            
                AddChat vbWhite, "Sex: " & IIf(Len(Sex) > 0, vbCrLf & Sex, vbNullString)
                AddChat vbWhite, "Age: " & IIf(Len(Age) > 0, vbCrLf & Age, vbNullString)
                AddChat vbWhite, "Location: " & IIf(Len(Location) > 0, vbCrLf & Location, vbNullString)
                AddChat vbWhite, "Description: " & IIf(Len(Description) > 0, vbCrLf & Description, vbNullString)
            End If
        Else
            If Settings.AccountData = True Then
                AddChat vbWhite, "Sex: " & IIf(Len(Sex) > 0, vbCrLf & Sex, vbNullString)
                AddChat vbWhite, "Age: " & IIf(Len(Age) > 0, vbCrLf & Age, vbNullString)
                AddChat vbWhite, "Location: " & IIf(Len(Location) > 0, vbCrLf & Location, vbNullString)
                AddChat vbWhite, "Description: " & IIf(Len(Description) > 0, vbCrLf & Description, vbNullString)
            End If
        End If
    End With
End Sub

'------------------------------------------------------------
' Send Away Update Profile (SID_WRITEUSERDATA)
'------------------------------------------------------------
Public Sub Send0x27(ByVal Sex As String, ByVal Location As String, ByVal Description As String)
    With Packet
        .InsertDWORD 1
        .InsertDWORD 3
        .InsertCSTR Config.UserName
        .InsertCSTR "profile\sex"
        .InsertCSTR "profile\location"
        .InsertCSTR "profile\description"
        .InsertCSTR Sex
        .InsertCSTR Location
        .InsertCSTR Description
        .SendPacket &H27
    End With
End Sub

'------------------------------------------------------------
' Receive Authorization Information (SID_AUTH_INFO)
'------------------------------------------------------------
Public Sub Recv0x50()
    Dim exeVersion As Long, exeinfo As String, checksum As Long, _
        KeyHash As String, HashLength As Long, KeyDecoder As Long, loginStyle As Long
    
    With Packet
        ClientToken = GetTickCount()
        loginStyle = .GetDWORD
        ServerToken = .GetDWORD
        
        Select Case loginStyle
            Case &H0
                AddChat vbWhite, "Using Old Logon System (Broken SHA-1)."
                UseNLS = False
            Case &H1:
                AddChat vbWhite, "Using New Logon System Version 1."
                AddChat vbRed, "This Logon System is no longer in use, disconnecting.."
                frmMain.wsBNCS.Close
                frmMain.wsBNLS.Close
                UseNLS = False
                Exit Sub
            Case &H2:
                AddChat vbWhite, "Using New Login System Version 2."
                UseNLS = True
                'OutPacket.InsertDWORD &H2
                'OutPacket.SendPacket &HD, True
            Case Else:
                AddChat vbWhite, "Unrecognized logon type.  You should check if a new version of the bot is available."
                frmMain.wsBNCS.Close
                frmMain.wsBNLS.Close
                Exit Sub
        End Select
    
        If Config.ProductID = "STAR" Or Config.ProductID = "SEXP" Or Config.ProductID = "W2BN" Then
            mpqFileTime = .GetBSTR(8)
            .Skip 4
            mpqArchive = .GetCSTR()
            ChecksumFormula = .GetCSTR()
            SendBNLS0x1A
            Exit Sub
        Else
            .Skip 12
            mpqNumber = extractMPQNumber(.GetCSTR())
            If mpqNumber < 0 Then
                .ClearOut
                AddChat vbRed, "The provided MPQ number appears to be invalid, maybe the way Battle.Net hashes this client has changed."
                Exit Sub
            End If
            ChecksumFormula = .GetCSTR()
            
            If frmMain.mnuUseLocalHashing.Checked = False Then
                SendBNLS0x09
                Exit Sub
            End If
        End If

        'Get Hash Files...
        Dim Hashes(2) As String
        GetHashes Config.ProductID, Hashes()

        Dim hp As String
        hp = Config.HashPath & IIf(Right(Config.HashPath, 1) = "\", "", "\")

        If checkRevision(ChecksumFormula, hp & Hashes(0), hp & Hashes(1), hp & Hashes(2), mpqNumber, checksum) = False Then
            .ClearOut
            AddChat vbRed, "Checkrevision call failed, make sure you specified the correct hash path for the selected product."
            Exit Sub
        End If
        
        Debug.Print checksum
        Debug.Print mpqNumber

        exeVersion = getExeInfo(hp & Hashes(0), exeinfo)
        If exeVersion = 0 Then
            .ClearOut
            AddChat vbRed, "Executable file (" & Hashes(0) & ") seems to be invalid."
            Exit Sub
        End If
        
        Dim ProductValue As Long, PublicValue As Long

        .InsertDWORD ClientToken
        .InsertDWORD exeVersion
        Debug.Print "version: " & exeVersion
        .InsertDWORD checksum
        Debug.Print "checksum: " & checksum
        .InsertDWORD IIf(Config.ProductID = "D2XP" Or Config.ProductID = "W3XP", _
            2, 1)
        .InsertDWORD 0

        KeyDecoder = kd_create(Config.CDKey, Len(Config.CDKey))
        If (KeyDecoder = -1) Then: _
            AddChat vbRed, "Could not decode your cdkey.": Exit Sub

        HashLength = kd_calculateHash(KeyDecoder, ClientToken, ServerToken)
        If (HashLength = 0) Then: _
            AddChat vbRed, "Could not hash your cdkey.": Exit Sub

        KeyHash = String$(HashLength, vbNullChar)
        Call kd_getHash(KeyDecoder, KeyHash)

        .InsertDWORD Len(Config.CDKey)
        .InsertDWORD kd_product(KeyDecoder)
        .InsertDWORD kd_val1(KeyDecoder)
        .InsertDWORD 0
        .InsertBSTR KeyHash

        Call kd_free(KeyDecoder)

        If Config.ProductID = "D2XP" Or Config.ProductID = "W3XP" Then
            KeyDecoder = kd_create(Config.ExpansionCdkey, Len(Config.ExpansionCdkey))
            If (KeyDecoder = -1) Then: _
                AddChat vbRed, "Could not create key decoder.": Exit Sub

            HashLength = kd_calculateHash(KeyDecoder, ClientToken, ServerToken)
            If (HashLength = 0) Then: _
                AddChat vbRed, "Could not hash your cdkey.": Exit Sub

            KeyHash = String$(HashLength, vbNullChar)
            Call kd_getHash(KeyDecoder, KeyHash)

            .InsertDWORD Len(Config.ExpansionCdkey)
            .InsertDWORD kd_product(KeyDecoder)
            .InsertDWORD kd_val1(KeyDecoder)
            .InsertDWORD 0
            .InsertBSTR KeyHash

            Call kd_free(KeyDecoder)
        End If

        .InsertCSTR exeinfo
        Debug.Print "exeinfo: " & exeinfo
        .InsertCSTR "ShieldBot"

        .SendPacket &H51
    End With
    AddChat &HC0C0C0, "Sent Hashing Information"
End Sub

'------------------------------------------------------------
' Send BNLS Version Check (BNLS_VERSIONCHECK)
'------------------------------------------------------------
Public Sub SendBNLS0x09()
    With Packet
        .InsertDWORD BNLSGetProductID(Config.ProductID)
        .InsertDWORD mpqNumber
        .InsertCSTR ChecksumFormula
        .SendPacket &H9, True
    End With
    AddChat &HE0E0E0, "Sent version information to BNLS for hashing..."
End Sub

'------------------------------------------------------------
' Send BNLS Version Check Ex2 (BNLS_VERSIONCHECKEX2)
'------------------------------------------------------------
Public Sub SendBNLS0x1A()
    With Packet
        .InsertDWORD BNLSGetProductID(Config.ProductID)
        .InsertDWORD &H0
        .InsertDWORD ServerToken
        .InsertBSTR mpqFileTime
        .InsertCSTR mpqArchive
        .InsertCSTR ChecksumFormula
        .SendPacket &H1A, True
    End With
    AddChat &HE0E0E0, "Sent version information to BNLS for hashing..."
End Sub

'------------------------------------------------------------
' Receive BNLS Version Check Ex2 Result (BNLS_VERSIONCHECKEX2)
'------------------------------------------------------------
Public Sub RecvBNLS0x1A_or_0x09()
    If Packet.GetDWORD = &H0 Then
        Debug.Print "BNLS Version check failed."
        Exit Sub
    End If
    AddChat &HE0E0E0, "Successfully hashed version information."

    Dim decoder As Long, HashLength As Long, KeyHash As String
    
    decoder = kd_create(Config.CDKey, Len(Config.CDKey))
    If decoder = -1 Then
        AddChat vbRed, "Failed to initialize decoder!"
        frmMain.wsBNCS.Close
        Exit Sub
    End If
      
    HashLength = kd_calculateHash(decoder, ClientToken, ServerToken)
    If HashLength = 0 Then
        AddChat vbRed, "Failed to calculate hash"
        frmMain.wsBNCS.Close
        Exit Sub
    End If
      
    KeyHash = Space(HashLength)
    If kd_getHash(decoder, KeyHash) = 0 Then
        AddChat vbRed, "Failed to retrieve Key Hash!"
        frmMain.wsBNCS.Close
        Exit Sub
    End If
    
    With Packet
        .InsertDWORD ClientToken
        .InsertDWORD Packet.GetDWORD
        .InsertDWORD Packet.GetDWORD
        If Config.ProductID = "D2XP" Or Config.ProductID = "W3XP" Then
            .InsertDWORD &H2
        Else
            .InsertDWORD &H1
        End If
        .InsertDWORD &H0 ' Spawn
        
        .InsertDWORD Len(Config.CDKey)
        .InsertDWORD kd_product(decoder)
        .InsertDWORD kd_val1(decoder)
        .InsertDWORD 0
        .InsertBSTR KeyHash
        kd_free (decoder)
        
        If Config.ProductID = "D2XP" Or Config.ProductID = "W3XP" Then
            decoder = kd_create(Config.ExpansionCdkey, Len(Config.ExpansionCdkey))
            If decoder = -1 Then
                AddChat vbRed, "Failed to initialize decoder!"
                frmMain.wsBNCS.Close
                Exit Sub
            End If
              
            HashLength = kd_calculateHash(decoder, ClientToken, ServerToken)
            If HashLength = 0 Then
                AddChat vbRed, "Failed to calculate hash"
                frmMain.wsBNCS.Close
                Exit Sub
            End If
              
            KeyHash = Space(HashLength)
            If kd_getHash(decoder, KeyHash) = 0 Then
                AddChat vbRed, "Failed to retrieve Key Hash!"
                frmMain.wsBNCS.Close
                Exit Sub
            End If
            .InsertDWORD Len(Config.ExpansionCdkey)
            .InsertDWORD kd_product(decoder)
            .InsertDWORD kd_val1(decoder)
            .InsertDWORD 0
            .InsertBSTR KeyHash
            kd_free (decoder)
        End If
        .InsertCSTR Packet.GetCSTR
        .InsertCSTR "ShieldBot"
        .SendPacket &H51
    End With
End Sub

'------------------------------------------------------------
' Receive Auth Check Result (SID_AUTH_CHECK)
'------------------------------------------------------------
Public Sub Recv0x51()
    AddChat &HC0C0C0, "Received Hashing Result"
    Select Case Packet.GetDWORD
        Case &H0
            'Change Password
            If Len(Config.NewPassword) > 0 Then
                If UseNLS = True Then
                    Send0x55
                Else
                    Send0x31
                End If
                Exit Sub
            End If
            
            'Reset Password
            If Config.ResetPassword = True Then
                Send0x5A
                Exit Sub
            End If
            
            'Change Email
            If Len(Config.NewEmail) > 0 Then
                Send0x5B
            End If
            
            'Login
            If UseNLS = True Then
                Send0x53
            Else
                Send0x3A
            End If
            
        Case &H100
            AddChat vbRed, "The hash files you are using are out of date, go download new hashes."
        Case &H101
            AddChat vbRed, "The game version is incorrect, please use the correct verbyte for this product."
        Case &H200
            AddChat vbRed, "The current cdkey is invalid, as a result you may be banned from the server temporarily."
        Case &H201
            AddChat vbYellow, "The current cdkey is being used by another user."
            Dim CdkeyUser As String
            CdkeyUser = Packet.GetCSTR()
            If Len(CdkeyUser) > 0 Then
                AddChat vbYellow, "The user has identified themselves as " & CdkeyUser & "."
            End If
        Case &H202
            AddChat vbRed, "The current cdkey is banned from the server."
        Case &H203
            AddChat vbRed, "The current cdkey is for another product."
        Case &H210
            AddChat vbRed, "The current expansion cdkey is invalid, as a result you may be banned from the server temporarily."
        Case &H211
            AddChat vbYellow, "The current expansion cdkey is being used by another user."
            Dim ExCdkeyUser As String
            ExCdkeyUser = Packet.GetCSTR()
            If Len(ExCdkeyUser) > 0 Then
                AddChat vbYellow, "The user has identified themselves as " & ExCdkeyUser & "."
            End If
        Case &H212
            AddChat vbRed, "The current expansion cdkey is banned from the server."
        Case &H213
            AddChat vbRed, "The current expansion cdkey is for another product."
        Case Else
            AddChat vbRed, "Unidentified error code was returned."
    End Select
End Sub

'------------------------------------------------------------
' Send Auth Logon Proof Request (SID_AUTH_LOGON)
'------------------------------------------------------------
Public Sub Send0x52()
    Dim Buffer As String, BufLen As Long
    BufLen = 65 + Len(Config.UserName)
    Buffer = String$(BufLen, vbNullChar)
    If (nls_account_create(NLS, Buffer, BufLen) = 0) Then
        AddChat vbRed, "Failed to generate 'SID_AUTH_CREATE' packet due to NLS handler."
        Exit Sub
    End If
    Packet.InsertBSTR Buffer
    Packet.SendPacket &H52
    AddChat &HC0C0C0, "Sent Account Creation Information"
End Sub

'------------------------------------------------------------
' Received Auth Logon Proof Result (SID_AUTH_LOGON)
'------------------------------------------------------------
Public Sub Recv0x52()
    AddChat &HC0C0C0, "Received Account Creation Result"
    Select Case Packet.GetDWORD()
        Case 0
            Send0x53
        Case 7, 8, 9, &HA, &HB, &HC
            AddChat vbRed, "Unable to create account, invalid characters or length."
        Case Else
            AddChat vbRed, "Unable to create account, it seems it may already exist."
    End Select
End Sub

'------------------------------------------------------------
' Send Auth Logon Request (SID_AUTH_LOGON)
'------------------------------------------------------------
Public Sub Send0x53()
    Dim Var_A As String * 32
    If (NLS = 0) Then
        NLS = nls_init(Config.UserName, LCase$(Config.Password))
        If NLS = 0 Then
            AddChat vbRed, "Failed to generate 'SID_AUTH_ACCOUNTLOGON' packet due to NLS handler."
            Exit Sub
        End If
    End If
    
    ' Retrieve "public ephermeral value" (A).
    Call nls_get_A(NLS, Var_A)
    
    ' Build objPacket
    With Packet
        .InsertBSTR Var_A
        .InsertCSTR Config.UserName
        .SendPacket &H53
    End With
    AddChat &HC0C0C0, "Sent Login Information (1/2)"
End Sub

'------------------------------------------------------------
' Received Auth Logon Result (SID_AUTH_LOGON)
'------------------------------------------------------------
Public Sub Recv0x53()
    AddChat &HC0C0C0, "Received Login Result (1/2)"
    Dim M1 As String * 20
    Dim Salt As String, Var_B As String

    With Packet
        Select Case .GetDWORD()
            Case &H0
                Salt = .GetBSTR(32)
                Var_B = .GetBSTR(32)
                Call nls_get_M1(NLS, M1, Var_B, Salt)

                .InsertBSTR M1
                .SendPacket &H54
                AddChat &HC0C0C0, "Sent Login Information (2/2)"
            Case &H1
                AddChat vbWhite, "Account doesn't exist, attempting creation..."
                Send0x52
            Case &H5
                Packet.SendPacket &H57
                AddChat &HC0C0C0, "Sent Account Upgrade Request"
            Case Else
                AddChat vbRed, "Unable to login, unidentified reason."
        End Select
    End With
End Sub

Public Sub Recv0x57()
    AddChat &HC0C0C0, "Received Account Upgrade Result"
    With Packet
        If .GetDWORD = &H0 Then
            AddChat &HC0C0C0, "Upgrade request was accepted"
            ServerToken = .GetDWORD()
        Else
            AddChat vbRed, "Upgrade request was rejected."
        End If
    End With
End Sub

'------------------------------------------------------------
' Received Auth Logon Proof Result (SID_AUTH_LOGONPROOF)
'------------------------------------------------------------
Public Sub Recv0x54()
    AddChat &HC0C0C0, "Received Login Result (2/2)"
    Dim M2 As String
    With Packet
        Select Case .GetDWORD()
            Case 0
                M2 = .GetBSTR(20)
                If (nls_check_M2(NLS, M2, vbNullString, vbNullString) = 0) Then
                    AddChat vbRed, "Server rejected password proof."
                    Exit Sub
                End If
                FreeNLS
                
                'Change Email
                If Len(Config.NewEmail) > 0 And Config.ProductID <> "W2BN" Then
                    Send0x5B
                End If
                
                'Enter Chat
                Send0x0A
            Case 2
                AddChat vbRed, "Unable to login, incorrect password was specified."
            Case &HE
                AddChat &HC0C0C0, "There is no E-mail address registered with this account."
                Send0x59
                Send0x0A
            Case Else
                AddChat vbRed, "Unable to login for an unidentified reason."
        End Select
    End With
End Sub

'------------------------------------------------------------
' Sent Set Email (SID_SETEMAIL)
'------------------------------------------------------------
Public Sub Send0x59()
    If Len(Config.EMail) = 0 Then
        AddChat vbRed, "Unable to assign a null E-mail address."
        Exit Sub
    End If
    With Packet
        .InsertCSTR Config.EMail
        .SendPacket &H59
    End With
    AddChat vbWhite, "E-mail address: " & Config.EMail & " has been successfully binded to " & Config.UserName & "."
End Sub

'------------------------------------------------------------
' Sent Auth Change (SID_AUTH_CHANGE)
'------------------------------------------------------------
Public Sub Send0x55()
    Dim A As String * 32
    NLS = nls_init(Config.UserName, Config.Password)
    If NLS = 0 Then
        AddChat vbRed, "Failed to generate 'SID_AUTH_CHANGE' packet due to NLS handler."
        Exit Sub
    End If
    
    Call nls_get_A(NLS, A)
    With Packet
        .InsertBSTR A
        .InsertCSTR Config.UserName
        .SendPacket &H55
    End With
    AddChat &HC0C0C0, "Sent Change Password Request (Step 1/2)"
End Sub

'------------------------------------------------------------
' Received Auth Change (SID_AUTH_CHANGE)
'------------------------------------------------------------
Public Sub Recv0x55()
    AddChat &HC0C0C0, "Received Change Password Result (Step 1/2)"
    Dim ServerKey As String, Salt As String, NewPW As String
    Dim NewNLS As Long, OutputBuffer As String * 84
        With Packet
            Select Case .GetDWORD()
                Case &H0
                    Salt = .GetBSTR(32)
                    ServerKey = .GetBSTR(32)
                    
                    NewPW = Config.NewPassword
                    NewNLS = nls_account_change_proof(NLS, OutputBuffer, NewPW, ServerKey, Salt)
                    
                    If NewNLS = 0 Then
                        AddChat vbRed, "Failed to generate 'SID_AUTH_CHANGEPROOF' packet due to NLS handler."
                        Exit Sub
                    End If
        
                    OldNLS = NLS
                    NLS = NewNLS
                    
                    .InsertBSTR OutputBuffer
                    .SendPacket &H56
                    AddChat &HC0C0C0, "Sent Change Password Request (Step 2/2)"
                Case &H1
                    Config.Password = Config.NewPassword
                    Config.NewPassword = vbNullString
                    
                    Call Registry.WriteString(REG_PROFILE & Config.Profile & "\Configuration", "Password", Config.Password)
                    Call Registry.WriteString(REG_PROFILE & Config.Profile & "\Configuration", "NewPassword", Config.NewPassword)
                
                    AddChat vbWhite, "Account doesn't exist, attempting creation..."
                    Send0x52
                Case &H5
                    AddChat vbRed, "Failed to change password, account requires upgrade."
                Case Else
                    AddChat vbRed, "Failed to change password for an unidentified reason."
            End Select
        End With
End Sub

'------------------------------------------------------------
' Received Auth Change 2 (SID_AUTH_CHANGEPROOF)
'------------------------------------------------------------
Public Sub Recv0x56()
    AddChat &HC0C0C0, "Received Change Password Result (Step 2/2)"
    Dim M2 As String
    With Packet
        Select Case .GetDWORD()
            Case &H0
                M2 = .GetBSTR(20)
                If (nls_check_M2(OldNLS, M2, "", "") = 0) Then
                    AddChat vbRed, "Server rejected password proof, password was not changed."
                    Exit Sub
                End If
                
                Call nls_free(OldNLS)
                OldNLS = 0
                
                AddChat vbWhite, "Password changed from " & Config.Password & " to " & Config.NewPassword & "."
                AddChat vbWhite, "Your configuration profile's password has been updated."
                
                Config.Password = Config.NewPassword
                Config.NewPassword = vbNullString
                
                Call Registry.WriteString(REG_PROFILE & Config.Profile & "\Configuration", "Password", Config.Password)
                Call Registry.WriteString(REG_PROFILE & Config.Profile & "\Configuration", "NewPassword", Config.NewPassword)
                
                Send0x53
            Case &H2
                AddChat vbRed, "Failed to change password, incorrect password was specified."
            Case Else
                AddChat vbRed, "Failed to change password for an unidentified reason."
        End Select
    End With
End Sub

'------------------------------------------------------------
' Sent Reset Password (SID_RESETPASSWORD)
'------------------------------------------------------------
Public Sub Send0x5A()
    With Packet
        .InsertCSTR Config.UserName
        .InsertCSTR Config.EMail
        .SendPacket &H5A
    End With
    AddChat &HC0C0C0, "Reset password request sent, you will receive an E-mail from Battle.Net momentarily."
End Sub

'------------------------------------------------------------
' Sent Change Email (SID_CHANGEEMAIL)
'------------------------------------------------------------
Public Sub Send0x5B()
    If Len(Config.EMail) = 0 Then
        AddChat vbRed, "Cannot change email address, first email address was not specified."
        Exit Sub
    End If
    If Len(Config.NewEmail) = 0 Then
        AddChat vbRed, "Cannot change email address, new email address was not specified."
        Exit Sub
    End If
    With Packet
        .InsertCSTR Config.UserName
        .InsertCSTR Config.EMail
        .InsertCSTR Config.NewEmail
        .SendPacket &H5B
    End With
    AddChat &HC0C0C0, "Changed Email from " & Config.EMail & " to " & Config.NewEmail & "."
End Sub

'------------------------------------------------------------
' Receive Ping Response (SID_PING)
'------------------------------------------------------------
Public Sub Recv0x25()
    If Sent0x25 = False Then
        If Config.Ping <> 1 Then
            With Packet
                .InsertDWORD .GetDWORD
                .SendPacket &H25
            End With
        End If
        Sent0x25 = True
    End If
End Sub


'------------------------------------------------------------
' Sent Change Password (SID_CHANGEPASSWORD)
'------------------------------------------------------------
Public Sub Send0x31()
    With Packet
        .InsertDWORD ClientToken
        .InsertDWORD ServerToken
        .InsertBSTR doubleHashPassword(LCase$(Config.Password), ClientToken, ServerToken)
        .InsertBSTR hashPassword(LCase$(Config.NewPassword))
        .InsertCSTR Config.UserName
        .SendPacket &H31
    End With
    AddChat &HC0C0C0, "Sent Change Password Information"
End Sub
    
'------------------------------------------------------------
' Received Change Password Result (SID_CHANGEPASSWORD)
'------------------------------------------------------------
Public Sub Recv0x31()
    With Packet
        If .GetBYTE = 0 Then
            AddChat vbRed, "Password Change Failed"
        Else
            AddChat vbWhite, "Password changed from " & Config.Password & " to " & Config.NewPassword & "."
            AddChat vbWhite, "Your configuration profile's password has been updated."
            
            Config.Password = Config.NewPassword
            Config.NewPassword = vbNullString
            
            Call Registry.WriteString(REG_PROFILE & Config.Profile & "\Configuration", "Password", Config.Password)
            Call Registry.WriteString(REG_PROFILE & Config.Profile & "\Configuration", "NewPassword", Config.NewPassword)
            
            Send0x3A
        End If
    End With
End Sub


'------------------------------------------------------------
' Send Logon Response (SID_LOGONRESPONSE2)
'------------------------------------------------------------
Public Sub Send0x3A()
    AddChat &HC0C0C0, "Sent Login Information"
    With Packet
        .InsertBSTR "tenb"
        .SendPacket &H14
        .InsertDWORD ClientToken
        .InsertDWORD ServerToken
        .InsertBSTR doubleHashPassword(LCase$(Config.Password), ClientToken, ServerToken)
        .InsertCSTR Config.UserName
        .SendPacket &H3A
    End With
End Sub

'------------------------------------------------------------
' Receive Logon Response (SID_LOGONRESPONSE2)
'------------------------------------------------------------
Public Sub Recv0x3A()
    AddChat &HC0C0C0, "Received Login Result"
    Select Case Packet.GetDWORD()
        Case &H0
            Send0x0A
        Case &H1
            AddChat vbWhite, "Account doesn't exist, attempting creation..."
            Send0x3D
        Case &H2
            AddChat vbRed, "Incorrect password specified for current account."
        Case Else
            AddChat vbRed, "Unidentified error code received."
    End Select
End Sub

'------------------------------------------------------------
' Send Create Account (SID_CREATEACCOUNT2)
'------------------------------------------------------------
Public Sub Send0x3D()
    With Packet
        .InsertBSTR hashPassword(Config.Password)
        .InsertCSTR Config.UserName
        .SendPacket &H3D
    End With
    AddChat &HC0C0C0, "Sent Create Account Information"
End Sub

'------------------------------------------------------------
' Recv Create Account (SID_CREATEACCOUNT2)
'------------------------------------------------------------
Public Sub Recv0x3D()
    AddChat &HC0C0C0, "Received Create Account Result"
    With Packet
        Select Case .GetDWORD()
            Case &H0
                Send0x3A
            Case &H2
                AddChat vbRed, "Account contained invalid characters."
            Case &H3
                AddChat vbRed, "Account contained a banned word."
            Case &H4
                AddChat vbRed, "Account already exists."
            Case &H6
                AddChat vbRed, "Account did not contain enough characters (less than 3)."
        End Select
    End With
End Sub

'------------------------------------------------------------
' Send Enter Chat (SID_ENTERCHAT)
'------------------------------------------------------------
Public Sub Send0x0A()
    AddChat &HC0C0C0, "Sent Chat Information"
    With Packet
        .InsertCSTR Config.UserName
        .InsertBYTE 0
        .SendPacket &HA
        .InsertDWORD 2
        .InsertCSTR Config.Channel
        .SendPacket &HC
    End With
End Sub

'------------------------------------------------------------
' Receive Enter Chat (SID_ENTERCHAT)
'------------------------------------------------------------
Public Sub Recv0x0A()
    AddChat &HC0C0C0, "Received Chat Information"
    Dim Values() As String
    Values() = Split(Mid$(Packet.GetDATA, 5), vbNullChar)
    
    If Settings.AccountData = True Then
        AddChat vbWhite, "- Current Account: " & Values(2)
        AddChat vbWhite, "- Current Stats: " & Values(1)
        AddChat vbWhite, "- Current Username: " & Values(0)
    End If
    
    MyOnlineTime = GetTickCount()
    MyProperUsername = IIf(Left$(Config.ProductID, 2) = "D2", "*" & Values(0), Values(0))
    MyStatstring = Values(1)
    MyFlags = 0
    MyPing = 0
    MyChannel = vbNullString
    
    Send0x46
    Send0x26
End Sub

Public Sub SendRejoin()
    Packet.SendPacket &H10
    Packet.InsertDWORD &H2
    Packet.InsertCSTR MyChannel
    Packet.SendPacket &HC
End Sub

'------------------------------------------------------------
' Receive News (SID_NEWS)
'------------------------------------------------------------
Public Sub Recv0x46()
    Dim Entries As Long, I As Integer
    With Packet
        Entries = .GetBYTE
        .Skip 12
        For I = 1 To Entries
            .Skip 4
            Dim Message As String
            Message = .GetCSTR
            
            If InStr(Message, "muted") > 0 Then
                AddChat vbYellow, "Cdkey is muted, therefore you cannot communicate with other users on Battle.Net."
            End If
            
            If InStr(Message, "VOIDed") > 0 Then
                AddChat vbRed, "Cdkey is restricted to The Void and cannot communicate with other usrs on Battle.Net."
            End If
            
            If frmMain.mnuDisplayNews.Checked = True Then
                AddChat vbWhite, Message
            End If
        Next I
    End With
End Sub

'------------------------------------------------------------
' Sent News (SID_NEWS)
'------------------------------------------------------------
Public Sub Send0x46()
    With Packet
        .InsertDWORD 0
        .SendPacket &H46
    End With
    AddChat &HC0C0C0, "Sent News Request"
End Sub

'------------------------------------------------------------
' Sent Text (SID_CHATCOMMAND)
'------------------------------------------------------------
Public Sub Send0x0E(ByVal Text As String)
    With Packet
        .InsertCSTR Text
        .SendPacket &HE
        If Left$(Text, 1) <> "/" Then AddChat vbMagenta, "(" & MyPing & ", " & MyFlags & ") ", vbCyan, "You said: ", vbWhite, Text
    End With
End Sub

'------------------------------------------------------------
' Received Chat Event (SID_CHATEVENT)
'------------------------------------------------------------
Public Sub Recv0x0F()
    'On Error GoTo ReportError:
    Dim ID As Long, Flags As Long, Ping As Long, UserName As String, Message As String
    
    ID = Packet.GetDWORD()
    Flags = Packet.GetDWORD()
    Ping = Packet.GetDWORD()
    Packet.Skip 12
    UserName = Packet.GetCSTR
    Message = Packet.GetCSTR
    
    Select Case ID
        Case &H1 'ShowUser
            Call EventUserShow(UserName, Ping, Flags, Message)
        
        Case &H2 'Join
            Call EventUserJoin(UserName, Ping, Flags, Message)
            
        Case &H3 'Leave
            Call EventUserLeave(UserName)
            
        Case &H4 'Whisper
            Call EventWhisper(UserName, Message, Ping, Flags)
        
        Case &H5
            Call EventUserTalk(UserName, Message, Ping, Flags)
        
        Case &H6 'Broadcast
            AddChat &HC0C0C0, Message
            
        Case &H7 'Channel
            Call EventChannel(Message)
            
        Case &H9 'Flags
            Call EventUserFlags(UserName, Ping, Flags, Message)
            
        Case &H12 'Info
            Call EventInformation(Message)
            
        Case &H13 'Error
            AddChat &HC0C0C0, Message
            
        Case &H17 'Emote
            Call EventUserEmote(UserName, Message, Ping, Flags)
            
        Case &HA 'Whisper Sent
            Call EventWhisperSent(UserName, Message, Ping, Flags)
            
    End Select
    Exit Sub
ReportError:
    AddChat vbRed, "Error in Chat Event (" & Hex(ID) & "), " & Err.Number & ": " & Err.Description & ". Source: " & Err.Source
End Sub








'
'------------------------------------------------------------
'
' WarCraft III Clan Packets
'
'------------------------------------------------------------
'

Public Sub Recv0x70()
    With Packet
        .Skip 4
        Select Case .GetBYTE
            Case &H0
                frmClanCreator.Step1Result.Caption = "Continue on to Step2!"
                frmClanCreator.Step1Result.ForeColor = vbGreen
                frmClanCreator.lvPotential.ListItems.Clear
                Dim cfc As Integer
                For cfc = 1 To .GetBYTE
                    frmClanCreator.lvPotential.ListItems.Add , , .GetCSTR
                Next cfc
                frmClanCreator.Step2
                
            Case &H1
                frmClanCreator.Step1Result.Caption = "Clan channel is already taken!"
                frmClanCreator.Step1Result.ForeColor = vbRed
                frmClanCreator.Step1
            
            Case &H8
                frmClanCreator.Step1Result.Caption = "This cdkey is clanned!"
                frmClanCreator.Step1Result.ForeColor = vbRed
                frmClanCreator.Step1
            
            Case &HA
                frmClanCreator.Step1Result.Caption = "Invalid clan tag specified!"
                frmClanCreator.Step1Result.ForeColor = vbRed
                frmClanCreator.Step1
                
        End Select
    End With
End Sub

Public Sub Recv0x71()
    With Packet
        .Skip 4
        Select Case .GetBYTE
            Case &H0
                frmClanCreator.Step2Result.Caption = "Success, everyone accepted invitation!"
                frmClanCreator.Step2Result.ForeColor = vbGreen
                frmClanCreator.Step2List.Caption = vbNullString
                
            Case &H4
                frmClanCreator.Step2Result.Caption = "Failed, not everyone accepted the invitation!"
                frmClanCreator.Step2Result.ForeColor = vbRed
                frmClanCreator.Step2List.Caption = .GetCSTR
                
            Case &H5
                frmClanCreator.Step2Result.Caption = "Not available, not in channel or already in a clan!"
                frmClanCreator.Step2Result.ForeColor = vbRed
                frmClanCreator.Step2List.Caption = .GetCSTR
        End Select
    End With
End Sub

Public Sub Recv0x72()
    Dim strClanName As String
    With Packet
        .Skip 4

        Dim f As New frmShowInvite
        f.InviteType = &H1
        f.ClanName = "Clan " & StrReverse(RemoveNull(.GetBSTR(4)))
        strClanName = .GetCSTR
        f.ClanInviter = "by " & .GetCSTR
        f.Show
    End With
End Sub

'------------------------------------------------------------
' Received Clan Information (SID_CLANINFO)
'------------------------------------------------------------
Public Sub Recv0x75()
    AddChat &HC0C0C0, "Received Clan Information"
    With Packet
        .Skip 1
        MyClanTag = Split(StrReverse(.GetBSTR(4)), vbNullChar)(0)
        MyClanRank = .GetBYTE()
        AddChat vbWhite, "You are the " & RankIDToString(MyClanRank) & " of Clan " & MyClanTag
    End With
    
    Send0x7C
    Send0x7D
End Sub

'------------------------------------------------------------
' Disband Result (SID_CLANDISBAND)
'------------------------------------------------------------
Public Sub Recv0x73()
    With Packet
        .Skip 4
        Select Case .GetBYTE
            Case &H0
                AddChat vbCyan, "[BNET] Successfully disbanded the clan!"
                MyClanRank = &H0
                MyClanTag = vbNullString
            Case &H2
                AddChat vbRed, "[BNET] Cannot disband the clan, it is not a week old yet!"
            Case &H7
                AddChat vbRed, "[BNET] You are not authorized to disband the clan!"
        End Select
    End With
End Sub

'------------------------------------------------------------
' Change Chieftain Result (SID_CLANMAKECHIEFTAIN)
'------------------------------------------------------------
Public Sub Recv0x74()
    With Packet
        .Skip 4
        If .GetBYTE = &H0 Then
            AddChat vbCyan, "[BNET] Successfully changed the clan's chieftain!"
        Else
            AddChat vbRed, "[BNET] Failed to change the clan's chieftain."
        End If
    End With
End Sub

Public Sub Recv0x77()
    With Packet
        .Skip 4
        Select Case .GetBYTE
            Case &H0
                AddChat vbCyan, "[BNET] Invitation accepted!"
            Case &H4
                AddChat vbRed, "[BNET] Invitation declined!"
            Case &H5
                AddChat vbRed, "[BNET] Failed to invite user!"
            Case &H9
                AddChat vbRed, "[BNET] Clan is full, cannot invite any more users!"
        End Select
    End With
End Sub

Public Sub Recv0x79()
    Dim strClanName As String
    With Packet
        .Skip 4

        Dim fa As New frmShowInvite
        fa.InviteType = &H2
        fa.ClanName = "Clan " & StrReverse(RemoveNull(.GetBSTR(4)))
        strClanName = .GetCSTR
        fa.ClanInviter = "by " & .GetCSTR
        fa.Show
    End With
End Sub

Public Sub Recv0x7A()
    With Packet
        .Skip 4
        Select Case .GetBYTE
            Case &H0
                AddChat vbCyan, "[BNET] Successfully changed members rank."
            Case &H1
                AddChat vbRed, "[BNET] Failed to change members rank."
            Case &H2
                AddChat vbRed, "[BNET] Cannot change members rank."
            Case &H7
                AddChat vbRed, "[BNET] Only Cheiftain's and Shaman's can change a members rank."
            Case &H8
                AddChat vbRed, "[BNET] Not allowed to change members rank, they are either a Cheiftain or have been in the clan for less than a week. This may also occur when there are too many shamans."
        End Select
    End With
End Sub

Public Sub Recv0x7E()
    RemoveClanMember Packet.GetCSTR
End Sub
                        
Public Sub Recv0x7F()
    Dim Account As String, Rank As Byte, Status As Byte, Location As String
    With Packet
        Account = .GetCSTR
        Rank = .GetBYTE
        Status = .GetBYTE
        Location = .GetCSTR
    End With
    
    With frmMain.lvClan.ListItems
        Dim I As Integer
        For I = .Count To 1 Step -1
            If LCase$(.Item(I).Text) = LCase$(Account) Then
                .Item(I).SmallIcon = IIf(Rank = 0, 1, Rank)
                If Status = &H0 Then
                    .Item(I).ForeColor = &H404040
                Else
                    .Item(I).ForeColor = vbCyan
                End If
                If Rank = 4 Then
                    .Item(I).ToolTipText = Account & " is the " & RankIDToString(Rank) & "."
                Else
                    .Item(I).ToolTipText = Account & " is a " & RankIDToString(Rank) & "."
                End If
            End If
        Next I
    End With
End Sub

Public Sub Recv0x81()
    Dim OldRank As Byte, NewRank As Byte, UserName As String
    OldRank = Packet.GetBYTE
    NewRank = Packet.GetBYTE
    UserName = Packet.GetCSTR
    
    AddChat vbCyan, "[BNET] Your clan rank was changed by " & UserName & " from " & RankIDToString(OldRank) & " to " & RankIDToString(NewRank) & "."
    MyClanRank = NewRank
End Sub

                        
'------------------------------------------------------------
' Send Clan Member List (SID_CLANMEMBERLIST)
'------------------------------------------------------------
Public Sub Send0x7D()
    AddChat &HC0C0C0, "Sent Request for Clan Member List"
    With Packet
        .InsertDWORD GetTickCount()
        .SendPacket &H7D
    End With
End Sub

'------------------------------------------------------------
' Received Clan Member List (SID_CLANMEMBERLIST)
'------------------------------------------------------------
Public Sub Recv0x7D()
    AddChat &HC0C0C0, "Received Clan Member List Result"
    Dim I As Integer, newUser As tClanMembers
    
    ClearClanMembers
    frmMain.lvClan.ListItems.Clear
    
    With Packet
        .Skip 4
            For I = 1 To .GetBYTE()
                newUser.UserName = .GetCSTR()
                newUser.Rank = .GetBYTE()
                newUser.Status = Abs(.GetBYTE())
                AddClanMember newUser
                .Skip 1
            Next I
    End With
End Sub

Public Sub Send0x73()
    AddChat vbRed, "Clan has been disbanded, this cannot be undone!!"
    With Packet
        .InsertDWORD GetTickCount
        .SendPacket &H73
    End With
End Sub

Public Sub Send0x78_Leave()
    AddChat vbYellow, "Attempting to leave the Clan..."
    With Packet
        .InsertDWORD GetTickCount
        .InsertCSTR Config.UserName
        .SendPacket &H78
    End With
End Sub

Public Sub Recv0x78()
    With Packet
        .Skip 4
        If .GetBYTE = &H0 Then
            AddChat vbRed, "Successfully removed member from the Clan!"
        End If
    End With
End Sub

Public Sub Recv0x76() ' Quit Notify
    If Packet.GetBYTE = &H1 Then
        AddChat vbRed, "You have been removed from the Clan!"
        ReDim ClanMembers(0)
        MyClanTag = vbNullString
        MyClanRank = 0
        MyClanname = vbNullString
        MyClanMOTD = vbNullString
    End If
End Sub

'------------------------------------------------------------
' Send Clan Set MOTD (SID_CLANSETMOTD)
'------------------------------------------------------------
Public Sub Send0x7B(ByVal NewMOTD As String)
    AddChat &HC0C0C0, "Sent Request to Change Clan MOTD"
    With Packet
        .InsertDWORD GetTickCount()
        .InsertCSTR NewMOTD
        .SendPacket &H7B
    End With
    Send0x7C
End Sub

'------------------------------------------------------------
' Send Clan MOTD (SID_CLANMOTD)
'------------------------------------------------------------
Public Sub Send0x7C()
    AddChat &HC0C0C0, "Sent Request for Clan MOTD"
    With Packet
        .InsertDWORD GetTickCount()
        .SendPacket &H7C
    End With
End Sub

'------------------------------------------------------------
' Recv Clan MOTD (SID_CLANMOTD)
'------------------------------------------------------------
Public Sub Recv0x7C()
    AddChat &HC0C0C0, "Received Clan MOTD Result"
    With Packet
        .Skip 8
        MyClanMOTD = .GetCSTR()
        AddChat vbCyan, "Clan Message of the Day: "
        AddChat vbWhite, vbTab & MyClanMOTD
    End With
End Sub

Public Sub Send0x7A(ByVal Account As String, ByVal NewRank As Byte)
    If MyClanRank = &H4 Then
        With Packet
            .InsertDWORD GetTickCount()
            .InsertCSTR Account
            .InsertBYTE NewRank
            .SendPacket &H7A
        End With
        AddChat vbYellow, "[BNET] Sent request to change " & Account & "'s rank to " & RankIDToString(NewRank) & "."
    ElseIf MyClanRank = &H3 Then
        If NewRank = &H3 Then
            AddChat vbRed, "[BNET] Only Chieftain's can change a Shaman's rank."
            Exit Sub
        End If
        With Packet
            .InsertDWORD GetTickCount()
            .InsertCSTR Account
            .InsertBYTE NewRank
            .SendPacket &H7A
        End With
        AddChat vbYellow, "[BNET] Sent request to change " & Account & "'s rank to " & RankIDToString(NewRank) & "."
    Else
        AddChat vbRed, "[BNET] Only Chieftain's and Shaman's can change another members' rank."
        Exit Sub
    End If
End Sub

Public Sub Send0x77(ByVal Account As String)
    If MyClanRank > &H2 Then
        With Packet
            .InsertDWORD GetTickCount()
            .InsertCSTR Account
            .SendPacket &H77
        End With
        AddChat vbYellow, "[BNET] Attempting to invite " & Account & " to the clan."
    Else
        AddChat vbRed, "[BNET] Only Chieftain's and Shaman's can remove another member."
    End If
End Sub

Public Sub Send0x78(ByVal Account As String)
    If MyClanRank > &H2 Then
        With Packet
            .InsertDWORD GetTickCount()
            .InsertCSTR Account
            .SendPacket &H78
        End With
        AddChat vbYellow, "[BNET] Attempting to remove " & Account & " from the clan."
    Else
        AddChat vbRed, "[BNET] Only Chieftain's and Shaman's can remove another member."
    End If
End Sub

Public Sub Send0x74(ByVal NewChief As String)
    If Len(MyClanTag) > 0 Then
        If MyClanRank = &H4 Then
            With Packet
                .InsertDWORD GetTickCount()
                .InsertCSTR NewChief
                .SendPacket &H74
            End With
            AddChat vbYellow, "[BNET] Attempting to change the Cheiftain of the clan to " & NewChief & ".."
        Else
            AddChat vbRed, "[BNET] You must be a Chieftain to change the Chieftain of the clan."
        End If
    Else
        AddChat vbRed, "[BNET] You are not a member of a clan."
    End If
End Sub

