VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmFileTransferS 
   BackColor       =   &H00000000&
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Ripple Chat Bot File Transfer"
   ClientHeight    =   3330
   ClientLeft      =   2190
   ClientTop       =   5910
   ClientWidth     =   3795
   ControlBox      =   0   'False
   BeginProperty Font 
      Name            =   "Arial"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "frmFileTransferS.frx":0000
   LinkTopic       =   "FileTransferServer"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   222
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   253
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin MSComDlg.CommonDialog cdlOpen 
      Left            =   480
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin MSWinsockLib.Winsock tcpServer 
      Left            =   0
      Top             =   0
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Timer tmrInfo 
      Interval        =   1000
      Left            =   1080
      Top             =   0
   End
   Begin MSComctlLib.ProgressBar pbPercent 
      Height          =   255
      Left            =   120
      TabIndex        =   2
      ToolTipText     =   "Progress (Click to change style)."
      Top             =   1080
      Width           =   3015
      _ExtentX        =   5318
      _ExtentY        =   450
      _Version        =   393216
      Appearance      =   1
   End
   Begin VB.CommandButton cmdDisconnect 
      Cancel          =   -1  'True
      Caption         =   "&Disconnect"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   11.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   1140
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   "Disconnect File Transfer."
      Top             =   2640
      Width           =   1425
   End
   Begin VB.CommandButton cmdQuit 
      Caption         =   "&Quit"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   11.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   1140
      Style           =   1  'Graphical
      TabIndex        =   1
      ToolTipText     =   "Close File Transfer Window."
      Top             =   2640
      Visible         =   0   'False
      Width           =   1425
   End
   Begin VB.Label lblTime 
      AutoSize        =   -1  'True
      BackColor       =   &H00000000&
      BackStyle       =   0  'Transparent
      Caption         =   "Time Left: 0 Seconds."
      ForeColor       =   &H00FFFFFF&
      Height          =   210
      Left            =   120
      TabIndex        =   10
      Top             =   1800
      Width           =   1575
   End
   Begin VB.Label lblFileSize 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackColor       =   &H00000000&
      BackStyle       =   0  'Transparent
      Caption         =   "0 B"
      ForeColor       =   &H00FFFFFF&
      Height          =   210
      Left            =   3360
      TabIndex        =   9
      Top             =   1440
      Width           =   240
   End
   Begin VB.Label lblStatus 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "No Connection"
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   2160
      UseMnemonic     =   0   'False
      Width           =   3600
   End
   Begin VB.Label lblPath 
      BackColor       =   &H00000000&
      BorderStyle     =   1  'Fixed Single
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   600
      UseMnemonic     =   0   'False
      Width           =   3600
   End
   Begin VB.Label lblFileTitle 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   11.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   375
      Left            =   120
      TabIndex        =   6
      Top             =   120
      UseMnemonic     =   0   'False
      Width           =   3600
   End
   Begin VB.Label lblSending 
      AutoSize        =   -1  'True
      BackColor       =   &H00000000&
      BackStyle       =   0  'Transparent
      Caption         =   "Sending:"
      ForeColor       =   &H00FFFFFF&
      Height          =   210
      Left            =   120
      TabIndex        =   5
      Top             =   1440
      Width           =   630
   End
   Begin VB.Label lblSpeed 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackColor       =   &H00000000&
      BackStyle       =   0  'Transparent
      Caption         =   "0 B/S"
      ForeColor       =   &H00FFFFFF&
      Height          =   210
      Left            =   3210
      TabIndex        =   4
      Top             =   1800
      Width           =   390
   End
   Begin VB.Label lblPercent 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackColor       =   &H00000000&
      BackStyle       =   0  'Transparent
      Caption         =   "0%"
      ForeColor       =   &H00FFFFFF&
      Height          =   210
      Left            =   3345
      TabIndex        =   3
      Top             =   1080
      Width           =   240
   End
End
Attribute VB_Name = "frmFileTransferS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private bSendingFile        As Boolean
Private SendTime            As Double
Private SentNow             As Long
Private CancelConnection    As Boolean
Private StartTime           As Double
Private Filename            As String
Private FileTitle           As String
Private FileSize            As Long
Private FullSize            As String
Private FullSent            As Long
Private ProgressColor       As Long
Private ProgressBG          As Long
Public Sub ApplySkin()
Dim FileTitleColor As Long
Dim FileTitleBG    As Long
Dim PathColor      As Long
Dim PathBG         As Long
Dim CaptionColor   As Long
Dim nFile          As Integer
Dim TmpR           As Integer
Dim TmpG           As Integer
Dim TmpB           As Integer
Dim Unzip          As clsUnzip
Dim I              As Integer
Dim TmpDr          As String
  On Error GoTo Erred
  TmpDr = TempDir
  OnTop Me, bOnTop
  If LenB(Dir$(App.Path & "\Skins\" & SkinName & ".rrz")) = 0 Then SkinName = vbNullString
  If LenB(SkinName) > 0 Then
    If LenB(Dir$(TmpDr, vbDirectory)) > 0 Then DeleteFolder TmpDr
    If LenB(Dir$(TmpDr, vbDirectory)) = 0 Then MkDir TmpDr
    Set Unzip = New clsUnzip
    Unzip.UnzipFolder = TmpDr
    Unzip.OverwriteExisting = True
    Unzip.UseFolderNames = True
    Unzip.ZipFile = App.Path & "\Skins\" & SkinName & ".rrz"
    Unzip.Directory
    For I = 1 To Unzip.FileCount
      Unzip.FileSelected(I) = LCase$(Unzip.FileDirectory(I)) = "file transfer"
    Next I
    Unzip.Unzip
    Set Unzip = Nothing
  End If
  If LenB(SkinName) > 0 And LenB(Dir$(TmpDr, vbDirectory)) > 0 Then
    Me.Picture = LoadPicture(TmpDr & "File Transfer\BG.bmp")
    cmdDisconnect.Picture = LoadPicture(TmpDr & "File Transfer\Disconnect.bmp")
    cmdQuit.Picture = LoadPicture(TmpDr & "File Transfer\Quit.bmp")
    cmdDisconnect.DisabledPicture = LoadPicture(TmpDr & "File Transfer\D_Disconnect.bmp")
    cmdQuit.DisabledPicture = LoadPicture(TmpDr & "File Transfer\D_Quit.bmp")
    cmdDisconnect.Caption = vbNullString
    cmdQuit.Caption = vbNullString
    nFile = FreeFile
    Open TmpDr & "File Transfer\Colors.txt" For Input As #nFile
    Input #nFile, TmpR, TmpG, TmpB
    FileTitleColor = RGB(TmpR, TmpG, TmpB)
    Input #nFile, TmpR, TmpG, TmpB
    FileTitleBG = RGB(TmpR, TmpG, TmpB)
    Input #nFile, TmpR, TmpG, TmpB
    PathColor = RGB(TmpR, TmpG, TmpB)
    Input #nFile, TmpR, TmpG, TmpB
    PathBG = RGB(TmpR, TmpG, TmpB)
    Input #nFile, TmpR, TmpG, TmpB
    CaptionColor = RGB(TmpR, TmpG, TmpB)
    Input #nFile, TmpR, TmpG, TmpB
    ProgressColor = RGB(TmpR, TmpG, TmpB)
    Input #nFile, TmpR, TmpG, TmpB
    ProgressBG = RGB(TmpR, TmpG, TmpB)
    Close #nFile
  Else
    Me.Picture = Nothing
    cmdDisconnect.Picture = Nothing
    cmdQuit.Picture = Nothing
    cmdDisconnect.Caption = "&Disconnect"
    cmdQuit.Caption = "&Quit"
    FileTitleColor = RGB(255, 255, 255)
    FileTitleBG = RGB(0, 0, 0)
    PathColor = RGB(255, 255, 255)
    PathBG = RGB(0, 0, 0)
    CaptionColor = RGB(255, 255, 255)
    ProgressColor = RGB(255, 255, 255)
    ProgressBG = RGB(0, 0, 0)
  End If
  lblFileTitle.ForeColor = FileTitleColor
  lblFileTitle.BackColor = FileTitleBG
  lblPath.ForeColor = PathColor
  lblPath.BackColor = PathBG
  lblPercent.ForeColor = CaptionColor
  lblSending.ForeColor = CaptionColor
  lblFileSize.ForeColor = CaptionColor
  lblTime.ForeColor = CaptionColor
  lblSpeed.ForeColor = CaptionColor
  lblStatus.ForeColor = PathColor
  lblStatus.BackColor = PathBG
  ChangeOBJColor pbPercent.hwnd, ProgressBG, ProgressColor
  If LenB(Dir$(TmpDr, vbDirectory)) > 0 Then DeleteFolder TmpDr
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "Skinning"
  Resume Next
End Sub
Private Sub cmdDisconnect_Click()
  On Error GoTo Erred
  If MessageBox("Are you sure you want to cancel the current transfer?", Question, YesNo) = "No" Then Exit Sub
  Screen.MousePointer = 13
  CancelConnection = True
  lblStatus = "Cancelled"
  lblSpeed = "0 B/S"
  lblPercent = "0%"
  pbPercent.value = 0
  lblFileSize = "0 B/0 B"
  lblTime = "Time Left: 0 Seconds"
  cmdDisconnect.Visible = False
  cmdQuit.Visible = True
  cmdQuit.Default = True
  cmdQuit.Cancel = True
  Screen.MousePointer = 0
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "Disconnect"
  Resume Next
End Sub
Private Sub cmdQuit_Click()
  On Error GoTo Erred
  Unload Me
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "Quit"
  Resume Next
End Sub
Private Sub Form_Load()
  On Error GoTo Erred
  Screen.MousePointer = 13
  ApplySkin
  tcpServer.Close
  tcpServer.LocalPort = frmMain.lFTPort
  tcpServer.Listen
  Caption = "Ripple Chat Bot File Transfer - Sending"
  lblStatus = "Waiting for connection..."
  Screen.MousePointer = 0
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "Load"
  Resume Next
End Sub
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
  On Error GoTo Erred
  Screen.MousePointer = 11
  tcpServer.Close
  Screen.MousePointer = 0
  Set frmFileTransferS = Nothing
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "Unload"
  Resume Next
End Sub
Public Sub GetData(strMessage As String, Optional ByVal ToSend As String = vbNullString)
Dim SendEncrypt As String
  On Error GoTo Erred
  Filename = vbNullString
  FileTitle = vbNullString
  FileSize = 0
  FullSize = vbNullString
  FullSent = 0
  SendTime = 0
  SentNow = 0
  bSendingFile = False
  If LenB(ToSend) = 0 Then
    lblStatus = "Getting File..."
    cdlOpen.Filter = "All Files (*.*)|*.*"
    cdlOpen.Flags = cdlOFNHideReadOnly
    cdlOpen.ShowOpen
    If LenB(cdlOpen.Filename) > 0 Then
      lblStatus = "Getting File Information..."
      Filename = cdlOpen.Filename
      FileTitle = cdlOpen.FileTitle
      lblFileTitle.Caption = FileTitle
      lblPath.Caption = ShortenFilename(cdlOpen.Filename, Me, lblPath)
      If LenB(Dir$(Filename, vbNormal)) = 0 Then
        Unload Me
        Exit Sub
      End If
      FileSize = FileLen(Filename)
      pbPercent.Max = FileSize
      FullSize = ByteSize(FileSize)
      lblFileSize = "0B/" & FullSize
      lblSpeed = "0 B/S"
      lblTime = "Time Left: Estimating..."
      lblPercent = "0%"
      pbPercent.value = 0
      lblStatus = "Awaiting Connection..."
      SendEncrypt = RC4(PublicIP, RC4_KEY)
      frmMain.Display "/w" & IIf(DII, " *", " ") & strMessage & " FTP Request |" & SendEncrypt & "|" & frmMain.lFTPort & "|" & FileTitle & "|" & FileSize
    Else
      Unload Me
    End If
  Else
    lblStatus = "Getting File Information..."
    Filename = ToSend
    FileTitle = Mid$(ToSend, InStrRev(ToSend, "\") + 1)
    lblFileTitle.Caption = FileTitle
    lblPath.Caption = ShortenFilename(Filename, Me, lblPath)
    If LenB(Dir$(Filename, vbNormal)) = 0 Then
      Unload Me
      Exit Sub
    End If
    FileSize = FileLen(Filename)
    pbPercent.Max = FileSize
    FullSize = ByteSize(FileSize)
    lblFileSize = "0B/" & FullSize
    lblSpeed = "0 B/S"
    lblTime = "Time Left: Estimating..."
    lblPercent = "0%"
    pbPercent.value = 0
    lblStatus = "Awaiting Connection..."
    SendEncrypt = RC4(PublicIP, RC4_KEY)
    frmMain.Display "/w" & IIf(DII, " *", " ") & strMessage & " FTP Request |" & SendEncrypt & "|" & frmMain.lFTPort & "|" & FileTitle & "|" & FileSize
  End If
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "GetData"
  Resume Next
End Sub
Public Sub SendData(ByVal sFile As String)
Dim sBuf      As String
Dim nFile     As Integer
Dim lRead     As Long
Dim lThisRead As Long
  On Error GoTo Erred
  nFile = FreeFile
  cmdDisconnect.Enabled = True
  bSendingFile = True
  lblTime = "Time Left: Estimating..."
  lblStatus = "Transferring"
  Open sFile For Binary Access Read As #nFile
  lblStatus = "Loading file"
  StartTime = GetTickDouble
  Do While lRead < FileSize
    DoEvents
    lThisRead = 65536
    If lThisRead + lRead > FileSize Then
      lThisRead = FileSize - lRead
    End If
    sBuf = Space$(lThisRead)
    Get #nFile, , sBuf
    lRead = lRead + lThisRead
    If CancelConnection Then
      Close #nFile
      bSendingFile = False
      tcpServer.Close
      cmdDisconnect.Visible = False
      lblStatus = "Cancelled"
      lblSpeed = "0 B/S"
      lblPercent = "0%"
      pbPercent.value = 0
      lblFileSize = "0 B/0 B"
      lblTime = "Time Left: 0 Seconds"
      cmdQuit.Visible = True
      cmdQuit.Cancel = True
      cmdQuit.Default = True
      lblStatus = "File Transfer Closed."
      Exit Sub
    End If
    tcpServer.SendData sBuf
    sBuf = Space$(0)
  Loop
  Close #nFile
  bSendingFile = False
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "TCP SendData"
  Resume Next
End Sub
Private Sub pbPercent_Click()
  On Error GoTo Erred
  If pbPercent.Scrolling = ccScrollingSmooth Then
    pbPercent.Scrolling = ccScrollingStandard
  Else
    pbPercent.Scrolling = ccScrollingSmooth
  End If
  ChangeOBJColor pbPercent.hwnd, ProgressBG, ProgressColor
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "pbPercent"
  Resume Next
End Sub
Private Sub tcpServer_Close()
  On Error GoTo Erred
  If bSendingFile Then
    CancelConnection = True
    cmdDisconnect.Visible = False
    lblStatus = "Cancelled"
    lblSpeed = "0 B/S"
    lblPercent = "0%"
    pbPercent.value = 0
    lblFileSize = "0 B/0 B"
    lblTime = "Time Left: 0 Seconds"
    cmdQuit.Visible = True
    cmdQuit.Default = True
    cmdQuit.Cancel = True
    lblStatus = "File Transfer Closed."
  Else
    cmdDisconnect.Visible = False
    lblSpeed = "0 B/S"
    lblFileSize = FullSize & "/" & FullSize
    pbPercent.value = pbPercent.Max
    lblPercent = "100%"
    lblTime = "Time Left: 0 Seconds"
    cmdQuit.Visible = True
    cmdQuit.Cancel = True
    cmdQuit.Default = True
    lblStatus = "Complete"
  End If
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "TCP Close"
  Resume Next
End Sub
Private Sub tcpServer_Connect()
  On Error GoTo Erred
  lblStatus = "Connected!"
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "TCP ServerConnect"
  Resume Next
End Sub
Private Sub tcpServer_ConnectionRequest(ByVal RequestID As Long)
  On Error GoTo Erred
  If tcpServer.State <> sckClosed Then tcpServer.Close
  tcpServer.Accept RequestID
  lblStatus = "Connecting..."
  If LenB(Dir$(Filename)) = 0 Then
    MessageBox "File Does Not Exist!", Critical, OKOnly, "File Does Not Exist!"
  Else
    SendData Filename
  End If
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "TCP Request"
  Resume Next
End Sub
Private Sub tcpServer_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
  On Error GoTo Erred
  If lblPercent.Caption = "100%" Then Exit Sub
  MessageBox "File Transfer error: " & Description, Critical, OKOnly, "File Transfer Error"
  tcpServer.Close
  lblStatus = "Errored"
  cmdDisconnect.Visible = False
  cmdQuit.Visible = True
  cmdQuit.Cancel = True
  cmdQuit.Default = True
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "TCP Error"
  Resume Next
End Sub
Private Sub tcpServer_SendProgress(ByVal bytesSent As Long, ByVal bytesRemaining As Long)
  On Error GoTo Erred
  FullSent = FullSent + bytesSent
  If SendTime = 0 Then SendTime = GetTickDouble
  If FileSize Then lblPercent = Int((FullSent - 7) / FileSize * 100) & "%"
  lblFileSize = ByteSize((FullSent - 7)) & "/" & FullSize
  If (FullSent - 7) <= pbPercent.Max Then pbPercent.value = (FullSent - 7)
  SentNow = SentNow + bytesSent
  If GetTickDouble - SendTime >= 1000 Then
    SendTime = GetTickDouble
    lblSpeed = GetSpeed((FullSent - 7), StartTime)
    lblTime = "Time Left: " & GetTime(FileSize, (FullSent - 7), StartTime)
    SentNow = 0
  Else
    SentNow = SentNow + bytesSent
  End If
  lblStatus = "Sending..."
Exit Sub
Erred:
  ErrorHandler "File Transfer Server", "TCP Send"
  Resume Next
End Sub
