VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsiTunes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private NoCOM       As Boolean
Private PlayerPath  As String
Private Sub Class_Initialize()
  PlayerPath = ReadINI("Main", "iTunesPath", Left$(SettingsFolder, 3) & "Program Files\iTunes\iTunes.exe", "Profiles\" & Profile & "\config.ini")
  WriteINI "Main", "iTunesPath", PlayerPath, "Profiles\" & Profile & "\config.ini"
End Sub
Private Sub Class_Terminate()
  On Error GoTo Erred
  NoCOM = True
Exit Sub
Erred:
  ErrorHandler "iTunes Control", "Unload"
End Sub
Private Sub Init()
  On Error GoTo Erred
  NoCOM = True
  NoCOM = Not iTunesIsOn
Exit Sub
Erred:
  ErrorHandler "iTunes Control", "Load"
End Sub
Private Function iTunesIsOn() As Boolean
  On Error GoTo Erred
  If FindWindowA("iTunes", vbNullString) > 0 Then
    iTunesIsOn = True
  Else
    iTunesIsOn = False
    NoCOM = True
  End If
Exit Function
Erred:
  ErrorHandler "iTunes Control", "iTunesIsOn"
  Resume Next
End Function
Public Function GetSong() As String
Dim iTunes As Object
  On Error GoTo Erred
  If Not iTunesIsOn Or NoCOM Then
    GetSong = Replace(MEDIA_CLOSED, "%PLAYER%", GetName)
  Else
    Set iTunes = CreateObject("iTunes.Application")
    If LenB(iTunes.CurrentTrack.Artist) > 0 Then
      GetSong = iTunes.CurrentTrack.Artist & " - " & iTunes.CurrentTrack.Name
    Else
      GetSong = iTunes.CurrentTrack.Name
    End If
    Set iTunes = Nothing
  End If
  Exit Function
Erred:
  If Err.Number = 429 Or Err.Number = 91 Then
    If Err.Number = 429 Then GetSong = Replace(MEDIA_CLOSED, "%PLAYER%", GetName)
    If Err.Number = 91 Then GetSong = MEDIA_NOTHING
  Else
    ErrorHandler "iTunes Control", "Title"
  End If
End Function
Public Function GoJumpToFile(ByVal strFile As String) As Byte
Dim iTunes          As Object
Dim Tracks_SongName As Object
Dim FoundTrack      As Object
  On Error GoTo Erred
  If Not iTunesIsOn And NoCOM Then
    GoJumpToFile = 0
    Exit Function
  End If
  Set iTunes = CreateObject("iTunes.Application")
  If LenB(strFile) > 0 Then
    Set Tracks_SongName = iTunes.LibraryPlaylist.Search(strFile, 5)
  Else
    Exit Function
  End If
  If Tracks_SongName Is Nothing Then
    GoJumpToFile = 2
    Set FoundTrack = Nothing
    Set Tracks_SongName = Nothing
    Exit Function
  End If
  Set FoundTrack = Nothing
  Set FoundTrack = Tracks_SongName.Item(1)
  If FoundTrack Is Nothing Then
    GoJumpToFile = 2
  Else
    FoundTrack.Play
    GoJumpToFile = 1
  End If
  Set FoundTrack = Nothing
  Set Tracks_SongName = Nothing
  Set iTunes = Nothing
Exit Function
Erred:
  If Err.Number = 429 Or Err.Number = 91 Then
    GoJumpToFile = 0
  Else
    ErrorHandler "iTunes Control", "GoJumpToFile "
  End If
End Function
Public Function DoPlay() As Boolean
Dim iTunes As Object
  On Error GoTo Erred
  If Not iTunesIsOn And NoCOM Then
    DoPlay = False
    Exit Function
  End If
  Set iTunes = CreateObject("iTunes.Application")
  Select Case iTunes.PlayerState
    Case 0
      iTunes.PlayPause
    Case 2
      iTunes.Resume
    Case 3
      iTunes.Resume
  End Select
  DoPlay = True
  Set iTunes = Nothing
Exit Function
Erred:
  If Err.Number = 429 Then
    DoPlay = False
  Else
    ErrorHandler "iTunes Control", "DoPlay"
  End If
End Function
Public Function DoPause() As Boolean
Dim iTunes As Object
  On Error GoTo Erred
  If Not iTunesIsOn And NoCOM Then
    DoPause = False
    Exit Function
  End If
  Set iTunes = CreateObject("iTunes.Application")
  If iTunes.PlayerState = 1 Then
    iTunes.PlayPause
    DoPause = True
  End If
  Set iTunes = Nothing
Exit Function
Erred:
  If Err.Number = 429 Then
    DoPause = False
  Else
    ErrorHandler "iTunes Control", "DoPause"
  End If
End Function
Public Function DoStop() As Boolean
Dim iTunes As Object
  On Error GoTo Erred
  If Not iTunesIsOn And NoCOM Then
    DoStop = False
    Exit Function
  End If
  Set iTunes = CreateObject("iTunes.Application")
  iTunes.Stop
  DoStop = True
  Set iTunes = Nothing
Exit Function
Erred:
  If Err.Number = 429 Then
    DoStop = False
  Else
    ErrorHandler "iTunes Control", "DoStop"
  End If
End Function
Public Function DoFadeOutStop() As Boolean
Dim iTunes  As Object
Dim CurVol  As Integer
Dim RealVol As Integer
  On Error GoTo Erred
  If Not iTunesIsOn And NoCOM Then
    DoFadeOutStop = False
    Exit Function
  End If
  Set iTunes = CreateObject("iTunes.Application")
  CurVol = iTunes.SoundVolume
  RealVol = CurVol
  Do Until CurVol = 0
    CurVol = CurVol - 1
    SetVolume CurVol
    DoEvents
    Sleep 5
  Loop
  DoStop
  SetVolume RealVol
  DoFadeOutStop = True
  Set iTunes = Nothing
Exit Function
Erred:
  If Err.Number = 429 Then
    DoFadeOutStop = False
  Else
    ErrorHandler "iTunes Control", "DoFadeOutStop"
  End If
End Function
Public Function GoPrevious() As Boolean
Dim iTunes As Object
  On Error GoTo Erred
  If Not iTunesIsOn And NoCOM Then
    GoPrevious = False
    Exit Function
  End If
  Set iTunes = CreateObject("iTunes.Application")
  iTunes.PreviousTrack
  GoPrevious = True
  Set iTunes = Nothing
Exit Function
Erred:
  If Err.Number = 429 Then
    GoPrevious = False
  Else
    ErrorHandler "iTunes Control", "GoPrevious"
  End If
End Function
Public Function GoNext() As Boolean
Dim iTunes As Object
  On Error GoTo Erred
  If Not iTunesIsOn And NoCOM Then
    GoNext = False
    Exit Function
  End If
  Set iTunes = CreateObject("iTunes.Application")
  iTunes.NextTrack
  GoNext = True
  Set iTunes = Nothing
Exit Function
Erred:
  If Err.Number = 429 Then
    GoNext = False
  Else
    ErrorHandler "iTunes Control", "GoNext"
  End If
End Function
Public Function DoRandom() As Byte
Dim iTunes As Object
  On Error GoTo Erred
  If Not iTunesIsOn And NoCOM Then
    DoRandom = 0
    Exit Function
  End If
  Set iTunes = CreateObject("iTunes.Application")
  If iTunes.LibraryPlaylist.Shuffle Then
    iTunes.LibraryPlaylist.Shuffle = False
    DoRandom = 1
  Else
    iTunes.LibraryPlaylist.Shuffle = True
    DoRandom = 2
  End If
  Set iTunes = Nothing
Exit Function
Erred:
  If Err.Number = 429 Then
    DoRandom = 0
  Else
    ErrorHandler "iTunes Control", "DoRandom"
  End If
End Function
Public Function DoRepeat() As Byte
Dim iTunes As Object
  On Error GoTo Erred
  If Not iTunesIsOn And NoCOM Then
    DoRepeat = 0
    Exit Function
  End If
  Set iTunes = CreateObject("iTunes.Application")
  If iTunes.LibraryPlaylist.SongRepeat = 0 Then
    iTunes.LibraryPlaylist.SongRepeat = 1
    DoRepeat = 1
  ElseIf iTunes.LibraryPlaylist.SongRepeat = 1 Then
    iTunes.LibraryPlaylist.SongRepeat = 2
    DoRepeat = 2
  Else
    iTunes.LibraryPlaylist.SongRepeat = 0
    DoRepeat = 3
  End If
  Set iTunes = Nothing
Exit Function
Erred:
  If Err.Number = 429 Then
NoiTunes:
    DoRepeat = 0
  Else
    ErrorHandler "iTunes Control", "DoRepeat"
  End If
End Function
Public Function SetVolume(intIndex As Integer) As Boolean
Dim iTunes As Object
  On Error GoTo Erred
  If Not iTunesIsOn And NoCOM Then
    SetVolume = False
    Exit Function
  End If
  Set iTunes = CreateObject("iTunes.Application")
  iTunes.SoundVolume = intIndex
  SetVolume = True
  Set iTunes = Nothing
Exit Function
Erred:
  If Err.Number = 429 Then
    SetVolume = False
  Else
    ErrorHandler "iTunes Control", "SetVolume"
  End If
End Function
Public Function DoLoadPlayer() As Byte
  On Error GoTo Erred
  If LenB(Dir$(PlayerPath)) > 0 Then
    Shell PlayerPath, vbNormalNoFocus
    Init
    DoLoadPlayer = 1
  Else
    DoLoadPlayer = 2
  End If
  Exit Function
Erred:
  ErrorHandler "iTunes Control", "DoLoadPlayer"
  Resume Next
End Function
Public Function DoClosePlayer() As Boolean
Dim iTunes As Object
  On Error GoTo Erred
  If Not iTunesIsOn And NoCOM Then
    DoClosePlayer = False
    Exit Function
  End If
  Set iTunes = CreateObject("iTunes.Application")
  iTunes.Quit
  DoClosePlayer = True
  Set iTunes = Nothing
Exit Function
Erred:
  If Err.Number = 429 Then
    DoClosePlayer = False
  Else
    ErrorHandler "iTunes Control", "DoClosePlayer"
  End If
End Function
Public Function GetName() As String
  GetName = "iTunes"
End Function
