VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsConvert"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private Function CheckLegal(ByVal Conversion As String, ByVal CheckString As String) As Boolean
Dim I As Integer
  On Error GoTo Erred
  For I = 1 To Len(CheckString)
    If Conversion = "B" Then
      Select Case Mid$(CheckString, I, 1)
        Case "0", "1"
          CheckLegal = True
        Case Else
          CheckLegal = False
      End Select
    ElseIf Conversion = "D" Then
      Select Case Mid$(CheckString, I, 1)
        Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
          CheckLegal = True
        Case Else
          CheckLegal = False
      End Select
    ElseIf Conversion = "H" Then
      Select Case UCase$(Mid$(CheckString, I, 1))
        Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"
          CheckLegal = True
        Case Else
          CheckLegal = False
      End Select
    End If
  Next I
Exit Function
Erred:
  ErrorHandler "Convert", "CheckLegal"
  Resume Next
End Function
Public Function ConvertBinaryToDecimal(BinVal As String) As String
Dim Length As Long
Dim I      As Integer
Dim iVal   As Long
  On Error GoTo Erred
  If CheckLegal("B", BinVal) Then
    Length = Len(BinVal)
    For I = 0 To Length - 1
      iVal = iVal + (CInt(Mid$(BinVal, Length - I, 1)) * (2 ^ I))
    Next I
    ConvertBinaryToDecimal = iVal
  Else
    ConvertBinaryToDecimal = "Illegal character!"
  End If
Exit Function
Erred:
  ErrorHandler "Convert", "BinToDec"
  Resume Next
End Function
Public Function ConvertBinaryToHexadecimal(BinVal As String) As String
Dim Length As Long
Dim I      As Long
  On Error GoTo Erred
  If CheckLegal("B", BinVal) Then
    Select Case (Len(BinVal) Mod 4)
      Case 1
        BinVal = "000" & BinVal
      Case 2
        BinVal = "00" & BinVal
      Case 3
        BinVal = "0" & BinVal
    End Select
    Length = Len(BinVal)
    For I = Length - 3 To 1 Step -4
      ConvertBinaryToHexadecimal = GetValue(Mid$(BinVal, I, 4), True) + ConvertBinaryToHexadecimal
    Next I
  Else
    ConvertBinaryToHexadecimal = "Illegal character!"
  End If
Exit Function
Erred:
  ErrorHandler "Convert", "BinToHex"
  Resume Next
End Function
Public Function ConvertBinaryToText(BinVal As String) As String
Dim I      As Integer
Dim tmpNum As String
Dim Ans    As String
  On Error GoTo Erred
  For I = 1 To Len(BinVal) Step 8
    tmpNum = Mid$(BinVal, I, 8)
    tmpNum = ConvertBinaryToDecimal(tmpNum)
    If Val(tmpNum) < 256 And Val(tmpNum) > 31 Then
      Ans = Ans & ChrW$(tmpNum)
    Else
      Ans = "Must be between 00100000 and 11111111!"
      Exit For
    End If
  Next I
  ConvertBinaryToText = Ans
  Exit Function
Erred:
  ErrorHandler "Convert", "BinToText"
  Resume Next
End Function
Public Function ConvertDecimalToBinary(value As String, Optional ByVal X As Integer) As String
Dim iVal     As Single
Dim temp     As Single
Dim Ret      As Long
Dim I        As Long
Dim Str      As String
Dim BinVal() As Long
  On Error GoTo Erred
  If CheckLegal("D", value) Then
    iVal = value
    Do
      temp = iVal / 2
      Ret = InStr(temp, ".")
      If Ret > 0 Then temp = Left$(temp, Ret - 1)
      Ret = iVal Mod 2
      ReDim Preserve BinVal(I)
      BinVal(I) = Ret
      I = I + 1
      iVal = temp
    Loop While temp > 0
    For I = UBound(BinVal) To 0 Step -1
      Str = Str + CStr(BinVal(I))
    Next I
    If X = 3 Then
      Select Case Len(Str) Mod 3
        Case 1
          Str = "00" & Str
        Case 2
          Str = "0" & Str
      End Select
    ElseIf X = 4 Then
      Select Case Len(Str) Mod 4
        Case 1
          Str = "000" & Str
        Case 2
          Str = "00" & Str
        Case 3
          Str = "0" & Str
        End Select
    End If
    ConvertDecimalToBinary = Str
  Else
    ConvertDecimalToBinary = "Illegal character!"
  End If
Exit Function
Erred:
  ErrorHandler "Convert", "DecToBin"
  Resume Next
End Function
Public Function ConvertDecimalToHexadecimal(value As String) As String
Dim iVal     As Double
Dim temp     As Double
Dim Ret      As Integer
Dim I        As Long
Dim BinVal() As String
Dim Strs     As String
  On Error GoTo Erred
  If CheckLegal("D", Trim$(value)) Then
    iVal = CDbl(value)
    Do
      temp = iVal / 16
      Ret = InStr(temp, ".")
      If Ret > 0 Then temp = Left$(temp, Ret - 1)
      Ret = BigMod(iVal, 16)
      ReDim Preserve BinVal(I)
      BinVal(I) = NoToHex(Ret)
      I = I + 1
      iVal = temp
    Loop While temp > 0
    For I = UBound(BinVal) To 0 Step -1
      Strs = Strs + CStr(BinVal(I))
    Next I
    ConvertDecimalToHexadecimal = Strs
  Else
    ConvertDecimalToHexadecimal = "Illegal character!"
  End If
Exit Function
Erred:
  ErrorHandler "Convert", "DecToHex"
  Resume Next
End Function
Public Function ConvertDecimalToText(value As String, Optional Restrict As Boolean = True) As String
Dim I      As Integer
Dim tmpNum As String
Dim Ans    As String
  On Error GoTo Erred
  For I = 1 To Len(value) Step 3
    tmpNum = Mid$(value, I, 3)
    If Restrict Then
      If Val(tmpNum) <= 255 And Val(tmpNum) >= 32 Then
        Ans = Ans & ChrW$(tmpNum)
      Else
        Ans = "Must be between 032 and 255!"
        Exit For
      End If
    Else
      If Val(tmpNum) <= 255 And Val(tmpNum) >= 0 Then
        Ans = Ans & ChrW$(tmpNum)
      Else
        Ans = ""
        Exit For
      End If
    End If
  Next I
  ConvertDecimalToText = Ans
  Exit Function
Erred:
  ErrorHandler "Convert", "DecToText"
  Resume Next
End Function
Public Function ConvertHexadecimalToBinary(HexVal As String) As String
Dim Length As Long
Dim I      As Integer
  On Error GoTo Erred
  If CheckLegal("H", HexVal) Then
    Length = Len(HexVal)
    For I = 0 To Length - 1
      ConvertHexadecimalToBinary = ConvertDecimalToBinary(HexToNo(Mid$(HexVal, Length - I, 1)), 4) + ConvertHexadecimalToBinary
    Next I
  Else
    ConvertHexadecimalToBinary = "Illegal character!"
  End If
Exit Function
Erred:
  ErrorHandler "Convert", "HexToBin"
  Resume Next
End Function
Public Function ConvertHexadecimalToDecimal(BinVal As String) As String
Dim Length As Long
Dim I      As Integer
Dim temp   As Integer
Dim iVal   As Double
  On Error GoTo Erred
  If CheckLegal("H", BinVal) Then
    Length = Len(BinVal)
    For I = 0 To Length - 1
      temp = HexToNo(Mid$(BinVal, Length - I, 1))
      iVal = iVal + (temp * (16 ^ I))
    Next I
    ConvertHexadecimalToDecimal = iVal
  Else
    ConvertHexadecimalToDecimal = "Illegal character!"
  End If
Exit Function
Erred:
  ErrorHandler "Convert", "HexToDec"
  Resume Next
End Function
Public Function ConvertHexadecimalToText(value As String) As String
Dim I      As Integer
Dim tmpNum As String
Dim Ans    As String
  On Error GoTo Erred
  For I = 1 To Len(value) Step 2
    tmpNum = Mid$(value, I, 2)
    tmpNum = ConvertHexadecimalToDecimal(tmpNum)
    If (Val(tmpNum) < 256 And Val(tmpNum) > 31) Then
      Ans = Ans & ChrW$(tmpNum)
    Else
      Ans = "Must be between 20 and FF!"
      Exit For
    End If
  Next I
  ConvertHexadecimalToText = Ans
  Exit Function
Erred:
  ErrorHandler "Convert", "HexToText"
  Resume Next
End Function
Public Function ConvertTextToBinary(value As String) As String
Dim I   As Integer
Dim Ans As String
  On Error GoTo Erred
  For I = 1 To Len(value)
    Ans = Ans & Format$(ConvertDecimalToBinary(Asc(Mid$(value, I, 1))), "00000000")
  Next I
  ConvertTextToBinary = Ans
  Exit Function
Erred:
  ErrorHandler "Convert", "TextToBin"
  Resume Next
End Function
Public Function ConvertTextToDecimal(value As String) As String
Dim I   As Integer
Dim Ans As String
  On Error GoTo Erred
  For I = 1 To Len(value)
    Ans = Ans & Format$(Asc(Mid$(value, I, 1)), "000")
  Next I
  ConvertTextToDecimal = Ans
  Exit Function
Erred:
  ErrorHandler "Convert", "TextToDec"
  Resume Next
End Function
Public Function ConvertTextToHexadecimal(value As String) As String
Dim I   As Integer
Dim Ans As String
  On Error GoTo Erred
  For I = 1 To Len(value)
    Ans = Ans & Format$(ConvertDecimalToHexadecimal(Asc(Mid$(value, I, 1))), "@@")
  Next I
  Ans = Replace$(Ans, " ", "0")
  ConvertTextToHexadecimal = Ans
  Exit Function
Erred:
  ErrorHandler "Convert", "TextToHex"
  Resume Next
End Function
Private Function GetValue(value As String, ByVal flag As Boolean) As String
Dim Length As Long
Dim I      As Integer
Dim temp   As Integer
Dim iVal   As Integer
  On Error GoTo Erred
  Length = Len(value)
  For I = 0 To Length - 1
    If flag = False Then
      temp = CInt(Mid$(value, Length - I, 1))
      iVal = iVal + (temp * (2 ^ I))
    Else
      temp = HexToNo(Mid$(value, Length - I, 1))
      iVal = iVal + (temp * (2 ^ I))
    End If
  Next I
  GetValue = NoToHex(iVal)
Exit Function
Erred:
  ErrorHandler "Convert", "GetVal"
  Resume Next
End Function
Private Function HexToNo(I As String) As Integer
  On Error GoTo Erred
  Select Case LCase$(I)
    Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
      HexToNo = CInt(I)
    Case "a"
      HexToNo = 10
    Case "b"
      HexToNo = 11
    Case "c"
      HexToNo = 12
    Case "d"
      HexToNo = 13
    Case "e"
      HexToNo = 14
    Case "f"
      HexToNo = 15
  End Select
Exit Function
Erred:
  ErrorHandler "Convert", "HexToNo"
  Resume Next
End Function
Private Function NoToHex(I As Integer) As String
  On Error GoTo Erred
  Select Case I
    Case 0 To 9
      NoToHex = CStr(I)
    Case 10
      NoToHex = "A"
    Case 11
      NoToHex = "B"
    Case 12
      NoToHex = "C"
    Case 13
      NoToHex = "D"
    Case 14
      NoToHex = "E"
    Case 15
      NoToHex = "F"
  End Select
Exit Function
Erred:
  ErrorHandler "Convert", "NoToHex"
  Resume Next
End Function
Function ArabicToRoman(lngNumber As Long) As String
Dim lngThousands    As Long
Dim lngFiveHundreds As Long
Dim lngHundreds     As Long
Dim lngFifties      As Long
Dim lngTens         As Long
Dim lngFives        As Long
Dim lngOnes         As Long
  On Error GoTo Erred
  lngOnes = lngNumber
  lngThousands = lngOnes \ 1000
  lngOnes = lngOnes - lngThousands * 1000
  lngFiveHundreds = lngOnes \ 500
  lngOnes = lngOnes - lngFiveHundreds * 500
  lngHundreds = lngOnes \ 100
  lngOnes = lngOnes - lngHundreds * 100
  lngFifties = lngOnes \ 50
  lngOnes = lngOnes - lngFifties * 50
  lngTens = lngOnes \ 10
  lngOnes = lngOnes - lngTens * 10
  lngFives = lngOnes \ 5
  lngOnes = lngOnes - lngFives * 5
  ArabicToRoman = String(lngThousands, "M")
  If lngHundreds = 4 Then
    If lngFiveHundreds = 1 Then
      ArabicToRoman = ArabicToRoman & "CM"
    Else
      ArabicToRoman = ArabicToRoman & "CD"
    End If
  Else
    ArabicToRoman = ArabicToRoman & String(lngFiveHundreds, "D") & String(lngHundreds, "C")
  End If
  If lngTens = 4 Then
    If lngFifties = 1 Then
      ArabicToRoman = ArabicToRoman & "XC"
    Else
      ArabicToRoman = ArabicToRoman & "XL"
    End If
  Else
    ArabicToRoman = ArabicToRoman & String(lngFifties, "L") & String(lngTens, "X")
  End If
  If lngOnes = 4 Then
    If lngFives = 1 Then
      ArabicToRoman = ArabicToRoman & "IX"
    Else
      ArabicToRoman = ArabicToRoman & "IV"
    End If
  Else
    ArabicToRoman = ArabicToRoman & String(lngFives, "V") & String(lngOnes, "I")
  End If
  Exit Function
Erred:
  ErrorHandler "Convert", "ArabicToRoman"
  Resume Next
End Function
Function RomanToArabic(ByVal strRoman As String) As String
Dim I             As Long
Dim strLen        As Long
Dim intChar       As Integer
Dim intNextChar   As Integer
Dim intNextChar1  As Integer
Dim tmpVal        As Long
  On Error GoTo Erred
  strRoman = LCase(strRoman)
  If InStr(strRoman, "iiii") Or InStr(strRoman, "xxxx") Or InStr(strRoman, "cccc") Or InStr(strRoman, "vv") Or InStr(strRoman, "ll") Or InStr(strRoman, "dd") Then
    RomanToArabic = "Illegal Roman Numeral!"
    Exit Function
  End If
  strLen = Len(strRoman)
  For I = 1 To strLen
    Select Case Mid$(strRoman, I, 1)
      Case "i"
        Mid$(strRoman, I, 1) = 1
      Case "v"
        Mid$(strRoman, I, 1) = 2
      Case "x"
        Mid$(strRoman, I, 1) = 3
      Case "l"
        Mid$(strRoman, I, 1) = 4
      Case "c"
        Mid$(strRoman, I, 1) = 5
      Case "d"
        Mid$(strRoman, I, 1) = 6
      Case "m"
        Mid$(strRoman, I, 1) = 7
      Case Else
        RomanToArabic = "Roman Numerals contain I, V, X, L, C, D, and M."
        Exit Function
    End Select
  Next
  For I = 1 To strLen
    intChar = CInt(Mid$(strRoman, I, 1))
    If I < strLen Then
      intNextChar = CInt(Mid$(strRoman, I + 1, 1))
      If I < strLen - 1 Then
        intNextChar1 = CInt(Mid$(strRoman, I + 2, 1))
      Else
        intNextChar1 = 0
      End If
      Select Case intChar
        Case 7
          GetTmpVal intChar, intNextChar, intNextChar1, tmpVal, I, 1000
        Case 6
          GetTmpVal intChar, intNextChar, intNextChar1, tmpVal, I, 500
        Case 5
          GetTmpVal intChar, intNextChar, intNextChar1, tmpVal, I, 100
        Case 4
          GetTmpVal intChar, intNextChar, intNextChar1, tmpVal, I, 50
        Case 3
          GetTmpVal intChar, intNextChar, intNextChar1, tmpVal, I, 10
        Case 2
          GetTmpVal intChar, intNextChar, intNextChar1, tmpVal, I, 5
        Case 1
          GetTmpVal intChar, intNextChar, intNextChar1, tmpVal, I, 1
      End Select
    Else
      tmpVal = tmpVal + ConvVal(intChar)
    End If
    If tmpVal = -1 Then Exit For
  Next
  RomanToArabic = Trim$(Str$(tmpVal))
  Exit Function
Erred:
  ErrorHandler "Convert", "RomanToArabic"
  Resume Next
End Function
Private Sub GetTmpVal(intChar As Integer, intNextChar As Integer, intNextChar1 As Integer, tmpVal As Long, I As Long, intValue As Integer)
  On Error GoTo Erred
  If intNextChar > intChar Then
    If ((intNextChar - intChar = 1 And (intChar <> 2 And intChar <> 6)) Or (intNextChar - intChar = 2 And (intNextChar <> 4 And intNextChar <> 6))) And intNextChar1 < intNextChar And intNextChar1 <> intChar Then
      tmpVal = tmpVal + ConvVal(intNextChar) - intValue
      I = I + 1
    Else
      tmpVal = -1
    End If
  Else
    tmpVal = tmpVal + intValue
  End If
Exit Sub
Erred:
  ErrorHandler "Convert", "GetTmpVal"
  Resume Next
End Sub
Private Function ConvVal(intVal As Integer) As Long
  On Error GoTo Erred
  Select Case intVal
    Case 7
      ConvVal = 1000
    Case 6
      ConvVal = 500
    Case 5
      ConvVal = 100
    Case 4
      ConvVal = 50
    Case 3
      ConvVal = 10
    Case 2
      ConvVal = 5
    Case 1
      ConvVal = 1
  End Select
Exit Function
Erred:
  ErrorHandler "Convert", "ConvVal"
  Resume Next
End Function
