Attribute VB_Name = "modUnzip"
Option Explicit
Private Type UNZIPnames
  S(0 To 1023)    As String
End Type
Private Type CBChar
  ch(0 To 32800)  As Byte
End Type
Private Type CBCh
  ch(0 To 255)    As Byte
End Type
Private Type USERFUNCTION
  lptrPrnt        As Long
  lptrSound       As Long
  lptrReplace     As Long
  lptrPassword    As Long
  lptrMessage     As Long
  lptrService     As Long
  lTotalSizeComp  As Long
  lTotalSize      As Long
  lCompFactor     As Long
  lNumMembers     As Long
  cchComment      As Integer
End Type
Public Type ZIPVERSIONTYPE
  major           As Byte
  minor           As Byte
  patchlevel      As Byte
  not_used        As Byte
End Type
Public Type UZPVER
  structlen       As Long
  flag            As Long
  betalevel       As String * 10
  Date            As String * 20
  zlib            As String * 10
  UnZip           As ZIPVERSIONTYPE
  zipinfo         As ZIPVERSIONTYPE
  os2dll          As ZIPVERSIONTYPE
  windll          As ZIPVERSIONTYPE
End Type
Private Declare Function Wiz_SingleEntryUnzip Lib "UnZip32.dll" (ByVal ifnc As Long, ByRef ifnv As UNZIPnames, ByVal xfnc As Long, ByRef xfnv As UNZIPnames, dcll As DCLIST, Userf As USERFUNCTION) As Long
Public Declare Sub UzpVersion2 Lib "UnZip32.dll" (uzpv As UZPVER)
Private m_cUnzip  As clsUnzip
Private m_bCancel As Boolean
Private Function plAddressOf(ByVal lPtr As Long) As Long
  On Error GoTo Erred
  plAddressOf = lPtr
Exit Function
Erred:
  ErrorHandler "mUnzip", "plAddressOf"
  Resume Next
End Function
Private Sub UnzipMessageCallBack(ByVal ucsize As Long, ByVal csiz As Long, ByVal cfactor As Integer, ByVal mo As Integer, ByVal dy As Integer, ByVal yr As Integer, ByVal HH As Integer, ByVal mm As Integer, ByVal C As Byte, ByRef fName As CBCh, ByRef meth As CBCh, ByVal crc As Long, ByVal fCrypt As Byte)
Dim sFileName As String
Dim sFolder As String
Dim dDate As Date
Dim sMethod As String
Dim iPos As Long
  On Error Resume Next
  sFileName = strConv(fName.ch, vbUnicode)
  ParseFileFolder sFileName, sFolder
  dDate = DateSerial(yr, mo, HH)
  dDate = dDate + TimeSerial(HH, mm, 0)
  sMethod = strConv(meth.ch, vbUnicode)
  iPos = InStr(sMethod, vbNullChar)
  If (iPos > 1) Then sMethod = Left$(sMethod, iPos - 1)
  m_cUnzip.DirectoryListAddFile sFileName, sFolder, dDate, csiz, crc, ((fCrypt And 64) = 64), cfactor, sMethod
End Sub
Private Function UnzipPrintCallback(ByRef fName As CBChar, ByVal X As Long) As Long
Dim iPos As Long
Dim sFile As String
  On Error Resume Next
  If X > 1 And X < 1024 Then
    ReDim B(0 To X) As Byte
    RtlMoveMemory B(0), fName, X
    sFile = strConv(B, vbUnicode)
    ReplaceSection sFile, "/", "\"
    m_cUnzip.ProgressReport sFile
  End If
  UnzipPrintCallback = 0
End Function
Private Function UnzipPasswordCallBack(ByRef pwd As CBCh, ByVal X As Long, ByRef s2 As CBCh, ByRef Name As CBCh) As Long
Dim bCancel As Boolean
Dim sPassword As String
Dim B() As Byte
Dim lSize As Long
  On Error Resume Next
  UnzipPasswordCallBack = 1
  If m_bCancel Then Exit Function
  m_cUnzip.PasswordRequest sPassword, bCancel
  sPassword = Trim$(sPassword)
  If bCancel Or Len(sPassword) = 0 Then
    m_bCancel = True
    Exit Function
  End If
  lSize = Len(sPassword)
  If lSize > 254 Then lSize = 254
  B = strConv(sPassword, vbFromUnicode)
  RtlMoveMemory pwd.ch(0), B(0), lSize
  UnzipPasswordCallBack = 0
End Function
Private Function UnzipReplaceCallback(ByRef fName As CBChar) As Long
Dim eResponse As EUZOverWriteResponse
Dim iPos      As Long
Dim sFile     As String
  On Error Resume Next
  eResponse = euzDoNotOverwrite
  sFile = strConv(fName.ch, vbUnicode)
  iPos = InStr(sFile, vbNullChar)
  If (iPos > 1) Then sFile = Left$(sFile, iPos - 1)
  ReplaceSection sFile, "/", "\"
  m_cUnzip.OverwriteRequest sFile, eResponse
  UnzipReplaceCallback = eResponse
End Function
Private Function UnZipServiceCallback(ByRef mname As CBChar, ByVal X As Long) As Long
Dim iPos    As Long
Dim sInfo   As String
Dim bCancel As Boolean
  On Error Resume Next
  If X > 1 And X < 1024 Then
    ReDim B(0 To X) As Byte
    RtlMoveMemory B(0), mname, X
    sInfo = strConv(B, vbUnicode)
    iPos = InStr(sInfo, vbNullChar)
    If iPos > 0 Then sInfo = Left$(sInfo, iPos - 1)
    ReplaceSection sInfo, "\", "/"
    m_cUnzip.Service sInfo, bCancel
    If bCancel Then
      UnZipServiceCallback = 1
    Else
      UnZipServiceCallback = 0
    End If
  End If
End Function
Private Sub ParseFileFolder(ByRef sFileName As String, ByRef sFolder As String)
Dim iPos     As Long
Dim iLastPos As Long
  On Error GoTo Erred
  iPos = InStr(sFileName, vbNullChar)
  If iPos <> 0 Then sFileName = Left$(sFileName, iPos - 1)
  iLastPos = ReplaceSection(sFileName, "/", "\")
  If (iLastPos > 1) Then
    sFolder = Left$(sFileName, iLastPos - 2)
    sFileName = Mid$(sFileName, iLastPos)
  End If
Exit Sub
Erred:
  ErrorHandler "mUnzip", "ParseFileFolder"
  Resume Next
End Sub
Private Function ReplaceSection(ByRef sString As String, ByVal sToReplace As String, ByVal sReplaceWith As String) As Long
Dim iPos     As Long
Dim iLastPos As Long
  iLastPos = 1
  On Error GoTo Erred
  Do
    iPos = InStr(iLastPos, sString, "/")
    If (iPos > 1) Then
      Mid$(sString, iPos, 1) = "\"
      iLastPos = iPos + 1
    End If
  Loop While Not (iPos = 0)
  ReplaceSection = iLastPos
Exit Function
Erred:
  ErrorHandler "mUnzip", "ReplaceSection"
  Resume Next
End Function
Public Function VBUnzip(cUnzipObject As clsUnzip, tDCL As DCLIST, iIncCount As Long, sInc() As String, iExCount As Long, sExc() As String) As Long
Dim tUser As USERFUNCTION
Dim lR    As Long
Dim tInc  As UNZIPnames
Dim tExc  As UNZIPnames
Dim I     As Long
  On Error GoTo ErrorHandler
  Set m_cUnzip = cUnzipObject
  tUser.lptrPrnt = plAddressOf(AddressOf UnzipPrintCallback)
  tUser.lptrSound = 0&
  tUser.lptrReplace = plAddressOf(AddressOf UnzipReplaceCallback)
  tUser.lptrPassword = plAddressOf(AddressOf UnzipPasswordCallBack)
  tUser.lptrMessage = plAddressOf(AddressOf UnzipMessageCallBack)
  tUser.lptrService = plAddressOf(AddressOf UnZipServiceCallback)
  If (iIncCount > 0) Then
    For I = 1 To iIncCount
      tInc.S(I - 1) = sInc(I)
    Next I
    tInc.S(iIncCount) = vbNullChar
  Else
    tInc.S(0) = vbNullChar
  End If
  If (iExCount > 0) Then
    For I = 1 To iExCount
      tExc.S(I - 1) = sExc(I)
    Next I
    tExc.S(iExCount) = vbNullChar
  Else
    tExc.S(0) = vbNullChar
  End If
  m_bCancel = False
  VBUnzip = Wiz_SingleEntryUnzip(iIncCount, tInc, iExCount, tExc, tDCL, tUser)
  Exit Function
ErrorHandler:
Dim lErr As Long, sErr As Long
  lErr = Err.Number: sErr = Err.Description
  VBUnzip = -1
  Set m_cUnzip = Nothing
  On Error GoTo Erred
  Err.Raise lErr, App.EXEName & ".VBUnzip", sErr
Exit Function
Erred:
  ErrorHandler "mUnzip", "VBUnzip"
  Resume Next
End Function
