Attribute VB_Name = "modRegistry"
Option Explicit
Private m_lngRetVal         As Long
Private Const REG_SZ        As Long = 1
Private Const REG_DWORD     As Long = 4
Private Const Error_SUCCESS As Long = 0
Private Declare Function RegCloseKey Lib "advapi32.dll" (ByVal lngRootKey As Long) As Long
Private Declare Function RegOpenKeyA Lib "advapi32.dll" (ByVal lngRootKey As Long, ByVal lpSubKey As String, phkResult As Long) As Long
Private Declare Function RegQueryValueExA Lib "advapi32.dll" (ByVal lngRootKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long
Private Declare Function RegSetValueExA Lib "advapi32.dll" (ByVal lngRootKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpData As Any, ByVal cbData As Long) As Long
Private Declare Function RegCreateKeyA Lib "advapi32.dll" (ByVal lngRootKey As Long, ByVal lpSubKey As String, phkResult As Long) As Long
Public Function regQuery_A_Key(ByVal lngRootKey As Long, ByVal strRegKeyPath As String, ByVal strRegSubKey As String, Optional ByVal RemoveNT As Boolean = True) As Variant
Dim intPosition   As Integer
Dim lngKeyHandle  As Long
Dim lngDataType   As Long
Dim lngBufferSize As Long
Dim lngBuffer     As Long
Dim strBuffer     As String
  On Error GoTo Erred
  m_lngRetVal = RegOpenKeyA(lngRootKey, strRegKeyPath, lngKeyHandle)
  If lngKeyHandle = 0 Then
    regQuery_A_Key = ""
    m_lngRetVal = RegCloseKey(lngKeyHandle)
    Exit Function
  End If
  m_lngRetVal = RegQueryValueExA(lngKeyHandle, strRegSubKey, 0&, lngDataType, ByVal 0&, lngBufferSize)
  If lngKeyHandle = 0 Then
    regQuery_A_Key = ""
    m_lngRetVal = RegCloseKey(lngKeyHandle)
    Exit Function
  End If
  Select Case lngDataType
    Case REG_SZ
      strBuffer = Space$(lngBufferSize)
      m_lngRetVal = RegQueryValueExA(lngKeyHandle, strRegSubKey, 0&, 0&, ByVal strBuffer, lngBufferSize)
      If m_lngRetVal <> Error_SUCCESS Then
        regQuery_A_Key = ""
      Else
        If RemoveNT Then
          intPosition = InStr(1, strBuffer, vbNullChar)
          If intPosition > 0 Then
            regQuery_A_Key = Left$(strBuffer, intPosition - 1)
          Else
            regQuery_A_Key = strBuffer
          End If
        Else
          regQuery_A_Key = strBuffer
        End If
      End If
    Case REG_DWORD
      m_lngRetVal = RegQueryValueExA(lngKeyHandle, strRegSubKey, 0&, lngDataType, lngBuffer, 4&)
      If m_lngRetVal <> Error_SUCCESS Then
        regQuery_A_Key = ""
      Else
        regQuery_A_Key = lngBuffer
      End If
    Case Else
      regQuery_A_Key = ""
  End Select
  m_lngRetVal = RegCloseKey(lngKeyHandle)
Exit Function
Erred:
  errorhandler "Registry", "QueryKey"
  Resume Next
End Function
Public Sub regCreate_Key_Value(ByVal lngRootKey As Long, ByVal strRegKeyPath As String, ByVal strRegSubKey As String, varRegData As Variant)
Dim lngKeyHandle As Long
Dim lngDataType  As Long
Dim lngKeyValue  As Long
Dim strKeyValue  As String
  On Error GoTo Erred
  If IsNumeric(varRegData) Then
    lngDataType = REG_DWORD
  Else
    lngDataType = REG_SZ
  End If
  m_lngRetVal = RegCreateKeyA(lngRootKey, strRegKeyPath, lngKeyHandle)
  Select Case lngDataType
    Case REG_SZ
      strKeyValue = Trim(varRegData) & Chr(0)
      m_lngRetVal = RegSetValueExA(lngKeyHandle, strRegSubKey, 0&, lngDataType, ByVal strKeyValue, Len(strKeyValue))
    Case REG_DWORD
      lngKeyValue = CLng(varRegData)
      m_lngRetVal = RegSetValueExA(lngKeyHandle, strRegSubKey, 0&, lngDataType, lngKeyValue, 4&)
  End Select
  m_lngRetVal = RegCloseKey(lngKeyHandle)
Exit Sub
Erred:
  errorhandler "Registry", "CreateKeyValue"
  Resume Next
End Sub
Public Function regCreate_A_Key(ByVal lngRootKey As Long, ByVal strRegKeyPath As String)
Dim lngKeyHandle As Long
  On Error GoTo Erred
  m_lngRetVal = RegCreateKeyA(lngRootKey, strRegKeyPath, lngKeyHandle)
  m_lngRetVal = RegCloseKey(lngKeyHandle)
Exit Function
Erred:
  errorhandler "Registry", "CreateAKey"
  Resume Next
End Function
