Attribute VB_Name = "modParseStats"
Option Explicit
Private Function GetCharacterName(ByVal StatString As String, ByVal start As Byte, ByRef cName As String) As Byte
  On Error GoTo Erred
  cName = Mid$(StatString, start, InStr(start, StatString, ",") - start)
  GetCharacterName = InStr(start, StatString, ",") + 1
Exit Function
Erred:
  ErrorHandler "Parse", "GetCharName"
  Resume Next
End Function
Private Function GetServer(ByVal StatString As String, ByRef Server As String) As Byte
  On Error GoTo Erred
  Server = Mid$(StatString, 5, InStr(5, StatString, ",") - 5)
  GetServer = InStr(5, StatString, ",") + 1
Exit Function
Erred:
  ErrorHandler "Parse", "GetServer"
  Resume Next
End Function
Private Sub MakeArray(ByVal Text As String, ByRef nArray() As Byte)
Dim I As Long
  On Error GoTo Erred
  ReDim nArray(0) As Byte
  For I = 0 To Len(Text) - 1
    nArray(I) = CByte(Asc(Mid$(Text, I + 1, 1)))
    If I <> Len(Text) Then
      ReDim Preserve nArray(0 To UBound(nArray) + 1) As Byte
    End If
  Next I
Exit Sub
Erred:
  ErrorHandler "Parse", "MakeArray"
  Resume Next
End Sub
Public Function ParseD2Stats(ByVal Stats As String)
Dim d2Classes(0 To 7) As String
Dim statbuf           As String
Dim P()               As Byte
Dim Server            As String
Dim Name              As String
Dim sLen              As Byte
Dim CharClass         As Byte
Dim Female            As Boolean
Dim CharLevel         As Long
Dim Hardcore          As Boolean
Dim Dead              As Boolean
Dim Ladder            As Boolean
Dim Expansion         As Boolean
Dim D2Act             As String
Dim D2Title           As Integer
  On Error GoTo Erred
  d2Classes(0) = "Amazon"
  d2Classes(1) = "Sorceress"
  d2Classes(2) = "Necromancer"
  d2Classes(3) = "Paladin"
  d2Classes(4) = "Barbarian"
  d2Classes(5) = "Druid"
  d2Classes(6) = "Assassin"
  d2Classes(7) = "unknown class"
  If Len(Stats) > 4 Then
    sLen = GetServer(Stats, Server)
    sLen = GetCharacterName(Stats, sLen, Name)
    MakeArray Mid$(Stats, sLen), P()
  End If
  If Left$(Stats, 4) = "VD2D" Then
    statbuf = statbuf & "Diablo II: "
  Else
    statbuf = statbuf & "Diablo II Lord of Destruction: "
  End If
  If Len(Stats) = 4 Then
    statbuf = statbuf & "Open Character"
  Else
    CharClass = P(13) - 1
    If CharClass < 0 Or CharClass > 6 Then CharClass = 7
    Female = CharClass = 0 Or CharClass = 1 Or CharClass = 6
    CharLevel = P(25)
    Hardcore = P(26) And &H4
    Dead = P(26) And &H8
    Expansion = P(26) And &H20
    Ladder = Not (P(30) = &HFF)
    If Left$(Stats, 4) = "PX2D" And (P(26) And &H20) Then
      Select Case P(27)
        Case &H80
          D2Act = "1 (Normal)"
          D2Title = 0
        Case &H82
          D2Act = "2 (Normal)"
          D2Title = 0
        Case &H84
          D2Act = "3 (Normal)"
          D2Title = 0
        Case &H86
          D2Act = "4/5 (Normal)"
          D2Title = 0
        Case &H88
          D2Act = "5 (Normal)"
          D2Title = 0
        Case &H8A
          D2Act = "1 (Nightmare)"
          D2Title = 1
        Case &H8C
          D2Act = "2 (Nightmare)"
          D2Title = 1
        Case &H8E
          D2Act = "3 (Nightmare)"
          D2Title = 1
        Case &H90
          D2Act = "4/5 (Nightmare)"
          D2Title = 1
        Case &H92
          D2Act = "5 (Nightmare)"
          D2Title = 1
        Case &H94
          D2Act = "1 (Hell)"
          D2Title = 2
        Case &H96
          D2Act = "2 (Hell)"
          D2Title = 2
        Case &H98
          D2Act = "3 (Hell)"
          D2Title = 2
        Case &H9A
          D2Act = "4/5 (Hell)"
          D2Title = 2
        Case &H9C
          D2Act = "5 (Hell)"
          D2Title = 2
        Case &H9E
          D2Act = vbNullString
          D2Title = 3
        Case Else
          D2Act = vbNullString
          D2Title = P(27)
      End Select
      Select Case D2Title
        Case &H0
          
        Case &H1
          If Hardcore Then
            statbuf = statbuf & "Destroyer "
          Else
            statbuf = statbuf & "Slayer "
          End If
        Case &H2
          If Hardcore Then
            statbuf = statbuf & "Conquerer "
          Else
            statbuf = statbuf & "Champion "
          End If
        Case &H3
          If Hardcore Then
            statbuf = statbuf & "Guardian "
          Else
            If Not Female Then
              statbuf = statbuf & "Patriarch "
            Else
              statbuf = statbuf & "Matriarch "
            End If
          End If
        Case Else
          statbuf = statbuf & "Unknown (0x" & Hex$(P(27)) & ")"
      End Select
    Else
      Select Case P(27)
        Case &H80
          D2Act = "1 (Normal)"
          D2Title = 0
        Case &H82
          D2Act = "2 (Normal)"
          D2Title = 0
        Case &H84
          D2Act = "3 (Normal)"
          D2Title = 0
        Case &H86
          D2Act = "4 (Normal)"
          D2Title = 0
        Case &H88
          D2Act = "1 (Nightmare)"
          D2Title = 1
        Case &H8A
          D2Act = "2 (Nightmare)"
          D2Title = 1
        Case &H8C
          D2Act = "3 (Nightmare)"
          D2Title = 1
        Case &H8E
          D2Act = "4 (Nightmare)"
          D2Title = 1
        Case &H90
          D2Act = "1 (Hell)"
          D2Title = 2
        Case &H92
          D2Act = "2 (Hell)"
          D2Title = 2
        Case &H94
          D2Act = "3 (Hell)"
          D2Title = 2
        Case &H96
          D2Act = "4 (Hell)"
          D2Title = 2
        Case &H98
          D2Act = vbNullString
          D2Title = 3
        Case Else
          D2Act = vbNullString
          D2Title = 0
      End Select
      Select Case D2Title
        Case &H0
          
        Case &H1
          If Not Female Then
            If Hardcore Then
              statbuf = statbuf & "Count "
            Else
              statbuf = statbuf & "Sir "
            End If
          Else
            If Hardcore Then
              statbuf = statbuf & "Countess "
            Else
              statbuf = statbuf & "Dame "
            End If
          End If
        Case &H2
          If Not Female Then
            If Hardcore Then
              statbuf = statbuf & "Duke "
            Else
              statbuf = statbuf & "Lord "
            End If
          Else
            If Hardcore Then
              statbuf = statbuf & "Duchess "
            Else
              statbuf = statbuf & "Lady "
            End If
          End If
        Case &H3
          If Not Female Then
            If Hardcore Then
              statbuf = statbuf & "King "
            Else
              statbuf = statbuf & "Baron "
            End If
          Else
            If Hardcore Then
              statbuf = statbuf & "Queen "
            Else
              statbuf = statbuf & "Baroness "
            End If
          End If
        Case Else
          statbuf = statbuf & "Unknown (0x" & Hex$(P(27)) & ")"
      End Select
    End If
    statbuf = statbuf & Name & ", a "
    If Hardcore Then
      If Dead Then
        statbuf = statbuf & "dead hardcore "
      Else
        statbuf = statbuf & "hardcore "
      End If
    End If
    statbuf = statbuf & "level " & CharLevel & " "
    If Ladder Then statbuf = statbuf & "ladder "
    statbuf = statbuf & d2Classes(CharClass) & IIf(LenB(D2Act) > 0, " in act " & D2Act, "") & " on realm " & Server & IIf(Expansion, " (Expansion)", "")
  End If
  ParseD2Stats = statbuf
Exit Function
Erred:
  ErrorHandler "Parse", "ParseD2Stats [" & Stats & "]"
  Resume Next
End Function
Public Function ParseStatString(ByVal StatString As String) As String
Dim OutBuf    As String
Dim Values()  As String
Dim cType     As String
Dim ClassName As String
Dim ClassLev  As Long
Dim I         As Integer
  On Error GoTo Erred
  Select Case StrReverse(Left$(StatString, 4))
    Case "DRTL"
      Values() = Split(Mid$(StatString, 6), " ")
      If UBound(Values) <> 8 Then
        If StatString = "LTRD" Then
          OutBuf = "a Diablo bot"
        Else
          OutBuf = "an illegal Diablo character: [ " & StatString & " ]"
        End If
      Else
        Select Case Values(1)
          Case &H0
            cType = "Warrior"
          Case &H1
            cType = "Rogue"
          Case &H2
            cType = "Sorcerer"
          Case Else
            cType = Values(1)
        End Select
        OutBuf = "Diablo: Level " & Values(0) & " " & cType & " with " & Values(2) & " dot" & IIf(Values(2) <> "1", "s", "") & ", " & Values(3) & " strength, " & Values(4) & " magic, " & Values(5) & " dexterity, " & Values(6) & " vitality, " & Values(7) & " gold"
      End If
    Case "DSHR"
      Values() = Split(Mid$(StatString, 6), " ")
      If UBound(Values) <> 8 Then
        If StatString = "RHSD" Then
          OutBuf = OutBuf & "a Diablo Shareware bot"
        Else
          OutBuf = OutBuf & "an illegal Diablo Shareware Character: [ " & StatString & " ]"
        End If
      Else
        Select Case Values(1)
          Case &H0
            cType = "Warrior"
          Case Else
            cType = Values(1)
        End Select
        OutBuf = "Diablo Shareware: Level " & Values(0) & " " & cType & " with " & Values(2) & " dot" & IIf(Values(2) <> "1", "s", "") & ", " & Values(3) & " strength, " & Values(4) & " magic, " & Values(5) & " dexterity, " & Values(6) & " vitality, " & Values(7) & " gold"
      End If
    Case "D2DV"
      OutBuf = OutBuf & ParseD2Stats(StatString)
    Case "D2XP"
      OutBuf = OutBuf & ParseD2Stats(StatString)
    Case "STAR"
      Values() = Split(Mid$(StatString, 6), " ")
      If UBound(Values) <> 8 Then
        If StatString = "RATS" Then
          OutBuf = "a Starcraft bot"
        Else
          OutBuf = "an illegal Starcraft Account: [ " & StatString & " ]"
        End If
      Else
        OutBuf = "Starcraft" & IIf((Values(3) = 1), " (spawn) ", vbNullString) & ": " & _
                 Values(2) & " normal game win" & IIf(Values(2) <> "1", "s", "") & _
                 IIf(Values(0) > 0, ", with a rating of " & Values(0) & _
                 IIf(Values(1) > 0, " and a rank of " & Values(1), "") & " on the ladder", "")
      End If
    Case "SSHR"
      OutBuf = OutBuf & "StarCraft Shareware"
    Case "JSTR"
      Values() = Split(Mid$(StatString, 6), " ")
      If UBound(Values) <> 8 Then
        If StatString = "RTSJ" Then
          OutBuf = "a Japanese Starcraft bot"
        Else
          OutBuf = "an illegal Japanese Starcraft Account: [ " & StatString & " ]"
        End If
      Else
        OutBuf = "Japanese Starcraft" & IIf((Values(3) = 1), " (spawn) ", vbNullString) & ": " & _
                 Values(2) & " normal game win" & IIf(Values(2) <> "1", "s", "") & _
                 IIf(Values(0) > 0, ", with a rating of " & Values(0) & _
                 IIf(Values(1) > 0, " and a rank of " & Values(1), "") & " on the ladder", "")
      End If
    Case "SEXP"
      Values() = Split(Mid$(StatString, 6), " ")
      If UBound(Values) <> 8 Then
        If StatString = "PXES" Then
          OutBuf = OutBuf & "a Starcraft Brood War bot"
        Else
          OutBuf = OutBuf & "an illegal Starcraft Brood War Account: [ " & StatString & " ]"
        End If
      Else
        OutBuf = "Starcraft Brood War" & IIf((Values(3) = 1), " (spawn) ", vbNullString) & ": " & _
                 Values(2) & " normal game win" & IIf(Values(2) <> "1", "s", "") & _
                 IIf(Values(0) > 0, ", with a rating of " & Values(0) & _
                 IIf(Values(1) > 0, " and a rank of " & Values(1), "") & " on the ladder", "")
      End If
    Case "W2BN"
      Values() = Split(Mid$(StatString, 6), " ")
      If UBound(Values) <> 8 Then
        If StatString = "RATS" Then
          OutBuf = OutBuf & "a Warcraft II bot"
        Else
          OutBuf = OutBuf & "an illegal Warcraft II Account: [ " & StatString & " ]"
        End If
      Else
        OutBuf = "Warcraft II" & IIf((Values(3) = 1), " (spawn) ", vbNullString) & ": " & _
                 Values(2) & " normal game win" & IIf(Values(2) <> "1", "s", "") & _
                 IIf(Values(0) > 0, ", with a rating of " & Values(0) & _
                 IIf(Values(1) > 0, " and a rank of " & Values(1), "") & " on the ladder", "") & _
                 IIf(Values(6) > 0, ", a rating of " & Values(6) & _
                 IIf(Values(7) > 0, " and a rank of " & Values(7), "") & " on the IronMan ladder", "")
      End If
    Case "WAR3"
      If Len(StatString) > 10 Then
        StatString = StatString & " "
        Values() = Split(Mid$(StatString, 5), " ")
        For I = LBound(Values) To UBound(Values)
          Values(I) = StrReverse(Values(I))
        Next I
        ClassName = Mid$(Values(1), 3, 1)
        If IsNumeric(Right$(Values(1), 1)) Then ClassLev = CLng(Right$(Values(1), 1))
        Values(2) = StrReverse(Values(2))
        Select Case ClassName
          Case "H"
            Select Case ClassLev
              Case &H1
                cType = "Peon"
              Case &H2
                cType = "Human Footman (25 wins)"
              Case &H3
                cType = "Human Knight (250 wins)"
              Case &H4
                cType = "Human Archmage (500 wins)"
              Case &H5
                cType = "Human Medivh (1500 wins)"
              Case Else
                cType = "Human Unknown [ " & ClassLev & " ]"
            End Select
          Case "O"
            Select Case ClassLev
              Case &H1
                cType = "Peon"
              Case &H2
                cType = "Orc Grunt (25 wins)"
              Case &H3
                cType = "Orc Tauren (250 wins)"
              Case &H4
                cType = "Orc Far Seer (500 wins)"
              Case &H5
                cType = "Orc Thrall (1500 wins)"
              Case Else
                cType = "Orc Unknown [ " & ClassLev & " ]"
            End Select
          Case "N"
            Select Case ClassLev
              Case &H1
                cType = "Peon"
              Case &H2
                cType = "Night Elf Archer (25 wins)"
              Case &H3
                cType = "Night Elf Druid of the Claw (250 wins)"
              Case &H4
                cType = "Night Elf Priestess of the Moon (500 wins)"
              Case &H5
                cType = "Night Elf Furion Stormrage (1500 wins)"
              Case Else
                cType = "Night Elf Unknown [ " & ClassLev & " ]"
            End Select
          Case "U"
            Select Case ClassLev
              Case &H1
                cType = "Peon"
              Case &H2
                cType = "Undead Ghoul (25 wins)"
              Case &H3
                cType = "Undead Abomination (250 wins)"
              Case &H4
                cType = "Undead Lich (500 wins)"
              Case &H5
                cType = "Undead Tichondrius (1500 wins)"
              Case Else
                cType = "Undead Unknown [ " & ClassLev & " ]"
            End Select
          Case "R"
            Select Case ClassLev
              Case &H1
                cType = "Peon"
              Case &H2
                cType = "Random Green Dragon Whelp (25 wins)"
              Case &H3
                cType = "Random Blue Dragon (250 wins)"
              Case &H4
                cType = "Random Red Dragon (500 wins)"
              Case &H5
                cType = "Random Deathwing (1500 wins)"
              Case Else
                cType = "Random Unknown [ " & ClassLev & " ]"
            End Select
          Case Else
            cType = "Unknown [ " & ClassName & ", " & ClassLev & " ]"
        End Select
        OutBuf = "Warcraft III Reign of Chaos: Level " & Values(2) & ", with " & cType & " as icon" & IIf(LenB(Values(3)) > 0, ", and in clan " & Values(3), "")
      Else
        OutBuf = "WarCraft III Reign of Chaos [ Not Parsed: " & StatString & " ]"
      End If
    Case "W3XP"
      If Len(StatString) > 10 Then
        StatString = StatString & " "
        Values() = Split(Mid$(StatString, 5), " ")
        For I = LBound(Values) To UBound(Values)
          Values(I) = StrReverse(Values(I))
        Next I
        ClassName = Mid$(Values(1), 3, 1)
        If IsNumeric(Right$(Values(1), 1)) Then ClassLev = CLng(Right$(Values(1), 1))
        Values(2) = StrReverse(Values(2))
        Select Case ClassName
          Case "H"
            Select Case ClassLev
              Case &H1
                cType = "Peon"
              Case &H2
                cType = "Human Rifleman (25 wins)"
              Case &H3
                cType = "Human Sorceress (150 wins)"
              Case &H4
                cType = "Human Spellbreaker (350 wins)"
              Case &H5
                cType = "Human Blood Mage (750 wins)"
              Case &H6
                cType = "Human Jaina (1500 wins)"
              Case Else
                cType = "Human Unknown [ " & ClassLev & " ]"
            End Select
          Case "O"
            Select Case ClassLev
              Case &H1
                cType = "Peon"
              Case &H2
                cType = "Orc Troll Headhunter (25 wins)"
              Case &H3
                cType = "Orc Shaman (150 wins)"
              Case &H4
                cType = "Orc Spirit Walker (350 wins)"
              Case &H5
                cType = "Orc Shadow Hunter (750 wins)"
              Case &H6
                cType = "Orc Rexxar (1500 wins)"
              Case Else
                cType = "Orc Unknown [ " & ClassLev & " ]"
            End Select
          Case "N"
            Select Case ClassLev
              Case &H1
                cType = "Peon"
              Case &H2
                cType = "Night Elf Huntress (25 wins)"
              Case &H3
                cType = "Night Elf Druid of the Talon (150 wins)"
              Case &H4
                cType = "Night Elf Dryad (350 wins)"
              Case &H5
                cType = "Night Elf Keeper of the Grove (750 wins)"
              Case &H6
                cType = "Night Elf Maiev (1500 wins)"
              Case Else
                cType = "Night Elf Unknown [ " & ClassLev & " ]"
            End Select
          Case "U"
            Select Case ClassLev
              Case &H1
                cType = "Peon"
              Case &H2
                cType = "Undead Crypt Fiend (25 wins)"
              Case &H3
                cType = "Undead Banshee (150 wins)"
              Case &H4
                cType = "Undead Destroyer (350 wins)"
              Case &H5
                cType = "Undead Crypt Lord (750 wins)"
              Case &H6
                cType = "Undead Sylvanas (1500 wins)"
              Case Else
                cType = "Undead Unknown [ " & ClassLev & " ]"
            End Select
          Case "R"
            Select Case ClassLev
              Case &H1
                cType = "Peon"
              Case &H2
                cType = "Random Myrmidon (25 wins)"
              Case &H3
                cType = "Random Siren (150 wins)"
              Case &H4
                cType = "Random Dragon Turtle (350 wins)"
              Case &H5
                cType = "Random Sea Witch (750 wins)"
              Case &H6
                cType = "Random Illidan (1500 wins)"
              Case Else
                cType = "Random Unknown [ " & ClassLev & " ]"
            End Select
          Case "D"
            Select Case ClassLev
              Case &H1
                cType = "Peon"
              Case &H2
                cType = "Tournament Felguard (10 wins)"
              Case &H3
                cType = "Tournament Infernal (75 wins)"
              Case &H4
                cType = "Tournament Doomguard (150 wins)"
              Case &H5
                cType = "Tournament Pit Lord (250 wins)"
              Case &H6
                cType = "Tournament Archimonde (500 wins)"
              Case Else
                cType = "Tournament Unknown [ " & ClassLev & " ]"
            End Select
          Case Else
            Select Case Values(1)
              Case "WCGP"
                cType = "WCG Player"
              Case "WCGS"
                cType = "WCG Staff"
              Case Else
                cType = "Unknown [ " & ClassName & ", " & ClassLev & " ]"
            End Select
        End Select
        OutBuf = "Warcraft III the Frozen Throne: Level " & Values(2) & ", with " & cType & " as icon" & IIf(LenB(Values(3)) > 0, ", and in clan " & Values(3), "")
      Else
        OutBuf = "WarCraft III the Frozen Throne [ Not Parsed: " & StatString & " ]"
      End If
    Case "CHAT"
      OutBuf = "a Chat bot"
    Case Else
      OutBuf = "an unknown client [ " & StatString & " ]"
  End Select
  ParseStatString = OutBuf
Exit Function
Erred:
  ErrorHandler "Parse", "ParseStatString [" & StatString & "]"
  Resume Next
End Function
Public Function ParseMapStats(ByVal strStats As String, Optional ByVal Shorten As Boolean = False) As String
Dim strMapSize   As String
Dim strGameType  As String
Dim strGameSpeed As String
Dim strPenalty   As String
Dim strIcon      As String
Dim strCreator   As String
Dim strMapName   As String
Dim varSplit     As Variant
  On Error GoTo Erred
  varSplit = Split(strStats, ",")
  If LenB(varSplit(1)) > 0 Then
    strMapSize = "Size: " & (Mid$(varSplit(1), 1, 1) * 32) & "x" & (Mid$(varSplit(1), 2, 1) * 32)
  Else
    strMapSize = "Size: Default"
  End If
  strGameSpeed = "Speed: " & GameSpeed(varSplit(3))
  strIcon = "Icon: " & MapIcon(varSplit(4))
  strGameType = "Type: " & GameType(varSplit(5))
  strPenalty = "Rules: " & GamePenalty(varSplit(7))
  If UBound(varSplit) >= 11 Then
    If LenB(varSplit(11)) > 0 Then
      strCreator = "Creator: " & Left$(varSplit(11), InStr(1, varSplit(11), vbCr) - 1)
      strMapName = "Map Name: " & Mid$(varSplit(11), InStr(1, varSplit(11), vbCr) + 1)
    Else
      strCreator = "Creator: [UNKNOWN]"
      strMapName = "Map Name: [UNKNOWN]"
    End If
  ElseIf UBound(varSplit) >= 10 Then
    If LenB(varSplit(10)) > 0 Then
      strCreator = "Creator: " & Left$(varSplit(10), InStr(1, varSplit(10), vbCr) - 1)
      strMapName = "Map Name: " & Mid$(varSplit(10), InStr(1, varSplit(10), vbCr) + 1)
    Else
      strCreator = "Creator: [UNKNOWN]"
      strMapName = "Map Name: [UNKNOWN]"
    End If
  ElseIf UBound(varSplit) >= 9 Then
    If LenB(varSplit(9)) > 0 Then
      strCreator = "Creator: " & Left$(varSplit(9), InStr(1, varSplit(9), vbCr) - 1)
      strMapName = "Map Name: " & Mid$(varSplit(9), InStr(1, varSplit(9), vbCr) + 1)
    Else
      strCreator = "Creator: [UNKNOWN]"
      strMapName = "Map Name: [UNKNOWN]"
    End If
  End If
  strMapName = Replace$(strMapName, vbCr, "")
  strMapName = Replace$(strMapName, vbLf, "")
  If Shorten Then
    ParseMapStats = strMapName & vbCrLf & _
                    strGameSpeed & vbCrLf & _
                    strGameType
  Else
    ParseMapStats = strCreator & vbCrLf & _
                    strMapName & vbCrLf & _
                    strMapSize & vbCrLf & _
                    strGameSpeed & vbCrLf & _
                    strIcon & vbCrLf & _
                    strGameType & vbCrLf & _
                    strPenalty
  End If
  Exit Function
Erred:
  ErrorHandler "Parse", "ParseMapStats"
  Resume Next
End Function
Private Function MapIcon(ByVal strCase As String) As String
  On Error GoTo Erred
  Select Case strCase
    Case "1"
      MapIcon = "Blizzard Approved"
    Case "2"
      MapIcon = "Ladder"
    Case "3"
      MapIcon = "GF"
    Case "4"
      MapIcon = "KBK"
    Case Else
      MapIcon = "None"
  End Select
  Exit Function
Erred:
  ErrorHandler "Parse", "MapIcon"
  Resume Next
End Function
Private Function GamePenalty(ByVal strCase As String) As String
  On Error GoTo Erred
  Select Case strCase
    Case "2"
      GamePenalty = "Dissconnect is a Loss"
    Case "4"
      GamePenalty = "1 Team Victory only"
    Case Else
      GamePenalty = "No rules"
  End Select
  Exit Function
Erred:
  ErrorHandler "Parse", "GamePenalty"
  Resume Next
End Function
Private Function GameSpeed(ByVal strCase As String) As String
  On Error GoTo Erred
  Select Case strCase
    Case "0"
      GameSpeed = "Slowest"
    Case "1"
      GameSpeed = "Slower"
    Case "2"
      GameSpeed = "Slow"
    Case "3"
      GameSpeed = "Normal"
    Case "4"
      GameSpeed = "Fast"
    Case "5"
      GameSpeed = "Faster"
    Case "6"
      GameSpeed = "Fastest"
    Case Else
      GameSpeed = "Default"
  End Select
  Exit Function
Erred:
  ErrorHandler "Parse", "GameSpeed"
  Resume Next
End Function
Private Function GameType(ByVal strCase As String) As String
  On Error GoTo Erred
  Select Case strCase
    Case "2"
      GameType = "Melee"
    Case "3"
      GameType = "Free For All"
    Case "4"
      GameType = "One on One"
    Case "5"
      GameType = "Capture the Flag"
    Case "6"
      GameType = "Greed"
    Case "7"
      GameType = "Slaughter"
    Case "8"
      GameType = "Sudden Death"
    Case "9"
      GameType = "Ladder"
    Case "a"
      GameType = "Use Map Settings"
    Case "b"
      GameType = "Team Melee"
    Case "c"
      GameType = "Team Free For All"
    Case "d"
      GameType = "Team Capture the Flag"
    Case "f"
      GameType = "Top vs. Bottom"
    Case "10"
      GameType = "Iron Man Ladder"
    Case Else
      GameType = "Unknowen Game Type (" & strCase & ")"
  End Select
  Exit Function
Erred:
  ErrorHandler "Parse", "GameType"
  Resume Next
End Function
Public Function DecodeMapData(ByVal Encoded As String, ByRef Decoded As String) As Long
Dim enc()  As Byte
Dim dec()  As Byte
Dim I      As Long
Dim J      As Long
Dim D      As Byte
Dim lngLen As Long
  On Error GoTo Erred
  enc = strConv(Encoded, vbFromUnicode)
  For I = 0 To UBound(enc)
    If (I Mod 8) Then
      ReDim Preserve dec(lngLen)
      dec(lngLen) = (enc(I) And ((RShift(D, 1 + J) Or Not 1)))
      J = J + 1
      lngLen = lngLen + 1
    Else
      J = 0
      D = enc(I)
    End If
  Next I
  Decoded = strConv(dec, vbUnicode)
  DecodeMapData = lngLen
Exit Function
Erred:
  ErrorHandler "Parse", "DecodeMapData"
  Resume Next
End Function
Public Function D2GameStats(ByVal Stats As Long) As String
Dim strStats As String
  On Error GoTo Erred
  If Stats = D2GAME_DOWN Then
    D2GameStats = "Realm Down"
  ElseIf Stats = D2GAME_GONE Then
    D2GameStats = "Game Doesn't Exist"
  Else
    If (Stats And D2GAME_EMPTY) Then strStats = "Empty "
    If (Stats And D2GAME_EXPANSION) Then strStats = strStats & "Expansion "
    If (Stats And D2GAME_HARDCORE) Then strStats = strStats & "Hardcore "
    If (Stats And D2GAME_LADDER) Then strStats = strStats & "Ladder "
    If (Stats And D2GAME_HELL) Then strStats = strStats & "Hell "
    If (Stats And D2GAME_NIGHTMARE) Then strStats = strStats & "Nightmare "
    D2GameStats = Trim$(strStats)
  End If
Exit Function
Erred:
  ErrorHandler "Parse", "D2GameStats"
  Resume Next
End Function
Private Function RShift(ByVal pnValue As Long, ByVal pnShift As Long) As Long
  On Error GoTo Erred
  RShift = CLng(pnValue \ (2 ^ pnShift))
Exit Function
Erred:
  ErrorHandler "Parse", "RShift"
  Resume Next
End Function
