Attribute VB_Name = "modFunctions"
Option Explicit
Private hConnection           As Long
Private hOpen                 As Long
Private Type LARGE_INTEGER
  lowpart                     As Long
  highpart                    As Long
End Type
Private Type MEMORYSTATUS
  dwLength                    As Long
  dwMemoryLoad                As Long
  dwTotalPhys                 As Long
  dwAvailPhys                 As Long
  dwTotalPageFile             As Long
  dwAvailPageFile             As Long
  dwTotalVirtual              As Long
  dwAvailVirtual              As Long
End Type
Private Type OSVERSIONINFOEX
  dwOSVersionInfoSize         As Long
  dwMajorVersion              As Long
  dwMinorVersion              As Long
  dwBuildNumber               As Long
  dwPlatformID                As Long
  szCSDVersion                As String * 128
  dwServicePackMajor          As Integer
  dwServicePackMinor          As Integer
  wSuiteMask                  As Integer
  wProductType                As Byte
  wReserved                   As Byte
End Type
Private Type BITMAP
  bmType                      As Long
  bmWidth                     As Long
  bmHeight                    As Long
  bmWidthBytes                As Long
  bmPlanes                    As Integer
  bmBitsPixel                 As Integer
  bmBits                      As Long
End Type
Private Type WAVEOUTCAPS
  wMid                        As Integer
  wPid                        As Integer
  vDriverVersion              As Long
  szPname                     As String * 32
  dwFormats                   As Long
  wChannels                   As Integer
  dwSupport                   As Long
End Type
Private Type VS_FIXEDFILEINFO
  dwSignature                 As Long
  dwStrucVersionl             As Integer
  dwStrucVersionh             As Integer
  dwFileVersionMSl            As Integer
  dwFileVersionMSh            As Integer
  dwFileVersionLSl            As Integer
  dwFileVersionLSh            As Integer
  dwProductVersionMSl         As Integer
  dwProductVersionMSh         As Integer
  dwProductVersionLSl         As Integer
  dwProductVersionLSh         As Integer
End Type
Private Type SYSTEM_INFO
  wProcessorArchitecture      As Integer
  wReserved                   As Integer
  dwPageSize                  As Long
  lpMinimumApplicationAddress As Long
  lpMaximumApplicationAddress As Long
  dwActiveProcessorMask       As Long
  dwNumberOfProcessors        As Long
  dwProcessorType             As Long
  dwAllocationGranularity     As Long
  wProcessorLevel             As Integer
  wProcessorRevision          As Integer
End Type
Private Type SCROLLINFO
  cbSize                      As Long
  fMask                       As Long
  nMin                        As Long
  nMax                        As Long
  nPage                       As Long
  nPos                        As Long
  nTrackPos                   As Long
End Type
Private Declare Sub CoTaskMemFree Lib "ole32" (ByVal pv As Long)
Private Declare Sub GetLocalTime Lib "kernel32" (lpSystemTime As SYSTEMTIME)
Private Declare Sub GetSystemInfo Lib "kernel32" (lpSystemInfo As SYSTEM_INFO)
Private Declare Sub GetSystemTime Lib "kernel32" (lpSystemTime As SYSTEMTIME)
Private Declare Sub GlobalMemoryStatus Lib "kernel32" (lpBuffer As MEMORYSTATUS)
Private Declare Function SHGetSpecialFolderLocation Lib "shell32" (ByVal hwndOwner As Long, ByVal nFolder As Long, ppidl As Long) As Long
Private Declare Function SHGetPathFromIDList Lib "shell32" (pidl As Long, ByVal pszPath As String) As Long
Private Declare Function FileTimeToLocalFileTime Lib "kernel32" (lpFileTime As FILETIME, lpLocalFileTime As FILETIME) As Long
Private Declare Function GetFileVersionInfoA Lib "Version.dll" (ByVal lptstrFilename As String, ByVal dwhandle As Long, ByVal dwlen As Long, lpData As Any) As Long
Private Declare Function GetFileVersionInfoSizeA Lib "Version.dll" (ByVal lptstrFilename As String, lpdwHandle As Long) As Long
Private Declare Function VerQueryValueA Lib "Version.dll" (pBlock As Any, ByVal lpSubBlock As String, lplpBuffer As Any, puLen As Long) As Long
Private Declare Function waveOutGetNumDevs Lib "winmm.dll" () As Long
Private Declare Function waveOutGetDevCapsA Lib "winmm.dll" (ByVal uDeviceID As Long, lpCaps As WAVEOUTCAPS, ByVal uSize As Long) As Long
Private Declare Function GetDiskFreeSpaceA Lib "kernel32" (ByVal lpRootPathName As String, lpSectorsPerCluster As Long, lpBytesPerSector As Long, lpNumberOfFreeClusters As Long, lpTotalNumberOfClusters As Long) As Long
Private Declare Function GetDiskFreeSpaceExA Lib "kernel32" (ByVal lpRootPathName As String, lpFreeBytesAvailableToCaller As LARGE_INTEGER, lpTotalNumberOfBytes As LARGE_INTEGER, lpTotalNumberOfFreeBytes As LARGE_INTEGER) As Long
Private Declare Function GetVersion Lib "kernel32" () As Long
Private Declare Function GetVersionExA Lib "kernel32" (lpVersionInformation As OSVERSIONINFOEX) As Long
Private Declare Function GetPrivateProfileStringA Lib "kernel32" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileStringA Lib "kernel32" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private Declare Function GetWindowTextA Lib "user32" (ByVal hwnd As Long, ByVal lpString As String, ByVal cch As Long) As Long
Private Declare Function GetLocaleInfoA Lib "kernel32" (ByVal locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Function GetComputerNameA Lib "kernel32" (ByVal lpBuffer As String, nSize As Long) As Long
Private Declare Function GetUserNameA Lib "advapi32.dll" (ByVal lpBuffer As String, nSize As Long) As Long
Private Declare Function PathCompactPathA Lib "shlwapi" (ByVal hDC As Long, ByVal lpszPath As String, ByVal DX As Long) As Long
Private Declare Function GetMenu Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetMenuItemID Lib "user32" (ByVal hMenu As Long, ByVal nPos As Long) As Long
Private Declare Function GetSubMenu Lib "user32" (ByVal hMenu As Long, ByVal nPos As Long) As Long
Private Declare Function SetMenuItemBitmaps Lib "user32" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long, ByVal hBitmapUnchecked As Long, ByVal hBitmapChecked As Long) As Long
Private Declare Function GetDriveTypeA Lib "kernel32" (ByVal nDrive As String) As Long
Private Declare Function GetVolumeInformationA Lib "Kernel32.dll" (ByVal lpRootPathName As String, ByVal lpVolumeNameBuffer As String, ByVal nVolumeNameSize As Integer, lpVolumeSerialNumber As Long, lpMaximumComponentLength As Long, lpFileSystemFlags As Long, ByVal lpFileSystemNameBuffer As String, ByVal nFileSystemNameSize As Long) As Long
Private Declare Function GetFileTime Lib "kernel32" (ByVal hFile As Long, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME) As Long
Private Declare Function SetFileTime Lib "kernel32" (ByVal hFile As Long, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME) As Long
Private Declare Function GetActiveWindow Lib "user32" () As Long
Private Declare Function GetSystemDirectoryA Lib "kernel32" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Private Declare Function LoadCursorA Lib "user32" (ByVal hInstance As Long, ByVal lpCursorName As Long) As Long
Private Declare Function SetCursor Lib "user32" (ByVal hCursor As Long) As Long
Private Declare Function SystemTimeToFileTime Lib "kernel32" (lpSystemTime As SYSTEMTIME, lpFileTime As FILETIME) As Long
Private Declare Function GetTimeZoneInformation Lib "kernel32" (tzs As TIME_ZONE_INFORMATION) As Long
Private Declare Function GetWindowLongA Lib "user32" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Private Declare Function SetWindowLongA Lib "user32" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function GetScrollInfo Lib "user32.dll" (ByVal hwnd As Long, ByVal n As Long, ByRef lpScrollInfo As SCROLLINFO) As Long
Private Declare Function GetWindow Lib "user32" (ByVal hwnd As Long, ByVal wCmd As Long) As Long
Private Declare Function GetClassName Lib "user32" Alias "GetClassNameA" (ByVal hwnd As Long, ByVal lpClassName As String, ByVal nMaxCount As Long) As Long
Private Declare Function QueryPerformanceCounter Lib "kernel32" (lpPerformanceCount As Currency) As Long
Private Declare Function QueryPerformanceFrequency Lib "kernel32" (lpFrequency As Currency) As Long
Private Declare Function PlaySoundA Lib "winmm.dll" (ByVal lpszName As Long, ByVal hModule As Long, ByVal dwFlags As Long) As Long
Public Declare Sub RtlMoveMemory Lib "kernel32" (lpvDest As Any, lpvSource As Any, ByVal cbCopy As Long)
Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)
Public Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Public Declare Function CreateFileA Lib "kernel32" (ByVal lpFileName As String, ByVal dwDesiredAccess As Long, ByVal dwShareMode As Long, ByVal NoSecurity As Long, ByVal dwCreationDisposition As Long, ByVal dwFlagsAndAttributes As Long, ByVal hTemplateFile As Long) As Long
Public Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
Public Declare Function FileTimeToSystemTime Lib "kernel32" (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME) As Long
Public Declare Function GetTickCount Lib "kernel32" () As Long
Public Declare Function GetObjectA Lib "gdi32" (ByVal hObject As Long, ByVal nCount As Long, lpObject As Any) As Long
Public Declare Function FindWindowExA Lib "user32" (ByVal hWnd1 As Long, ByVal hWnd2 As Long, ByVal lpsz1 As String, ByVal lpsz2 As String) As Long
Public Declare Function PostMessageA Lib "user32" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Public Declare Function SendMessageA Lib "user32" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Public Declare Function FindWindowA Lib "user32" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long
Public Declare Function FlashWindow Lib "user32" (ByVal hwnd As Long, ByVal bInvert As Long) As Long
Public Declare Function GetTempPathA Lib "kernel32" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Public Sub AddUPnP(ByVal Port As Long, Optional ByVal Silent As Boolean = False)
Dim NAT As Object
Dim pMap As Object
  On Error GoTo Erred
  Set NAT = CreateObject("HNetCfg.NATUPnP")
  Set pMap = NAT.StaticPortMappingCollection
  If ObjPtr(pMap) Then
    pMap.Add Port, "TCP", Port, frmMain.wsPing.LocalIP, True, "RCB/" & frmMain.wsPing.LocalIP
    If Not Silent Then frmMain.ChatAdd Chr$(8) & "tAdded UPnP for port " & Port & "."
  Else
    If Not Silent Then frmMain.ChatAdd Chr$(8) & "eCould not detect UPnP device."
  End If
Exit Sub
Erred:
  If Not Silent Then frmMain.ChatAdd Chr$(8) & "eUPnP failed."
  Err.Clear
End Sub
Public Function BigMod(ByVal dblNumber As Double, ByVal Modulator As Double) As Double
  On Error GoTo Erred
  BigMod = dblNumber - (Modulator * Fix(dblNumber / Modulator))
Exit Function
Erred:
  ErrorHandler "Functions", "BigMod " & dblNumber & " mod " & Modulator
  Resume Next
End Function
Public Function BigDiv(ByVal dblNumber As Double, ByVal Divisor As Double) As Double
  On Error GoTo Erred
  BigDiv = Fix(dblNumber / Divisor)
Exit Function
Erred:
  ErrorHandler "Functions", "BigDiv " & dblNumber & " div " & Divisor
  Resume Next
End Function
Public Function ByteCompare(ByRef Array1() As Byte, ByRef Array2() As Byte) As Boolean
Dim I As Long
  On Error GoTo Erred
  ByteCompare = True
  If UBound(Array1) <> UBound(Array2) Then
    ByteCompare = False
  Else
    For I = 0 To UBound(Array1)
      If Array1(I) <> Array2(I) Then
        ByteCompare = False
        Exit For
      End If
    Next I
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "ByteCompare"
  Resume Next
End Function
Public Function ByteSize(ByVal InBytes As Variant) As String
  On Error GoTo Erred
  If InBytes > 1024 Then
    If InBytes / 1024 > 1024 Then
      If InBytes / 1024 / 1024 > 1024 Then
        If InBytes / 1024 / 1024 / 1024 > 1024 Then
          ByteSize = Format$((InBytes) / 1024 / 1024 / 1024 / 1024, "0.0#") & " TB"
        Else
          ByteSize = Format$((InBytes) / 1024 / 1024 / 1024, "0.0#") & " GB"
        End If
      Else
        ByteSize = Format$((InBytes) / 1024 / 1024, "0.0#") & " MB"
      End If
    Else
        ByteSize = Format$((InBytes) / 1024, "0.0#") & " KB"
    End If
  Else
    ByteSize = (InBytes) & " B"
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "ByteSize " & InBytes
  Resume Next
End Function
Public Sub Canadize(ByRef strMessage As String)
  On Error GoTo Erred
  If Right$(strMessage, 1) = "." Or Right$(strMessage, 1) = "?" Or Right$(strMessage, 1) = "!" Then strMessage = Left$(strMessage, Len(strMessage) - 1)
  strMessage = strMessage & ", eh?"
  strMessage = Replace$(strMessage, "house", "igloo", , , vbTextCompare)
  strMessage = Replace$(strMessage, "ou", "oo", , , vbTextCompare)
Exit Sub
Erred:
  ErrorHandler "Functions", "Canadize " & strMessage
  Resume Next
End Sub
Public Function CDKeys(ByVal Client As GameType, Optional ByVal CDKey As String) As String
Dim DialogBox As New frmCDKeys
Dim Key       As String
  On Error GoTo Erred
  If LenB(CDKey) > 0 Then Key = CDLegal(CDKey)
  If Client = STAR Then
    DialogBox.pctSTAR.Visible = True
    If LenB(Key) > 0 Then
      DialogBox.Caption = "Edit STAR CD Key"
      DialogBox.lblTitle.Caption = "Edit CDKey for StarCraft:"
      DialogBox.txtSTAR1 = Left$(Key, 4)
      DialogBox.txtSTAR2 = Mid$(Key, 5, 5)
      DialogBox.txtSTAR3 = Right$(Key, 4)
    Else
      DialogBox.Caption = "New STAR CD Key"
      DialogBox.lblTitle.Caption = "Enter new CDKey for StarCraft:"
    End If
  ElseIf Client = SEXP Then
    DialogBox.pctSTAR.Visible = True
    If LenB(Key) > 0 Then
      DialogBox.Caption = "Edit SEXP CD Key"
      DialogBox.lblTitle.Caption = "Edit CDKey for Brood War:"
      DialogBox.txtSTAR1 = Left$(Key, 4)
      DialogBox.txtSTAR2 = Mid$(Key, 5, 5)
      DialogBox.txtSTAR3 = Right$(Key, 4)
    Else
      DialogBox.Caption = "New SEXP CD Key"
      DialogBox.lblTitle.Caption = "Enter new CDKey for Brood War:"
    End If
  ElseIf Client = JSTR Then
    DialogBox.pctSTAR.Visible = True
    If LenB(Key) > 0 Then
      DialogBox.Caption = "Edit JSTR CD Key"
      DialogBox.lblTitle.Caption = "Edit CDKey for Japanese StarCraft:"
      DialogBox.txtSTAR1 = Left$(Key, 4)
      DialogBox.txtSTAR2 = Mid$(Key, 5, 5)
      DialogBox.txtSTAR3 = Right$(Key, 4)
    Else
      DialogBox.Caption = "New JSTR CD Key"
      DialogBox.lblTitle.Caption = "Enter new CDKey for Japanese StarCraft:"
    End If
  ElseIf Client = D2DV Then
    DialogBox.pctD2DV.Visible = True
    If LenB(Key) > 0 Then
      DialogBox.Caption = "Edit D2DV CD Key"
      DialogBox.lblTitle.Caption = "Edit CDKey for Diablo II:"
      DialogBox.txtD2DV1 = Left$(Key, 4)
      DialogBox.txtD2DV2 = Mid$(Key, 5, 4)
      DialogBox.txtD2DV3 = Mid$(Key, 9, 4)
      DialogBox.txtD2DV4 = Right$(Key, 4)
    Else
      DialogBox.Caption = "New D2DV CD Key"
      DialogBox.lblTitle.Caption = "Enter new CDKey for Diablo II:"
    End If
  ElseIf Client = D2XP Then
    DialogBox.pctD2DV.Visible = True
    If LenB(Key) > 0 Then
      DialogBox.Caption = "Edit D2XP EXP Key"
      DialogBox.lblTitle.Caption = "Edit EXPKey for Diablo II:"
      DialogBox.txtD2DV1 = Left$(Key, 4)
      DialogBox.txtD2DV2 = Mid$(Key, 5, 4)
      DialogBox.txtD2DV3 = Mid$(Key, 9, 4)
      DialogBox.txtD2DV4 = Right$(Key, 4)
    Else
      DialogBox.Caption = "New D2XP EXP Key"
      DialogBox.lblTitle.Caption = "Enter new EXPKey for Diablo II:"
    End If
  ElseIf Client = W2BN Then
    DialogBox.Caption = "New W2BN CD Key"
    DialogBox.lblTitle.Caption = "Enter new CDKey for WarCraft II:"
    DialogBox.pctW2BN.Visible = True
    If LenB(Key) > 0 Then
      DialogBox.txtW2BN1 = Left$(Key, 4)
      DialogBox.txtW2BN2 = Mid$(Key, 5, 4)
      DialogBox.txtW2BN3 = Mid$(Key, 9, 4)
      DialogBox.txtW2BN4 = Right$(Key, 4)
    End If
  ElseIf Client = WAR3 Then
    DialogBox.pctWAR3.Visible = True
    If LenB(Key) > 0 Then
      DialogBox.Caption = "Edit WAR3 CD Key"
      DialogBox.lblTitle.Caption = "Edit CDKey for WarCraft III:"
      DialogBox.txtWAR31 = Left$(Key, 6)
      DialogBox.txtWAR32 = Mid$(Key, 7, 4)
      DialogBox.txtWAR33 = Mid$(Key, 11, 6)
      DialogBox.txtWAR34 = Mid$(Key, 17, 4)
      DialogBox.txtWAR35 = Right$(Key, 6)
    Else
      DialogBox.Caption = "New WAR3 CD Key"
      DialogBox.lblTitle.Caption = "Enter new CDKey for WarCraft III:"
    End If
  ElseIf Client = W3XP Then
    DialogBox.pctWAR3.Visible = True
    If LenB(Key) > 0 Then
      DialogBox.Caption = "Edit W3XP EXP Key"
      DialogBox.lblTitle.Caption = "Edit EXPKey for WarCraft III:"
      DialogBox.txtWAR31 = Left$(Key, 6)
      DialogBox.txtWAR32 = Mid$(Key, 7, 4)
      DialogBox.txtWAR33 = Mid$(Key, 11, 6)
      DialogBox.txtWAR34 = Mid$(Key, 17, 4)
      DialogBox.txtWAR35 = Right$(Key, 6)
    Else
      DialogBox.Caption = "New W3XP EXP Key"
      DialogBox.lblTitle.Caption = "Enter new EXPKey for WarCraft III:"
    End If
  End If
  DialogBox.Show vbModal, frmMain
  Do Until DialogBox.CDKey <> vbNullString
    DoEvents
  Loop
  If DialogBox.CDKey = "Cancel" Then
    CDKeys = vbNullString
  Else
    CDKeys = DialogBox.CDKey
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "CDKeys"
  Resume Next
End Function
Public Function CDLegal(ByVal CDKey As String) As String
Dim Key       As String
Dim I         As Integer
  On Error GoTo Erred
  Key = Trim$(UCase$(CDKey))
  For I = 1 To 255
    If Not ((I >= vbKey0 And I <= vbKey9) Or (I >= vbKeyA And I <= vbKeyZ)) Then
      Key = Replace$(Key, Chr$(I), "")
    End If
  Next I
  CDLegal = Key
Exit Function
Erred:
  ErrorHandler "Functions", "CDLegal"
  Resume Next
End Function
Public Sub ChangeOBJColor(ByRef obj As Long, ByVal BGColor As Long, ByVal FGColor As Long)
  On Error GoTo Erred
  SendMessageA obj, &H2000 + 1, 0, ByVal BGColor
  SendMessageA obj, &H400 + 9, 0, ByVal FGColor
Exit Sub
Erred:
  ErrorHandler "Functions", "ChangeOBJColor"
  Resume Next
End Sub
Public Function ClanRanking(ByVal Rank As Byte) As String
  On Error GoTo Erred
  Select Case Rank
    Case 0
      ClanRanking = "New Peon"
    Case 1
      ClanRanking = "Peon"
    Case 2
      ClanRanking = "Grunt"
    Case 3
      ClanRanking = "Shaman"
    Case 4
      ClanRanking = "Chieftain"
    Case Else
      ClanRanking = "Unknown [" & Rank & "]"
  End Select
Exit Function
Erred:
  ErrorHandler "Functions", "ClanRanking " & Rank
  Resume Next
End Function
Private Function CLargeInt(ByVal Lo As Long, ByVal Hi As Long) As Double
Dim dblLo As Double
Dim dblHi As Double
  On Error GoTo Erred
  If Lo < 0 Then
    dblLo = 2 ^ 32 + Lo
  Else
    dblLo = Lo
  End If
  If Hi < 0 Then
    dblHi = 2 ^ 32 + Hi
  Else
    dblHi = Hi
  End If
  CLargeInt = dblLo + dblHi * 2 ^ 32
Exit Function
Erred:
  ErrorHandler "Functions", "CLargeInt"
  Resume Next
End Function
Private Function ClassName(ByVal hwnd As Long) As String
Dim buf As String
Dim buflen As Long
  On Error GoTo Erred
  buflen = 256
  buf = Space$(buflen - 1)
  buflen = GetClassName(hwnd, buf, buflen)
  ClassName = Left$(buf, buflen)
Exit Function
Erred:
  ErrorHandler "Functions", "ClassName"
  Resume Next
End Function
Public Function ConvertPort(ByVal Port As String) As String
  On Error GoTo Erred
  ConvertPort = (Asc(Mid$(Port, 1, 1)) * (2 ^ 8)) + Asc(Mid$(Port, 2, 1))
Exit Function
Erred:
  ErrorHandler "Functions", "ConvertPort " & Port
  Resume Next
End Function
Public Function ConvertTime(ByVal lngMS As Double, Optional ByVal Abbreviated As Boolean = False) As String
Dim lngSeconds As Double
Dim lngDays    As Double
Dim lngHours   As Double
Dim lngMins    As Double
Dim strSeconds As String
Dim strDays    As String
Dim strHours   As String
Dim strMins    As String
  On Error GoTo Erred
  lngSeconds = BigDiv(lngMS, 1000)
  lngDays = BigDiv(lngSeconds, 86400)
  lngSeconds = BigMod(lngSeconds, 86400)
  lngHours = BigDiv(lngSeconds, 3600)
  lngSeconds = BigMod(lngSeconds, 3600)
  lngMins = BigDiv(lngSeconds, 60)
  lngSeconds = BigMod(lngSeconds, 60)
  If lngSeconds <> 1 Then strSeconds = "s"
  If lngDays <> 1 Then strDays = "s"
  If lngHours <> 1 Then strHours = "s"
  If lngMins <> 1 Then strMins = "s"
  If Abbreviated Then
    If lngDays > 0 Then
      ConvertTime = lngDays & " day" & strDays & ", " & lngHours & " hr" & strHours & ", " & lngMins & " min" & strMins & ", and " & lngSeconds & " sec" & strSeconds
    ElseIf lngHours > 0 Then
      ConvertTime = lngHours & " hr" & strHours & ", " & lngMins & " min" & strMins & ", and " & lngSeconds & " sec" & strSeconds
    ElseIf lngMins > 0 Then
      ConvertTime = lngMins & " min" & strMins & " and " & lngSeconds & " sec" & strSeconds
    Else
      ConvertTime = lngSeconds & " sec" & strSeconds
    End If
  Else
    If lngDays > 0 Then
      ConvertTime = lngDays & " day" & strDays & ", " & lngHours & " hour" & strHours & ", " & lngMins & " minute" & strMins & ", and " & lngSeconds & " second" & strSeconds
    ElseIf lngHours > 0 Then
      ConvertTime = lngHours & " hour" & strHours & ", " & lngMins & " minute" & strMins & ", and " & lngSeconds & " second" & strSeconds
    ElseIf lngMins > 0 Then
      ConvertTime = lngMins & " minute" & strMins & " and " & lngSeconds & " second" & strSeconds
    Else
      ConvertTime = lngSeconds & " second" & strSeconds
    End If
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "ConvertTime " & lngMS
  Resume Next
End Function
Public Sub CreateServerList()
Dim nFile As Integer
  On Error GoTo Erred
  nFile = FreeFile
  Open SettingsFolder & "\servers.ini" For Output As nFile
  Print #nFile, ";You may add or edit any of these connections."
  Print #nFile, ";The connection name is listed in brackets,"
  Print #nFile, ";and all data below is used as the connection IP."
  Print #nFile, "[US West]"
  Print #nFile, "63.241.83.9"
  Print #nFile, "63.241.83.12"
  Print #nFile, "63.241.83.13"
  Print #nFile, "63.241.83.107"
  Print #nFile, "63.241.83.108"
  Print #nFile, "63.241.83.109"
  Print #nFile, "63.241.83.110"
  Print #nFile, "63.241.83.111"
  Print #nFile, "63.241.83.112"
  Print #nFile, ""
  Print #nFile, "[US East]"
  Print #nFile, "63.240.202.120"
  Print #nFile, "63.240.202.121"
  Print #nFile, "63.240.202.122"
  Print #nFile, "63.240.202.126"
  Print #nFile, "63.240.202.127"
  Print #nFile, "63.240.202.128"
  Print #nFile, "63.240.202.129"
  Print #nFile, "63.240.202.130"
  Print #nFile, "63.240.202.131"
  Print #nFile, "63.240.202.134"
  Print #nFile, "63.240.202.138"
  Print #nFile, "63.240.202.139"
  Print #nFile, ""
  Print #nFile, "[Europe]"
  Print #nFile, "213.248.106.200"
  Print #nFile, "213.248.106.201"
  Print #nFile, "213.248.106.202"
  Print #nFile, "213.248.106.204"
  Print #nFile, ""
  Print #nFile, "[Asia]"
  Print #nFile, "211.233.0.49"
  Print #nFile, "211.233.0.50"
  Print #nFile, "211.233.0.51"
  Print #nFile, "211.233.0.52"
  Print #nFile, "211.233.0.53"
  Print #nFile, "211.233.0.72"
  Print #nFile, "211.233.0.73"
  Print #nFile, "211.233.0.74"
  Print #nFile, "211.233.0.75"
  Print #nFile, "211.233.0.76"
  Print #nFile, "211.233.0.78"
  Print #nFile, "211.233.0.79"
  Print #nFile, "211.233.0.80"
  Close #nFile
Exit Sub
Erred:
  ErrorHandler "Functions", "CreateServerList"
  Resume Next
End Sub
Public Sub CreateBNLSList()
Dim nFile As Integer
  On Error GoTo Erred
  nFile = FreeFile
  Open SettingsFolder & "\BNLS.ini" For Output As nFile
  Print #nFile, ";You may add or edit any of these connections."
  Print #nFile, ";The connection can be an IP or host name,"
  Print #nFile, ";and will be displayed as typed in the Options window."
  Print #nFile, "bnls.valhallalegends.com"
  Print #nFile, "jbls.org"
  Print #nFile, "hdx.jbls.org"
  Close #nFile
Exit Sub
Erred:
  ErrorHandler "Functions", "CreateBNLSList"
  Resume Next
End Sub
Public Function DeCensor(ByVal strMessage As String) As String
Dim Caps As Boolean
  On Error GoTo Erred
  If strMessage = UCase$(strMessage) Then Caps = True
  If strMessage = LCase$(strMessage) Then Caps = False
  strMessage = Replace$(strMessage, "!&$%@", "pussy")
  strMessage = Replace$(strMessage, "!&$%", "fuck")
  strMessage = Replace$(strMessage, "$!@%", "shit")
  strMessage = Replace$(strMessage, "@$%!@%&", "asshole")
  strMessage = Replace$(strMessage, "@$%!@!&", "asswipe")
  strMessage = Replace$(strMessage, "$%$", "kkk")
  strMessage = Replace$(strMessage, "#@%$!", "bitch")
  strMessage = Replace$(strMessage, "!@!#&", "whore")
  strMessage = Replace$(strMessage, "!@!@%&", "nipple")
  strMessage = Replace$(strMessage, "!&!@$", "penis")
  strMessage = Replace$(strMessage, "$!$%", "cock")
  strMessage = Replace$(strMessage, "!@!@&#", "nigger")
  strMessage = Replace$(strMessage, "!@!@#", "nigga")
  strMessage = Replace$(strMessage, "$%&%", "slut")
  strMessage = Replace$(strMessage, "!@!@!@", "vagina")
  strMessage = Replace$(strMessage, "$&!%", "cunt")
  strMessage = Replace$(strMessage, "$%@%", "clit")
  strMessage = Replace$(strMessage, "&#&$%", "erect")
  strMessage = Replace$(strMessage, "%@$%", "dick")
  strMessage = Replace$(strMessage, "!#!@$&", "orgasm")
  strMessage = Replace$(strMessage, "$!@!$", "chink")
  strMessage = Replace$(strMessage, "!@!$", "gook")
  strMessage = Replace$(strMessage, "&@$%&#$@%", "masturbat")
  strMessage = Replace$(strMessage, "!@!@!%", "faggot")
  strMessage = Replace$(strMessage, "$%&!", "klux")
  strMessage = Replace$(strMessage, "$@$&", "kyke")
  strMessage = Replace$(strMessage, "%&$#@#!", "lesbian")
  strMessage = Replace$(strMessage, "%@%&!", "dildo")
  If Caps Then
    DeCensor = UCase$(strMessage)
  Else
    DeCensor = strMessage
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "Decensor " & strMessage
  Resume Next
End Function
Public Sub DeleteFolder(ByVal sPath As String)
Dim sFile As String
Dim sDir  As String
  On Error GoTo Erred
  sFile = Dir$(sPath & "*.*", vbHidden Or vbReadOnly Or vbSystem)
  Do While Len(sFile)
    On Error Resume Next
    Kill sPath & sFile
    On Error GoTo Erred
    sFile = Dir$
  Loop
  sDir = Dir$(sPath, vbDirectory)
  Do While Len(sDir)
    If (GetAttr(sPath & sDir) And vbDirectory) = vbDirectory Then
      If Left$(sDir, 1) <> "." Then
        DeleteFolder sPath & sDir & "\"
        sDir = Dir$(sPath, vbDirectory)
      End If
    End If
    sDir = Dir$
  Loop
  On Error Resume Next
  RmDir sPath
  On Error GoTo Erred
  sPath = sPath & ".."
Exit Sub
Erred:
  ErrorHandler "Functions", "DeleteFolder " & sPath
  Resume Next
End Sub
Public Function DetectScrollLoc(ByVal rtb As Long) As Boolean
Dim sInfo As SCROLLINFO
  sInfo.cbSize = Len(sInfo)
  sInfo.fMask = &H1 Or &H2 Or &H4
  GetScrollInfo rtb, 1, sInfo
  DetectScrollLoc = sInfo.nPos >= sInfo.nMax - sInfo.nPage
End Function
Public Function DisplayFileVerInfo(ByVal Filename As String) As String
Dim sBuffer()    As Byte
Dim lBufferLen   As Long
Dim lVerPointer  As Long
Dim udtVerBuffer As VS_FIXEDFILEINFO
  On Error GoTo Erred
  lBufferLen = GetFileVersionInfoSizeA(Filename, 0&)
  If lBufferLen < 1 Then
    DisplayFileVerInfo = "0"
    Exit Function
  End If
  ReDim sBuffer(lBufferLen)
  GetFileVersionInfoA Filename, 0&, lBufferLen, sBuffer(0)
  VerQueryValueA sBuffer(0), "\", lVerPointer, 0&
  RtlMoveMemory udtVerBuffer, ByVal lVerPointer, Len(udtVerBuffer)
  DisplayFileVerInfo = Format$(udtVerBuffer.dwFileVersionMSh) & "." & Format$(udtVerBuffer.dwFileVersionMSl) & "." & Format$(udtVerBuffer.dwFileVersionLSl)
Exit Function
Erred:
  ErrorHandler "Functions", "DisplayFileVerInfo " & Filename
  Resume Next
End Function
Public Function DisplayProdVerInfo(ByVal Filename As String) As String
Dim sBuffer()    As Byte
Dim lBufferLen   As Long
Dim lVerPointer  As Long
Dim udtVerBuffer As VS_FIXEDFILEINFO
  On Error GoTo Erred
  lBufferLen = GetFileVersionInfoSizeA(Filename, 0&)
  If lBufferLen < 1 Then
    DisplayProdVerInfo = 0
    Exit Function
  End If
  ReDim sBuffer(lBufferLen)
  GetFileVersionInfoA Filename, 0&, lBufferLen, sBuffer(0)
  VerQueryValueA sBuffer(0), "\", lVerPointer, 0&
  RtlMoveMemory udtVerBuffer, ByVal lVerPointer, Len(udtVerBuffer)
  DisplayProdVerInfo = Format$(udtVerBuffer.dwProductVersionMSh) & "." & Format$(udtVerBuffer.dwProductVersionMSl) & "." & Format$(udtVerBuffer.dwProductVersionLSh) & "." & Format$(udtVerBuffer.dwProductVersionLSl)
Exit Function
Erred:
  ErrorHandler "Functions", "DisplayProdVerInfo " & Filename
  Resume Next
End Function
Public Sub ErrorHandler(ByVal Window As String, ByVal Subroutine As String)
Dim ErrorBox As New frmError
Dim ErrDescr As String
Dim ErrNum   As String
Dim ErrSrc   As String
Dim ErrLine  As String
  If Err.Number = 339 Then
    MsgBox Err.Number & ": " & Err.Description, vbCritical, "Error!"
    End
  End If
  ErrDescr = Err.Description
  ErrNum = Err.Number
  ErrSrc = Err.Source
  ErrLine = Erl
  LogError ErrNum, ErrDescr, ErrSrc, ErrLine, Window, Subroutine
  If DisableErrors Then Exit Sub
  On Error Resume Next
  Reset
  ErrorBox.GetError ErrNum, ErrDescr, ErrSrc, Subroutine, Window, ErrLine
  If frmMain.tmrUpdate.Enabled And Not frmMain.Visible Then
    App.TaskVisible = True
    If frmMain.Maxed Then
      frmMain.WindowState = 2
    Else
      frmMain.WindowState = 0
    End If
    frmMain.Show
    frmMain.TrayIcon.HideIcon
  End If
  ErrorBox.Show vbModal, frmMain
End Sub
Public Function FindEditChild(ByVal hwnd As Long) As Long
Dim child_hwnd As Long
  On Error GoTo Erred
  child_hwnd = GetWindow(hwnd, 5)
  Do While child_hwnd <> 0
    If ClassName(child_hwnd) = "Edit" Then
      FindEditChild = child_hwnd
      Exit Function
    End If
    child_hwnd = GetWindow(child_hwnd, 2)
  Loop
  FindEditChild = 0
Exit Function
Erred:
  ErrorHandler "Functions", "FindEditChild"
  Resume Next
End Function
Private Function FindIllegal(ByVal From As String) As String
Dim I      As Integer
Dim strTmp As String
  On Error GoTo Erred
  For I = 1 To Len(From)
    If Asc(Mid$(From, I, 1)) >= &H20 Then
      strTmp = strTmp & Mid$(From, I, 1)
    Else
      Exit For
    End If
  Next I
  FindIllegal = Trim$(strTmp)
Exit Function
Erred:
  ErrorHandler "Functions", "FindIllegal " & From
  Resume Next
End Function
Public Function FormatTime(ByVal strTime As Date, ByVal strFormat As String) As String
Dim TimeStr As String
  On Error GoTo Erred
  TimeStr = strFormat
  TimeStr = Replace$(TimeStr, "HH", Format$(Hour(strTime), "00"))
  TimeStr = Replace$(TimeStr, "H", Hour(strTime))
  TimeStr = Replace$(TimeStr, "MM", Format$(Minute(strTime), "00"))
  TimeStr = Replace$(TimeStr, "M", Minute(strTime))
  TimeStr = Replace$(TimeStr, "SS", Format$(Second(strTime), "00"))
  TimeStr = Replace$(TimeStr, "S", Second(strTime))
  If Hour(strTime) > 12 Then
    TimeStr = Replace$(TimeStr, "hh", Format$(Hour(strTime) - 12, "00"))
    TimeStr = Replace$(TimeStr, "h", Hour(strTime) - 12)
    TimeStr = Replace$(TimeStr, "tt", "pm")
    TimeStr = Replace$(TimeStr, "TT", "PM")
  ElseIf Hour(strTime) = 12 Then
    TimeStr = Replace$(TimeStr, "hh", "12")
    TimeStr = Replace$(TimeStr, "h", "12")
    TimeStr = Replace$(TimeStr, "tt", "pm")
    TimeStr = Replace$(TimeStr, "TT", "PM")
  ElseIf Hour(strTime) = 0 Then
    TimeStr = Replace$(TimeStr, "hh", "12")
    TimeStr = Replace$(TimeStr, "h", "12")
    TimeStr = Replace$(TimeStr, "tt", "am")
    TimeStr = Replace$(TimeStr, "TT", "AM")
  Else
    TimeStr = Replace$(TimeStr, "hh", Format$(Hour(strTime), "00"))
    TimeStr = Replace$(TimeStr, "h", Hour(strTime))
    TimeStr = Replace$(TimeStr, "tt", "am")
    TimeStr = Replace$(TimeStr, "TT", "AM")
  End If
  FormatTime = TimeStr
Exit Function
Erred:
  ErrorHandler "Functions", "FormatTime " & strTime & " | " & strFormat
  Resume Next
End Function
Public Sub Fudd(ByRef strMessage As String)
  On Error GoTo Erred
  strMessage = Replace$(strMessage, "er", "aw", , , vbTextCompare)
  strMessage = Replace$(strMessage, "r", "w", , , vbTextCompare)
  strMessage = Replace$(strMessage, "l", "w", , , vbTextCompare)
Exit Sub
Erred:
  ErrorHandler "Functions", "Fudd " & strMessage
  Resume Next
End Sub
Public Function GameStringToName(ByVal fromGame As String) As String
  On Error GoTo Erred
  If fromGame = "LTRD" Then
    GameStringToName = "Diablo"
  ElseIf fromGame = "RHSD" Then
    GameStringToName = "Diablo Shareware"
  ElseIf fromGame = "VD2D" Then
    GameStringToName = "Diablo II"
  ElseIf fromGame = "PX2D" Then
    GameStringToName = "Diablo II: Lord of Destruction"
  ElseIf fromGame = "RATS" Then
    GameStringToName = "StarCraft"
  ElseIf fromGame = "RHSS" Then
    GameStringToName = "StarCraft Shareware"
  ElseIf fromGame = "RTSJ" Then
    GameStringToName = "Japanese StarCraft"
  ElseIf fromGame = "PXES" Then
    GameStringToName = "Brood War"
  ElseIf fromGame = "NB2W" Then
    GameStringToName = "WarCraft II"
  ElseIf fromGame = "3RAW" Then
    GameStringToName = "WarCraft III"
  ElseIf fromGame = "PX3W" Then
    GameStringToName = "WarCraft III: The Frozen Throne"
  ElseIf fromGame = "TAHC" Then
    GameStringToName = "Chat"
  Else
    GameStringToName = StrReverse(fromGame)
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "GameStringToName " & fromGame
  Resume Next
End Function
Public Function GameToDWORD(ByVal fromGame As GameType) As Long
  On Error GoTo Erred
  If fromGame = DRTL Then
    GameToDWORD = CLIENT_DRTL
  ElseIf fromGame = DSHR Then
    GameToDWORD = CLIENT_DSHR
  ElseIf fromGame = D2DV Then
    GameToDWORD = CLIENT_D2DV
  ElseIf fromGame = D2XP Then
    GameToDWORD = CLIENT_D2XP
  ElseIf fromGame = STAR Then
    GameToDWORD = CLIENT_STAR
  ElseIf fromGame = SSHR Then
    GameToDWORD = CLIENT_SSHR
  ElseIf fromGame = JSTR Then
    GameToDWORD = CLIENT_JSTR
  ElseIf fromGame = SEXP Then
    GameToDWORD = CLIENT_SEXP
  ElseIf fromGame = W2BN Then
    GameToDWORD = CLIENT_W2BN
  ElseIf fromGame = WAR3 Then
    GameToDWORD = CLIENT_WAR3
  ElseIf fromGame = W3XP Then
    GameToDWORD = CLIENT_W3XP
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "GameToDWord"
  Resume Next
End Function
Public Function GameToName(ByVal fromGame As GameType) As String
  On Error GoTo Erred
  GameToName = GameStringToName(StrReverse(GameToString(fromGame)))
Exit Function
Erred:
  ErrorHandler "Functions", "GameToName"
End Function
Public Function GameToString(ByVal fromGame As GameType) As String
  On Error GoTo Erred
  If fromGame = DRTL Then
    GameToString = "DRTL"
  ElseIf fromGame = DSHR Then
    GameToString = "DSHR"
  ElseIf fromGame = D2DV Then
    GameToString = "D2DV"
  ElseIf fromGame = D2XP Then
    GameToString = "D2XP"
  ElseIf fromGame = STAR Then
    GameToString = "STAR"
  ElseIf fromGame = SSHR Then
    GameToString = "SSHR"
  ElseIf fromGame = JSTR Then
    GameToString = "JSTR"
  ElseIf fromGame = SEXP Then
    GameToString = "SEXP"
  ElseIf fromGame = W2BN Then
    GameToString = "W2BN"
  ElseIf fromGame = WAR3 Then
    GameToString = "WAR3"
  ElseIf fromGame = W3XP Then
    GameToString = "W3XP"
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "GameToString"
  Resume Next
End Function
Public Function Get_LCID(ByVal ID As Long) As String
  On Error GoTo Erred
  Select Case ID
    Case &H436
      Get_LCID = "Afrikaans"
    Case &H41C
      Get_LCID = "Albanian"
    Case &H401
      Get_LCID = "Arabic"
    Case &H1401
      Get_LCID = "Arabic Algeria"
    Case &H3C01
      Get_LCID = "Arabic Bahrain"
    Case &HC01
      Get_LCID = "Arabic Egypt"
    Case &H801
      Get_LCID = "Arabic Iraq"
    Case &H2C01
      Get_LCID = "Arabic Jordan"
    Case &H3401
      Get_LCID = "Arabic Kuwait"
    Case &H3001
      Get_LCID = "Arabic Lebanon"
    Case &H1001
      Get_LCID = "Arabic Libya"
    Case &H1801
      Get_LCID = "Arabic Morocco"
    Case &H2001
      Get_LCID = "Arabic Oman"
    Case &H4001
      Get_LCID = "Arabic Qatar"
    Case &H401
      Get_LCID = "Arabic Saudi Arabia"
    Case &H2801
      Get_LCID = "Arabic Syria"
    Case &H1C01
      Get_LCID = "Arabic Tunisia"
    Case &H3801
      Get_LCID = "Arabic U.A.E."
    Case &H2401
      Get_LCID = "Arabic Yemen"
    Case &H42B
      Get_LCID = "Armenian"
    Case &H44D
      Get_LCID = "Assamese"
    Case &H82C
      Get_LCID = "Azeri Cyrillic"
    Case &H42C
      Get_LCID = "Azeri Latin"
    Case &H42D
      Get_LCID = "Basque"
    Case &H813
      Get_LCID = "Belgian Dutch"
    Case &H80C
      Get_LCID = "Belgian French"
    Case &H445
      Get_LCID = "Bengali"
    Case &H416
      Get_LCID = "Portuguese (Brazil)"
    Case &H402
      Get_LCID = "Bulgarian"
    Case &H455
      Get_LCID = "Burmese"
    Case &H423
      Get_LCID = "Byelorussian (Belarusian)"
    Case &H403
      Get_LCID = "Catalan"
    Case &HC04
      Get_LCID = "Chinese Hong Kong SAR"
    Case &H1404
      Get_LCID = "Chinese Macau SAR"
    Case &H804
      Get_LCID = "Chinese Simplified"
    Case &H1004
      Get_LCID = "Chinese Singapore"
    Case &H404
      Get_LCID = "Chinese Traditional"
    Case &H41A
      Get_LCID = "Croatian"
    Case &H405
      Get_LCID = "Czech"
    Case &H406
      Get_LCID = "Danish"
    Case &H413
      Get_LCID = "Dutch"
    Case &HC09
      Get_LCID = "English Australia"
    Case &H2809
      Get_LCID = "English Belize"
    Case &H1009
      Get_LCID = "English Canadian"
    Case &H2409
      Get_LCID = "English Caribbean"
    Case &H1809
      Get_LCID = "English Ireland"
    Case &H2009
      Get_LCID = "English Jamaica"
    Case &H1409
      Get_LCID = "English New Zealand"
    Case &H3409
      Get_LCID = "English Philippines"
    Case &H1C09
      Get_LCID = "English South Africa"
    Case &H2C09
      Get_LCID = "English Trinidad"
    Case &H809
      Get_LCID = "English U.K."
    Case &H409
      Get_LCID = "English U.S."
    Case &H3009
      Get_LCID = "English Zimbabwe"
    Case &H425
      Get_LCID = "Estonian"
    Case &H438
      Get_LCID = "Faeroese"
    Case &H429
      Get_LCID = "Farsi"
    Case &H40B
      Get_LCID = "Finnish"
    Case &H40C
      Get_LCID = "French"
    Case &H2C0C
      Get_LCID = "French Cameroon"
    Case &HC0C
      Get_LCID = "French Canadian"
    Case &H300C
      Get_LCID = "French Cote d'Ivoire"
    Case &H140C
      Get_LCID = "French Luxembourg"
    Case &H340C
      Get_LCID = "French Mali"
    Case &H180C
      Get_LCID = "French Monaco"
    Case &H200C
      Get_LCID = "French Reunion"
    Case &H280C
      Get_LCID = "French Senegal"
    Case &H1C0C
      Get_LCID = "French West Indies"
    Case &H240C
      Get_LCID = "French Congo (DRC)"
    Case &H462
      Get_LCID = "Frisian Netherlands"
    Case &H83C
      Get_LCID = "Gaelic Ireland"
    Case &H43C
      Get_LCID = "Gaelic Scotland"
    Case &H456
      Get_LCID = "Galician"
    Case &H437
      Get_LCID = "Georgian"
    Case &H407
      Get_LCID = "German"
    Case &HC07
      Get_LCID = "German Austria"
    Case &H1407
      Get_LCID = "German Liechtenstein"
    Case &H1007
      Get_LCID = "German Luxembourg"
    Case &H408
      Get_LCID = "Greek"
    Case &H447
      Get_LCID = "Gujarati"
    Case &H40D
      Get_LCID = "Hebrew"
    Case &H439
      Get_LCID = "Hindi"
    Case &H40E
      Get_LCID = "Hungarian"
    Case &H40F
      Get_LCID = "Icelandic"
    Case &H421
      Get_LCID = "Indonesian"
    Case &H410
      Get_LCID = "Italian"
    Case &H411
      Get_LCID = "Japanese"
    Case &H44B
      Get_LCID = "Kannada"
    Case &H460
      Get_LCID = "Kashmiri"
    Case &H43F
      Get_LCID = "Kazakh"
    Case &H453
      Get_LCID = "Khmer"
    Case &H440
      Get_LCID = "Kirghiz"
    Case &H457
      Get_LCID = "Konkani"
    Case &H412
      Get_LCID = "Korean"
    Case &H454
      Get_LCID = "Lao"
    Case &H426
      Get_LCID = "Latvian"
    Case &H427
      Get_LCID = "Lithuanian"
    Case &H42F
      Get_LCID = "FYRO Macedonian"
    Case &H44C
      Get_LCID = "Malayalam"
    Case &H83E
      Get_LCID = "Malay Brunei Darussalam"
    Case &H43E
      Get_LCID = "Malaysian"
    Case &H43A
      Get_LCID = "Maltese"
    Case &H458
      Get_LCID = "Manipuri"
    Case &H44E
      Get_LCID = "Marathi"
    Case &H450
      Get_LCID = "Mongolian"
    Case &H461
      Get_LCID = "Nepali"
    Case &H414
      Get_LCID = "Norwegian Bokmol"
    Case &H814
      Get_LCID = "Norwegian Nynorsk"
    Case &H448
      Get_LCID = "Oriya"
    Case &H415
      Get_LCID = "Polish"
    Case &H816
      Get_LCID = "Portuguese"
    Case &H446
      Get_LCID = "Punjabi"
    Case &H417
      Get_LCID = "Rhaeto-Romanic"
    Case &H418
      Get_LCID = "Romanian"
    Case &H818
      Get_LCID = "Romanian Moldova"
    Case &H419
      Get_LCID = "Russian"
    Case &H819
      Get_LCID = "Russian Moldova"
    Case &H43B
      Get_LCID = "Sami Lappish"
    Case &H44F
      Get_LCID = "Sanskrit"
    Case &HC1A
      Get_LCID = "Serbian Cyrillic"
    Case &H81A
      Get_LCID = "Serbian Latin"
    Case &H430
      Get_LCID = "Sesotho"
    Case &H459
      Get_LCID = "Sindhi"
    Case &H41B
      Get_LCID = "Slovak"
    Case &H424
      Get_LCID = "Slovenian"
    Case &H42E
      Get_LCID = "Sorbian"
    Case &H40A
      Get_LCID = "Spanish (Traditional)"
    Case &H2C0A
      Get_LCID = "Spanish Argentina"
    Case &H400A
      Get_LCID = "Spanish Bolivia"
    Case &H340A
      Get_LCID = "Spanish Chile"
    Case &H240A
      Get_LCID = "Spanish Colombia"
    Case &H140A
      Get_LCID = "Spanish Costa Rica"
    Case &H1C0A
      Get_LCID = "Spanish Dominican Republic"
    Case &H300A
      Get_LCID = "Spanish Ecuador"
    Case &H440A
      Get_LCID = "Spanish El Salvador"
    Case &H100A
      Get_LCID = "Spanish Guatemala"
    Case &H480A
      Get_LCID = "Spanish Honduras"
    Case &H4C0A
      Get_LCID = "Spanish Nicaragua"
    Case &H180A
      Get_LCID = "Spanish Panama"
    Case &H3C0A
      Get_LCID = "Spanish Paraguay"
    Case &H280A
      Get_LCID = "Spanish Peru"
    Case &H500A
      Get_LCID = "Spanish Puerto Rico"
    Case &HC0A
      Get_LCID = "Spanish Spain (Modern Sort)"
    Case &H380A
      Get_LCID = "Spanish Uruguay"
    Case &H200A
      Get_LCID = "Spanish Venezuela"
    Case &H430
      Get_LCID = "Sutu"
    Case &H441
      Get_LCID = "Swahili"
    Case &H41D
      Get_LCID = "Swedish"
    Case &H81D
      Get_LCID = "Swedish Finland"
    Case &H100C
      Get_LCID = "Swiss French"
    Case &H807
      Get_LCID = "Swiss German"
    Case &H810
      Get_LCID = "Swiss Italian"
    Case &H428
      Get_LCID = "Tajik"
    Case &H449
      Get_LCID = "Tamil"
    Case &H444
      Get_LCID = "Tatar"
    Case &H44A
      Get_LCID = "Telugu"
    Case &H41E
      Get_LCID = "Thai"
    Case &H451
      Get_LCID = "Tibetan"
    Case &H431
      Get_LCID = "Tsonga"
    Case &H432
      Get_LCID = "Tswana"
    Case &H41F
      Get_LCID = "Turkish"
    Case &H442
      Get_LCID = "Ukrainian"
    Case &H420
      Get_LCID = "Urdu"
    Case &H843
      Get_LCID = "Uzbek Cyrillic"
    Case &H443
      Get_LCID = "Uzbek Latin"
    Case &H433
      Get_LCID = "Venda"
    Case &H42A
      Get_LCID = "Vietnamese"
    Case &H452
      Get_LCID = "Welsh"
    Case &H434
      Get_LCID = "Xhosa"
    Case &H435
      Get_LCID = "Zulu"
    Case Else
      Get_LCID = "Unknown [" & Hex$(ID) & "]"
  End Select
Exit Function
Erred:
  ErrorHandler "Functions", "GetLCID"
  Resume Next
End Function
Public Function GetCompUserName(Optional ByVal User As Boolean = False) As String
Dim strBuff As String
Dim Rut     As Long
  On Error GoTo Erred
  strBuff = String$(255, vbNullChar)
  If User Then
    Rut = GetUserNameA(strBuff, Len(strBuff))
  Else
    Rut = GetComputerNameA(strBuff, Len(strBuff))
  End If
  If Rut = 0 Then
    strBuff = vbNullString
  Else
    strBuff = KillNull(strBuff)
  End If
  GetCompUserName = strBuff
Exit Function
Erred:
  ErrorHandler "Functions", "GetCompUserName"
  Resume Next
End Function
Public Sub GetDriveSpecs(strDrive As String, ByRef DriveName As String, ByRef DriveSerial As Long, ByRef DriveFormat As String)
Dim Res   As Long
Dim CMP   As Long
Dim Flags As Long
  On Error GoTo Erred
  DriveName = String$(255, vbNullChar)
  DriveFormat = String$(255, vbNullChar)
  Res = GetVolumeInformationA(strDrive, DriveName, Len(DriveName), DriveSerial, 0, 0, DriveFormat, Len(DriveFormat))
  DriveName = TrimNull(DriveName)
  DriveFormat = TrimNull(DriveFormat)
Exit Sub
Erred:
  ErrorHandler "Functions", "GetDriveSpecs (" & strDrive & ")"
  Resume Next
End Sub
Public Function GetFileTimeInfo(Filename As String) As FILETIME
Dim file_handle As Long
Dim create_time As FILETIME
Dim access_time As FILETIME
Dim write_time  As FILETIME
  On Error GoTo Erred
  If LenB(Dir$(Filename)) > 0 Then
    file_handle = CreateFileA(Filename, &H80000000, &H1 Or &H2, 0&, &H3, 0&, 0&)
    GetFileTime file_handle, create_time, access_time, write_time
    GetFileTimeInfo = write_time
    CloseHandle (file_handle)
  Else
    GetFileTimeInfo.dwHighDateTime = 0
    GetFileTimeInfo.dwLowDateTime = 0
  End If
  Exit Function
Erred:
  ErrorHandler "Functions", "GetFileTimeInfo " & Filename
  Resume Next
End Function
Public Function GetFTLocal() As FILETIME
Dim STime As SYSTEMTIME
Dim FTime  As FILETIME
  On Error GoTo Erred
  GetLocalTime STime
  SystemTimeToFileTime STime, FTime
  GetFTLocal = FTime
Exit Function
Erred:
  ErrorHandler "Functions", "GetFTLocal"
  Resume Next
End Function
Public Function GetFTSystem() As FILETIME
Dim STime As SYSTEMTIME
Dim FTime  As FILETIME
  On Error GoTo Erred
  GetSystemTime STime
  SystemTimeToFileTime STime, FTime
  GetFTSystem = FTime
Exit Function
Erred:
  ErrorHandler "Functions", "GetFTSystem"
  Resume Next
End Function
Public Function GetFTTime(FT As FILETIME, Optional Shorten As Boolean = False, Optional LocalTime As Boolean = True) As String
Dim LocalFT As FILETIME
Dim SysTime As SYSTEMTIME
Dim SetHour As String
Dim AP      As String
  On Error GoTo Erred
  If LocalTime Then
    FileTimeToLocalFileTime FT, LocalFT
    FileTimeToSystemTime LocalFT, SysTime
  Else
    FileTimeToSystemTime FT, SysTime
  End If
  If SysTime.wHour = 0 Then
    AP = "AM"
    SetHour = "12"
  ElseIf SysTime.wHour < 12 Then
    AP = "AM"
    SetHour = Trim$(Str$(SysTime.wHour))
  ElseIf SysTime.wHour = 12 Then
    AP = "PM"
    SetHour = "12"
  Else
    AP = "PM"
    SetHour = Trim$(Str$(SysTime.wHour))
  End If
  SysTime.wDayOfWeek = SysTime.wDayOfWeek + 1
  If Shorten Then
    GetFTTime = Format$(SysTime.wMonth, "00") & "/" & Format$(SysTime.wDay, "00") & "/" & Right$(SysTime.wYear, 2) & " " & SetHour & ":" & Format$(SysTime.wMinute, "00") & ":" & Format$(SysTime.wSecond, "00") & " " & AP
  Else
    GetFTTime = WeekdayName(SysTime.wDayOfWeek, True) & ", " & MonthName(SysTime.wMonth, True) & " " & SysTime.wDay & ", " & SysTime.wYear & " at " & SetHour & ":" & Format$(SysTime.wMinute, "00") & ":" & Format$(SysTime.wSecond, "00") & " " & AP
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "GetFTTime"
  Resume Next
End Function
Public Function GetInfo(ByVal lInfo As Long) As String
Dim Buffer As String
Dim Ret    As String
  On Error GoTo Erred
  Buffer = String$(256, 0)
  Ret = GetLocaleInfoA(LOCALE_USER_DEFAULT, lInfo, Buffer, Len(Buffer))
  If Ret > 0 Then
    GetInfo = Left$(Buffer, Ret - 1)
  Else
    GetInfo = vbNullString
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "GetInfo"
  Resume Next
End Function
Public Function GetLSClient(ByVal Client As GameType, ByVal Host As String) As Long
Dim JBLS As Boolean
  On Error GoTo Erred
  JBLS = InStr(LCase$(Host), "bnls") = 0
  Select Case Client
    Case STAR
      GetLSClient = &H1
    Case SEXP
      GetLSClient = &H2
    Case W2BN
      GetLSClient = &H3
    Case D2DV
      GetLSClient = &H4
    Case D2XP
      GetLSClient = &H5
    Case JSTR
      GetLSClient = &H6
    Case WAR3
      GetLSClient = &H7
    Case W3XP
      GetLSClient = &H8
    Case DRTL
      If JBLS Then
        GetLSClient = &H9
      Else
        GetLSClient = &H0
      End If
    Case DSHR
      If JBLS Then
        GetLSClient = &HA
      Else
        GetLSClient = &H0
      End If
    Case SSHR
      If JBLS Then
        GetLSClient = &HB
      Else
        GetLSClient = &H0
      End If
  End Select
Exit Function
Erred:
  ErrorHandler "Functions", "GetLSClient"
  Resume Next
End Function
Public Function GetQuote(ByVal Query As String) As String
Dim nFile    As Integer
Dim QuoteTmp As String
Dim FoundQ   As Boolean
  If LenB(Dir$(SettingsFolder & "\Profiles\" & Profile & "\quotes.rcb")) > 0 Then
    nFile = FreeFile
    Open SettingsFolder & "\Profiles\" & Profile & "\quotes.rcb" For Input As #nFile
    Do Until EOF(nFile)
      Line Input #nFile, QuoteTmp
      If InStr(1, QuoteTmp, Query) > 0 Then
        GetQuote = QuoteTmp
        FoundQ = True
        Exit Do
      End If
    Loop
    Close #nFile
    If Not FoundQ Then
      nFile = FreeFile
      Open SettingsFolder & "\Profiles\" & Profile & "\quotes.rcb" For Input As #nFile
      Do Until EOF(nFile)
        Line Input #nFile, QuoteTmp
        If InStr(1, QuoteTmp, Query, vbTextCompare) > 0 Then
          GetQuote = QuoteTmp
          FoundQ = True
          Exit Do
        End If
      Loop
      Close #nFile
      If Not FoundQ Then GetQuote = "Could not find a quote with the term """ & Query & """ in it."
    End If
  Else
    GetQuote = "No quotes exist."
  End If
  Exit Function
Erred:
  GetQuote = "Error in GetQuote: " & Err.Description
End Function
Public Function GetRegionDWord() As Long
Dim RegionString As String
  On Error GoTo Erred
  RegionString = GetInfo(LOCALE_SISO639LANGNAME) & GetInfo(LOCALE_SISO3166CTRYNAME)
  GetRegionDWord = lngDWORD(RegionString)
Exit Function
Erred:
  ErrorHandler "Functions", "GetRegionDWord"
  Resume Next
End Function
Public Function GetSerialNumber(strDrive As String) As Long
Dim SerialNum As Long
Dim Res       As Long
Dim Temp1     As String
Dim Temp2     As String
  On Error GoTo Erred
  Temp1 = String$(255, vbNullChar)
  Temp2 = String$(255, vbNullChar)
  Res = GetVolumeInformationA(strDrive, Temp1, Len(Temp1), SerialNum, 0, 0, Temp2, Len(Temp2))
  GetSerialNumber = SerialNum
Exit Function
Erred:
  ErrorHandler "Functions", "GetSerialNumber (" & strDrive & ")"
  Resume Next
End Function
Public Function GetSpeed(ByVal CurrentSize As Long, ByVal StartTime As Long) As String
Dim TimeSoFar As Double
  On Error GoTo Erred
  TimeSoFar = (GetTickDouble - StartTime) / 1000
  If TimeSoFar < 1 Then TimeSoFar = 1
  GetSpeed = ByteSize(Int(CurrentSize / TimeSoFar)) & "/S"
Exit Function
Erred:
  ErrorHandler "Functions", "GetSpeed " & CurrentSize & " | " & StartTime
  Resume Next
End Function
Public Sub GetSysInfo(ByRef ProcCount As Long, ByRef ProcArch As Long, ByRef ProcLev As Long, ByRef ProcTime As Long, ByRef TotalMem As Long, ByRef PageFile As Long, ByRef DiskSpace As Long)
Dim Mem            As MEMORYSTATUS
Dim sys            As SYSTEM_INFO
Dim DrSize         As Double
Dim SperC          As Long
Dim BperS          As Long
Dim Free           As Long
Dim Total          As Long
Dim FirstTick      As Long
Dim CurrentTick    As Double
Dim ProcessorSpeed As Double
Dim Counter        As Long
Dim I              As Integer
  On Error GoTo Erred
  FirstTick = GetTickDouble
  Do
    CurrentTick = GetTickDouble
  Loop While CurrentTick = FirstTick
  ProcessorSpeed = GetTickDouble - CurrentTick
  Do
    For I = 10000 To 0 Step -1
      ProcessorSpeed = ProcessorSpeed + Counter + Counter + Counter + Counter + Counter + Counter + Counter + Counter
      Counter = Counter + 1
    Next I
    ProcessorSpeed = GetTickDouble - CurrentTick
  Loop While ProcessorSpeed < &H32
  GetSystemInfo sys
  GlobalMemoryStatus Mem
  GetDiskFreeSpaceA Left$(SettingsFolder, 3), SperC, BperS, Free, Total
  DrSize = CDbl(Total) * SperC * BperS
  ProcCount = sys.dwNumberOfProcessors
  ProcArch = sys.wProcessorArchitecture
  ProcLev = sys.wProcessorLevel
  ProcTime = ProcessorSpeed
  PageFile = RShift(CDbl(Mem.dwTotalPageFile), &H14)
  TotalMem = RShift(CDbl(Mem.dwTotalPhys), &H16)
  DiskSpace = CDbl("&H" & Right$(Hex$(RShift(DrSize, &H14)), 3))
Exit Sub
Erred:
  ErrorHandler "Functions", "GetSysInfo"
  Resume Next
End Sub
Public Function GetTempDir() As String
Dim nSize As Long
Dim tmp As String
  On Error GoTo Erred
  tmp = Space$(255)
  nSize = Len(tmp)
  GetTempPathA nSize, tmp
  GetTempDir = TrimNull(tmp)
Exit Function
Erred:
  ErrorHandler "Functions", "GetTempDir"
  Resume Next
End Function
Public Function GetTempName(Optional anExt As String = "tmp") As String
Dim Filename     As String
Dim I            As Long
Const validChars As String = "123567890qwertyuiopasdfghjklzxcvbnm"
  On Error GoTo Erred
  Filename = Space$(12)
  Mid$(Filename, 1, 1) = "T"
  Mid$(Filename, Len(Filename) - Len(anExt), 1) = "."
  Mid$(Filename, Len(Filename) - Len(anExt) + 1, Len(anExt)) = anExt
  For I = 2 To Len(Filename) - (Len(anExt) + 1)
    Mid$(Filename, I, 1) = Mid$(validChars, CLng(Rnd() * (Len(validChars)) + 1), 1)
  Next I
  If LenB(Dir$(GetTempDir & "RCB", vbDirectory)) = 0 Then MkDir GetTempDir & "RCB"
  GetTempName = GetTempDir & "RCB\" & Filename
Exit Function
Erred:
  ErrorHandler "Functions", "GetTempName"
  Resume Next
End Function
Public Function GetTime(ByVal TotalSize As Long, ByVal CurrentSize As Long, ByVal StartTime As Long) As String
Dim TimeSoFar As Double
  On Error GoTo Erred
  TimeSoFar = (GetTickDouble - StartTime) / 1000
  If TimeSoFar < 1 Then TimeSoFar = 1
  GetTime = ConvertTime(Int((TotalSize - CurrentSize) / (CurrentSize \ TimeSoFar)) * 1000, True)
Exit Function
Erred:
  ErrorHandler "Functions", "GetTime " & TotalSize & "/" & CurrentSize & " | " & StartTime
  Resume Next
End Function
Public Function HasFocus(ByRef Frm As Form) As Boolean
  On Error GoTo Erred
  If GetActiveWindow = Frm.hwnd And Frm.Visible Then HasFocus = True
Exit Function
Erred:
  ErrorHandler "Functions", "HasFocus " & Frm.Name
  Resume Next
End Function
Public Function HtS(ByVal HexToStr As String) As String
Dim strTemp   As String
Dim strReturn As String
Dim I         As Long
  On Error GoTo Erred
  For I = 1 To Len(HexToStr) Step 2
    strTemp = Chr$(Val("&H" & Mid$(HexToStr, I, 2)))
    strReturn = strReturn & strTemp
  Next I
  HtS = strReturn
Exit Function
Erred:
  ErrorHandler "Functions", "HtS"
  Resume Next
End Function
Public Sub IconMenu()
  On Error GoTo Erred
  MenuIcon 0, frmMain.imlMenu.ListImages(4).Picture
  If frmMain.mnuConnect.Caption = "Co&nnect" Then
    MenuIcon 2, frmMain.imlMenu.ListImages(1).Picture
  Else
    MenuIcon 2, frmMain.imlMenu.ListImages(3).Picture
  End If
  MenuIcon 3, frmMain.imlMenu.ListImages(2).Picture
  MenuIcon 5, frmMain.imlMenu.ListImages(5).Picture
Exit Sub
Erred:
  ErrorHandler "Functions", "IconMenu"
  Resume Next
End Sub
Public Function IDBNLS(ByVal PacketID As Byte) As String
  On Error GoTo Erred
  Select Case PacketID
    Case &H0
      IDBNLS = "BNLS_NULL"
    Case &H1
      IDBNLS = "BNLS_CDKEY"
    Case &H2
      IDBNLS = "BNLS_LOGONCHALLENGE"
    Case &H3
      IDBNLS = "BNLS_LOGONPROOF"
    Case &H4
      IDBNLS = "BNLS_CREATEACCOUNT"
    Case &H5
      IDBNLS = "BNLS_CHANGECHALLENGE"
    Case &H6
      IDBNLS = "BNLS_CHANGEPROOF"
    Case &H7
      IDBNLS = "BNLS_UPGRADECHALLENGE"
    Case &H8
      IDBNLS = "BNLS_UPGRADEPROOF"
    Case &H9
      IDBNLS = "BNLS_VERSIONCHECK"
    Case &HA
      IDBNLS = "BNLS_CONFIRMLOGON"
    Case &HB
      IDBNLS = "BNLS_HASHDATA"
    Case &HC
      IDBNLS = "BNLS_CDKEY_EX"
    Case &HD
      IDBNLS = "BNLS_CHOOSENLSREVISION"
    Case &HE
      IDBNLS = "BNLS_AUTHORIZE"
    Case &HF
      IDBNLS = "BNLS_AUTHORIZEPROOF"
    Case &H10
      IDBNLS = "BNLS_REQUESTVERSIONBYTE"
    Case &H11
      IDBNLS = "BNLS_VERIFYSERVER"
    Case &H12
      IDBNLS = "BNLS_RESERVESERVERSLOTS"
    Case &H13
      IDBNLS = "BNLS_SERVERLOGONCHALLENGE"
    Case &H14
      IDBNLS = "BNLS_SERVERLOGONPROOF"
    Case &H15
      IDBNLS = "BNLS_RESERVED0"
    Case &H16
      IDBNLS = "BNLS_RESERVED1"
    Case &H17
      IDBNLS = "BNLS_RESERVED2"
    Case &H18
      IDBNLS = "BNLS_VERSIONCHECKEX"
    Case &H19
      IDBNLS = "BNLS_RESERVED3"
    Case &H1A
      IDBNLS = "BNLS_VERSIONCHECKEX2"
    Case Else
      IDBNLS = "BNLS (" & PacketID & ")"
  End Select
Exit Function
Erred:
  ErrorHandler "Functions", "IDBNLS " & PacketID
  Resume Next
End Function
Public Function IDMCP(ByVal PacketID As Byte) As String
  On Error GoTo Erred
  Select Case PacketID
    Case &H1
      IDMCP = "MCP_STARTUP"
    Case &H2
      IDMCP = "MCP_CHARCREATE"
    Case &H3
      IDMCP = "MCP_CREATEGAME"
    Case &H4
      IDMCP = "MCP_JOINGAME"
    Case &H5
      IDMCP = "MCP_GAMELIST"
    Case &H6
      IDMCP = "MCP_GAMEINFO"
    Case &H7
      IDMCP = "MCP_CHARLOGON"
    Case &HA
      IDMCP = "MCP_CHARDELETE"
    Case &H11
      IDMCP = "MCP_REQUESTLADDERDATA"
    Case &H12
      IDMCP = "MCP_MOTD"
    Case &H13
      IDMCP = "MCP_CANCELGAMECREATE"
    Case &H14
      IDMCP = "MCP_CREATEQUEUE"
    Case &H17
      IDMCP = "MCP_CHARLIST"
    Case &H18
      IDMCP = "MCP_CHARUPGRADE"
    Case &H19
      IDMCP = "MCP_CHARLIST2"
    Case Else
      IDMCP = "MCP (" & PacketID & ")"
  End Select
Exit Function
Erred:
  ErrorHandler "Functions", "IDMCP " & PacketID
  Resume Next
End Function
Public Function IDSID(ByVal PacketID As Byte) As String
  On Error GoTo Erred
  Select Case PacketID
    Case &H0
      IDSID = "SID_NULL"
    Case &H2
      IDSID = "SID_STOPADV"
    Case &H4
      IDSID = "SID_SERVERLIST"
    Case &H5
      IDSID = "SID_CLIENTID"
    Case &H6
      IDSID = "SID_STARTVERSIONING"
    Case &H7
      IDSID = "SID_REPORTVERSION"
    Case &H8
      IDSID = "SID_STARTADVEX"
    Case &H9
      IDSID = "SID_GETADVLISTEX"
    Case &HA
      IDSID = "SID_ENTERCHAT"
    Case &HB
      IDSID = "SID_GETCHANNELLIST"
    Case &HC
      IDSID = "SID_JOINCHANNEL"
    Case &HE
      IDSID = "SID_CHATCOMMAND"
    Case &HF
      IDSID = "SID_CHATEVENT"
    Case &H10
      IDSID = "SID_LEAVECHAT"
    Case &H12
      IDSID = "SID_LOCALEINFO"
    Case &H13
      IDSID = "SID_FLOODDETECTED"
    Case &H14
      IDSID = "SID_UDPPINGRESPONSE"
    Case &H15
      IDSID = "SID_CHECKAD"
    Case &H16
      IDSID = "SID_CLICKAD"
    Case &H18
      IDSID = "SID_REGISTRY"
    Case &H19
      IDSID = "SID_MESSAGEBOX"
    Case &H1C
      IDSID = "SID_STARTADVEX3"
    Case &H1D
      IDSID = "SID_LOGONCHALLENGEEX"
    Case &H1E
      IDSID = "SID_CLIENTID2"
    Case &H1F
      IDSID = "SID_LEAVEGAME"
    Case &H21
      IDSID = "SID_DISPLAYAD"
    Case &H22
      IDSID = "SID_NOTIFYJOIN"
    Case &H25
      IDSID = "SID_PING"
    Case &H26
      IDSID = "SID_READUSERDATA"
    Case &H27
      IDSID = "SID_WRITEUSERDATA"
    Case &H28
      IDSID = "SID_LOGONCHALLENGE"
    Case &H29
      IDSID = "SID_LOGONRESPONSE"
    Case &H2A
      IDSID = "SID_CREATEACCOUNT"
    Case &H2B
      IDSID = "SID_SYSTEMINFO"
    Case &H2C
      IDSID = "SID_GAMERESULT"
    Case &H2D
      IDSID = "SID_GETICONDATA"
    Case &H2E
      IDSID = "SID_GETLADDERDATA"
    Case &H2F
      IDSID = "SID_FINDLADDERUSER"
    Case &H30
      IDSID = "SID_CDKEY"
    Case &H31
      IDSID = "SID_CHANGEPASSWORD"
    Case &H32
      IDSID = "SID_CHECKDATAFILE"
    Case &H33
      IDSID = "SID_GETFILETIME"
    Case &H34
      IDSID = "SID_QUERYREALMS"
    Case &H35
      IDSID = "SID_PROFILE"
    Case &H36
      IDSID = "SID_CDKEY2"
    Case &H3A
      IDSID = "SID_LOGONRESPONSE2"
    Case &H3C
      IDSID = "SID_CHECKDATAFILE2"
    Case &H3D
      IDSID = "SID_CREATEACCOUNT2"
    Case &H3E
      IDSID = "SID_LOGONREALMEX"
    Case &H3F
      IDSID = "SID_STARTVERSIONING2"
    Case &H40
      IDSID = "SID_QUERYREALMS2"
    Case &H41
      IDSID = "SID_QUERYADURL"
    Case &H44
      IDSID = "SID_WARCRAFTGENERAL"
    Case &H45
      IDSID = "SID_NETGAMEPORT"
    Case &H46
      IDSID = "SID_NEWS_INFO"
    Case &H4A
      IDSID = "SID_OPTIONALWORK"
    Case &H4A
      IDSID = "SID_EXTRAWORK"
    Case &H4C
      IDSID = "SID_REQUIREDWORK"
    Case &H50
      IDSID = "SID_AUTH_INFO"
    Case &H51
      IDSID = "SID_AUTH_CHECK"
    Case &H52
      IDSID = "SID_AUTH_ACCOUNTCREATE"
    Case &H53
      IDSID = "SID_AUTH_ACCOUNTLOGON"
    Case &H54
      IDSID = "SID_AUTH_ACCOUNTLOGONPROOF"
    Case &H55
      IDSID = "SID_AUTH_ACCOUNTCHANGE"
    Case &H56
      IDSID = "SID_AUTH_ACCOUNTCHANGEPROOF"
    Case &H59
      IDSID = "SID_SETEMAIL"
    Case &H5A
      IDSID = "SID_RESETPASSWORD"
    Case &H5B
      IDSID = "SID_CHANGEEMAIL"
    Case &H5C
      IDSID = "SID_SWITCHPRODUCT"
    Case &H5E
      IDSID = "SID_WARDEN"
    Case &H60
      IDSID = "SID_GAMEPLAYERSEARCH"
    Case &H65
      IDSID = "SID_FRIENDSLIST"
    Case &H66
      IDSID = "SID_FRIENDSUPDATE"
    Case &H67
      IDSID = "SID_FRIENDSADD"
    Case &H68
      IDSID = "SID_FRIENDSREMOVE"
    Case &H69
      IDSID = "SID_FRIENDSPOSITION"
    Case &H70
      IDSID = "SID_CLANFINDCANDIDATES"
    Case &H71
      IDSID = "SID_CLANINVITEMULTIPLE"
    Case &H72
      IDSID = "SID_CLANCREATIONINVITATION"
    Case &H73
      IDSID = "SID_CLANDISBAND"
    Case &H74
      IDSID = "SID_CLANMAKECHIEFTAIN"
    Case &H75
      IDSID = "SID_CLANINFO"
    Case &H76
      IDSID = "SID_CLANQUITNOTIFY"
    Case &H77
      IDSID = "SID_CLANINVITATION"
    Case &H78
      IDSID = "SID_CLANREMOVEMEMBER"
    Case &H79
      IDSID = "SID_CLANINVITATIONRESPONSE"
    Case &H7A
      IDSID = "SID_CLANRANKCHANGE"
    Case &H7B
      IDSID = "SID_CLANSETMOTD"
    Case &H7C
      IDSID = "SID_CLANMOTD"
    Case &H7D
      IDSID = "SID_CLANMEMBERLIST"
    Case &H7E
      IDSID = "SID_CLANMEMBERREMOVED"
    Case &H7F
      IDSID = "SID_CLANMEMBERSTATUSCHANGE"
    Case &H81
      IDSID = "SID_CLANMEMBERRANKCHANGE"
    Case &H82
      IDSID = "SID_CLANMEMBERINFORMATION"
    Case Else
      IDSID = "SID (0x" & Format$(Hex$(PacketID), "00") & ")"
  End Select
Exit Function
Erred:
  ErrorHandler "Functions", "IDSID " & PacketID
  Resume Next
End Function
Public Function KillNull(ByVal Text As String) As String
  On Error GoTo Erred
  If InStr(Text, vbNullChar) > 0 Then
    KillNull = Split(Text, vbNullChar)(0)
  Else
    KillNull = Text
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "KillNull " & Text
  Resume Next
End Function
Public Function LegalURL(ByVal URL As String) As Boolean
  On Error GoTo Erred
  URL = LCase$(URL)
If Left$(URL, 4) = "www." Then
    Select Case LCase$(Mid$(URL, 5, 1))
      Case "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"
        LegalURL = True
      Case Else
        LegalURL = False
    End Select
  ElseIf Left$(URL, 7) = "http://" Then
    If Mid$(URL, 8, 4) = "www." Then
      Select Case LCase$(Mid$(URL, 12, 1))
        Case "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"
          LegalURL = True
        Case Else
          LegalURL = False
      End Select
    Else
      Select Case LCase$(Mid$(URL, 8, 1))
        Case "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"
          LegalURL = True
        Case Else
          LegalURL = False
      End Select
    End If
  ElseIf Left$(URL, 8) = "https://" Then
    If Mid$(URL, 9, 4) = "www." Then
      Select Case LCase$(Mid$(URL, 13, 1))
        Case "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"
          LegalURL = True
        Case Else
          LegalURL = False
      End Select
    Else
      Select Case LCase$(Mid$(URL, 9, 1))
        Case "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"
          LegalURL = True
        Case Else
          LegalURL = False
      End Select
    End If
  ElseIf Left$(URL, 6) = "ftp://" Then
    If Mid$(URL, 7, 4) = "www." Then
      Select Case LCase$(Mid$(URL, 11, 1))
        Case "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"
          LegalURL = True
        Case Else
          LegalURL = False
      End Select
    Else
      Select Case LCase$(Mid$(URL, 7, 1))
        Case "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"
          LegalURL = True
        Case Else
          LegalURL = False
      End Select
    End If
  ElseIf Left$(URL, 7) = "mailto:" Then
    If Mid$(URL, 8) Like "*@*.*" Then
      Select Case LCase$(Mid$(URL, 8, 1))
        Case "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"
          LegalURL = True
        Case Else
          LegalURL = False
      End Select
    Else
      LegalURL = False
    End If
  Else
    LegalURL = False
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "LegalURL " & URL
  Resume Next
End Function
Public Function lngDWORD(ByVal sValue As String) As Long
Dim Result As Long
  On Error GoTo Erred
  sValue = sValue & String$(4 - Len(sValue), vbNullChar)
  sValue = StrReverse(sValue)
  RtlMoveMemory Result, ByVal sValue, 4
  lngDWORD = Result
Exit Function
Erred:
  ErrorHandler "Functions", "lngDWORD " & sValue
  Resume Next
End Function
Public Sub LogEvent(ByVal strMessage As String)
Dim nFile As Integer
  On Error GoTo Erred
  nFile = FreeFile
  If LenB(Dir$(SettingsFolder & "\events.log")) = 0 Then
    Open SettingsFolder & "\events.log" For Output As #nFile
  Else
    Open SettingsFolder & "\events.log" For Append As #nFile
  End If
  Print #nFile, "[" & Now & "] " & strMessage
  Close #nFile
Exit Sub
Erred:
  ErrorHandler "Functions", "Log Event (" & strMessage & ")"
  Resume Next
End Sub
Private Sub LogError(ByVal ErrNum As Long, ByVal ErrDescr As String, ByVal ErrSrc As String, ByVal ErrLine As Long, ByVal ErrWin As String, ByVal ErrSub As String)
  LogEvent "Error #" & ErrNum & ": " & ErrDescr & ". Occured on line " & ErrLine & " of " & ErrWin & "(" & ErrSub & ")."
End Sub
Public Function GetTickDouble() As Double
Dim Cou As Currency
Dim Fre As Currency
  On Error GoTo Erred
  If QueryPerformanceCounter(Cou) And QueryPerformanceFrequency(Fre) Then
    GetTickDouble = Int(Cou / Fre * 1000)
  Else
    GetTickDouble = LongToUnsigned(GetTickCount)
  End If
Exit Function
Erred:
  GetTickDouble = 0
End Function
Public Function LongToUnsigned(value As Long) As Double
  On Error GoTo Erred
  If value < 0 Then
    LongToUnsigned = value + 4294967296#
  Else
    LongToUnsigned = value
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "LongToUnsigned " & value
  Resume Next
End Function
Public Function MakeFT(ByVal FromStr As String) As FILETIME
Dim HighTime As Double
Dim LowTime As Double
  On Error GoTo Erred
    HighTime = Left$(FromStr, InStr(1, FromStr, " "))
    HighTime = MakeLongSize(HighTime)
    LowTime = Mid$(FromStr, InStr(1, FromStr, " "))
    LowTime = MakeLongSize(LowTime)
    MakeFT.dwHighDateTime = CLng(HighTime)
    MakeFT.dwLowDateTime = CLng(LowTime)
Exit Function
Erred:
  ErrorHandler "Functions", "MakeFT " & FromStr
  Resume Next
End Function
Public Function MakeLongSize(ByVal BigNumber As Double) As Long
  On Error GoTo Erred
ReCheck:
  If BigNumber > 2147483647 Then
    BigNumber = BigNumber - 2147483647
    GoTo ReCheck
  End If
  MakeLongSize = BigNumber
Exit Function
Erred:
  ErrorHandler "Functions", "MakeLongSize " & BigNumber
  Resume Next
End Function
Public Sub MaxLines(ByVal MaxCount As Long, ByRef Box As RichTextBox, ByRef linkStuff As clsHyperlink)
Dim LinesToRemove As Long
Dim chrsToStart   As Long
Dim chrsToEnd     As Long
  On Error GoTo Erred
  If SendMessageA(Box.hwnd, &HBA, 0, 0) > MaxCount Then
    LinesToRemove = MaxCount \ 10
    If LinesToRemove < 1 Then LinesToRemove = 1
    chrsToStart = SendMessageA(Box.hwnd, &HBB, 0, ByVal 0&)
    chrsToEnd = SendMessageA(Box.hwnd, &HBB, LinesToRemove, ByVal 0&)
    SendMessageA Box.hwnd, &HB1, chrsToStart, ByVal chrsToEnd
    SendMessageA Box.hwnd, &HC2, 0, 0
    Box.SelStart = Len(Box.Text)
    linkStuff.UpdateLinks chrsToEnd - chrsToStart
  End If
Exit Sub
Erred:
  ErrorHandler "Functions", "MaxLines " & MaxCount
  Resume Next
End Sub
Private Sub MenuIcon(ByVal Target As Long, ByRef ipcPicture As IPictureDisp)
Dim hMenu     As Long
Dim hSubMenu  As Long
Dim nPosition As Long
  On Error GoTo Erred
  hMenu = GetMenu(frmMain.hwnd)
  If frmMain.mnuBot.Visible Then
    hSubMenu = GetSubMenu(hMenu, 3)
  Else
    hSubMenu = GetSubMenu(hMenu, 0)
  End If
  nPosition = GetMenuItemID(hSubMenu, Target)
  SetMenuItemBitmaps hMenu, nPosition, 0, CLng(ipcPicture), CLng(ipcPicture)
Exit Sub
Erred:
  ErrorHandler "Functions", "MenuIcon"
  Resume Next
End Sub
Public Function MessageBox(ByVal strMessage As String, Optional ByVal IconStyle As style = Information, Optional ByVal ButtonStyle As Buttons = OKOnly, Optional ByVal strCaption As String = "Ripple Chat Bot", Optional ByVal Default As String) As String
Attribute MessageBox.VB_UserMemId = -552
Dim DialogBox As New frmDialog
  On Error GoTo Erred
  DialogBox.SetStyle strMessage, IconStyle, ButtonStyle, strCaption, Default
  If frmMain.WindowState = vbMinimized Or Not frmMain.Visible Then
    frmMain.Enabled = False
    DialogBox.Show
  Else
    DialogBox.Show vbModal
  End If
  Do Until DialogBox.Result <> vbNullString
    DoEvents
  Loop
  If IconStyle = InputDialog And (DialogBox.Result = "Cancel" Or DialogBox.Result = "No") Then
    MessageBox = vbNullString
  Else
    MessageBox = DialogBox.Result
  End If
  If frmMain.WindowState = vbMinimized Or Not frmMain.Visible Then frmMain.Enabled = True
Exit Function
Erred:
  ErrorHandler "Functions", "MessageBox"
  Resume Next
End Function
Public Function Morse(ByVal strMessage As String, MorseOut As Boolean) As String
Dim Ans    As String
Dim Nums() As String
Dim I      As Integer
  On Error GoTo Erred
  If MorseOut Then
    For I = 1 To Len(strMessage)
      Select Case LCase$(Mid$(strMessage, I, 1))
        Case "a"
          Ans = Ans & ".-"
        Case "b"
          Ans = Ans & "-..."
        Case "c"
          Ans = Ans & "-.-."
        Case "d"
          Ans = Ans & "-.."
        Case "e"
          Ans = Ans & "."
        Case "f"
          Ans = Ans & "..-."
        Case "g"
          Ans = Ans & "--."
        Case "h"
          Ans = Ans & "...."
        Case "i"
          Ans = Ans & ".."
        Case "j"
          Ans = Ans & ".---"
        Case "k"
          Ans = Ans & "-.-"
        Case "l"
          Ans = Ans & ".-.."
        Case "m"
          Ans = Ans & "--"
        Case "n"
          Ans = Ans & "-."
        Case "o"
          Ans = Ans & "---"
        Case "p"
          Ans = Ans & ".--."
        Case "q"
          Ans = Ans & "--.-"
        Case "r"
          Ans = Ans & ".-."
        Case "s"
          Ans = Ans & "..."
        Case "t"
          Ans = Ans & "-"
        Case "u"
          Ans = Ans & "..-"
        Case "v"
          Ans = Ans & "...-"
        Case "w"
          Ans = Ans & ".--"
        Case "x"
          Ans = Ans & "-..-"
        Case "y"
          Ans = Ans & "-.--"
        Case "z"
          Ans = Ans & "--.."
        Case "0"
          Ans = Ans & "-----"
        Case "1"
          Ans = Ans & ".----"
        Case "2"
          Ans = Ans & "..---"
        Case "3"
          Ans = Ans & "...--"
        Case "4"
          Ans = Ans & "....-"
        Case "5"
          Ans = Ans & "....."
        Case "6"
          Ans = Ans & "-...."
        Case "7"
          Ans = Ans & "--..."
        Case "8"
          Ans = Ans & "---.."
        Case "9"
          Ans = Ans & "----."
        Case "."
          Ans = Ans & ".-.-.-"
        Case ","
          Ans = Ans & "--..--"
        Case "?"
          Ans = Ans & "..--.."
        Case "'"
          Ans = Ans & ".----."
        Case "!"
          Ans = Ans & "-.-.--"
        Case "/"
          Ans = Ans & "-..-."
        Case "("
          Ans = Ans & "-.--."
        Case ")"
          Ans = Ans & "-.--.-"
        Case "&"
          Ans = Ans & ". ..."
        Case ":"
          Ans = Ans & "---..."
        Case ";"
          Ans = Ans & "-.-.-."
        Case "="
          Ans = Ans & "-...-"
        Case "\"
          Ans = Ans & "-..-."
        Case "-"
          Ans = Ans & "-....-"
        Case "_"
          Ans = Ans & "..-- .-"
        Case """"
          Ans = Ans & ".-..-."
        Case "$"
          Ans = Ans & "...-..-"
        Case "@"
          Ans = Ans & ".--.-."
        Case " "
          Ans = Ans & "/"
        Case Else
          Ans = Ans & "_"
      End Select
      Ans = Ans & "  "
    Next I
  Else
    Nums = Split(strMessage, "  ")
    For I = 0 To UBound(Nums)
      Select Case Nums(I)
        Case ".-"
          Ans = Ans & "a"
        Case "-..."
          Ans = Ans & "b"
        Case "-.-."
          Ans = Ans & "c"
        Case "-.."
          Ans = Ans & "d"
        Case "."
          Ans = Ans & "e"
        Case "..-."
          Ans = Ans & "f"
        Case "--."
          Ans = Ans & "g"
        Case "...."
          Ans = Ans & "h"
        Case ".."
          Ans = Ans & "i"
        Case ".---"
          Ans = Ans & "j"
        Case "-.-"
          Ans = Ans & "k"
        Case ".-.."
          Ans = Ans & "l"
        Case "--"
          Ans = Ans & "m"
        Case "-."
          Ans = Ans & "n"
        Case "---"
          Ans = Ans & "o"
        Case ".--."
          Ans = Ans & "p"
        Case "--.-"
          Ans = Ans & "q"
        Case ".-."
          Ans = Ans & "r"
        Case "..."
          Ans = Ans & "s"
        Case "-"
          Ans = Ans & "t"
        Case "..-"
          Ans = Ans & "u"
        Case "...-"
          Ans = Ans & "v"
        Case ".--"
          Ans = Ans & "w"
        Case "-..-"
          Ans = Ans & "x"
        Case "-.--"
          Ans = Ans & "y"
        Case "--.."
          Ans = Ans & "z"
        Case "-----"
          Ans = Ans & "0"
        Case ".----"
          Ans = Ans & "1"
        Case "..---"
          Ans = Ans & "2"
        Case "...--"
          Ans = Ans & "3"
        Case "....-"
          Ans = Ans & "4"
        Case "....."
          Ans = Ans & "5"
        Case "-...."
          Ans = Ans & "6"
        Case "--..."
          Ans = Ans & "7"
        Case "---.."
          Ans = Ans & "8"
        Case "----."
          Ans = Ans & "9"
        Case ".-.-.-"
          Ans = Ans & "."
        Case "--..--"
          Ans = Ans & ","
        Case "..--.."
          Ans = Ans & "?"
        Case ".----."
          Ans = Ans & "'"
        Case "-.-.--"
          Ans = Ans & "!"
        Case "-..-."
          Ans = Ans & "/"
        Case "-.--."
          Ans = Ans & "("
        Case "-.--.-"
          Ans = Ans & ")"
        Case ". ..."
          Ans = Ans & "&"
        Case "---..."
          Ans = Ans & ":"
        Case "-.-.-."
          Ans = Ans & ";"
        Case "-...-"
          Ans = Ans & "="
        Case "-..-."
          Ans = Ans & "\"
        Case "-....-"
          Ans = Ans & "-"
        Case "..-- .-"
          Ans = Ans & "_"
        Case ".-..-."
          Ans = Ans & """"
        Case "...-..-"
          Ans = Ans & "$"
        Case ".--.-."
          Ans = Ans & "@"
        Case "/"
          Ans = Ans & " "
        Case Else
          Ans = Ans & "_"
      End Select
    Next I
  End If
  Morse = Trim$(Ans)
Exit Function
Erred:
  ErrorHandler "Functions", "Morse " & strMessage & " | " & MorseOut
  Resume Next
End Function
Public Sub OnTop(ByRef Frm As Form, ByVal TopMost As Boolean)
  On Error GoTo Erred
  If TopMost Then
    SetWindowPos Frm.hwnd, -1, 0, 0, 0, 0, &H1 Or &H2 Or &H10
  Else
    SetWindowPos Frm.hwnd, -2, 0, 0, 0, 0, &H1 Or &H2 Or &H10
  End If
Exit Sub
Erred:
  ErrorHandler "Functions", "OnTop " & Frm.Name & " | " & TopMost
  Resume Next
End Sub
Public Sub PlaySound(ByVal ID As Long)
Dim Ret As Long
  PlaySoundA ID, App.hInstance, &H40004 Or &H1
End Sub
Public Function RaceNoToStr(ByVal RaceID As Byte) As String
  On Error GoTo Erred
  Select Case RaceID
    Case &H0
      RaceNoToStr = "Random"
    Case &H1
      RaceNoToStr = "Human"
    Case &H2
      RaceNoToStr = "Orc"
    Case &H3
      RaceNoToStr = "Undead"
    Case &H4
      RaceNoToStr = "Night Elf"
    Case &H5
      RaceNoToStr = "Tournament"
    Case Else
      RaceNoToStr = "Unknown (" & RaceID & ")"
  End Select
Exit Function
Erred:
  ErrorHandler "Functions", "RaceNoToStr"
  Resume Next
End Function
Public Function RC4(ByVal Expression As String, ByVal Password As String) As String
Dim RB(0 To 255)    As Integer
Dim X               As Long
Dim Y               As Long
Dim Z               As Long
Dim Key()           As Byte
Dim ByteArray()     As Byte
Dim temp            As Byte
Dim Encrypt         As Boolean
  On Error Resume Next
  If LenB(Password) = 0 Then Exit Function
  If LenB(Expression) = 0 Then Exit Function
  Encrypt = Not Left$(Expression, 1) = ""
  If Not Encrypt Then Expression = HtS(Mid$(Expression, 2))
  If Len(Password) > 256 Then
    Key() = strConv(Left$(Password, 256), vbFromUnicode)
  Else
    Key() = strConv(Password, vbFromUnicode)
  End If
  For X = 0 To 255
    RB(X) = X
  Next X
  X = 0
  Y = 0
  Z = 0
  For X = 0 To 255
    Y = (Y + RB(X) + Key(X Mod Len(Password))) Mod 256
    temp = RB(X)
    RB(X) = RB(Y)
    RB(Y) = temp
  Next X
  X = 0
  Y = 0
  Z = 0
  ByteArray() = strConv(Expression, vbFromUnicode)
  For X = 0 To Len(Expression)
    Y = (Y + 1) Mod 256
    Z = (Z + RB(Y)) Mod 256
    temp = RB(Y)
    RB(Y) = RB(Z)
    RB(Z) = temp
    If X <= UBound(ByteArray) Then ByteArray(X) = ByteArray(X) Xor (RB((RB(Y) + RB(Z)) Mod 256))
  Next X
  If Encrypt Then
    RC4 = "" & StH(strConv(ByteArray, vbUnicode))
  Else
    RC4 = strConv(ByteArray, vbUnicode)
  End If
End Function
Public Function ReadINI(ByVal riSection As String, ByVal riKey As String, ByVal riDefault As String, ByVal riFile As String) As String
Dim sRiBuffer As String
Dim sRiValue  As String
Dim sRiLong   As String
Dim INIFile   As String
  On Error GoTo Erred
  INIFile = SettingsFolder & "\" & riFile
  If LenB(Dir$(INIFile)) > 0 Then
    sRiBuffer = String$(255, vbNull)
    sRiLong = GetPrivateProfileStringA(riSection, riKey, ChrW$(1), sRiBuffer, 255, INIFile)
    If Left$(sRiBuffer, 1) <> ChrW$(1) Then
      sRiValue = Left$(sRiBuffer, sRiLong)
      If LenB(sRiValue) > 0 Then
        ReadINI = sRiValue
      Else
        ReadINI = riDefault
      End If
    Else
      ReadINI = riDefault
    End If
  Else
    ReadINI = riDefault
  End If
Exit Function
Erred:
  If Err.Description = "File already open" Then
    MessageBox "Could not save the config file. It is currently in use.", Critical, OKOnly
  Else
    ErrorHandler "Functions", "ReadINI " & INIFile & "::/" & riSection & "/" & riKey & "/" & riDefault
    Resume Next
  End If
End Function
Public Function RemoveNumber(ByVal Account As String) As String
  On Error GoTo Erred
  If InStr(1, Account, "#") > 0 Then
    If InStr(InStr(1, Account, "#"), Account, "@") > 0 Then
      RemoveNumber = Left$(Account, InStr(1, Account, "#") - 1) & Mid$(Account, InStr(1, Account, "@"))
    Else
      RemoveNumber = Left$(Account, InStr(1, Account, "#") - 1)
    End If
  Else
    RemoveNumber = Account
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "RemoveNumber " & Account
  Resume Next
End Function
Public Sub RemoveUPnP(ByVal Port As Long, Optional ByVal Silent As Boolean = False)
Dim NAT As Object
Dim pMap As Object
  On Error GoTo Erred
  Set NAT = CreateObject("HNetCfg.NATUPnP")
  Set pMap = NAT.StaticPortMappingCollection
  If ObjPtr(pMap) Then
    pMap.Remove Port, "TCP"
    If Not Silent Then frmMain.ChatAdd Chr$(8) & "eRemoved UPnP for port " & Port & "."
  Else
    If Not Silent Then frmMain.ChatAdd Chr$(8) & "eCould not detect UPnP device."
  End If
Exit Sub
Erred:
  If Not Silent Then frmMain.ChatAdd Chr$(8) & "eUPnP failed."
  Err.Clear
End Sub
Public Function RShift(ByVal pnValue As Double, ByVal pnShift As Long) As Long
Dim Shft As String
  On Error GoTo Erred
  Shft = Str$(pnValue / (2 ^ pnShift))
  If InStr(Shft, ".") > 0 Then
    RShift = CLng(Left$(Shft, InStr(Shft, ".") - 1))
  Else
    RShift = CLng(Shft)
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "RShift"
  Resume Next
End Function
Public Sub SendStringTo(ByVal strCaption As String, ByVal Send As String)
Dim hwnd As Long
Dim cds  As COPYDATASTRUCT
  On Error GoTo Erred
  hwnd = FindWindowA("ThunderRT6FormDC", strCaption)
  If Len(Send) = 0 Then Send = vbNullString
  cds.cbData = LenB(Send)
  cds.lpData = StrPtr(Send)
  SendMessageA hwnd, &H4A, frmMessage.hwnd, cds
Exit Sub
Erred:
  ErrorHandler "Functions", "SendStringTo"
  Resume Next
End Sub
Public Sub SendString(ByVal hwnd As Long, ByVal Send As String)
Dim cds  As COPYDATASTRUCT
  On Error GoTo Erred
  If Len(Send) = 0 Or hwnd = 0 Then Send = vbNullString
  cds.cbData = LenB(Send)
  cds.lpData = StrPtr(Send)
  SendMessageA hwnd, &H4A, frmMessage.hwnd, cds
Exit Sub
Erred:
  ErrorHandler "Functions", "SendString"
  Resume Next
End Sub
Public Function ServerIPToChar(ByVal ServerIP As String, ByRef CharString As String) As Boolean
Dim IP() As String
  On Error GoTo Erred
  IP() = Split(ServerIP, ".")
  If UBound(IP) = 3 Then
    CharString = Chr$(IP(0)) & Chr$(IP(1)) & Chr$(IP(2)) & Chr$(IP(3))
    ServerIPToChar = True
  Else
    ServerIPToChar = False
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "ServerIPToChar " & ServerIP
  Resume Next
End Function
Public Sub SetAllCaps(ByVal txt As TextBox)
Dim style As Long
  On Error GoTo Erred
  style = GetWindowLongA(txt.hwnd, -16)
  style = style Or &H8&
  SetWindowLongA txt.hwnd, -16, style
Exit Sub
Erred:
  ErrorHandler "Functions", "SetAllCaps"
  Resume Next
End Sub
Public Sub SetFileTimeInfo(Filename As String, Created As FILETIME, Accessed As FILETIME, Written As FILETIME)
Dim file_handle As Long
  On Error GoTo Erred
  If LenB(Dir$(Filename)) > 0 Then
    file_handle = CreateFileA(Filename, &H40000000, &H1 Or &H2, 0&, &H3, 0&, 0&)
    SetFileTime file_handle, Created, Accessed, Written
    CloseHandle (file_handle)
  End If
Exit Sub
Erred:
  ErrorHandler "Functions", "SetFileTimeInfo " & Filename
  Resume Next
End Sub
Public Sub SetHand()
Dim lHandle As Long
  On Error GoTo Erred
  lHandle = LoadCursorA(0, HANDCURSOR)
  If lHandle > 0 Then SetCursor lHandle
Exit Sub
Erred:
  ErrorHandler "Functions", "SetHand"
  Resume Next
End Sub
Public Function SettingsFolder() As String
Static sSettings    As String
Dim IsThere         As Boolean
Dim lngRet          As Long
Dim strLocation     As String
Dim pidl            As Long
  On Error GoTo Erred
  IsThere = True
  If LenB(sSettings) = 0 Then IsThere = False
  If IsThere Then If LenB(Dir$(sSettings)) = 0 Then IsThere = False
  If Not IsThere Then
    lngRet = SHGetSpecialFolderLocation(frmLogin.hwnd, &H1A, pidl)
    If lngRet = 0 Then
      strLocation = Space$(260)
      lngRet = SHGetPathFromIDList(ByVal pidl, strLocation)
      If lngRet = 0 Or LenB(Trim$(strLocation)) = 0 Then
        sSettings = App.Path
      Else
        sSettings = Left$(strLocation, InStr(strLocation, vbNullChar) - 1) & "\RealityRipple Software\Ripple Chat Bot"
        If LenB(Dir$(Left$(strLocation, InStr(strLocation, vbNullChar) - 1) & "\RealityRipple Software", vbDirectory)) = 0 Then MkDir Left$(strLocation, InStr(strLocation, vbNullChar) - 1) & "\RealityRipple Software"
        If LenB(Dir$(sSettings, vbDirectory)) = 0 Then MkDir sSettings
      End If
      CoTaskMemFree pidl
    End If
  End If
  SettingsFolder = sSettings
Exit Function
Erred:
  If lngRet = 0 Or LenB(Trim$(strLocation)) = 0 Then
    ErrorHandler "Functions", "SettingsFolder"
  Else
    ErrorHandler "Functions", "SettingsFolder [" & strLocation & "]"
  End If
  Resume Next
End Function
Public Sub ShellExecute(ByVal Path As String, Optional ByVal Focus As VbAppWinStyle = vbNormalFocus)
  On Error GoTo Erred
  ShellExecuteA 0, vbNullString, Path, vbNullString, vbNullString, Focus
Exit Sub
Erred:
  ErrorHandler "Functions", "OpenFile " & Path
  Resume Next
End Sub
Public Function ShortenFilename(ByVal strFile As String, ByRef Frm As Form, ByRef lbl As Label) As String
  On Error GoTo Erred
  Frm.ScaleMode = vbPixels
  PathCompactPathA Frm.hDC, strFile, lbl.Width - Frm.DrawWidth - 3
  ShortenFilename = strFile
Exit Function
Erred:
  ErrorHandler "Functions", "ShortenFilename " & strFile
  Resume Next
End Function
Public Function SlashCheck(ByVal strMessage As String) As String
Dim I As Integer
  On Error GoTo Erred
  For I = 1 To &H1F
    strMessage = Replace$(strMessage, Chr$(I), vbNullString)
  Next I
  Do While Left$(strMessage, 1) = "/"
    strMessage = Mid$(strMessage, 2)
  Loop
  SlashCheck = strMessage
Exit Function
Erred:
  ErrorHandler "Functions", "SlashCheck " & strMessage
  Resume Next
End Function
Public Function Specs_Audio() As String
Dim soundinfo As WAVEOUTCAPS
Dim tmp As String
Dim I As Long
  On Error GoTo Erred
  If waveOutGetNumDevs > 0 Then
    tmp = vbNullString
    For I = 0 To waveOutGetNumDevs - 1
      waveOutGetDevCapsA I, soundinfo, Len(soundinfo)
      Specs_Audio = Specs_Audio & "Audio Device(" & I & "): " & FindIllegal(soundinfo.szPname) & vbLf
    Next I
  End If
  If LenB(Specs_Audio) = 0 Then
    Specs_Audio = "Audio Device: None detected."
  Else
    Specs_Audio = Left$(Specs_Audio, Len(Specs_Audio) - 1)
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "SpecsAudio"
  Resume Next
End Function
Public Function Specs_Drives() As String
Dim sDrive      As String
Dim liAvailable As LARGE_INTEGER
Dim liTotal     As LARGE_INTEGER
Dim liFree      As LARGE_INTEGER
Dim dblTotal    As Double
Dim dblFree     As Double
Dim dblAvail    As Double
Dim I           As Integer
Dim DriveName   As String
Dim DriveSerial As Long
Dim DriveFormat As String
Dim DriveType   As String
Dim DriveInfo   As String
  On Error GoTo Erred
  For I = 65 To 90
    DriveName = vbNullString
    DriveFormat = vbNullString
    DriveType = vbNullString
    DriveInfo = vbNullString
    liAvailable.highpart = 0
    liAvailable.lowpart = 0
    liTotal.highpart = 0
    liTotal.lowpart = 0
    liFree.highpart = 0
    liFree.lowpart = 0
    dblTotal = 0
    dblFree = 0
    DriveSerial = 0
    sDrive = Chr$(I) & ":\"
    GetDiskFreeSpaceExA sDrive, liAvailable, liTotal, liFree
    dblTotal = CLargeInt(liTotal.lowpart, liTotal.highpart)
    dblFree = CLargeInt(liFree.lowpart, liFree.highpart)
    dblAvail = CLargeInt(liAvailable.lowpart, liAvailable.highpart)
    GetDriveSpecs sDrive, DriveName, DriveSerial, DriveFormat
    Select Case GetDriveTypeA(sDrive)
      Case 2
        DriveType = "Removable Drive"
      Case 3
        DriveType = "Hard Drive"
      Case 4
        DriveType = "Remote Drive"
      Case 5
        DriveType = "CD Drive"
      Case 6
        DriveType = "Ramdisk"
      Case Else
        DriveType = vbNullString
    End Select
    If DriveType <> vbNullString Then
      DriveInfo = DriveType
      If DriveName <> vbNullString Then DriveInfo = DriveInfo & " " & DriveName
      DriveInfo = DriveInfo & " (" & sDrive & ")"
      If DriveFormat <> vbNullString Then DriveInfo = DriveInfo & " [" & DriveFormat & "]"
      If dblTotal > 0 Then
        DriveInfo = DriveInfo & ":"
        DriveInfo = DriveInfo & " " & ByteSize(dblTotal)
        If dblFree > 0 Then DriveInfo = DriveInfo & " (" & ByteSize(dblFree) & " free)"
      End If
      If DriveSerial <> 0 Then DriveInfo = DriveInfo & ", Volume Serial #:" & Hex$(DriveSerial)
      Specs_Drives = Specs_Drives & DriveInfo & vbLf
    End If
  Next I
  If LenB(Specs_Drives) = 0 Then
    Specs_Drives = "Drive: None detected."
  Else
    Specs_Drives = Left$(Specs_Drives, Len(Specs_Drives) - 1)
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "SpecsDrives"
  Resume Next
End Function
Public Function Specs_Memory() As String
Dim Mem As MEMORYSTATUS
  On Error GoTo Erred
  GlobalMemoryStatus Mem
  Specs_Memory = "Memory: " & ByteSize(Mem.dwTotalPhys) & " physical, " & ByteSize(Mem.dwTotalVirtual) & " virtual"
  If LenB(Specs_Memory) = 0 Then Specs_Memory = "Memory: None detected."
Exit Function
Erred:
  ErrorHandler "Functions", "SpecsMemory"
  Resume Next
End Function
Public Function Specs_Motherboard() As String
Dim SpecList     As String
Dim BaseBoardSet As SWbemObjectSet
Dim bb           As SWbemObject
  On Error GoTo Erred
  Set BaseBoardSet = GetObject("winmgmts:{impersonationLevel=impersonate}").InstancesOf("Win32_BaseBoard")
  For Each bb In BaseBoardSet
    SpecList = SpecList & "Motherboard: " & bb.Manufacturer & " " & bb.Product & vbLf
  Next bb
  Specs_Motherboard = Left$(SpecList, Len(SpecList) - 1)
  If LenB(Specs_Motherboard) = 0 Then Specs_Motherboard = "Motherboard: None detected."
Exit Function
Erred:
  If Err.Number = 432 Then
    Specs_Motherboard = "Motherboard information not available."
  Else
    ErrorHandler "Functions", "SpecsVideo"
    Resume Next
  End If
End Function
Private Function GetOSInfo(ByRef VerInfo As OSVERSIONINFOEX) As Boolean
Dim udtVerinfo  As OSVERSIONINFOEX
Dim strInfo     As String
  udtVerinfo.szCSDVersion = Space$(128)
  udtVerinfo.dwOSVersionInfoSize = Len(udtVerinfo)
  If GetVersionExA(udtVerinfo) Then
    VerInfo = udtVerinfo
    GetOSInfo = True
  ElseIf GetVersion <> 0 Then
    strInfo = Hex$(GetVersion)
    strInfo = String$(8 - Len(strInfo), "0") & strInfo
    If Mid$(strInfo, 1, 4) <> "C000" Then udtVerinfo.dwBuildNumber = Val("&H" & Mid$(strInfo, 1, 4))
    udtVerinfo.dwMinorVersion = Val("&H" & Mid$(strInfo, 5, 2))
    udtVerinfo.dwMajorVersion = Val("&H" & Mid$(strInfo, 7, 2))
    VerInfo = udtVerinfo
    GetOSInfo = True
  Else
    GetOSInfo = False
  End If
End Function
Public Function Specs_OS() As String
Dim strMsg       As String
Dim BuildNo      As Long
Dim udtVerinfo   As OSVERSIONINFOEX
  On Error GoTo Erred
  If GetOSInfo(udtVerinfo) Then
    Select Case udtVerinfo.dwMajorVersion
      Case 4
        BuildNo = Val("&H" & Right$(Hex$(udtVerinfo.dwBuildNumber), 4))
        Select Case udtVerinfo.dwMinorVersion
          Case 0
            Select Case udtVerinfo.wProductType
              Case 0
                strMsg = "Windows 95 "
              Case 1
                strMsg = "Windows NT "
              Case Else
                strMsg = "Windows "
            End Select
          Case 10
            If BuildNo < 2183 Then
              strMsg = "Windows 98 "
            Else
              strMsg = "Windows 98 SE "
            End If
          Case 90
            strMsg = "Windows ME "
          Case Else
            strMsg = "Windows "
        End Select
      Case 5
        BuildNo = udtVerinfo.dwBuildNumber
        Select Case udtVerinfo.wProductType
          Case 1
            Select Case udtVerinfo.dwMinorVersion
              Case 0
                strMsg = "Windows 2000 "
              Case 1
                strMsg = "Windows XP "
              Case 2
                strMsg = "Windows XP Professional x64 "
              Case Else
                strMsg = "Windows "
            End Select
          Case 2, 3
            Select Case udtVerinfo.dwMinorVersion
              Case 0
                strMsg = "Windows 2000 Server "
              Case Else
                strMsg = "Windows Server 2003 "
            End Select
          Case Else
            strMsg = "Windows "
        End Select
      Case 6
        BuildNo = udtVerinfo.dwBuildNumber
        Select Case udtVerinfo.wProductType
          Case 1
            strMsg = "Windows Vista "
          Case 2, 3
            strMsg = "Windows Server 2008 "
          Case Else
            strMsg = "Windows Server "
        End Select
      Case Else
        BuildNo = udtVerinfo.dwBuildNumber
        strMsg = "Windows "
    End Select
    If LenB(strMsg) > 0 Then
      Specs_OS = "Operating System: " & strMsg & "Version " & udtVerinfo.dwMajorVersion & "." & udtVerinfo.dwMinorVersion & IIf(LenB(BuildNo) > 0, "." & BuildNo, "") & " " & FindIllegal(udtVerinfo.szCSDVersion)
    Else
      Specs_OS = "Operating System: Unable to determine."
    End If
  Else
    Specs_OS = "Operating System: None detected."
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "SpecsOS"
  Resume Next
End Function
Public Function Specs_Processor() As String
Dim RegPath As String
  On Error GoTo Erred
  RegPath = "HARDWARE\DESCRIPTION\System\CentralProcessor\0"
  Specs_Processor = "Processor: "
  If LenB(Trim$(regQuery_A_Key(HKEY_LOCAL_MACHINE, RegPath, "VendorIdentifier"))) > 0 Then
    Specs_Processor = Specs_Processor & Trim$(regQuery_A_Key(HKEY_LOCAL_MACHINE, RegPath, "VendorIdentifier")) & "- "
  Else
    Specs_Processor = Specs_Processor & "Unknown- "
  End If
  If LenB(Trim$(regQuery_A_Key(HKEY_LOCAL_MACHINE, RegPath, "ProcessorNameString"))) > 0 Then Specs_Processor = Specs_Processor & Trim$(regQuery_A_Key(HKEY_LOCAL_MACHINE, RegPath, "ProcessorNameString")) & " "
  If LenB(Trim$(regQuery_A_Key(HKEY_LOCAL_MACHINE, RegPath, "Identifier"))) > 0 Then Specs_Processor = Specs_Processor & "(" & Trim$(regQuery_A_Key(HKEY_LOCAL_MACHINE, RegPath, "Identifier")) & ") "
  If LenB(Trim$(regQuery_A_Key(HKEY_LOCAL_MACHINE, RegPath, "~MHz"))) > 0 Then Specs_Processor = Specs_Processor & "running at ~" & Trim$(regQuery_A_Key(HKEY_LOCAL_MACHINE, RegPath, "~MHz")) & " MHz"
Exit Function
Erred:
  ErrorHandler "Functions", "SpecsProcessor"
  Resume Next
End Function
Public Function Specs_Video() As String
Dim SpecList  As String
Dim wmiObjSet As SWbemObjectSet
Dim obj       As SWbemObject
Dim VidCount  As Byte
Dim bm        As BITMAP
  On Error GoTo Erred
  Set wmiObjSet = GetObject("winmgmts:{impersonationLevel=impersonate}").InstancesOf("Win32_VideoController")
  VidCount = 1
  For Each obj In wmiObjSet
    SpecList = SpecList & "Video Card(" & VidCount & "): " & ByteSize(obj.AdapterRAM) & " " & obj.VideoProcessor & vbLf
    VidCount = VidCount + 1
  Next obj
  If LenB(SpecList) = 0 Then SpecList = "Video Card: None detected." & vbLf
  GetObjectA frmMain.Image, Len(bm), bm
  SpecList = SpecList & "Screen Resolution: " & Screen.Width / Screen.TwipsPerPixelX & "x" & Screen.Height / Screen.TwipsPerPixelY & " with " & bm.bmBitsPixel & "bit color"
  Specs_Video = SpecList
Exit Function
Erred:
  If Err.Number = 432 Then
    Specs_Video = "Video Card information not available."
  Else
    ErrorHandler "Functions", "SpecsVideo"
    Resume Next
  End If
End Function
Public Function StH(ByVal StrToHex As String) As String
Dim strTemp   As String
Dim strReturn As String
Dim I         As Long
  On Error GoTo Erred
  For I = 1 To Len(StrToHex)
    strTemp = Hex$(Asc(Mid$(StrToHex, I, 1)))
    If Len(strTemp) = 1 Then strTemp = "0" & strTemp
    strReturn = strReturn & strTemp
  Next I
  StH = strReturn
Exit Function
Erred:
  ErrorHandler "Functions", "StH"
  Resume Next
End Function
Public Function strDWORD(ByVal lValue As Long) As String
Dim Result As String * 4
  On Error GoTo Erred
  RtlMoveMemory ByVal Result, lValue, 4
  strDWORD = Replace$(StrReverse(Result), vbNullChar, "")
Exit Function
Erred:
  ErrorHandler "Functions", "strDWORD " & Hex$(lValue)
  Resume Next
End Function
Public Function SysDir() As String
Dim SystemDir As String
Dim Ret       As Long
  On Error GoTo Erred
  SystemDir = Space$(&HFF)
  Ret = GetSystemDirectoryA(SystemDir, &HFF)
  SystemDir = Left$(SystemDir, Ret)
  SysDir = SystemDir
Exit Function
Erred:
  ErrorHandler "Functions", "SysDir"
  Resume Next
End Function
Public Function TempDir() As String
  On Error GoTo Erred
  If LenB(Dir$(GetTempDir & "RCB", vbDirectory)) = 0 Then MkDir GetTempDir & "RCB"
  If LenB(Profile) > 0 Then
    If LenB(Dir$(GetTempDir & "RCB\" & Profile, vbDirectory)) = 0 Then MkDir GetTempDir & "RCB\" & Profile
    TempDir = GetTempDir & "RCB\" & Profile & "\" & Hex$(Int(Rnd * 16)) & Hex$(Int(Rnd * 16)) & Hex$(Int(Rnd * 16)) & Hex$(Int(Rnd * 16)) & Hex$(Int(Rnd * 16)) & Hex$(Int(Rnd * 16)) & "\"
  Else
    TempDir = GetTempDir & "RCB\" & Hex$(Int(Rnd * 16)) & Hex$(Int(Rnd * 16)) & Hex$(Int(Rnd * 16)) & Hex$(Int(Rnd * 16)) & Hex$(Int(Rnd * 16)) & Hex$(Int(Rnd * 16)) & "\"
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "TempDir"
  Resume Next
End Function
Public Function TimeZoneBias() As String
Dim SysFT   As FILETIME
Dim LocFT   As FILETIME
  On Error GoTo Erred
  LocFT = GetFTLocal
  SysFT = GetFTSystem
  TimeZoneBias = DateDiff("n", GetFTTime(LocFT, True, False), GetFTTime(SysFT, True, False))
Exit Function
Erred:
  ErrorHandler "Functions", "TimeZoneBias"
  Resume Next
End Function
Public Function TimeZoneName() As String
Dim oTZI     As TIME_ZONE_INFORMATION
Dim TimeZone As String
Dim tmp      As String
Dim DLSDate  As String
Dim DLSName  As String
Dim STDDate  As String
Dim STDName  As String
Dim Bias     As Long
Dim I        As Integer
  On Error GoTo Erred
  GetTimeZoneInformation oTZI
  DLSDate = oTZI.DaylightDate.wMonth & "/" & oTZI.DaylightDate.wDay & "/" & Year(Date) & " " & oTZI.DaylightDate.wHour & ":" & oTZI.DaylightDate.wMinute & ":" & oTZI.DaylightDate.wSecond
  DLSName = vbNullString
  For I = 0 To 31
    DLSName = DLSName & Chr$(oTZI.DaylightName(I))
  Next I
  STDDate = oTZI.StandardDate.wMonth & "/" & oTZI.StandardDate.wDay & "/" & Year(Date) & " " & oTZI.StandardDate.wHour & ":" & oTZI.StandardDate.wMinute & ":" & oTZI.StandardDate.wSecond
  STDName = vbNullString
  For I = 0 To 31
    STDName = STDName & Chr$(oTZI.StandardName(I))
  Next I
  DLSName = TrimNull(DLSName)
  STDName = TrimNull(STDName)
  If oTZI.DaylightDate.wMonth = 0 Then
    Bias = oTZI.Bias - oTZI.StandardBias
    TimeZoneName = STDName
    GoTo SkipDST
  End If
  'This needs to be checked and worked on!
  'Debug.Print STDDate & " " & DLSDate
  'Debug.Print DateDiff("d", DLSDate, STDDate)
  If DateDiff("d", DLSDate, STDDate) > 0 Then
    TimeZoneName = DLSName
  Else
    TimeZoneName = STDName
  End If
SkipDST:
  TimeZone = Trim$(Str$(-1 * (oTZI.Bias / 60)))
  If InStr(1, TimeZone, "-") = 0 Then TimeZone = "+" & TimeZone
  If InStr(1, TimeZone, ".") Then
    TimeZoneName = "[" & TimeZoneName & " (GMT " & Left$(TimeZone, InStr(1, TimeZone, ".") - 1) & ":" & Left$((Mid$(TimeZone, InStr(1, TimeZone, ".") + 1) * 60 / 10), 2) & ")]"
  Else
    TimeZoneName = "[" & TimeZoneName & " (GMT " & TimeZone & ":00" & ")]"
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "TimeZoneName"
  Resume Next
End Function
Public Function Translate(Conversion As String) As String
Dim ConversionType As String
Dim ConversionText As String
Dim Translation    As String
Dim Ans            As String
  On Error GoTo Erred
  ConversionType = Replace$(LCase$(Left$(Conversion, 5)), "-", "_")
  ConversionText = Replace$(Mid$(Conversion, 7), " ", "_")
  ConversionText = Replace$(ConversionText, "'", "`")
  DoEvents
  Translation = frmMain.httpNews.GetURL("http://babelfish.altavista.com/babelfish/trurl_pagecontent?lp=" & ConversionType & "&url=rcb.realityripple.com/trans.php?q=" & ConversionText)
  DoEvents
  Ans = Mid$(Translation, InStr(1, Translation, vbLf) + 1)
  Ans = Left$(Ans, InStr(1, Ans, "<!-") - 1)
  Ans = Replace$(Ans, vbCr, "")
  Ans = Replace$(Ans, vbLf, " ")
  If InStr(1, Ans, "<html>") Then GoTo Erred
  Translate = Ans
  Exit Function
Erred:
  If InStr(1, Translation, "<tr><td><b>") > 0 Then
    Translate = Mid$(Translation, InStr(1, Translation, "<tr><td><b>") + 11)
    Translate = "Error Translating: " & Left$(Translate, InStr(1, Translate, "</b>") - 1)
  ElseIf LenB(Err.Description) > 0 Then
    Translate = "Error Translating: " & Err.Description
  Else
    Translate = "Could Not Translate!"
  End If
End Function
Public Function TrimNull(ByVal Item As String) As String
Dim Pos As Integer
  On Error GoTo Erred
  Pos = InStr(1, Item, vbNullChar)
  If Pos Then
    TrimNull = Left$(Item, Pos - 1)
  Else
    TrimNull = Item
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "TrimNull " & Item
  Resume Next
End Function
Public Function Version() As String
  On Error GoTo Erred
  If Len(Trim$(Str$(App.Revision))) > 2 Then
    If Mid$(Trim$(Str$(App.Revision)), 2, 1) = "0" Then
      Version = App.major & "." & App.minor & "." & Left$(App.Revision, 1) & "1 Beta " & Mid$(App.Revision, 3)
    ElseIf Mid$(Trim$(Str$(App.Revision)), 2, 1) = "9" Then
      Version = App.major & "." & App.minor & "." & Left$(Left$(App.Revision, 2) + 1, 1) & " Beta " & Mid$(App.Revision, 3)
    Else
      Version = App.major & "." & App.minor & "." & Left$(App.Revision, 2) + 1 & " Beta " & Mid$(App.Revision, 3)
    End If
  Else
    Version = App.major & "." & App.minor & "." & App.Revision
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "Version"
  Resume Next
End Function
Public Function WindowEnumerator(ByVal app_hwnd As Long, ByVal lParam As Long) As Long
Dim buf    As String * 256
Dim Title  As String
Dim Length As Long
  On Error GoTo Erred
  Length = GetWindowTextA(app_hwnd, buf, Len(buf))
  Title = Left$(buf, Length)
  If InStr(Title, TargetName) > 0 Then
    TargetHwnd = app_hwnd
    WindowEnumerator = False
  Else
    WindowEnumerator = True
  End If
Exit Function
Erred:
  ErrorHandler "Functions", "WindowEnumerator"
  Resume Next
End Function
Public Sub WriteINI(ByVal wiSection As String, ByVal wiKey As String, ByVal wiValue As String, ByVal wiFile As String)
  On Error GoTo Erred
  WritePrivateProfileStringA wiSection, wiKey, wiValue, SettingsFolder & "\" & wiFile
Exit Sub
Erred:
  If Err.Description = "File already open" Then
    MessageBox "Could not save the config file. It is currently in use.", Critical, OKOnly
  Else
    ErrorHandler "Functions", "WriteINI " & SettingsFolder & "\" & wiFile & "/" & wiSection & "/" & wiKey & "/" & wiValue
    Resume Next
  End If
End Sub
