#include "Statstring.h"
#include <stdio.h>
#include <string.h>
#include <windows.h>

void ParseStatstring(char *statstring, char *outbuf)
{
	DWORD a, b, c, d, e, f, g, h, i, j;
	strcpy(outbuf, statstring);
	//Starcraft Shareware
	if(!strnicmp(statstring, "RHSS", 4))
	{
		if(sscanf(statstring + 5, "%d %d %d %d %d %d %d %d %d", &a, &b, &c, &d, &e, &f, &g, &h, &i, &j) != 9)
		{
			strcpy(outbuf, "Starcraft Shareware Bot");
			return;
		}
		if(a > 0)
			sprintf(outbuf, "Starcraft Shareware (Wins: %d, Ladder Rating: %d)", c, a);
		else
			sprintf(outbuf, "Starcraft Shareware (Wins: %d)", c);
	}

	//Starcraft Japanese
	if(!strnicmp(statstring, "RTSJ", 4))
	{
		if(sscanf(statstring + 5, "%d %d %d %d %d %d %d %d %d", &a, &b, &c, &d, &e, &f, &g, &h, &i, &j) != 9)
		{
			sprintf(outbuf, "Starcraft Japanese %sBot.", (d == 1) ? "Spawn " : "");
			return;
		}
		if(a > 0)
			sprintf(outbuf, "Starcraft Japanese %s(Wins: %d, Ladder Rating: %d)", (d == 1) ? "Spawn " : "", c, a);
		else
			sprintf(outbuf, "Starcraft Japanese %s(Wins: %d)", (d == 1) ? "Spawn " : "", c);
	}

	//Starcraft
	if(!strnicmp(statstring, "RATS", 4))
	{
		if(sscanf(statstring + 5, "%d %d %d %d %d %d %d %d %d", &a, &b, &c, &d, &e, &f, &g, &h, &i, &j) != 9)
		{
			sprintf(outbuf, "Starcraft %sBot.", (d == 1) ? "Spawn " : "");
			return;
		}
		if(a > 0)
			sprintf(outbuf, "Starcraft %s(Wins: %d, Ladder Rating: %d)", (d == 1) ? "Spawn " : "", c, a);
		else
			sprintf(outbuf, "Starcraft %s(Wins: %d)", (d == 1) ? "Spawn " : "", c);
	}

	//Brood War
	if(!strnicmp(statstring, "PXES", 4))
	{
		if(sscanf(statstring + 5, "%d %d %d %d %d %d %d %d %d", &a, &b, &c, &d, &e, &f, &g, &h, &i, &j) != 9)
		{
			sprintf(outbuf, "Starcraft Brood War %sBot.", (d == 1) ? "Spawn " : "");
			return;
		}
		if(a > 0)
			sprintf(outbuf, "Starcraft Brood War %s(Wins: %d, Ladder Rating: %d)", (d == 1) ? "Spawn " : "", c, a);
		else
			sprintf(outbuf, "Starcraft Brood War %s(Wins: %d)", (d == 1) ? "Spawn " : "", c);
	}

	//Warcraft II
	if(!strnicmp(statstring, "NB2W", 4))
	{
		if(sscanf(statstring + 5, "%d %d %d %d %d %d %d %d %d", &a, &b, &c, &d, &e, &f, &g, &h, &i, &j) != 9)
		{
			sprintf(outbuf, "Warcraft II %sBot.", (d == 1) ? "Spawn " : "");
			return;
		}
		if(a > 0)
			sprintf(outbuf, "Warcraft II %s(Wins: %d, Ladder Rating: %d)", (d == 1) ? "Spawn " : "", c, a);
		else
			sprintf(outbuf, "Warcraft II %s(Wins: %d)", (d == 1) ? "Spawn " : "", c);
	}

	//Diablo Shareware
	if(!strnicmp(statstring, "RHSD", 4))
	{
		if(sscanf(statstring + 5, "%d %d %d %d %d %d %d %d %d", &a, &b, &c, &d, &e, &f, &g, &h, &i, &j) != 9)
		{
			strcpy(outbuf, "Diablo Shareware Bot");
			return;
		}
		char type[32] = "";
		if(c == 0) strcpy(type, "Warrior");
		if(c == 1) strcpy(type, "Sorceror");
		if(c == 2) strcpy(type, "Rogue");
		sprintf(outbuf, "Diablo Shareware (Level %d %s, Dots: %d, Strength: %d, Magic: %d, Dexterity: %d, Vitality: %d, Gold: %d)", a, type, b, d, e, f, g, h);
	}

	//Diablo
	if(!strnicmp(statstring, "LTRD", 4))
	{
		if(sscanf(statstring + 5, "%d %d %d %d %d %d %d %d %d", &a, &b, &c, &d, &e, &f, &g, &h, &i, &j) != 9)
		{
			strcpy(outbuf, "Diablo Bot");
			return;
		}
		char type[32] = "";
		if(c == 0) strcpy(type, "Warrior");
		if(c == 1) strcpy(type, "Sorceror");
		if(c == 2) strcpy(type, "Rogue");
		sprintf(outbuf, "Diablo (Level %d %s, Dots: %d, Strength: %d, Magic: %d, Dexterity: %d, Vitality: %d, Gold: %d)", a, type, b, d, e, f, g, h);
	}

	//Diablo II
	if(!strnicmp(statstring + 2, "2D", 2))
		strcpy(outbuf, ParseD2Stats(statstring));

	//Chat Client
	if(!strnicmp(statstring, "TAHC", 4))
		strcpy(outbuf, "Chat Client");
	
	//Warcraft III
	if(!strnicmp(statstring, "3RAW", 4))
		strcpy(outbuf, "Warcraft III (FINISH NEXT TIME)");
}

char *ParseD2Stats(char *stats)
{
	char *d2classes[] = 
	{
		"Amazon",
		"Sorceress",
		"Necromancer",
		"Paladin",
		"Barbarian",
		"Druid",
		"Assassin",
		"Unknown Class Type"
	};
	char *statbuf = new char[512];
	memset(statbuf, 0, 512);
	char *p = 0;
	char server[32];
	char name[32];
	if(strlen(stats) > 4) {
		int len = StringCopy(server, stats + 4, ',');
		len += StringCopy(name, stats + len + 5, ',');
		p = stats + len + 6;
	}
	if(!strnicmp(stats, "VD2D", 4))
		strcat(statbuf, "Diablo II (");
	else
		strcat(statbuf, "Lord of Destruction: (");
	if(!p || strlen(p) != 33) {
		strcat(statbuf, "Open)");
	} else {
		char version = p[0] - 0x80;
		char charclass = p[13] - 1;
		if(charclass < 0 || charclass > 6)
			charclass = 7;
		bool female = false;
		if(charclass == 0 || charclass == 1 || charclass == 6)
			female = true;
		int charlevel = p[25];
		char hardcore = p[26] & 4;
		bool expansion = false;
		if(!strnicmp(stats, "PX2D", 4))
		{
			if(p[26] & 0x20)
			{
				switch((p[27] & 0x18) >> 3)	
				{
				case 1:
					if(hardcore)
						mystrcat(statbuf, "Destroyer ");
					else
						mystrcat(statbuf, "Slayer ");
					break;
				case 2:
					if(hardcore)
						mystrcat(statbuf, "Conquerer ");
					else
						mystrcat(statbuf, "Champion ");
					break;
				case 3:
					if(hardcore)
						mystrcat(statbuf, "Guardian ");
					else
					{
						if(!female)
							mystrcat(statbuf, "Patriarch ");
						else
							mystrcat(statbuf, "Matriarch ");
					}
					break;
				}
				expansion = true;
			}
		}
		if(!expansion){
		switch((p[27] & 0x18) >> 3) {
			case 1:
				if(female == false) {
					if(hardcore)
						mystrcat(statbuf, "Count ");
					else
						mystrcat(statbuf, "Sir ");
				} else {
					if(hardcore)
						mystrcat(statbuf, "Countess ");
					else
						mystrcat(statbuf, "Dame ");
				}
				break;
			case 2:
				if(female == false) {
					if(hardcore)
						mystrcat(statbuf, "Duke ");
					else
						mystrcat(statbuf, "Lord ");
				} else {
					if(hardcore)
						mystrcat(statbuf, "Duchess ");
					else
						mystrcat(statbuf, "Lady ");
				}
				break;
			case 3:
				if(female == false) {
					if(hardcore)
						mystrcat(statbuf, "King ");
					else
						mystrcat(statbuf, "Baron ");
				} else {
					if(hardcore)
						mystrcat(statbuf, "Queen ");
					else
						mystrcat(statbuf, "Baroness ");
				}
				break;
		}}
		mystrcat(statbuf, "%s@%s", (strlen(name)==0 ? "<Invalid Character>" : name), server);
		if(hardcore) {
			if(p[26] & 0x08)
				strcat(statbuf, ", a dead");
			else
				strcat(statbuf, ", a");
			mystrcat(statbuf, " hardcore level %d", charlevel);
		} else {
			mystrcat(statbuf, ", level %d", charlevel);
		}
		mystrcat(statbuf, " %s)", d2classes[charclass]);
	}
	return statbuf;
}

int StringCopy(char *dest, char *source, int stopchar)
{
	int lencopied = 0;
	while(*source && *source != stopchar) {
		*dest = *source;
		dest++;
		source++;
		lencopied++;
	}
	if(lencopied)
		*dest = 0;
	return lencopied;
}

char *mystrcat(char *dest, char *src, ...)
{
	va_list argptr;
	va_start(argptr, src);
	vsprintf(dest + strlen(dest), src, argptr);
	va_end(argptr);
	return dest;
}

int GetIconCode(char *prog, int flags)
{
	int iconcode;
	if(!strncmp(prog, "TAHC", 4)) iconcode = CHAT;
	if(!strncmp(prog, "LTRD", 4)) iconcode = DRTL;
	if(!strncmp(prog, "RATS", 4)) iconcode = SC;
	if(!strncmp(prog, "RTSJ", 4)) iconcode = SCJ;
	if(!strncmp(prog, "RHSD", 4)) iconcode = DSHR;
	if(!strncmp(prog, "RHSS", 4)) iconcode = SSHR;
	if(!strncmp(prog, "PXES", 4)) iconcode = BW;
	if(!strncmp(prog, "VD2D", 4)) iconcode = D2;
	if(!strncmp(prog, "PX2D", 4)) iconcode = D2X;
	if(!strncmp(prog, "NB2W", 4)) iconcode = WAR2;
	if(!strncmp(prog, "3RAW", 4)) iconcode = WAR3;
	if(flags & 0x01) iconcode = BLIZZ;
	if(flags & 0x02) iconcode = OP;
	if(flags & 0x04) iconcode = BLIZZ;
	if(flags & 0x08) iconcode = BLIZZ;
	if(flags & 0x20) iconcode = BRX;
	if(flags & 0x40) iconcode = BLIZZ;
	return iconcode;
}