#ifndef PACKETBUFFER_H
#define PACKETBUFFER_H

class PacketBuffer {
public:
	PacketBuffer(const PacketBuffer *srcbuf);
	PacketBuffer(void);
	~PacketBuffer();
	void insert(unsigned long data);
	void insert(const char *data);
	void insert(const void *data, int size);
	void insertbyte(unsigned char data);
	void insertshort(unsigned short data);
	unsigned long extract(void);
	char *extract(char *databuf);
	unsigned char extractbyte(void);
	void *extract(void *databuf, int size);
	unsigned short extractlen(void);
	short extractepos(void);
	short extractipos(void);
	void clear(void);
	void getpacket(int, char*);
	void resetextraction(void);
	void resetinsertion(void);
	void reset(void);
	void sendpacket(int s, char id);
	void sendpacketto(int s, char *server, unsigned short port);
	operator char *(void);
	operator int(void);
	operator +=(int size);
	operator -=(int size);
	char buffer[8192];
	short len;
	short ipos;
	short epos;
};

#endif