#include "PacketBuffer.h"

#include <string.h>
#include <winsock2.h>
#include <windows.h>
#include <process.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>

PacketBuffer::PacketBuffer(const PacketBuffer *srcbuf) {
	ZeroMemory(buffer, sizeof(buffer));
	ipos = epos = len = 0;
	insert((char *)srcbuf, (int)srcbuf);
}

PacketBuffer::PacketBuffer(void) {
	ZeroMemory(buffer, sizeof(buffer));
	ipos = epos = len = 0;
}

PacketBuffer::~PacketBuffer() { }

void PacketBuffer::sendpacket(int s, char id)
{
	char packetbuffer[1024] = "";
	packetbuffer[0] = (char)0xff;
	packetbuffer[1] = id;
	*(unsigned short *)(packetbuffer + 2) = (unsigned short)len + 4;
	memcpy(packetbuffer + 4, buffer, len);
	send(s, packetbuffer, len + 4, 0);
	clear();
}

void PacketBuffer::getpacket(int id, char *recv)
{
	char packetbuffer[1024] = "";
	packetbuffer[0] = (char)0xff;
	packetbuffer[1] = id;
	*(unsigned short *)(packetbuffer + 2) = (unsigned short)len + 4;
	memcpy(packetbuffer + 4, buffer, len);
	strcpy(recv, packetbuffer + 4);
}

void PacketBuffer::sendpacketto(int s, char *server, unsigned short port)
{
	char packetbuffer[1024] = "";
	memcpy(packetbuffer, buffer, len);
	struct sockaddr_in udpsaddr;
	struct hostent *hp;
	memset(&udpsaddr, '\0', sizeof(udpsaddr));
	udpsaddr.sin_family = PF_INET;
	udpsaddr.sin_port = htons(port);
	char *p = server;
	while(*p && (isdigit(*p) || (*p == '.')))
		p++;
	if(*p){
		hp = gethostbyname(server);
		if(hp == 0)
			return;
		memcpy(&udpsaddr.sin_addr, hp->h_addr, hp->h_length);
	}
	else
		udpsaddr.sin_addr.s_addr = inet_addr(server);
	sendto(s, packetbuffer, len, 0, (struct sockaddr *)&udpsaddr, sizeof(udpsaddr));
	clear();
}

void PacketBuffer::insert(unsigned long data) {
	memcpy(buffer + ipos, &data, sizeof(data));
	if(ipos + sizeof(data) > len)
		len = ipos + sizeof(data);
	ipos += sizeof(data);
}

void PacketBuffer::insert(const char *data) {
	strcpy(buffer + ipos, data);
	if(ipos + strlen(data) + 1 > len)
		len = ipos + strlen(data) + 1;
	ipos += strlen(data) + 1;
}

void PacketBuffer::insert(const void *data, int size) {
	memcpy(buffer + ipos, data, size);
	if(ipos + size > len)
		len = ipos + size;
	ipos += size;
}

void PacketBuffer::insertbyte(unsigned char data) {
//	*(buffer + ipos) = data;
	memcpy(buffer + ipos, &data, sizeof(data));
	if(ipos + sizeof(data) > len)
		len = ipos + sizeof(data);
	ipos += sizeof(data);
}

void PacketBuffer::insertshort(unsigned short data) {
	memcpy(buffer + ipos, &data, sizeof(data));
	if(ipos + sizeof(data) > len)
		len = ipos + sizeof(data);
	ipos += sizeof(data);
}

unsigned long PacketBuffer::extract(void) {
	if(len - epos >= 4) {
		epos += 4;
		return *(unsigned long *)(buffer + epos - 4);
	} else
		return 0;
}

char *PacketBuffer::extract(char *databuf) {
	if(memchr(buffer + epos, 0, len - epos)) {
		strcpy(databuf, (char *)buffer + epos);
		epos += strlen(databuf) + 1;
	} else {
		memcpy(databuf, buffer + epos, len - epos);
		databuf[len - epos] = 0;
		epos = len;
	}
	return databuf;
}

unsigned char PacketBuffer::extractbyte(void) {
	if(len - epos >= 1) {
		epos += 1;
		return *(unsigned char *)(buffer + epos - 1);
	} else
		return 0;
}

void *PacketBuffer::extract(void *databuf, int size) {
	if(len - epos >= size) {
		memcpy(databuf, buffer + epos, size);
		epos += size;
	}
	return databuf;
}

unsigned short PacketBuffer::extractlen(void) {
	return len;
}

short PacketBuffer::extractepos(void) {
	return epos;
}

short PacketBuffer::extractipos(void) {
	return ipos;
}

void PacketBuffer::clear(void) {
	ZeroMemory(buffer, sizeof(buffer));
	len = epos = ipos = 0;
}

void PacketBuffer::resetextraction(void) {
	epos = 0;
}

void PacketBuffer::resetinsertion(void) {
	ipos = 0;
}

void PacketBuffer::reset(void) {
	epos = ipos = 0;
}

PacketBuffer::operator char *(void) {
	return buffer;
}

PacketBuffer::operator int(void) {
	return len;
}

int PacketBuffer::operator +=(int size) {
	if(epos + size <= len)
		epos += size;
	return epos;
}

int PacketBuffer::operator -=(int size) {
	if(epos - size >= 0)
		epos -= size;
	return epos;
}
