#include <new.h>
#include "controls.h"
#include "rc.h"

//The instance
HINSTANCE TheInstance = NULL;

//There is no need to edit ANYTHING in this file


//////////////////////////////////This is the beginning of your form, no need to edit!
BOOL CALLBACK DialogProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    static Controller* control = NULL;
	HINSTANCE RichEditDLL = LoadLibrary("RichEd32.dll");
	InitCommonControls();
    switch (message)
    {
    case WM_INITDIALOG:
        try
        {
            control = new Controller (hwnd, TheInstance);
        }
        catch (WinException e)
        {
            MessageBox (0, e.GetMessage (), "Exception", MB_ICONEXCLAMATION | MB_OK);
        }
        catch (...)
        {
            MessageBox (0, "Unknown", "Exception", MB_ICONEXCLAMATION | MB_OK);
            return -1;
        }
        return TRUE;
    case WM_COMMAND:
        control->Command(hwnd, LOWORD(wParam), HIWORD (wParam));
        return TRUE;
	case WM_SIZE:
		//control->Command(hwnd, LOWORD(wParam), HIWORD (wParam));
		//control->_richedit.Resize(100, 200, LOWORD(wParam), HIWORD(wParam), false);
		return TRUE;
    case WM_DESTROY:
        PostQuitMessage(0);
        return TRUE;
    case WM_CLOSE:
        delete control;
		FreeLibrary(RichEditDLL);
        DestroyWindow (hwnd);
        return TRUE;
    }
    return FALSE;
}

///////////////////////////////////////Do not edit this function unless it is a string!
int WINAPI WinMain
   (HINSTANCE hInst, HINSTANCE hPrevInst, char * cmdParam, int cmdShow)
{
    TheInstance = hInst;
    _set_new_handler (&NewHandler);

    HWND hDialog = 0;

    hDialog = CreateDialog (hInst, MAKEINTRESOURCE (DLG_MAIN), 0, (DLGPROC)DialogProc);
    if (!hDialog)
    {
        char buf [100];
        wsprintf (buf, "Error x%x", GetLastError ());
        MessageBox (0, buf, "CreateDialog", MB_ICONEXCLAMATION | MB_OK);
        return 1;
    }

    MSG  msg;
    int status;
    while ((status = GetMessage (&msg, 0, 0, 0)) != 0)
    {
        if (status == -1)
            return -1;
        if (!IsDialogMessage (hDialog, &msg))
        {
            TranslateMessage ( &msg );
            DispatchMessage ( &msg );
        }
    }

    return msg.wParam;
}