#include "List.h"
//#include "Listexcept.hh"
template LList<char *>;

template <class T>
T LList<T>::Get(int index)
{
	TheList.rewind();
	for(int i = 0; i < TheList.get_count(); i++){
		if(i == index)
			return TheList.get();
		++TheList;
	}
	return 0;
}

template <class T>
void LList<T>::Flush(void)
{
	TheList.rewind();
	while(!TheList.at_end()){
		TheList.remove(TheList.get());
		++TheList;
	}
}

template <class T>
int LList<T>::Count()
{
	return TheList.get_count();
}

template <class T>
void LList<T>::Remove(int index)
{
	TheList.rewind();
	for(int i = 0; i < TheList.get_count(); i++){
		if(i == index)
			TheList.remove(TheList.get());
		++TheList;
	}
}

template <class T>
void LList<T>::Add(T data)
{
	TheList.addend(data);
}

template <class T>
List<T>::List() 
{
	head = pos = 0;
	tailp = 0;
	count = 0;
}

template <class T>
List<T>::~List()
{
	while (head) {
		pos = head -> next;
		delete head;
		head = pos;
	}
}

template <class T>
void List<T>::rewind()
{
	pos = head;
}

template <class T>
void List<T>::operator ++()
{
	if (pos) {
		pos = pos -> next;
	} else {
//		throw List_error("Moving past end of list");
	}
}

template <class T>
int List<T>::at_end()
{
	return pos == 0;
}

template <class T>
int List<T>::get_count()
{
	return count;
}

template <class T>
int List<T>::is_empty()
{
	return head == 0;
}

template <class T>
void List<T>::add(T data)
{
	Listnode<T> *p = new Listnode<T>;
	p -> next = head;
	p -> data = data;
	head = p;
	if(!tailp)
		tailp = &head->next;
	count++;
}

template <class T>
void List<T>::addend(T data)
{
	if(!tailp) {
		add(data);
	} else {
		*tailp = new Listnode<T>;
		(*tailp) -> data = data;
		(*tailp) -> next = 0;
		tailp = &(*tailp) -> next;
		count++;
	}
}

template <class T>
void List<T>::remove(T data)
{
	Listnode<T> **pp = &head;
	while (*pp) {
		if ((*pp) -> data == data) {
			Listnode<T> *p;
			p = *pp;
			*pp = p -> next;
			count--;
			if (pos == p) {
				pos = p -> next;
			}
			if(tailp == &p->next)
				tailp = pp;
			delete p;
		} else {
			pp = &(*pp) -> next;
		}
	}
}

template <class T>
T List<T>::get()
{
	if (pos) {
		return pos -> data;
	} else {
//		throw List_error("Reading past end of list");
		return 0;
	}
}

/*template <class T>
List<T>::operator T()
{
	if (pos) {
		return pos -> data;
	} else {
//		throw List_error("Reading past end of list");
		return 0;
	}
}*/
template <class T>
T List<T>::getfirst()
{
	if (head) {
		return head -> data;
	} else {
//		throw List_error("Reading past end of list");
		return 0;
	}
}

template <class T>
T List<T>::takefirst()
{
	if (head) {
		T temp = head -> data;
		Listnode<T> *node = head;
		head = head -> next;
		delete node;
		return temp;
	} else {
//		throw List_error("Reading past end of list");
		return 0;
	}
}






#if 0
template <class T>
LinkedList<T>::LinkedList(void)
{
	head = tail = pos = 0;
	count = 0;
}

template <class T>
LinkedList<T>::~LinkedList()
{
	clear();
}

template <class T>
T LinkedList<T>::get(void)
{
	if(pos)
		return pos -> data;
	else
		return 0;
}

template <class T>
T LinkedList<T>::getfirst(void)
{
	if(head)
		return head -> data;
	else
		return 0;
}

template <class T>
T LinkedList<T>::takefirst(void)
{
	if(head) {
		T temp = head -> data;
		LinkedListNode<T> *pNode = head;

		head = head -> next;

		if(head)
			head -> prev = 0;

		delete pNode;

		count--;

		return temp;
	} else {
		return 0;
	}
}

template <class T>
T LinkedList<T>::getlast(void)
{
	if(tail)
		return tail -> data;
	else
		return 0;
}

template <class T>
T LinkedList<T>::takelast(void)
{
	if(tail) {
		T temp = tail -> data;
		LinkedListNode<T> *pNode = tail;

		tail = tail -> prev;

		if(tail)
			tail -> next = 0;

		delete pNode;

		count--;

		return temp;
	} else {
		return 0;
	}
}

template <class T>
void LinkedList<T>::operator++(void)
{
	if(pos)
		pos = pos -> next;
}

template <class T>
void LinkedList<T>::rewind(void)
{
	pos = head;
}

template <class T>
void LinkedList<T>::add(T data)
{
	LinkedListNode<T> *pNode = new LinkedListNode<T>;

	pNode -> next = head;
	pNode -> prev = 0;
	pNode -> data = data;

	// head itm1
	// itm2
	// itm3

	if(head) {
		// itm1 ->
//		if(head -> next)
//			head -> next -> prev = pNode;
		head -> prev = pNode;
	}
	
	if(!tail)
		tail = pNode;

	head = pNode;
	count++;
}

template <class T>
void LinkedList<T>::addend(T data)
{
	LinkedListNode<T> *pNode = new LinkedListNode<T>;

	pNode -> next = 0;
	pNode -> prev = tail;
	pNode -> data = data;

	if(tail) {
//		if(tail -> prev)
//			tail -> prev -> next = pNode;
		tail -> next = pNode;
	}

	if(!head)
		head = pNode;
	
	tail = pNode;
	count++;
}

template <class T>
void LinkedList<T>::remove(T data)
{
	LinkedListNode<T> *temp = head;

	while(temp) {
		if(temp -> data == data) {
			if(temp -> prev) // hook previous node's next ptr into next node
				temp -> prev -> next = temp -> next;

			if(temp -> next) // hook next node's prev ptr into prev node
				temp -> next -> prev = temp -> prev;

			if(temp == tail) // move tail to previous node
				tail = temp -> prev;

			if(temp == head) // move head to next node
				head = temp -> next;

			delete temp;
			count--;
			break;
		} else {
			temp = temp -> next;
		}
	}
}
#endif

#pragma warning(disable:4284)
#pragma warning(disable:4660) // already instantiated

template List <class Accesslistuser *>;
template List <class Channeluser *>;
template List <void *>;
template List <char *>;
template List <class Pluginuser *>;
template List <class Banneduser *>;
template List <class ProfileIndex *>;
template List <class CustomCommand *>;
template List <struct MemInfo *>;
template List <struct GameInfo *>;
template List <struct BotInfo *>;
template List <struct QueueItem *>;
template List <class PacketBuffer *>;