#ifndef _CONTROLS_H_INCLUDED
#define _CONTROLS_H_INCLUDED

//Original design by Relisoft for the inheritance and dialog application
//Compilation of controls and methods by Raihan
//Special thanks to Zonker for extra research, 
//DarkMinion for additions, 
//and www.Relisoft.com for teaching Win32 GUI methods to the public in an easy manner

//Controls.h Index - #1 Headers #2 Control classes #3 Extra classes
//Controls.cpp Index - #1 Controller functions #2 Extra classes functions

//#1
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define WIN32_LEAN_AND_MEAN		//Less header details

#include <windows.h>
#include <commctrl.h>
#include <richedit.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <winsock2.h>
#include <time.h>

#define BLACK 0x00000000
#define BLUE 0x00FF0000
#define RED 0x000000FF
#define GREEN 0x0000FF00
#define WHITE 0x00FFFFFF
#define YELLOW 0x0000FFFF
#define LIGHTBLUE 0x00FFFF00
#define GRAY 0x00757575
#define DARKGREEN 0x00217721
#define TEAL 0x00009999
#define ORANGE 0x00FF6600
#define LIGHTORANGE 0x00FF9900
#define MAGENTA 0x00CC0066
#define PERIWINKLE 0x00669999
#define DARKBEIGE 0x00999966

//_#1
//Exception Handler
int NewHandler (size_t size);

//MessageBox Variants
//LPCSTR means const char *   or a constant string
inline int MsgBox(LPCSTR Message, LPCSTR Title);
//DoEvents
void DoEvents();
//_#3

//#2
class SimpleControl
{
public:
    SimpleControl (HWND hwndParent, int id, BOOL initialState=TRUE)
        : _hWnd (GetDlgItem (hwndParent, id))
    {
        if (initialState == FALSE)
			Disable();

		/*RECT sizes;
		if (GetWindowRect(_hWnd, &sizes)) {
			X = sizes.left;
			Y = sizes.top;
			Width = sizes.right - X;
			Height = sizes.bottom - Y;
		}*/
   }
   void Hide ()
   {
      ::ShowWindow(_hWnd , SW_HIDE);
   }
   void Show ()
   {
      ::ShowWindow(_hWnd , SW_SHOW);
   }
   BOOL IsVisible()
   {
      return(::IsWindowVisible(_hWnd ));
   }
   void SetFocus ()
   {
       ::SetFocus (_hWnd);
   }
   void Enable()
   {
       ::EnableWindow(_hWnd , TRUE);
   }
   void Disable()
   {
       ::EnableWindow(_hWnd , FALSE);
   }
	HWND Hwnd () const { return _hWnd; }
	
	BOOL Resize(int x, int y, int width, int height, BOOL Redraw)
	{
		BOOL Result;
		Result = (::MoveWindow(_hWnd, x, y, width, height, Redraw));
		if (Result)
		{
			X = x;
			Y = y;
			Height = height;
			Width = width;
		}
		return Result;
	}

	BOOL Resize(BOOL Redraw)
	{
		return (::MoveWindow(_hWnd, X, Y, Width, Height, Redraw));
	}

	int X;
	int Y;
	int Height;
	int Width;

protected:
    HWND _hWnd;
};

class Button : public SimpleControl
{
public:
   Button(HWND hwndParent, int id, BOOL initialState=TRUE)
       : SimpleControl(hwndParent, id, initialState)
   { return; }
   void SetName( char const * newName )
   {
      SendMessage(_hWnd, WM_SETTEXT, 0, (LPARAM)newName );
   }
   unsigned long GetName(char *buf, int len)
   {
	   return SendMessage(_hWnd, WM_GETTEXT, len, (LPARAM) buf);
   }
};

class Slider : public SimpleControl
{
public:
   Slider(HWND hwndParent, int id, BOOL initialState=TRUE)
       : SimpleControl(hwndParent, id, initialState)
   { }

};



class CheckBox : public Button
{
public:
   CheckBox (HWND hwndParent, int id, BOOL initialState=TRUE)
       : Button(hwndParent, id, initialState)
   { return; }
   BOOL IsChecked()
   {
      return( SendMessage(_hWnd, BM_GETCHECK, 0, 0) == BST_CHECKED );
   }
   void Check()
   {
      SendMessage( _hWnd, BM_SETCHECK, (WPARAM) BST_CHECKED, 0);
   }
   void UnCheck()
   {
      SendMessage( _hWnd, BM_SETCHECK, (WPARAM) BST_UNCHECKED, 0);
   }
};

class RadioButton: public Button
{
public:
   RadioButton (HWND hwndParent, int id, BOOL initialState=TRUE)
       : Button(hwndParent, id, initialState)
   {}
   BOOL IsSelected()
   {
      return( SendMessage( _hWnd, BM_GETCHECK, 0, 0) == BST_CHECKED );
   }
   void Select()
   {
      SendMessage( _hWnd, BM_SETCHECK, (WPARAM) BST_CHECKED, 0);
   }
};

class Edit: public SimpleControl
{
public:
   Edit (HWND hwndParent, int id, BOOL initialState=TRUE)
        :	SimpleControl (hwndParent, id, initialState)
   {}

   void SetString (char* buf)
   {
       SendMessage (_hWnd, WM_SETTEXT, 0, (LPARAM) buf);
   }

   // code is the HIWORD (wParam)
   static BOOL IsChanged (int code)
   {
       return code == EN_CHANGE;
   }

   int GetLength ()
   {
       return (int)(SendMessage (_hWnd, WM_GETTEXTLENGTH, 0, 0));
   }

   char* GetString (char *buf, int len)
   {
       SendMessage (_hWnd, WM_GETTEXT, (WPARAM) len, (LPARAM) buf);
	   return buf;
   }
   
   void Select ()
   {
       SendMessage (_hWnd, EM_SETSEL, 0, -1);
   }

   void ClearSelection ()
   {
       SendMessage (_hWnd, EM_SETSEL, -1, 0);
   }
   void SetEditBoxText(char *text)
	{
		SetWindowText(_hWnd, text);
	}

	void GetEditBoxText(char *text)
	{
		GetWindowText(_hWnd, text, 256);
	}

	void AppendEditBoxText(char *text)
	{
		char buffer[256] = "";
		GetWindowText(_hWnd, buffer, sizeof(buffer));
		sprintf(buffer, "%s%s", buffer, text);
		SetWindowText(_hWnd, buffer);
	}
	void Clear()
	{
		SetWindowText(_hWnd, "");
	}

	void SetTextLimit(unsigned long max)
	{
		SendMessage (_hWnd, EM_LIMITTEXT, max, 0);
	} 
	void SetPasswordChar(char passchar)
	{
		SendMessage (_hWnd, EM_SETPASSWORDCHAR, (WPARAM) passchar, 0);
	}
	void SetReadOnly (bool set)
	{
		SendMessage (_hWnd, EM_SETREADONLY, (WPARAM) set, 0);
	}
	void __cdecl AddText( char *Fmt, ...)
	{
		char txt[2048] = "";
		va_list argptr;
		va_start(argptr, Fmt);
		vsprintf(txt, Fmt, argptr);
		va_end(argptr);

		SendMessage(_hWnd, EM_SETSEL, -1, -1);
		SendMessage(_hWnd, EM_REPLACESEL, FALSE, (LPARAM)txt);
		SendMessage(_hWnd, EM_SETSEL, -1, -1);
	}
};

class Combo : public Edit
{
public:
   Combo(HWND hwndParent, int id, BOOL initialState=TRUE)
       : Edit(hwndParent, id, initialState)
   { }

};

class RichEdit: public Edit
{
	public:
	
	
	RichEdit (HWND hwndParent, int id, BOOL initialState=TRUE)
        :	Edit (hwndParent, id, initialState)
   {
	//	SendMessage(_hWnd, EM_SETBKGNDCOLOR, 0, 0);
		strcpy(Font,"Verdana");
	}
	
	void __cdecl AppendText(COLORREF Color, char *Fmt, ...)
	{
		char txt[2048] = "";
		va_list argptr;
		va_start(argptr, Fmt);
		vsprintf(txt, Fmt, argptr);
		va_end(argptr);

		//CHARRANGE crOldSelection;
		//POINT pt;
		//SendMessage(_hWnd, EM_EXGETSEL, 0, (LPARAM)&crOldSelection);
		//SendMessage(_hWnd, EM_GETSCROLLPOS, 0, &pt);
		CHARFORMAT cf;
		SendMessage(_hWnd, EM_SETSEL, -1, -1);
		CharFormat(Color, cf);
		SendMessage(_hWnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf);
		SendMessage(_hWnd, EM_REPLACESEL, FALSE, (LPARAM)txt);
		SendMessage(_hWnd, EM_SETSEL, -1, -1);
		//SendMessage(_hWnd, EM_EXSETSEL, 0, (LPARAM)&crOldSelection);
		//SendMessage(_hWnd, EM_SETSCROLLPOS, 0, &pt);
	}

	void SetBackColor(COLORREF Color)
	{
		SendMessage(_hWnd, EM_SETBKGNDCOLOR, 0, Color);
	}
	void Clear()
	{
		SetWindowText(_hWnd, "");
	}
	
	void SetFont(char *nFont)
	{
		strcpy(Font, nFont);
	}
private:

	void CharFormat(COLORREF color, CHARFORMAT &cf)
	{
		cf.cbSize = sizeof(CHARFORMAT);
		cf.dwMask = CFM_COLOR | CFM_FACE | CFM_SIZE;
		cf.dwEffects = CFE_PROTECTED;
		cf.yHeight = 170;
		cf.yOffset = 0;
		cf.crTextColor = color;
		cf.bCharSet = DEFAULT_CHARSET;
		cf.bPitchAndFamily = DEFAULT_PITCH;
		strcpy(cf.szFaceName, Font);
	}
	char Font[30];
};

class ListView: public SimpleControl
{
	public:
	ListView (HWND hwndParent, int id, BOOL initialState=TRUE, INT BITMAP=0)
		:SimpleControl (hwndParent, id, initialState)
    {
		//
	}

	void InitImageList(HINSTANCE DlgInst, int RESOURCE_ID)
	{
		HIMAGELIST hList = ImageList_Create(28, 14, ILC_COLOR16, 8, 1);
		HBITMAP Icons = LoadBitmap(DlgInst, MAKEINTRESOURCE(RESOURCE_ID));
		ImageList_Add(hList, Icons, NULL);
		SendMessage(_hWnd, LVM_SETIMAGELIST, LVSIL_SMALL, (LPARAM)hList);
		SendMessage(_hWnd, LVM_SETBKCOLOR, 0, (LPARAM)BLACK);
		SendMessage(_hWnd, LVM_SETTEXTBKCOLOR, 0, (LPARAM)BLACK);
		SendMessage(_hWnd, LVM_SETTEXTCOLOR, 0, (LPARAM)WHITE);

		LVCOLUMN lvc;

		lvc.mask     = LVCF_FMT | LVCF_SUBITEM  | LVCF_WIDTH;
		lvc.fmt      = LVCFMT_LEFT;
		lvc.iSubItem = 0;         
		lvc.cx       = 105;
		ListView_InsertColumn(_hWnd, 0, &lvc);

		lvc.mask     = LVCF_FMT | LVCF_SUBITEM  | LVCF_WIDTH;
		lvc.fmt      = LVCFMT_LEFT;
		lvc.iSubItem = 0;         
		lvc.cx       = 30;
		ListView_InsertColumn(_hWnd, 1, &lvc);

		ListView_SetExtendedListViewStyle(_hWnd, LVS_EX_FULLROWSELECT | LVS_EX_SUBITEMIMAGES);
	}

	void GetItemText(int item, char *buf)
	{
		char buffer[32] = "";
		LVITEM lvi;
		lvi.pszText = buffer;
		lvi.iSubItem = 0;
		lvi.cchTextMax = sizeof(buffer);
		SendMessage(_hWnd, LVM_GETITEMTEXT, item, (LPARAM)&lvi);
		strcpy(buf, buffer);
	}

	int GetSelectedItem()
	{
		int itemcount = SendMessage(_hWnd, LVM_GETITEMCOUNT, 0, 0);
		for(int i = 0; i < itemcount; i++){
			DWORD state = SendMessage(_hWnd, LVM_GETITEMSTATE, i, LVIS_SELECTED);
			if(state == LVIS_SELECTED)
				return i;
		}
		return -1;
	}

	void InsertItem(char *item, int icon, int lagicon, char *currentchannel, HWND updatelbl)
	{
		LVITEM *lvi = new LVITEM;
		lvi->mask =  LVIF_IMAGE | LVIF_TEXT;
		lvi->iItem = (int)SendMessage(_hWnd, LVM_GETITEMCOUNT, 0, 0);
		lvi->iSubItem = 0;
		lvi->pszText = item;
		lvi->cchTextMax = strlen(item);
		lvi->iImage = icon;
		int index = SendMessage(_hWnd, LVM_INSERTITEM, 0, (LPARAM)lvi);

		lvi->mask = LVIF_IMAGE;
		lvi->iSubItem = 1;
		lvi->iImage = lagicon;
		lvi->iItem = index;
		SendMessage(_hWnd, LVM_SETITEM, 0, (LPARAM) lvi);

		SendMessage(_hWnd, LVM_ARRANGE, LVA_ALIGNLEFT, 0);
		int itemcount = (int)SendMessage(_hWnd, LVM_GETITEMCOUNT, 0, 0);
		char txt[128] = "";
		sprintf(txt, "%s (%i)", currentchannel, itemcount);
		SetWindowText(updatelbl, txt);
	}

	int GetItemIndex(char *item)
	{
		int ItemCount = SendMessage(_hWnd, LVM_GETITEMCOUNT, 0, 0);
		for(int i = 0; i < ItemCount; i++){
			char buffer[32] = "";
			ListView_GetItemText(_hWnd, i, 0, buffer, sizeof(buffer));
			if(!stricmp(buffer, item))
				return i;
		}
		return -1;
	}

	void RemoveItem(char *item, char *currentchannel, HWND updatelbl)
	{
		int ItemCount = SendMessage(_hWnd, LVM_GETITEMCOUNT, 0, 0);
		for(int i = 0; i < ItemCount; i++){
			char buffer[32] = "";
			ListView_GetItemText(_hWnd, i, 0, buffer, sizeof(buffer));
			if(!stricmp(buffer, item))
				SendMessage(_hWnd, LVM_DELETEITEM, i, 0);
		}
		SendMessage(_hWnd, LVM_ARRANGE, LVA_ALIGNLEFT, 0);
		int itemcount = (int)SendMessage(_hWnd, LVM_GETITEMCOUNT, 0, 0);
		char txt[128] = "";
		sprintf(txt, "%s (%i)", currentchannel, itemcount);
		SetWindowText(updatelbl, txt);
	}

	void ModifyItem(char *item, int icon)
	{
		int itemcount = SendMessage(_hWnd, LVM_GETITEMCOUNT, 0, 0);
		int pos = GetItemIndex(item);
		LVITEM lvi;
		lvi.mask =  LVIF_IMAGE | LVIF_TEXT;
		lvi.iItem = pos;
		lvi.iSubItem = 0;
		lvi.pszText = item;
		lvi.iImage = icon;
		SendMessage(_hWnd, LVM_DELETEITEM, pos, 0);
		SendMessage(_hWnd, LVM_INSERTITEM, 0, (LPARAM)&lvi);
	}

	void Clear()
	{
		SendMessage(_hWnd, LVM_DELETEALLITEMS, 0, 0);
	}

};

//typedef int (*Winsock_Receive)(char *data, int *len);
//typedef int (*idleproc)();

class Winsock : public Edit
{
public:
	//idleproc idlefunction = NULL;

	Winsock (HWND hwndParent, int id, BOOL initialState=TRUE)
		:Edit (hwndParent, id, initialState)
    {
		//InitImageList(hwndParent);
	}

	bool Connect(char *ServerName, unsigned short Port)
	{
		if(connected == true) Disconnect();
		s = INVALID_SOCKET;
		WSADATA wsadata;
		if(WSAStartup(0x101,&wsadata)) 
		return false;
		if(wsadata.wVersion != 0x101){
			WSACleanup();
			return false;
		}
		struct hostent *hp;
		memset(&sname, '\0', sizeof(sname));
		sname.sin_family = AF_INET;
		sname.sin_port = htons(Port);
		char *p = ServerName;
		while(*p && (isdigit(*p) || (*p == '.')))
			p++;
		if(*p){
			hp = gethostbyname(ServerName);
			if(hp == 0)
				return false;
			memcpy(&sname.sin_addr, hp->h_addr, hp->h_length);
		}
		else
			sname.sin_addr.s_addr = inet_addr(ServerName);
		s = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);

		if(s == INVALID_SOCKET)
			return false;

		if(connect(s, (struct sockaddr *)&sname, sizeof(sname)))
			return false;
		recvevent = CreateEvent(0, 0, 0, 0);
		WSAResetEvent(recvevent);
		WSAEventSelect(s, recvevent, 0);
		WSAEventSelect(s, recvevent, FD_READ | FD_CLOSE);
		SetString("Connected!");
		connected = true;
		return true;
	}

	void Disconnect()
	{
		shutdown(s, SD_BOTH);
		closesocket(s);
		s = INVALID_SOCKET;
		WSACleanup();
		SetString("Disconnected.");
		connected = false;
	}

    int	Send(char *lpszFmt, ...)
	{
		char szOutStr[256];
		va_list argptr;

		va_start(argptr, lpszFmt);
		vsprintf(szOutStr, lpszFmt, argptr);
		va_end(argptr);

		if (send(s, szOutStr, strlen(szOutStr), 0) < 0)
		return 0;
		
		return 1;
	}

	HANDLE GetEvent() const
	{
		return recvevent;
	}

	bool Connected() const
	{
		return connected;
	}

	SOCKET GetSocket() const
	{
		return s;
	}

private:
	SOCKET s;
	HANDLE recvevent;
	struct sockaddr_in sname;
	bool connected;
};

class ListBox: public SimpleControl
{
	public:
	ListBox (HWND hwndParent, int id, BOOL initialState=TRUE)
		:SimpleControl (hwndParent, id, initialState)
    {
		
	}

	void AddItem(char *text)
	{;
		SendMessage(_hWnd, LB_ADDSTRING, 0, (LPARAM)text);
	}

	void RemoveItem(int item)
	{
		SendMessage(_hWnd, LB_DELETESTRING, item, 0);
	}

	void GetItemText(int item, char *text)
	{
		SendMessage(_hWnd, LB_GETTEXT, item, (LPARAM)text);
	}

	void Clear()
	{
		SendMessage(_hWnd, LB_RESETCONTENT, 0, 0);
	}

	int Count()
	{
		return SendMessage(_hWnd, LB_GETCOUNT, 0, 0);
	}

};

class Controller
{
public:
    Controller(HWND hwnd, HINSTANCE hinst);
    ~Controller () {}
    void Command (HWND hwnd, int controlID, int command);
	/*This is where you define the control names
	Button		_button3;
	Button      _button2;
	Button      _button1;
	Button      _clear;
	RadioButton _bottomRadio;
	RadioButton _middleRadio;
	RadioButton _topRadio;
	CheckBox    _rightCheck;
	CheckBox    _leftCheck;
	Edit        _status;
	*/
	RichEdit    _richedit;
	Button      _button2;
	Edit        _edit;
	Button      _button;
	ListBox     _listbox;
	Button      _button3;
	Button      _button4;
	Button      _button5;
	ListView    _listview;
	Edit		_label;
	Winsock		_winsock;
	Button	    _button6;
	Edit		_username;
	Edit		_password;
	Edit		_cdkey;
	Edit		_homechannel;
	Edit		_server;
	Slider		_slider;
	Combo		_combo;
};

//Make this global in your main.cpp or whatever, Controller* Control=0;
		
//In your MainDialogProc or whatever, put this in the message for WM_INITDIALOG: Control = new Controller (hDlg);
//Here is an example of how to initialize an imagelist, assuming you have one made:  Control->Chanlist.InitImageList(DlgInst);
//_#2

//#3
class WinException
{
public:
    WinException (char* msg)
    : _err (GetLastError()), _msg(msg)
    {}
    DWORD GetError() const { return _err; }
    char* GetMessage () const { return _msg; }
private:
    DWORD _err;
    char* _msg;
};

#endif // _CONTROLS_H_INCLUDED
