#include "controls.h"
#include "rc.h"
#include "config.h"
#include "encryption.h"
#include "list.h"
#include "statstring.h"
#include "hashing.h"
#include "packetbuffer.h"

WNDPROC EditOldWndProc = NULL;
Controller *globalcontrol = NULL;
LList<char*> Antiflood;

void TimeStamp(char *buf)
{
	SYSTEMTIME st;
	GetLocalTime(&st);
	sprintf(buf, "[%02i:%02i:%02i]", st.wHour, st.wMinute, st.wSecond);
}

void HexDump(int len, char *buf) {
  char tmp[ 128];
  for (int offset = 0; offset < len; offset += 16) {
    sprintf( tmp, "%08X   ", offset); globalcontrol->_richedit.AppendText(WHITE, "%s", tmp);
    unsigned char *p = (unsigned char *)(buf + offset);
    int stop = ((offset + 16) > len) ? len - offset : 16;

    int i = 0;
    for (; i < stop; i++) {
      if (i == 8) globalcontrol->_richedit.AppendText(WHITE, "- ");
      sprintf( tmp, "%02X ", p[i]);
      globalcontrol->_richedit.AppendText(WHITE, "%s", tmp);
    }

    while (i < 16) {
      if (i++ == 8) globalcontrol->_richedit.AppendText(WHITE, "- ");
      globalcontrol->_richedit.AppendText(WHITE, "   ");
    }

    globalcontrol->_richedit.AppendText(WHITE, "  ");

    for (i = 0; i < stop; i++)
      tmp[i] = isgraph(p[i]) ? p[i] : p[i] == ' ' ? ' ' : '.';
    tmp[i] = 0;
    globalcontrol->_richedit.AppendText(WHITE, "%s\r\n", tmp);
  }
}

LRESULT CALLBACK EditSubclass(HWND Edit, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	char txt[256] = "";
	switch(uMsg){
	case WM_KEYUP:
		if(wParam == VK_RETURN){
			globalcontrol->_edit.GetEditBoxText(txt);
			strtok(txt, "\r\n\x0a");
			if(strlen(txt)==0)
			{
				char timestamp[20];
				TimeStamp(timestamp);
				globalcontrol->_richedit.AppendText(YELLOW, "%s ", timestamp);
				globalcontrol->_richedit.AppendText(RED, "Cannot send a message.\r\n");
			}
			PacketBuffer packetbuf;
			char *p = new char[strlen(txt) + 1];
			strcpy(p, txt);
			Antiflood.Add(p);
			globalcontrol->_edit.Clear();
			return 0;
		}
	case WM_KEYDOWN:
		if(wParam == VK_RETURN)
			return 0;
	case WM_CHAR:
		if(wParam == VK_RETURN)
			return 0;
	}
	return CallWindowProc(EditOldWndProc, Edit, uMsg, wParam, lParam);
}

int Send_0x51(char *mpqname, char *hashcmd, unsigned long encryptvalue, char *cdkey, SOCKET s, PacketBuffer &packetbuf)
{
	unsigned long Version, Checksum;
	char exeinfo[256] = "";
	char accountHash[500] = "";
	char fullname[50] = "";
	unsigned long lngProdID, lngValue1, lngValue2, gtc = 2140859764;
	unsigned long dblProdID, dblValue1, dblValue2;

	if(!CheckRevision("SC\\starcraft.exe", "SC\\storm.dll", "SC\\battle.snp", hashcmd, &Version, &Checksum, exeinfo, mpqname))
	{
		globalcontrol->_winsock.Disconnect();
		return 1;
	}
	if(!DecodeCDKey(cdkey, &dblProdID, &dblValue1, &dblValue2))
	{
		globalcontrol->_winsock.Disconnect();
		return 2;
	}
	lngProdID = dblProdID;
	lngValue1 = dblValue1;
	lngValue2 = dblValue2;
	

    if(!HashCDKey2(accountHash, encryptvalue + 1234, lngProdID + 1234, lngValue1, lngValue2, gtc, 0, 0))
	{
		globalcontrol->_winsock.Disconnect();
		return 3;
	}
	sprintf(fullname, "RaiBot%d", GetTickCount());
	packetbuf.clear();
	packetbuf.insert(gtc);
	packetbuf.insert(Version);
	packetbuf.insert(Checksum);
	packetbuf.insert((int)0x01);
	packetbuf.insert((int)0x00);
	packetbuf.insert(strlen(cdkey));
	packetbuf.insert(dblProdID);
	packetbuf.insert(dblValue1);
	packetbuf.insert((int)0x00);
	packetbuf.insert(accountHash, strlen(accountHash));
	packetbuf.insert(exeinfo);
	packetbuf.insert("RaiBot");
	packetbuf.sendpacket(s, 0x51);
	return 0;
}

int Send_0x2d_0x14(SOCKET s, PacketBuffer &packetbuf)
{
	packetbuf.clear();
	packetbuf.insert("tenb", 4);
	packetbuf.sendpacket(s, 0x14);
	packetbuf.clear();
	packetbuf.sendpacket(s, 0x2d);
	return 0;
}

int Send_0x3a(char *username, char *password, unsigned long encryptvalue, SOCKET s, PacketBuffer &packetbuf)
{
	unsigned long lngSeed, lngKey, lngValue1, lngValue2, lngValue3;
	unsigned long dblSeed, dblKey;
    dblSeed = encryptvalue;
    dblKey = GetTickCount();
    lngSeed = dblSeed;
    lngKey = dblKey;
    if(HashPass(password, strlen(password), &lngKey, &lngSeed, &lngValue1, &lngValue2, &lngValue3, 0) == false){
		return 1;
	}
    packetbuf.insert(dblKey);
	packetbuf.insert(dblSeed);
	packetbuf.insert(lngKey);
	packetbuf.insert(lngSeed);
	packetbuf.insert(lngValue1);
	packetbuf.insert(lngValue2);
	packetbuf.insert(lngValue3);
	packetbuf.insert(username);
	packetbuf.sendpacket(s, 0x3a);
	return 0;
}

//#1
Controller::Controller (HWND hwnd, HINSTANCE hinst) : 
		_edit(hwnd, IDC_EDIT),
	    _button(hwnd, IDC_BUTTON),
		_richedit(hwnd, IDC_RICHEDIT),
		_button2(hwnd, IDC_BUTTON2),
		_listbox(hwnd, IDC_LISTBOX),
		_button3(hwnd, IDC_BUTTON3),
		_button4(hwnd, IDC_BUTTON4),
		_button5(hwnd, IDC_BUTTON5),
		_listview(hwnd, IDC_LISTVIEW),
		_label(hwnd, IDC_LABEL),
		_winsock(hwnd, IDC_WINSOCK),
		_combo(hwnd, IDC_COMBO),
        _button6(hwnd, IDC_BUTTON6),
		_slider(hwnd, IDC_SLIDER),
		_username(hwnd, IDC_USERNAME),
		_password(hwnd, IDC_PASSWORD),
		_cdkey(hwnd, IDC_CDKEY),
		_homechannel(hwnd, IDC_HOMECHANNEL),
		_server(hwnd, IDC_SERVER)
{
    // Attach icon to main dialog
    HICON hIcon = LoadIcon (hinst, MAKEINTRESOURCE (DLG_ICON));
    SendMessage (hwnd, WM_SETICON, WPARAM (TRUE), LPARAM (hIcon));
    hIcon = LoadIcon (hinst, MAKEINTRESOURCE (DLG_ICON));
    SendMessage (hwnd, WM_SETICON, WPARAM (FALSE), LPARAM (hIcon));	
    // Other initializations...
	_listview.InitImageList(hinst, IDB_BITMAP);
    _edit.SetFocus();
	_richedit.SetBackColor(BLACK);
	_richedit.SetReadOnly(TRUE);
	_button.SetName("Add to RichEdit Len 0");
	_button2.SetName("Clear Text     Length 0");
	_button3.SetName("Load");
	_button4.SetName("Save");
	_button5.SetName("Leave");
	_button6.SetName("&Connect");
	_label.SetString("Channel");
	_winsock.SetString("Disconnected.");
	LoadConfig(_username.Hwnd(), _password.Hwnd(), _cdkey.Hwnd(), _server.Hwnd(), _homechannel.Hwnd());
	EditOldWndProc = (WNDPROC)SetWindowLong(_edit.Hwnd(), GWL_WNDPROC, (LONG)EditSubclass);
	globalcontrol = this;
}

void Controller::Command (HWND hwnd, int controlID, int command)
{
    char statusMessage[64]="";
	//Use the above string to store some messages for later

    switch (controlID)
    {
        case IDC_EDIT:
            if (_edit.IsChanged(command))
            {
				sprintf(statusMessage, "Add to RichEdit Len %i", _edit.GetLength());
                _button.SetName(statusMessage);
            }
            break;
		case IDC_BUTTON:
			if(_edit.GetLength() == 0)
			{
				MsgBox("First type something in the box!", "Error");
			}
			else
			{
			_edit.SetFocus();
			}
            break;
		case IDC_RICHEDIT:
            break;
		case IDC_BUTTON2:
			_richedit.Clear();
            _button2.SetName("Clear Text     Length 0");
            break;
		case IDC_LISTBOX:
			break;
		case IDC_BUTTON3:
			//LOAD
			LoadConfig(_username.Hwnd(), _password.Hwnd(), _cdkey.Hwnd(), _server.Hwnd(), _homechannel.Hwnd());
			break;
		case IDC_BUTTON4:
			//SAVE 2875752504297 sc-key
			char usernamestore[32];
			char passwordstore[200];
			char cdkeystore[16];
			char homechannelstore[30];
			char servernamestore[20];
			_username.GetEditBoxText(usernamestore);
			_password.GetEditBoxText(passwordstore);
			_cdkey.GetEditBoxText(cdkeystore);
			_homechannel.GetEditBoxText(homechannelstore);
			_server.GetEditBoxText(servernamestore);
			WriteConfig(usernamestore, passwordstore, cdkeystore, servernamestore, homechannelstore);
			break;
		case IDC_BUTTON5:
			//DISCONNECT
			_winsock.Disconnect();
			break;
		case IDC_BUTTON6:
			char servername[20] = "";
			char timestamp[20] = "";
			TimeStamp(timestamp);
			unsigned short port = 6112;
			char username[32] = "";
			char password[200] = "";
			char cdkey[16] = "";
			char homechannel[30] = "";
			_username.GetEditBoxText(username);
			_password.GetEditBoxText(password);
			_cdkey.GetEditBoxText(cdkey);
			_homechannel.GetEditBoxText(homechannel);
			_server.GetEditBoxText(servername);
			_richedit.AppendText(BLUE, "%s ", timestamp);
			_richedit.AppendText(GREEN, "Connecting to [%s]...\r\n", servername);
			_winsock.Disconnect();
			if(_winsock.Connect(servername, port))//IF CONNECTED
			{
				char gametype[5] = "PXES";
				char tmp[32] = "";
				char buffer[20000] = "";
				char packetdata[5000] = "";
				char packetid = 0;
				unsigned short packetlen = 0;
				char chanbuf[128] = "";
				unsigned long ladder;
				unsigned long encryptvalue = 0;
				char mbtitle[128] = "", mbtext[128] = "";
				unsigned long mbstyle = 0;
				unsigned long idletimer = 0, idletime = 0;
				bool lastreply = false;
				char mpqname[128] = "", hashcmd[256] = "", exeinfo[256] = "";
				char channels[512];
				char currentchannel[30] = "";
				unsigned long channelslen = 0;
				char uname[32] = "", name[32] = "", txt[256] = "", stats[512] = "", cdkeyname[512] = "", prog[8] = "";
				unsigned long ping = 0, flags = 0, pingvalue = 0;
				unsigned long lasttick = 0, floodtimer = 0;
				unsigned long rpacketpos = 0, rpacketlen = 0;
				lasttick = GetTickCount();
	
				PacketBuffer packetbuf;
				Antiflood.Flush();
				send(_winsock.GetSocket(), "\x1", 1, 0);
				packetbuf.clear();
				packetbuf.insert((int)0);
				packetbuf.insert("68XI", 4);
				packetbuf.insert(gametype, 4);
				packetbuf.insert((int)0xc5);
				packetbuf.insert((int)0);
				packetbuf.insert((int)0);
				packetbuf.insert((int)480);
				packetbuf.insert((int)1033);
				packetbuf.insert((int)1033);
				packetbuf.insert("USA");
				packetbuf.insert("United States");
				packetbuf.sendpacket(_winsock.GetSocket(), 0x50);
				_richedit.AppendText(BLUE, "%s ", timestamp);
				_richedit.AppendText(GREEN, "Sending location information...\r\n");
			
				while(_winsock.Connected())//WHILE CONNECTED
				{
					DWORD waitresult = WaitForSingleObject(_winsock.GetEvent(), 10);
					if(waitresult == WAIT_TIMEOUT)
					{
						if(GetTickCount() >= floodtimer)
						{
							if(Antiflood.Count() > 0){
								packetbuf.insert(Antiflood.Get(0));
								packetbuf.sendpacket(_winsock.GetSocket(), 0x0e);
								char *tmpbuf = Antiflood.Get(0);
								if(tmpbuf[0] != '/')
								{
									_richedit.AppendText(WHITE, "%s ", timestamp);
									_richedit.AppendText(LIGHTBLUE, "<%s> %s\r\n", uname, Antiflood.Get(0));
								}
								floodtimer = GetTickCount() + (strlen(Antiflood.Get(0)) * 10 + 1500);
								Antiflood.Remove(0);
								lastreply = false;
							}
						}
					}
					if(waitresult == WAIT_OBJECT_0)//IF RESULT
					{
						int buflen = 0;
						int recvlen = recv(_winsock.GetSocket(), buffer + buflen, sizeof(buffer) - buflen, 0);
						if(!recvlen || recvlen == SOCKET_ERROR)
						{
							//SOCKET ERROR
							_richedit.AppendText(YELLOW, "%s ", timestamp);
							_richedit.AppendText(RED, "Socket error occurred.\r\n", servername);
							_winsock.Disconnect();
							return;
						}
						buflen += recvlen;
						while((int)buflen >= 4 && globalcontrol->_winsock.Connected() && (unsigned char)buffer[0] == 0xff)//WHILE BUFLEN
						{
							packetid = buffer[1];
							packetlen = *(unsigned short *)(buffer + 2);
							
							switch(packetid)
							{
							case 0x00:
								//Keep alive
								packetbuf.sendpacket(_winsock.GetSocket(), 0x0);
								break;
							case 0x50:
								strcpy(mpqname, buffer + 24);
								strcpy(hashcmd, buffer + 37);
								encryptvalue = *(unsigned long *)(buffer + 8);
								switch(Send_0x51(mpqname, hashcmd, encryptvalue, cdkey, _winsock.GetSocket(), packetbuf))
								{
								case 0: _richedit.AppendText(WHITE, "%s Verifying Version and CD-Key\r\n", timestamp); break;
								case 1: _richedit.AppendText(WHITE, "%s Could not check versions\r\n", timestamp); break;
								case 2: _richedit.AppendText(WHITE, "%s Could not decode CD-Key\r\n", timestamp); break;
								case 3: _richedit.AppendText(WHITE, "%s Could not hash CD-Key\r\n", timestamp); break;
								} 
								break;
							case 0x51:
								if(buffer[4] == 0x00)
								{
									_richedit.AppendText(WHITE, "%s Version and CD-Key verified\r\n", timestamp);
									Send_0x2d_0x14(_winsock.GetSocket(), packetbuf);
									Send_0x3a(username, password, encryptvalue, _winsock.GetSocket(), packetbuf);
								}
								else
								{
									_richedit.AppendText(WHITE, "%s Version and CD-Key not verified\r\n", timestamp);
									
								}
								break;
							case 0x06:
								//Mpq name & hash command
								//strcpy(mpqname, buffer + 12);
								//strcpy(hashcmd, buffer + 25);
								//if(!CheckRevision("jstr\\starcraftj.exe", "jstr\\storm.dll", "jstr\\battle.snp", hashcmd, &version, &checksum, exeinfo, mpqname)){
								//	_richedit.AppendText(WHITE, "%s ", timestamp);
								//	_richedit.AppendText(RED, "CheckRevision() failed!\r\n");
								//	_winsock.Disconnect();
								//	return;
								//}
								//_richedit.AppendText(WHITE, "%s ", timestamp);
								//_richedit.AppendText(WHITE, "Checking versions...\r\n");
								//packetbuf.insert("68XIRTSJ", 8);
								//packetbuf.insert((int)0xa9);
								//packetbuf.insert(version);
								//packetbuf.insert(checksum);
								//packetbuf.insert(exeinfo);
								//packetbuf.sendpacket(_winsock.GetSocket(), 0x07);
								break;
							case 0x07:
								//Version check result
								//if(buffer[4] != 0x02){
								//	_richedit.AppendText(WHITE, "%s ", timestamp);
								//	_richedit.AppendText(RED, "Version check failed!\r\n");
								//	Disconnect();
								//	return;
								//}
								//_richedit.AppendText(WHITE, "%s ", timestamp);
								//_richedit.AppendText(GREEN, "Passed version check!\r\n");
								//packetbuf.insert("tenb", 4);
								//packetbuf.sendpacket(_winsock.GetSocket(), 0x14);
								//packetbuf.sendpacket(_winsock.GetSocket(), 0x2d);
								//packetbuf.insert((int)0x1b);
								//packetbuf.insert((int)0);
								//packetbuf.insert("bnserver.ini");
								//packetbuf.sendpacket(_winsock.GetSocket(), 0x33);
								//_richedit.AppendText(WHITE, "%s ", timestamp);
								//_richedit.AppendText(WHITE, "Checking CDKey...\r\n");
								break;
							case 0x19:
								//Message box
								mbstyle = *(unsigned long *)(buffer + 4);
								strcpy(mbtext, buffer + 8);
								strcpy(mbtitle, buffer + (9 + strlen(mbtext)));
								//MessageBox(Dlg, mbtext, mbtitle, (UINT)mbstyle);
								break;
							case 0x1d:
								//Random encrypt value
								//encryptvalue = *(unsigned long *)(buffer + 8);
								//packetbuf.insert((int)9);
								//packetbuf.insert(buffer + 8, 4);
								//packetbuf.insert(buffer + 4, 4);
								//packetbuf.sendpacketto(udp, server, 6112);
								break;
							case 0x25:
								//Ping
								pingvalue = *(unsigned long *)(buffer + 4);
								packetbuf.insert((int)pingvalue);
								packetbuf.sendpacket(_winsock.GetSocket(), 0x25);
								break;
							case 0x26:
								//Profile
								//profnum = *(unsigned long *)(buffer + 12);
								//DisplayProfileDialog(buffer);
								break;
							case 0x30:
								//strcpy(cdkeyname, buffer + 8);
								//if(buffer[4] != 0x01)
								//{
								//	if(buffer[4] == 0x02)
								//	{
								//		_richedit.AppendText(WHITE, "%s ", timestamp);
								//		_richedit.AppendText(RED, "CDKey invalid!\r\n");
								//		Disconnect();
								//		return;
								//	}
								//	if(buffer[4] == 0x03)
								//	{
								//		_richedit.AppendText(WHITE, "%s ", timestamp);
								//		_richedit.AppendText(RED, "CDKey invalid for this game!\r\n");
								//		Disconnect();
								//		return;
								//	}
								//	if(buffer[4] == 0x05)
								//	{	
								//		_richedit.AppendText(WHITE, "%s ", timestamp);
								//		_richedit.AppendText(RED, "CDKey in use by: %s!\r\n", cdkeyname);
								//		Disconnect();
								//		return;
								//	}
								//}
								//_richedit.AppendText(WHITE, "%s ", timestamp);
								//_richedit.AppendText(GREEN, "CDKey accepted, logging on...\r\n");
								//passwordhash[0] = GetTickCount();
								//passwordhash[1] = encryptvalue;
								//HashData(password, strlen(password), passwordhash + 2);
								//HashData(passwordhash, 7 * sizeof(DWORD), passwordhash + 2);
								//packetbuf.insert(passwordhash, 7 * sizeof(DWORD));
								//packetbuf.insert(username);
								//packetbuf.sendpacket(_winsock.GetSocket(), 0x29);
								break;
							case 0x3a:
								if(buffer[4] != 0x00){
									_richedit.AppendText(WHITE, "%s ", timestamp);
									_richedit.AppendText(RED, "Login failed! Attempting to create account...\r\n");
									//HashData(password, strlen(password), createhash);
									//packetbuf.insert(createhash, 5 * sizeof(DWORD));
									//packetbuf.insert(username);
									//packetbuf.sendpacket(_winsock.GetSocket(), 0x2a);
									break;
								}
								_richedit.AppendText(WHITE, "%s ", timestamp);
								_richedit.AppendText(GREEN, "Login accepted!\r\n");
								packetbuf.insert(username);
								packetbuf.insert(gametype);
								packetbuf.sendpacket(_winsock.GetSocket(), 0x0a);
								packetbuf.insert(gametype, 4);
								packetbuf.sendpacket(_winsock.GetSocket(), 0x0b);
								packetbuf.insert((int)0);
								packetbuf.insert(homechannel);
								packetbuf.sendpacket(_winsock.GetSocket(), 0x0c);
								break;
							case 0x3d:
								if(buffer[4] != 0x00)
								{
									_richedit.AppendText(WHITE, "%s ", timestamp);
									_richedit.AppendText(RED, "Account create failed!\r\n");
									_winsock.Disconnect();
									return;
								}
								_richedit.AppendText(WHITE, "%s ", timestamp);
								_richedit.AppendText(GREEN, "Account successfully created! Logging on...\r\n");
								Send_0x3a(username, password, encryptvalue, _winsock.GetSocket(), packetbuf);
								break;
							case 0x2f:
								//ladder = *(unsigned long *)(buffer + 4);
								//_richedit.AppendText(WHITE, "%s ", timestamp);
								//if(ladder == 0xffffffff)
								//	_richedit.AppendText(RED, "%s is not on the ladder.\r\n", laddername);
								//else
								//	_richedit.AppendText(YELLOW, "%s is ranked #%d on the ladder.\r\n", laddername, ladder);
								break;
							case 0x0a:
								strcpy(uname, buffer + 4);
								_richedit.AppendText(WHITE, "%s ", timestamp);
								_richedit.AppendText(LIGHTBLUE, "Logged on as %s\r\n", uname);
								idletimer = GetTickCount() + 180000;
								lasttick = GetTickCount();
								idletime = 0;
								break;
							case 0x0b:
								memcpy(channels, buffer + 4, packetlen - 4);
								channelslen = packetlen - 4;
								break;
							case 0x33:
								lastreply = true;
								break;
							case 0x2d:
								break;
							case 0x0f:
								switch(buffer[4])
								{
								case 0x01:
									getvalues(buffer, &ping, &flags, name, txt);
									ParseStatstring(txt, stats);
									_listview.InsertItem(name, GetIconCode(txt, flags), 1, currentchannel, _label.Hwnd());
									strncpy(prog, txt, 4);
									//AddListBoxItem(IDC_PROGLIST, prog);
									_richedit.AppendText(YELLOW, "%s ", timestamp);
									_richedit.AppendText(GREEN, "%s is here with %dms and flags of %x; %s\r\n", name, ping, flags, stats);
									break;
								case 0x02:
									getvalues(buffer, &ping, &flags, name, txt);
									ParseStatstring(txt, stats);
									strncpy(prog, txt, 4);
									//AddListBoxItem(IDC_PROGLIST, prog);
									_listview.InsertItem(name, GetIconCode(txt, flags), 1, currentchannel, _label.Hwnd());
									_richedit.AppendText(YELLOW, "%s ", timestamp);
									_richedit.AppendText(GREEN, "%s joined with %dms and flags of %x; %s\r\n", name, ping, flags, stats);break;
								case 0x03:
									getvalues(buffer, &ping, &flags, name, txt);
									//RemoveListBoxItem(IDC_PROGLIST, GetItemIndex(IDC_CHANLIST, name));
									_listview.RemoveItem(name, currentchannel, _label.Hwnd());
									_richedit.AppendText(YELLOW, "%s ", timestamp);
									_richedit.AppendText(GREEN, "%s leaves.\r\n", name);
									break;
								case 0x04:
									getvalues(buffer, &ping, &flags, name, txt);
									_richedit.AppendText(DARKBEIGE, "%s ", timestamp);
									_richedit.AppendText(WHITE, "[%d:%x] <From: %s> ", ping, flags, name);
									_richedit.AppendText(GRAY, "%s\r\n", txt);
									//strcpy(replyname, name);
									break;
								case 0x05:
									getvalues(buffer, &ping, &flags, name, txt);
									if(txt[0] == '')
									{
										_richedit.AppendText(YELLOW, "%s ", timestamp);
										_richedit.AppendText(DARKGREEN, "<%s> (Encrypted) ", name);
										_richedit.AppendText(TEAL, "%s\r\n", Decrypt(txt + 1));
										break;
									}
									if(txt[0] == '')
									{
										_richedit.AppendText(YELLOW, "%s ", timestamp);
										_richedit.AppendText(DARKGREEN, "<%s> (Hexadecimal) ", name);
										Translate(txt + 1);
										_richedit.AppendText(TEAL, "%s\r\n", txt + 1);
										break;
									}
									_richedit.AppendText(YELLOW, "%s ", timestamp);
									if(flags % 10 > 0 && flags % 10 != 6)
										_richedit.AppendText(WHITE, "<%s> ", name);
									else
										_richedit.AppendText(ORANGE, "<%s> ", name);
										_richedit.AppendText(WHITE, "%s\r\n", txt);
									break;
								case 0x07:
									getvalues(buffer, &ping, &flags, name, txt);
									_listview.Clear();
									//ClearListBox(IDC_PROGLIST);
									strcpy(currentchannel, txt);
									_label.SetString(txt);
									_richedit.AppendText(BLUE, "%s ", timestamp);
									_richedit.AppendText(RED, "Joined %s (flags: 0x%x)\r\n", txt, flags);
									break;
								case 0x09:
									getvalues(buffer, &ping, &flags, name, txt);
									//GetListBoxItemText(IDC_PROGLIST, GetItemIndex(IDC_CHANLIST, name), prog);
									_listview.ModifyItem(name, GetIconCode(prog, flags));
									if(flags & 0x02){
										_richedit.AppendText(RED, "%s ", timestamp);
										if(!stricmp(uname, name))
											_richedit.AppendText(YELLOW, "You are a channel operator.\r\n");
										else
											_richedit.AppendText(YELLOW, "%s is a channel operator.\r\n", name);
									}
									break;
								case 0x0a:
									getvalues(buffer, &ping, &flags, name, txt);
									_richedit.AppendText(WHITE, "%s ", timestamp);
									_richedit.AppendText(WHITE, "[%d:%x] <To: %s> ", ping, flags, name);
									_richedit.AppendText(GRAY, "%s\r\n", txt);
									break;
								case 0x12:
									getvalues(buffer, &ping, &flags, name, txt);
									_richedit.AppendText(RED, "%s ", timestamp);
									_richedit.AppendText(YELLOW, "%s\r\n", txt);
									break;
								case 0x13:
									getvalues(buffer, &ping, &flags, name, txt);
									_richedit.AppendText(YELLOW, "%s ", timestamp);
									_richedit.AppendText(RED, "%s\r\n", txt);
									break;
								case 0x17:
									getvalues(buffer, &ping, &flags, name, txt);
									_richedit.AppendText(WHITE, "%s ", timestamp);
									_richedit.AppendText(YELLOW, "<%s %s>\r\n", name, txt);
									break;			
								}
								break;
								default:
									_richedit.AppendText(YELLOW, "%s ", timestamp);
									_richedit.AppendText(RED, "Unknown Packet ID: 0x%x\r\n", packetid);
									break;

							}
							if((int)buflen - (int)packetlen < 0) buflen += packetlen;
							if((int)buflen - (int)packetlen >= 0)
								memmove(buffer, buffer + packetlen, buflen - packetlen);
							buflen -= packetlen;
							DoEvents();
						}
					}
					DoEvents();
				}
				
				
			}
			else
				_richedit.AppendText(RED, "Could not connect!\r\n");
			break;
			
		}
	//The above switch statement will see which control was affected
}
//_#1


//#2
int NewHandler (size_t size)
{
    throw WinException ( "Out of memory" );
    return 0;
}

inline int MsgBox(LPCSTR Message, LPCSTR Title)
{
	return MessageBox(0, Message, Title, MB_OK);
}

void DoEvents()  
{  
     MSG Msg;  
     while(PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE)) 
     { 
          if(Msg.message == WM_QUIT)  
               break; 
          TranslateMessage(&Msg);  
          DispatchMessage(&Msg); 
     } 
}
//_#2