VERSION 1.0 CLASS
BEGIN
  MultiUse = 0   'False
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "UserDatabase"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Users() As User
Private UserCount As Long

Private Type User
    Username As String
    Flags As String
    Talks As Long
    Emotes As Long
    Joins As Long
    Kicks As Long
    Bans As Long
    LastSeen As String
    uId As Long
    Password As String
End Type

Private DBWritten As Boolean

Public Property Get Count() As Long
    Count = UserCount
End Property

Public Sub CreateDatabase(ByVal DataFile As String)
    'Debug.Print "Created the database."
    DBWritten = False
    
    ReDim Users(0)
    UserCount = 0

    Dim TempArray() As String
    Dim TempObject() As String
    TempArray = Split(DataFile, vbCrLf)
    
    Dim i As Integer
    For i = LBound(TempArray) To UBound(TempArray) - 1
        TempObject = Split(TempArray(i), "")
        Dim TempUser As User
        TempUser.Username = TempObject(0)
        TempUser.Flags = TempObject(1)
        TempUser.Talks = CLng(TempObject(2))
        TempUser.Emotes = CLng(TempObject(3))
        TempUser.Joins = CLng(TempObject(4))
        TempUser.Kicks = CLng(TempObject(5))
        TempUser.Bans = CLng(TempObject(6))
        TempUser.LastSeen = TempObject(7)
        TempUser.uId = CLng(TempObject(8))
        TempUser.Password = TempObject(9)
        Users(UserCount) = TempUser
        UserCount = UserCount + 1
        ReDim Preserve Users(UserCount)
    Next i
End Sub

Public Sub AddUser(ByVal Username As String)
    Users(UserCount).Username = Username
    Users(UserCount).Flags = ""
    Users(UserCount).Talks = 0
    Users(UserCount).Emotes = 0
    Users(UserCount).Joins = 0
    Users(UserCount).Kicks = 0
    Users(UserCount).Bans = 0
    Users(UserCount).LastSeen = Now
    Users(UserCount).uId = UserCount
    Users(UserCount).Password = ""
    UserCount = UserCount + 1
    ReDim Preserve Users(UserCount)
    'Debug.Print "Added -> " & Users(UserCount - 1).Username
    'Debug.Print "Users(" & UserCount & ")"
End Sub

Public Sub UpdateStat(ByVal Username As String, ByVal StatToUpdate As String, Optional NewValue As String)
    Dim TheUser As Long
    TheUser = FindUser(Username)
    If TheUser = -1 Then
        AddUser Username
        UpdateStat Username, StatToUpdate, NewValue
        Exit Sub
    End If
    Select Case StatToUpdate
        Case "Flags"
            If IsAlpha(StripNonAlpha(NewValue)) = False And NewValue <> vbNullString Then Exit Sub
            NewValue = StripDuplicates(Bubble(StripNonAlpha(NewValue)))
            Debug.Print "New Flags -> " & NewValue
            Users(TheUser).Flags = NewValue
        Case "Talks"
            Users(TheUser).Talks = Users(TheUser).Talks + 1
        Case "Emotes"
            Users(TheUser).Emotes = Users(TheUser).Emotes + 1
        Case "Joins"
            Users(TheUser).Joins = Users(TheUser).Joins + 1
        Case "Kicks"
            Users(TheUser).Kicks = Users(TheUser).Kicks + 1
        Case "Bans"
            Users(TheUser).Bans = Users(TheUser).Bans + 1
        Case "LastSeen"
            'Debug.Print "Now -> " & Now
            Users(TheUser).LastSeen = Now
        Case "Password"
            Users(TheUser).Password = NewValue
    End Select
End Sub

Public Sub CloseDatabase()
    If DBWritten = True Then Exit Sub
    'Debug.Print "Database closing..."
    'Debug.Print "Users to close: " & UBound(Users) - 1 & "/" & UserCount
    On Error Resume Next
    frmShutdown.ProgressBar1.Min = 0
    frmShutdown.ProgressBar1.Max = UBound(Users) - 1
    frmShutdown.ProgressBar1.Value = 0
    Dim Buffer As String
    Dim i As Integer
    For i = LBound(Users) To UBound(Users) - 1
        frmShutdown.ProgressBar1.Value = i
        'Debug.Print "Closing " & Users(i).Username
        Buffer = Buffer & Users(i).Username & "" & _
                         Users(i).Flags & "" & _
                         Users(i).Talks & "" & _
                         Users(i).Emotes & "" & _
                         Users(i).Joins & "" & _
                         Users(i).Kicks & "" & _
                         Users(i).Bans & "" & _
                         Users(i).LastSeen & "" & _
                         Users(i).uId & "" & _
                         Users(i).Password & vbCrLf
    Next i
    'Debug.Print "Database closed."
    Buffer = Left(Buffer, Len(Buffer) - 2)
    frmMain.UserDB.WriteLine Buffer
    DBWritten = True
End Sub

Public Function FindUser(ByVal Username As String) As Long
    Dim i As Integer
    For i = 0 To UBound(Users)
        If LCase(Users(i).Username) = LCase(Username) Then
            FindUser = i
            Exit Function
        End If
    Next i
    FindUser = -1
End Function

Public Function GetInfo(ByVal Username As String, ByVal Paramater As Integer) As String
    Dim TempVar As Long
    TempVar = FindUser(Username)
    If TempVar = -1 Then
        GetInfo = "-1"
        Exit Function
    End If
    Select Case Paramater
        Case 1: GetInfo = Users(FindUser(Username)).Flags
        Case 2: GetInfo = Users(FindUser(Username)).Talks
        Case 3: GetInfo = Users(FindUser(Username)).Emotes
        Case 4: GetInfo = Users(FindUser(Username)).Joins
        Case 5: GetInfo = Users(FindUser(Username)).Kicks
        Case 6: GetInfo = Users(FindUser(Username)).Bans
        Case 7: GetInfo = Users(FindUser(Username)).LastSeen
        Case 8: GetInfo = Users(FindUser(Username)).uId
        Case 9: GetInfo = Users(FindUser(Username)).Password
    End Select
End Function

Private Function Bubble(UnSortedString As String) As String
    Dim X As Long
    Dim Y As Long
    Dim nMax As Long
    Dim sByt As String
    nMax = Len(UnSortedString)


    For X = nMax - 1 To 1 Step -1


        For Y = 1 To X


            If Asc(Mid$(UnSortedString, Y, 1)) > Asc(Mid$(UnSortedString, Y + 1, 1)) Then
                sByt = Mid$(UnSortedString, Y, 1)
                Mid$(UnSortedString, Y, 1) = Mid$(UnSortedString, Y + 1, 1)
                Mid$(UnSortedString, Y + 1, 1) = sByt
            End If
        Next
    Next
    Bubble = UnSortedString
End Function

Private Function IsAlpha(str As String) As Boolean
    Dim InvalidCharFound As Boolean
    Dim X As String
    Dim i As Integer
    Dim AsciiVal As Integer


    If Len(str) > 0 And str <> vbNullString Then


        For i = 1 To Len(str)
            X = Mid(str, i, 1)
            AsciiVal = Asc(X)
            'The ASCII values here are "acceptable"
            '     values for the function.
            'This code allows lower-case letters, up
            '     per-case letters, commas,
            'periods, double and single quotes, hyph
            '     ens, and spaces.
            'It can be modified to include or exclud
            '     e any ASCII values.
            If Not ((AsciiVal > 64 And AsciiVal < 91) Or _
            (AsciiVal > 96 And AsciiVal < 123) Or _
            AsciiVal = 34 Or _
            AsciiVal = 36 Or _
            AsciiVal = 39 Or _
            (AsciiVal > 43 And AsciiVal < 47)) Then
            InvalidCharFound = True
        End If
    Next i
    IsAlpha = Not InvalidCharFound
Else
    IsAlpha = False
End If
End Function

Private Function StripNonAlpha(str As String) As String
    Dim X As String
    Dim i As Integer
    Dim AsciiVal As Integer


    If Len(str) > 0 And str <> vbNullString Then


        For i = 1 To Len(str)
            X = Mid(str, i, 1)
            If i > Len(str) Then
                StripNonAlpha = str
                Exit Function
            End If
            AsciiVal = Asc(X)
            'The ASCII values here are "acceptable"
            '     values for the function.
            'This code allows lower-case letters, up
            '     per-case letters, commas,
            'periods, double and single quotes, hyph
            '     ens, and spaces.
            'It can be modified to include or exclud
            '     e any ASCII values.
            If Not ((AsciiVal > 64 And AsciiVal < 91) Or _
            (AsciiVal > 96 And AsciiVal < 123)) Then
                str = Replace(str, X, "")
                i = i - 1
            End If
        Next i
        StripNonAlpha = str
    Else
        StripNonAlpha = str
    End If
End Function

Private Function StripDuplicates(ByRef TheString As String) As String
    Dim i As Long, TheChar As String
    For i = 1 To Len(TheString) - 1
        TheChar = Mid(TheString, i, 1)
        If TheChar = Mid(TheString, i + 1, 1) Then TheString = Replace(TheString, TheChar & TheChar, TheChar)
    Next i
    StripDuplicates = TheString
End Function
