Attribute VB_Name = "modBNLSLogin"
Option Explicit
' BNLS Events
Public Const BNLS_NULL = &H0
Public Const BNLS_CDKEY = &H1
Public Const BNLS_LOGONCHALLENGE = &H2
Public Const BNLS_LOGONPROOF = &H3
Public Const BNLS_CREATEACCOUNT = &H4
Public Const BNLS_CHANGECHALLENG = &H5
Public Const BNLS_CHANGEPROOF = &H6
Public Const BNLS_UPGRADECHALLENGE = &H7
Public Const BNLS_UPGRADEPROOF = &H8
Public Const BNLS_VERSIONCHECK = &H9
Public Const BNLS_CONFIRMLOGON = &HA
Public Const BNLS_HASHDATA = &HB
Public Const BNLS_CDKEY_EX = &HC
Public Const BNLS_CHOOSENLSREVISION = &HD
Public Const BNLS_AUTHORIZE = &HE
Public Const BNLS_AUTHORIZEPROOF = &HF
Public Const BNLS_REQUESTVERSIONBYTE = &H10
Public Const BNLS_VERIFYSERVER = &H11
Public Const BNLS_RESERVESERVERSLOTS = &H12
Public Const BNLS_SERVERLOGONCHALLENGE = &H13
Public Const BNLS_SERVERLOGONPROOF = &H14

Public Const PRODUCT_WARCRAFT3 = &H7
Public Const PRODUCT_FROZENTHRONE = &H8

Public Sub ParseBNLS(ByVal Data As String)
Select Case Asc(Mid(Data, 3, 1))
    Case BNLS_CDKEY: Parse0x01 Data
    Case BNLS_LOGONCHALLENGE: Parse0x02 Data
    Case BNLS_LOGONPROOF: Parse0x03 Data
    Case BNLS_CREATEACCOUNT: Parse0x04 Data
    Case BNLS_VERSIONCHECK: Parse0x09 Data
    Case BNLS_REQUESTVERSIONBYTE: Parse0x10 Data
    Case BNLS_CDKEY_EX: Parse0x0C Data
    Case BNLS_CHOOSENLSREVISION: Parse0x0D Data
    Case BNLS_AUTHORIZE: Parse0x0E Data
    Case BNLS_AUTHORIZEPROOF: Parse0x0F Data
    Case Else: ParseUnknown Data
End Select
End Sub

Private Function Parse0x01(Data As String)
CdkeyHash = Mid(Data, 12)
GTC = Val("&H" & PBuffer.StrToHex(StrReverse(Mid(Data, 8, 4))))
GTC = CLng(GTC)
Send0x51
End Function
Private Function Parse0x02(Data As String)
With PBuffer
.InsertNonNTString Mid(Data, 4)
.InsertNTString BNCS.Username
.SendPacket SID_AUTH_ACCOUNTLOGON
End With
End Function
Private Function Parse0x03(Data As String)
With PBuffer
.InsertNonNTString Mid(Data, 4)
.SendPacket SID_AUTH_ACCOUNTLOGONPROOF
End With
End Function
Private Function Parse0x04(Data As String)
With PBuffer
.InsertNonNTString Mid$(Data, 4)
.InsertNTString BNCS.Username
.SendPacket SID_AUTH_ACCOUNTCREATE
End With
End Function
Private Function Parse0x09(Data As String)
Version = Val("&H" & PBuffer.StrToHex(StrReverse(Mid(Data, 8, 4))))
Version = CLng(strVersion)
CheckSum = Val("&H" & PBuffer.StrToHex(StrReverse(Mid(Data, 12, 4))))
CheckSum = CLng(CheckSum)
ExeInfo = Mid(Data, 16, Len(Data) - 16)
With PBuffer
If BNCS.Product = "W3XP" Then
    .InsertDWORD &H0
    .InsertBYTE &H2
    .InsertDWORD &H1
    .InsertDWORD Servers
    .InsertNTString BNCS.Cdkey
    .InsertNTString BNCS.ExpCdKey
    .SendBNLSPacket BNLS_CDKEY_EX
Else
    .InsertDWORD Servers
    .InsertNTString BNCS.Cdkey
    .SendBNLSPacket BNLS_CDKEY
End If
End With
End Function

Private Function Parse0x10(Data As String)
VerByte = PBuffer.GetDWORD(Mid(Data, 8, 4))
frmMain.sckBNCS.Close
frmMain.sckBNCS.Connect BNCS.BNCSServer, 6112
AddC AtomicGreen, "(BNCS) ", vbTeal, "Attempting Connection."
End Function

Private Function Parse0x0C(Data As String)
CdkeyHash = Mid(Data, 18, 36)
Cdkey2Hash = Mid(Data, 58, 36)
GTC = Val("&H" & PBuffer.StrToHex(StrReverse(Mid(Data, 14, 4))))
GTC = CLng(GTC)
Send0x51
End Function
Private Function Parse0x0D(Data As String)
'AddC AtomicWhite, "(BNLS) ", vbDGreen, "NLS Revision Passed!"
End Function

Private Function Parse0x0E(Data As String)
Dim check As Long
Dim key As Long
key = PBuffer.GetDWORD(Mid(Data, 4, 4))
check = BNLSChecksum("@", key)
With PBuffer
.InsertDWORD check
.SendBNLSPacket BNLS_AUTHORIZEPROOF
End With
End Function

Private Function Parse0x0F(Data As String)
AddC AtomicWhite, "(BNLS) ", vbDGreen, "Authorized!"
With PBuffer
    .InsertDWORD GetBNLSByte()
    .SendBNLSPacket &H10
    .InsertDWORD &H2
    .SendBNLSPacket &HD
End With
End Function

Private Function ParseUnknown(Data As String)
Dim r() As String
r = Split(PBuffer.StrToHex(Data))
AddC AtomicWhite, "(BNLS) ", vbDGreen, "Unidentified Packet: 0x" & r(3)
Open App.Path & "\Packets\BNLS\0x" & r(3) & ".txt" For Append As #1
Print #1, "Unidentified Packet: 0x" & r(3) & " Recieved On: " & Date & " At: " & Time
Print #1, PBuffer.DebugOutput(Data)
Print #1, ""
Close #1
End Function

Private Sub InitCRC32()
    Dim i As Long, J As Long, K As Long, XorVal As Long
    
    Static CRC32Initialized As Boolean
    If CRC32Initialized Then Exit Sub
    CRC32Initialized = True
    
    For i = 0 To 255
        K = i
        
        For J = 1 To 8
            If K And 1 Then XorVal = CRC32_POLYNOMIAL Else XorVal = 0
            If K < 0 Then K = ((K And &H7FFFFFFF) \ 2) Or &H40000000 Else K = K \ 2
            K = K Xor XorVal
        Next
        
        CRC32Table(i) = K
    Next
End Sub

Private Function CRC32(ByVal Data As String) As Long
    Dim i As Long, J As Long
    
    Call InitCRC32
    
    CRC32 = &HFFFFFFFF
    
    For i = 1 To Len(Data)
        J = CByte(Asc(Mid(Data, i, 1))) Xor (CRC32 And &HFF&)
        If CRC32 < 0 Then CRC32 = ((CRC32 And &H7FFFFFFF) \ &H100&) Or &H800000 Else CRC32 = CRC32 \ &H100&
        CRC32 = CRC32 Xor CRC32Table(J)
    Next
    
    CRC32 = Not CRC32
End Function

Public Function BNLSChecksum(ByVal Password As String, ByVal ServerCode As Long) As Long
    BNLSChecksum = CRC32(Password & Right("0000000" & Hex(ServerCode), 8))
End Function

Public Function GetBNLSByte() As Long
Select Case BNCS.Product
    Case "WAR3"
        GetBNLSByte = PRODUCT_WARCRAFT3
    Case "W3XP"
        GetBNLSByte = PRODUCT_FROZENTHRONE
    Case Else
        AddC AtomicWhite, "(BNLS) ", vbDGreen, "Invalid Product " & BNCS.Product
        frmMain.sckBNLS.Close
End Select
End Function
