Attribute VB_Name = "modBNCSChat"
Option Explicit
'Chat Events (0x0F)
Public Const EID_USER = &H1
Public Const EID_JOIN = &H2
Public Const EID_LEAVE = &H3
Public Const EID_WHISPER = &H4
Public Const EID_TALK = &H5
Public Const EID_BROADCAST = &H6
Public Const EID_CHANNEL = &H7
Public Const EID_USERFLAGS = &H9
Public Const EID_WHISPERSENT = &HA
Public Const EID_CHANNELFULL = &HD
Public Const EID_CHANNELDOESNOTEXIST = &HE
Public Const EID_CHANNELRESTRICTED = &HF
Public Const EID_INFO = &H12
Public Const EID_ERROR = &H13
Public Const EID_EMOTE = &H17

' User Flags
Public Const UF_BLIZZREP = &H1
Public Const UF_CHANNELOP = &H2
Public Const UF_SPEAKER = &H4
Public Const UF_ADMIN = &H8
Public Const UF_NOUDP = &H10
Public Const UF_SQUELCHED = &H20

Public Sub Parse0x0F(ByVal Data As String)
Dim EID As Long, username As String, message As String, Flags As Long
EID = PBuffer.MakeLong(Mid$(Data, 5, 4))
username = PBuffer.KillNull(Mid$(Data, 29))
Flags = PBuffer.MakeLong(Mid$(Data, 9, 4))
message = PBuffer.KillNull(Mid$(Data, Len(username) + 30))
Select Case EID
    Case EID_USER: OnUser username, Flags, message ' 0x01
    Case EID_JOIN: OnJoin username, Flags, message  ' 0x02
    Case EID_LEAVE: OnLeave username ' 0x03
    Case EID_WHISPER: OnWhisperFrom username, Flags, message ' 0x04
    Case EID_TALK: OnTalk username, message, Flags ' 0x05
    Case EID_BROADCAST: OnBroadcast message ' 0x06
    Case EID_CHANNEL: OnChannel message, Flags ' 0x07
    Case EID_USERFLAGS: OnFlags username, Flags, message ' 0x09
    Case EID_WHISPERSENT: OnWhisperSent username, Flags, message ' 0x0A
    Case EID_CHANNELFULL: OnChannelFull message ' 0x0D
    Case EID_CHANNELDOESNOTEXIST: OnChannelDoesNotExist message ' 0x0E
    Case EID_CHANNELRESTRICTED: OnChannelRestricted message ' 0x0F
    Case EID_INFO: OnInfo message ' 0x12
    Case EID_ERROR: OnError message ' 0x13
    Case EID_EMOTE: OnEmote username, Flags, message ' 0x17
    Case Else: OnUnknown message
End Select
End Sub

Private Sub OnUser(ByVal username As String, ByVal Flags As Long, ByVal message As String)

Dim i As Integer
For i = 1 To frmMain.lwChannel.ListItems.Count
    If username = frmMain.lwChannel.ListItems(i).text Then Exit Sub
Next i

With frmMain.lwChannel
If (Flags And UF_CHANNELOP) = UF_CHANNELOP Then
    .ListItems.Add 1, , username
    .FindItem(username).ListSubItems.Add , , GetFlags(LCase(username))
    .ListItems(.FindItem(username).Index).ForeColor = vbLightGreen
    .Refresh
AddC vbLavender, username & " has operator status."
Else
    .ListItems.Add , , username
    .FindItem(username).ListSubItems.Add , , GetFlags(LCase(username))
    If GetFlags(LCase(username)) <> "" Then
    .ListItems(.FindItem(username).Index).ForeColor = AtomicBlue
    End If
    .Refresh
End If
frmMain.lblChannel.Caption = frmMain.lblChannel.Tag & " (" & frmMain.lwChannel.ListItems.Count & ")"
End With
Open App.Path & "\Channel.txt" For Append As #1
Print #1, username
Close #1
End Sub
Private Sub OnJoin(ByVal username As String, ByVal Flags As Long, ByVal message As String)
frmMain.tmrJoinSet.Enabled = True
If LastJoin = username Then Rejoins = Rejoins + 1
If Rejoins = 2 Then frmMain.Send "Flood Detected: " & username
If username <> LastJoiner Then If CheckMail(username) <> 0 Then frmMain.lwQueue.ListItems.Add , , "/msg " & username & " You have " & CheckMail(username) & " new messages, whisper me 'listmail' for a list."
LastJoiner = username
LastJoin = username
With frmMain.lwChannel
    .ListItems.Add , , username
    .FindItem(username).ListSubItems.Add , , GetFlags(LCase(username))
    If GetFlags(LCase(username)) <> "" Then
    .ListItems(.FindItem(username).Index).ForeColor = AtomicBlue
    End If
    .Refresh
End With
frmMain.lblChannel.Caption = frmMain.lblChannel.Tag & " (" & frmMain.lwChannel.ListItems.Count & ")"
End Sub
Private Sub OnLeave(ByVal username As String)
With frmMain.lwChannel
    .ListItems.Remove .FindItem(username).Index
    .Refresh
End With
frmMain.lblChannel.Caption = frmMain.lblChannel.Tag & " (" & frmMain.lwChannel.ListItems.Count & ")"
End Sub
Private Sub OnWhisperFrom(ByVal username As String, ByVal Flags As Long, ByVal message As String)
message = RidColors(message)
message = BNCS.Trigger + message
PRC username, message, True
Dim i As Integer
For i = 1 To frmMain.lwDatabase.ListItems.Count
    If LCase(frmMain.lwDatabase.ListItems(i).text) = LCase(username) Then
        AddC vbMediumOrange, "<From: " & username & "> " & message
    End If
Next i
End Sub
Private Sub OnTalk(ByVal username As String, ByVal message As String, ByVal Flags As Long)
message = RidColors(message)
If Left(message, Len(BNCS.Trigger)) = BNCS.Trigger Then PRC username, message
Dim i As Integer
For i = 1 To frmMain.lwDatabase.ListItems.Count
    If LCase(frmMain.lwDatabase.ListItems(i).text) = LCase(username) Then
        AddC AtomicBlue, "<" & username & "> " & message: Exit Sub
    End If
Next i
End Sub
Private Sub OnBroadcast(ByVal message As String)
AddC AtomicWhite, "(BNCS) ", AtomicYellow, "Broadcast: " & message
End Sub
Private Sub OnChannel(ByVal ChannelName As String, ByVal Flags As Long)
With frmMain
    .lwChannel.ListItems.Clear
    .lblChannel.Tag = ChannelName
    .lblChannel.Caption = ChannelName
End With
AddC vbLightBlue, "Joined Channel: " & ChannelName
With PBuffer
    .InsertDWORD &H1
    .InsertDWORD &H4
    .InsertNTString BNCS.username
    .InsertNTString "profile\sex"
    .InsertNTString "profile\age"
    .InsertNTString "profile\location"
    .InsertNTString "profile\description"
    .InsertNTString " "
    .InsertNTString " "
    .InsertNTString " "
    .InsertNTString "Trigger: " & BNCS.Trigger
    .SendPacket SID_WRITEUSERDATA
End With
End Sub
Private Sub OnFlags(ByVal username As String, ByVal Flags As Long, ByVal message As String)
Dim FinalMsg As String
If (Flags And UF_CHANNELOP) = UF_CHANNELOP And (Flags And UF_SQUELCHED) = UF_SQUELCHED Then
    frmMain.lwChannel.ListItems.Remove frmMain.lwChannel.FindItem(username).Index
    frmMain.lwChannel.Refresh
    frmMain.lwChannel.ListItems.Add 1, , username
    frmMain.lwChannel.ListItems(frmMain.lwChannel.FindItem(username).Index).ForeColor = vbPaleRed
    frmMain.lwChannel.Refresh
    FinalMsg = "Channel Operator and Squelched"
    
ElseIf (Flags And UF_CHANNELOP) = UF_CHANNELOP Then
    frmMain.lwChannel.ListItems.Remove frmMain.lwChannel.FindItem(username).Index
    frmMain.lwChannel.Refresh
    frmMain.lwChannel.ListItems.Add 1, , username
    frmMain.lwChannel.ListItems(frmMain.lwChannel.FindItem(username).Index).ForeColor = vbGold
    frmMain.lwChannel.Refresh
    FinalMsg = "Channel Operator"
    
ElseIf (Flags And UF_SQUELCHED) = UF_SQUELCHED Then
    frmMain.lwChannel.ListItems(frmMain.lwChannel.FindItem(username).Index).ForeColor = vbPaleRed
    frmMain.lwChannel.Refresh
    If FinalMsg <> vbNullString Then
        FinalMsg = FinalMsg & " Squelched"
    Else
        FinalMsg = "Squelched"
    End If
ElseIf (Flags And &H0) = &H0 Then
    'Null
End If
If FinalMsg <> vbNullString Then
AddC vbGrey, "Flags Update: " & username & " (" & FinalMsg & ")"
End If
End Sub
Private Sub OnWhisperSent(ByVal username As String, ByVal Flags As Long, ByVal message As String)
AddC vbRed, "To: " & username & " ~~ " & message
End Sub
Private Sub OnChannelFull(ByVal message As String)
AddC vbRed, "Channel " & message & " is full."
End Sub
Private Sub OnChannelDoesNotExist(ByVal message As String)
With PBuffer
    .InsertDWORD &H2
    .InsertNTString message
    .SendPacket SID_JOINCHANNEL
End With
End Sub
Private Sub OnChannelRestricted(ByVal message As String)
If message = "warez" Then
    With PBuffer
        .InsertDWORD &H2
        .InsertNTString message
        .SendPacket SID_JOINCHANNEL
    End With
Else
    AddC vbRed, "Channel " & message & " is restricted."
End If
End Sub
Private Sub OnInfo(ByVal message As String)
If message = "You are now marked as being away." Then Exit Sub
If message = "You are no longer marked as away." Then frmMain.lwQueue.ListItems.Add , , "/away -:- " & Title & " v" & strVersion & " -:-": Exit Sub
If message = "This channel does not have chat privileges." Then Exit Sub
If message = "You are still marked as being away." Then Exit Sub
If message = "Looking for a clan? Looking for members? Clan Recruitment allows you to find both." Then Exit Sub
If InStr(message, "has been unsquelched.") Then Exit Sub
If InStr(message, "has been squelched.") Then Exit Sub
If InStr(message, "is away") Then Exit Sub

'BanList functions
If InStr(message, "was banned by") Then
Dim SplitBan() As String
SplitBan() = Split(message, " ")
LastBan = SplitBan(0)
If InStr(1, BanList, SplitBan(0)) = 0 Then
If Len(BanList) = 0 Then
BanList = SplitBan(0)
Else
BanList = BanList & ", " & SplitBan(0)
End If
End If
End If

AddC vbLightBlue, "Info: " & message
End Sub
Private Sub OnError(ByVal message As String)
AddC vbRed, "Error: " & message
End Sub
Private Sub OnEmote(ByVal username As String, ByVal Flags As Long, ByVal message As String)
AddC vbYellow, "<" & username & " (Emote)" & ">" & message
End Sub
Private Sub OnUnknown(ByVal UnknownString As String)
AddC vbRed, "Unknown: " & UnknownString
End Sub
