Attribute VB_Name = "modWinsock"
'Winsock API Module Copyright (C) 2004 LoRd[nK] (thevirushunter@hotmail.com)

Option Explicit

Public Declare Function lstrlenA Lib "Kernel32.dll" (ByVal lpString As Any) As Long
Public Declare Function lstrcpyA Lib "Kernel32.dll" (ByVal lpString1 As String, ByVal lpString2 As Long) As Long
Public Declare Function IsCharAlphaA Lib "User32.dll" (ByVal str As String) As Boolean
Public Declare Function IsCharAlphaNumericA Lib "User32.dll" (ByVal str As String) As Boolean
Public Declare Sub RtlMoveMemory Lib "Kernel32.dll" (ByRef Destination As Any, ByRef Source As Any, ByVal numBYTEs As Long)

Public Declare Function htons Lib "Ws2_32.dll" (ByVal hostshort As Long) As Integer
Public Declare Function inet_addr Lib "Ws2_32.dll" (ByVal CP As String) As Long
Public Declare Function inet_ntoa Lib "Ws2_32.dll" (ByRef inaddr As in_addr) As Long
Public Declare Function setsockopt Lib "Ws2_32.dll" (ByVal s As Long, ByVal level As Long, ByVal optname As Long, optval As Any, ByVal optlen As Long) As Long 'Set socket options
Public Declare Function closesocket Lib "Ws2_32.dll" (ByVal s As Long) As Long 'Close socket

Private Declare Function socket Lib "Ws2_32.dll" (ByVal af As Integer, ByVal s_type As Integer, ByVal Protocol As Integer) As Long 'Creates a socket
Private Declare Function listen Lib "Ws2_32.dll" (ByVal s As Long, ByVal backlog As Integer) As Long 'Places a socket in a state in which it is listening for an incoming connection
Private Declare Function connect Lib "Ws2_32.dll" (ByVal s As Long, ByVal sockaddr As sock_addr, ByVal namelen As Integer) As Integer 'Establish a connection to a specified socket
Private Declare Function send Lib "Ws2_32.dll" (ByVal s As Long, ByVal Data As String, ByVal Length As Integer, flags As Long) As Long 'Send data to connected socket
Private Declare Function recv Lib "Ws2_32.dll" (ByVal s As Long, ByRef buf As Any, ByVal buflen As Long, ByVal flags As Long) As Long
Private Declare Function WSAStartup Lib "Ws2_32.dll" (ByVal wVersionRequested As Integer, lpWSAData As WSADATA) As Integer 'Start use of Ws2_32.dll
Private Declare Function WSACleanup Lib "Ws2_32.dll" () As Integer 'End use of Ws2_32.dll
Private Declare Function gethostname Lib "Ws2_32.dll" (ByVal Name As String, ByVal namelen As Integer) As Integer 'Retrieves the standard host name for the local computer
Private Declare Function gethostbyname Lib "Ws2_32.dll" (ByVal strname As String) As Long

Public Const IPPROTO_TCP = 6
Public Const TCP_NODELAY = &H1 '(BOOL) Nagel Algorithm
Public Const SOCKET_ERROR = -1

Public Type WSADATA
   wVersion As Integer
   wHighVersion As Integer
   szDescription(0 To 256) As Byte
   szSystemStatus(0 To 128) As Byte
   iMaxSockets As Long
   iMaxUDPDG As Long
   lpVendorInfo As Long
End Type

Public Type in_addr
    s_b1 As Byte
    s_b2 As Byte
    s_b3 As Byte
    s_b4 As Byte
    s_w1 As Integer
    s_w2 As Integer
    s_addr As Long
End Type

Public Type sock_addr
    sin_family As Integer
    sin_port As Integer
    sin_addr As in_addr
    sin_zero(0 To 7) As Byte
End Type

Public Type HOSTENT
    hName As Long
    hAliases As Long
    hAddrType As Integer
    hLength As Integer
    hAddrList As Long
End Type

Enum sckState
    sckClosed = 0
    sckOpen = 1
    sckListening = 2
    sckConnectionPending = 3
    sckResolvingHost = 4
    sckHostResolved = 5
    sckConnecting = 6
    sckConnected = 7
    sckClosing = 8
    sckError = 9
End Enum

Private clsFunctions As New Functions

Public Function SendData(ByVal SocketHandle As Long, ByVal strData As String) As Long
Dim tmpBuf() As Byte
tmpBuf() = StrConv(strData, vbFromUnicode)
SendData = send(SocketHandle, tmpBuf(0), Len(strData), &H0)
End Function
Public Property Get LocalHostName() As String
Dim tmpHost As String * 256
If gethostname(tmpHost, 256) <> SOCKET_ERROR Then LocalHostName = clsFunctions.TrimNull(tmpHost)
End Property
Public Function GetIPFromHostName(ByVal Hostname As String) As String()
Dim tmpArrIP() As String
Dim tmpPointer As Long
Dim tmpHOSTENT As HOSTENT
tmpPointer = gethostbyname(Hostname)
If tmpPointer Then
    Dim I As Byte
    Dim strIPAddress As String
    Dim arrIPAddress() As Byte
    Dim arrIPAddresses() As String
    Call RtlMoveMemory(tmpHOSTENT, ByVal tmpPointer, LenB(tmpHOSTENT))
    Call RtlMoveMemory(tmpPointer, ByVal tmpHOSTENT.hAddrList, 4)
    ReDim arrIPAddresses(0)
    While tmpPointer
        ReDim arrIPAddress(0 To tmpHOSTENT.hLength)
        Call RtlMoveMemory(arrIPAddress(0), ByVal tmpPointer, tmpHOSTENT.hLength)
        For I = 0 To tmpHOSTENT.hLength - 1
            strIPAddress = strIPAddress & arrIPAddress(I) & "."
        Next
        arrIPAddresses(UBound(arrIPAddresses)) = Mid(strIPAddress, 1, lstrlenA(strIPAddress) - 1)
        strIPAddress = vbNullString
        tmpHOSTENT.hAddrList = tmpHOSTENT.hAddrList + LenB(tmpHOSTENT.hAddrList)
        Call RtlMoveMemory(tmpPointer, ByVal tmpHOSTENT.hAddrList, 4)
        ReDim Preserve arrIPAddresses(0 To UBound(arrIPAddresses) + 1)
    Wend
    ReDim Preserve arrIPAddresses(0 To UBound(arrIPAddresses) - 1)
    GetIPFromHostName = arrIPAddresses
End If
End Function

