VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ParseStats"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Sub sprintf(ByRef Source As String, ByVal nText As String, _
    Optional ByVal A As Variant, _
    Optional ByVal B As Variant, _
    Optional ByVal C As Variant, _
    Optional ByVal D As Variant, _
    Optional ByVal E As Variant, _
    Optional ByVal F As Variant, _
    Optional ByVal G As Variant, _
    Optional ByVal H As Variant)
    
    nText = Replace(nText, "%S", "%s")
    Dim I As Byte
    I = 0
    Do While (InStr(1, nText, "%s") <> 0)
        Select Case I
            Case 0
                If IsEmpty(A) Then GoTo TheEnd
                nText = Replace(nText, "%s", A, 1, 1)
            Case 1
                If IsEmpty(B) Then GoTo TheEnd
                nText = Replace(nText, "%s", B, 1, 1)
            Case 2
                If IsEmpty(C) Then GoTo TheEnd
                nText = Replace(nText, "%s", C, 1, 1)
            Case 3
                If IsEmpty(D) Then GoTo TheEnd
                nText = Replace(nText, "%s", D, 1, 1)
            Case 4
                If IsEmpty(E) Then GoTo TheEnd
                nText = Replace(nText, "%s", E, 1, 1)
            Case 5
                If IsEmpty(F) Then GoTo TheEnd
                nText = Replace(nText, "%s", F, 1, 1)
            Case 6
                If IsEmpty(G) Then GoTo TheEnd
                nText = Replace(nText, "%s", G, 1, 1)
            Case 7
                If IsEmpty(H) Then GoTo TheEnd
                nText = Replace(nText, "%s", H, 1, 1)
        End Select
        I = I + 1
    Loop
TheEnd:
    Source = Source & nText
End Sub
Public Sub ParseStatString(ByVal statstring As String, ByRef OutBuf As String)
    Dim Values() As String
    Dim cType As String

    Select Case Left$(statstring, 4)
        Case "3RAW"
            sprintf OutBuf, "WarCraft III: Reign of Chaos ("
            If Len(statstring) > 4 Then
                Values = Split(statstring, " ")
                Call strcpy(OutBuf, "level " & Values(2) & ", best race ")
                    Select Case Mid$(Values(1), 2, 1)
                        Case "H": strcpy OutBuf, "human, "
                        Case "O": strcpy OutBuf, "orcs, "
                        Case "N": strcpy OutBuf, "night elf, "
                        Case "U": strcpy OutBuf, "undead, "
                        Case "R": strcpy OutBuf, "random, "
                        Case Else: strcpy OutBuf, "unknown, "
                    End Select
                    Select Case Mid$(Values(1), 1, 1)
                        Case 1: strcpy OutBuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1), "3RAW")
                        Case 2: strcpy OutBuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1), "3RAW")
                        Case 3: strcpy OutBuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1), "3RAW")
                        Case 4: strcpy OutBuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1), "3RAW")
                        Case Else: strcpy OutBuf, "unknown " & Mid$(Values(1), 1, 1) & ", "
                    End Select
                    If UBound(Values) > 2 Then strcpy OutBuf, ", clan " & StrReverse(Values(3))
                    strcpy OutBuf, ")"
            ElseIf Len(statstring) = 4 Then
                strcpy OutBuf, "No stats available)"
            Else
                strcpy OutBuf, "Unknown Stats " & statstring & ")"
            End If
            Case "PX3W"
                sprintf OutBuf, "WarCraft III: The Frozen Throne ("
                If Len(statstring) > 4 Then
                Values = Split(statstring, " ")
                Call strcpy(OutBuf, "level " & Values(2) & ", best race ")
                Select Case Mid$(Values(1), 2, 1)
                    Case "D": strcpy OutBuf, "tournament, "
                    Case "H": strcpy OutBuf, "human, "
                    Case "O": strcpy OutBuf, "orcs, "
                    Case "N": strcpy OutBuf, "night elf, "
                    Case "U": strcpy OutBuf, "undead, "
                    Case "R": strcpy OutBuf, "random, "
                    Case Else: strcpy OutBuf, "unknown, "
                End Select
                Select Case Mid$(Values(1), 1, 1)
                    Case "D": strcpy OutBuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1), "PX3W")
                    Case "S": strcpy OutBuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1), "PX3W")
                    Case 1: strcpy OutBuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1), "PX3W")
                    Case 2: strcpy OutBuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1), "PX3W")
                    Case 3: strcpy OutBuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1), "PX3W")
                    Case 4: strcpy OutBuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1), "PX3W")
                    Case Else: strcpy OutBuf, "unknown " & Mid$(Values(1), 1, 1) & ", "
                End Select
                If UBound(Values) > 2 Then strcpy OutBuf, ", clan " & StrReverse(Values(3))
                strcpy OutBuf, ")"
            Else
                strcpy OutBuf, "No stats available)"
            End If
        Case "RHSS"
            Call strcpy(OutBuf, "Starcraft: Shareware")
        Case "RATS"
            Values() = Split(Mid$(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call sprintf(OutBuf, "a Starcraft %sbot", IIf((Values(3) = 1), " (spawn) ", ""))
                Exit Sub
            End If
            If Values(0) > 0 Then

                If Values(1) > 0 Then
                    Call sprintf(OutBuf, "Starcraft%s (%s wins, ladder rating #%s, high ladder rating #" & Values(5) & ", ladder rank #" & Values(1) & ")", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                Else
                    Call sprintf(OutBuf, "Starcraft%s (%s wins, ladder rating #%s, high ladder rating #" & Values(5) & ")", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                End If
            Else
                Call sprintf(OutBuf, "Starcraft%s (%s wins)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2))
            End If
        Case "PXES"
            Values() = Split(Mid(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call sprintf(OutBuf, "a Starcraft: Brood War %sbot", IIf((Values(3) = 1), " (spawn) ", ""))
                Exit Sub
            End If
            If Values(0) > 0 Then
                If Values(1) > 0 Then
                    Call sprintf(OutBuf, "Starcraft: Brood War%s (%s wins, ladder rating #%s, high ladder rating #" & Values(5) & ", ladder rank #" & Values(1) & ")", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                Else
                    Call sprintf(OutBuf, "Starcraft: Brood War%s (%s wins, ladder rating #%s, high ladder rating #" & Values(5) & ")", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                End If
            Else
                Call sprintf(OutBuf, "Starcraft: Brood War%s (%s wins)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2))
            End If
        Case "RTSJ"
            Values() = Split(Mid(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call sprintf(OutBuf, "a Starcraft Japanese %sbot", IIf((Values(3) = 1), " (spawn) ", ""))
                Exit Sub
            End If
            If Values(0) > 0 Then
                If Values(1) > 0 Then
                    Call sprintf(OutBuf, "Starcraft: Japanese%s (%s wins, ladder rating #%s, high ladder rating #" & Values(5) & ", ladder rank #" & Values(1) & ")", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                Else
                    Call sprintf(OutBuf, "Starcraft: Japanese%s (%s wins, ladder rating #%s, high ladder rating #" & Values(5) & ")", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                End If
            Else
                Call sprintf(OutBuf, "Starcraft: Japanese%s (%s wins)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2))
            End If
        Case "NB2W"
            Values() = Split(Mid$(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call sprintf(OutBuf, "a Warcraft II: Battle.net Edition %sbot", IIf((Values(3) = 1), " (spawn) ", ""))
                Exit Sub
            End If
            If Values(0) > 0 Then
                If Values(1) > 0 Then
                    Call sprintf(OutBuf, "Warcraft II: Battle.net Edition%s (%s wins, ladder rating #%s, high ladder rating #" & Values(5) & ", ladder rank #" & Values(1) & ")", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                Else
                    Call sprintf(OutBuf, "Warcraft II: Battle.net Edition%s (%s wins, ladder rating #%s, high ladder rating #" & Values(5) & ")", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                End If
            Else
                Call sprintf(OutBuf, "Warcraft II: Battle.net Edition%s (%s wins)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2))
            End If
        Case "RHSD"
            Values() = Split(Mid$(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call strcpy(OutBuf, "a Diablo: Shareware bot")
                Exit Sub
            End If
            Select Case Values(2)
                Case 0: cType = "warrior"
                Case 1: cType = "rogue"
                Case 2: cType = "sorceror"
            End Select
            Call sprintf(OutBuf, "Diablo: Shareware (Level %s %s with %s dots, %s strength, %s magic, %s dexterity, %s vitality, and %s gold)", Values(0), cType, Values(1), Values(3), Values(4), Values(5), Values(6), Values(7))
        Case "LTRD"
            Values() = Split(Mid$(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call strcpy(OutBuf, "a Diablo bot")
                Exit Sub
            End If
            Select Case Values(2)
                Case 0: cType = "warrior"
                Case 1: cType = "rogue"
                Case 2: cType = "sorceror"
            End Select
            Call sprintf(OutBuf, "Diablo (Level %s %s with %s dots, %s strength, %s magic, %s dexterity, %s vitality, and %s gold)", Values(0), cType, Values(1), Values(3), Values(4), Values(5), Values(6), Values(7))
        Case "PX2D"
            Call strcpy(OutBuf, ParseD2Stats(statstring))
        Case "VD2D"
            Call strcpy(OutBuf, ParseD2Stats(statstring))
        Case "TAHC"
            Call strcpy(OutBuf, "a chat bot")
        Case Else
            Call strcpy(OutBuf, "unknown")
    End Select
End Sub
Public Function ParseD2Stats(ByVal Stats As String)
On Error Resume Next
Dim Act As Integer
    Dim d2classes(0 To 7) As String
        d2classes(0) = "amazon"
        d2classes(1) = "sorceress"
        d2classes(2) = "necromancer"
        d2classes(3) = "paladin"
        d2classes(4) = "barbarian"
        d2classes(5) = "druid"
        d2classes(6) = "assassin"
        d2classes(7) = "unknown class"
    Dim statbuf As String, p() As String, Server As String, Name As String
    If Len(Stats) > 4 Then
        Dim sLen As Byte
        sLen = GetServer(Stats, Server)
        sLen = GetCharacterName(Stats, sLen, Name)
        Call MakeArray(Mid$(Stats, sLen), p())
    End If
    If Left$(Stats, 4) = "VD2D" Then
        Call strcpy(statbuf, "Diablo II (")
    Else
        Call strcpy(statbuf, "Diablo II: Lord of Destruction (")
    End If
    If (Len(Stats) = 4) Then
        Call strcpy(statbuf, "Open Character)")
    Else
        Dim version As Byte
        version = Asc(p(0)) - &H80
        Dim charclass As Byte
        charclass = Asc(p(13)) - 1
        If (charclass < 0) Or (charclass > 6) Then
            charclass = 7
        End If
        Dim female As Boolean
        female = False
        If (charclass = 0) Or (charclass = 1) Or (charclass = 6) Then
            female = True
        End If
        Dim charlevel As Byte
        charlevel = Asc(p(25))
        Dim hardcore As Byte
        hardcore = Asc(p(26)) And 4
        Dim expansion As Boolean
        expansion = False
        If Left$(Stats, 4) = "PX2D" Then
            If (Asc(p(26)) And &H20) Then
                Select Case Functions.RShift((Asc(p(27)) And &H18), 3)
                    Case 1
                        If hardcore Then
                            Call strcpy(statbuf, "Destroyer ")
                        Else
                            Call strcpy(statbuf, "Slayer ")
                        End If
                    Case 2
                        If hardcore Then
                            Call strcpy(statbuf, "Conquerer ")
                        Else
                            Call strcpy(statbuf, "Champion ")
                        End If
                    Case 3
                        If hardcore Then
                            Call strcpy(statbuf, "Guardian ")
                        Else
                            If Not female Then
                                Call strcpy(statbuf, "Patriarch ")
                            Else
                                Call strcpy(statbuf, "Matriarch ")
                            End If
                        End If
                End Select
                expansion = True
            End If
        End If
        If Not expansion Then
            Select Case Functions.RShift((Asc(p(27)) And &H18), 3)
                Case 1
                    If female = False Then
                        If hardcore Then
                            Call strcpy(statbuf, "Count ")
                        Else
                            Call strcpy(statbuf, "Sir ")
                        End If
                    Else
                        If hardcore Then
                            Call strcpy(statbuf, "Countess ")
                        Else
                            Call strcpy(statbuf, "Dame ")
                        End If
                    End If
                Case 2
                    If female = False Then
                        If hardcore Then
                            Call strcpy(statbuf, "Duke ")
                        Else
                            Call strcpy(statbuf, "Lord ")
                        End If
                    Else
                        If hardcore Then
                            Call strcpy(statbuf, "Duchess ")
                        Else
                            Call strcpy(statbuf, "Lady ")
                        End If
                    End If
                Case 3
                    If female = False Then
                        If hardcore Then
                            Call strcpy(statbuf, "King ")
                        Else
                            Call strcpy(statbuf, "Baron ")
                        End If
                    Else
                        If hardcore Then
                            Call strcpy(statbuf, "Queen ")
                        Else
                            Call strcpy(statbuf, "Baroness ")
                        End If
                    End If
            End Select
        End If
        Call sprintf(statbuf, "%s@%s, a ", Name, Server)
        If hardcore Then
            If (Asc(p(26)) And &H8) Then Call strcpy(statbuf, "dead ")
            Call sprintf(statbuf, "level %s ", charlevel)
            If expansion Then
                Call sprintf(statbuf, "expansion hardcore ")
            Else
                Call sprintf(statbuf, "standard hardcore ")
            End If
        Else
            Call sprintf(statbuf, "level %s ", charlevel)
            If expansion Then
                Call sprintf(statbuf, "expansion ")
            Else
                Call sprintf(statbuf, "standard ")
            End If
        End If
        If Asc(p(30)) = &H1 Then Call strcpy(statbuf, "ladder ")
        Call sprintf(statbuf, "%s)", d2classes(charclass))
    End If
    'P(2) == Cap
    'P(7) == Weapon
    'P(9) == Sheild
    'P(27) == Act
    ParseD2Stats = statbuf
End Function
Private Function GetServer(ByVal statstring As String, ByRef Server As String) As Byte
Server = Mid$(statstring, 5, InStr(5, statstring, ",") - 5)
GetServer = InStr(5, statstring, ",") + 1
End Function
Private Function GetCharacterName(ByVal statstring As String, ByVal start As Byte, ByRef cName As String) As Byte
cName = Mid$(statstring, start, InStr(start, statstring, ",") - start)
GetCharacterName = InStr(start, statstring, ",") + 1
End Function
Private Sub MakeArray(ByVal text As String, ByRef nArray() As String)
Dim I As Long
ReDim nArray(0)
For I = 0 To Len(text)
    nArray(I) = Mid$(text, I + 1, 1)
    If I <> Len(text) Then
        ReDim Preserve nArray(0 To UBound(nArray) + 1)
    End If
Next I
End Sub
Private Sub strcpy(ByRef Source As String, ByVal nText As String)
Source = Source & nText
End Sub
Private Function GetIconTier(ByVal IconNum As Long, ByVal Race As String, Client As String) As String
    Select Case Race
        Case "H"
            If Client = "3RAW" Then
                Select Case IconNum
                    Case 1: GetIconTier = "peon"
                    Case 2: GetIconTier = "footman"
                    Case 3: GetIconTier = "knight"
                    Case 4: GetIconTier = "archmage"
                    Case 5: GetIconTier = "medivh"
                    Case Else: GetIconTier = "unknown"
                End Select
            Else
                Select Case IconNum
                    Case 1: GetIconTier = "peon"
                    Case 2: GetIconTier = "rifleman"
                    Case 3: GetIconTier = "sorceress"
                    Case 4: GetIconTier = "spellbreaker"
                    Case 5: GetIconTier = "blood Mage"
                    Case 6: GetIconTier = "jaina"
                    Case Else: GetIconTier = "unknown"
                End Select
            End If
        Case "O"
        If Client = "3RAW" Then
            Select Case IconNum
                Case 1: GetIconTier = "peon"
                Case 2: GetIconTier = "grunt"
                Case 3: GetIconTier = "tauren"
                Case 4: GetIconTier = "far seer"
                Case 5: GetIconTier = "thrall"
                Case Else: GetIconTier = "unknown"
            End Select
        Else
            Select Case IconNum
                Case 1: GetIconTier = "peon"
                Case 2: GetIconTier = "troll headhunter"
                Case 3: GetIconTier = "shaman"
                Case 4: GetIconTier = "spirit walker"
                Case 5: GetIconTier = "shadow hunter"
                Case 6: GetIconTier = "rexxar"
                Case Else: GetIconTier = "unknown"
            End Select
        End If
            
        Case "N"
        If Client = "3RAW" Then
            Select Case IconNum
                Case 1: GetIconTier = "peon"
                Case 2: GetIconTier = "archer"
                Case 3: GetIconTier = "druid of the claw"
                Case 4: GetIconTier = "priestess of the moon"
                Case 5: GetIconTier = "furion stomrage"
                Case Else: GetIconTier = "unknown"
            End Select
        Else
            Select Case IconNum
                Case 1: GetIconTier = "peon"
                Case 2: GetIconTier = "huntress"
                Case 3: GetIconTier = "druid of the talon"
                Case 4: GetIconTier = "dryad"
                Case 5: GetIconTier = "keeper of the grove"
                Case 6: GetIconTier = "maiev"
                Case Else: GetIconTier = "unknown"
            End Select
        End If
        Case "U"
        If Client = "3RAW" Then
            Select Case IconNum
                Case 1: GetIconTier = "peon"
                Case 2: GetIconTier = "ghoul"
                Case 3: GetIconTier = "abomination"
                Case 4: GetIconTier = "lich"
                Case 5: GetIconTier = "tichondrius"
                Case Else: GetIconTier = "unknown"
            End Select
        Else
            Select Case IconNum
                Case 1: GetIconTier = "peon"
                Case 2: GetIconTier = "crypt fiend"
                Case 3: GetIconTier = "banshee"
                Case 4: GetIconTier = "destroyer"
                Case 5: GetIconTier = "crypt Lord"
                Case 6: GetIconTier = "sylvanas"
                Case Else: GetIconTier = "unknown undead"
            End Select
        End If
        Case "R"
        If Client = "3RAW" Then
            Select Case IconNum
                Case 1: GetIconTier = "peon"
                Case 2: GetIconTier = "green dragon whelp"
                Case 3: GetIconTier = "blue dragon"
                Case 4: GetIconTier = "red dragon"
                Case 5: GetIconTier = "deathwing"
                Case Else: GetIconTier = "unknown"
            End Select
        Else
            Select Case IconNum
                Case 1: GetIconTier = "peon"
                Case 2: GetIconTier = "myrmidon"
                Case 3: GetIconTier = "siren"
                Case 4: GetIconTier = "dragon Turtle"
                Case 5: GetIconTier = "sea Witch"
                Case 6: GetIconTier = "illidan"
                Case Else: GetIconTier = "unknown"
            End Select
        End If
        Case "D"
        If Client = "3RAW" Then
            GetIconTier = "unknown"
        Else
            Select Case IconNum
                Case 1: GetIconTier = "peon"
                Case 2: GetIconTier = "felguard"
                Case 3: GetIconTier = "infernal"
                Case 4: GetIconTier = "doomguard"
                Case 5: GetIconTier = "pit lord"
                Case 6: GetIconTier = "archimonde"
                Case Else: GetIconTier = "unknown"
            End Select
        End If
        Case Else
            GetIconTier = "unknown"
    End Select
GetIconTier = "icon " & GetIconTier
End Function

