#include "precomp.h"
#include "nbbot.h"


boterror::boterror(const char *txt) {
	msg = newstr(txt);
};

boterror::~boterror() {
	delete msg;
}

const char *boterror::message() {
	return msg;
}



securitymanagement::~securitymanagement()
{
	if(userfile) {
		delete userfile;
	}
}

void securitymanagement::save(void)
{
	int retries = 0;
	FILE *f;
	do {
		f = _fsopen(userfile, "wt", _SH_DENYRW);
		if(!f) {
			printf("Error: %d\n", errno);
			Sleep(100);
		}
	} while(!f && retries++ < 50);
	if(!f) {
		throw boterror("User account file write error");
		return;
	}
	for(user::users.rewind(); !user::users.at_end(); ++user::users) {
		fprintf(f, "User %s %s %s\n", user::users->name, user::users->pwd1, user::users->pwd2);
		for(user::users->identities.rewind(); 
				!user::users->identities.at_end();
				++user::users->identities) {
			if(user::users->identities->loginname) {
				fprintf(f, "%s", user::users->identities->loginname);
			}
			if(user::users->identities->account != -1) {
				fprintf(f, "#%d", user::users->identities->account);
			}
			fprintf(f, "\n");
		}
		fprintf(f, "\n");
	}
	for(group::groups.rewind(); !group::groups.at_end(); ++group::groups) {
		fprintf(f, "Group %s\n", group::groups->name);
		for(group::groups->members.rewind(); 
				!group::groups->members.at_end();
				++group::groups->members) {
			fprintf(f, "%s", group::groups->members->user->name);
			if(group::groups->members->privilege != 1 || group::groups->members->resp[0]) {
				fprintf(f, " %d %s", group::groups->members->privilege, group::groups->members->resp);
			}
			fprintf(f, "\n");
		}
		fprintf(f, "\n");
	}
	time(&lastsave);
	fclose(f);
}

void securitymanagement::load(void)
{
	int retries = 0;
	FILE *f;
	do {
		f = _fsopen(userfile, "rt", _SH_DENYWR);
		if(!f) {
			Sleep(100);
		}
	} while(!f && retries++ < 50);
	if(!f) {
		throw boterror("User account file read error");
	}
	clear();
	char rad[128];
	user *curuser = 0;
	user *user;
	group *curgroup = 0;
	while(fgets(rad, 128, f)) {
		strtok(rad, "\r\n");
		if(!_strnicmp(rad, "Group ", 6)) {
			curuser = 0;
			curgroup = group::addfindgroup(rad + 6);
		} else if(!_strnicmp(rad, "User ", 5)) {
			char pw1[128], pw2[128], username[128];
			if(sscanf(rad, "User %s", username) == 1) {
				strcpy(pw1, rad + 6 + strlen(username));
				if(strchr(pw1, ' ')) {
					strcpy(pw2, strchr(pw1, ' ') + 1);
					*strchr(pw1, ' ') = 0;
				} else {
					pw2[0] = 0;
				}
				curuser = user::addfinduser(username, pw1, pw2);
			}
		} else if(rad[0] > ' ') {
			if(curuser) {
				char loginname[128];
				int account = -1;
				time_t t = time(0);
				if(sscanf(rad, "#%d %d", &account, &t) >= 1) {
					curuser->identities.add(new identity(0, account, t));
				} else if(sscanf(rad, "%[^#]#%d %d", loginname, &account, &t) >= 1) {
					curuser->identities.add(new identity(loginname, account, t));
				}
			} else if(curgroup) {
				char username[128];
				char resp[128] = "";
				int privilege = 1;
				if(sscanf(rad, "%s %d %s", username, &privilege, resp) >= 1) {
					user = user::finduser(username);
					if(user) {
						curgroup->members.add(new member(user, privilege, resp));
					}
				}
			}
		}
	}
	fclose(f);
}

void securitymanagement::timesave(void)
{
	if(time(0) - lastsave > 60) {
		save();
	}
}

void securitymanagement::clear(void)
{
	while(!user::users.is_empty()) {
		delete user::users.takefirst();
	}
	while(!group::groups.is_empty()) {
		delete group::groups.takefirst();
	}
}

void user::renameuser(char *nname)
{
	if(finduser(nname))
		return;
	delete [] name;
	name = newstr(nname);
	printf("Saving users...\n");
	secman.save();
	printf("Users saved.\n");
}

void user::mergeuser(user *otheruser)
{
	if(otheruser == this)
		return;
	while(!otheruser->identities.is_empty()) {
		identities.add(otheruser->identities.takefirst());
	}
	delete otheruser;
	printf("Saving users...\n");
	secman.save();
	printf("Users saved.\n");
}

user::~user()
{
	users.remove(this);
	while(!identities.is_empty()) {
		delete identities.takefirst();
	}
	delete [] name;
	delete [] pwd1;
	delete [] pwd2;
}

user *user::addfinduser(char *loginname, int account, bool stamp)
{
	for(users.rewind(); !users.at_end(); ++users) {
		for(users->identities.rewind(); !users->identities.at_end(); ++users->identities) {
			if( (!users->identities->loginname || !stricmp(users->identities->loginname, loginname)) &&
					(users->identities->account == -1 || users->identities->account == account)) {
				if(stamp)
					users->identities->timestamp();
				return users;
			}
		}
	}
	char name[128];
	user *newuser;
	wsprintf(name, "%s#%d", loginname, account);
	newuser = new user(name, "", "");
	if(automerge && account != 0)
		newuser->identities.add(new identity(0, account, time(0)));
	else
		newuser->identities.add(new identity(loginname, account, time(0)));
	printf("Saving users...\n");
	secman.save();
	printf("Users saved.\n");
	return newuser;
}

user *user::finduser(char *loginname, int account)
{
	for(users.rewind(); !users.at_end(); ++users) {
		for(users->identities.rewind(); !users->identities.at_end(); ++users->identities) {
			if( (!users->identities->loginname || !stricmp(users->identities->loginname, loginname)) &&
					(users->identities->account == -1 || users->identities->account == account)) {
				return users;
			}
		}
	}
	return 0;
}

user *user::addfinduser(char *n, char *p1, char *p2)
{
	for(users.rewind(); !users.at_end(); ++users) {
		if(!stricmp(n, users->name)) {
			return users;
		}
	}
	return new user(n, p1, p2);
}

int user::checkpass1(const char *p1, bool strict)
{
	if(strict && pwd1[0] == 0)
		return 0;
	return !strncmp(p1, pwd1, strlen(pwd1));
}

int user::checkpass2(const char *p2, bool strict)
{
	if(strict && pwd2[0] == 0)
		return 0;
	return !strncmp(p2, pwd2, strlen(pwd2));
}

void user::setpass1(const char *p1)
{
	delete [] pwd1;
	pwd1 = newstr(p1);
	printf("Saving users...\n");
	secman.save();
	printf("Users saved.\n");
}

void user::setpass2(const char *p2)
{
	delete [] pwd2;
	pwd2 = newstr(p2);
	printf("Saving users...\n");
	secman.save();
	printf("Users saved.\n");
}

user *user::finduser(char *n)
{
	for(users.rewind(); !users.at_end(); ++users) {
		if(!stricmp(n, users->name)) {
			return users;
		}
	}
	return 0;
}

group *group::addfindgroup(char *n)
{
	for(groups.rewind(); !groups.at_end(); ++groups) {
		if(!stricmp(n, groups->name)) {
			return groups;
		}
	}
	return new group(n);
}

group *group::findgroup(char *n)
{
	for(groups.rewind(); !groups.at_end(); ++groups) {
		if(!stricmp(n, groups->name)) {
			return groups;
		}
	}
	return 0;
}

int group::findprivilege(user *curuser)
{
	for(members.rewind(); !members.at_end(); ++members) {
		if(members->user == curuser) {
			return members->privilege;
		}
	}
	return 0;
}

void group::setprivilege(user *curuser, int privilege, const char *resp)
{
	for(members.rewind(); !members.at_end(); ++members) {
		if(members->user == curuser) {
			if(privilege > 0) {
				members->privilege = privilege;
			} else {
				member *m = members;
				members.remove(m);
				delete m;
			}
			return;
		}
	}
	if(privilege > 0)
		members.add(new member(curuser, privilege, resp));
}

List<user*> user::users;
List<group*> group::groups;



