#include "precomp.h"
#include "nbbot.h" 
#include "list.h"
#include "bancls.h"

void sendstring(char *p, int type = 0)
{
	addqueue(sb, p, type);
	plog("Auto: %s\n", p);
}


List<Channel*> Channel::channels;
List<User*> User::users;

class Channeluser {
public:
	char *name;
	char *stats;
	DWORD icon;
	DWORD lag;
	DWORD account;
	DWORD server;
	Channeluser(char *_name, char *_stats, DWORD _icon, DWORD _lag, DWORD _server, DWORD _account) {
		name = newstr(_name);
		stats = newstr(_stats);
		icon = _icon;
		lag = _lag;
		account = _account;
		server = _server;
	}
	~Channeluser() {
		delete [] name;
		delete [] stats;
	}
};


class Autoban {
public:
	char *name;
	time_t t;
	Autoban() : name(0), t(0) {};
	~Autoban() {
		if(name)
			delete [] name;
	}
};


threaded List<Channeluser*> *usershere = 0;
threaded List<Autoban*> *autobans = 0;

Ban::Ban(Userchaninfo *_banner, Userchaninfo *_banned, int _level)
{
	banned = _banned;
	banner = _banner;
	time(&t);
	expires = t + 600;
	level = _level;
}

Ban::~Ban()
{
	banned -> removebanned(this);
	banner -> removebanner(this);
}

void Channel::join(User *user)
{
	members.add(user);
}

void Channel::leave(User *user)
{
	members.remove(user);
}

int Channel::ismember(User *user)
{
	members.rewind();
	while(!members.at_end()) {
		if(user == members.get())
			return 1;
		++members;
	}
	return 0;
}

Userchaninfo::Userchaninfo(User *_user, Channel *_channel)
{
	channel = _channel;
	user = _user;
	time(&lastjoin);
	banlevel = -2; // Three bans required for ban
	lastleave = lastspoke = 0;
}

Userchaninfo::~Userchaninfo()
{
	banner.rewind();
	while(!banner.is_empty()) {
		Ban *ban;
		ban = banner.get();
		delete ban;
	}
	banned.rewind();
	while(!banned.is_empty()) {
		Ban *ban;
		ban = banned.get();
		delete ban;
	}
	user -> removechaninfo(this);
}

void Userchaninfo::removebanned(Ban *ban)
{
	banned.remove(ban);
}

void Userchaninfo::removebanner(Ban *ban)
{
	banner.remove(ban);
}

Userchaninfo *User::uci(Channel *channel)
{
	channelinfos.rewind();
	while(!channelinfos.at_end()) {
		if(channelinfos.get() -> channel == channel)
			return channelinfos.get();
		++channelinfos;
	}
	Userchaninfo *p = new Userchaninfo(this, channel);
	channelinfos.add(p);
	return p;
}

void User::settype(char *stats)
{
	type = OTHER;
	if(!memcmp(stats, "TAHC", 4))
		type = CHAT;
	else if(!memcmp(stats, "LTRD", 4))
		type = DRTL;
	else if(!memcmp(stats, "RATS", 4))
		type = STAR;
}

User::User(char *name)
{
	char *p;
	p = new char[strlen(name) + 1];
	strcpy(p, name);
	names.add(p);
	users.add(this);
	type = CHAT;
}

Ban *Userchaninfo::findban(Userchaninfo *banuci)
{
	banner.rewind();
	while(!banner.at_end()) {
		if(banner.get() -> banned == banuci)
			return banner.get();
		++banner;
	}
	return 0;
}

void User::removechaninfo(Userchaninfo *uci)
{
	channelinfos.remove(uci);
}

int User::ban(Channel *channel, User *banuser)
{
	Ban *p;
	Userchaninfo *p1, *p2;
	p1 = uci(channel);
	p2 = banuser -> uci(channel);
	int prevlevel = p2 -> banlevel;
	p = p1 -> findban(p2);
	if(!p) {
		p = new Ban(p1, p2, 1);
		p1 -> banner.add(p);
		p2 -> banned.add(p);
		p2 -> banlevel++;
	}
	if(p->level < 0) {
		p -> level = -p -> level;
		p2 -> banlevel += 2 * p -> level;
	}
	return prevlevel <= 0 && p2 -> banlevel > 0;
}

int User::unban(Channel *channel, User *banuser)
{
	Ban *p;
	Userchaninfo *p1, *p2;
	p1 = uci(channel);
	p2 = banuser -> uci(channel);
	int prevlevel = p2 -> banlevel;
	p = p1 -> findban(p2);
	if(!p) {
		p = new Ban(p1, p2, -1);
		p1 -> banner.add(p);
		p2 -> banned.add(p);
		p2 -> banlevel--;
	}
	if(p->level > 0) {
		p -> level = -p -> level;
		p2 -> banlevel += 2 * p -> level;
	}
	return prevlevel > 0 && p2 -> banlevel <= 0;
}

void User::removebans(Channel *channel)
{
	Userchaninfo *p;
	p = uci(channel);
	p->banner.rewind();
	while(!p->banner.is_empty()) {
		Ban *b = p->banner.get();
		Userchaninfo *p2;
		p2 = b->banned;
		int oldlevel = p2 -> banlevel;
		p2 -> banlevel -= b->level;
		if(oldlevel > 0 && p2->banlevel <= 0) { // unban
			char command[1000];
			char *name;
			name = p2->user->names.getfirst();
			sprintf(command, "/unban %s", name);
			sendstring(command);
			sprintf(command, "/w %s You were unbanned", name);
			sendstring(command);
		}
		if(oldlevel <= 0 && p2->banlevel > 0) { // ban
			char command[1000];
			char *name;
			name = p2->user->names.getfirst();
			sprintf(command, "/ban %s (voted)", name);
			sendstring(command);
			sprintf(command, "/w %s Type \"/w %s unbanme\" to request an unban", name, myname);
			sendstring(command);
		}
		delete b;
	}
}

User::~User()
{
	users.remove(this);
	while(!names.is_empty()) {
		delete names.get();
	}
	while(!channelinfos.is_empty()) {
		delete channelinfos.get();
	}
}

Channel::Channel(char *_name)
{
	name = new char[strlen(_name) + 1];
	strcpy(name, _name);
	channels.add(this);
}

Channel::~Channel()
{
	channels.remove(this);
	delete name;
}

Channel *Channel::find(char *_name)
{
	channels.rewind();
	while(!channels.at_end()) {
		if(!stricmp(_name, channels.get() -> name))
			return channels.get();
		++channels;
	}
	return 0;
}

User *User::find(char *_name)
{
	users.rewind();
//	plog("Searching for user %s\n", _name);
	while(!users.at_end()) {
		User *pu;
		pu = users.get();
		pu -> names.rewind();
		while(!pu -> names.at_end()) {
//			plog("Checking name %s ?= %s\n", _name, pu -> names.get());
			if(!stricmp(_name, pu -> names.get()))
				return pu;
			++(pu -> names);
		}
		++users;
	}
	return 0;
}

threaded Channel *channel = 0;
threaded int votetime = 0;



void processbans(int type, char *user, char *txt)
{
	if(type == 7) {
		channel = Channel::find(txt);
	}
	if(!channel)
		return;
	User *curuser = User::find(user);
	User *banuser = 0;
	if(!curuser) {
		curuser = new User(user);
	}
//	plog("Checking user named %s\n", curuser -> names.get());
	char command[1000];
	switch(type) {
	case 1: // already in channel
	case 2: // join
		channel->join(curuser);
		curuser->settype(txt);
		if(curuser->uci(channel)->banlevel > 0) {
			char command[128];
			sprintf(command, "/ban %s (voted)", user);
			sendstring(command);
			sprintf(command, "/w %s Type \"/w %s unbanme\" to request an unban", user, myname);
			sendstring(command);
		}
		break;
	case 3: // leave
		channel->leave(curuser);
		curuser->removebans(channel);
		break;

//	case 5: // talk
	case 4: // whisper
		if(votetime < time(0)) {
			if(!memcmp(txt, "voteban ", 8)) {
				if(curuser->type == User::CHAT)
					break;
				if(!channel->ismember(curuser)) {
					plog("User out of channel attempting voteban");
					break;
				}
				plog("try voteban");
				banuser = User::find(txt + 8);
				if(banuser) {
					if(curuser->ban(channel, banuser)) {
						sprintf(command, "/ban %s (voted)", txt+8);
						sendstring(command);
						sprintf(command, "/w %s Type \"/w %s unbanme\" to request an unban", txt+8, myname);
						sendstring(command);
					}
					sprintf(command, "/w %s %s votes to ban you", txt + 8, user);
					sendstring(command);
				}
			} else if(!memcmp(txt, "voteunban ", 10)) {
				if(curuser->type == User::CHAT)
					break;
				if(!channel->ismember(curuser)) {
					plog("User out of channel attempting voteunban");
					break;
				}
				plog("try voteunban");
				banuser = User::find(txt + 10);
				if(banuser) {
					if(curuser->unban(channel, banuser)) {
						sprintf(command, "/unban %s", txt+10);
						sendstring(command);
						sprintf(command, "/w %s You were unbanned", txt+10);
						sendstring(command);
					}
					sprintf(command, "/w %s %s votes not to ban you", txt + 10, user);
					sendstring(command);
				}
			} else if(!stricmp(txt, "unbanme")) {
				plog("try unbanme");
				if(curuser->uci(channel)->banlevel <= 0) {
					sprintf(command, "/unban %s", user);
					sendstring(command);
					sprintf(command, "/w %s You were unbanned", user);
					sendstring(command);
				}
			}
		}
			
		if(!memcmp(txt, "help", 5)) {
			sprintf(command, "/w %s \"voteban <user>\", \"voteunban <user>\", \"votes <user>\", \"unbanme\", \"help\". All commands are talked except \"unbanme\"", user, txt+6);
			sendstring(command);
		} else if(!memcmp(txt, "votes ", 6)) {
			plog("try vote status");
			banuser = User::find(txt + 6);
			if(banuser) {
				char command1[1000], command2[1000];
				Userchaninfo *p = banuser -> uci(channel);
				sprintf(command1, "/w %s [%d]For ban(%s): ", user, p->banlevel, txt+6);
				sprintf(command2, "/w %s Against ban(%s): ", user, txt+6);
				p->banned.rewind();
				while(!p->banned.at_end()) {
					Ban *b = p->banned.get();
					if(b->level > 0) {
						strcat(command1, b->banner->user->names.getfirst());
						strcat(command1, " ");
					} else {
						strcat(command2, b->banner->user->names.getfirst());
						strcat(command2, " ");
					}
					++(p->banned);
				}
				sendstring(command1);
				sendstring(command2);
			}
		}
		break;
	case 7: // channel
		break;
	}
}


int processcommand(char *username, char *command, char **inserts, user *&curuser, int ownprivilege) // returns true if cmdlist changed
{
	char outstr[250];
	if(!memcmp(command, ":listgroup ", 11)) {
		char gname[32];
		int total=0;
		if(sscanf(command, ":listgroup %30s", gname) == 1) {
			group *group = group::findgroup(gname);
			if(group) {
				group->members.rewind();
				sprintf(outstr, "/w %s %s: {", username, group->name);
				while(!group->members.at_end()) {
					strcat(outstr, group->members->user->Name());
					if(group->members->privilege != 1) {
						sprintf(outstr + strlen(outstr), " [%d]", group->members->privilege);
					}
					++group->members;
					if(group->members.at_end()) {
						total++;
						sprintf(outstr + strlen(outstr), "} %d total", total);
						sendstring(outstr);
					} else {
						total++;
						strcat(outstr, ", ");
						if(strlen(outstr) > 200) {
							sendstring(outstr);
							sprintf(outstr, "/w %s ", username);
						}
					}
				}
			} else {
				sprintf(outstr, "/w %s Group %s does not exist.", username, gname);
				sendstring(outstr);
			}
		}
		return 1;
	}
	if(!memcmp(command, ":listalias ", 11)) {
		char uname[32];
		int total=0;
		if(sscanf(command, ":listalias %30s", uname) == 1) {
			user *user = user::finduser(uname);
			if(user) {
				user->identities.rewind();
				sprintf(outstr, "/w %s %s: {", username, user->Name());
				while(!user->identities.at_end()) {
					if(user->identities->loginname)
						strcat(outstr, user->identities->loginname);
					if(user->identities->account != -1) {
						sprintf(outstr + strlen(outstr), " #%d", user->identities->account);
					}
					++user->identities;
					if(user->identities.at_end()) {
						total++;
						sprintf(outstr + strlen(outstr), "} %d total", total);
						sendstring(outstr);
					} else {
						total++;
						strcat(outstr, ", ");
						if(strlen(outstr) > 200) {
							sendstring(outstr);
							sprintf(outstr, "/w %s ", username);
						}
					}
				}
			} else {
				sprintf(outstr, "/w %s User %s does not exist.", username, uname);
				sendstring(outstr);
			}
		}
		return 1;
	}
	if(!memcmp(command, ":setuserrank ", 13)) {
		char uname[32], gname[32];
		int priv = 1;
		if(sscanf(command, ":setuserrank %30s %30s %d", uname, gname, &priv) >= 2) {
			group *group = group::findgroup(gname);
			user *user = user::finduser(uname);
			if(group && user) {
				int userprivilege = group->findprivilege(user);
				int ownprivilege = group->findprivilege(curuser);
				if(ownprivilege > userprivilege && ownprivilege > priv && priv >= 0 && ownprivilege > 1) {
					group->setprivilege(user, priv, curuser->Name());
					sprintf(outstr, "/w %s %s: {%s[%d]}", username, gname, uname, priv);
					sendstring(outstr);
				}
			} else {
				sprintf(outstr, "/w %s Group %s or user %s does not exist.", username, gname, uname);
				sendstring(outstr);
			}
		}
		secman.load();
		return 1;
	}
	if(!memcmp(command, ":setpass1 ", 10)) {
		char pwd1[32] = "";
		sscanf(command, ":setpass1 %30s", pwd1);
		curuser->setpass1(pwd1);
		sprintf(outstr, "/w %s password 1 changed", username);
		sendstring(outstr);
	}
	if(!memcmp(command, ":setpass2 ", 10)) {
		char pwd2[32] = "";
		sscanf(command, ":setpass2 %30s", pwd2);
		curuser->setpass2(pwd2);
		sprintf(outstr, "/w %s password 2 changed", username);
		sendstring(outstr);
	}
	if(!memcmp(command, ":joinuser ", 10)) {
		char pwd2[32], uname[32];
		if(sscanf(command, ":joinuser %30s %30s", uname, pwd2) == 2) {
			user *otheruser = user::finduser(uname);
			if(otheruser && otheruser->checkpass2(pwd2, true)) {
				otheruser->mergeuser(curuser);
				curuser = otheruser;
				sprintf(outstr, "/w %s merged", username);
				sendstring(outstr);
			}
		}
	}
	if(!memcmp(command, ":renameuser ", 12)) {
		char uname[32];
		if(sscanf(command, ":renameuser %30s", uname) == 1) {
			if(!user::finduser(uname)) {
				curuser->renameuser(uname);
				sprintf(outstr, "/w %s renamed", username);
				sendstring(outstr);
			}
		}
	}
	if(!strcmp(command, ":quit"))
		exit(0);
	if(!memcmp(command, ":novote ", 8)) {
		votetime = time(0) + atoi(command + 8);
	}
	if(!memcmp(command, ":reconnect", 10)) {
		state=DISCONNECTED;
	}
	if(!memcmp(command, ":config ", 8)) {
		strcpy(config, command+8);
		plog("Setting config to %s\n", config);
		loadconfig();
		return 1;
	}
	if(!memcmp(command, ":mkick ", 7)) {
		char *str = new char[strlen(command + 7) + 1];
		strcpy(str, command + 7);
		strtok(str, " ");
		char buf[512];
		for(char *p = strtok(0, " ");
				p;
				p = strtok(0, " ")) {
			strcpy(buf, "/kick ");
			strcat(buf, p);
			strcat(buf, " mass kick");
			sendstring(buf);
		}
		delete [] str;
	}
	if(!memcmp(command, ":autoban ", 9) && strlen(command) > 9 && command[9] != ' ') {
		char *p = new char[strlen(command + 9) + 1];
		strcpy(p, command + 9);
		strtok(p, " ");
		autobans->rewind();
		while(!autobans->at_end()) {
			if(!stricmp(p, autobans->get()->name)) {
				break;
			}
			++*autobans;
		}
		if(autobans->at_end()) {
			char tmp[512];
			wsprintf(tmp, "/ban %s Auto-ban", command+9);
			sendstring(tmp);
			Autoban *pa;
			pa = new Autoban;
			pa->name = p;
			time(&pa->t);
			autobans->add(pa);
			return 0;
		} else {
			delete [] p;
		}
	}
	if(!memcmp(command, ":autounban ", 11) && strlen(command) > 11 && command[11] != ' ') {
		char *p = new char[strlen(command + 11) + 1];
		strcpy(p, command + 11);
		strtok(p, " ");
		Autoban *pa;
		autobans->rewind();
		while(!autobans->at_end()) {
			pa = autobans->get();
			if(!stricmp(p, pa->name)) {
				autobans->remove(pa);
				delete pa;
				char tmp[512];
				wsprintf(tmp, "/me removed %s from auto-ban", p);
				sendstring(tmp);
				break;
			}
			++*autobans;
		}
		delete [] p;
		return 0;
	}
	if(!strcmp(command, ":oprejoin")) {
		usershere->rewind();
		if(usershere->get_count() == 1 && !(usershere->get()->icon & 2)) {
			plog("Rejoining to get op\n");
			sendstring("/rejoin");
		}
	}
	if(!memcmp(command, ":makeuser", 9)) {
		char makename[1024], makepw[1024], createnam[1024];
		if(sscanf(command, ":makeuser %s %s %s", createnam, makename, makepw) == 3) {
			createname = new char[strlen(createnam)+1];
			strcpy(createname, createnam);
			plog("Trying to make user %s pw %s\n", makename, makepw);
			unsigned long tohash[5];
			calchashbuf(tohash, makepw, strlen(makepw));
			add(tohash, 5*4);
			add(makename);
			sendpacket(0x2a);
		}
	}
	if(!memcmp(command, ":setprof ", 9)) {
		strtok(command, " ");
		char *prof, *val, *name;
		name = strtok(0, " ");
		prof = strtok(0, " ");
		val = strtok(0, "\r\n");
		add(1);
		add(1);
		add(name);
		add(prof);
		add(val);
		sendpacket(0x27);
	}
	if(!memcmp(command, ":ruingame ", 10)) {
		add(0);			// Level range
		add(0);
		add(0);
		add(1);			// Number of games to find
		add(command+10);
		add("");
		add("");
		sendpacket(0x9);
		gameop = RUIN;
		strcpy(gamename, command+10);
	}
	if(!memcmp(command, ":ruinall ", 9)) {
		add(atoi(command+9));			// Level range
		if(command[9] == '*')
			add(0);
		else
			add(0xffff);
		add(0);
		add(250);			// Number of games to find
		add("");
		add("");
		add("");
		sendpacket(0x9);
		gameop = RUIN;
		strcpy(gamename, "\x1");
	}
	if(!memcmp(command, ":make ", 6)) {
		add(0);	// 1 = password protected
		add(5);
		add(0);
		add(0xf);
		add(0);
		add(6112);
		add(command+5);
		add("");
		add("0\r", 2);
		add(username, strlen(username));
		add("\r", 1);
		add(statstring);
		sendpacket(0x1a);
	//	sendpacket(0x8);
		sendpacket(0x10);
	}
	if(!memcmp(command, ":leave", 6)) {
		sendpacket(2);
		add(username);
		add(statstring);
		sendpacket(0xa);
		add(type, 4);
		sendpacket(0xb);
		add(2);			// 1 = add SWE-1, 2 = use as is
		add(homechannel);
		sendpacket(0xc);
	}
	if(!memcmp(command, ":joingame ", 10)) {
		add(0);			// Level range
		add(0);
		add(0);
		add(1);			// Number of games to find
		add(command+10);
		add("");
		add("");
		sendpacket(0x9);
		gameop = JOIN;
		strcpy(gamename, command+10);
	}
	if(!memcmp(command, ":passgame ", 10)) {
		if(strchr(command+10, ' ')) {
			char *pass=strchr(command+10, ' ');
			*pass++=0;
			add(0);			// Level range
			add(0);
			add(0);
			add(1);			// Number of games to find
			add(command+10);
			add(pass);
			add("");
			sendpacket(0x9);
			gameop = JOIN;
			strcpy(gamename, command+10);
		}
	}
	if(!memcmp(command, ":listgame ", 10)) {
		add(atoi(command+10));			// Level range
		add(0xffff);
		add(0);
		add(20);			// Number of games to find
		add("");
		add("");
		add("");
		sendpacket(0x9);
	}
	if(!memcmp(command, ":scanf ", 7)) {
		int base = 0, expect = 0, c = 0;
		char finder[256];
		if(sscanf(command, ":scanf %d %d %[^&]", &base, &expect, finder) == 3 && strchr(command, '&')) {
			if((c = sscanf(strchr(command, '&') + 1, 
					finder, 
					inserts[base + 10],
					inserts[base + 11],
					inserts[base + 12],
					inserts[base + 13],
					inserts[base + 14],
					inserts[base + 15],
					inserts[base + 16],
					inserts[base + 17],
					inserts[base + 18],
					inserts[base + 19])) != expect) {
				return 1;
			}
		}
	}
	if(!memcmp(command, ":roll ", 6)) {
		int n, m;
		if(sscanf(command, ":roll %dd%d", &n, &m) == 2) {
			if(n > 0 && m > 0 && n < 100) {
				if(inserts[7])
					delete [] inserts[7];
				inserts[7] = new char[10 * n + 1];
				inserts[7][0] = 0;
				while(n--) {
					sprintf(inserts[7] + strlen(inserts[7]), "%d ", (rand() % m) + 1);
				}
			}
		}
		printf("%s\n", command);
	}
	if(!memcmp(command, ":random ", 8)) {
		char *p = command;
		int i = 1;
		while(p = strchr(p, '|')) {
			i++, p++;
		}
		int j = rand() % i;
		p = command + 8;
		while(j--) {
			p = strchr(p, '|') + 1;
		}
		char *o, *q, *buf;
		o = strchr(p, '|');
		if(!o) 
			o = p + strlen(p);
		q = new char[o - p + 1];
		memcpy(q, p, o - p);
		q[o - p] = 0;
		if(
			FormatMessage(
				FORMAT_MESSAGE_ALLOCATE_BUFFER|
				FORMAT_MESSAGE_FROM_STRING|
				FORMAT_MESSAGE_ARGUMENT_ARRAY,
				q,
				0, 0,
				(char*)&buf,
				100,
				inserts)) {
			if(buf[0] == ':') {
				if(processcommand(username, buf, inserts, curuser, ownprivilege)) {
					LocalFree(buf);
					return 1;
				}
			} else 
				sendstring(buf);
			LocalFree(buf);
		} else 
			plog("Error %d in FormatMessage\n", GetLastError());
	}
	return 0;
}

void processuserlist(int type, char *user, char *txt, DWORD *params)
{
	Channeluser *cu = 0;
	Channeluser *p = 0;
	if(!usershere)
		usershere = new List<Channeluser*>;
	usershere->rewind();
	while(!usershere->at_end()) {
		p = usershere->get();
		if(!strcmp(p->name, user) && p->server == params[3] && p->account == params[4]) {
			cu = p;
		}
		++*usershere;
	}
	switch(type) {
	case 1:
	case 2:
		{
			if(cu) {
				plog("Note multiple users with same info in channel\n");
			}
			usershere->add(p = new Channeluser(user, txt, params[0], params[1], params[3], params[4]));
			group *desgroup = group::findgroup(designategroup);
			if(desgroup && currentdesignatepriority >= 0) {
				class user *desuser = user::finduser(p->name, p->server?p->account:0);
				int priority = desgroup->findprivilege(desuser);
				if((priority > currentdesignatepriority || priority <= topdesignatepriority && currentdesignatepriority > topdesignatepriority) && (priority <= topdesignatepriority || currentdesignatepriority == 0) && !(p->icon & 3) && p!=cu) {
					currentdesignatepriority = priority;
					currentdesignate = p;
					char tmp[50];
					printf("Designate %s on join, priority %d\n", currentdesignate->name, priority);
					sprintf(tmp, "/designate %s", currentdesignate->name);
					sendstring(tmp);
				}
			}
		}
		break;
	case 3:
		if(!cu) {
			plog("User leaving that wasn't in channel?\n");
		} else {
			if(currentdesignate == cu) {
				currentdesignate = 0;
				currentdesignatepriority = 0;
				group *desgroup = group::findgroup(designategroup);
				if(desgroup) {
					usershere->rewind();
					while(!usershere->at_end()) {
						p = usershere->get();
						class user *desuser = user::finduser(p->name, p->server?p->account:0);
						int priority = desgroup->findprivilege(desuser);
						if((priority > currentdesignatepriority || priority <= topdesignatepriority && currentdesignatepriority > topdesignatepriority) && (priority <= topdesignatepriority || currentdesignatepriority == 0) && !(p->icon & 3) && p!=cu) {
							currentdesignatepriority = priority;
							currentdesignate = p;
						}
						++*usershere;
					}
				}
				if(currentdesignate) {
					char tmp[50];
					sprintf(tmp, "/designate %s", currentdesignate->name);
					sendstring(tmp);
				}
			}
			usershere->remove(cu);
			delete cu;
		}
		usershere->rewind();
		if(usershere->get_count() == 1 && !(usershere->get()->icon & 2)) {
			plog("Rejoining to get op\n");
			sendstring("/rejoin");
		}
		break;
	case 7:
		plog("Clearing userlist\n");
		currentdesignate = 0;
		currentdesignatepriority = -1;
		usershere->rewind();
		while(!usershere->is_empty()) {
			Channeluser *p = usershere->get();
			usershere->remove(p);
			delete p;
		}
		break;
	case 9:
		if(cu) {
			cu->icon = params[0];
		}
		if(!stricmp(myname, p->name) && (params[0] & 3)) {
			if(currentdesignate == 0) {
				currentdesignatepriority = 0;
				group *desgroup = group::findgroup(designategroup);
				if(desgroup) {
					usershere->rewind();
					while(!usershere->at_end()) {
						p = usershere->get();
						class user *desuser = user::finduser(p->name, p->server?p->account:0);
						int priority = desgroup->findprivilege(desuser);
						if((priority > currentdesignatepriority || priority <= topdesignatepriority && currentdesignatepriority > topdesignatepriority) && (priority <= topdesignatepriority || currentdesignatepriority == 0) && !(p->icon & 3) && p!=cu) {
							currentdesignatepriority = priority;
							currentdesignate = p;
						}
						++*usershere;
					}
				}
				if(currentdesignate) {
					char tmp[50];
					sprintf(tmp, "/designate %s", currentdesignate->name);
					sendstring(tmp);
				}
			}
		}
	}
}


void process(int type, char *user, char *txt, DWORD *params)
{
	static int first = 1;
	if(first) {
		new Channel("Cheaters");
		new Channel("Hackers");
		new Channel("Cheaters2");
		new Channel("Legit");
		first = 0;
	}
	
	if(stickyhome && type == 7 && stricmp(txt, "the void")) {
		strcpy(homechannel, txt);
	}

	if(votes) 
		processbans(type, user, txt);
	
	processuserlist(type, user, txt, params);

	if(!autobans)
		autobans = new List<Autoban*>;
	
	if(type == 2) {
		autobans->rewind();
		while(!autobans->at_end()) {
			Autoban *pa = autobans->get();
			if(pa->t < time(0) - 60*60) {
				autobans->remove(pa);
				delete pa;
				break;
			}
			if(!stricmp(user, pa->name)) {
				char tmp[512];
				wsprintf(tmp, "/ban %s Auto-ban", user);
				sendstring(tmp);
				break;
			}
			++*autobans;
		}
	}

	
	cmd *p;
	char *buf;
	char userref[64], txtref[1024];
	char *inserts[40];
	char ip[20];
	char acc[20];
	if(params[3]) {
		char *p = inet_ntoa(*(in_addr*)&params[3]);
		if(p) 
			strcpy(ip, p);
		else
			ip[0] = 0;
		wsprintf(acc, "#%d", params[4]);
	} else {
		char *p = inet_ntoa(*(in_addr*)&params[4]);
		if(p) 
			strcpy(ip, p);
		else
			ip[0] = 0;
		acc[0] = 0;
	}
	sprintf(userref, "\"%.60s\"", user);
	sprintf(txtref, "\"%.1020s\"", txt);
	CharUpper(userref);
	CharUpper(txtref);
	inserts[0] = user;
	inserts[1] = txt;
	inserts[3] = myname;
	inserts[4] = inet_ntoa(rsin.sin_addr);
	inserts[5] = config;
	inserts[6] = homechannel;
	inserts[7] = new char[1]; // Dice
	inserts[7][0] = 0;
	inserts[8] = ip;
	inserts[9] = acc;
	int i;
	for(i = 10; i < 20 ; i++) {
		inserts[i] = new char[256];
		inserts[i][0] = 0;
	}
	class user *curuser = user::addfinduser(user, params[3]?params[4]:params[3], true);
	secman.timesave();
	inserts[20] = const_cast<char*>(curuser->Name());
	for(p = head; p; p = p->next) {
	//	plog("Checking %d \"%s\" \"%s\" = %d \"%s\" \"%s\"\n", type, userref, txtref, p->type, p->user, p->txt);
		int userprivilege = 0;
		if(p->type != type)
			continue;
		if(!p->user || (p->user[0] != '$' && p->user[0] != '' && p->user[0] != '@')) {
			if(!(p->account == -1 || (DWORD)p->account == params[3] || (DWORD)p->account == params[4]) ||
					!(!p->user || strstr(userref, p->user))) 
				continue;
		} else {
			char sname[128] = "";
			int privilege = 0;
			char match = '>';
			char pwdcheck;
			if(sscanf(p->user, "%c%[^><=]%c%d", &pwdcheck, sname, &match, &privilege) < 1)
				continue;
			switch(pwdcheck) {
			case '$':
				if(!curuser->checkpass1(txt))
					continue;
				break;
			case '':
				if(!curuser->checkpass2(txt))
					continue;
				break;
			}
			if(sname[0]) {
				group *group = group::findgroup(sname);
				if(group) {
					userprivilege = group->findprivilege(curuser);
					if(match == '<' && userprivilege >= privilege ||
							match == '>' && userprivilege <= privilege ||
							match == '=' && userprivilege != privilege)
						continue;
				} else {
					continue;
				}
			}
		}
		if(p->txt && !strstr(txtref, p->txt))
			continue;
		inserts[2] = txt;
		if(p->txt) {
			inserts[2] += strstr(txtref, p->txt)-txtref + strlen(p->txt)-1;
		}
		if(
			FormatMessage(
				FORMAT_MESSAGE_ALLOCATE_BUFFER|
				FORMAT_MESSAGE_FROM_STRING|
				FORMAT_MESSAGE_ARGUMENT_ARRAY,
				p->command,
				0, 0,
				(char*)&buf,
				100,
				inserts)) {
			if(buf[0] == ':') {
				if(processcommand(user, buf, inserts, curuser, userprivilege)) {
					LocalFree(buf);
					break;
				}
			} else 
				sendstring(buf);
			LocalFree(buf);
		} else 
			plog("Error %d in FormatMessage\n", GetLastError());
		if(!p->repeat)
			break;
	}
	delete [] inserts[7];
	for(i = 10; i < 20 ; i++) 
		delete [] inserts[i];
}
