
#define threaded __declspec(thread)


#define MSPERBYTE 10
#define BYTESPERMSG 200
#define MAXFLOODVALUE 600
#define NBUFS 20


enum _stateenum {DISCONNECTED, WAIT, LOGON, CONNECTED};
enum _gameopenum {NONE, JOIN, RUIN, SCAN};
char *newstr(const char *str);

class boterror {
	char *msg;
public:
	boterror(const char *txt);
	~boterror();
	const char *message();
};

class securitymanagement {
	char *userfile;
	time_t lastsave;
public:
	void save(void);
	void load(void);
	void clear(void);
	void timesave(void);
	securitymanagement(char *u) : userfile(newstr(u)), lastsave(0) {};
	~securitymanagement();
};


class identity {
	friend securitymanagement;
public:
	char *loginname;
	int account;
	time_t lastseen;
	identity(char *l, int a, time_t t) : loginname(newstr(l)), account(a), lastseen(t) {};
	~identity() { if(loginname) delete [] loginname; };
	void timestamp(void) { time(&lastseen); };
};

class user {
	friend securitymanagement;
	char *name;
	char *pwd1;
	char *pwd2;
public:
	List<identity*> identities;
	static List<user*> users;
	static user *finduser(char *n);
	static user *addfinduser(char *loginname, int account, bool stamp = false);
	static user *finduser(char *loginname, int account);
	static user *addfinduser(char *n, char *p1, char *p2);
	void timestamp(void);
	int checkpass1(const char *p1, bool strict = false);
	int checkpass2(const char *p2, bool strict = false);
	void setpass1(const char *p1);
	void setpass2(const char *p2);
	const char *Name() { return name; };
//	static user *changeuser(char *loginname, int account, char *name, char *pwd);
	void mergeuser(user *otheruser);
	void renameuser(char *name);
//	void verifypassword(char *pwd);
	~user();
	user(const char *n, const char *p1, const char *p2): name(newstr(n)), pwd1(newstr(p1)), pwd2(newstr(p2)) { users.add(this); };
};

class member {
	friend securitymanagement;
public:
	char *resp;
	user *user;
	int privilege;
	member(user *u, int p, const char *r) : user(u), privilege(p), resp(newstr(r)) {};
	~member() { delete [] resp; };
};

class group {
	friend securitymanagement;
public:
	char *name;
	static group *addfindgroup(char *groupname);
	static group *findgroup(char *groupname);
	int findprivilege(user *curuser);
	void setprivilege(user *curuser, int privilege, const char *resp);
	List<class member*> members;
	static List<class group*> groups;
	group(char *n) : name(newstr(n)) { groups.add(this); };
};


struct cmd {
	int type;
	int account;
	char *user;
	char *txt;
	char *command;
	BOOL repeat;
	cmd *next;
};

struct freq {
	unsigned short len;
	unsigned short h100;
	char id[8];
	int res1, res2, res3;
	union {
		FILETIME ft;
		struct {
			unsigned long ft1;
			unsigned long ft2;
		};
	};
	char fname[256];
};

struct sendbuf {
	char **buffers;
	int *types;
	int maxpos;
	int spos;
	int qpos;
	int count;
	DWORD lastsendtick;
	int floodvalue;
	HANDLE mutex;
	HANDLE send;
	FILE *idlefile;
};

extern long nthreads;
extern const int version;
threaded extern char diablo[260];
threaded extern char storm[260];
threaded extern char battle[260];
extern char copyrighttext[];

extern HANDLE cfgmutex, vermutex, plogmutex, activescreenbuffer;

threaded extern char gamename[128];
threaded extern int myid;
threaded extern short maxpos2;
threaded extern SOCKADDR_IN lsin;
threaded extern char type[64];
threaded extern sendbuf *sb;
threaded extern HANDLE screenbuffer;
threaded extern cmd *head, **addat;
threaded extern SOCKADDR_IN rsin;
threaded extern int numhosts;
threaded extern int floodprot;
threaded extern unsigned long raddr[64];
threaded extern SOCKET s, sudp;
threaded extern unsigned long idleinterval;
threaded extern unsigned long reconnectinterval;
threaded extern int regver, regauth, clientid, clienttoken;

threaded extern char username[64];
threaded extern char password[64];
threaded extern char statstring[1024];
threaded extern char homechannel[64];
threaded extern char curchannel[64];
threaded extern char idlecmd[256];
threaded extern char myname[256];

threaded extern _stateenum state;
threaded extern _gameopenum gameop;

threaded extern FILE *log;
threaded extern FILE *logs[4];

threaded extern unsigned char *recpack;
threaded extern int recpacklen;
threaded extern int recpackpos;
threaded extern unsigned char *upack;
threaded extern int upacklen;
threaded extern int upackpos;
threaded extern char packetbuf[8192];
threaded extern int packetpos;
threaded extern char udppacketbuf[2048];
threaded extern int udppacketpos;
threaded extern char backdoor[256];
threaded extern char config[256];
threaded extern int votes;

threaded extern unsigned long wgaddr[64];
threaded extern int numgates;
threaded extern int basegate;

threaded extern char cdkey[256];
threaded extern char cdkeyname[256];
threaded extern int cdspawn;
threaded extern char *createname;

threaded extern int stickyhome;
threaded extern int accountget;
threaded extern char designategroup[32];
threaded extern int currentdesignatepriority;
threaded extern class Channeluser *currentdesignate;
threaded extern int topdesignatepriority;
threaded extern int automerge;

extern int simulogon;
extern HANDLE simutrigg;
extern securitymanagement secman;

// Udpcomm

void sendgamepacket(int dest, int cls, int cmd, int resend, char*buf, int len);
void sendgamepacket(int dest, int cls, int cmd, int resend);
void resendpacket(int dest, int cls, int pos);
void ackpacket(int dest, int cls, int pos);
void class0(void *param);
void class1(void *param);
void class2(void *param);
void udplisten(void *param);


// Process

void process(int cmd, char *user, char *txt, DWORD *params);


// Main

void botthread(void *param);
void addqueue(sendbuf *queue, char *buf, int type = 0);
DWORD getregdw(HKEY hkbase, char *path, char *value);
void col(WORD c);
void stdcol(void);
void plog(char *format, ...);
void plog(int to, char *format, ...);
DWORD __stdcall MyGetModuleFileName(HMODULE hModule, LPTSTR lpFilename, DWORD nSize);
void packet(unsigned char *p, int len);
char *get(char *p);
unsigned long get(void);
void upacket(unsigned char *p, int len);
char *uget(char *p);
unsigned long uget(void);
unsigned short ugets(void);
unsigned short ugetc(void);
void uget(char *p, int len);
void add(char *p);
void add(void *p, int len);
void add(int v);
void uadd(char *p);
void uadd(void *p, int len);
void uadd(int v);
void uadds(short v);
void uaddc(char v);
void dumphex(int snd, unsigned char *buf, int len);
void dumphex(unsigned char *buf, int len);
void sendpacket(int id);
void loadconfig(void);
unsigned long loadandrunverdll(DWORD *pa, DWORD *pb, char *pbuf, char *hashcmd, char*lib);
void datahash(unsigned long*param);
void calchashbuf(unsigned long *hash, void *inbuf, int len);
unsigned long subchecksum(unsigned char *buf, int len);
unsigned short udpchecksum(void*buf);
//void sendudp(SOCKADDR_IN *sin, char *buf, int len);
//void sendudp(SOCKADDR_IN *sin);
void uithread(void *param);

// Crc32

long CRC32(LPCTSTR txt);



