#include "List.h"
//#include "Listexcept.hh"

template <class T>
List<T>::List() 
{
	head = pos = 0;
	count = 0;
}

template <class T>
List<T>::~List()
{
	while (head) {
		pos = head -> next;
		delete head;
		head = pos;
	}
}

template <class T>
void List<T>::rewind()
{
	pos = head;
}

template <class T>
void List<T>::operator ++()
{
	if (pos) {
		pos = pos -> next;
	} else {
//		throw List_error("Moving past end of list");
	}
}

template <class T>
int List<T>::at_end()
{
	return pos == 0;
}

template <class T>
int List<T>::get_count()
{
	return count;
}

template <class T>
int List<T>::is_empty()
{
	return head == 0;
}

template <class T>
void List<T>::add(T data)
{
	Listnode<T> *p = new Listnode<T>;
	p -> next = head;
	p -> data = data;
	head = p;
	count++;
}

template <class T>
void List<T>::remove(T data)
{
	Listnode<T> **pp = &head;
	while (*pp) {
		if ((*pp) -> data == data) {
			Listnode<T> *p;
			p = *pp;
			*pp = p -> next;
			count--;
			if (pos == p) {
				pos = p -> next;
			}
			delete p;
		} else {
			pp = &(*pp) -> next;
		}
	}
}

template <class T>
T List<T>::get()
{
	if (pos) {
		return pos -> data;
	} else {
//		throw List_error("Reading past end of list");
		return 0;
	}
}

template <class T>
List<T>::operator T()
{
	if (pos) {
		return pos -> data;
	} else {
//		throw List_error("Reading past end of list");
		return 0;
	}
}
template <class T>
T List<T>::getfirst()
{
	if (head) {
		return head -> data;
	} else {
//		throw List_error("Reading past end of list");
		return 0;
	}
}

template <class T>
T List<T>::takefirst()
{
	if (head) {
		T temp = head -> data;
		Listnode<T> *node = head;
		head = head -> next;
		delete node;
		return temp;
	} else {
//		throw List_error("Reading past end of list");
		return 0;
	}
}

#pragma warning(disable:4284)

template List<class Ban*>;
template List<char*>;
template List<long>;
template List<class Userchaninfo*>;
template List<class User*>;
template List<class Channel*>;
template List<class Channeluser*>;
template List<class Autoban*>;
template List<class user*>;
template List<class member*>;
template List<class identity*>;
template List<class group*>;
