Attribute VB_Name = "modTextComparisons"
Option Explicit
Option Compare Text

Public Function Matches(ByVal strText As String, ByVal strMatch As String) As Boolean
    If Len(strText) = 0 Then Exit Function
    Call PrepareCheck(strMatch)
    Matches = (strText Like strMatch)
End Function

Public Sub PrepareCheck(ByRef S As String)
    If InStrB(S, "[") <> 0 Then S = Replace$(S, "[", "")
    If InStrB(S, "]") <> 0 Then S = Replace$(S, "]", "")
    If InStrB(S, "") <> 0 Then S = Replace$(S, "", "[[]")
    If InStrB(S, "") <> 0 Then S = Replace$(S, "", "[]]")
    If InStrB(S, "#") <> 0 Then S = Replace$(S, "#", "[#]")
    If InStrB(S, "-") <> 0 Then S = Replace$(S, "-", "[-]")
End Sub

Public Function YesNo(bool As Boolean) As String
    If bool Then YesNo = "Y" Else YesNo = "N"
End Function

Public Function IsYes(str As String, Optional Default As Boolean = False) As Boolean
    Select Case str
    Case "Y": IsYes = True
    Case "N": IsYes = False
    Case Else: IsYes = Default
    End Select
End Function

Public Function YesNoToChecked(S As String) As CheckBoxConstants
    If S = "Y" Then YesNoToChecked = vbChecked Else YesNoToChecked = vbUnchecked
End Function

Public Function IsEnabled(bool As Boolean) As String
    If bool Then IsEnabled = "enabled" Else IsEnabled = "disabled"
End Function

Public Function OnOff(bool As Boolean) As String
    If bool Then OnOff = "on" Else OnOff = "off"
End Function

