Attribute VB_Name = "modThemes"
'-----------------------------------------------------
' MirageBot Theme Manager Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public CurrentTheme As String, AlignmentH As String, AlignmentV As String, AlignmentT As String, StretchHeight As Long, ImageStretch As Boolean, _
        PaddingT As Long, PaddingL As Long, PaddingR As Long, PaddingS As Long, PaddingB As Long, PaddingX As Long, BottomStretch As Boolean, TransWind As Boolean

Public Sub ImportThemes()
    Dim F As Folders, X As folder
    Set F = FolderList(AppData & "Themes\")
    With frmBot
        Dim I As Integer
        For I = .mnuTheme.UBound To 1 Step -1
            Unload .mnuTheme(I)
        Next I
        .mnuTheme(0).Caption = vbNullString
    
        For Each X In F
            If LenB(X.Name) > 0 Then
                If LenB(.mnuTheme(0).Caption) = 0 Then
                    .mnuTheme(0).Caption = X.Name
                Else
                    Load .mnuTheme(.mnuTheme.Count)
                    .mnuTheme(.mnuTheme.UBound).Caption = X.Name
                End If
                .mnuTheme(.mnuTheme.UBound).Checked = (LCase$(.mnuTheme(.mnuTheme.UBound).Caption) = LCase$(CurrentTheme))
            End If
        Next X
    End With
    ApplyTheme ReadINI(AppSettings, "Settings", "TheTheme")
End Sub

Public Sub ApplyTheme(strTheme As String)
On Error GoTo hErr:
    Dim File As String, F As New FileSystemObject
    If LenB(strTheme) = 0 Then strTheme = "Ribbon Powder"
    File = AppData & "Themes\" & strTheme & "\Theme.ini"
    CreateFolder AppData & "Themes\" & strTheme
    CreateFile File
    'Get values
    Dim Back&, ForeA&, ForeB&, Border&, Img$, Window&, List&, ComboB&, ComboF&
    Img = AppData & "Themes\" & strTheme & "\Theme.jpg"
    Back = Hex2Color(ReadINI(File, "Colors", "Background"))
    ForeA = Hex2Color(ReadINI(File, "Colors", "ForeA"))
    ForeB = Hex2Color(ReadINI(File, "Colors", "ForeB"))
    Border = Hex2Color(ReadINI(File, "Colors", "Border"))
    Window = Hex2Color(ReadINI(File, "Colors", "Window"))
    List = Hex2Color(ReadINI(File, "Colors", "List"))
    ComboB = Hex2Color(ReadINI(File, "Colors", "ComboB"))
    ComboF = Hex2Color(ReadINI(File, "Colors", "ComboF"))
    AlignmentH = LCase$(ReadINI(File, "Alignment", "Horizontal"))
    AlignmentT = LCase$(ReadINI(File, "Alignment", "Position"))
    AlignmentV = LCase$(ReadINI(File, "Alignment", "Vertical"))
    ImageStretch = UCase$(ReadINI(File, "Alignment", "Stretch")) = "Y"
    BottomStretch = UCase$(ReadINI(File, "Alignment", "StretchBottom")) = "Y"
    StretchHeight = Val(ReadINI(File, "Alignment", "StretchHeight"))
    PaddingT = Val(ReadINI(File, "Padding", "Top"))
    PaddingL = Val(ReadINI(File, "Padding", "Left"))
    PaddingR = Val(ReadINI(File, "Padding", "Right"))
    PaddingB = Val(ReadINI(File, "Padding", "Bottom"))
    PaddingX = Val(ReadINI(File, "Padding", "Text"))
    PaddingS = Val(ReadINI(File, "Padding", "Separator"))
    If StretchHeight > 0 Then StretchHeight = StretchHeight * Screen.TwipsPerPixelY
    If PaddingT = 0 Then PaddingT = 56
    If PaddingL = 0 Then PaddingL = 8
    If PaddingR = 0 Then PaddingR = 8
    If PaddingB = 0 Then PaddingB = 8
    If PaddingS = 0 Then PaddingS = 8
    If PaddingX = 0 Then PaddingX = 8
    If PaddingT > 300 Then PaddingT = 300
    If PaddingL > 300 Then PaddingL = 300
    If PaddingR > 300 Then PaddingR = 300
    If PaddingB > 300 Then PaddingB = 300
    If PaddingS > 300 Then PaddingS = 300
    If PaddingX > 300 Then PaddingX = 300
    PaddingT = PaddingT * Screen.TwipsPerPixelY
    PaddingL = PaddingL * Screen.TwipsPerPixelX
    PaddingR = PaddingR * Screen.TwipsPerPixelY
    PaddingB = PaddingB * Screen.TwipsPerPixelY
    PaddingS = PaddingS * Screen.TwipsPerPixelY
    PaddingX = PaddingX * Screen.TwipsPerPixelY
    
    If ComboB = vbBlack And ComboF = vbBlack Then ComboF = vbWhite
    
    'Check if blacked out
    If Back = vbBlack And ForeA = vbBlack And ForeB = vbBlack And Border = vbBlack Then
        ForeA = vbWhite
        ForeB = vbWhite
        Border = &HE0E0E0
    End If
    'Check if whited out
    If Back = vbWhite And ForeA = vbWhite And ForeB = vbWhite And Border = vbWhite Then
        Back = vbBlack
        Border = &HE0E0E0
    End If
    'Apply colors
    With frmBot
        .BackColor = Back
        .lblProfileData.ForeColor = ForeA
        .lblChannel.ForeColor = ForeB
        .shaChat.BorderColor = Border
        .shaList.BorderColor = Border
        .shaSend.BorderColor = Border
        .shaSmile.BorderColor = Border
        .shaListSel.BorderColor = Border
        .shaText.BorderColor = Border
        .shaCmd.BorderColor = Border
        .prfBack.Picture = Nothing
        On Error Resume Next
        .prfBack.Stretch = False
        .prfBack.Picture = LoadPicture(Img)
        
        Dim C As Control
        For Each C In .Controls
            Select Case TypeName(C)
            Case "RichTextBox"
                C.BackColor = Window
            Case "ListView", "List", "PictureBox", "Label", "TextBox"
                C.BackColor = List
            Case "ComboBox"
                C.BackColor = ComboB
                C.ForeColor = ComboF
            End Select
        Next C
    End With
    
    CurrentTheme = strTheme
    WriteINI AppSettings, "Settings", "TheTheme", strTheme

    Dim I As Integer
    With frmBot.mnuTheme
        For I = 0 To .UBound
            .Item(I).Checked = LCase$(.Item(I).Caption) = LCase$(CurrentTheme)
        Next I
    End With
    
    frmBot.Form_Resize
    frmBot.Cls
    frmBot.Refresh
    Exit Sub
hErr:
    
End Sub
