Attribute VB_Name = "modProfiles"
'-----------------------------------------------------
' MirageBot Profile Manager Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public SelTab As Integer

Private Sub ConVis(C As Control, t As Boolean)
    If C.Visible <> t Then C.Visible = t
End Sub

Private Sub ConEnb(C As Control, t As Boolean)
    If C.Enabled <> t Then C.Enabled = t
End Sub

Private Sub ConChk(C As Control, t As Boolean)
    If C.Checked <> t Then C.Checked = t
End Sub

Public Property Get SelBot() As Integer
    SelBot = TabToBotIndex(SelTab)
End Property
'
'Public Sub TabPrevious()
'On Error Resume Next
'    If SelTab < 1 Then SelTab = 1: ViewProfile SelTab: Exit Sub
'    SelTab = SelTab - 1
'    ViewProfile SelTab
'    frmBot.tbsProfile.Tabs(SelTab).Selected = True
'End Sub
'
'Public Sub TabNext()
'On Error Resume Next
'    If SelTab >= frmBot.tbsProfile.Tabs.Count Then SelTab = frmBot.tbsProfile.Tabs.Count: ViewProfile SelTab: Exit Sub
'    SelTab = SelTab + 1
'    ViewProfile SelTab
'    frmBot.tbsProfile.Tabs(SelTab).Selected = True
'End Sub

'Public Sub TabMoveRight()
'    If SelTab = frmBot.tbsProfile.Tabs.Count Then Exit Sub
'    If frmBot.tbsProfile.Tabs.Count < 2 Then Exit Sub
'
'    Dim ST As Integer
'    ST = SelTab
'    Dim LB As Integer, tB As Integer
'    LB = TabToBotIndex(ST + 1)
'    tB = TabToBotIndex(ST)
'
'    'Move tab to the right of this tab to the left
'    frmBot.tbsProfile.Tabs(ST).Tag = LB
'    'Shift current tab to the right
'    frmBot.tbsProfile.Tabs(ST + 1).Tag = tB
'    'Select new tab
'    ViewProfile ST + 1
'    frmBot.tbsProfile.Tabs(ST + 1).Selected = True
'    frmBot.tmrView_Timer
'End Sub
'
'Public Sub TabMoveLeft()
'    If SelTab = 1 Then Exit Sub
'    If frmBot.tbsProfile.Tabs.Count < 2 Then Exit Sub
'
'    Dim ST As Integer
'    ST = SelTab
'    Dim LB As Integer, tB As Integer
'    LB = TabToBotIndex(ST - 1)
'    tB = TabToBotIndex(ST)
'
'    'Move tab to the left of this tab to the right
'    frmBot.tbsProfile.Tabs(ST).Tag = LB
'    'Shift current tab to the left
'    frmBot.tbsProfile.Tabs(ST - 1).Tag = tB
'    'Select new tab
'    ViewProfile ST - 1
'    frmBot.tbsProfile.Tabs(ST - 1).Selected = True
'    frmBot.tmrView_Timer
'End Sub

Public Sub TabSelectLast()
On Error GoTo hErr
5   If frmBot.tbsProfile.Tabs.Count > 0 Then
        RefreshPlugins
        ViewProfile frmBot.tbsProfile.Tabs.Count
        Exit Sub
    End If
1   ViewProfile -1
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Profiles", "TabSelectLast"
End Sub

Public Sub TabSelectNext()
On Error GoTo hErr
5   If frmBot.tbsProfile.Tabs.Count > 0 Then
4       RefreshPlugins
8       ViewProfile 1
        Exit Sub
    End If
    ViewProfile -1
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Profiles", "TabSelectNext"
End Sub

Public Sub TabSwitch()
On Error Resume Next
    If frmBot.tbsProfile.Tabs.Count <= 1 Then Exit Sub
    If SelTab >= frmBot.tbsProfile.Tabs.Count Then SelTab = 0
    SelTab = SelTab + 1
    ViewProfile SelTab
    frmBot.tbsProfile.Tabs(SelTab).Selected = True
End Sub

Public Sub TabUnswitch()
On Error Resume Next
    If frmBot.tbsProfile.Tabs.Count <= 1 Then Exit Sub
    If SelTab <= 1 Then SelTab = frmBot.tbsProfile.Tabs.Count + 1
    SelTab = SelTab - 1
    ViewProfile SelTab
    frmBot.tbsProfile.Tabs(SelTab).Selected = True
End Sub

Public Sub DeleteProfile(Profile As String)
On Error GoTo hErr
    Dim FSO As New FileSystemObject
1   If FSO.FileExists(AppData & "Profiles\" & Profile & "\Config.ini") Then FSO.DeleteFile AppData & "Profiles\" & Profile & "\Config.ini", True
2   If FSO.FileExists(AppData & "Profiles\" & Profile & "\Database.dat") Then FSO.DeleteFile AppData & "Profiles\" & Profile & "\Database.dat", True
3   If FSO.FileExists(AppData & "Profiles\" & Profile & "\Channels.dat") Then FSO.DeleteFile AppData & "Profiles\" & Profile & "\Channels.dat", True
4   FSO.DeleteFolder AppData & "Profiles\" & Profile, True
    Set FSO = Nothing
    UnloadProfile TabToBotIndex(GetProfileIndex(Profile)), True
8   frmConfig.BuildProfileList
    Exit Sub
hErr:
    MsgBox "An error occurred when trying to delete this profile: " & vbNewLine & Err.Description, vbCritical, "Delete Profile"
End Sub

Public Sub SaveLoadedProfiles()
    'Initialize profiles array
    Dim I As Integer, Profiles() As String
    ReDim Profiles(0)
    For I = 0 To frmBot.Bot.UBound
        'Check if current bot is loaded
        If (frmBot.Bot(I).IsLoaded) Then
            If LenB(Profiles(0)) = 0 Then
                'Set array item 0 to profile
                Profiles(0) = frmBot.Bot(I).Profile
            Else
                'Add profile to array
                ReDim Preserve Profiles(UBound(Profiles) + 1)
                Profiles(UBound(Profiles)) = frmBot.Bot(I).Profile
            End If
        End If
    Next I
    'Finally, write loaded profiles
    WriteINI AppSettings, "Cache", "LoadedProfiles", Join(Profiles, ":")
End Sub

Public Sub LoadProfile(strProfile As String)
On Error GoTo hErr
1   If IsProfileLoaded(strProfile) Then
2       MsgBox "Profile " & ChrW$(34) & strProfile & ChrW$(34) & " is already loaded!", vbExclamation
        Exit Sub
    End If
    
    Dim BotIndex As Integer, B As BNCS, I As Integer
    BotIndex = -1
    For Each B In frmBot.Bot
3       If Not B.IsLoaded Then BotIndex = I: Exit For
        I = I + 1
    Next B
    
    If BotIndex = -1 Then
        MsgBox "Sorry, you can only load 50 profiles in a single instance.", vbExclamation
        Exit Sub
    End If
    
4   CreateFolder AppData & "Profiles\" & strProfile
    With frmBot
5       .rtbChat(BotIndex).Text = vbNS
7       .lvUsers(BotIndex).ListItems.Clear
        .lvClan(BotIndex).ListItems.Clear
        .lvFriends(BotIndex).ListItems.Clear
        With .Bot(BotIndex)
10          .BotIndex = BotIndex
11          .Profile = strProfile
12          .ProfilePath = AppData & "Profiles\" & strProfile & "\Config.ini"
9           .Loaded
        End With
15      ReloadProfile BotIndex
8       .tbsProfile.Tabs.Add(, , GetProfileDisplay(BotIndex), 1).Tag = BotIndex
        
        With .Bot(BotIndex)
29          .ImplementPlugins
30          .ImplementScripts
26          If .Config.AutoHide Or options.AutoHideAll Then TabUnload BotIndex
27          If .Config.AutoConnect Or options.AutoConnectAll Then frmBot.tmrStartConnection.Enabled = True
28          If .Config.AutoLock Or options.AutoLockAll Then .IsLocked = True
        End With
        If SelTab < 1 And .tbsProfile.Tabs.Count > 0 Then ViewProfile .tbsProfile.Tabs.Count
    End With
    
    For Each B In frmBot.Bot
        If B.IsLoaded Then
            B.scProcessArg vbNS, "Profile_Loaded", BotIndex
            B.plProcessArg vbNS, "Profile_Loaded", BotIndex
        End If
    Next
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Profiles", "LoadProfile", , BotIndex
End Sub

Public Sub ReloadProfile(ByVal intBot As Integer)
On Error GoTo hErr
    With frmBot.Bot(intBot)
2       .Config.Load .Profile
4       .Database.Load AppData & "Profiles\" & .Profile & "\Database.dat"
        .Mail.LoadMail intBot
    End With
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Profiles", "ReloadProfile", , intBot
End Sub
Public Sub HideControls(intBot As Integer, Optional ByRef Resize As Boolean = True)
On Error GoTo hErr:
    With frmBot
        .picNo.Visible = (intBot = -1)
1       Dim rtb As RichTextBox, lv As ListView, x As Boolean, InternalList As Boolean
2       For Each rtb In .rtbChat
3           x = (rtb.Index = intBot) And (.cboList.Text = LIST_CURR Or _
                                            .cboList.Text = LIST_CLAN Or _
                                            .cboList.Text = LIST_FRND Or _
                                            .cboList.Text = LIST_BANL Or _
                                            .cboList.Text = LIST_DATA) And frmBot.mnuTWW.Checked = False
8           If x Then InternalList = True
9           ConVis rtb, x
10      Next
11      For Each rtb In .rtbWhis
12          x = (rtb.Index = intBot) And (.cboList.Text = LIST_CURR Or _
                                            .cboList.Text = LIST_CLAN Or _
                                            .cboList.Text = LIST_FRND Or _
                                            .cboList.Text = LIST_BANL Or _
                                            .cboList.Text = LIST_DATA) And frmBot.mnuTWW.Checked = True
17          If x Then InternalList = True
18          ConVis rtb, x
19      Next
20      For Each lv In .lvUsers
21          x = (lv.Index = intBot) And Not .CloseSidebar And .cboList.Text = LIST_CURR
22          If x Then InternalList = True
23          ConVis lv, x
24      Next
25      For Each lv In .lvClan
26          x = (lv.Index = intBot) And Not .CloseSidebar And .cboList.Text = LIST_CLAN
27          If x Then InternalList = True
28          ConVis lv, x
29      Next
30      For Each lv In .lvFriends
31          x = (lv.Index = intBot) And Not .CloseSidebar And .cboList.Text = LIST_FRND
32          If x Then InternalList = True
33          ConVis lv, x
34      Next
35      x = (intBot > -1) And frmBot.cboList.Text = LIST_BANL
36      If x Then InternalList = True
37          ConVis .lvBanList, x
38
39      x = (intBot > -1) And frmBot.cboList.Text = LIST_DATA
40      If x Then InternalList = True
41          ConVis .lvDB, x
42
43      If (InternalList = False) And (SuccessfulLoad = True) And (ShuttingDown = False) And intBot > -1 Then
44          For Each lv In frmBot.lvFrame
                x = LCase(intBot & "%" & .cboList.Text) = LCase(lv.Tag) And Not .CloseSidebar
46              ConVis lv, x
47          Next
48          For Each rtb In frmBot.rtbFrame
                x = LCase(intBot & "%" & .cboList.Text) = LCase(rtb.Tag)
50              ConVis rtb, x
51          Next
52      End If
53
54      x = (intBot > -1)
55          ConVis .cboSend, x
56          ConVis .shaChat, x
57          ConVis .prfBack, x
58          ConVis .imgToggle, x
59          ConVis .shaCmd, x
60          ConVis .shaSend, x
61          ConVis .lblArrow, False
62          ConVis .mnuChannel, x
63          ConVis .mnuRequest, x
64          ConVis .mnuCustomize, x
65          ConVis .mnuView, x
67          ConVis .tbsProfile, x
        x = (intBot > -1) And frmBot.FrameSelected = False
70          ConVis .cboCommand, x
71
72      x = (intBot > -1) And (options.DisableStyleBar = False)
73          ConVis .shaText, x
74
75      x = (intBot > -1) And Not frmBot.CloseSidebar
76          ConVis .cboList, x
77          ConVis .shaList, x
78          ConVis .shaListSel, x
79
80      If Not options.DisableStyleBar Then
81          .picTextBar.Visible = (.tbsProfile.Tabs.Count > 0) And (intBot > -1)
82      Else
83          .picTextBar.Visible = False
84      End If
86      If Resize Then .Form_Resize

    End With
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Profiles", "HideControls", , intBot
    Resume Next
End Sub

Public Sub RefreshProfileCommandList()
On Error Resume Next
    Dim I As Integer, Pool() As Object, t As String
    t = frmBot.cboCommand.Text
    frmBot.cboCommand.Clear
    Pool = frmBot.Bot(SelBot).Commands.GetPool
    For I = 0 To UBound(Pool)
        If LenB(Pool(I).Cmd) Then
            If Pool(I).Use < 2 Then
                frmBot.cboCommand.AddItem "/" & Pool(I).Cmd & IIf(LenB(Pool(I).Parameters), " ", vbNS)
            End If
        End If
    Next I
    frmBot.cboCommand.Text = t
End Sub

Public Sub ViewProfile(ByVal intTab As Integer)
On Error GoTo hErr
    Dim intBot As Integer, B As BNCS
1   intBot = TabToBotIndex(intTab)
6   SelTab = intTab
    HideControls intBot, True
    With frmBot
2       If (intBot <> -1) Then
3           DisableURLDetect
4           EnableURLDetect .rtbChat(intBot).hwnd, .hwnd
5           Call URLViewing(True, .rtbChat(intBot).hwnd)
7           .Bot(intBot).IsActive = False
            For Each B In .Bot
                If B.IsLoaded And B.IsConnected Then
                    If GetServerName(B.Config.Server, False) = GetServerName(.Bot(intBot).Config.Server, False) Then
                        If LCase$(B.Self.Channel) = LCase$(.Bot(intBot).Self.Channel) Then B.IsActive = False
                    End If
                End If
            Next
            
            .rtbChat(intBot).SelStart = Len(.rtbChat(intBot).Text)
            .rtbWhis(intBot).SelStart = Len(.rtbChat(intBot).Text)
        
            ConVis .mnuClan, .Bot(intBot).Config.IsWarCraft3
            ConEnb .mnuClanDisband, .Bot(intBot).Clan.InClan And .Bot(intBot).Clan.Rank = crChieftain
            ConEnb .mnuClanLeave, .Bot(intBot).Clan.InClan
            ConEnb .mnuWebProfile, .Bot(intBot).Clan.InClan
            ConEnb .mnuClanCreate, Not .Bot(intBot).Clan.InClan
            ConEnb .mnuMembers, .Bot(intBot).Clan.InClan
            If .mnuClan.Visible Then
                .mnuClan.Caption = "Clan " & .Bot(intBot).Clan.Tag
            Else
                .mnuClan.Caption = "Clan"
            End If
    
            ConChk .mnuCAuto(0), .Bot(intBot).Config.AutoConnect
            ConChk .mnuHAuto, .Bot(intBot).Config.AutoHide
            ConChk .mnuALoad, .Bot(intBot).Config.AutoLoad
            ConChk .mnuLAuto, .Bot(intBot).Config.AutoLock
            ConChk .mnuLockBot, .Bot(intBot).IsLocked
            Dim sName As String: sName = .Bot(intBot).Config.ServerNameEx(False)
            ConChk .mnuServer(0), sName = "USWest"
            ConChk .mnuServer(1), sName = "USEast"
            ConChk .mnuServer(2), sName = "Asia"
            ConChk .mnuServer(3), sName = "Europe"
            ConVis .mnuRealm, .Bot(intBot).Config.IsDiablo
            ConVis .mnuGames, Not .Bot(intBot).Config.IsDiablo
            
            'Connection options
            Dim prvList As String, Pool() As Object, p As Integer, V As Boolean
20          prvList = .cboList.Text
21          .mnuConnect.Caption = IIf(.Bot(intBot).IsConnected, "Reconnect", "Connect")
            V = .cboList.Visible
            .cboList.Visible = False
22          .cboList.Clear
23          .cboList.AddItem LIST_CURR
            .cboList.AddItem LIST_DATA
24          .cboList.AddItem LIST_BANL
25          If .Bot(intBot).Config.IsWarCraft3 Then .cboList.AddItem LIST_CLAN
            .cboList.AddItem LIST_FRND
            Pool = .Bot(intBot).Frames.GetPool
            For p = 0 To UBound(Pool)
                If LenB(Pool(p).Title) Then .cboList.AddItem Pool(p).Title
            Next
            For p = 0 To .cboList.ListCount - 1
                If .cboList.List(p) = prvList Then
                    .cboList.ListIndex = p
                    p = -1
                    Exit For
                End If
            Next
            If p <> -1 Then .cboList.ListIndex = 0
            .cboList.Visible = V
            RefreshProfileCommandList
            ShowFaves .Bot(intBot).Config.Server
            ShowPublic .Bot(intBot)
            ShowPlaces .Bot(intBot)
        Else
            Dim HCount As Integer
            For Each B In .Bot
                If B.IsLoaded And B.IsHidden Then
                    HCount = HCount + 1
                End If
            Next
            If HCount > 0 Then
                .lblNoProf(0) = "No Profiles Shown"
                .lblNoProf(1) = "There are " & HCount & " profiles hidden. To unhide..."
                .lblNoProf(2) = "1. Click Profiles"
                .lblNoProf(3) = "2. Look for a profile with 'Hiding' status..."
                .lblNoProf(4) = "3. Select that profile, Viola!"
            Else
                .lblNoProf(0) = "No Profiles Loaded"
                .lblNoProf(1) = "New to MirageBot? No Problem..."
                .lblNoProf(2) = "1. Click Profiles, then select New Profile"
                .lblNoProf(3) = "2. Enter a name for the profile, then fill out the configuration"
                .lblNoProf(4) = "3. Click Apply, then click Load"
            End If
            .mnuClan.Visible = False
            .cboList.Clear
            .cboList.AddItem LIST_CURR
            .cboList.ListIndex = 0
            .cboCommand.Clear
        End If
    End With
    'Refresh the channel
28  RefreshChannel
29  RefreshPlugins
30  RefreshScripts
31  RefreshQueues
    'Resize the main form
32  frmBot.Form_Resize
33  frmBot.cboList_Click
    'Refresh some other stuff
34  'frmBot.cboSend.SelStart = Len(frmBot.cboSend.Text)
On Error Resume Next
35  frmBot.RefreshCount
36  'If SuccessfulLoad And Not ShuttingDown Then frmBot.cboSend.SetFocus
    Exit Sub
hErr:
    Close #1
    ErrorHandler Err.Number, Err.Description, Erl, "Profiles", "ViewProfile", , intBot
End Sub

Public Sub UnloadProfile(ByVal intBot As Integer, ByVal DoSelect As Boolean)
On Error GoTo hErr
1   If (intBot = -1) Then Exit Sub
    Dim B As BNCS
    For Each B In frmBot.Bot
        If B.IsLoaded Then
            B.scProcessArg vbNS, "Profile_Unloaded", intBot
            B.plProcessArg vbNS, "Profile_Unloaded", intBot
        End If
    Next
2   With frmBot
3       .rtbChat(intBot).Text = vbNS
5       .lvUsers(intBot).ListItems.Clear
6       .lvFriends(intBot).ListItems.Clear
7       .lvClan(intBot).ListItems.Clear
10      .Bot(intBot).Unloaded
    End With
    
    Dim intTab As Integer
11  intTab = BotToTabIndex(intBot)
    If intTab <> -1 Then
        'Check if tab is valid
12      If (intTab <= frmBot.tbsProfile.Tabs.Count And intTab > 0) Then
13          frmBot.tbsProfile.Tabs.Remove intTab
        Else
15          MsgBox "Cannot unload profile, tab index is out of bounds!", vbExclamation
            Exit Sub
        End If
    End If
    
    If DoSelect Then
        With frmBot.tbsProfile
            If .Tabs.Count > 0 Then
                If (intTab - 1 = .Tabs.Count) Then
                    ViewProfile intTab - 1
                    .Tabs(intTab - 1).Selected = True
                ElseIf (intTab > 0 And intTab < .Tabs.Count) Then
                    ViewProfile intTab
                    .Tabs(intTab).Selected = True
                End If
            Else
                ViewProfile -1
            End If
        End With
        frmBot.Form_Resize
    End If
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Profiles", "UnloadProfile", , intBot
End Sub

Public Sub TabLoad(intBot As Integer)
    'Load the tab, when you switch from IsHidden to tabbed
    frmBot.Bot(intBot).IsHidden = False
    frmBot.tbsProfile.Tabs.Add(, , GetProfileDisplay(intBot), 1).Tag = intBot
    If SelTab < 1 Then TabSelectNext
End Sub


Public Function TabUnload(intBot As Integer) As Boolean
    'Unload the tab, but leave the bot loaded (IsHidden)
On Error GoTo hErr
    Dim I As Integer
1   For I = 1 To frmBot.tbsProfile.Tabs.Count
2       If (Val(frmBot.tbsProfile.Tabs(I).Tag) = intBot) Then
3           frmBot.Bot(intBot).IsLoaded = True
4           frmBot.Bot(intBot).IsHidden = True
5           frmBot.tbsProfile.Tabs.Remove I
6           TabUnload = True
7           TabSelectNext
            Exit Function
        End If
    Next I
    TabSelectNext
hErr:
    TabUnload = False
End Function

Public Function CreateProfile() As String
On Error GoTo hErr
    Dim str As String
1   str = InputBox("Enter name for new profile:", "Create Profile")
2   str = FixFilename(str)
3   If LenB(str) > 0 Then
4       Dim p As String
5       p = AppData & "Profiles\" & str & "\"
6       If CreateFolder(p) = True Then
7           CreateFolder p & "Logs\"
8           CreateFile p & "Database.dat"
9           CreateFile p & "Config.ini"
10          frmConfig.Show
11          frmConfig.BuildProfileList
12          frmConfig.SelectProfile str
13          frmBot.RefreshBotList
14          CreateProfile = str
        Else
15          MsgBox "A profile with that name already exists!", vbExclamation
        End If
    End If
    Exit Function
hErr:
    MsgBox "An error occurred when trying to create a profile: " & vbNewLine & Err.Description, vbCritical, "Create Profile"
End Function

Public Function IsProfileLoaded(ByVal ProfileName As String) As Boolean
On Error GoTo hErr
1   Dim B As BNCS
2   ProfileName = LCase$(ProfileName)
3   For Each B In frmBot.Bot
4       If LCase$(B.Profile) = ProfileName Then IsProfileLoaded = True: Exit Function
    Next
    Exit Function
hErr:
    MsgBox "An error occurred while checking if profile was loaded: " & vbNewLine & Err.Description, vbCritical, "Is Profile Loaded"
End Function

Public Function GetProfileDisplay(ByVal BotIndex As Integer) As String
    If BotIndex = -1 Then Exit Function
    Dim B As BNCS, TS As String
    Set B = frmBot.Bot(BotIndex)
    TS = options.TabString
    TS = Replace(TS, "<account>", IIf(B.IsOnline, B.Self.Username, B.Config.Username))
    TS = Replace(TS, "<channel>", IIf(B.IsOnline, B.Self.Channel, B.Config.Channel))
    TS = Replace(TS, "<gateway>", B.Config.ServerName)
    TS = Replace(TS, "<index>", B.BotIndex)
    TS = Replace(TS, "<product>", B.Config.ProductID)
    TS = Replace(TS, "<profile>", B.Profile)
    If Len(TS) = 0 Then TS = B.Profile
    GetProfileDisplay = TS
End Function

Public Function GetProfileIndex(ByVal ProfileName As String) As Integer
On Error GoTo hErr
1   Dim B As BNCS
2   ProfileName = LCase$(ProfileName)
3   For Each B In frmBot.Bot
4       If LCase$(B.Profile) = ProfileName Then
5           GetProfileIndex = B.BotIndex
            Exit Function
        End If
    Next
    Exit Function
hErr:
    GetProfileIndex = -1
End Function

Public Function BotToTabIndex(intBot As Integer) As Integer
    'Convert bot to tab index
On Error GoTo hErr
    If intBot = -1 Then GoTo hErr
1   If frmBot.tbsProfile.Tabs.Count > 0 Then
        Dim I As Integer
2       For I = 1 To frmBot.tbsProfile.Tabs.Count
3           If (Val(frmBot.tbsProfile.Tabs(I).Tag) = intBot) Then
4               BotToTabIndex = I
                Exit Function
            End If
        Next I
    End If
hErr:
    BotToTabIndex = -1
End Function

Public Function TabToBotIndex(intTab As Integer) As Integer
    'Convert tab to bot index
1   If (intTab <= frmBot.tbsProfile.Tabs.Count And intTab > 0) Then
2       TabToBotIndex = Val(frmBot.tbsProfile.Tabs(intTab).Tag)
3   Else
4       TabToBotIndex = -1
    End If
End Function
