Attribute VB_Name = "modManageAlerts"
'-----------------------------------------------------
' MirageBot Alerts Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public Alerts() As AlertType
Public Type AlertType
    Username As String
    Alert As AlertEnum
    Pattern As String
End Type
Public Enum AlertEnum
    aeEMOTE& = 0
    aeJOIN& = 1
    aeLEAVE& = 2
    aeTALK& = 3
    aeWHISPER& = 4
End Enum

Public Sub LoadAlerts()
    Dim ts As TextStream
    Set ts = ReadFile(AppData & "Data\Preferences\Alerts.txt")
    ReDim Alerts(0)
    Do Until (ts.AtEndOfStream)
        Dim strLine As String
        strLine = ts.ReadLine()
        If InStrB(strLine, vbNullChar) <> 0 Then
            Dim LineData() As String
            LineData() = Split(strLine, vbNullChar)
            If UBound(LineData) = 2 Then
                '0 - Alert Type
                '1 - Alert Username
                '2 - Alert Pattern
                If (Val(LineData(0)) > -1) And (Val(LineData(0)) < 5) Then
                    ReDim Preserve Alerts(UBound(Alerts) + 1)
                    With Alerts(UBound(Alerts))
                        .Alert = Val(LineData(0))
                        .Username = LineData(1)
                        .Pattern = LineData(2)
                    End With
                End If
            End If
        End If
    Loop
    ts.Close
End Sub

Public Sub CheckAlert(botIndex As Integer, AlertType As AlertEnum, Username As String, Pattern As String)
    Dim i As Integer
    For i = 1 To UBound(Alerts)
        If AlertType = Alerts(i).Alert Then
            If Matches(Username, Alerts(i).Username) Or _
                Len(Alerts(i).Username) = 0 Or Alerts(i).Username = "*" Then
                If Matches(Pattern, Alerts(i).Pattern) Then
                    Dim AT As String
                    Select Case AlertType
                    Case AlertEnum.aeEMOTE: AT = "emote"
                    Case AlertEnum.aeJOIN: AT = "join"
                    Case AlertEnum.aeLEAVE: AT = "leave"
                    Case AlertEnum.aeTALK: AT = "talk"
                    Case AlertEnum.aeWHISPER: AT = "whisper"
                    End Select
                    frmBot.ZOrder vbBringToFront
                    If inTray Then
                        frmTray.TrayBalloon vbInformationIcon, "Alert!", Username & " triggered an alert on event " & AT & " (" & Pattern & ")!"
                    Else
                        FlashWindow
                    End If
                    PlaySound App.Path & "\notify.wav", SND_ASYNC
                    frmBot.AddChat botIndex, vbCyan, "Alert triggered by " & Username & " on event " & AT & " (" & Pattern & ")!"
                    Exit For
                End If
            End If
        End If
    Next i
End Sub

Private Sub SaveAlerts()
    Open AppData & "Data\Preferences\Alerts.txt" For Output As #1
        Dim i As Integer
        For i = 1 To UBound(Alerts)
            Print #1, Alerts(i).Alert & vbNullChar & Alerts(i).Username & vbNullChar & Alerts(i).Pattern
        Next i
    Close #1
End Sub
    
Public Sub RemoveAlert(Index As Integer)
    Dim R As Integer
    For R = Index To UBound(Alerts) - 1
        Alerts(R) = Alerts(R + 1)
    Next R
    ReDim Preserve Alerts(UBound(Alerts) - 1)
    SaveAlerts
End Sub

Public Sub AddAlert(AlertType As Integer, Username As String, Pattern As String)
    ReDim Preserve Alerts(UBound(Alerts) + 1)
    With Alerts(UBound(Alerts))
        .Alert = AlertType
        .Username = Username
        .Pattern = Pattern
    End With
    SaveAlerts
End Sub
