Attribute VB_Name = "modGroups"
'-----------------------------------------------------
' MirageBot Groups Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public Groups() As clsGroup
Public GroupsLoaded As Boolean

Public Function IsGroup(Group As String) As Boolean
    Dim i As Integer, C As Integer
    C = UBound(Groups)
    For i = 0 To C
        If LCase$(Group) = LCase$(Groups(i).Name) Then
            IsGroup = True
            Exit Function
        End If
    Next
End Function

Public Sub RefreshChannel()
On Error GoTo hErr
    If Not SanityCheck Then Exit Sub
    Dim O As Integer, C As Boolean
1   For O = 1 To frmBot.lvUsers(SelBot).ListItems.Count
2       With frmBot.lvUsers(SelBot).ListItems.Item(O)
3           Dim U As UserInfo, S As objUser
4           Set S = frmBot.Bot(SelBot).Users.GetByName(.Tag)
5           If Not S Is Nothing Then
6               U = GetUserInfo(SelBot, .Tag, S.Statstring, S.Flags, S.Ping)
                Dim t As String, ServerName As String
                If IsOnGateway(S.Username) Then
                    ServerName = Mid$(S.Username, InStrRev(S.Username, "@") + 1)
                Else
                    ServerName = frmBot.Bot(SelBot).Config.ServerName
                End If
                t = Alias.GetAlias(S.Username, ServerName)
                If LenB(t) Then
                    If t = S.Username Then
                        If .Text <> Abbr(U.Account) Then C = True: .Text = Abbr(U.Account)
                    Else
                        If .Text <> t Then C = True: .Text = t
                    End If
                Else
                    If .Text <> Abbr(U.Account) Then C = True: .Text = Abbr(U.Account)
                End If
7               If .ForeColor <> U.Color Then C = True: .ForeColor = U.Color
8               If .SmallIcon <> U.Icon Then C = True: .SmallIcon = U.Icon
9               If .ListSubItems(1).Text <> U.Clan Then C = True: .ListSubItems(1).Text = U.Clan
                If U.Clan = frmBot.Bot(SelBot).Clan.Tag Then
                    If .ListSubItems(1).ForeColor <> modStyles.ClanColor.cl_yourclan Then .ListSubItems(1).ForeColor = modStyles.ClanColor.cl_yourclan
                Else
                    If .ListSubItems(1).ForeColor = modStyles.ClanColor.cl_clan Then .ListSubItems(1).ForeColor = modStyles.ClanColor.cl_clan
                End If
11              If .ListSubItems(2).Text <> U.Ping Then C = True: .ListSubItems(2).Text = U.Ping
12              If .ListSubItems(2).ForeColor <> U.PingColor Then C = True: .ListSubItems(2).ForeColor = U.PingColor
13              Set S = Nothing
            End If
        End With
    Next
    If frmBot.Bot(SelBot).Self.IsVoid Then DoEvents
    'frmBot.lvUsers(SelBot).Visible = True
14  'If C Then frmBot.lvUsers(SelBot).Refresh
    Exit Sub
hErr:
    Output frmBot.rtbChat(SelBot), &HB0, , "Icon: " & U.Icon & " (" & U.Statstring & ")"
    ErrorHandler Err.Number, Err.Description, Erl, "Groups", "RefreshChannel", , SelBot
End Sub

Public Function AddToGroup(ByVal Group As String, Username As String) As Boolean
On Error GoTo hErr
    If GroupsLoaded = True Then
        Dim i As Integer, Count As Long
        Group = LCase$(Group)
        Count = UBound(Groups)
        For i = 0 To Count
            If LCase$(Groups(i).Name) = Group Then
                Groups(i).Add Username
                Groups(i).SaveGroup
                AddToGroup = True
                Exit Function
            End If
        Next i
    End If
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Groups", "AddToGroup"
End Function

Public Function RemoveFromGroup(Username As String) As Boolean
On Error GoTo hErr
    If GroupsLoaded = True Then
        Dim i As Integer, Count As Long
        Count = UBound(Groups)
        For i = 0 To Count
            If Groups(i).IsInGroup(Username) Then
                RemoveFromGroup = Groups(i).Remove(Username)
                Groups(i).SaveGroup
                Exit Function
            End If
        Next i
    End If
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Groups", "RemoveFromGroup"
End Function

Public Function GetGroupColor(Username As String) As Long
On Error GoTo hErr
    Dim i As Integer, Count As Long
    Count = UBound(Groups)
    For i = 0 To Count
        If Not Groups(i) Is Nothing Then
            If Groups(i).IsInGroup(Username) Then
                GetGroupColor = Groups(i).Color
                Exit Function
            End If
        End If
    Next i
hErr:
    GetGroupColor = -1
End Function

Public Function GetGroupName(Username As String) As String
On Error GoTo hErr
    If GroupsLoaded = True Then
        Dim i As Integer, Count As Long
        Count = UBound(Groups)
        For i = 0 To Count
            If Groups(i).IsInGroup(Username) Then
                GetGroupName = Groups(i).Name
                Exit Function
            End If
        Next i
    End If
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Groups", "GetGroupName"
End Function

Public Sub RefreshGroups()
On Error GoTo hErr
    Dim i As Integer
    For i = frmBotMenu.mnuGroups.UBound To 1 Step -1
        Unload frmBotMenu.mnuGroups(i)
    Next i
    frmBotMenu.mnuGroups(0).Checked = False
    frmBotMenu.mnuGroups(0).Caption = "-"
    If GroupsLoaded = True Then
        If ArrayInit(Not Groups) Then
            If LenB(Groups(0).Name) <> 0 Then
                Dim Count As Long
                Count = UBound(Groups)
                For i = 0 To Count
                    If frmBotMenu.mnuGroups(0).Caption = "-" Then
                        frmBotMenu.mnuGroups(0).Caption = Groups(i).Name
                    Else
                        Load frmBotMenu.mnuGroups(frmBotMenu.mnuGroups.Count)
                        frmBotMenu.mnuGroups(frmBotMenu.mnuGroups.UBound).Caption = Groups(i).Name
                    End If
                Next i
            End If
        End If
    End If
    Exit Sub
hErr:
    Close #1
    ErrorHandler Err.Number, Err.Description, Erl, "Group", "RefreshGroups"
End Sub

Public Sub LoadGroups()
    ReDim Groups(0)
    GroupsLoaded = False
On Error GoTo hErr
    Dim Files() As String, i As Integer, N As Integer, TS As TextStream
    CreateFolder AppData & "Data\Preferences\Groups\"
    If LenB(Dir$(AppData & "Data\Preferences\Groups\")) <> 0 Then
        Files = FileList(AppData & "Data\Preferences\Groups\*.txt")
        If ArrayInit(Not Files) Then
            ReDim Groups(UBound(Files()))
            GroupsLoaded = True
            For i = 0 To UBound(Files())
                Set Groups(i) = New clsGroup
                Groups(i).Clear
                Groups(i).Name = Left$(Files(i), InStrRev(Files(i), ".") - 1)
                Dim FSO As New FileSystemObject
                Set TS = FSO.OpenTextFile(AppData & "Data\Preferences\Groups\" & Files(i), ForReading, True)
                Set FSO = Nothing
                Dim Content As String, Lines() As String
                If TS.AtEndOfStream = False Then
                    Content = TS.ReadAll()
                    TS.Close
                    If InStrB(Content, vbNewLine) <> 0 Then
                        Lines = Split(Content, vbNewLine)
                        If Lines(0) Like "Color=*" Then Groups(i).Color = Val(Mid$(Lines(0), 7))
                        If Groups(i).Color = 0 Then Groups(i).Color = vbWhite
                        For N = 1 To UBound(Lines)
                            If LenB(Lines(N)) <> 0 Then Groups(i).Add Lines(N)
                        Next N
                    End If
                End If
            Next i
        End If
    End If
    RefreshGroups
    Exit Sub
hErr:
    Close #1
    ErrorHandler Err.Number, Err.Description, Erl, "Group", "LoadGroups"
End Sub

Public Function CreateGroup(Name As String, Color As Long) As Boolean
    On Error Resume Next
    Dim gf As String, fn As Integer
    gf = AppData & "Data\Preferences\Groups\" & Name & ".txt"
    If modFileIO.IsFile(gf) Then Exit Function
    fn = FreeFile
    CreateFile gf
    Open gf For Output As #fn
        Print #fn, "Color=" & Color
    Close #fn
    LoadGroups
    CreateGroup = True
End Function

Public Function DeleteGroup(Name As String)
    On Error Resume Next
    If IsGroup(Name) Then
        Dim gf As String
        gf = AppData & "Data\Preferences\Groups\" & Name & ".txt"
        If Not modFileIO.IsFile(gf) Then Exit Function
        DeleteGroup = modFileIO.DeleteFile(gf)
        LoadGroups
    End If
End Function

Public Function RenameGroup(OldName As String, NewName As String)
    On Error Resume Next
    If LenB(NewName) > 0 And LCase$(NewName) <> LCase$(OldName) Then
        FileCopy AppData & "Data\Preferences\Groups\" & OldName & ".txt", AppData & "Data\Preferences\Groups\" & FixFilename(NewName) & ".txt"
        Kill AppData & "Data\Preferences\Groups\" & OldName & ".txt"
        LoadGroups
    End If
End Function
