VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "mswinsck.ocx"
Begin VB.UserControl SVGN 
   CanGetFocus     =   0   'False
   ClientHeight    =   600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   780
   ClipBehavior    =   0  'None
   ClipControls    =   0   'False
   HasDC           =   0   'False
   InvisibleAtRuntime=   -1  'True
   ScaleHeight     =   600
   ScaleWidth      =   780
   Windowless      =   -1  'True
   Begin VB.Timer tmrKeepAlive 
      Interval        =   40000
      Left            =   360
      Top             =   0
   End
   Begin MSWinsockLib.Winsock sckSovereign 
      Left            =   0
      Top             =   0
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
End
Attribute VB_Name = "SVGN"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Event AddChat(color As Long, Message As String)
Event Connecting(Server As String)
Event Connected()
Event Disconnect()
Event Broadcast(Description As String)
Event Information(Description As String)
Event Error(Description As String)
Event UserJoin(ByVal U As IUserSov)
Event UserPresent(ByVal U As IUserSov)
Event UserTalk(ByVal U As IUserSov)
Event UserEmote(ByVal U As IUserSov)
Event UserWhisperTo(ByVal U As IUserSov)
Event UserWhisperFrom(ByVal U As IUserSov)
Event UserLeave(Username As String)
Event JoinedChannel(Channel As String, Flags As Long)
Event MessageSent(Message As String)

Private Const Port = 2190
Private IncomingData As String
Private LastProfile As String
Private B As New clsPacketBuffer

Public Users As New clsSovUsers
Public Self As New ISelf, mAutoConnect As Boolean
Public Account As String, Password As String, Server As String, Channel As String
Public botIndex As Integer, Profile As String, profilePath As String
Public IsOnline As Boolean, IsLoaded As Boolean, Reconnect As Boolean

Public Sub Load(F As String)
    Const SOVEREIGN_SECTION As String = "Sovereign"
    
    Account = ReadINI(F, SOVEREIGN_SECTION, "Account")
    Password = ReadINI(F, SOVEREIGN_SECTION, "Password")
    Server = ReadINI(F, SOVEREIGN_SECTION, "Server")
    Channel = ReadINI(F, SOVEREIGN_SECTION, "Channel")
    AutoConnect = (UCase$(ReadINI(F, SOVEREIGN_SECTION, "AutoConnect")) = "Y")
End Sub

Public Property Get AutoConnect() As Boolean
    AutoConnect = mAutoConnect
End Property

Public Property Let AutoConnect(value As Boolean)
    mAutoConnect = value
    WriteINI profilePath, "Sovereign", "AutoConnect", YesNo(mAutoConnect)
End Property

Public Sub Connect()
    Disconnect
    sckSovereign.Connect Server, Port
    RaiseEvent Connecting(Server)
End Sub

Public Sub Disconnect()
    If sckSovereign.State <> sckClosed Then RaiseEvent Disconnect
    IsOnline = False
    sckSovereign.Close
End Sub

Public Sub JoinChannel(sChannel As String)
    Set B = New clsPacketBuffer
    B.InsertCString "/join " & sChannel
    B.SendBnetPacket sckSovereign, &H30
End Sub

Public Sub SendText(Message As String)
    RaiseEvent MessageSent(Message)
    Set B = New clsPacketBuffer
    B.InsertCString Message
    B.SendBnetPacket sckSovereign, &H30
End Sub

'Public Sub AccountNotify(Account As String, Server As String, Online As Boolean)
'    Set B = New clsPacketBuffer
'    B.InsertByte 1
'    B.InsertByte IIf(Online, 1, 0)
'    B.InsertCString Account
'    B.InsertCString Server
'End Sub
'
'Public Sub AccountNotifyOnConnect()
'    Dim i As BNCS, Count As Byte
'    For Each i In frmBot.Bot
'        If i.IsOnline Then
'            Count = Count + 1
'        End If
'    Next i
'    Set B = New clsPacketBuffer
'    B.InsertByte Count
'    For Each i In frmBot.Bot
'        If i.IsOnline Then
'            B.InsertByte 1
'            B.InsertCString i.Self.Username
'            B.InsertCString GetServerName(i.Config.Server, i.IsWarCraft)
'        Else
'            B.InsertByte 0
'            B.InsertCString i.Self.Username
'            B.InsertCString GetServerName(i.Config.Server, i.IsWarCraft)
'        End If
'    Next i
'End Sub

Public Sub RequestProfile(Username As String)
    On Error Resume Next
    Set B = New clsPacketBuffer
    B.InsertCString Username
    B.SendBnetPacket sckSovereign, &H32
    LastProfile = Username
End Sub

Public Sub WriteProfile( _
    Age As Byte, Gender As Boolean, Email As String, _
    AIM As String, YIM As String, ICQ As String, _
    MSN As String, Skype As String, Site As String, _
    Description As String)
    On Error Resume Next
    Set B = New clsPacketBuffer
    B.InsertByte Age
    B.InsertByte IIf(Gender, 1, 0)
    B.InsertCString Email
    B.InsertCString AIM
    B.InsertCString YIM
    B.InsertCString ICQ
    B.InsertCString MSN
    B.InsertCString Skype
    B.InsertCString Site
    B.InsertCString Description
    B.SendBnetPacket sckSovereign, &H31
End Sub

Private Sub sckSovereign_Close()
    Disconnect
    Reconnect = True
End Sub

Private Sub sckSovereign_Connect()
    RaiseEvent Connected
    If LenB(Password) = 0 Or LenB(Account) = 0 Then
        RaiseEvent Error("You must specify both username and password!")
        Disconnect
        Exit Sub
    End If
    Set B = New clsPacketBuffer
    Dim encPassword() As String
    encPassword = SovEncode(Password)
    B.InsertCString Account
    B.InsertCString encPassword(1)
    B.InsertCString encPassword(0)
    B.SendBnetPacket sckSovereign, &H21
End Sub

Private Sub sckSovereign_DataArrival(ByVal bytesTotal As Long)
On Error Resume Next
    Dim Data As String
    sckSovereign.GetData Data
    IncomingData = IncomingData & Data

    Dim Length As Long
    Dim strTemp As String, Packet As String, strData As String
    While Len(IncomingData) > 4 Or Err Or (sckSovereign.State <> sckConnected)
        Length = ExtractInt16(Mid$(IncomingData, 3, 2))
        If (Len(IncomingData) < Length) Or (Length < 0) Then Exit Sub
        Packet = Left$(IncomingData, Length)
        ParseData Packet
        IncomingData = Mid$(IncomingData, Length + 1)
'
'        strTemp = StrReverse(Mid$(IncomingData, 3, 2))
'        Length = Asc(Right$(strTemp, 1))
'        I = Asc(Left$(strTemp, 1))
'        i2 = 0
'        If I > 0 Then
'            i2 = I
'            Do Until I = 0 Or Err
'                Length = Length + 255
'                I = I - 1
'            Loop
'        End If
'        If Len(IncomingData) < Length Then Exit Sub
'        Packet = Left$(IncomingData, Length)
'        ParseData Packet
'        IncomingData = Mid(IncomingData, Length + 1 + i2)
    Wend
End Sub

Private Sub ParseData(Data As String)
    Dim PacketID As Integer, success As Byte
    PacketID = Asc(Mid$(Data, 2, 1))
    
    Select Case PacketID
        Case &H0: 'StayAlive
            Set B = New clsPacketBuffer
            B.SendBnetPacket sckSovereign, &H0
            
        Case &H22
            success = Asc(Mid$(Data, 5, 1))
            If success = 1 Then RaiseEvent AddChat(colour.msg.mNegative, "Unable to report system information!")
            
        Case &H21: 'ChatLogon2
            success = Asc(Mid$(Data, 5, 1))
            
            Select Case success
                Case 0: 'Success
                    Self.Username = Split(Mid(Data, 6), vbNullChar)(0)
                    RaiseEvent AddChat(colour.msg.mPositive, "Login successful!")
                Case 1: 'Incorrect password
                    RaiseEvent AddChat(colour.msg.mNegative, "Incorrect password!")
                Case 2: 'Invalid username
                    RaiseEvent AddChat(colour.msg.mNegative, "Invalid username!")
                Case 3: 'Illegal character
                    RaiseEvent AddChat(colour.msg.mNegative, "Illegal character in username!")
                Case Else: 'Other error
                    RaiseEvent AddChat(colour.msg.mNegative, "Unknown error occurred during logon!")
            End Select
            Set B = New clsPacketBuffer
            B.InsertInt32 ARCH_IX86
            B.InsertByte &H1
            B.InsertCString GetLocaleInfo(LOCALE_SABBREVCTRYNAME)
            B.InsertCString GetLocaleInfo(LOCALE_SABBREVLANGNAME)
            B.InsertCString GetLocaleInfo(LOCALE_SENGCOUNTRY)
            B.InsertCString GetLocaleInfo(LOCALE_SENGLANGUAGE)
            B.InsertCString GetOS
            B.InsertCString "MirageBot"
            B.InsertCString App.Major & "." & App.Minor & IIf(BETA, " BETA", IIf(PRIV, " (Private)", " (Public)"))
            B.SendBnetPacket sckSovereign, &H22
            
            JoinChannel Channel
            'AccountNotifyOnConnect
            
            IsOnline = True
        Case &H30: 'ChatEvent
            ParseEvent Data
            
        Case &H32: 'RequestProfile
            ParseProfile Data
    End Select
End Sub

Private Sub ParseProfile(Data As String)
    Dim D As New clsPacketDebuffer
    D.SetDebuffer Mid$(Data, 5)
    
    If D.ReadByte() = &H1 Then
        Dim Age As Byte, Sex As Boolean, Username As String, ICQ As String
        Dim Email As String, AIM As String, YIM As String, MSN As String, Skype As String
        Dim Website As String, Description As String
        Age = D.ReadByte()
        Sex = D.ReadByte() = &H1
        Username = D.ReadCString()
        Email = D.ReadCString()
        AIM = D.ReadCString()
        YIM = D.ReadCString()
        ICQ = D.ReadCString()
        MSN = D.ReadCString()
        Skype = D.ReadCString()
        Website = D.ReadCString()
        Description = D.ReadCString()
        Dim S As New frmViewProfileSov
        S.botIndex = botIndex
        S.lblUser = Username
        S.txtAge = Age
        S.txtEmail = Email
        S.txtICQ = ICQ
        S.txtAIM = AIM
        S.txtYIM = YIM
        S.txtMSN = MSN
        S.txtSkype = Skype
        S.txtWebsite = Website
        S.txtDescription = Description
        S.txtAge.Locked = Not (LCase$(Prefix(Username, "@")) = LCase$(Prefix(Self.Username, "@")))
        S.txtEmail.Locked = S.txtAge.Locked
        S.txtICQ.Locked = S.txtAge.Locked
        S.txtAIM.Locked = S.txtAge.Locked
        S.txtYIM.Locked = S.txtAge.Locked
        S.txtMSN.Locked = S.txtAge.Locked
        S.txtSkype.Locked = S.txtAge.Locked
        S.txtWebsite.Locked = S.txtAge.Locked
        S.txtDescription.Locked = S.txtAge.Locked
        S.Show
    Else
        If LCase$(LastProfile) = LCase$(Self.Username) Then
            WriteProfile 0, True, "", "", "", "", "", "", "", "MirageBot"
            RequestProfile Self.Username
        Else
            RaiseEvent AddChat(colour.msg.mNegative, "That user has not written their profile yet!")
        End If
    End If
End Sub

Private Sub ParseEvent(Data As String)
    Dim D As New clsPacketDebuffer
    D.SetDebuffer Mid$(Data, 5)
    
    Debug.Print DebugOutput(Data)
    
    Dim U As New IUserSov, EventID As Integer, X As Integer, I As Integer
    EventID = D.ReadByte()
    U.Flags = D.ReadInt32()
    U.Ping = D.ReadInt32()
    U.PlatformID = D.ReadFixedString(4)
    U.Is64Bit = D.ReadByte() = &H1
    U.Username = D.ReadCString()
    U.Message = D.ReadCString()
    
    If EventID = 1 Or EventID = 2 Then
        U.CountryAbbr = D.ReadCString()
        U.LanguageAbbr = D.ReadCString()
        U.Country = D.ReadCString()
        U.Language = D.ReadCString()
        U.OS = D.ReadCString()
        U.BotName = D.ReadCString()
        U.BotVersion = D.ReadCString()
        X = D.ReadByte()
        For I = 0 To X
            U.AddAccount D.ReadCString(), D.ReadCString()
        Next I
    End If
    
    Select Case EventID
        Case 1: 'UserInChannel
            If U.Username = Self.Username Then
                Self.Ping = U.Ping
                Self.Flags = U.Flags
            End If
            Users.Add U
            RaiseEvent UserPresent(U)
        Case 2: 'UserJoin
            U.TickJoin = DblTickCount()
            Users.Add U
            RaiseEvent UserJoin(U)
        Case 3: 'UserLeave
            Users.Remove U.Username
            RaiseEvent UserLeave(U.Username)
        Case 4: 'WhisperFrom
            RaiseEvent UserWhisperFrom(U)
        Case 5: 'WhisperTo
            RaiseEvent UserWhisperTo(U)
        Case 6: 'UserTalk
            RaiseEvent UserTalk(U)
        Case 7: 'UserEmote
            RaiseEvent UserEmote(U)
        Case 8: 'JoinedChannel
            Users.Clear
            Self.Channel = U.Message
            Self.channelFlags = U.Flags
            RaiseEvent JoinedChannel(U.Message, U.Flags)
        Case 9: 'Broadcast
            RaiseEvent Broadcast(U.Message)
        Case 10: 'FlagsUpdate
        Case 11: 'ServerInfo
            RaiseEvent Information(U.Message)
        Case 12: 'ServerError
            RaiseEvent Error(U.Message)
    End Select
End Sub

Private Sub sckSovereign_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
    RaiseEvent AddChat(colour.msg.mNegative, "Sovereign: " & Description)
    Disconnect
    Reconnect = True
End Sub

Private Sub tmrKeepAlive_Timer()
    If sckSovereign.State = sckConnected Then
        Set B = New clsPacketBuffer
        B.SendBnetPacket sckSovereign, &H0
    Else
        If Reconnect Then
            Connect
        End If
    End If
End Sub
