VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsXDCPacket"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private strBuffer As String, strReader As String, Offset As Integer

Private Sub Class_Initialize()
    ClearBuffer
    ClearReader
End Sub

'// Return Buffer
Public Property Get Buffer()
    Buffer = strBuffer
End Property

'// Set Buffer Data
Public Property Let Buffer(Value)
    strBuffer = CStr(Value)
End Property

'// Return Reader
Public Property Get Reader()
    Reader = strReader
End Property

'// Set Reader Data
Public Property Let Reader(Value)
    strReader = CStr(Value)
    ReaderOffset = 1
End Property

'// Return Reader Offset
Public Property Get ReaderOffset()
    ReaderOffset = Offset
End Property

'// Set Reader Offset
Public Property Let ReaderOffset(Value)
    If Val(Value) > 0 And Val(Value) < Len(strReader) Then
        Offset = CInt(Value)
    End If
End Property

'// Skip forward Reader Offset
Public Sub Skip(Bytes As Integer)
    Offset = Offset + Bytes
End Sub

'// Skip backward Reader Offset
Public Sub Back(Bytes As Integer)
    Offset = Offset - Bytes
End Sub

'// Clear Reader
Public Sub ClearReader()
    strReader = vbNS
End Sub

'// Clear Buffer
Public Sub ClearBuffer()
    strBuffer = vbNS
End Sub

'// Insert BYTE at end of Buffer
Public Sub InsertBYTE(Value)
    strBuffer = strBuffer & Chr$(CByte(Value))
End Sub

'// Insert BYTE-Array at end of Buffer
Public Sub InsertBYTES(Values())
    Dim I As Integer
    For I = 0 To UBound(Values)
        InsertBYTE Values(I)
    Next I
End Sub

'// Insert WORD at end of Buffer
Public Sub InsertWORD(Value)
    strBuffer = strBuffer & CreateInt16(CInt(Value))
End Sub

'// Insert WORD-Array at end of Buffer
Public Sub InsertWORDS(Values())
    Dim I As Integer
    For I = 0 To UBound(Values)
        InsertWORD Values(I)
    Next I
End Sub

'// Insert DWORD at end of Buffer
Public Sub InsertDWORD(Value)
    strBuffer = strBuffer & CreateInt32(CLng(Value))
End Sub

'// Insert DWORD-Array at end of Buffer
Public Sub InsertDWORDS(Values())
    Dim I As Integer
    For I = 0 To UBound(Values)
        InsertDWORD Values(I)
    Next I
End Sub

'// Insert fixed STRING at end of Buffer
Public Sub InsertSTRING(Value)
    strBuffer = strBuffer & Value
End Sub

'// Insert fixed STRING-Array at end of Buffer
Public Sub InsertSTRINGS(Values())
    Dim I As Integer
    For I = 0 To UBound(Values)
        InsertSTRING Values(I)
    Next I
End Sub

'// Insert Terminated STRING at end of Buffer
Public Sub InsertTSTRING(Value, Terminator)
    InsertSTRING Value & Terminator
End Sub

'// Insert Terminated STRING-Array at end of Buffer
Public Sub InsertTSTRINGS(Values(), Terminator)
    Dim I As Integer
    For I = 0 To UBound(Values)
        InsertSTRING Values(I) & Terminator
    Next I
End Sub

'// Extract BYTE from Reader
Public Function ReadBYTE()
    If Offset + 1 > Len(strReader) Then Exit Function
    ReadBYTE = Mid$(strReader, Offset)
    Skip 1
End Function

'// Extract WORD from Reader
Public Function ReadWORD()
    If Offset + 2 > Len(strReader) Then Exit Function
    ReadWORD = ExtractInt16(Mid$(strReader, Offset, 2))
    Skip 2
End Function

'// Extract DWORD from Reader
Public Function ReadDWORD()
    If Offset + 4 > Len(strReader) Then Exit Function
    ReadDWORD = ExtractInt32(Mid$(strReader, Offset, 4))
    Skip 4
End Function

'// Extract FILETIME from Reader and Parse as Readable String
Public Function ReadFILETIME()
    If Offset + 8 > Len(strReader) Then Exit Function
    Dim FT As FILETIME, LT As FILETIME, ST As SYSTEMTIME
    FT = ExtractFT(Mid$(strReader, Offset, 8))
    FileTimeToLocalFileTime FT, LT
    FileTimeToSystemTime LT, ST
    ReadFILETIME = ProcessSystemTime(ST)
    Skip 8
End Function

'// Extract a fixed STRING from Reader
Public Function ReadSTRING(Optional Length = 4)
    If Val(Length) = 0 Then Exit Function
    If Offset + Val(Length) > Len(strReader) Then Exit Function
    ReadSTRING = Mid$(strReader, Offset, Val(Length))
    Skip CInt(Val(Length))
End Function

'// Extract a terminated STRING from Reader
Public Function ReadTSTRING(Terminator)
    If (InStrB(Mid$(strReader, Offset), Terminator) > 0) Then
        ReadTSTRING = Split(Mid$(strReader, Offset), Terminator)(0)
        Skip Len(ReadTSTRING) + Len(Terminator)
    End If
End Function
