VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsQueue"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public TickLast As Double, CurDelay As Long, Consecutive As Long
Private BasDelay As Long, LenDelay As Long, FrqDelay As Long, MaxDelay As Long, ExtDelay As Long, EveDelay As Long, mF As String

Private Const QUEUE_SECTION As String = "Queue"

Public Property Get BaseDelay() As Long
    BaseDelay = BasDelay
End Property

Public Property Let BaseDelay(v As Long)
    BasDelay = v
    If LenB(mF) <> 0 Then WriteINI mF, QUEUE_SECTION, "Base", CStr(BasDelay)
End Property

Public Property Get LengthDelay() As Long
    LengthDelay = LenDelay
End Property

Public Property Let LengthDelay(v As Long)
    LenDelay = v
    If LenB(mF) <> 0 Then WriteINI mF, QUEUE_SECTION, "Length", CStr(LenDelay)
End Property

Public Property Get FrequencyDelay() As Long
    FrequencyDelay = FrqDelay
End Property

Public Property Let FrequencyDelay(v As Long)
    FrqDelay = v
    If LenB(mF) <> 0 Then WriteINI mF, QUEUE_SECTION, "Freq", CStr(FrqDelay)
End Property

Public Property Get MaximumDelay() As Long
    MaximumDelay = MaxDelay
End Property

Public Property Let MaximumDelay(v As Long)
    MaxDelay = v
    If LenB(mF) <> 0 Then WriteINI mF, QUEUE_SECTION, "Max", CStr(MaxDelay)
End Property

Public Property Get ExtraDelay() As Long
    ExtraDelay = ExtDelay
End Property

Public Property Let ExtraDelay(v As Long)
    ExtDelay = v
    If LenB(mF) <> 0 Then WriteINI mF, QUEUE_SECTION, "Extra", CStr(ExtDelay)
End Property

Public Property Get EveryDelay() As Long
    EveryDelay = EveDelay
End Property

Public Property Let EveryDelay(v As Long)
    EveDelay = v
    If LenB(mF) <> 0 Then WriteINI mF, QUEUE_SECTION, "Every", CStr(EveDelay)
End Property

Public Sub Reload()
    If LenB(mF) <> 0 Then
        BasDelay = CLng(Val(ReadINI(mF, QUEUE_SECTION, "Base")))
        LenDelay = CLng(Val(ReadINI(mF, QUEUE_SECTION, "Length")))
        FrqDelay = CLng(Val(ReadINI(mF, QUEUE_SECTION, "Freq")))
        MaxDelay = CLng(Val(ReadINI(mF, QUEUE_SECTION, "Max")))
        ExtDelay = CLng(Val(ReadINI(mF, QUEUE_SECTION, "Extra")))
        EveDelay = CLng(Val(ReadINI(mF, QUEUE_SECTION, "Every")))
        If BasDelay = 0 And LenDelay = 0 And FrqDelay = 0 And MaxDelay = 0 And ExtDelay = 0 And EveDelay = 0 Then
            BaseDelay = 2000
            LengthDelay = 25
            FrequencyDelay = 15
            MaximumDelay = 6000
            ExtraDelay = 500
            EveryDelay = 4
        End If
        If BasDelay = 0 Then BaseDelay = 2000
    End If
End Sub

Public Sub Load(F As String)
    CreateFile F
    mF = F
    Reload
End Sub

Public Sub NextDelay(Message As String)
On Error Resume Next
    Dim LD As Long, FD As Long
    If LenDelay = 0 Or Len(Message) = 0 Then LD = 0 Else LD = Len(Message) * LenDelay
    If FrqDelay = 0 Or Consecutive = 0 Then FD = 0 Else FD = Consecutive * FrqDelay
    
    'DELAY = BD + CD + FD
    CurDelay = BasDelay + LD + FD
    'DELAY = MD
    If CurDelay > MaxDelay Then CurDelay = MaxDelay
    If (EveDelay > 0) And (Consecutive > 0) And (ExtDelay > 0) Then
        'DELAY = DELAY + ED
        If (Consecutive Mod EveDelay) = 0 Then CurDelay = CurDelay + ExtDelay
    End If
End Sub
