VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsOptions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'-----------------------------------------------------
' MirageBot Options Class
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit
Private Const SE As String = "Settings"

Private Broadcasts As String, Mutators As String
Private dTimerReconnect As Double, dTimerFlood As Double, mAlertName As Boolean, mDisableAdvInfo As Boolean, mFilterNudge As Boolean, mFilterGame As Boolean, mDisableChatColors As Boolean, mDisableConfirmExit As Boolean, _
    mTabString As String, mDisableIdleColors As Boolean, mFilterFriend As Boolean, mDisableUTF8Decode As Boolean, mDisableUTF8Encode As Boolean, _
    mDisableSilentView As Boolean, mDisableStyleBar As Boolean, mTrayStart As Boolean, mLogging As LOGMODE, _
    mTrayMin As Boolean, mDisableVerboseConsole As Boolean, mDisableClanIcons As Boolean, mFilterRepeatBan As Boolean, _
    mPassword As String, mRequireNLS As Boolean, mDisableRealmName As Boolean, mTrigger(6) As String, mAutoReconnect As Boolean, mIcons As Integer, mFilterUnsafe As Boolean, _
    mCommandDebug As Boolean, mCommandGlobal As Boolean, mEmoticons As Boolean, mEmoticonSet As String, mFilterUnsafeNudge As Boolean, _
    mAutoConnectAll As Boolean, mAutoHideAll As Boolean, mAutoLockAll As Boolean, mAutoLoadAll As Boolean, mFilterBanFlood As Boolean, _
    mBNLS() As String, mFilterKick As Boolean, mFilterBan As Boolean, mFilterEmote As Boolean, mFilterLoad As Boolean, _
    mFilterSTAR As Boolean, mFilterSEXP As Boolean, mFilterD2DV As Boolean, mFilterD2XP As Boolean, mFilterW2BN As Boolean, mFilterWAR3 As Boolean, mFilterW3XP As Boolean, _
    mFilterAccount As Boolean, mFilterJoin As Boolean, mChannel(6) As String, mRTFInj As Boolean, mFilterPing As Integer, _
    mAlertFlood As Boolean, mAlertNoFlood As Boolean, mAlertKicked As Boolean, mAlertMin As Boolean, mFilterPresent As Boolean, mDisableClanColors As Boolean, _
    mFocusBack As Boolean, mPreventSleep As Boolean, mFocusFlash As Boolean, mFocusMax As Integer, mFocusAuto As Boolean, mEncryption As Integer, mPrevLoad As Boolean, mPrevProf As String
Public ProfileAge As String, ProfileSex As String, ProfileLocation As String, ProfileDescription As String

Public Property Get Logging() As LOGMODE
    Logging = mLogging
End Property
Public Property Let Logging(Value As LOGMODE)
    mLogging = Value
    WriteINI AppSettings, SE, "Logging", CStr(Value)
    frmBot.mnuLogging(0).Checked = Value = lmDisabled
    frmBot.mnuLogging(1).Checked = Value = lmHTML
    frmBot.mnuLogging(2).Checked = Value = lmText
End Property

Public Property Get TabString() As String
    TabString = mTabString
End Property
Public Property Let TabString(Value As String)
    mTabString = Value
    WriteINI AppSettings, SE, "TabString", Value
End Property

Public Property Get PreventSleep() As Boolean
    PreventSleep = mPreventSleep
End Property
Public Property Let PreventSleep(V As Boolean)
    mPreventSleep = V
    WriteINI AppSettings, SE, "PreventSleep", YesNo(V)
    If V Then
        SetThreadExecutionState ES_SYSTEM_REQUIRED Or ES_CONTINUOUS
    Else
        SetThreadExecutionState ES_CONTINUOUS
    End If
End Property

Public Property Get RTFInj() As Boolean
    RTFInj = mRTFInj
End Property
Public Property Let RTFInj(V As Boolean)
    mRTFInj = V
    WriteINI AppSettings, SE, "RTFInj", YesNo(V)
End Property

Public Property Get TimerReconnect() As Double
    If dTimerReconnect = 0 Then dTimerReconnect = 8
    TimerReconnect = dTimerReconnect
End Property
Public Property Let TimerReconnect(V As Double)
    dTimerReconnect = V
    If dTimerReconnect = 0 Then dTimerReconnect = 8
    WriteINI AppSettings, "Timers", "Reconnect", CStr(V)
End Property

Public Property Get TimerFlood() As Double
    If dTimerFlood = 0 Then dTimerFlood = 60000
    TimerFlood = dTimerFlood
End Property
Public Property Let TimerFlood(V As Double)
    dTimerFlood = V
    If dTimerFlood = 0 Then dTimerFlood = 60000
    WriteINI AppSettings, "Timers", "Flood", CStr(V)
End Property

Public Property Get SpokenAll() As String
    SpokenAll = mTrigger(0)
End Property
Public Property Let SpokenAll(V As String)
    mTrigger(0) = V
    If Len(V) < 2 Or Len(V) > 4 Then mTrigger(0) = "!!"
    WriteINI AppSettings, "Triggers", "SpokenAll", V
End Property

Public Property Get SpokenNon() As String
    SpokenNon = mTrigger(1)
End Property
Public Property Let SpokenNon(V As String)
    mTrigger(1) = V
    If Len(V) < 2 Or Len(V) > 4 Then mTrigger(1) = "!`"
    WriteINI AppSettings, "Triggers", "SpokenNon", V
End Property

Public Property Get SpokenOps() As String
    SpokenOps = mTrigger(2)
End Property
Public Property Let SpokenOps(V As String)
    mTrigger(2) = V
    If Len(V) < 2 Or Len(V) > 4 Then mTrigger(2) = "!~"
    WriteINI AppSettings, "Triggers", "SpokenOps", V
End Property

Public Property Get ConsoleAll() As String
    ConsoleAll = mTrigger(3)
End Property
Public Property Let ConsoleAll(V As String)
    mTrigger(3) = V
    If Len(V) < 2 Or Len(V) > 4 Then mTrigger(3) = "//"
    WriteINI AppSettings, "Triggers", "ConsoleAll", V
End Property

Public Property Get ConsoleSrv() As String
    ConsoleSrv = mTrigger(4)
End Property
Public Property Let ConsoleSrv(V As String)
    mTrigger(4) = V
    If Len(V) < 2 Or Len(V) > 4 Then mTrigger(4) = "/@"
    WriteINI AppSettings, "Triggers", "ConsoleSrv", V
End Property

Public Property Get ConsoleNon() As String
    ConsoleNon = mTrigger(5)
End Property
Public Property Let ConsoleNon(V As String)
    mTrigger(5) = V
    If Len(V) < 2 Or Len(V) > 4 Then mTrigger(5) = "/`"
    WriteINI AppSettings, "Triggers", "ConsoleNon", V
End Property

Public Property Get ConsoleOps() As String
    ConsoleOps = mTrigger(6)
End Property
Public Property Let ConsoleOps(V As String)
    mTrigger(6) = V
    If Len(V) < 2 Or Len(V) > 4 Then mTrigger(6) = "/~"
    WriteINI AppSettings, "Triggers", "ConsoleOps", V
End Property

Public Property Get PrevProf() As String
    PrevProf = mPrevProf
End Property
Public Property Let PrevProf(V As String)
    mPrevProf = V
    WriteINI AppSettings, SE, "PrevProf", V
End Property


Public Function BroadcastInList(Message As String) As Boolean
    Dim S() As String, i As Integer
    S = Split(Broadcasts, vbNewLine)
    For i = 0 To UBound(S)
        If InStr(S(i), "*") Then
            If Matches(Message, S(i)) Then BroadcastInList = True: Exit Function
        End If
        If LCase$(Message) = LCase$(S(i)) Then BroadcastInList = True: Exit Function
    Next i
End Function

Public Function MutatorInList(Message As String) As String
    Dim S() As String, i As Integer, M() As String
    S = Split(Mutators, vbNewLine)
    For i = 0 To UBound(S)
        M = Split(S(i), " >> ")
        If UBound(M) = 1 Then
            If LCase$(M(0)) = LCase$(Message) Then
                MutatorInList = M(1)
            End If
        End If
    Next i
End Function

Public Property Get AlertFlood() As Boolean
    AlertFlood = mAlertFlood
End Property

Public Property Let AlertFlood(ByVal V As Boolean)
    mAlertFlood = V
    WriteINI AppSettings, "Alerts", "Flood", YesNo(V)
End Property

Public Property Get FocusBack() As Boolean
    FocusBack = mFocusBack
End Property

Public Property Let FocusBack(ByVal V As Boolean)
    mFocusBack = V
    WriteINI AppSettings, "Focus", "Back", YesNo(V)
End Property

Public Property Get FocusFlash() As Boolean
    FocusFlash = mFocusFlash
End Property

Public Property Let FocusFlash(ByVal V As Boolean)
    mFocusFlash = V
    WriteINI AppSettings, "Focus", "Flash", YesNo(V)
End Property

Public Property Get FocusAuto() As Boolean
    FocusAuto = mFocusAuto
End Property

Public Property Let FocusAuto(ByVal V As Boolean)
    mFocusAuto = V
    WriteINI AppSettings, "Focus", "Auto", YesNo(V)
End Property

Public Property Get FocusMax() As Integer
    FocusMax = mFocusMax
End Property

Public Property Let FocusMax(ByVal V As Integer)
    mFocusMax = V
    WriteINI AppSettings, "Focus", "Max", CStr(V)
End Property

Public Property Get AlertMin() As Boolean
    AlertMin = mAlertMin
End Property

Public Property Let AlertMin(ByVal V As Boolean)
    mAlertMin = V
    WriteINI AppSettings, "Alerts", "Min", YesNo(V)
End Property
        
Public Property Get AlertNoFlood() As Boolean
    AlertNoFlood = mAlertNoFlood
End Property

Public Property Let AlertNoFlood(ByVal V As Boolean)
    mAlertNoFlood = V
    WriteINI AppSettings, "Alerts", "NoFlood", YesNo(V)
End Property

Public Property Get AlertKicked() As Boolean
    AlertKicked = mAlertKicked
End Property

Public Property Let AlertKicked(ByVal V As Boolean)
    mAlertKicked = V
    WriteINI AppSettings, "Alerts", "Kicked", YesNo(V)
End Property

Public Property Get AlertName() As Boolean
    AlertName = mAlertName
End Property

Public Property Let AlertName(ByVal V As Boolean)
    mAlertName = V
    WriteINI AppSettings, "Alerts", "Name", YesNo(V)
End Property

Public Sub Class_Terminate()
    On Error Resume Next
    Export
End Sub

Public Property Get BNLS(Index As Integer) As String
    If Index > UBound(mBNLS) Then BNLS = "bnls.mattkv.net": Exit Property
    BNLS = mBNLS(Index)
    If LenB(BNLS) = 0 Then BNLS = "bnls.mattkv.net"
End Property

Public Property Get BNLSCount() As Long
    BNLSCount = UBound(mBNLS)
End Property

Public Sub Export()
    Dim FF As Integer, Ar As String
    FF = FreeFile
    Ar = AppData & "Data\Other\DynamicProfile.ini"
    If Right$(ProfileAge, Len(vbNewLine)) = vbNewLine Then ProfileAge = Left$(ProfileAge, Len(ProfileAge) - Len(vbNewLine))
    If Right$(ProfileSex, Len(vbNewLine)) = vbNewLine Then ProfileSex = Left$(ProfileSex, Len(ProfileSex) - Len(vbNewLine))
    If Right$(ProfileLocation, Len(vbNewLine)) = vbNewLine Then ProfileLocation = Left$(ProfileLocation, Len(ProfileLocation) - Len(vbNewLine))
    If Right$(ProfileDescription, Len(vbNewLine)) = vbNewLine Then ProfileDescription = Left$(ProfileDescription, Len(ProfileDescription) - Len(vbNewLine))
    Open Ar For Append As #FF
    Close #FF
    Open Ar For Output As #FF
        Print #FF, "[Age]"
        Print #FF, ProfileAge
        Print #FF, "[Sex]"
        Print #FF, ProfileSex
        Print #FF, "[Location]"
        Print #FF, ProfileLocation
        Print #FF, "[Description]"
        Print #FF, ProfileDescription
    Close #FF
End Sub

Public Property Get FilterGame() As Boolean
    FilterGame = mFilterGame
End Property

Public Property Let FilterGame(V As Boolean)
    mFilterGame = V
    WriteINI AppSettings, "Filter", "Game", YesNo(V)
    frmBot.mnuFilterOpt(1).Checked = V
End Property

Public Property Get Icons() As Integer
    Icons = mIcons
End Property

Public Property Let Icons(V As Integer)
    mIcons = V
    Dim i As Integer, C As Control
    For i = 0 To 6
        frmBot.mnuDIcons(i).Checked = False
    Next i
    frmBot.mnuDIcons(V).Checked = True
    WriteINI AppSettings, SE, "Icons", CStr(V)
    For Each C In frmBot.Controls
        If TypeName(C) = "ListView" And C.Name <> "lvChars" And C.Name <> "lvDB" And C.Name <> "lvFrame" Then
            ApplyIcons C
        End If
    Next
End Property

Public Property Get Emoticons() As Boolean
    Emoticons = mEmoticons
End Property

Public Property Let Emoticons(V As Boolean)
    mEmoticons = V
    frmBot.mnuParseEmoticons.Checked = V
    WriteINI AppSettings, SE, "Emoticons", YesNo(V)
End Property

Public Property Get EmoticonSet() As String
    EmoticonSet = mEmoticonSet
End Property

Public Property Let EmoticonSet(V As String)
    mEmoticonSet = V
    LoadEmoticons V
    WriteINI AppSettings, SE, "EmoticonSet", V
End Property

Public Property Get FilterFriend() As Boolean
    FilterFriend = mFilterFriend
End Property

Public Property Let FilterFriend(V As Boolean)
    mFilterFriend = V
    WriteINI AppSettings, "Filter", "Friend", YesNo(V)
    frmBot.mnuFilterOpt(3).Checked = V
End Property

Public Property Get FilterAccount() As Boolean
    FilterAccount = mFilterAccount
End Property

Public Property Let FilterAccount(V As Boolean)
    mFilterAccount = V
    WriteINI AppSettings, "Filter", "Account", YesNo(V)
    frmBot.mnuFilterOpt(0).Checked = V
End Property

Public Property Get FilterJoin() As Boolean
    FilterJoin = mFilterJoin
End Property

Public Property Let FilterJoin(V As Boolean)
    mFilterJoin = V
    WriteINI AppSettings, "Filter", "Join", YesNo(V)
    frmBot.mnuFilterOptU(2).Checked = V
End Property

Public Property Get FilterPresent() As Boolean
    FilterPresent = mFilterPresent
End Property

Public Property Let FilterPresent(V As Boolean)
    mFilterPresent = V
    WriteINI AppSettings, "Filter", "Present", YesNo(V)
    frmBot.mnuFilterOptU(4).Checked = V
End Property

Public Property Get FilterPing() As Integer
    FilterPing = mFilterPing
End Property

Public Property Let FilterPing(V As Integer)
    mFilterPing = V
    WriteINI AppSettings, "Filter", "Ping", CStr(V)
    Dim i%
    For i = 0 To frmBot.mnuFP.UBound
        frmBot.mnuFP(i).Checked = i = V
    Next
End Property

Public Property Get FilterEmote() As Boolean
    FilterEmote = mFilterEmote
End Property

Public Property Let FilterEmote(V As Boolean)
    mFilterEmote = V
    WriteINI AppSettings, "Filter", "Emote", YesNo(V)
    frmBot.mnuFilterOptU(1).Checked = V
End Property

Public Property Get FilterBan() As Boolean
    FilterBan = mFilterBan
End Property

Public Property Let FilterBan(V As Boolean)
    mFilterBan = V
    WriteINI AppSettings, "Filter", "Ban", YesNo(V)
    frmBot.mnuFilterOptU(0).Checked = V
End Property

Public Property Get FilterKick() As Boolean
    FilterKick = mFilterKick
End Property

Public Property Let FilterKick(V As Boolean)
    mFilterKick = V
    WriteINI AppSettings, "Filter", "Kick", YesNo(V)
    frmBot.mnuFilterOptU(3).Checked = V
End Property

Public Property Get FilterUnsafe() As Boolean
    FilterUnsafe = mFilterUnsafe
End Property

Public Property Let FilterUnsafe(V As Boolean)
    mFilterUnsafe = V
    WriteINI AppSettings, "Filter", "Unsafe", YesNo(V)
    frmBot.mnuFilterOptU(6).Checked = V
End Property

Public Property Get FilterRepeatBan() As Boolean
    FilterRepeatBan = mFilterRepeatBan
End Property

Public Property Let FilterRepeatBan(V As Boolean)
    mFilterRepeatBan = V
    WriteINI AppSettings, "Filter", "RepeatBan", YesNo(V)
    frmBot.mnuFilterOptU(5).Checked = V
End Property

Public Property Get FilterBanFlood() As Boolean
    FilterBanFlood = mFilterBanFlood
End Property

Public Property Let FilterBanFlood(V As Boolean)
    mFilterBanFlood = V
    WriteINI AppSettings, "Filter", "BanFlood", YesNo(V)
    frmBot.mnuFilterBanDur.Checked = V
End Property

Public Property Get FilterD2DV() As Boolean
    FilterD2DV = mFilterD2DV
End Property

Public Property Let FilterD2DV(V As Boolean)
    mFilterD2DV = V
    WriteINI AppSettings, "Filter", "D2DV", YesNo(V)
    frmBot.mnuFC(0).Checked = V
End Property

Public Property Get FilterD2XP() As Boolean
    FilterD2XP = mFilterD2XP
End Property

Public Property Let FilterD2XP(V As Boolean)
    mFilterD2XP = V
    WriteINI AppSettings, "Filter", "D2XP", YesNo(V)
    frmBot.mnuFC(1).Checked = V
End Property

Public Property Get FilterSTAR() As Boolean
    FilterSTAR = mFilterSTAR
End Property

Public Property Let FilterSTAR(V As Boolean)
    mFilterSTAR = V
    WriteINI AppSettings, "Filter", "STAR", YesNo(V)
    frmBot.mnuFC(2).Checked = V
End Property

Public Property Get FilterSEXP() As Boolean
    FilterSEXP = mFilterSEXP
End Property

Public Property Let FilterSEXP(V As Boolean)
    mFilterSEXP = V
    WriteINI AppSettings, "Filter", "SEXP", YesNo(V)
    frmBot.mnuFC(3).Checked = V
End Property

Public Property Get FilterW2BN() As Boolean
    FilterW2BN = mFilterW2BN
End Property

Public Property Let FilterW2BN(V As Boolean)
    mFilterW2BN = V
    WriteINI AppSettings, "Filter", "W2BN", YesNo(V)
    frmBot.mnuFC(4).Checked = V
End Property

Public Property Get FilterWAR3() As Boolean
    FilterWAR3 = mFilterWAR3
End Property

Public Property Let FilterWAR3(V As Boolean)
    mFilterWAR3 = V
    WriteINI AppSettings, "Filter", "WAR3", YesNo(V)
    frmBot.mnuFC(5).Checked = V
End Property

Public Property Get FilterW3XP() As Boolean
    FilterW3XP = mFilterW3XP
End Property

Public Property Let FilterW3XP(V As Boolean)
    mFilterW3XP = V
    WriteINI AppSettings, "Filter", "W3XP", YesNo(V)
    frmBot.mnuFC(6).Checked = V
End Property

Public Property Get FilterLoad() As Boolean
    FilterLoad = mFilterLoad
End Property

Public Property Let FilterLoad(V As Boolean)
    mFilterLoad = V
    WriteINI AppSettings, "Filter", "FilterLoad", YesNo(V)
    frmBot.mnuFilterRule.Checked = V
End Property

Public Property Get DisableClanColors() As Boolean
    DisableClanColors = mDisableClanColors
End Property

Public Property Let DisableClanColors(V As Boolean)
    mDisableClanColors = V
    WriteINI AppSettings, SE, "DisableClanColors", YesNo(V)
End Property

Public Property Get DisableClanIcons() As Boolean
    DisableClanIcons = mDisableClanIcons
End Property

Public Property Let DisableClanIcons(V As Boolean)
    mDisableClanIcons = V
    WriteINI AppSettings, SE, "DisableClanIcons", YesNo(V)
End Property

Public Property Get DisableRealmName() As Boolean
    DisableRealmName = mDisableRealmName
End Property

Public Property Let DisableRealmName(V As Boolean)
    mDisableRealmName = V
    WriteINI AppSettings, SE, "DisableRealmName", YesNo(V)
End Property

Public Property Get AutoReconnect() As Boolean
    AutoReconnect = mAutoReconnect
End Property

Public Property Let AutoReconnect(V As Boolean)
    mAutoReconnect = V
    WriteINI AppSettings, SE, "AutoReconnect", YesNo(V)
    frmBot.mnuCAuto(2).Checked = V
End Property

Public Property Get RequireNLS() As Boolean
    RequireNLS = mRequireNLS
End Property

Public Property Let RequireNLS(V As Boolean)
    mRequireNLS = V
    WriteINI AppSettings, SE, "RequireNLS", YesNo(V)
End Property

Public Property Get DisableAdvInfo() As Boolean
    DisableAdvInfo = mDisableAdvInfo
End Property

Public Property Let DisableAdvInfo(V As Boolean)
    mDisableAdvInfo = V
    WriteINI AppSettings, SE, "DisableAdvInfo", YesNo(V)
End Property

Public Property Get FilterUnsafeNudge() As Boolean
    FilterUnsafeNudge = mFilterUnsafeNudge
End Property

Public Property Let FilterUnsafeNudge(V As Boolean)
    mFilterUnsafeNudge = V
    WriteINI AppSettings, SE, "FilterUnsafeNudge", YesNo(V)
    frmBot.mnuFilterOpt(4).Checked = V
End Property

Public Property Get Encryption() As Integer
    Encryption = mEncryption
End Property

Public Property Let Encryption(V As Integer)
    If V > 4 Or V < 0 Then V = 0
    mEncryption = V
    WriteINI AppSettings, SE, "Encryption", CStr(V)
    frmBot.mnuEncryption(0).Checked = V = 0
    frmBot.mnuEncryption(1).Checked = V = 1
    frmBot.mnuEncryption(2).Checked = V = 2
    frmBot.mnuEncryption(3).Checked = V = 3
    frmBot.mnuEncryption(4).Checked = V = 4
End Property

Public Property Get CommandGlobal() As Boolean
    CommandGlobal = mCommandGlobal
End Property

Public Property Let CommandGlobal(V As Boolean)
    mCommandGlobal = V
    WriteINI AppSettings, SE, "CommandGlobal", YesNo(V)
    frmBot.mnuCommFunc.Checked = V
End Property

Public Property Get CommandDebug() As Boolean
    CommandDebug = mCommandDebug
End Property

Public Property Let CommandDebug(V As Boolean)
    mCommandDebug = V
    WriteINI AppSettings, SE, "CommandDebug", YesNo(V)
    frmBot.mnuDBC.Checked = V
End Property

Public Property Get DisableStyleBar() As Boolean
    DisableStyleBar = mDisableStyleBar
End Property

Public Property Let DisableStyleBar(V As Boolean)
    mDisableStyleBar = V
    WriteINI AppSettings, SE, "DisableStyleBar", YesNo(V)
    frmBot.mnuHideStyleBar.Caption = IIf(V, "Show Style Bar", "Hide Style Bar")
End Property

Public Property Get FilterNudge() As Boolean
    FilterNudge = mFilterNudge
End Property

Public Property Let FilterNudge(V As Boolean)
    mFilterNudge = V
    WriteINI AppSettings, "Filter", "Nudge", YesNo(V)
    frmBot.mnuFilterOpt(2).Checked = V
End Property

Public Property Get DisableChatColors() As Boolean
    DisableChatColors = mDisableChatColors
End Property

Public Property Let DisableChatColors(V As Boolean)
    mDisableChatColors = V
    WriteINI AppSettings, SE, "DisableChatColors", YesNo(V)
End Property

Public Property Get DisableConfirmExit() As Boolean
    DisableConfirmExit = mDisableConfirmExit
End Property

Public Property Let DisableConfirmExit(V As Boolean)
    mDisableConfirmExit = V
    WriteINI AppSettings, SE, "DisableConfirmExit", YesNo(V)
End Property

Public Property Get AutoConnectAll() As Boolean
    AutoConnectAll = mAutoConnectAll
End Property

Public Property Let AutoConnectAll(V As Boolean)
    mAutoConnectAll = V
    WriteINI AppSettings, SE, "AutoConnectAll", YesNo(V)
    frmBot.mnuCAuto(1).Checked = V
End Property

Public Property Get AutoLockAll() As Boolean
    AutoLockAll = mAutoLockAll
End Property

Public Property Let AutoLockAll(V As Boolean)
    mAutoLockAll = V
    WriteINI AppSettings, SE, "AutoLockAll", YesNo(V)
    frmBot.mnuAutoLockAll.Checked = V
End Property

Public Property Get AutoHideAll() As Boolean
    AutoHideAll = mAutoHideAll
End Property

Public Property Let AutoHideAll(V As Boolean)
    mAutoHideAll = V
    WriteINI AppSettings, SE, "AutoHideAll", YesNo(V)
    frmBot.mnuAutoHideAll.Checked = V
End Property

Public Property Get AutoLoadAll() As Boolean
    AutoLoadAll = mAutoLoadAll
End Property

Public Property Let AutoLoadAll(V As Boolean)
    mAutoLoadAll = V
    WriteINI AppSettings, SE, "AutoLoadAll", YesNo(V)
    frmBot.mnuAutoLoad.Checked = V
    If V Then PrevLoad = False
End Property

Public Property Get PrevLoad() As Boolean
    PrevLoad = mPrevLoad
End Property

Public Property Let PrevLoad(V As Boolean)
    mPrevLoad = V
    WriteINI AppSettings, SE, "PrevLoad", YesNo(V)
    frmBot.mnuRemember.Checked = V
    If V Then AutoLoadAll = False
End Property

Public Property Get DisableVerboseConsole() As Boolean
    DisableVerboseConsole = mDisableVerboseConsole
End Property

Public Property Let DisableVerboseConsole(V As Boolean)
    mDisableVerboseConsole = V
    WriteINI AppSettings, SE, "DisableVerboseConsole", YesNo(V)
End Property

Public Property Get DisableUTF8Encode() As Boolean
    DisableUTF8Encode = mDisableUTF8Encode
End Property

Public Property Let DisableUTF8Encode(V As Boolean)
    mDisableUTF8Encode = V
    WriteINI AppSettings, SE, "DisableUTF8Encode", YesNo(V)
End Property

Public Property Get DisableUTF8Decode() As Boolean
    DisableUTF8Decode = mDisableUTF8Decode
End Property

Public Property Let DisableUTF8Decode(V As Boolean)
    mDisableUTF8Decode = V
    WriteINI AppSettings, SE, "DisableUTF8Decode", YesNo(V)
End Property

Public Property Get DisableIdleColors() As Boolean
    DisableIdleColors = mDisableIdleColors
End Property

Public Property Let DisableIdleColors(V As Boolean)
    mDisableIdleColors = V
    WriteINI AppSettings, SE, "DisableIdleColors", YesNo(V)
End Property

Public Property Get DisableSilentView() As Boolean
    DisableSilentView = mDisableSilentView
End Property

Public Property Let DisableSilentView(V As Boolean)
    mDisableSilentView = V
    WriteINI AppSettings, SE, "DisableSilentView", YesNo(V)
End Property

Public Property Get TrayMin() As Boolean
    TrayMin = mTrayMin
End Property

Public Property Let TrayMin(V As Boolean)
    mTrayMin = V
    WriteINI AppSettings, SE, "TrayMin", YesNo(V)
End Property

Public Property Get TrayStart() As Boolean
    TrayStart = mTrayStart
End Property

Public Property Let TrayStart(V As Boolean)
    mTrayStart = V
    WriteINI AppSettings, SE, "TrayStart", YesNo(V)
End Property

Public Property Get Password() As String
    Password = mPassword
End Property

Public Property Let Password(V As String)
    mPassword = V
    WriteINI AppSettings, SE, "MasterPassword", StringToAsc(V)
End Property

Public Sub Reload()
On Error GoTo hErr:
1   Const SE As String = "Settings", FI As String = "Filter", AL As String = "Alerts", FO As String = "Focus", tR As String = "Triggers"
2   ReDim mBNLS(0)
    Dim Ap As String
3   Ap = AppSettings
4   CreateFile Ap
5   EmoticonSet = ReadINI(Ap, SE, "EmoticonSet")
    If LenB(EmoticonSet) = 0 Then EmoticonSet = "Classic"
6   AutoReconnect = IsYes(ReadINI(Ap, SE, "AutoReconnect"), True)
7   AutoConnectAll = IsYes(ReadINI(Ap, SE, "AutoConnectAll"))
8   AutoHideAll = IsYes(ReadINI(Ap, SE, "AutoHideAll"))
9   AutoLoadAll = IsYes(ReadINI(Ap, SE, "AutoLoadAll"))
10  AutoLockAll = IsYes(ReadINI(Ap, SE, "AutoLockAll"))
12  RequireNLS = IsYes(ReadINI(Ap, SE, "RequireNLS"))
    PrevLoad = IsYes(ReadINI(Ap, SE, "PrevLoad"), True)
    PrevProf = ReadINI(Ap, SE, "PrevProf")
13  CommandDebug = IsYes(ReadINI(Ap, SE, "CommandDebug"))
    CommandGlobal = IsYes(ReadINI(Ap, SE, "CommandGlobal"))
14  Emoticons = IsYes(ReadINI(Ap, SE, "Emoticons"), True)
15  TrayMin = IsYes(ReadINI(Ap, SE, "TrayMin"), True)
16  TrayStart = IsYes(ReadINI(Ap, SE, "TrayStart"))
17  Icons = Val(ReadINI(Ap, SE, "Icons"))
18  Password = AscToString(ReadINI(Ap, SE, "MasterPassword"))
    DisableAdvInfo = IsYes(ReadINI(Ap, SE, "DisableAdvInfo"))
20  DisableClanIcons = IsYes(ReadINI(Ap, SE, "DisableClanIcons"))
21  DisableChatColors = IsYes(ReadINI(Ap, SE, "DisableChatColors"))
22  DisableStyleBar = IsYes(ReadINI(Ap, SE, "DisableStyleBar"))
24  DisableRealmName = IsYes(ReadINI(Ap, SE, "DisableRealmName"))
25  DisableVerboseConsole = IsYes(ReadINI(Ap, SE, "DisableVerboseConsole"), True)
26  DisableIdleColors = IsYes(ReadINI(Ap, SE, "DisableIdleColors"))
27  DisableSilentView = IsYes(ReadINI(Ap, SE, "DisableSilentView"), True)
    DisableUTF8Encode = IsYes(ReadINI(Ap, SE, "DisableUTF8Encode"))
    DisableUTF8Decode = IsYes(ReadINI(Ap, SE, "DisableUTF8Decode"))
    Logging = Val(ReadINI(Ap, SE, "Logging"))
    PreventSleep = IsYes(ReadINI(Ap, SE, "PreventSleep"), True)
    RTFInj = IsYes(ReadINI(Ap, SE, "RTFInj"))
    Encryption = CInt(Val(ReadINI(Ap, SE, "Encryption")))
    DisableConfirmExit = IsYes(ReadINI(Ap, SE, "DisableConfirmExit"))
    FilterPing = Val(ReadINI(Ap, FI, "Ping"))
    FilterD2DV = IsYes(ReadINI(Ap, FI, "D2DV"))
    FilterD2XP = IsYes(ReadINI(Ap, FI, "D2XP"))
    FilterSTAR = IsYes(ReadINI(Ap, FI, "STAR"))
    FilterSEXP = IsYes(ReadINI(Ap, FI, "SEXP"))
    FilterW2BN = IsYes(ReadINI(Ap, FI, "W2BN"))
    FilterWAR3 = IsYes(ReadINI(Ap, FI, "WAR3"))
    FilterW3XP = IsYes(ReadINI(Ap, FI, "W3XP"))
19  FilterUnsafeNudge = IsYes(ReadINI(Ap, SE, "FilterUnsafeNudge"))
28  FilterGame = IsYes(ReadINI(Ap, FI, "Game"))
29  FilterUnsafe = IsYes(ReadINI(Ap, FI, "Unsafe"))
30  FilterNudge = IsYes(ReadINI(Ap, FI, "Nudge"))
31  FilterKick = IsYes(ReadINI(Ap, FI, "Kick"))
32  FilterBan = IsYes(ReadINI(Ap, FI, "Ban"))
33  FilterEmote = IsYes(ReadINI(Ap, FI, "Emote"))
34  FilterFriend = IsYes(ReadINI(Ap, FI, "Friend"), True)
35  FilterAccount = IsYes(ReadINI(Ap, FI, "Account"))
36  FilterJoin = IsYes(ReadINI(Ap, FI, "Join"))
37  FilterPresent = IsYes(ReadINI(Ap, FI, "Present"), True)
    FilterRepeatBan = IsYes(ReadINI(Ap, FI, "RepeatBan"), True)
    FilterBanFlood = IsYes(ReadINI(Ap, FI, "BanFlood"), True)
40  FilterLoad = IsYes(ReadINI(Ap, FI, "FilterLoad"), True)
41  AlertFlood = IsYes(ReadINI(Ap, AL, "Flood"))
42  AlertNoFlood = IsYes(ReadINI(Ap, AL, "NoFlood"))
43  AlertKicked = IsYes(ReadINI(Ap, AL, "Kicked"), True)
    AlertMin = IsYes(ReadINI(Ap, AL, "Min"))
    AlertName = IsYes(ReadINI(Ap, AL, "Name"))
    FocusBack = IsYes(ReadINI(Ap, FO, "Back"))
    FocusFlash = IsYes(ReadINI(Ap, FO, "Flash"))
    SpokenAll = ReadINI(Ap, tR, "SpokenAll")
    SpokenNon = ReadINI(Ap, tR, "SpokenNon")
    SpokenOps = ReadINI(Ap, tR, "SpokenOps")
    ConsoleAll = ReadINI(Ap, tR, "ConsoleAll")
    ConsoleSrv = ReadINI(Ap, tR, "ConsoleSrv")
    ConsoleNon = ReadINI(Ap, tR, "ConsoleNon")
    ConsoleOps = ReadINI(Ap, tR, "ConsoleOps")
    TimerReconnect = Val(ReadINI(Ap, "Timers", "Reconnect"))
    TimerFlood = Val(ReadINI(Ap, "Timers", "Flood"))
    TabString = ReadINI(Ap, SE, "TabString")
    
    If Len(ReadINI(Ap, FO, "Auto")) = 0 Then FocusAuto = True Else FocusAuto = IsYes(ReadINI(Ap, FO, "Auto"))
    FocusMax = Val(ReadINI(Ap, FO, "Max"))
    If FocusMax < 5 Then FocusMax = 5
    
    Dim FF As Integer, L As String, Ar As String, p As Integer
    FF = FreeFile
    Ar = AppData & "Data\Other\BnlsServers.ini"
    Open Ar For Append As #FF
    Close #FF
    Open Ar For Input As #FF
    Do Until EOF(FF)
        Line Input #FF, L
        If LenB(L) > 0 Then
            If LenB(mBNLS(0)) > 0 Then ReDim Preserve mBNLS(UBound(mBNLS) + 1)
            mBNLS(UBound(mBNLS)) = L
        End If
    Loop
    Close #FF
    
    Broadcasts = ReadFile(AppData & "Data\Other\Broadcast.txt")
    Mutators = ReadFile(AppData & "Data\Other\Mutators.txt")
    
    FF = FreeFile
    Ar = AppData & "Data\Other\DynamicProfile.ini"
    ProfileAge = vbNS
    ProfileSex = vbNS
    ProfileLocation = vbNS
    ProfileDescription = vbNS
    Open Ar For Append As #FF
    Close #FF
    Open Ar For Input As #FF
    Do Until EOF(FF)
        Line Input #FF, L
        Select Case L
        Case "[Age]": p = 1
        Case "[Sex]": p = 2
        Case "[Location]": p = 3
        Case "[Description]": p = 4
        Case Else
            Select Case p
            Case 1: ProfileAge = ProfileAge & L & vbNewLine
            Case 2: ProfileSex = ProfileSex & L & vbNewLine
            Case 3: ProfileLocation = ProfileLocation & L & vbNewLine
            Case 4: ProfileDescription = ProfileDescription & L & vbNewLine
            End Select
        End Select
    Loop
    Close #FF
    If Right$(ProfileAge, Len(vbNewLine)) = vbNewLine Then ProfileAge = Left$(ProfileAge, Len(ProfileAge) - Len(vbNewLine))
    If Right$(ProfileSex, Len(vbNewLine)) = vbNewLine Then ProfileSex = Left$(ProfileSex, Len(ProfileSex) - Len(vbNewLine))
    If Right$(ProfileLocation, Len(vbNewLine)) = vbNewLine Then ProfileLocation = Left$(ProfileLocation, Len(ProfileLocation) - Len(vbNewLine))
    If Right$(ProfileDescription, Len(vbNewLine)) = vbNewLine Then ProfileDescription = Left$(ProfileDescription, Len(ProfileDescription) - Len(vbNewLine))
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Options", "Reload"
End Sub
