VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsOptions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'-----------------------------------------------------
' MirageBot Options Class
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Private Const SE As String = "Settings"

'Strings:
Private mTrigger(6) As String, mChannel(6) As String, sHideFeatures As String, sEmoticonSet As String, sPassword As String

'Integers:
Private iIcons As Integer, iEncryption As Integer, iFocusMax As Integer

'Doubles:
Private dTimerReconnect As Double, dTimerFlood As Double

Private Broadcasts As String, Mutators As String
Private mDisableAdvInfo As Boolean, mFilterNudge As Boolean, mFilterGame As Boolean, mDisableChatColors As Boolean, mDisableConfirmExit As Boolean, _
    mDisableIdleColors As Boolean, mFilterFriend As Boolean, mDisableUTF8Decode As Boolean, mDisableUTF8Encode As Boolean, _
    mDisableSilentView As Boolean, mDisableStyleBar As Boolean, mTrayStart As Boolean, _
    mTrayMin As Boolean, mDisableVerboseConsole As Boolean, mDisableClanIcons As Boolean, _
    mRequireNLS As Boolean, mDisableRealmName As Boolean, _
    mLogging As Boolean, mAutoReconnect As Boolean, mFilterUnsafe As Boolean, _
    mCommandDebug As Boolean, mCommandGlobal As Boolean, mEmoticons As Boolean, mFilterUnsafeNudge As Boolean, _
    mAutoConnectAll As Boolean, mAutoHideAll As Boolean, mAutoLockAll As Boolean, mAutoLoadAll As Boolean, _
    mBNLS() As String, mFilterKick As Boolean, mFilterBan As Boolean, mFilterEmote As Boolean, mFilterLoad As Boolean, _
    mFilterAccount As Boolean, mFilterJoin As Boolean, mRTFInj As Boolean, _
    mAlertFlood As Boolean, mAlertNoFlood As Boolean, mAlertKicked As Boolean, mAlertMin As Boolean, mFilterPresent As Boolean, mDisableClanColors As Boolean, _
    mFocusBack As Boolean, mFocusFlash As Boolean, mFocusAuto As Boolean
Public ProfileAge As String, ProfileSex As String, ProfileLocation As String, ProfileDescription As String

Public Property Get RTFInj() As Boolean
    RTFInj = mRTFInj
End Property
Public Property Let RTFInj(v As Boolean)
    mRTFInj = v
    WriteINI AppSettings, SE, "RTFInj", YesNo(v)
    frmBot.mnuDisableOpt(12).Checked = v
End Property

Public Property Get TimerReconnect() As Double
    If dTimerReconnect = 0 Then dTimerReconnect = 8
    TimerReconnect = dTimerReconnect
End Property
Public Property Let TimerReconnect(v As Double)
    dTimerReconnect = v
    If dTimerReconnect = 0 Then dTimerReconnect = 8
    WriteINI AppSettings, "Timers", "Reconnect", v & ""
End Property

Public Property Get TimerFlood() As Double
    If dTimerFlood = 0 Then dTimerFlood = 60000
    TimerFlood = dTimerFlood
End Property
Public Property Let TimerFlood(v As Double)
    dTimerFlood = v
    If dTimerFlood = 0 Then dTimerFlood = 60000
    WriteINI AppSettings, "Timers", "Flood", v & ""
End Property

Public Property Get SpokenAll() As String
    SpokenAll = mTrigger(0)
End Property
Public Property Let SpokenAll(v As String)
    mTrigger(0) = v
    If Len(v) < 2 Or Len(v) > 4 Then mTrigger(0) = "!!"
    WriteINI AppSettings, "Triggers", "SpokenAll", mTrigger(0)
End Property

Public Property Get SpokenNon() As String
    SpokenNon = mTrigger(1)
End Property
Public Property Let SpokenNon(v As String)
    mTrigger(1) = v
    If Len(v) < 2 Or Len(v) > 4 Then mTrigger(1) = "!`"
    WriteINI AppSettings, "Triggers", "SpokenNon", mTrigger(1)
End Property

Public Property Get SpokenOps() As String
    SpokenOps = mTrigger(2)
End Property
Public Property Let SpokenOps(v As String)
    mTrigger(2) = v
    If Len(v) < 2 Or Len(v) > 4 Then mTrigger(2) = "!~"
    WriteINI AppSettings, "Triggers", "SpokenOps", mTrigger(2)
End Property

Public Property Get ConsoleAll() As String
    ConsoleAll = mTrigger(3)
End Property
Public Property Let ConsoleAll(v As String)
    mTrigger(3) = v
    If Len(v) < 2 Or Len(v) > 4 Then mTrigger(3) = "//"
    WriteINI AppSettings, "Triggers", "ConsoleAll", mTrigger(3)
End Property

Public Property Get ConsoleSrv() As String
    ConsoleSrv = mTrigger(4)
End Property
Public Property Let ConsoleSrv(v As String)
    mTrigger(4) = v
    If Len(v) < 2 Or Len(v) > 4 Then mTrigger(4) = "/@"
    WriteINI AppSettings, "Triggers", "ConsoleSrv", mTrigger(4)
End Property

Public Property Get ConsoleNon() As String
    ConsoleNon = mTrigger(5)
End Property
Public Property Let ConsoleNon(v As String)
    mTrigger(5) = v
    If Len(v) < 2 Or Len(v) > 4 Then mTrigger(5) = "/`"
    WriteINI AppSettings, "Triggers", "ConsoleNon", mTrigger(5)
End Property

Public Property Get ConsoleOps() As String
    ConsoleOps = mTrigger(6)
End Property
Public Property Let ConsoleOps(v As String)
    mTrigger(6) = v
    If Len(v) < 2 Or Len(v) > 4 Then mTrigger(6) = "/~"
    WriteINI AppSettings, "Triggers", "ConsoleOps", mTrigger(6)
End Property


Public Function BroadcastInList(Message As String) As Boolean
    Dim S() As String, I As Integer
    S = Split(Broadcasts, vbNewLine)
    For I = 0 To UBound(S)
        If InStr(S(I), "*") Then
            If Matches(Message, S(I)) Then BroadcastInList = True: Exit Function
        End If
        If LCase$(Message) = LCase$(S(I)) Then BroadcastInList = True: Exit Function
    Next I
End Function

Public Function MutatorInList(Message As String) As String
    Dim S() As String, I As Integer, M() As String
    S = Split(Mutators, vbNewLine)
    For I = 0 To UBound(S)
        M = Split(S(I), " >> ")
        If UBound(M) = 1 Then
            If LCase$(M(0)) = LCase$(Message) Then
                MutatorInList = M(1)
            End If
        End If
    Next I
End Function

Public Property Get HideFeatures() As String
    HideFeatures = sHideFeatures
    If Len(sHideFeatures) = 15 Then sHideFeatures = sHideFeatures & "000"
End Property

Public Property Let HideFeatures(ByVal v As String)
    sHideFeatures = v
    WriteINI AppSettings, SE, "HideFeatures", v
    ViewProfile SelTab
End Property

Public Property Get AlertFlood() As Boolean
    AlertFlood = mAlertFlood
End Property

Public Property Let AlertFlood(ByVal v As Boolean)
    mAlertFlood = v
    WriteINI AppSettings, "Alerts", "Flood", YesNo(v)
    frmBot.mnuAlertOpt(0).Checked = v
End Property

Public Property Get FocusBack() As Boolean
    FocusBack = mFocusBack
End Property

Public Property Let FocusBack(ByVal v As Boolean)
    mFocusBack = v
    WriteINI AppSettings, "Focus", "Back", YesNo(v)
End Property

Public Property Get FocusFlash() As Boolean
    FocusFlash = mFocusFlash
End Property

Public Property Let FocusFlash(ByVal v As Boolean)
    mFocusFlash = v
    WriteINI AppSettings, "Focus", "Flash", YesNo(v)
End Property

Public Property Get FocusAuto() As Boolean
    FocusAuto = mFocusAuto
End Property

Public Property Let FocusAuto(ByVal v As Boolean)
    mFocusAuto = v
    WriteINI AppSettings, "Focus", "Auto", YesNo(v)
End Property

Public Property Get FocusMax() As Integer
    FocusMax = iFocusMax
End Property

Public Property Let FocusMax(ByVal v As Integer)
    iFocusMax = v
    WriteINI AppSettings, "Focus", "Max", CStr(v)
End Property

Public Property Get AlertMin() As Boolean
    AlertMin = mAlertMin
End Property

Public Property Let AlertMin(ByVal v As Boolean)
    mAlertMin = v
    WriteINI AppSettings, "Alerts", "Min", YesNo(v)
    frmBot.mnuMinAlert.Checked = v
End Property
        
Public Property Get AlertNoFlood() As Boolean
    AlertNoFlood = mAlertNoFlood
End Property

Public Property Let AlertNoFlood(ByVal v As Boolean)
    mAlertNoFlood = v
    WriteINI AppSettings, "Alerts", "NoFlood", YesNo(v)
    frmBot.mnuAlertOpt(1).Checked = v
End Property

Public Property Get AlertKicked() As Boolean
    AlertKicked = mAlertKicked
End Property

Public Property Let AlertKicked(ByVal v As Boolean)
    mAlertKicked = v
    WriteINI AppSettings, "Alerts", "Kicked", YesNo(v)
    frmBot.mnuAlertOpt(2).Checked = v
End Property

Public Sub Class_Terminate()
    On Error Resume Next
    Export
End Sub

Public Property Get BNLS(Index As Integer) As String
    If Index > UBound(mBNLS) Then BNLS = "bnls.bnetdev.net": Exit Property
    BNLS = mBNLS(Index)
    If LenB(BNLS) = 0 Then BNLS = "bnls.bnetdev.net"
End Property

Public Property Get BNLSCount() As Long
    BNLSCount = UBound(mBNLS)
End Property

Public Sub Export()
    Dim FF As Integer, Ar As String
    FF = FreeFile
    Ar = AppData & "Data\Other\DynamicProfile.ini"
    If Right$(ProfileAge, Len(vbNewLine)) = vbNewLine Then ProfileAge = Left$(ProfileAge, Len(ProfileAge) - Len(vbNewLine))
    If Right$(ProfileSex, Len(vbNewLine)) = vbNewLine Then ProfileSex = Left$(ProfileSex, Len(ProfileSex) - Len(vbNewLine))
    If Right$(ProfileLocation, Len(vbNewLine)) = vbNewLine Then ProfileLocation = Left$(ProfileLocation, Len(ProfileLocation) - Len(vbNewLine))
    If Right$(ProfileDescription, Len(vbNewLine)) = vbNewLine Then ProfileDescription = Left$(ProfileDescription, Len(ProfileDescription) - Len(vbNewLine))
    Open Ar For Append As #FF
    Close #FF
    Open Ar For Output As #FF
        Print #FF, "[Age]"
        Print #FF, ProfileAge
        Print #FF, "[Sex]"
        Print #FF, ProfileSex
        Print #FF, "[Location]"
        Print #FF, ProfileLocation
        Print #FF, "[Description]"
        Print #FF, ProfileDescription
    Close #FF
End Sub

Public Property Get FilterGame() As Boolean
    FilterGame = mFilterGame
End Property

Public Property Let FilterGame(v As Boolean)
    mFilterGame = v
    WriteINI AppSettings, "Filter", "Game", YesNo(v)
    frmBot.mnuFilterOpt(1).Checked = v
End Property

Public Property Get Icons() As Integer
    Icons = iIcons
End Property

Public Property Let Icons(v As Integer)
    iIcons = v
    Dim I As Integer, C As Control
    For I = 0 To 2
        frmBot.mnuDIcons(I).Checked = False
    Next I
    frmBot.mnuDIcons(v).Checked = True
    WriteINI AppSettings, SE, "Icons", CStr(v & "")
    Select Case v
    Case 0
        For Each C In frmBot.Controls
            If TypeName(C) = "ListView" And C.Name <> "lvChars" And C.Name <> "lvDB" And C.Name <> "lvFrame" Then
                If C.ListItems.Count = 0 Then
                    Set C.SmallIcons = frmBot.imlAvatar
                Else
                    C.ListItems(1).Selected = True
                    C.SelectedItem.EnsureVisible
                End If
                ApplyIcons C.hwnd
            End If
        Next
    Case 1
        For Each C In frmBot.Controls
            If TypeName(C) = "ListView" And C.Name <> "lvChars" And C.Name <> "lvDB" And C.Name <> "lvFrame" Then
                If C.ListItems.Count = 0 Then
                    Set C.SmallIcons = frmBot.imlClassic
                Else
                    C.ListItems(1).Selected = True
                    C.SelectedItem.EnsureVisible
                End If
                ApplyIcons C.hwnd
            End If
        Next
    Case 2
        For Each C In frmBot.Controls
            If TypeName(C) = "ListView" And C.Name <> "lvChars" And C.Name <> "lvDB" And C.Name <> "lvFrame" Then
                If C.ListItems.Count = 0 Then
                    Set C.SmallIcons = frmBot.imlModern
                Else
                    C.ListItems(1).Selected = True
                    C.SelectedItem.EnsureVisible
                End If
                ApplyIcons C.hwnd
            End If
        Next
    End Select
End Property

Public Property Get Emoticons() As Boolean
    Emoticons = mEmoticons
End Property

Public Property Let Emoticons(v As Boolean)
    mEmoticons = v
    frmBot.mnuParseEmoticons.Checked = v
    WriteINI AppSettings, SE, "Emoticons", YesNo(v)
End Property

Public Property Get EmoticonSet() As String
    EmoticonSet = sEmoticonSet
End Property

Public Property Let EmoticonSet(v As String)
    sEmoticonSet = v
    LoadEmoticons v
    WriteINI AppSettings, SE, "EmoticonSet", v
End Property

Public Property Get FilterFriend() As Boolean
    FilterFriend = mFilterFriend
End Property

Public Property Let FilterFriend(v As Boolean)
    mFilterFriend = v
    WriteINI AppSettings, "Filter", "Friend", YesNo(v)
    frmBot.mnuFilterOpt(3).Checked = v
End Property

Public Property Get FilterAccount() As Boolean
    FilterAccount = mFilterAccount
End Property

Public Property Let FilterAccount(v As Boolean)
    mFilterAccount = v
    WriteINI AppSettings, "Filter", "Account", YesNo(v)
    frmBot.mnuFilterOpt(0).Checked = v
End Property

Public Property Get FilterJoin() As Boolean
    FilterJoin = mFilterJoin
End Property

Public Property Let FilterJoin(v As Boolean)
    mFilterJoin = v
    WriteINI AppSettings, "Filter", "Join", YesNo(v)
    frmBot.mnuFilterOptU(2).Checked = v
End Property

Public Property Get FilterPresent() As Boolean
    FilterPresent = mFilterPresent
End Property

Public Property Let FilterPresent(v As Boolean)
    mFilterPresent = v
    WriteINI AppSettings, "Filter", "Present", YesNo(v)
    frmBot.mnuFilterOptU(4).Checked = v
End Property

Public Property Get FilterEmote() As Boolean
    FilterEmote = mFilterEmote
End Property

Public Property Let FilterEmote(v As Boolean)
    mFilterEmote = v
    WriteINI AppSettings, "Filter", "Emote", YesNo(v)
    frmBot.mnuFilterOptU(1).Checked = v
End Property

Public Property Get FilterBan() As Boolean
    FilterBan = mFilterBan
End Property

Public Property Let FilterBan(v As Boolean)
    mFilterBan = v
    WriteINI AppSettings, "Filter", "Ban", YesNo(v)
    frmBot.mnuFilterOptU(0).Checked = v
End Property

Public Property Get FilterKick() As Boolean
    FilterKick = mFilterKick
End Property

Public Property Let FilterKick(v As Boolean)
    mFilterKick = v
    WriteINI AppSettings, "Filter", "Kick", YesNo(v)
    frmBot.mnuFilterOptU(3).Checked = v
End Property

Public Property Get FilterUnsafe() As Boolean
    FilterUnsafe = mFilterUnsafe
End Property

Public Property Let FilterUnsafe(v As Boolean)
    mFilterUnsafe = v
    WriteINI AppSettings, "Filter", "Unsafe", YesNo(v)
    frmBot.mnuFilterOptU(5).Checked = v
End Property

Public Property Get FilterLoad() As Boolean
    FilterLoad = mFilterLoad
End Property

Public Property Let FilterLoad(v As Boolean)
    mFilterLoad = v
    WriteINI AppSettings, "Filter", "FilterLoad", YesNo(v)
    frmBot.mnuFilterRule.Checked = v
End Property

Public Property Get DisableClanColors() As Boolean
    DisableClanColors = mDisableClanColors
End Property

Public Property Let DisableClanColors(v As Boolean)
    mDisableClanColors = v
    WriteINI AppSettings, SE, "DisableClanColors", YesNo(v)
    frmBot.mnuDisableOpt(0).Checked = v
End Property

Public Property Get DisableClanIcons() As Boolean
    DisableClanIcons = mDisableClanIcons
End Property

Public Property Let DisableClanIcons(v As Boolean)
    mDisableClanIcons = v
    WriteINI AppSettings, SE, "DisableClanIcons", YesNo(v)
    frmBot.mnuDisableOpt(1).Checked = v
End Property

Public Property Get DisableRealmName() As Boolean
    DisableRealmName = mDisableRealmName
End Property

Public Property Let DisableRealmName(v As Boolean)
    mDisableRealmName = v
    WriteINI AppSettings, SE, "DisableRealmName", YesNo(v)
    frmBot.mnuDisableOpt(6).Checked = v
End Property

Public Property Get AutoReconnect() As Boolean
    AutoReconnect = mAutoReconnect
End Property

Public Property Let AutoReconnect(v As Boolean)
    mAutoReconnect = v
    WriteINI AppSettings, SE, "AutoReconnect", YesNo(v)
    frmBot.mnuBAuto(4).Checked = v
End Property

Public Property Get Logging() As Boolean
    Logging = mLogging
End Property

Public Property Let Logging(v As Boolean)
    mLogging = v
    WriteINI AppSettings, SE, "Logging", YesNo(v)
End Property

Public Property Get RequireNLS() As Boolean
    RequireNLS = mRequireNLS
End Property

Public Property Let RequireNLS(v As Boolean)
    mRequireNLS = v
    WriteINI AppSettings, SE, "RequireNLS", YesNo(v)
    frmBot.mnuNLS.Checked = v
End Property

Public Property Get DisableAdvInfo() As Boolean
    DisableAdvInfo = mDisableAdvInfo
End Property

Public Property Let DisableAdvInfo(v As Boolean)
    mDisableAdvInfo = v
    WriteINI AppSettings, SE, "DisableAdvInfo", YesNo(v)
    frmBot.mnuDisableOpt(4).Checked = v
End Property

Public Property Get FilterUnsafeNudge() As Boolean
    FilterUnsafeNudge = mFilterUnsafeNudge
End Property

Public Property Let FilterUnsafeNudge(v As Boolean)
    mFilterUnsafeNudge = v
    WriteINI AppSettings, SE, "FilterUnsafeNudge", YesNo(v)
    frmBot.mnuFilterOpt(4).Checked = v
End Property

Public Property Get Encryption() As Integer
    Encryption = iEncryption
End Property

Public Property Let Encryption(v As Integer)
    If v > 3 Or v < 0 Then v = 0
    iEncryption = v
    WriteINI AppSettings, SE, "Encryption", CStr(v)
    frmBot.mnuEncryption(0).Checked = v = 0
    frmBot.mnuEncryption(1).Checked = v = 1
    frmBot.mnuEncryption(2).Checked = v = 2
    frmBot.mnuEncryption(3).Checked = v = 3
End Property

Public Property Get CommandGlobal() As Boolean
    CommandGlobal = mCommandGlobal
End Property

Public Property Let CommandGlobal(v As Boolean)
    mCommandGlobal = v
    WriteINI AppSettings, SE, "CommandGlobal", YesNo(v)
    frmBot.mnuCommFunc.Checked = v
End Property

Public Property Get CommandDebug() As Boolean
    CommandDebug = mCommandDebug
End Property

Public Property Let CommandDebug(v As Boolean)
    mCommandDebug = v
    WriteINI AppSettings, SE, "CommandDebug", YesNo(v)
    frmBot.mnuDBC.Checked = v
End Property

Public Property Get DisableStyleBar() As Boolean
    DisableStyleBar = mDisableStyleBar
End Property

Public Property Let DisableStyleBar(v As Boolean)
    mDisableStyleBar = v
    WriteINI AppSettings, SE, "DisableStyleBar", YesNo(v)
    frmBot.mnuDisableOpt(8).Checked = v
End Property

Public Property Get FilterNudge() As Boolean
    FilterNudge = mFilterNudge
End Property

Public Property Let FilterNudge(v As Boolean)
    mFilterNudge = v
    WriteINI AppSettings, "Filter", "Nudge", YesNo(v)
    frmBot.mnuFilterOpt(2).Checked = v
End Property

Public Property Get DisableChatColors() As Boolean
    DisableChatColors = mDisableChatColors
End Property

Public Property Let DisableChatColors(v As Boolean)
    mDisableChatColors = v
    WriteINI AppSettings, SE, "DisableChatColors", YesNo(v)
    frmBot.mnuDisableOpt(2).Checked = v
End Property

Public Property Get DisableConfirmExit() As Boolean
    DisableConfirmExit = mDisableConfirmExit
End Property

Public Property Let DisableConfirmExit(v As Boolean)
    mDisableConfirmExit = v
    WriteINI AppSettings, SE, "DisableConfirmExit", YesNo(v)
    frmBot.mnuDisableOpt(3).Checked = v
End Property

Public Property Get AutoConnectAll() As Boolean
    AutoConnectAll = mAutoConnectAll
End Property

Public Property Let AutoConnectAll(v As Boolean)
    mAutoConnectAll = v
    WriteINI AppSettings, SE, "AutoConnectAll", YesNo(v)
    frmBot.mnuBAuto(0).Checked = v
End Property

Public Property Get AutoLockAll() As Boolean
    AutoLockAll = mAutoLockAll
End Property

Public Property Let AutoLockAll(v As Boolean)
    mAutoLockAll = v
    WriteINI AppSettings, SE, "AutoLockAll", YesNo(v)
    frmBot.mnuBAuto(3).Checked = v
End Property

Public Property Get AutoHideAll() As Boolean
    AutoHideAll = mAutoHideAll
End Property

Public Property Let AutoHideAll(v As Boolean)
    mAutoHideAll = v
    WriteINI AppSettings, SE, "AutoHideAll", YesNo(v)
    frmBot.mnuBAuto(1).Checked = v
End Property

Public Property Get AutoLoadAll() As Boolean
    AutoLoadAll = mAutoLoadAll
End Property

Public Property Let AutoLoadAll(v As Boolean)
    mAutoLoadAll = v
    WriteINI AppSettings, SE, "AutoLoadAll", YesNo(v)
    frmBot.mnuBAuto(2).Checked = v
End Property

Public Property Get DisableVerboseConsole() As Boolean
    DisableVerboseConsole = mDisableVerboseConsole
End Property

Public Property Let DisableVerboseConsole(v As Boolean)
    mDisableVerboseConsole = v
    WriteINI AppSettings, SE, "DisableVerboseConsole", YesNo(v)
    frmBot.mnuDisableOpt(11).Checked = v
End Property

Public Property Get DisableUTF8Encode() As Boolean
    DisableUTF8Encode = mDisableUTF8Encode
End Property

Public Property Let DisableUTF8Encode(v As Boolean)
    mDisableUTF8Encode = v
    WriteINI AppSettings, SE, "DisableUTF8Encode", YesNo(v)
    frmBot.mnuDisableOpt(10).Checked = v
End Property

Public Property Get DisableUTF8Decode() As Boolean
    DisableUTF8Decode = mDisableUTF8Decode
End Property

Public Property Let DisableUTF8Decode(v As Boolean)
    mDisableUTF8Decode = v
    WriteINI AppSettings, SE, "DisableUTF8Decode", YesNo(v)
    frmBot.mnuDisableOpt(9).Checked = v
End Property

Public Property Get DisableIdleColors() As Boolean
    DisableIdleColors = mDisableIdleColors
End Property

Public Property Let DisableIdleColors(v As Boolean)
    mDisableIdleColors = v
    WriteINI AppSettings, SE, "DisableIdleColors", YesNo(v)
    frmBot.mnuDisableOpt(5).Checked = v
End Property

Public Property Get DisableSilentView() As Boolean
    DisableSilentView = mDisableSilentView
End Property

Public Property Let DisableSilentView(v As Boolean)
    mDisableSilentView = v
    WriteINI AppSettings, SE, "DisableSilentView", YesNo(v)
    frmBot.mnuDisableOpt(7).Checked = v
End Property

Public Property Get TrayMin() As Boolean
    TrayMin = mTrayMin
End Property

Public Property Let TrayMin(v As Boolean)
    mTrayMin = v
    WriteINI AppSettings, SE, "TrayMin", YesNo(v)
    frmBot.mnuMinTray.Checked = v
End Property

Public Property Get TrayStart() As Boolean
    TrayStart = mTrayStart
End Property

Public Property Let TrayStart(v As Boolean)
    mTrayStart = v
    WriteINI AppSettings, SE, "TrayStart", YesNo(v)
    frmBot.mnuStartTray.Checked = v
End Property

Public Property Get Password() As String
    Password = sPassword
End Property

Public Property Let Password(v As String)
    sPassword = v
    WriteINI AppSettings, SE, "MasterPassword", StringToAsc(v)
End Property

Public Sub Reload()
On Error GoTo hErr:
1   Const SE As String = "Settings", FI As String = "Filter", AL As String = "Alerts", FO As String = "Focus", TR As String = "Triggers"
2   ReDim mBNLS(0)
    Dim AP As String
3   AP = AppSettings
4   CreateFile AP
5   EmoticonSet = ReadINI(AP, SE, "EmoticonSet")
    If LenB(EmoticonSet) = 0 Then EmoticonSet = "Classic"
6   AutoReconnect = IsYes(ReadINI(AP, SE, "AutoReconnect"))
7   AutoConnectAll = IsYes(ReadINI(AP, SE, "AutoConnectAll"))
8   AutoHideAll = IsYes(ReadINI(AP, SE, "AutoHideAll"))
9   AutoLoadAll = IsYes(ReadINI(AP, SE, "AutoLoadAll"))
10  AutoLockAll = IsYes(ReadINI(AP, SE, "AutoLockAll"))
11  Logging = IsYes(ReadINI(AP, SE, "Logging"))
12  RequireNLS = IsYes(ReadINI(AP, SE, "RequireNLS"))
13  CommandDebug = IsYes(ReadINI(AP, SE, "CommandDebug"))
    CommandGlobal = IsYes(ReadINI(AP, SE, "CommandGlobal"))
14  Emoticons = IsYes(ReadINI(AP, SE, "Emoticons"))
15  TrayMin = IsYes(ReadINI(AP, SE, "TrayMin"))
16  TrayStart = IsYes(ReadINI(AP, SE, "TrayStart"))
17  Icons = Val(ReadINI(AP, SE, "Icons"))
18  Password = AscToString(ReadINI(AP, SE, "MasterPassword"))
    DisableAdvInfo = IsYes(ReadINI(AP, SE, "DisableAdvInfo"))
20  DisableClanIcons = IsYes(ReadINI(AP, SE, "DisableClanIcons"))
21  DisableChatColors = IsYes(ReadINI(AP, SE, "DisableChatColors"))
22  DisableStyleBar = IsYes(ReadINI(AP, SE, "DisableStyleBar"))
24  DisableRealmName = IsYes(ReadINI(AP, SE, "DisableRealmName"))
25  DisableVerboseConsole = IsYes(ReadINI(AP, SE, "DisableVerboseConsole"))
26  DisableIdleColors = IsYes(ReadINI(AP, SE, "DisableIdleColors"))
27  DisableSilentView = IsYes(ReadINI(AP, SE, "DisableSilentView"))
    DisableUTF8Encode = IsYes(ReadINI(AP, SE, "DisableUTF8Encode"))
    DisableUTF8Decode = IsYes(ReadINI(AP, SE, "DisableUTF8Decode"))
    RTFInj = IsYes(ReadINI(AP, SE, "RTFInj"))
    Encryption = CInt(Val(ReadINI(AP, SE, "Encryption")))
    HideFeatures = ReadINI(AP, SE, "HideFeatures")
    DisableConfirmExit = IsYes(ReadINI(AP, SE, "DisableConfirmExit"))
19  FilterUnsafeNudge = IsYes(ReadINI(AP, SE, "FilterUnsafeNudge"))
28  FilterGame = IsYes(ReadINI(AP, FI, "Game"))
29  FilterUnsafe = IsYes(ReadINI(AP, FI, "Unsafe"))
30  FilterNudge = IsYes(ReadINI(AP, FI, "Nudge"))
31  FilterKick = IsYes(ReadINI(AP, FI, "Kick"))
32  FilterBan = IsYes(ReadINI(AP, FI, "Ban"))
33  FilterEmote = IsYes(ReadINI(AP, FI, "Emote"))
34  FilterFriend = IsYes(ReadINI(AP, FI, "Friend"))
35  FilterAccount = IsYes(ReadINI(AP, FI, "Account"))
36  FilterJoin = IsYes(ReadINI(AP, FI, "Join"))
37  FilterPresent = IsYes(ReadINI(AP, FI, "Present"))
40  FilterLoad = IsYes(ReadINI(AP, FI, "FilterLoad"))
41  AlertFlood = IsYes(ReadINI(AP, AL, "Flood"))
42  AlertNoFlood = IsYes(ReadINI(AP, AL, "NoFlood"))
43  AlertKicked = IsYes(ReadINI(AP, AL, "Kicked"))
    AlertMin = IsYes(ReadINI(AP, AL, "Min"))
    FocusBack = IsYes(ReadINI(AP, FO, "Back"))
    FocusFlash = IsYes(ReadINI(AP, FO, "Flash"))
    SpokenAll = ReadINI(AP, TR, "SpokenAll")
    SpokenNon = ReadINI(AP, TR, "SpokenNon")
    SpokenOps = ReadINI(AP, TR, "SpokenOps")
    ConsoleAll = ReadINI(AP, TR, "ConsoleAll")
    ConsoleSrv = ReadINI(AP, TR, "ConsoleSrv")
    ConsoleNon = ReadINI(AP, TR, "ConsoleNon")
    ConsoleOps = ReadINI(AP, TR, "ConsoleOps")
    TimerReconnect = Val(ReadINI(AP, "Timers", "Reconnect"))
    TimerFlood = Val(ReadINI(AP, "Timers", "Flood"))
    
    If Len(ReadINI(AP, FO, "Auto")) = 0 Then FocusAuto = True Else FocusAuto = IsYes(ReadINI(AP, FO, "Auto"))
    FocusMax = Val(ReadINI(AP, FO, "Max"))
    If FocusMax < 5 Then FocusMax = 5
    
    Dim FF As Integer, L As String, Ar As String, p As Integer
    FF = FreeFile
    Ar = AppData & "Data\Other\BnlsServers.ini"
    Open Ar For Append As #FF
    Close #FF
    Open Ar For Input As #FF
    Do Until EOF(FF)
        Line Input #FF, L
        If LenB(L) > 0 Then
            If LenB(mBNLS(0)) > 0 Then ReDim Preserve mBNLS(UBound(mBNLS) + 1)
            mBNLS(UBound(mBNLS)) = L
        End If
    Loop
    Close #FF
    
    Broadcasts = ReadFile(AppData & "Data\Other\Broadcast.txt")
    Mutators = ReadFile(AppData & "Data\Other\Mutators.txt")
    
    FF = FreeFile
    Ar = AppData & "Data\Other\DynamicProfile.ini"
    ProfileAge = vbNullString
    ProfileSex = vbNullString
    ProfileLocation = vbNullString
    ProfileDescription = vbNullString
    Open Ar For Append As #FF
    Close #FF
    Open Ar For Input As #FF
    Do Until EOF(FF)
        Line Input #FF, L
        Select Case L
        Case "[Age]": p = 1
        Case "[Sex]": p = 2
        Case "[Location]": p = 3
        Case "[Description]": p = 4
        Case Else
            Select Case p
            Case 1: ProfileAge = ProfileAge & L & vbNewLine
            Case 2: ProfileSex = ProfileSex & L & vbNewLine
            Case 3: ProfileLocation = ProfileLocation & L & vbNewLine
            Case 4: ProfileDescription = ProfileDescription & L & vbNewLine
            End Select
        End Select
    Loop
    Close #FF
    If Right$(ProfileAge, Len(vbNewLine)) = vbNewLine Then ProfileAge = Left$(ProfileAge, Len(ProfileAge) - Len(vbNewLine))
    If Right$(ProfileSex, Len(vbNewLine)) = vbNewLine Then ProfileSex = Left$(ProfileSex, Len(ProfileSex) - Len(vbNewLine))
    If Right$(ProfileLocation, Len(vbNewLine)) = vbNewLine Then ProfileLocation = Left$(ProfileLocation, Len(ProfileLocation) - Len(vbNewLine))
    If Right$(ProfileDescription, Len(vbNewLine)) = vbNewLine Then ProfileDescription = Left$(ProfileDescription, Len(ProfileDescription) - Len(vbNewLine))
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Options", "Reload"
End Sub
