VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMail"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Type MailItem
    miFrom As String
    miTo As String
    miTime As String
    miText As String
End Type

Private Mail() As MailItem

Public BotIndex As Integer

Public Sub ClearMail()
    ReDim Mail(0)
End Sub

Public Sub LoadMail(Index As Integer)
On Error GoTo hErr:
1   BotIndex = Index
2   ClearMail
    Dim p As String, FF As Integer, LN As String
3   FF = FreeFile
4   p = frmBot.Bot(Index).ProfilePath
5   p = Left$(p, InStrRev(p, "\")) & "Mail.ini"
6   Open p For Append As #FF
7   Close #FF
8   Open p For Input As #FF
9   Do Until EOF(FF)
10      Line Input #FF, LN
11      If InStrB(LN, "") <> 0 Then
12          Dim ST() As String
13          ST = Split(LN, "")
14          If UBound(ST) = 3 Then
15              AddMail ST(0), ST(1), ST(2), ST(3)
            End If
        End If
    Loop
16  Close #FF
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "LoadMail"
End Sub

Public Sub SaveMail()
On Error GoTo hErr:
1   Const DELIM As String = ""
    Dim p As String, FF As Integer, LN As String
2   FF = FreeFile
3   p = frmBot.Bot(BotIndex).ProfilePath
4   p = Left$(p, InStrRev(p, "\")) & "Mail.ini"
5   Open p For Append As #FF
    Close #FF
6   Open p For Output As #FF
        Dim I As Integer
7       For I = 0 To UBound(Mail)
8           With Mail(I)
9               If LenB(.miFrom) And LenB(.miTo) Then
10                  Print #FF, .miFrom & DELIM & .miTo & DELIM & .miText & DELIM & .miTime
                End If
            End With
        Next I
    Close #FF
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "SaveMail"
End Sub

Public Sub AddMail(sFrom As String, sTo As String, sText As String, Optional TimeStamp As String)
On Error GoTo hErr:
1   If LenB(Mail(0).miText) > 0 Then ReDim Preserve Mail(UBound(Mail) + 1)
2   With Mail(UBound(Mail))
3       .miFrom = sFrom
4       .miTo = sTo
5       .miText = sText
6       .miTime = IIf(LenB(TimeStamp) > 0, TimeStamp, "[" & Format$(Date, "dd/mm/yy") & " - " & Format$(Time, "hh:mm:ss") & "]")
    End With
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "AddMail"
End Sub

Public Function CountAllMail() As Integer
On Error GoTo hErr:
1   CountAllMail = UBound(Mail) + 1
2   If LenB(Mail(0).miTo) = 0 Then CountAllMail = CountAllMail - 1
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "CountAllMail"
End Function

Public Function CountAllMailUsers() As Integer
On Error GoTo hErr:
    Dim I As Integer, C As Integer, U As New Collection, DoNotAdd As Boolean
2   For I = 0 To UBound(Mail)
3       If LenB(Mail(I).miTo) > 0 Then
            DoNotAdd = False
            For C = 1 To U.Count
                If LCase$(U(C)) = LCase$(Mail(I).miTo) Then
                    DoNotAdd = True
                    Exit For
                End If
            Next
            If DoNotAdd = False Then U.Add Mail(I).miTo
        End If
    Next
    CountAllMailUsers = U.Count
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "CountAllMail"
End Function

Public Sub CheckMail(sUsername As String)
On Error GoTo hErr:
    Dim Count As Integer
    Count = CountInbox(sUsername)
    If Count > 0 Then
        frmBot.Bot(BotIndex).SendText "/w " & frmBot.Bot(BotIndex).GetAccount(sUsername) & " You have mail waiting to be read, whisper !inbox to read your mail."
    End If
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "CheckMail"
End Sub

Public Function CountInbox(sUsername As String) As Integer
On Error GoTo hErr:
    Dim I As Integer, C As Integer
1   sUsername = LCase$(sUsername)
2   For I = 0 To UBound(Mail)
3       If LenB(Mail(I).miTo) > 0 Then If LCase$(Mail(I).miTo) = sUsername Then C = C + 1
4   Next I
5   CountInbox = C
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "CountInbox"
End Function

Public Function CountOutbox(sUsername As String) As Integer
On Error GoTo hErr:
    Dim I As Integer, C As Integer
1   sUsername = LCase$(sUsername)
2   For I = 0 To UBound(Mail)
3       If LenB(Mail(I).miFrom) > 0 Then If LCase$(Mail(I).miFrom) = sUsername Then C = C + 1
4   Next I
5   CountOutbox = C
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "CountOutbox"
End Function

Public Sub SendAllMail()
On Error GoTo hErr:
    Dim I As Integer
1   For I = 0 To UBound(Mail)
2       With Mail(I)
3           frmBot.Bot(BotIndex).SendText .miTo & "=>" & .miFrom & ": " & .miText & " - " & .miTime
        End With
    Next I
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "SendAllMail"
End Sub

Public Sub SendMail(sUsername As String)
On Error GoTo hErr:
1   If CountInbox(sUsername) = 0 Then Exit Sub
2   sUsername = LCase$(sUsername)
    Dim I As Integer, C As Integer
3   For I = 0 To UBound(Mail)
4       With Mail(I)
5           If LCase$(.miTo) = sUsername Then
                frmBot.Bot(BotIndex).SendText "/w " & frmBot.Bot(BotIndex).GetAccount(sUsername) & " " & _
                    .miFrom & " said: " & .miText & " - " & .miTime
            End If
        End With
    Next I
7   RemoveAllMail sUsername
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "SendMail"
End Sub

Public Sub SendMailOut(sUsername As String)
On Error GoTo hErr:
1   If CountOutbox(sUsername) = 0 Then Exit Sub
2   sUsername = LCase$(sUsername)
    Dim I As Integer, C As Integer
3   For I = 0 To UBound(Mail)
4       With Mail(I)
5           If LCase$(.miFrom) = sUsername Then
                frmBot.Bot(BotIndex).SendText "/w " & frmBot.Bot(BotIndex).GetAccount(sUsername) & " " & _
                    "To " & .miTo & ": " & .miText & " - " & .miTime
            End If
        End With
    Next I
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "SendMail"
End Sub

Public Sub RemoveAllMail(ByVal sTo As String)
On Error GoTo hErr:
1   If CountInbox(sTo) = 0 Then Exit Sub
    Dim I As Integer
2   sTo = LCase$(sTo)
3   For I = 1 To UBound(Mail)
4       If LCase$(Mail(I).miTo) = sTo Then
5           Dim x As Integer
6           For x = I To UBound(Mail) - 1
7               Mail(x) = Mail(x + 1)
8           Next x
9           ReDim Preserve Mail(UBound(Mail) - 1)
        End If
    Next I
10  If LCase$(Mail(0).miTo) = sTo Then
11      With Mail(0)
12          .miFrom = vbNS
13          .miTo = vbNS
14          .miText = vbNS
15          .miTime = vbNS
        End With
    End If
16  RemoveAllMail sTo
    SaveMail
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "RemoveAllMail"
End Sub

Public Function RemoveMail(ByVal sFrom As String, ByVal sTo As String) As Integer
On Error GoTo hErr:
    Dim I As Integer, r As Integer
1   sFrom = LCase$(sFrom): sTo = LCase$(sTo)
2   For I = UBound(Mail) To 1 Step -1
3       If LCase$(Mail(I).miTo) = sTo And LCase$(Mail(I).miFrom) = sFrom Then
7           r = r + 1
            Dim x As Integer
4           For x = I To UBound(Mail) - 1
5               Mail(x) = Mail(x + 1)
            Next x
6           ReDim Preserve Mail(UBound(Mail) - 1)
        End If
    Next I
8   If LCase$(Mail(0).miTo) = sTo And LCase$(Mail(0).miFrom) = sFrom Then
9       With Mail(0)
10          .miFrom = vbNS
11          .miTo = vbNS
12          .miText = vbNS
13          .miTime = vbNS
        End With
14      r = r + 1
    End If
15  RemoveMail = r
    SaveMail
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Mail", "RemoveMail"
End Function

Private Sub Class_Initialize()
    ReDim Mail(0)
End Sub
