VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsConfig"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'-----------------------------------------------------
' MirageBot Config Class
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit
Option Compare Text

Dim mARChieftain As String, mARShaman As String, mARGrunt As String, mARPeon As String, mARInitiate As String, mARFriend As String, mARUnclan As String
Dim mUsername As String, mPassword As String, mCdkey As String, mCdkeyEx As String, mProductID As String
Dim mChannel As String, mBackupChannel As String, mServer As String, mUseBNLS As Boolean, mVerbyte As Byte, mCdkeyVerify As Boolean
Dim mNewPassword As String, mEmail As String, mNewEmail As String, mRegister As REGMODE, mPing As PINGMODE
Dim mIdle As Boolean, mIdleTime As Double, mIdleMessage As String, mGreet As Boolean, mGreetMessage As String, mLoginMessage As String
Dim mTrigger As String, mKeepAlive As Boolean, mShamanGlitch As Boolean, mForceOLS As Boolean, mBindIP As String
Dim mAutoLoad As Boolean, mAutoHide As Boolean, mAutoConnect As Boolean, mAutoLock As Boolean, mWhisperBack As Boolean, mPlug As Boolean, mDynamicProfile As Boolean
Dim mGateway As String, mCharacter As String, mProxy() As String, mProxyMode As Integer, mProxyIP As String, mProxyPort As Long
Dim mQueue As String

Public Op As clsModeration, Focus As clsFocus, CurProxy As Integer, mProxyPass As String, mProxyUser As String
Public ProfilePath As String, ProxyPath As String, FocusPath As String, StatBanPath As String

Public Enum PINGMODE
    DisablePing& = 0
    ZeroPing& = 1
    NegativePing& = 2
End Enum
Public Enum LOGMODE
    lmDisabled = 0
    lmHtml = 1
    lmText = 2
End Enum
Public Enum REGMODE
    Disabled& = 0
    AllowRegistration& = 1
    ChangeEmail& = 2
    RequestPassword& = 3
End Enum
Const MAIN_SECTION As String = "Main"
Const BIND_SECTION As String = "Binding"
Const BNLS_SECTION As String = "BNLS"
Const PROXY_SECTION As String = "Proxy"
Const REGISTER_SECTION As String = "Register"
Const IDLE_SECTION As String = "Idle"
Const GREET_SECTION As String = "Greet"
Const REALM_SECTION As String = "Realm"
Const CLAN_SECTION As String = "AutoRank"

Public Sub Save()
    CreateFiles
    Me.AutoConnect = AutoConnect
    Me.AutoHide = AutoHide
    Me.AutoLoad = AutoLoad
    Me.AutoLock = AutoLock
    Me.BackupChannel = BackupChannel
    Me.Cdkey = Cdkey
    Me.CdkeyEx = CdkeyEx
    Me.Channel = Channel
    Me.Character = Character
    Me.DynamicProfile = DynamicProfile
    Me.Email = Email
    Me.Gateway = Gateway
    Me.Greet = Greet
    Me.GreetMessage = GreetMessage
    Me.Idle = Idle
    Me.IdleMessage = IdleMessage
    Me.IdleTime = IdleTime
    Me.ForceOLS = ForceOLS
    Me.KeepAlive = KeepAlive
    Me.NewEmail = NewEmail
    Me.NewPassword = NewPassword
    Me.Password = Password
    Me.Ping = Ping
    Me.Plug = Plug
    Me.ProxyMode = ProxyMode
    Me.ProductID = ProductID
    Me.Register = Register
    Me.Server = Server
    Me.Trigger = Trigger
    Me.UseBNLS = UseBNLS
    Me.Username = Username
    Me.VerByte = VerByte
    Me.WhisperBack = WhisperBack
    Me.ShamanGlitch = ShamanGlitch
    Me.BindIP = BindIP
    Me.ARChieftain = ARChieftain
    Me.ARShaman = ARShaman
    Me.ARGrunt = ARGrunt
    Me.ARPeon = ARPeon
    Me.ARInitiate = ARInitiate
    Me.ARFriend = ARFriend
    Me.ARUnclan = ARUnclan
    Me.CdkeyVerify = CdkeyVerify
    
    Op.Save
    Focus.Save
End Sub

Private Function ReadClanDB(S As String) As String
    If LCase$(S) = "<no rank>" Then Exit Function
    If RankingExists(S) Then ReadClanDB = LCase$(S)
End Function

Private Sub CreateFiles()
    CreateFile ProfilePath
    CreateFile StatBanPath
    CreateFile FocusPath
    CreateFile ProxyPath
End Sub

Public Sub Load(Profile As String)
    ProfilePath = AppData & "Profiles\" & Profile & "\Config.ini"
    StatBanPath = AppData & "Profiles\" & Profile & "\Statbans.dat"
    FocusPath = AppData & "Profiles\" & Profile & "\Focus.dat"
    ProxyPath = AppData & "Profiles\" & Profile & "\Proxies.dat"
    
    CreateFiles
    
    Op.ProfilePath = ProfilePath
    Op.StatBanPath = StatBanPath
    Op.Load
    Focus.ProfilePath = ProfilePath
    Focus.FocusPath = FocusPath
    Focus.Load
    
    mGateway = ReadINI(ProfilePath, REALM_SECTION, "Gateway")
    mCharacter = ReadINI(ProfilePath, REALM_SECTION, "Character")
    mGreet = IsYes(ReadINI(ProfilePath, GREET_SECTION, "Enabled"))
    mGreetMessage = Replace$(ReadINI(ProfilePath, GREET_SECTION, "Message"), "\r\n", vbNewLine)
    mIdle = IsYes(ReadINI(ProfilePath, IDLE_SECTION, "Enabled"))
    mIdleTime = Val(ReadINI(ProfilePath, IDLE_SECTION, "Interval"))
    mIdleMessage = Replace$(ReadINI(ProfilePath, IDLE_SECTION, "Message"), "\r\n", vbNewLine)
    mDynamicProfile = IsYes(ReadINI(ProfilePath, MAIN_SECTION, "DynamicProfile"))
    mForceOLS = IsYes(ReadINI(ProfilePath, MAIN_SECTION, "ForceOLS"))
    mCdkeyVerify = IsYes(ReadINI(ProfilePath, MAIN_SECTION, "CdkeyVerify"))
    mServer = ReadINI(ProfilePath, MAIN_SECTION, "Server")
    AutoConnect = IsYes(ReadINI(ProfilePath, MAIN_SECTION, "AutoConnect"))
    AutoLoad = IsYes(ReadINI(ProfilePath, MAIN_SECTION, "AutoLoad"))
    AutoHide = IsYes(ReadINI(ProfilePath, MAIN_SECTION, "AutoHide"))
    AutoLock = IsYes(ReadINI(ProfilePath, MAIN_SECTION, "AutoLock"))
    mPlug = IsYes(ReadINI(ProfilePath, MAIN_SECTION, "Plug"))
    mKeepAlive = IsYes(ReadINI(ProfilePath, MAIN_SECTION, "KeepAlive"))
    mCdkey = ReadINI(ProfilePath, MAIN_SECTION, "Cdkey")
    mCdkeyEx = ReadINI(ProfilePath, MAIN_SECTION, "CdkeyEx")
    mChannel = ReadINI(ProfilePath, MAIN_SECTION, "Channel")
    mBackupChannel = ReadINI(ProfilePath, MAIN_SECTION, "Backup")
    mPassword = ReadINI(ProfilePath, MAIN_SECTION, "Password")
    mTrigger = ReadINI(ProfilePath, MAIN_SECTION, "Trigger")
    mNewPassword = ReadINI(ProfilePath, MAIN_SECTION, "NewPassword")
    mQueue = ReadINI(ProfilePath, MAIN_SECTION, "Queue")
    mEmail = ReadINI(ProfilePath, REGISTER_SECTION, "Email")
    mNewEmail = ReadINI(ProfilePath, REGISTER_SECTION, "NewEmail")
    mProductID = ReadINI(ProfilePath, MAIN_SECTION, "ProductID")
    mVerbyte = CByte(Val("&H0" & ReadINI(ProfilePath, MAIN_SECTION, "Verbyte")))
    mProxyMode = Val(ReadINI(ProfilePath, PROXY_SECTION, "ProxyMode"))
    mUseBNLS = IsYes(ReadINI(ProfilePath, BNLS_SECTION, "UseBNLS"))
    mUsername = ReadINI(ProfilePath, MAIN_SECTION, "Username")
    mBindIP = ReadINI(ProfilePath, MAIN_SECTION, "LocalIP")
    mWhisperBack = IsYes(ReadINI(ProfilePath, MAIN_SECTION, "WhisperBack"))
    mShamanGlitch = IsYes(ReadINI(ProfilePath, MAIN_SECTION, "ShamanGlitch"))
    mARChieftain = ReadClanDB(ReadINI(ProfilePath, CLAN_SECTION, "Chieftain"))
    mARShaman = ReadClanDB(ReadINI(ProfilePath, CLAN_SECTION, "Shaman"))
    mARGrunt = ReadClanDB(ReadINI(ProfilePath, CLAN_SECTION, "Grunt"))
    mARPeon = ReadClanDB(ReadINI(ProfilePath, CLAN_SECTION, "Peon"))
    mARInitiate = ReadClanDB(ReadINI(ProfilePath, CLAN_SECTION, "Initiate"))
    mARFriend = ReadClanDB(ReadINI(ProfilePath, CLAN_SECTION, "Friend"))
    mARUnclan = ReadClanDB(ReadINI(ProfilePath, CLAN_SECTION, "Unclan"))
    Select Case Val(ReadINI(ProfilePath, REGISTER_SECTION, "Mode"))
        Case 0, 1, 2, 3: mRegister = Val(ReadINI(ProfilePath, REGISTER_SECTION, "Mode"))
        Case Else: mRegister = Disabled
    End Select
    Select Case Val(ReadINI(ProfilePath, MAIN_SECTION, "Ping"))
        Case 0, 1, 2: mPing = Val(ReadINI(ProfilePath, MAIN_SECTION, "Ping"))
        Case Else: mPing = DisablePing
    End Select
    
    ReDim mProxy(0)
    Dim FF As Integer, L As String
    FF = FreeFile
    Open ProxyPath For Append As #FF
    Close #FF
    Open ProxyPath For Input As #FF
    Do Until EOF(FF)
        Line Input #FF, L
        If LenB(L) > 0 Then
            If LenB(mProxy(0)) > 0 Then ReDim Preserve mProxy(UBound(mProxy) + 1)
            mProxy(UBound(mProxy)) = L
        End If
    Loop
    Close #FF
End Sub

Public Property Get ProxyCount() As Integer
    ProxyCount = UBound(mProxy)
End Property

Public Property Get ProxyMode() As Integer
    ProxyMode = mProxyMode
End Property

Public Property Let ProxyMode(V As Integer)
    mProxyMode = V
    WriteINI ProfilePath, PROXY_SECTION, "ProxyMode", CStr(V)
End Property

Public Property Get Proxy() As String
On Error GoTo hErr:
    If mProxyMode = 0 Then Exit Property
1   If CurProxy > UBound(mProxy) Then CurProxy = 0
    Dim S As String
2   S = mProxy(CurProxy)
3   If InStrB(S, ":") > 0 Then
4       If InStrB(S, "@") > 0 Then
            Dim r() As String
5           r = Split(S, "@")
            'user:pass@proxy:port
6           If InStr(r(0), ":") > 0 Then
7               mProxyUser = Split(r(0), ":")(0)
8               mProxyPass = Split(r(0), ":")(1)
            End If
9           If InStr(r(1), ":") > 0 Then
10              mProxyIP = Split(r(1), ":")(0)
11              mProxyPort = CLng(Val(Split(r(1), ":")(1)))
            End If
        Else
12          mProxyIP = Split(S, ":")(0)
13          mProxyPort = CLng(Val(Split(S, ":")(1)))
14          mProxyUser = vbNS
15          mProxyPass = vbNS
        End If
    Else
16      mProxyIP = S
17      mProxyPort = 1080
18      mProxyUser = vbNS
19      mProxyPass = vbNS
    End If
    Proxy = mProxyIP
    Exit Property
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Config", "Proxy"
End Property

Public Property Get ProxyPort() As Long
    ProxyPort = mProxyPort
End Property

Public Property Get ProxyUser() As String
    ProxyUser = mProxyUser
End Property

Public Property Get ProxyPass() As String
    ProxyPass = mProxyPass
End Property

Public Property Get IsWarCraft2() As Boolean
    IsWarCraft2 = (ProductID = "W2BN")
End Property
Public Property Get IsWarCraft3() As Boolean
    IsWarCraft3 = (ProductID = "WAR3" Or ProductID = "W3XP")
End Property
Public Property Get IsDiablo() As Boolean
    IsDiablo = (ProductID = "D2DV" Or ProductID = "D2XP")
End Property
Public Property Get IsStarCraft() As Boolean
    IsStarCraft = (ProductID = "STAR" Or ProductID = "SEXP")
End Property
Public Property Get IsExpansion() As Boolean
    IsExpansion = (ProductID = "D2XP" Or ProductID = "W3XP")
End Property
Public Property Get Ping() As PINGMODE
    Ping = mPing
End Property
Public Property Let Ping(Value As PINGMODE)
    mPing = Value
    WriteINI ProfilePath, MAIN_SECTION, "Ping", CStr(Value)
End Property
Public Property Get BnlsProduct() As Long
    Select Case mProductID
        Case "STAR"
            BnlsProduct = &H1
        Case "SEXP"
            BnlsProduct = &H2
        Case "W2BN"
            BnlsProduct = &H3
        Case "D2DV"
            BnlsProduct = &H4
        Case "D2XP"
            BnlsProduct = &H5
        Case "WAR3"
            BnlsProduct = &H7
        Case "W3XP"
            BnlsProduct = &H8
    End Select
End Property
Public Property Get UseBNLS() As Boolean
    UseBNLS = mUseBNLS
End Property
Public Property Let UseBNLS(Value As Boolean)
    mUseBNLS = Value
    WriteINI ProfilePath, BNLS_SECTION, "UseBNLS", YesNo(Value)
End Property
Public Property Get VerByte() As Byte
    VerByte = mVerbyte
End Property
Public Property Let VerByte(Value As Byte)
    mVerbyte = Value
    WriteINI ProfilePath, MAIN_SECTION, "Verbyte", CStr(Hex(Value))
End Property
Public Property Get ARChieftain() As String
    ARChieftain = mARChieftain
End Property
Public Property Let ARChieftain(Value As String)
    mARChieftain = Value
    WriteINI ProfilePath, CLAN_SECTION, "Chieftain", Value
End Property
Public Property Get ARShaman() As String
    ARShaman = mARShaman
End Property
Public Property Let ARShaman(Value As String)
    mARShaman = Value
    WriteINI ProfilePath, CLAN_SECTION, "Shaman", Value
End Property
Public Property Get ARGrunt() As String
    ARGrunt = mARGrunt
End Property
Public Property Let ARGrunt(Value As String)
    mARGrunt = Value
    WriteINI ProfilePath, CLAN_SECTION, "Grunt", Value
End Property
Public Property Get ARPeon() As String
    ARPeon = mARPeon
End Property
Public Property Let ARPeon(Value As String)
    mARPeon = Value
    WriteINI ProfilePath, CLAN_SECTION, "Peon", Value
End Property
Public Property Get ARInitiate() As String
    ARInitiate = mARInitiate
End Property
Public Property Let ARInitiate(Value As String)
    mARInitiate = Value
    WriteINI ProfilePath, CLAN_SECTION, "Initiate", Value
End Property
Public Property Get ARFriend() As String
    ARFriend = mARFriend
End Property
Public Property Let ARFriend(Value As String)
    mARFriend = Value
    WriteINI ProfilePath, CLAN_SECTION, "Friend", Value
End Property
Public Property Get ARUnclan() As String
    ARUnclan = mARUnclan
End Property
Public Property Let ARUnclan(Value As String)
    mARUnclan = Value
    WriteINI ProfilePath, CLAN_SECTION, "Unclan", Value
End Property
Public Property Get Username() As String
    Username = mUsername
End Property
Public Property Let Username(Value As String)
    mUsername = Value
    WriteINI ProfilePath, MAIN_SECTION, "Username", Value
End Property
Public Property Get Queue() As String
    Queue = mQueue
End Property
Public Property Let Queue(Value As String)
    mQueue = Value
    If LenB(Trim$(Value)) = 0 Then Value = "Basic"
    If LCase$(Value) = "default" Then Value = "Basic"
    WriteINI ProfilePath, MAIN_SECTION, "Queue", Value
End Property
Public Property Get Trigger() As String
    Trigger = mTrigger
End Property
Public Property Let Trigger(Value As String)
    mTrigger = Trim$(Value)
    If LenB(mTrigger) = 0 Then mTrigger = "."
    If Len(mTrigger) > 1 Then mTrigger = Left$(mTrigger, 1)
    WriteINI ProfilePath, MAIN_SECTION, "Trigger", mTrigger
End Property
Public Property Get Password() As String
    Password = mPassword
End Property
Public Property Let Password(Value As String)
    mPassword = Value
    WriteINI ProfilePath, MAIN_SECTION, "Password", Value
End Property
Public Property Get NewPassword() As String
    NewPassword = mNewPassword
End Property
Public Property Let NewPassword(Value As String)
    mNewPassword = Value
    WriteINI ProfilePath, MAIN_SECTION, "NewPassword", Value
End Property
Public Property Get LoginMessage() As String
    LoginMessage = mLoginMessage
End Property
Public Property Let LoginMessage(Value As String)
    mLoginMessage = Value
    WriteINI ProfilePath, "Login", "Message", Value
End Property
Public Property Get Cdkey() As String
    Cdkey = mCdkey
End Property
Public Property Let Cdkey(Value As String)
    Value = Replace$(Value, "-", vbNS)
    Value = Replace$(Value, Space$(1), vbNS)
    mCdkey = Value
    WriteINI ProfilePath, MAIN_SECTION, "Cdkey", mCdkey
End Property
Public Property Get CdkeyEx() As String
    CdkeyEx = mCdkeyEx
End Property
Public Property Let CdkeyEx(Value As String)
    Value = Replace$(Value, "-", vbNS)
    Value = Replace$(Value, Space$(1), vbNS)
    mCdkeyEx = Value
    WriteINI ProfilePath, MAIN_SECTION, "CdkeyEx", mCdkeyEx
End Property
Public Property Get ProductID() As String
    ProductID = mProductID
End Property
Public Property Let ProductID(Value As String)
    Select Case UCase$(Value)
    Case "STAR", "SEXP", "W2BN", "D2DV", "D2XP", "WAR3", "W3XP"
        mProductID = UCase$(Value)
    Case Else
        mProductID = vbNS
    End Select
    WriteINI ProfilePath, MAIN_SECTION, "ProductID", mProductID
End Property
Public Property Get BackupChannel() As String
    BackupChannel = mBackupChannel
End Property
Public Property Let BackupChannel(Value As String)
    mBackupChannel = Value
    WriteINI ProfilePath, MAIN_SECTION, "Backup", Value
End Property
Public Property Get Channel() As String
    Channel = mChannel
End Property
Public Property Let Channel(Value As String)
    mChannel = Value
    WriteINI ProfilePath, MAIN_SECTION, "Channel", Value
End Property
Public Property Get BindIP() As String
    BindIP = mBindIP
End Property
Public Property Let BindIP(Value As String)
    mBindIP = Value
    WriteINI ProfilePath, MAIN_SECTION, "LocalIP", Value
End Property
Public Property Get Email() As String
    Email = mEmail
End Property
Public Property Let Email(Value As String)
    mEmail = Value
    WriteINI ProfilePath, REGISTER_SECTION, "Email", Value
End Property
Public Property Get NewEmail() As String
    NewEmail = mNewEmail
End Property
Public Property Let NewEmail(Value As String)
    mNewEmail = Value
    WriteINI ProfilePath, REGISTER_SECTION, "NewEmail", Value
End Property
Public Property Get Register() As REGMODE
    Register = mRegister
End Property
Public Property Let Register(Value As REGMODE)
    mRegister = Value
    WriteINI ProfilePath, REGISTER_SECTION, "Mode", CStr(Value)
End Property
Public Property Get Server() As String
    Server = mServer
End Property
Public Property Get ServerName() As String
    ServerName = GetServerName(mServer, IsWarCraft3)
End Property
Public Property Get ServerNameEx(Optional W3 As Boolean = False) As String
    ServerNameEx = GetServerName(mServer, W3)
End Property
Public Property Let Server(Value As String)
    mServer = Value
    WriteINI ProfilePath, MAIN_SECTION, "Server", Value
End Property
Public Property Get KeepAlive() As Boolean
    KeepAlive = mKeepAlive
End Property
Public Property Let KeepAlive(ByVal vNewValue As Boolean)
    mKeepAlive = vNewValue
    WriteINI ProfilePath, MAIN_SECTION, "KeepAlive", YesNo(vNewValue)
End Property
Public Property Get CdkeyVerify() As Boolean
    CdkeyVerify = mCdkeyVerify
End Property
Public Property Let CdkeyVerify(ByVal vNewValue As Boolean)
    mCdkeyVerify = vNewValue
    WriteINI ProfilePath, MAIN_SECTION, "CdkeyVerify", YesNo(vNewValue)
End Property
Public Property Get ForceOLS() As Boolean
    ForceOLS = mForceOLS
End Property
Public Property Let ForceOLS(ByVal vNewValue As Boolean)
    mForceOLS = vNewValue
    WriteINI ProfilePath, MAIN_SECTION, "ForceOLS", YesNo(vNewValue)
End Property
Public Property Get AutoConnect() As Boolean
    AutoConnect = mAutoConnect
End Property
Public Property Let AutoConnect(ByVal vNewValue As Boolean)
    mAutoConnect = vNewValue
    WriteINI ProfilePath, MAIN_SECTION, "AutoConnect", YesNo(vNewValue)
End Property
Public Property Get AutoHide() As Boolean
    AutoHide = mAutoHide
End Property
Public Property Let AutoHide(ByVal vNewValue As Boolean)
    mAutoHide = vNewValue
    WriteINI ProfilePath, MAIN_SECTION, "AutoHide", YesNo(vNewValue)
End Property
Public Property Get ShamanGlitch() As Boolean
    ShamanGlitch = mShamanGlitch
End Property
Public Property Let ShamanGlitch(ByVal vNewValue As Boolean)
    mShamanGlitch = vNewValue
    WriteINI ProfilePath, MAIN_SECTION, "ShamanGlitch", YesNo(vNewValue)
End Property
Public Property Get AutoLoad() As Boolean
    AutoLoad = mAutoLoad
End Property
Public Property Let AutoLoad(ByVal vNewValue As Boolean)
    mAutoLoad = vNewValue
    WriteINI ProfilePath, MAIN_SECTION, "AutoLoad", YesNo(vNewValue)
End Property
Public Property Get AutoLock() As Boolean
    AutoLock = mAutoLock
End Property
Public Property Let AutoLock(ByVal vNewValue As Boolean)
    mAutoLock = vNewValue
    WriteINI ProfilePath, MAIN_SECTION, "AutoLock", YesNo(vNewValue)
End Property
Public Property Get DynamicProfile() As Boolean
    DynamicProfile = mDynamicProfile
End Property
Public Property Let DynamicProfile(ByVal vNewValue As Boolean)
    mDynamicProfile = vNewValue
    WriteINI ProfilePath, MAIN_SECTION, "DynamicProfile", YesNo(vNewValue)
End Property
Public Property Get WhisperBack() As Boolean
    WhisperBack = mWhisperBack
End Property
Public Property Let WhisperBack(ByVal vNewValue As Boolean)
    mWhisperBack = vNewValue
    WriteINI ProfilePath, MAIN_SECTION, "WhisperBack", YesNo(vNewValue)
End Property
Public Property Get Idle() As Boolean
    Idle = mIdle
End Property
Public Property Let Idle(ByVal vNewValue As Boolean)
    mIdle = vNewValue
    WriteINI ProfilePath, IDLE_SECTION, "Enabled", YesNo(vNewValue)
End Property
Public Property Get IdleMessage() As String
    IdleMessage = mIdleMessage
End Property
Public Property Let IdleMessage(ByVal vNewValue As String)
    mIdleMessage = vNewValue
    WriteINI ProfilePath, IDLE_SECTION, "Message", Replace$(vNewValue, vbNewLine, "\r\n")
End Property
Public Property Get Greet() As Boolean
    Greet = mGreet
End Property
Public Property Let Greet(ByVal vNewValue As Boolean)
    mGreet = vNewValue
    WriteINI ProfilePath, GREET_SECTION, "Enabled", YesNo(vNewValue)
End Property
Public Property Get GreetMessage() As String
    GreetMessage = mGreetMessage
End Property
Public Property Let GreetMessage(ByVal vNewValue As String)
    mGreetMessage = vNewValue
    WriteINI ProfilePath, GREET_SECTION, "Message", Replace$(vNewValue, vbNewLine, "\r\n")
End Property
Public Property Get IdleTime() As Double
    IdleTime = mIdleTime
End Property
Public Property Let IdleTime(ByVal vNewValue As Double)
    mIdleTime = vNewValue
    WriteINI ProfilePath, IDLE_SECTION, "Interval", CStr(vNewValue)
End Property
Public Property Get Plug() As Boolean
    Plug = mPlug
End Property
Public Property Let Plug(ByVal vNewValue As Boolean)
    mPlug = vNewValue
    WriteINI ProfilePath, MAIN_SECTION, "Plug", YesNo(vNewValue)
End Property
Public Property Get Character() As String
    Character = mCharacter
End Property
Public Property Let Character(ByVal vNewValue As String)
    mCharacter = vNewValue
    WriteINI ProfilePath, REALM_SECTION, "Character", CStr(vNewValue)
End Property
Public Property Get Gateway() As String
    Gateway = mGateway
End Property
Public Property Let Gateway(ByVal vNewValue As String)
    mGateway = vNewValue
    WriteINI ProfilePath, REALM_SECTION, "Gateway", CStr(vNewValue)
End Property
Public Sub Class_Initialize()
    Set Op = New clsModeration
    Set Focus = New clsFocus
End Sub
Public Sub Class_Terminate()
    On Error Resume Next
    Set Op = Nothing
    Set Focus = Nothing
End Sub
