VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsCommandHandler"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' FIX CMDADD/CMDDELETE

Public Sub cmdPlugins(CS As objCmdSet)
    Dim FL() As String, I As Integer, Buf As String
    FL = FileList(AppData & "Plugins\*.dll")
    For I = 0 To UBound(FL)
        Buf = Buf & Left$(FL(I), Len(FL(I)) - 4) & ", "
        If Len(Buf) >= 50 Then
            CS.ReplyEvent Left$(Buf, Len(Buf) - 2) & IIf(I = UBound(FL), ".", ", ..."), &HB0
            Buf = vbNS
        End If
    Next I
    If Len(Buf) > 0 Then
        CS.ReplyEvent Left$(Buf, Len(Buf) - 2) & ".", &HB0
    End If
End Sub

Public Sub cmdScripts(CS As objCmdSet)
    Dim FL() As String, I As Integer, Buf As String
    FL = FileList(AppData & "Scripts\*.txt")
    For I = 0 To UBound(FL)
        Buf = Buf & Left$(FL(I), Len(FL(I)) - 4) & ", "
        If Len(Buf) >= 50 Then
            CS.ReplyEvent Left$(Buf, Len(Buf) - 2) & IIf(I = UBound(FL), ".", ", ..."), &HB0
            Buf = vbNS
        End If
    Next I
    If Len(Buf) > 0 Then
        CS.ReplyEvent Left$(Buf, Len(Buf) - 2) & ".", &HB0
    End If
End Sub

Public Sub cmdPlugin(CS As objCmdSet)
    Dim PN$, PJ%, PI%, PB%, PA$, PC$, PD$
    GetPluginValues CS.Message, PN, PJ, PI, PB, PA, PC, PD
    If Len(PN) > 0 And Len(PA) > 0 And Len(PD) > 0 Then
        CS.ReplyEvent PN & " v" & PJ & "." & PI & "." & PB & " by " & PA, &HB0
        CS.ReplyEvent PD, &HB0
        CS.ReplyEvent "Commands: " & PC, &HB0
    Else
        CS.ReplyEvent "Plugin not found!", &HB2
    End If
End Sub

Public Sub cmdScript(CS As objCmdSet)
    Dim PN, PJ, PI, PB, PA, PC, PD
    GetScriptValues CS.Message, PN, PJ, PI, PB, PA, PC, PD
    If Len(PN) > 0 And Len(PA) > 0 And Len(PD) > 0 Then
        CS.ReplyEvent PN & " v" & PJ & "." & PI & "." & PB & " by " & PA, &HB0
        CS.ReplyEvent PD, &HB0
        If Len(PC) Then CS.ReplyEvent "Commands: " & PC, &HB0
    Else
        CS.ReplyEvent "Script not found!", &HB2
    End If
End Sub

Public Sub cmdAddQuote(CS As objCmdSet)
    AddQuote CS.Message
    CS.Reply "Added quote!"
End Sub

Public Sub cmdQuote(CS As objCmdSet)
    Dim r As String
    r = RandomQuote
    If Len(r) > 0 Then
        CS.Reply r
    Else
        CS.Reply "No quotes have been added."
    End If
End Sub

Public Sub cmdEval(CS As objCmdSet)
    CS.Reply "Response: " & CS.Bot.scEval(CS.Message)
End Sub

Public Sub cmdStatAdd(CS As objCmdSet)
    Dim S() As String, E As String
    S = Split(CS.Message, " ")
    If UBound(S) = 2 Then
        If CS.Bot.Config.Op.StatAdd(S(0), S(1), S(2), E) Then
            CS.ReplyEvent "Added statban with id '" & S(0) & "'.", &HB1
        Else
            CS.ReplyEvent E, &HB2
        End If
    Else
        CS.ReplyEvent "Invalid syntax, try: /statadd [id] [product] [options].", &HB2
    End If
End Sub

Public Sub cmdStatDel(CS As objCmdSet)
    If CS.Bot.Config.Op.StatDelete(CS.Message) Then
        CS.ReplyEvent "Deleted statban with id '" & CS.Message & "'.", &HB1
    Else
        CS.ReplyEvent "Statban with that id does not exist!", &HB2
    End If
End Sub

Public Sub cmdStatFind(CS As objCmdSet)
    Dim SF As Integer
    SF = CS.Bot.Config.Op.StatFind(CS.Message)
    If SF = -1 Then
        CS.ReplyEvent "Statban with that id does not exist!", &HB2
    Else
        CS.ReplyEvent "Statban: " & Replace$(CS.Bot.Config.Op.StatBans(SF), "/", " "), &HB0
    End If
End Sub

Public Sub cmdStatBans(CS As objCmdSet)
On Error GoTo hErr:
    Dim I As Integer, B As String, S As Boolean
1   With CS.Bot.Config.Op.StatBans
2       If .Count > 0 Then
3           For I = 1 To .Count
4               If InStr(.Item(I), "/") Then
5                   B = B & Prefix(.Item(I), "/") & ", "
6                   If Len(B) >= 40 Then
7                       If I = .Count Then B = Left$(B, Len(B) - 2)
8                       CS.ReplyEvent IIf(S, vbNS, "StatBans: ") & B & IIf(I = .Count, ".", "..."), &HB0
9                       S = True
10                      B = vbNS
11                  End If
12              End If
13          Next I
14          If Len(B) Then
15              B = Left$(B, Len(B) - 2)
16              CS.ReplyEvent IIf(S, vbNS, "StatBans: ") & B & ".", &HB0
17          End If
        Else
            CS.ReplyEvent "No statbans exist, type /statadd [id] [product] [options] to add one.", &HB2
18      End If
19  End With
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "StatBans"
End Sub

Public Sub cmdFriendList(CS As objCmdSet)
    Dim B As String, I As Integer, First As Boolean, Last As Boolean
    First = True
    For I = 1 To CS.Bot.Friends.Count
        B = B & CS.Bot.Friends(I).Username & IIf(CS.Bot.Friends(I).Location = &H0, vbNS, "*") & ", "
        If Len(B) >= 40 Then
            Last = (CS.Bot.Friends.Count = I)
            If Last Then B = Left$(B, Len(B) - 2)
            CS.ReplyEvent IIf(First, "Friends (* = online): ", vbNS) & B & IIf(Not Last, "...", vbNS), &HB0
            B = vbNS
            First = False
        End If
    Next I
    If LenB(B) Then CS.ReplyEvent IIf(First, "Friends (* = online): ", vbNS) & Left$(B, Len(B) - 2), &HB0
End Sub

Public Sub cmdFriendInfo(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) Then
        Dim V As Integer, I As Integer
        V = -1
2       If Len(CS.Message) < 3 Then
3           If CStr(Val(CS.Message)) = CS.Message Then
4               V = Abs(Val(CS.Message))
5               If Not (CS.Bot.Friends.Count >= V And V > 0) Then
                    V = -1
                End If
            End If
        End If
        If V = -1 Then
6           I = CS.Bot.FindFriend(Suffix(CS.Message))
        Else
            I = V
        End If
        If I > 0 And I <= CS.Bot.Friends.Count Then
7           Dim F As objFriend, str As String, sta As String
8           Set F = CS.Bot.Friends(I)
            If Not F Is Nothing Then
9               If F.Location = &H0 Then
10                  CS.ReplyEvent I & ". " & F.Username & ", offline.", &HB2
                    Exit Sub
                End If
11              sta = FriendStatus2(F.Status)
12              str = I & ". " & F.Username & ", " & IIf(LenB(sta), "(" & sta & ")", vbNS) & " using " & ProductToStr(StrReverse$(F.ProductID)) & " "
                Select Case F.Location
                    Case &H1: str = str & "and is not in chat."
14                  Case &H2: str = str & "in " & IIf(Len(F.LocationName), "the channel " & F.LocationName & ".", "a private channel.")
15                  Case &H3: str = str & "in a public game" & IIf(Len(F.LocationName), " called " & F.LocationName & ".", ".")
16                  Case &H4: str = str & "in a private game" & IIf(Len(F.LocationName), " called " & F.LocationName & ".", ".")
17                  Case &H5: str = str & "in a password protected game" & IIf(Len(F.LocationName), " called " & F.LocationName & ".", ".")
18                  Case Else: CS.ReplyEvent F.Username & "'s location is unknown.", &HB2: Exit Sub
                End Select
                CS.ReplyEvent str, &HB0
            End If
        Else
            CS.ReplyEvent "Friend not found, use /f a [username] to add a friend.", &HB2
        End If
    End If
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "FriendInfo"
End Sub

Public Sub cmdUSWest(CS As objCmdSet)
    CS.Bot.Config.Server = "uswest.battle.net"
    CS.Bot.Connect
End Sub

Public Sub cmdUSEast(CS As objCmdSet)
    CS.Bot.Config.Server = "useast.battle.net"
    CS.Bot.Connect
End Sub

Public Sub cmdAsia(CS As objCmdSet)
    CS.Bot.Config.Server = "asia.battle.net"
    CS.Bot.Connect
End Sub

Public Sub cmdEurope(CS As objCmdSet)
    CS.Bot.Config.Server = "europe.battle.net"
    CS.Bot.Connect
End Sub

'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' OPERATIONAL COMMANDS
'///////////////////////////////////////////////////////////////////////////////
Public Sub cmdGroup(CS As objCmdSet)
    Dim User As String, Splt() As String
    Splt = Split(CS.Message, " ")
    If UBound(Splt) = 1 Then
        If IsGroup(Splt(1)) Then
            User = Suffix(Splt(0))
            If (GetGroupColor(User) <> -1) Then
                CS.ReplyEvent GetRes("group", "1", User), &HB2
            Else
                Dim I As Integer
                For I = 0 To UBound(Groups())
                    If LCase$(Groups(I).Name) = LCase$(Splt(1)) Then
                        Groups(I).Add User
                        Groups(I).SaveGroup
                        CS.ReplyEvent "Added " & User & " to group " & Groups(I).Name & "!", &HB1
                        RefreshChannel
                        Exit Sub
                    End If
                Next I
            End If
        Else
            CS.ReplyEvent GetRes("group", "2", Splt(1)), &HB2
        End If
    End If
End Sub
Public Sub cmdGroups(CS As objCmdSet)
    Dim x As Integer, Buf As String, Sent As Boolean
    For x = 0 To UBound(Groups)
        If LenB(Groups(x).Name) > 0 Then
            Buf = Buf & Groups(x).Name & ", "
            If Len(Buf) >= 40 Then
                CS.ReplyEvent "Groups: " & Left$(Buf, Len(Buf) - 2), &HB0
                Buf = vbNS
                Sent = True
            End If
        End If
    Next x
    If Len(Buf) > 0 Then
        CS.ReplyEvent "Groups: " & Left$(Buf, Len(Buf) - 2), &HB0
        Buf = vbNS
        Sent = True
    End If
    If Not Sent Then CS.ReplyEvent "No groups found!", &HB2
End Sub
Public Sub cmdUngroup(CS As objCmdSet)
    Dim I As Integer, C As Integer, Removed As Boolean
    C = UBound(Groups)
    For I = 0 To C
        If Groups(I).Remove(CS.Message) Then Removed = True
        If Removed Then Groups(I).SaveGroup
    Next I
    If Removed Then
        CS.ReplyEvent GetRes("ungroup", "1"), &HB1
    Else
        CS.ReplyEvent GetRes("ungroup", "2", CS.Message), &HB2
    End If
    RefreshChannel
End Sub
Public Sub cmdIdleVars(CS As objCmdSet)
    CS.Reply GetRes("Idle", "vars")
End Sub
Public Sub cmdGreetVars(CS As objCmdSet)
    CS.Reply GetRes("Greet", "vars")
End Sub
Public Sub cmdIdle(CS As objCmdSet)
    If LenB(CS.Message) = 0 Then
        CS.ReplyEvent GetRes("Idle", "3"), &HB2
        Exit Sub
    End If
    With CS.Bot.Config
        Select Case UCase$(CS.Message)
        Case "ON": .Idle = True
            CS.ReplyEvent GetRes("Idle", "1", OnOff(.Idle)), &HB1
        Case "OFF": .Idle = False
            CS.ReplyEvent GetRes("Idle", "1", OnOff(.Idle)), &HB1
        Case "?"
            CS.ReplyEvent GetRes("Idle", "2", OnOff(.Idle)), &HB0
        Case Else
            CS.ReplyEvent GetRes("Idle", "3"), &HB2
        End Select
    End With
End Sub
Public Sub cmdGreet(CS As objCmdSet)
    If LenB(CS.Message) = 0 Then
        CS.ReplyEvent GetRes("Greet", "3"), &HB2
        Exit Sub
    End If
    With CS.Bot.Config
        Select Case UCase$(CS.Message)
        Case "ON": .Greet = True
            CS.ReplyEvent GetRes("Greet", "1", OnOff(.Greet)), &HB1
        Case "OFF": .Greet = False
            CS.ReplyEvent GetRes("Greet", "1", OnOff(.Greet)), &HB1
        Case "?"
            CS.ReplyEvent GetRes("Greet", "2", OnOff(.Greet)), &HB0
        Case Else
            CS.ReplyEvent GetRes("Greet", "3"), &HB2
        End Select
    End With
End Sub
Public Sub cmdSetGreet(CS As objCmdSet)
    With CS.Bot.Config
        If LenB(Trim$(CS.Message)) = 0 Then
            .GreetMessage = vbNS
            .Greet = False
            CS.Reply GetRes("greet", "4")
        Else
            .GreetMessage = CS.Message
            CS.Reply GetRes("greet", "5")
        End If
    End With
End Sub
Public Sub cmdSetIdle(CS As objCmdSet)
    With CS.Bot.Config
        If LenB(Trim$(CS.Message)) = 0 Then
            .IdleMessage = vbNS
            .Idle = False
            CS.Reply GetRes("idle", "6")
        Else
            If InStr(CS.Message, " ") > 0 Then
                Dim S() As String, Seconds As Double
                S = Split(CS.Message, " ", 2)
                Seconds = Abs(Val(S(0)))
                If Val(Seconds) > 0 Then
                    .IdleTime = Seconds
                End If
                .IdleMessage = S(1)
                CS.Reply GetRes("idle", "4")
            Else
                CS.Reply GetRes("idle", "5")
            End If
        End If
    End With
End Sub
Public Sub cmdGames(CS As objCmdSet)
    With CS.Bot
        If .Config.IsDiablo Then
            .SendRealmGameList
        Else
            If CS.Bot.Self.IsWarCraft3 Then
                .SendGameListW3
            Else
                .SendGameList GameTypeFromString(CS.Message)
            End If
        End If
    End With
End Sub
Public Sub cmdFocus(CS As objCmdSet)
    Dim User As String, S() As String, I As Integer, Users As New Collection
    User = Trim$(Suffix(CS.Message))
    S = Split(User, ", ")
    For I = 0 To UBound(S)
        Users.Add CStr(Prefix(S(I), " "))
    Next I
    Dim frm As Form, Success As Boolean
    If Users.Count = 1 Then
        Set frm = FocusSingle(User, CS.Index, Success)
        If Success Then
            frm.Flash
        End If
    Else
        Success = False
    End If
    If Not Success Then
        CreateFocus Users, CS.Index
    End If
End Sub
Public Sub cmdUnfocus(CS As objCmdSet)
    Dim User As String, S() As String, I As Integer
    User = Trim$(Suffix(CS.Message))
    S = Split(User, ", ")
    For I = 0 To UBound(S)
        Dim F As Form
        For Each F In Forms
            If F.Name = "frmFocus" Then
                If F.BotIndex = CS.Index Then
                    F.DelUser S(I)
                End If
            End If
        Next
    Next
End Sub
Public Sub cmdBans(CS As objCmdSet)
    With CS.Bot.BanList
        Output frmBot.rtbChat(CS.Index), &HB2, , "There are currently " & .Count & " recorded bans!"
        Dim I As Integer
        For I = 0 To .Count
            If LenB(.Item(I).Username) Then Output frmBot.rtbChat(CS.Index), &HB2, , "- " & .Item(I).Username & " (" & .Item(I).Reason & ") banned by " & .Item(I).Operator & " (" & DateTimeToShortestString(ConvertTickCount(DblTickCount - .Item(I).Tick)) & ")"
        Next I
    End With
End Sub
Public Sub cmdClearBans(CS As objCmdSet)
    CS.Bot.BanList.Clear
    Output frmBot.rtbChat(CS.Index), &HB1, , "Cleared recorded bans!"
End Sub
Public Sub cmdConnectAll(CS As objCmdSet)
    Dim B As BNCS
    For Each B In frmBot.Bot
        If B.IsLoaded And B.IsOnline = False Then B.Connect
    Next B
End Sub
Public Sub cmdUnload(CS As objCmdSet)
    With CS.Bot
        If LenB(CS.Message) = 0 Then
            UnloadProfile CS.Index, True
        Else
            Dim M As Integer
            CS.Message = LCase$(CS.Message)
            For M = 0 To frmBot.Bot.UBound
                If LCase$(frmBot.Bot(M).Profile) = CS.Message And frmBot.Bot(M).IsLoaded Then
                    CS.ReplyEvent "Unloading profile: " & frmBot.Bot(M).Profile, &HB1
                    UnloadProfile frmBot.Bot(M).BotIndex, True
                End If
            Next M
            CS.ReplyEvent "That profile is not loaded!", &HB2
        End If
    End With
End Sub
Public Sub cmdLoad(CS As objCmdSet)
    If LenB(CS.Message) = 0 Then
        CS.ReplyEvent "Please specify a profile to load!", &HB2
        Exit Sub
    End If
    With CS.Bot
        Dim J As Folders, F As Folder, K As Integer, Found As Boolean, NewName As String
        Set J = FolderList(AppData & "Profiles\")
        For Each F In J
            If LCase$(CS.Message) = LCase$(F.Name) Then
                Found = True
                NewName = F.Name
                For K = 0 To frmBot.Bot.UBound
                    If LCase$(frmBot.Bot(K).Profile) = LCase$(CS.Message) And frmBot.Bot(K).IsLoaded Then
                        CS.ReplyEvent "That profile is already loaded!", &HB2
                    End If
                Next K
            End If
        Next
        If Not Found Then
            CS.ReplyEvent "That profile does not exist!", &HB2
        ElseIf Found And LenB(NewName) <> 0 Then
            CS.ReplyEvent "Loading profile: " & NewName, &HB1
            LoadProfile NewName
        End If
    End With
End Sub

'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' FILTERING COMMANDS
'///////////////////////////////////////////////////////////////////////////////
Public Sub cmdFilters(CS As objCmdSet)
    Dim x As Integer, Buf As String, Sent As Boolean
    For x = 0 To UBound(Filters)
        If Filters(x).blnUser = False Then
            If LenB(Filters(x).strText) > 0 Then
                Buf = Buf & Filters(x).strText & ", "
                If Len(Buf) >= 40 Then
                    CS.Reply "Messages: " & Left$(Buf, Len(Buf) - 2)
                    Buf = vbNS
                    Sent = True
                End If
            End If
        End If
    Next x
    If Len(Buf) > 0 Then
        CS.Reply "Messages: " & Left$(Buf, Len(Buf) - 2)
        Buf = vbNS
        Sent = True
    End If
    For x = 0 To UBound(Filters)
        If Filters(x).blnUser = True Then
            If LenB(Filters(x).strText) > 0 Then
                Buf = Buf & Filters(x).strText & ", "
                If Len(Buf) >= 40 Then
                    CS.Reply "Users: " & Left$(Buf, Len(Buf) - 2)
                    Buf = vbNS
                    Sent = True
                End If
            End If
        End If
    Next x
    If Len(Buf) > 0 Then
        CS.Reply "Users: " & Left$(Buf, Len(Buf) - 2)
        Buf = vbNS
        Sent = True
    End If
    If Not Sent Then CS.ReplyEvent "No filters found!", &HB2
End Sub
Public Sub cmdUnfilter(CS As objCmdSet)
    If InStr(CS.Message, " ") > 0 Then
        Dim S() As String
        S = Split(CS.Message, " ", 2)
        If UBound(S) = 1 Then
            Select Case UCase$(S(0))
            Case "U"
                If RemoveFilter(S(1), True) Then
                    CS.ReplyEvent "Removed user filter: " & S(1) & ".", &HB1
                Else
                    CS.ReplyEvent "User filter not found: " & S(1) & ".", &HB2
                End If
                Exit Sub
            Case "M"
                'Debug.Print S(1)
                If RemoveFilter(S(1), False) Then
                    CS.ReplyEvent "Removed message filter: " & S(1) & ".", &HB1
                Else
                    CS.ReplyEvent "Message filter not found: " & S(1) & ".", &HB2
                End If
                Exit Sub
            End Select
        End If
    End If
    CS.ReplyEvent "Syntax error, try: /unfilter [M/U] [message/user]", &HB2
End Sub
Public Sub cmdFilter(CS As objCmdSet)
    If InStr(CS.Message, " ") > 0 Then
        Dim S() As String
        S = Split(CS.Message, " ", 2)
        If UBound(S) = 1 Then
            Select Case UCase$(S(0))
            Case "U"
                If AddFilter(S(1), True) Then
                    CS.ReplyEvent "Added user filter: " & S(1) & ".", &HB1
                Else
                    CS.ReplyEvent "Replaced user filter: " & S(1) & ".", &HB2
                End If
                Exit Sub
            Case "M"
                If AddFilter(S(1), False) Then
                    CS.ReplyEvent "Added message filter: " & S(1) & ".", &HB1
                Else
                    CS.ReplyEvent "Replaced message filter: " & S(1) & ".", &HB2
                End If
                Exit Sub
            End Select
        End If
    End If
    CS.ReplyEvent "Syntax error, try: /filter [M/U] [message/user]", &HB2
End Sub

Public Sub cmdSay(CS As objCmdSet)
    If CS.IsConsole Then
        CS.Bot.SendAway CS.Message
    Else
        CS.Bot.SendAway CS.Username & " says: " & CS.Message
    End If
End Sub

Public Sub cmdSpeak(CS As objCmdSet)
    If CS.Display < 3 Then
        If Left$(CS.Message, 1) = "/" Then
            If Len(CS.Message) > 4 And InStrB(CS.Message, " ") > 0 Then
                Select Case LCase$(Mid$(CS.Message, 2, InStr(CS.Message, " ") - 2))
                Case "ban", "kick", "designate", "resign", "rejoin", "join", "j", "rj", "unban", "ignore", "unignore"
                    CS.Bot.SendAway "Cannot send that command using 'speak'."
                    Exit Sub
                End Select
            End If
        End If
    End If
    CS.Bot.SendAway CS.Message
End Sub
Public Sub cmdEmote(CS As objCmdSet)
    CS.Bot.SendAway "/me " & CS.Message
End Sub

'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' ALIASES, TAGS COMMANDS
'///////////////////////////////////////////////////////////////////////////////
Public Sub cmdUntag(CS As objCmdSet)
    Dim Chan As String
    Chan = CS.Message
    If Tags.RemoveTag(Chan) Then
        CS.ReplyEvent "Removed tag for channel: " & Chan, &HB1
    Else
        CS.ReplyEvent "Channel does not have a tag!", &HB2
    End If
End Sub
Public Sub cmdUnalias(CS As objCmdSet)
    If InStr(CS.Message, " ") > 0 Then
        Dim S() As String
        S = Split(CS.Message, " ")
        If UBound(S) = 1 Then
            If Alias.RemoveAlias(S(0), S(1)) Then
                CS.ReplyEvent "Removed alias for user: " & S(0) & "@" & S(1), &HB1
            Else
                CS.ReplyEvent "User does not have an alias or gateway is invalid!", &HB2
            End If
        End If
    Else
        Dim ServName As String, User As String
        User = CS.Message
        If IsOnGateway(CS.Message) Then
            ServName = Mid$(User, InStrRev(User, "@") + 1)
        Else
            ServName = CS.Bot.Config.ServerName
        End If
        If Alias.RemoveAlias(User, ServName) Then
            CS.ReplyEvent "Removed alias for user: " & User & "@" & ServName, &HB1
        Else
            CS.ReplyEvent "User does not have an alias or gateway is invalid!", &HB2
        End If
    End If
End Sub
Public Sub cmdTag(CS As objCmdSet)
    If InStr(CS.Message, " => ") > 0 Then
        Dim S() As String, Doodad As String
        S = Split(CS.Message, " => ")
        If UBound(S) = 1 Then
            If Tags.TagExists(S(0)) Then
                Doodad = "Updated"
            Else
                Doodad = "Added"
            End If
            If Tags.AddTag(S(0), S(1)) Then
                CS.ReplyEvent Doodad & " tag for channel: " & S(0), &HB1
            Else
                CS.ReplyEvent "Unknown error occurred!", &HB2
            End If
        End If
    End If
End Sub
Public Sub cmdAlias(CS As objCmdSet)
    If InStr(CS.Message, " ") > 0 Then
        Dim S() As String, Doodad As String
        S = Split(CS.Message, " ")
        If UBound(S) = 2 Then
            If Alias.AliasExists(S(0), S(2)) Then
                Doodad = "Updated"
            Else
                Doodad = "Added"
            End If
            If Alias.AddAlias(S(0), S(1), S(2)) Then
                CS.ReplyEvent Doodad & " alias for user: " & S(0) & "@" & S(2), &HB1
            Else
                CS.ReplyEvent "Gateway is invalid!", &HB2
            End If
        ElseIf UBound(S) = 1 Then
            Dim ServerName As String
            If IsOnGateway(S(0)) Then
                ServerName = Mid$(S(0), InStrRev(S(0), "@") + 1)
            Else
                ServerName = CS.Bot.Config.ServerName
            End If
            If Alias.AliasExists(S(0), ServerName) Then
                Doodad = "Updated"
            Else
                Doodad = "Added"
            End If
            If Alias.AddAlias(S(0), S(1), ServerName) Then
                CS.ReplyEvent Doodad & " alias for user: " & S(0) & "@" & ServerName, &HB1
            Else
                CS.ReplyEvent "Gateway is invalid!", &HB2
            End If
        End If
    End If
End Sub

'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' BASIC COMMANDS
'///////////////////////////////////////////////////////////////////////////////
Public Sub cmdPing(CS As objCmdSet)
On Error GoTo hErr:
1   With CS.Bot
2       Dim U As New objUser
3       If LenB(CS.Message) = 0 Then
4           CS.Reply "My ping is: " & .Self.Ping & "ms"
5       Else
6           Set U = .Users.GetByName(CS.Message)
7           If Not U Is Nothing Then
                If LenB(U.Account) = 0 Then
                    CS.Reply CS.Message & " is not in the channel!"
                Else
8                   CS.Reply U.Account & " has a ping of: " & U.Ping & "ms"
                End If
9           Else
10              CS.Reply CS.Message & " is not in the channel!"
11          End If
12      End If
13  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Ping"
End Sub
Public Sub cmdPingMe(CS As objCmdSet)
On Error GoTo hErr:
1   With CS.Bot
2       Dim U As New objUser
3       Set U = .Users.GetByName(CS.Username)
4       If Not U Is Nothing Then CS.Reply "Your ping is: " & U.Ping & "ms"
5   End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "PingMe"
End Sub
Public Sub cmdInfo(CS As objCmdSet)
On Error GoTo hErr:
1   With CS.Bot
2       Dim U As New objUser
3       Set U = .Users.GetByName(CS.Message)
4       If Not U Is Nothing Then CS.Reply U.Account & " [" & LongToHex(U.Flags) & ", " & U.Ping & "ms] " & _
            "joined " & DateTimeToShortString(ConvertTickCount(DblTickCount() - U.TickJoin)) & " ago, " & _
            "talked " & DateTimeToShortString(ConvertTickCount(DblTickCount() - U.TickTalk)) & " ago."
5   End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Info"
End Sub
Public Sub cmdMass(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.Reply "Please specify a channel to move bots to!"
3       Exit Sub
4   End If
5   With CS.Bot
6       Dim B As BNCS
7       For Each B In frmBot.Bot
8           If ServerMatch(B.Config.Server, .Config.Server) Then B.SendAway "/join " & CS.Message
9       Next B
10  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Mass"
End Sub


'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' CONFIG RELATED
'///////////////////////////////////////////////////////////////////////////////
Public Sub cmdWhisperBack(CS As objCmdSet)
On Error GoTo hErr:
1   With CS.Bot.Config
        Select Case UCase$(CS.Message)
        Case "ON"
            .WhisperBack = True
2           CS.ReplyEvent "WhisperBack is now: " & OnOff(.WhisperBack), &HB1
        Case "OFF"
            .WhisperBack = False
3           CS.ReplyEvent "WhisperBack is now: " & OnOff(.WhisperBack), &HB1
        Case Else
4           CS.ReplyEvent "WhisperBack is currently: " & OnOff(.WhisperBack), &HB0
        End Select
    End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "WhisperBack"
End Sub
Public Sub cmdSetHome(CS As objCmdSet)
On Error GoTo hErr:
5   With CS.Bot
1       If LenB(CS.Message) = 0 Then
            .Config.Channel = .Self.Channel
2           CS.Reply "Home channel changed to: " & .Config.Channel
4       Else
6           .Config.Channel = CS.Message
7           CS.Reply "Home channel changed to: " & .Config.Channel
        End If
8   End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "SetHome"
End Sub
Public Sub cmdSetBackup(CS As objCmdSet)
On Error GoTo hErr:
5   With CS.Bot
1       If LenB(CS.Message) = 0 Then
            .Config.BackupChannel = .Self.Channel
2           CS.Reply "Backup channel changed to: " & .Config.BackupChannel
4       Else
6           .Config.BackupChannel = CS.Message
7           CS.Reply "Backup channel changed to: " & .Config.BackupChannel
        End If
8   End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "SetBackup"
End Sub
Public Sub cmdSetAccount(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.Reply "Please specify a new account!"
3       Exit Sub
4   End If
5   With CS.Bot
6       .Config.Username = CS.Message
7       CS.Reply "Account changed to: " & CS.Message
8   End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "SetAccount"
End Sub
Public Sub cmdSetServer(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.Reply "Please specify a new server!"
3       Exit Sub
4   End If
5   With CS.Bot
6       .Config.Server = CS.Message
7       CS.Reply "Server changed to: " & CS.Message
8   End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "SetServer"
End Sub
Public Sub cmdSetPassword(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.Reply "Please specify the account's password!"
3       Exit Sub
4   End If
5   With CS.Bot
6       .Config.Password = CS.Message
7       CS.Reply "Password changed!"
8   End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "SetPassword"
End Sub
Public Sub cmdSetNewPassword(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.Reply "Please specify a new password for the account!"
3       Exit Sub
4   End If
5   With CS.Bot
6       .Config.NewPassword = CS.Message
7       CS.Reply "New password set, reconnect to carry out change!"
8   End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "SetNewPassword"
End Sub
Public Sub cmdSetTrigger(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.Reply "Please specify a new trigger!"
3       Exit Sub
4   End If
5   With CS.Bot
6       .Config.Trigger = CS.Message
7       CS.Reply "Trigger changed to: " & CS.Message
8   End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "SetTrigger"
End Sub
Public Sub cmdQueues(CS As objCmdSet)
On Error GoTo hErr:
    Dim F() As String, I As Integer, Buf As String, E As Boolean
1   F = FileList(AppData & "Queues\*.queue")
2   For I = 0 To UBound(F)
3       If Len(F(I)) > 4 Then
            Dim S As String
4           S = Prefix(F(I), ".queue")
5           Buf = Buf & S & ", "
6           If Len(Buf) > 50 Then
7               CS.Reply "Queues: " & Left$(Buf, Len(Buf) - 2)
8               Buf = vbNS
9               E = True
            End If
        End If
    Next I
10  If Len(Buf) > 0 Then
11      CS.Reply "Queues: " & Left$(Buf, Len(Buf) - 2)
12      Buf = vbNS
        E = True
    End If
    If Not E Then
13      CS.Reply "No queues are installed (default of 5000ms will be used)."
    End If
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "cmdQueues"
End Sub
Public Sub cmdQueue(CS As objCmdSet)
On Error GoTo hErr:
    With CS.Bot
        CS.Reply "Queue: " & .Config.Queue
    End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "cmdQueue"
End Sub
Public Sub cmdSetQueue(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.Reply "Please specify a queue to switch to!"
3       Exit Sub
4   End If
    Dim F() As String, I As Integer
5   F = FileList(AppData & "Queues\*.queue")
6   For I = 0 To UBound(F)
7       If Len(F(I)) > 4 Then
            Dim S As String
8           S = Prefix(F(I), ".queue")
9           If LCase$(CS.Message) = LCase$(S) Then
10              With CS.Bot
11                  .Config.Queue = S
13                  CS.Reply "Queue changed to: " & S
                    Exit Sub
                End With
            End If
        End If
    Next I
14  With CS.Bot
15      .Config.Queue = "Basic"
17      CS.Reply "Queue reverted to: Basic"
    End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "cmdSetQueue"
End Sub

'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' DATABASE RELATED
'///////////////////////////////////////////////////////////////////////////////
Public Sub cmdDatabase(CS As objCmdSet)
    Dim I As Integer, C As Integer, Buf As String, S As Boolean, RS As Boolean, DBT As Integer
    C = UBound(Ranking)
    For I = 0 To C
        If LenB(Ranking(I).RankName) > 0 Then
            Dim DBC As Integer
            DBC = CS.Bot.Database.CountRanked(Ranking(I).RankName)
            DBT = DBT + DBC
            Buf = Buf & Ranking(I).RankName & "/" & Ranking(I).Alias & " (" & DBC & "), "
        End If
        If Len(Buf) >= 150 Then
            CS.Reply IIf(RS, vbNS, "Database: ") & Left$(Buf, Len(Buf) - 2) & IIf(I = C, ".", ", ...")
            RS = True
            Buf = vbNS
            S = True
        End If
    Next I
    If Len(Buf) > 0 Then
        CS.Reply IIf(RS, vbNS, "Database: ") & Left$(Buf, Len(Buf) - 2) & "."
        Buf = vbNS
        S = True
    End If
    If DBT > 0 Then CS.Reply "There are a total of " & DBT & " users belonging to " & UBound(Ranking) + 1 & " ranks."
    If Not S Then CS.Reply "Error: no ranks found!"
End Sub
Public Sub cmdList(CS As objCmdSet)
On Error GoTo hErr:
    If modRanks.RankingExists(CS.Message) Then
        With CS.Bot.Database
            Dim U As objDbUser, RI As Integer
            Dim r() As String, I As Integer, RankUser As String, RankCount As Integer, RankSent As Boolean
            r = .GetRanked(CS.Message)
            If UBound(r) > 0 Then
                CS.Reply UBound(r) + 1 & " users found with rank " & vbQuote & GetRankByID(GetIDByRank(CS.Message)).RankName & vbQuote & ":"
                For I = 0 To UBound(r)
                    If LenB(r(I)) Then
                        RankCount = RankCount + 1
                        Set U = Nothing
                        If InStr(r(I), "*") Then
                            RI = .FindPattern(r(I))
                            If RI > -1 Then
                                Set U = .GetUser(RI)
                            Else
                                RI = .Find(r(I))
                                If RI > -1 Then Set U = .GetUser(RI)
                            End If
                        Else
                            RI = .Find(r(I))
                            If RI > -1 Then Set U = .GetUser(RI)
                        End If
                        If Not U Is Nothing Then
                            RankUser = RankUser & U.Username & ", "
                        End If
                        If LenB(RankUser) > 150 Then
                            CS.Reply Left$(RankUser, Len(RankUser) - 2) & IIf(I = UBound(r), ".", ", ...")
                            RankCount = 0
                            RankUser = vbNS
                            RankSent = True
                        End If
                    End If
                Next
17              If RankCount > 0 Then
18                  CS.Reply Left$(RankUser, Len(RankUser) - 2) & "."
19                  RankCount = 0
20                  RankUser = vbNS
21              End If
            Else
                If LenB(r(0)) = 0 Then
                    CS.Reply "No users belong to the rank " & vbQuote & GetRankByID(GetIDByRank(CS.Message)).RankName & vbQuote & "!"
                Else
                    Set U = Nothing
                    If InStr(r(0), "*") Then
                        RI = .FindPattern(r(0))
                        If RI > -1 Then
                            Set U = .GetUser(RI)
                        Else
                            RI = .Find(r(0))
                            If RI > -1 Then Set U = .GetUser(RI)
                        End If
                    Else
                        RI = .Find(r(0))
                        If RI > -1 Then Set U = .GetUser(RI)
                    End If
                    If Not U Is Nothing Then
                        CS.Reply U.Username & "=>" & U.Rank & " (added by " & U.AddBy & " at " & U.AddTime & " on " & U.AddDate & ")"
                    End If
                End If
            End If
        End With
    Else
        CS.Reply "That is not a valid rank."
    End If
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Commands", "List"
End Sub
Public Sub cmdFind(CS As objCmdSet)
On Error GoTo hErr:
    If InStrB(CS.Message, Space$(1)) <> 0 Or LenB(CS.Message) = 0 Then
        CS.Reply "Please specify a user or pattern to lookup!"
        Exit Sub
    End If
0   With CS.Bot
1       Dim U As New objDbUser, Match() As Integer, mF As Integer, MatchText As String, MatchCount As Long, LookupSent As Boolean, PF As Integer
        PF = .Database.FindPattern(CS.Message)
        If PF > -1 Then
            Set U = .Database.GetUser(PF)
            CS.Reply U.Username & "=>" & GetRankByID(U.RankID).RankName & " (added by " & U.AddBy & " at " & U.AddTime & " on " & U.AddDate & ")"
            Exit Sub
        End If
2       If .Database.MatchUser(CS.Message, Match) Then
3           If UBound(Match) > 0 Then
4               CS.Reply UBound(Match) + 1 & " users found matching " & vbQuote & CS.Message & vbQuote & ":"
5               For mF = 0 To UBound(Match)
6                   MatchCount = MatchCount + 1
7                   With .Database.GetUser(Match(mF))
8                       MatchText = MatchText & .Username & " (" & GetRankByID(.RankID).Alias & "), "
9                   End With
10                  If Len(MatchText) > 150 Then
11                      CS.Reply Left$(MatchText, Len(MatchText) - 2) & IIf(mF = UBound(Match), ".", ", ...")
12                      MatchCount = 0
13                      MatchText = vbNS
14                      LookupSent = True
15                  End If
16              Next
17              If MatchCount > 0 Then
18                  CS.Reply Left$(MatchText, Len(MatchText) - 2) & "."
19                  MatchCount = 0
20                  MatchText = vbNS
21              End If
22          ElseIf UBound(Match) = 0 Then
24              Set U = .Database.GetUser(Match(mF))
25              CS.Reply U.Username & "=>" & GetRankByID(U.RankID).RankName & " (added by " & U.AddBy & " at " & U.AddTime & " on " & U.AddDate & ")"
26          End If
27      Else
28          CS.Reply "No users matched criteria!"
29      End If
30  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Find"
End Sub
Public Sub cmdAdd(CS As objCmdSet)
On Error GoTo hErr:
    Dim r As RankingStruct
    r = GetAccess(CS)
    If InStrB(CS.Message, " ") = 0 Or LenB(CS.Message) = 0 Then
        CS.ReplyEvent "Please specify a user and rank to add someone to the database!", &HB2
        Exit Sub
    End If
1   Dim S() As String: S = Split(CS.Message, Space$(1))
2   Dim AddRank As RankingStruct: AddRank = GetRanking(S(1))
3   Dim RetVal As String
5   With CS.Bot
6       If AddRank.UserGroup And LenB(AddRank.RankName) <> 0 Then
7           If AddRank.PatternMatch Then
8               If CS.IsConsole Or RankManaged(r, AddRank) Then
18                  If .Database.Add(S(0), AddRank.RankName, , , CS.Username, RetVal) Then
                        CS.ReplyEvent "Added user '" & S(0) & _
                            "' to " & AddRank.RankName & " rank!", &HB1
                        .CheckChannel
                    Else
                        CS.Reply RetVal
                    End If
20              Else
21                  CS.ReplyEvent "Your rank is not capable of adding users to " & AddRank.RankName & " rank!", &HB2
22              End If
23          Else
24              If CS.IsConsole Or RankManaged(r, AddRank) Then
25                  Dim I As Integer, Added As Boolean, Buffer As String, Conflict As Integer, Sent As Boolean, Users() As String
26                  Users = .Users.Match(S(0))
27                  Added = False
28                  For I = 0 To UBound(Users)
29                      If .Database.Add(Users(I), AddRank.RankName, , , CS.Username, RetVal) Then
30                          If LenB(Users(I)) > 0 Then
31                              Buffer = Buffer & Users(I) & ", "
32                              Added = True
33                          End If
34                      Else
35                          Conflict = Conflict + 1
36                      End If
37                      If Len(Buffer) > 150 Then
38                          If Not Sent Then
39                              CS.ReplyEvent "Added users to " & AddRank.RankName & " rank: " & _
                                    Left$(Buffer, Len(Buffer) - 2) & IIf(I < UBound(Users), ", ...", "."), &HB1
41                              Sent = True
42                          Else
43                              CS.ReplyEvent AddRank.RankName & ": " & _
                                    Left$(Buffer, Len(Buffer) - 2) & IIf(I < UBound(Users), ", ...", "."), &HB1
45                          End If
46                          Buffer = vbNS
47                      End If
48                  Next I
49                  If Added Then
50                      If Len(Buffer) > 3 Then
51                          If Not Sent Then
52                              CS.ReplyEvent "Added users to " & AddRank.RankName & " rank: " & _
                                    Left$(Buffer, Len(Buffer) - 2) & ".", &HB1
54                              Sent = True
55                          Else
56                              CS.ReplyEvent AddRank.RankName & ": " & _
                                    Left$(Buffer, Len(Buffer) - 2) & ".", &HB1
58                          End If
59                          Buffer = vbNS
60                      End If
61                      If Conflict > 0 Then
62                          CS.ReplyEvent "Conflicts encountered: " & Conflict, &HB2
63                      End If
64                  Else
65                      If InStrB(S(0), "*") = 0 Then
66                          If .Database.Add(S(0), AddRank.RankName, , , CS.Username, RetVal) Then
67                                  CS.ReplyEvent "Added user " & S(0) & _
                                        " to " & AddRank.RankName & " rank!", &HB1
69                                  .CheckChannel
70                          Else
71                              CS.ReplyEvent RetVal, &HB2
72                          End If
73                      Else
74                          CS.ReplyEvent "This rank only allows exact users to be added!", &HB2
75                      End If
76                  End If
77                  .CheckChannel
78              Else
79                  CS.ReplyEvent "Your rank is not capable of adding users to " & AddRank.RankName & " rank!", &HB2
80              End If
81          End If
82      Else
83          CS.ReplyEvent "Invalid rank name!", &HB2
84      End If
85  End With
    If SelBot = CS.Index Then frmBot.RefreshDatabaseList SelBot
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Add"
End Sub
Public Sub cmdDelete(CS As objCmdSet)
On Error GoTo hErr:
    Dim r As RankingStruct
    r = GetRankByID(GetIDByRank("God"))
    If LenB(CS.Message) = 0 Or InStrB(CS.Message, " ") <> 0 Then
        CS.ReplyEvent "Please specify a user to remove from the database!", &HB2
        Exit Sub
    End If
    Dim Remove() As Integer, I As Integer, Buffer As String, RemoveSent As Boolean
    Dim Find As Integer, U As objDbUser
1   With CS.Bot
2       Find = .Database.FindPattern(CS.Message)
3       If Find > -1 Then
4           Set U = .Database.GetUser(Find)
5           If GetRankByID(.Database.GetUser(Find).RankID).PatternMatch Then
6               If CS.IsConsole Or RankManaged(r, GetRankByID(U.RankID)) Then
7                   If .Database.Remove(CS.Message) Then
8                       CS.ReplyEvent "Removed user: " & CS.Message & ".", &HB1
                        If SelBot = CS.Index Then frmBot.RefreshDatabaseList SelBot
9                       Exit Sub
10                  End If
11              Else
12                  CS.Reply "Your rank is unable to remove this user!", &HB2
13              End If
14          Else
15              If CS.IsConsole Or RankManaged(r, GetRankByID(U.RankID)) Then
16                  If .Database.Remove(CS.Message) Then
17                      CS.ReplyEvent "Removed user: " & CS.Message & ".", &HB1
                        If SelBot = CS.Index Then frmBot.RefreshDatabaseList SelBot
18                      Exit Sub
19                  End If
20              Else
21                  CS.ReplyEvent "Your rank is unable to remove this user!", &HB2
22              End If
23          End If
24      End If
25      If .Database.MatchUser(CS.Message, Remove) Then
26          Dim D() As objDbUser
27          ReDim D(UBound(Remove))
28          For I = 0 To UBound(Remove)
29              Set D(I) = .Database.GetUser(Remove(I))
30          Next I
31          For I = 0 To UBound(Remove)
32              Dim RemRank As RankingStruct
33              RemRank = GetRankByID(D(I).RankID)
34              If Not RemRank.PatternMatch Then
35                  If CS.IsConsole Or RankManaged(r, RemRank) Then
36                      If .Database.Remove(D(I).Username) Then
37                          Buffer = Buffer & D(I).Username & ", "
38                      End If
39                  End If
40                  If Len(Buffer) > 150 Then
41                      If RemoveSent Then
42                          CS.ReplyEvent Left$(Buffer, Len(Buffer) - 2) & IIf(I = UBound(Remove), ".", ", ..."), &HB1
43                      Else
44                          CS.ReplyEvent "Removed users: " & Left$(Buffer, Len(Buffer) - 2) & IIf(I = UBound(Remove), ".", ", ..."), &HB1
45                      End If
46                      Buffer = vbNS
47                      RemoveSent = True
48                  End If
49              End If
50          Next
51          ReDim D(0)
52          If Len(Buffer) > 0 Then
53              If RemoveSent Then
54                  CS.ReplyEvent Left$(Buffer, Len(Buffer) - 2) & ".", &HB1
55              Else
56                  CS.ReplyEvent "Removed users: " & Left$(Buffer, Len(Buffer) - 2) & ".", &HB1
57              End If
58              Buffer = vbNS
59              RemoveSent = True
60          End If
            If SelBot = CS.Index Then frmBot.RefreshDatabaseList SelBot
63      End If
64      If Not RemoveSent Then
65          CS.ReplyEvent "No users matched criteria!", &HB2
66      End If
67  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Delete"
End Sub





'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' MODERATION RELATED
'///////////////////////////////////////////////////////////////////////////////
Public Sub cmdBan(CS As objCmdSet, Optional IP As Boolean = False)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.ReplyEvent "Please specify a user to ban!", &HB2
3       Exit Sub
4   End If
5   With CS.Bot
6       Dim banUser As String, banMessage As String, I As Integer
7       If InStrB(CS.Message, Space$(1)) <> 0 Then
8           banUser = Split(CS.Message, Space$(1))(0)
9           banMessage = Space$(1) & Split(CS.Message, Space$(1), 2)(1)
10      Else
11          banUser = CS.Message
12          banMessage = vbNS
13      End If
        
14      'Search Channel
        Dim Found As Boolean
        Found = False
        If InStr(banUser, "*") > 1 Or banUser = "*" Then
15          For I = 0 To .Users.Count
16              Dim U As objUser
17              Set U = .Users.GetByIndex(I)
18              If Matches(U.Account, banUser) Then
                    Found = True
19                  If GetAccess2(U.Username, CS.Index).Safe = False Then
20                      If U.IsBannable Then
                            If IP Then .SendAway "/ignore " & U.Account
                            .SendAway "/ban " & U.Account & banMessage
                        End If
21                  End If
22              End If
23          Next I
        End If
        If Not Found Then
            'Search Database
            banUser = CS.Bot.GetAccount(FixUserExploits(banUser))
            Dim Gate As String
            If Not IsOnGateway(banUser) Then
                If IsOnGateway(CS.Username) And LenB(CS.Username) Then
                    Gate = Mid$(CS.Username, InStrRev(CS.Username, "@") - 1)
                Else
                    Gate = "@" & frmBot.Bot(CS.Index).Config.ServerName
                End If
                banUser = banUser & Gate
            End If
            If InStr(banUser, "@PvPGN") <> 0 Then banUser = Split(banUser, "@PvPGN")(0)
25          If GetAccess2(banUser, CS.Index).Safe Then
26              CS.ReplyEvent "User (" & banUser & ") is in the database with rank " & GetAccess2(banUser, CS.Index).RankName & " (Safe).", &HB2
27          Else
28              If IP Then .SendAway "/ignore " & banUser
32              .SendAway "/ban " & banUser & banMessage
29          End If
30      End If
31  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Ban"
End Sub
Public Sub cmdBanIP(CS As objCmdSet)
    cmdBan CS, True
End Sub
Public Sub cmdDDP(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.ReplyEvent "Please specify a user to designate!", &HB2
3       Exit Sub
4   End If
5   With CS.Bot
6       .PerformDDP CS.Username, CS.Message
7   End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "DDP"
End Sub
Public Sub cmdUnban(CS As objCmdSet, Optional IP As Boolean = False)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.ReplyEvent "Please specify a user to unban!", &HB2
3       Exit Sub
4   End If
5   With CS.Bot
        Dim Gate As String, User As String
6       If InStr(CS.Message, "*") > 1 Or CS.Message = "*" Then
7           Dim Asterisk As Boolean, I As Integer
8           For I = 1 To .BanList.Count
9               If Matches(Suffix(.BanList.Item(I).Username), CS.Message) Then
10                  .SendAway "/unban " & .GetAccount(.BanList.Item(I).Username)
23                  If IP Then .SendAway "/unignore " & .GetAccount(.BanList.Item(I).Username)
11                  Asterisk = True
12              End If
13          Next I
14          If Not Asterisk And .Config.IsDiablo And Left$(CS.Message, 1) = "*" Then
                User = CS.Message
                If Not IsOnGateway(User) Then
                    If IsOnGateway(CS.Username) And LenB(CS.Username) Then
                        Gate = Mid$(CS.Username, InStrRev(CS.Username, "@") - 1)
                    Else
                        Gate = "@" & frmBot.Bot(CS.Index).Config.ServerName
                    End If
                    If InStr(LCase$(Gate), "pvpgn") = 0 Then User = User & Gate
                End If
15              .SendAway "/unban " & User
21              If IP Then .SendAway "/unignore " & User
16          End If
17      Else
            User = CS.Message
            If Not IsOnGateway(User) Then
                If IsOnGateway(CS.Username) And LenB(CS.Username) Then
                    Gate = Mid$(CS.Username, InStrRev(CS.Username, "@") - 1)
                Else
                    Gate = "@" & frmBot.Bot(CS.Index).Config.ServerName
                End If
                If InStr(LCase$(Gate), "pvpgn") = 0 Then User = User & Gate
            End If
18          .SendAway "/unban " & User
22          If IP Then .SendAway "/unignore " & User
19      End If
20  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Unban"
End Sub
Public Sub cmdKick(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.ReplyEvent "Please specify a user to kick!", &HB2
3       Exit Sub
4   End If
5   With CS.Bot
6       Dim KickUser As String, KickMessage As String, I As Integer
7       If InStrB(CS.Message, Space$(1)) <> 0 Then
8           KickUser = Split(CS.Message, Space$(1))(0)
9           KickMessage = Space$(1) & Split(CS.Message, Space$(1), 2)(1)
10      Else
11          KickUser = CS.Message
12          KickMessage = vbNS
13      End If
14
        Dim Found As Boolean
        Found = False
15      If InStr(KickUser, "*") > 1 Or KickUser = "*" Then
16          For I = 0 To .Users.Count
17              Dim U As objUser
18              Set U = .Users.GetByIndex(I)
19              If Matches(U.Account, KickUser) Then
                    Found = True
20                  If GetAccess2(U.Account, CS.Index).Safe = False Then
21                      If U.IsBannable Then .SendAway "/kick " & U.Account & KickMessage
22                  End If
23              End If
24          Next I
        End If
        If Not Found Then
            'Search Database
            KickUser = CS.Bot.GetAccount(FixUserExploits(KickUser))
            Dim Gate As String
            If Not IsOnGateway(KickUser) Then
                If IsOnGateway(CS.Username) And LenB(CS.Username) Then
                    Gate = Mid$(CS.Username, InStrRev(CS.Username, "@") - 1)
                Else
                    Gate = "@" & frmBot.Bot(CS.Index).Config.ServerName
                End If
                KickUser = KickUser & Gate
            End If
            If InStr(KickUser, "@PvPGN") <> 0 Then KickUser = Split(KickUser, "@PvPGN")(0)
26          If GetAccess2(KickUser, CS.Index).Safe Then
27              CS.ReplyEvent "User (" & KickUser & ") is safe!", &HB2
28          Else
29              .SendAway "/kick " & KickUser & KickMessage
30          End If
31      End If
32  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Kick"
End Sub
Public Sub cmdUnignore(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.ReplyEvent "Please specify a user to unignore!", &HB2
3       Exit Sub
4   End If
5   With CS.Bot
6       Dim UnignoreUser As String, I As Integer
7       UnignoreUser = CS.Message
8       If InStrB(UnignoreUser, "*") <> 0 Then
9           Dim UnignoreFound As Boolean
10          For I = 0 To .Users.Count
11              Dim U As objUser
12              Set U = .Users.GetByIndex(I)
13              If Matches(U.Account, UnignoreUser) Then
14                  If (Not U.IsIgnored) Then
15                      .SendAway "/unignore " & U.Account
16                      UnignoreFound = True
17                  End If
18              End If
19          Next I
20          If Not UnignoreFound Then .SendAway "/unignore " & UnignoreUser
21      Else
22          .SendAway "/unignore " & UnignoreUser
23      End If
24  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Unignore"
End Sub
Public Sub cmdIgnore(CS As objCmdSet)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       CS.ReplyEvent ReadINI(AppRes, "Ignore", "1"), &HB2
3       Exit Sub
4   End If
5   With CS.Bot
6       Dim IgnoreUser As String, I As Integer
7       IgnoreUser = CS.Message
8       If InStr(IgnoreUser, "*") > 1 Or IgnoreUser = "*" Then
9           Dim IgnoreFound As Boolean
10          For I = 0 To .Users.Count
11              Dim U As objUser
12              Set U = .Users.GetByIndex(I)
13              If Matches(U.Account, IgnoreUser) Then
14                  If GetAccess2(U.Username, CS.Index).Safe = False Then
15                      If (Not U.IsIgnored) Then
16                          .SendAway "/ignore " & U.Account
17                          IgnoreFound = True
18                      End If
19                  End If
20              End If
21          Next I
22          If Not IgnoreFound Then .SendAway "/ignore " & IgnoreUser
23      Else
24          If GetAccess2(IgnoreUser, CS.Index).Safe Then
26              CS.ReplyEvent "User (" & IgnoreUser & ") is safe!", &HB2
            Else
27              .SendAway "/ignore " & IgnoreUser
28          End If
29      End If
30  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Ignore"
End Sub
Public Sub cmdGetMacro(CS As objCmdSet)
    Dim Content() As String
    Content = GetMacro(CS.Message)
    If UBound(Content) > 0 Or LenB(Content(0)) > 0 Then
        Dim I As Integer
        For I = 0 To UBound(Content)
            CS.Bot.SendAway Content(I)
        Next I
    Else
        CS.ReplyEvent "Macro does not exist!", &HB2
    End If
End Sub
Public Sub cmdStatus(CS As objCmdSet)
    With CS.Bot.Config.Op
        CS.Reply "DodgeBan (" & OnOff(.DodgeBan) & _
                    "), FilterBan (" & OnOff(.FilterBan) & _
                    "), FloodBan (" & OnOff(.FloodBan) & _
                    "), HashBan (" & OnOff(.HashBan) & _
                    "), IPBan (" & OnOff(.IPBan) & _
                    "), LoadBan (" & OnOff(.LoadBan) & _
                    "), LockDown (" & OnOff(.LockDown) & _
                    "), NextBan (" & OnOff(.NextBan) & _
                    ")"
        CS.Reply "OutsiderBan (" & OnOff(.OutsiderBan) & _
                    "), RandomBan (" & OnOff(.RandomBan) & _
                    "), RepeatBan (" & OnOff(.RepeatBan) & _
                    "), SafeUnban (" & OnOff(.SafeUnban) & _
                    "), SilencedBan (" & OnOff(.SilencedBan) & _
                    "), SmartBan (" & OnOff(.SmartBan) & _
                    "), StatBan (" & OnOff(.StatBan) & _
                    ")"
    End With
End Sub
Public Sub cmdFloodBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .FloodBan = True
            CS.ReplyEvent ModString(1, "FloodBan", .FloodBan), &HB1: Exit Sub
        Case "OFF": .FloodBan = False
            CS.ReplyEvent ModString(1, "FloodBan", .FloodBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "FloodBan", .FloodBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "FloodBan"), &HB3
    End With
End Sub
Public Sub cmdLoadBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .LoadBan = True
            CS.ReplyEvent ModString(1, "LoadBan", .LoadBan), &HB1: Exit Sub
        Case "OFF": .LoadBan = False
            CS.ReplyEvent ModString(1, "LoadBan", .LoadBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "LoadBan", .LoadBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "LoadBan"), &HB3
    End With
End Sub
Public Sub cmdIPBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .IPBan = True
            CS.ReplyEvent ModString(1, "IPBan", .IPBan), &HB1: Exit Sub
        Case "OFF": .IPBan = False
            CS.ReplyEvent ModString(1, "IPBan", .IPBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "IPBan", .IPBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "IPBan"), &HB3
    End With
End Sub
Public Sub cmdSmartBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .SmartBan = True
            CS.ReplyEvent ModString(1, "SmartBan", .SmartBan), &HB1: Exit Sub
        Case "OFF": .SmartBan = False
            CS.ReplyEvent ModString(1, "SmartBan", .SmartBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "SmartBan", .SmartBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "SmartBan"), &HB3
    End With
End Sub
Public Sub cmdDodgeBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .DodgeBan = True
            CS.ReplyEvent ModString(1, "DodgeBan", .DodgeBan), &HB1: Exit Sub
        Case "OFF": .DodgeBan = False
            CS.ReplyEvent ModString(1, "DodgeBan", .DodgeBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "DodgeBan", .DodgeBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "DodgeBan"), &HB3
    End With
End Sub
Public Sub cmdStatBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .StatBan = True
            CS.ReplyEvent ModString(1, "StatBan", .StatBan), &HB1: Exit Sub
        Case "OFF": .StatBan = False
            CS.ReplyEvent ModString(1, "StatBan", .StatBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "StatBan", .StatBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "StatBan"), &HB3
    End With
End Sub
Public Sub cmdNextBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .NextBan = True
            CS.ReplyEvent ModString(1, "NextBan", .NextBan), &HB1: Exit Sub
        Case "OFF": .NextBan = False
            CS.ReplyEvent ModString(1, "NextBan", .NextBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "NextBan", .NextBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "NextBan"), &HB3
    End With
End Sub
Public Sub cmdLockDown(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .LockDown = True
            CS.ReplyEvent ModString(1, "LockDown", .LockDown), &HB1: Exit Sub
        Case "OFF": .LockDown = False
            CS.ReplyEvent ModString(1, "LockDown", .LockDown), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "LockDown", .LockDown), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "LockDown"), &HB3
    End With
End Sub
Public Sub cmdHashBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .HashBan = True
            CS.ReplyEvent ModString(1, "HashBan", .HashBan), &HB1: Exit Sub
        Case "OFF": .HashBan = False
            CS.ReplyEvent ModString(1, "HashBan", .HashBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "HashBan", .HashBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "HashBan"), &HB3
    End With
End Sub
Public Sub cmdClanBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .ClanBan = True
            CS.ReplyEvent ModString(1, "ClanBan", .ClanBan), &HB1: Exit Sub
        Case "OFF": .ClanBan = False
            CS.ReplyEvent ModString(1, "ClanBan", .ClanBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "ClanBan", .ClanBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "ClanBan"), &HB3
    End With
End Sub
Public Sub cmdSilencedBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .SilencedBan = True
            CS.ReplyEvent ModString(1, "SilencedBan", .SilencedBan), &HB1: Exit Sub
        Case "OFF": .SilencedBan = False
            CS.ReplyEvent ModString(1, "SilencedBan", .SilencedBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "SilencedBan", .SilencedBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "SilencedBan"), &HB3
    End With
End Sub
Public Sub cmdFilterBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .FilterBan = True
            CS.ReplyEvent ModString(1, "FilterBan", .FilterBan), &HB1: Exit Sub
        Case "OFF": .FilterBan = False
            CS.ReplyEvent ModString(1, "FilterBan", .FilterBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "FilterBan", .FilterBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "FilterBan"), &HB3
    End With
End Sub
Public Sub cmdOutsiderBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .OutsiderBan = True
            CS.ReplyEvent ModString(1, "OutsiderBan", .OutsiderBan), &HB1: Exit Sub
        Case "OFF": .OutsiderBan = False
            CS.ReplyEvent ModString(1, "OutsiderBan", .OutsiderBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "OutsiderBan", .OutsiderBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "OutsiderBan"), &HB3
    End With
End Sub
Public Sub cmdRandomBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .RandomBan = True
            CS.ReplyEvent ModString(1, "RandomBan", .RandomBan), &HB1: Exit Sub
        Case "OFF": .RandomBan = False
            CS.ReplyEvent ModString(1, "RandomBan", .RandomBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "RandomBan", .RandomBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "RandomBan"), &HB3
    End With
End Sub
Public Sub cmdRepeatBan(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .RepeatBan = True
            CS.ReplyEvent ModString(1, "RepeatBan", .RepeatBan), &HB1: Exit Sub
        Case "OFF": .RepeatBan = False
            CS.ReplyEvent ModString(1, "RepeatBan", .RepeatBan), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "RepeatBan", .RepeatBan), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "RepeatBan"), &HB3
    End With
End Sub
Public Sub cmdSafeUnban(CS As objCmdSet)
    With CS.Bot.Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .SafeUnban = True
            CS.ReplyEvent ModString(1, "SafeUnban", .SafeUnban), &HB1: Exit Sub
        Case "OFF": .SafeUnban = False
            CS.ReplyEvent ModString(1, "SafeUnban", .SafeUnban), &HB1: Exit Sub
        Case "?"
            CS.ReplyEvent ModString(2, "SafeUnban", .SafeUnban), &HB0: Exit Sub
        End Select
        CS.ReplyEvent ModString(3, "SafeUnban"), &HB3
    End With
End Sub
Public Sub cmdHome(CS As objCmdSet)
    CS.Bot.SendText "/join " & CS.Bot.Config.Channel
End Sub
Public Sub cmdVersion(CS As objCmdSet)
    CS.Reply frmBot.Title(False) & " by Chriso (www.BnetDev.net)"
End Sub
Public Sub cmdBuild(CS As objCmdSet)
    CS.Reply frmBot.Title(False) & " [build: " & AppBuild & "]"
End Sub
Public Sub cmdDesignate(CS As objCmdSet)
    CS.Bot.SendAway "/designate " & CS.Bot.GetAccount(CS.Message)
End Sub
Public Sub cmdProfile(CS As objCmdSet)
    Dim User As String, Client As String
    If LenB(CS.Message) = 0 Then
        User = CS.Bot.Self.Username
    Else
        If InStr(CS.Message, " ") Then
            User = Suffix(Prefix(CS.Message, " "))
            Client = Suffix(CS.Message, " ")
        Else
            User = Suffix(Trim$(CS.Message))
        End If
    End If
    CS.Bot.ProfileLookup User, Len(CS.Username), Client
End Sub
Public Sub cmdAddMail(CS As objCmdSet)
    Dim User As String, Mess As String
    If InStr(CS.Message, " ") Then
        User = Split(CS.Message, " ")(0)
        Mess = Split(CS.Message, " ", 2)(1)
        CS.Bot.Mail.AddMail CS.Username, User, Mess
        CS.Bot.Mail.SaveMail
        CS.Reply "Added mail for '" & User & "'."
    Else
        CS.Reply "Cannot add mail, no message specified."
    End If
End Sub
Public Sub cmdDeleteMail(CS As objCmdSet)
    If Len(CS.Message) = 0 Then
        CS.Reply "Cannot remove mail you have added, no user specified."
    Else
        Dim M As Integer
        M = CS.Bot.Mail.RemoveMail(CS.Username, CS.Message)
        If M = 0 Then
            CS.Reply "No mail has been added for that for '" & CS.Message & "'."
        Else
            CS.Reply "Removed " & M & " mail messages for '" & CS.Message & "'."
        End If
    End If
End Sub
Public Sub cmdMailBox(CS As objCmdSet)
    CS.Reply "There are " & CS.Bot.Mail.CountAllMail & " items for " & CS.Bot.Mail.CountAllMailUsers & " users in the mailbox."
End Sub
Public Sub cmdEncrypt(CS As objCmdSet)
On Error GoTo hErr:
1   Dim EncStr As String, ToEncode As String, MaxLen As Integer
    Select Case options.Encryption
    Case 1: MaxLen = 99
    Case 2: MaxLen = 100
    Case Else: MaxLen = 200
    End Select
8   EncStr = CS.Message
9   Do Until Len(EncStr) = 0
10      If Len(EncStr) > MaxLen Then
11          ToEncode = Left(EncStr, MaxLen)
12          EncStr = Mid(EncStr, MaxLen + 1)
13      Else
14          ToEncode = EncStr
15          EncStr = vbNS
16      End If
17      CS.Bot.SendText Encrypt(ToEncode)
18  Loop
Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "CommandHandler", "cmdEncrypt"
End Sub
Public Sub cmdDecrypt(CS As objCmdSet)
    Dim enc As String, Dec As String
    Dec = Decrypt(CS.Message, enc)
    CS.Bot.SendText "(" & enc & ") " & Dec
End Sub
Public Sub cmdCP(CS As objCmdSet)
    If Val(CS.Message) = 1 Then
        CS.Bot.SendAway "/clan private"
        CS.Reply "Channel set to private, only clan members can enter!"
    Else
        CS.Bot.SendAway "/clan public"
        CS.Reply "Channel set to public, all users can enter!"
    End If
End Sub
Public Sub cmdLastWhisper(CS As objCmdSet)
    If LenB(CS.Bot.Self.UserRE) = 0 Then
        CS.ReplyEvent "No one has whispered me yet!", &HB2
    Else
        CS.Reply "Last whisper received from: " & CS.Bot.Self.UserRE
    End If
End Sub
Public Sub cmdNudgeSweep(CS As objCmdSet)
    CS.Bot.SendAway "/nudgesweep " & CS.Message
End Sub
Public Sub cmdBanCount(CS As objCmdSet)
    CS.Reply "Number of banned users: " & CS.Bot.BanList.Count
End Sub
Public Sub cmdCheckChannel(CS As objCmdSet)
    CS.Bot.CheckChannel
End Sub
Public Sub cmdWhois(CS As objCmdSet)
    CS.Bot.SendAway "/whois " & CS.Bot.GetAccount(CS.Message)
End Sub
Public Sub cmdAccess(CS As objCmdSet)
    Dim DB As Integer
    DB = CS.Bot.Database.Find(CS.Username)
    If DB > -1 Then
        Dim DBU As objDbUser
        Set DBU = CS.Bot.Database.GetUser(DB)
        CS.Reply DBU.Username & "=>" & DBU.Rank & _
                    " (added by " & DBU.AddBy & " at " & _
                    DBU.AddTime & " on " & DBU.AddDate & ")"
    End If
End Sub
Public Sub cmdSetAuto(CS As objCmdSet)
    If InStrB(CS.Message, " ") Then
        Dim S() As String
        S = Split(CS.Message, " ", 2)
        If RankingExists(S(1)) Or LCase$(S(1)) = "none" Then
            Dim r As String, t As String
            If LCase$(S(1)) = "none" Then
                r = vbNS
                t = "none."
            Else
                r = GetRanking(S(1)).RankName
                t = r & "."
            End If
            Select Case LCase$(S(0))
            Case "chieftain", "c"
                CS.Bot.Config.ARChieftain = r
                CS.Reply "Changed chieftain auto-rank to " & t
            Case "shaman", "s"
                CS.Bot.Config.ARShaman = r
                CS.Reply "Changed shaman auto-rank to " & t
            Case "grunt", "g"
                CS.Bot.Config.ARGrunt = r
                CS.Reply "Changed grunt auto-rank to " & t
            Case "peon", "p"
                CS.Bot.Config.ARPeon = r
                CS.Reply "Changed peon auto-rank to " & t
            Case "initiate", "i"
                CS.Bot.Config.ARInitiate = r
                CS.Reply "Changed initiate auto-rank to " & t
            Case "friend", "f"
                CS.Bot.Config.ARFriend = r
                CS.Reply "Changed friend auto-rank to " & t
            Case "unclanned", "u"
                CS.Bot.Config.ARUnclan = r
                CS.Reply "Changed unclanned user auto-rank to " & t
            End Select
        End If
    End If
End Sub
Public Sub cmdGiveOp(CS As objCmdSet)
    If CS.Bot.Self.IsOperator Then
        CS.Bot.SendAway "/designate " & CS.Message
        CS.Bot.SendAway "/resign"
    Else
        CS.ReplyEvent "I am not a channel operator!", &HB2
    End If
End Sub
Public Sub cmdSweep(CS As objCmdSet)
    If CS.Bot.Self.IsOperator Then
        CS.Bot.SendAway "/sweep " & CS.Message
    Else
        CS.ReplyEvent "I am not a channel operator!", &HB2
    End If
End Sub
Public Sub cmdIPSweep(CS As objCmdSet)
    If CS.Bot.Self.IsOperator Then
        CS.Bot.SendAway "/ipsweep " & CS.Message
    Else
        CS.ReplyEvent "I am not a channel operator!", &HB2
    End If
End Sub
Public Sub cmdClearQueue(CS As objCmdSet)
    ShareQ.QClear CS.Index
    Output frmBot.rtbChat(CS.Index), &HB1, , "Queue cleared!"
End Sub
Public Sub cmdUptime(CS As objCmdSet)
    CS.Reply "Uptime [System: " & DateTimeToShortestString(ConvertTickCount(DblTickCount())) & "], [Bot: " & DateTimeToShortestString(ConvertTickCount(DblTickCount() - TickLaunch)) & "], [Connection: " & DateTimeToShortestString(ConvertTickCount(DblTickCount() - CS.Bot.Self.TickOnline)) & "]"
End Sub
Public Sub cmdTime(CS As objCmdSet)
    CS.Reply "System Time: " & Time & " on " & Date & " (" & GetTimeZoneName & ", " & GetCurrentTimeBias & ")"
    If CS.IsConsole Then CS.Bot.SendAway "/time"
End Sub
Public Sub cmdDate(CS As objCmdSet)
    Dim SF As String
    Select Case Val(Right$(Day(Date), 1))
        Case 1:    SF = Day(Date) & "st"
        Case 2:    SF = Day(Date) & "nd"
        Case 3:    SF = Day(Date) & "rd"
        Case Else: SF = Day(Date) & "th"
    End Select
    CS.Reply "System Date: " & WeekdayName(Weekday(Date, vbUseSystemDayOfWeek)) & Space$(1) & SF & " of " & MonthName(Month(Date)) & Space$(1) & Year(Date) & " (week " & DatePart("ww", Date, vbUseSystemDayOfWeek, vbUseSystem) & ")"
End Sub
Public Sub cmdReconnect(CS As objCmdSet)
    CS.Bot.Connect
End Sub
Public Sub cmdQuit(CS As objCmdSet)
    Unload frmBot
    End
End Sub
Public Sub cmdShow(CS As objCmdSet)
    frmBot.Show
    frmBot.WindowState = frmBot.LastWindowState
End Sub
Public Sub cmdHide(CS As objCmdSet)
    frmBot.Hide
    frmBot.WindowState = vbMinimized
End Sub
Public Sub cmdJoin(CS As objCmdSet)
    CS.Bot.SendAway "/join " & CS.Message
End Sub
Public Sub cmdForce(CS As objCmdSet)
    CS.Bot.SendJoinChannel CS.Message, &H2
End Sub
Public Sub cmdFirst(CS As objCmdSet)
    CS.Bot.SendJoinChannel "The Void", &H1
End Sub
Public Sub cmdBackup(CS As objCmdSet)
    If LenB(CS.Bot.Config.BackupChannel) Then CS.Bot.SendText "/join " & CS.Bot.Config.BackupChannel
End Sub
Public Sub cmdLast(CS As objCmdSet)
    If LenB(CS.Bot.Self.PreviousChannel) Then CS.Bot.SendText "/join " & CS.Bot.Self.PreviousChannel
End Sub
Public Sub cmdRejoin(CS As objCmdSet)
    CS.Bot.SendJoinChannel CS.Bot.Self.Channel, &H2
End Sub
Public Sub cmdClanAdd(CS As objCmdSet)
    If Len(CS.Message) <> 0 Then
        If CS.Bot.Config.Op.ClanAdd(CS.Message) Then
            CS.ReplyEvent "Added clan ban: " & RestrictCharacters(CS.Message), &HB1
        Else
            CS.ReplyEvent "Unable to add clan ban (conflict or invalid length).", &HB2
        End If
    Else
        CS.ReplyEvent "Unable to add clan ban (invalid length).", &HB2
    End If
End Sub
Public Sub cmdClanDel(CS As objCmdSet)
    If Len(CS.Message) <> 0 Then
        If CS.Bot.Config.Op.ClanDel(CS.Message) Then
            CS.ReplyEvent "Deleted clan ban: " & RestrictCharacters(CS.Message), &HB1
        Else
            CS.ReplyEvent "Unable to delete clan ban (invalid length or not found).", &HB2
        End If
    Else
        CS.ReplyEvent "Unable to delete clan ban (invalid length).", &HB2
    End If
End Sub
Public Sub cmdClanBans(CS As objCmdSet)
    Dim M As String
    M = CS.Bot.Config.Op.GetClans
    If LenB(M) = 0 Then
        CS.Reply "No clan bans added yet, type " & CS.Bot.Config.Trigger & "clanadd [clan]."
    Else
        CS.Reply "Clan bans: " & M
    End If
End Sub
'I could simply return "Note: Command overlap encountered on command 'say'"
Public Sub cmdTimeBan(CS As objCmdSet)
On Error GoTo hErr:
1   With CS.Bot
2       If InStrB(CS.Message, Space$(1)) <> 0 Then
3           Dim mSplt() As String
4           mSplt = Split(CS.Message, Space$(1))
5           If Not GetAccess2(mSplt(0), CS.Index).Safe And CStr(Val(mSplt(1))) = mSplt(1) Then
6               .SendAway "/ban " & .GetAccount(mSplt(0)) & " TimeBan => " & Val(mSplt(1))
7               Dim mb As New objTimeBan
8               mb.Minutes = Val(mSplt(1))
9               mb.Username = mSplt(0)
10              .TimeBans.Add mb
11          Else
12              CS.ReplyEvent GetRes("timeban", "1"), &HB2
13          End If
14      Else
15          CS.ReplyEvent GetRes("timeban", "2"), &HB2
16      End If
17  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "UBL"
End Sub
Public Sub cmdNudge(CS As objCmdSet)
    With CS.Bot
        If LenB(CS.Message) > 0 Then
            If InStrB(CS.Message, " ") = 0 Then
                .SendAway "/w " & CS.Message & " [NUDGE]"
            End If
        End If
    End With
End Sub
Public Sub cmdNudgeMe(CS As objCmdSet)
    With CS.Bot
        If LenB(CS.Username) = 0 Then
            TryNudge CS.Index, "<Console>"
        Else
            TryNudge CS.Index, CS.Username
        End If
    End With
End Sub
Public Sub cmdUBL(CS As objCmdSet)
On Error GoTo hErr:
1   With CS.Bot
2       If .Self.IsOperator Then
3           If (LenB(.Self.UserUBL) > 0) Then
4               .SendAway "/unban " & .Self.UserUBL
5               .Self.UserUBL = vbNS
6           Else
7               CS.ReplyEvent GetRes("ubl", "1"), &HB2
8           End If
9       Else
10          CS.ReplyEvent GetRes("ubl", "2"), &HB2
11      End If
12  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "UBL"
End Sub



'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' CLAN RELATED
'///////////////////////////////////////////////////////////////////////////////
Public Sub cmdDemote(CS As objCmdSet)
On Error GoTo hErr
1   With CS.Bot
2       If .Clan.InClan Then
3           If .Clan.Rank = crChieftain Or .Clan.Rank = crShaman Then
4               Dim Username As String, DwnAmount As Byte, NewRank As Byte
                DwnAmount = 1
                If InStr(CS.Message, " ") Then
                    Dim S() As String
                    S = Split(CS.Message, " ")
                    If CStr(Val(S(1))) = S(1) Then
                        DwnAmount = CByte(Val(S(1)))
                        Username = S(0)
                    Else
                        Username = S(0)
                    End If
                Else
                    Username = CS.Message
                End If
                If .Clan.IsMember(Username) Then
5                   Dim CR As Byte
6                   CR = CByte(.Clan.GetByName(CS.Message).Rank)
7                   If (CR > CLANRANKENUM.crInitiate) Then
                        If (CR >= crShaman And .Clan.Rank = crShaman) Then
                            CS.ReplyEvent GetRes("depromote", "1", "Demote"), &HB2
                        Else
                            NewRank = CByte(CR - DwnAmount)
                            If NewRank < 1 Then NewRank = 1
8                           .SendClanRankChange CS.Message, NewRank
                        End If
9                   Else
10                      CS.ReplyEvent GetRes("depromote", "1", "Demote"), &HB2
11                  End If
12              Else
13                  CS.ReplyEvent GetRes("depromote", "2"), &HB2
14              End If
15          Else
16              CS.ReplyEvent GetRes("depromote", "3", "Demote"), &HB2
17          End If
18      Else
19          CS.ReplyEvent GetRes("depromote", "4", "Demote"), &HB2
20      End If
    End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "DemoteMember"
End Sub
Public Sub cmdPromote(CS As objCmdSet)
On Error GoTo hErr:
1   With CS.Bot
2       If .Clan.InClan Then
3           If .Clan.Rank = crChieftain Or .Clan.Rank = crShaman Then
                Dim Username As String, UpAmount As Byte, NewRank As Byte
                UpAmount = 1
                If InStr(CS.Message, " ") Then
                    Dim S() As String
                    S = Split(CS.Message, " ")
                    If CStr(Val(S(1))) = S(1) Then
                        UpAmount = CByte(Val(S(1)))
                        Username = S(0)
                    Else
                        Username = S(0)
                    End If
                Else
                    Username = CS.Message
                End If
4               If .Clan.IsMember(Username) Then
5                   Dim CR As Byte
6                   CR = CByte(.Clan.GetByName(CS.Message).Rank)
7                   If (CR > CLANRANKENUM.crInitiate) Then
                        If (CR >= crShaman And .Clan.Rank = crShaman) Then
                            CS.ReplyEvent GetRes("depromote", "1", "Promote"), &HB2
                        Else
                            NewRank = CByte(UpAmount + CR)
                            If NewRank > 3 Then NewRank = 3
8                           .SendClanRankChange CS.Message, NewRank
                        End If
9                   Else
10                      CS.ReplyEvent GetRes("depromote", "1", "Promote"), &HB2
11                  End If
12              Else
13                  CS.ReplyEvent GetRes("depromote", "2"), &HB2
14              End If
15          Else
16              CS.ReplyEvent GetRes("depromote", "3", "Promote"), &HB2
17          End If
18      Else
19          CS.ReplyEvent GetRes("depromote", "4", "Promote"), &HB2
20      End If
21  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "PromoteMember"
End Sub
Public Sub cmdSetChieftain(CS As objCmdSet)
On Error GoTo hErr:
    With CS.Bot
        If LenB(CS.Message) Then
            If .Clan.Rank = crChieftain Then
                .SendClanMemberChieftain CS.Message
                .SendText "Attempting to change chieftain to: " & CS.Message
            End If
        End If
    End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "SetChieftain"
End Sub
Public Sub cmdBoot(CS As objCmdSet)
On Error GoTo hErr:
1   With CS.Bot
2       If .Clan.Rank = crShaman Or .Clan.Rank = crChieftain Then
3           .SendClanMemberRemove CS.Message
4       Else
5           CS.ReplyEvent "Boot requires shaman or chieftain rank!", &HB2
6       End If
7   End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "BootMember"
End Sub
Public Sub cmdMemberInfo(CS As objCmdSet)
    If CS.Bot.Self.IsWarCraft3 Then
        Dim User As String, Tag As String
        If InStrB(CS.Message, " ") Then
            User = Split(CS.Message, " ")(0)
            Tag = Split(CS.Message, " ")(1)
        Else
            User = Trim$(CS.Message)
        End If
        If LenB(User) Then
            CS.Bot.SendClanMemberInfo User, Tag
        End If
    Else
        CS.ReplyEvent "Cannot get memberinfo, I am not on WarCraft III.", &HB2
    End If
End Sub
Public Sub cmdControl(CS As objCmdSet)
On Error GoTo hErr:
1   If InStr(CS.Message, " ") <> 0 Then
        Dim S() As String, F As New FileSystemObject
2       S = Split(CS.Message, " ", 2)
3       If F.FolderExists(AppData & "Profiles\" & S(0)) Then
            If IsProfileLoaded(S(0)) Then
                Dim CC As New objCmdSet
                CC.Index = GetProfileIndex(S(0))
                CC.Username = vbNS
                CC.Display = 0
                If InStrB(S(1), " ") Then
                    CC.Command = Prefix(S(1), " ")
                    CC.Message = Split(S(1), " ", 2)(1)
                Else
                    CC.Command = S(1)
                    CC.Message = vbNS
                End If
                CS.Bot.Commands.RunCommand CC
            Else
                CS.ReplyEvent "Profile " & vbQuote & S(0) & vbQuote & " is not loaded! Use /load [profile].", &HB2
            End If
        Else
8           CS.ReplyEvent "Profile " & vbQuote & S(0) & vbQuote & " does not exist!", &HB2
        End If
    Else
9       CS.ReplyEvent "Syntax incorrect, use: /control [profile] [command].", &HB2
    End If
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Control"
End Sub
Public Sub cmdInvite(CS As objCmdSet)
On Error GoTo hErr:
    If LenB(CS.Message) = 0 Then
        CS.ReplyEvent "Please specify a user to invite!", &HB2
        Exit Sub
    End If
    With CS.Bot
        If .Clan.Rank = crChieftain Or .Clan.Rank = crShaman Then
            .SendClanInvitation CS.Message
            CS.ReplyEvent "Invite sent to " & CS.Message & "...", &HB1
        Else
            CS.ReplyEvent "Invite requires shaman or chieftain rank!", &HB2
        End If
    End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Invite"
End Sub
Public Sub cmdSetMOTD(CS As objCmdSet)
On Error GoTo hErr:
    If LenB(CS.Message) = 0 Then
        CS.ReplyEvent "Please specify a new clan MOTD!", &HB2
        Exit Sub
    End If
    With CS.Bot
        If .Clan.Rank = crChieftain Or .Clan.Rank = crShaman Then
            .SendClanSetMOTD CS.Message
            CS.ReplyEvent "Changed MOTD: " & CS.Message, &HB1
        Else
            CS.ReplyEvent "Changing the MOTD requires shaman or chieftain rank!", &HB2
        End If
    End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "SetMOTD"
End Sub
Public Sub cmdAccept(CS As objCmdSet)
On Error GoTo hErr:
1   With CS.Bot
2       If (DblTickCount() - .Clan.TickInviteResp) > 45000 Then
3           CS.ReplyEvent "No pending clan requests or clan request expired!", &HB2
        Else
4           If .Clan.InviteRespType = 1 Then
5               CS.ReplyEvent "Accepted clan invitation!", &HB1
                .SendClanInvitationResponse True
6           ElseIf .Clan.InviteRespType = 2 Then
7               CS.ReplyEvent "Accepted clan creation invitation!", &HB1
                .SendClanCreateInvite True
            End If
        End If
    End With
    Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Accept"
End Sub
Public Sub cmdDecline(CS As objCmdSet)
On Error GoTo hErr:
1   With CS.Bot
2       If DblTickCount() - .Clan.TickInviteResp > 45000 Then
3           CS.ReplyEvent "No pending clan requests or clan request expired!", &HB2
        Else
4           If .Clan.InviteRespType = 1 Then
5               CS.ReplyEvent "Declined clan invitation!", &HB1
                .SendClanInvitationResponse False
6           ElseIf .Clan.InviteRespType = 2 Then
7               CS.ReplyEvent "Declined clan creation invitation!", &HB1
                .SendClanCreateInvite False
            End If
        End If
    End With
    Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Decline"
End Sub
Public Sub cmdShamans(CS As objCmdSet)
On Error GoTo hErr:
1   With CS.Bot
2       If .Clan.InClan Then
3           Dim I As Integer, Buffer As String, ShamanSent As Boolean
4           For I = 0 To .Clan.Count
5               Dim C As objMember
6               Set C = .Clan.GetByIndex(I)
7               If C.Rank = crShaman Then Buffer = Buffer & C.Username & ", "
10              If LenB(Buffer) >= 70 Then
11                  CS.Reply IIf(ShamanSent, vbNS, "Shamans: ") & Left$(Buffer, Len(Buffer) - 2)
                    Buffer = vbNS
12                  If Not ShamanSent Then ShamanSent = True
13              End If
14          Next I
15          If LenB(Buffer) > 0 Then
16              CS.Reply IIf(ShamanSent, vbNS, "Shamans: ") & Left$(Buffer, Len(Buffer) - 2)
                Buffer = vbNS
17              If Not ShamanSent Then ShamanSent = True
18          End If
19      Else
20          CS.ReplyEvent "You are not a member of a clan!", &HB2
21      End If
22  End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Shamans"
End Sub
Public Sub cmdChieftain(CS As objCmdSet)
On Error GoTo hErr:
    With CS.Bot
        If .Clan.InClan Then
            Dim I As Integer
            For I = 0 To .Clan.Count
                Dim C As objMember
                Set C = .Clan.GetByIndex(I)
                If C.Rank = crChieftain Then CS.Reply "Chieftain: " & C.Username: Exit Sub
            Next I
            CS.ReplyEvent "Error, no chieftain found?!", &HB2
        Else
            CS.ReplyEvent "You are not a member of a clan!", &HB2
        End If
    End With
Exit Sub
hErr:
ErrorHandler Err.Number, Err.Description, Erl, "ManageCommands", "Chieftain"
End Sub




'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' PLUGIN RELATED
'///////////////////////////////////////////////////////////////////////////////
Public Sub cmdLoadPlugin(CS As objCmdSet)
    With CS.Bot
        If IsFile(AppData & "\Plugins\" & CS.Message & ".dll") Then
            CS.Bot.UnloadPlugin CS.Message
            CS.Bot.LoadPlugin CS.Message
            WriteINI .ProfilePath, "Plugins", CS.Message, "1"
            CS.ReplyEvent "Plugin '" & CS.Message & "' is now enabled!", &HB1
        Else
            CS.ReplyEvent "Plugin does not exist!", &HB2
        End If
        .ReloadPluginsScripts
        RefreshPlugins
        If CS.Index = SelBot Then RefreshProfileCommandList
    End With
End Sub
Public Sub cmdUnloadPlugin(CS As objCmdSet)
    With CS.Bot
        If IsFile(AppData & "\Plugins\" & CS.Message & ".dll") Then
            CS.Bot.UnloadPlugin CS.Message
            WriteINI .ProfilePath, "Plugins", CS.Message, "0"
            CS.ReplyEvent "Plugin '" & CS.Message & "' is now disabled!", &HB1
        Else
            CS.ReplyEvent "Plugin does not exist!", &HB2
        End If
        .ReloadPluginsScripts
        RefreshPlugins
        If CS.Index = SelBot Then RefreshProfileCommandList
    End With
End Sub
Public Sub cmdCmdHelp(CS As objCmdSet)
On Error GoTo hErr:
    Dim I As Integer, Pool() As Object
    Pool = CS.Bot.Commands.GetPool
1   For I = 0 To UBound(Pool)
2       With Pool(I)
3           If LCase$(.Cmd) = LCase$(CS.Message) Or LCase$(.Alias) = LCase$(CS.Message) Then
4               CS.Reply "Command: " & .Cmd & IIf(LenB(.Alias), "/" & .Alias, vbNS) & _
                    IIf(LenB(.Parameters), " (" & .Parameters & ")", vbNS) & _
                    IIf(CommandRank(.Cmd) = "<Unranked>", ", <Unranked>", ", Rank: " & CommandRank(.Cmd)) & _
                    IIf(.Use = 1, " (Internal Only)", vbNS) & _
                    IIf(.Use = 2, " (External Only)", vbNS) & " -- " & .Help
                Exit Sub
            End If
        End With
    Next I
5   CS.ReplyEvent "Command: " & CS.Message & " does not exist!", &HB2
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "CommandHandler", "CmdHelp"
End Sub



'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' SCRIPT RELATED
'///////////////////////////////////////////////////////////////////////////////
Public Sub cmdLoadScript(CS As objCmdSet)
    With CS.Bot
        Dim FSO As New FileSystemObject
        If FSO.FileExists(AppData & "Scripts\" & CS.Message & ".txt") Then
            UnloadScript CS.Message
            LoadScript CS.Message
            CS.ReplyEvent "Script '" & CS.Message & "' is now enabled!", &HB1
        Else
            CS.ReplyEvent "Script does not exist!", &HB2
        End If
        .ReloadPluginsScripts
        RefreshScripts
        If CS.Index = SelBot Then RefreshProfileCommandList
    End With
End Sub
Public Sub cmdUnloadScript(CS As objCmdSet)
    With CS.Bot
        Dim FSO As New FileSystemObject
        If FSO.FileExists(AppData & "Scripts\" & CS.Message & ".txt") Then
            UnloadScript CS.Message
            CS.ReplyEvent "Script '" & CS.Message & "' is now disabled!", &HB1
        Else
            CS.ReplyEvent "Script does not exist!", &HB2
        End If
        .ReloadPluginsScripts
        RefreshScripts
        If CS.Index = SelBot Then RefreshProfileCommandList
    End With
End Sub

'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' CONSOLE ONLY
'///////////////////////////////////////////////////////////////////////////////
Public Sub cmdFilterGame(CS As objCmdSet)
    With CS.Bot
        If LenB(CS.Message) > 0 Then
            If LCase$(Suffix(CS.Message)) <> LCase$(.Self.Username) Then
                .SendAway "/w " & .GetAccount(CS.Message) & " $_begin"
            Else
                Output frmBot.rtbChat(CS.Index), &HB2, , "Trying to play with yourself? Sad..."
            End If
        End If
    End With
End Sub

