Attribute VB_Name = "modTime"
Option Explicit

Private Declare Function QueryPerformanceCounter Lib "kernel32" (lpPerformanceCount As Currency) As Long
Private Declare Function QueryPerformanceFrequency Lib "kernel32" (lpFrequency As Currency) As Long
Public Declare Function GetTickCount Lib "kernel32" () As Long
Public Declare Function FileTimeToSystemTime Lib "kernel32" (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME) As Boolean
Public Declare Function FileTimeToLocalFileTime Lib "kernel32" (lpFileTime As FILETIME, lpLocalFileTime As FILETIME) As Long

Public Function CurrentTime() As String
    If frmBot.mnuMilitaryTimestamps.Checked Then
        CurrentTime = Format(Time, "hh:mm:ss") & " | "
    Else
        CurrentTime = Format(Time, "hh:mm:ss ampm") & " | "
    End If
End Function

Public Function ProcessTimeLogged(T As Long) As String
    Dim Days As Long, Hours As Long, Minutes As Long
    If T = 0 Then
        ProcessTimeLogged = "Unavailable"
    Else
        Days = T / 86400
        T = T Mod 86400
        Hours = T / 3600
        T = T Mod 3600
        Minutes = T / 60
        T = T Mod 60
        ProcessTimeLogged = Days & " days, " & Hours & " hours, " & Minutes & " minutes."
    End If
End Function

Public Function StringToFiletime(T As String) As FILETIME
    Dim Frag() As String, FT As FILETIME
    Frag = Split(T, " ")
    If (Val(Frag(0)) < 2 ^ 31) Then
        FT.dwHighDateTime = Val(Frag(0))
    Else
        FT.dwHighDateTime = Val(Frag(0)) - 2147483648# '2 ^ 32
    End If
    If UBound(Frag) > 0 Then
        If (Val(Frag(0)) < 2 ^ 31) And (Val(Frag(0)) > 0) Then
            FT.dwLowDateTime = Val(Frag(0))
            FT.dwLowDateTime = FT.dwLowDateTime - 2147483648# '2 ^ 32
        Else
            FT.dwLowDateTime = Val(Frag(0))
        End If
    End If
    StringToFiletime = FT
End Function

Public Function ProcessSystemTime(T As SYSTEMTIME) As String
    On Error Resume Next
   ProcessSystemTime = WeekdayName(T.wDayOfWeek + 1, True) & ", " & MonthName(T.wMonth, True) & " " & T.wDay & ", " & T.wYear & " "
   Dim ap$
   If T.wHour > 12 Then
       T.wHour = T.wHour - 12
       ap = "PM"
   Else
       ap = "AM"
   End If
   ProcessSystemTime = ProcessSystemTime & " " & T.wHour & ":" & Format(T.wMinute, "00") & _
       " " & ap
End Function

Public Function NowTickCount() As Double
    #If Win16 Then
        NowTickCount = CDbl(GetTickCount())
    #Else
        Dim Cou As Currency
        Dim Fre As Currency
        On Error GoTo hErr
        If QueryPerformanceCounter(Cou) And QueryPerformanceFrequency(Fre) Then
            NowTickCount = Int(Cou / Fre * 1000)
        Else
            NowTickCount = LongToUnsigned(GetTickCount)
        End If
    #End If
    Exit Function
hErr:
    NowTickCount = 0
End Function

Private Function LongToUnsigned(value As Long) As Double
    If value < 0 Then
        LongToUnsigned = value + 4294967296#
    Else
        LongToUnsigned = value
    End If
End Function

Public Function DateTimeToShortString(ByRef DT As DATETIME) As String
    Dim buf As String
    If (DT.Weeks) Then buf = DT.Weeks & "w, "
    If (DT.Days) Then buf = buf & DT.Days & "d, "
    If (DT.Hours Or DT.Days) Then buf = buf & DT.Hours & "h, "
    If (DT.Hours Or DT.Days Or DT.Minutes) Then buf = buf & DT.Minutes & "m, "
    buf = buf & DT.Seconds & "s"
    DateTimeToShortString = buf
End Function

Public Function DateTimeToLongString(ByRef DT As DATETIME) As String
    Dim buf As String
    If (DT.Weeks) Then buf = DT.Weeks & IIf(DT.Weeks = 1, " week, ", " weeks, ")
    If (DT.Days) Then buf = buf & DT.Days & IIf(DT.Days = 1, " day, ", " days, ")
    If (DT.Hours Or DT.Days) Then buf = buf & DT.Hours & IIf(DT.Hours = 1, " hour, ", " hours, ")
    If (DT.Hours Or DT.Days Or DT.Minutes) Then buf = buf & DT.Minutes & IIf(DT.Minutes = 1, " minute, ", " minutes, ")
    buf = buf & DT.Seconds & IIf(DT.Seconds = 1, " second", " seconds")
    DateTimeToLongString = buf
End Function

Public Function ConvertTickCount(ByVal TickCount As Double) As DATETIME
    On Error GoTo hErr:
    Dim DT As DATETIME
    TickCount = TickCount / 1000
    DT.Days = Int(TickCount / 86400)
    TickCount = TickCount Mod 86400
    DT.Hours = Int(TickCount / 3600)
    TickCount = TickCount Mod 3600
    DT.Minutes = Int(TickCount / 60)
    TickCount = TickCount Mod 60
    DT.Seconds = TickCount
    DT.Weeks = DT.Days \ 7
    DT.Days = DT.Days Mod 7
    ConvertTickCount = DT
    Exit Function
hErr:
    ConvertTickCount = DT
    ErrorHandler "Time", "ConvertTickCount"
End Function
